
from canaerospace.datatypes import DataType
from canaerospace.units import unit_map as units


def get_flight_state_data_parameters() -> list[dict[str, int | float | str | DataType]]:
    """Flight State / Air Data. CANAS 17 5.1"""
    return [
        # @TODO Change(instead of the literal name of the unit):
        #  grams for weight,
        #  degree_per_second to rotation_per_unit_time
        #
        {"name": "body_long_accel", "can_id": 300,
            "data_type": DataType.FLOAT, "unit": units.get("gravity")},
        {"name": "body_lat_accel", "can_id": 301,
            "data_type": DataType.FLOAT, "unit": units.get("gravity")},
        {"name": "body_norm_accel", "can_id": 302,
            "data_type": DataType.FLOAT, "unit": units.get("gravity")},
        {"name": "body_pitch_rate", "can_id": 303,
            "data_type": DataType.FLOAT, "unit": units.get("degree_per_second")},
        {"name": "body_roll_rate", "can_id": 304, "data_type": DataType.FLOAT,
            "unit": units.get("degree_per_second")},
        {"name": "body_yaw_rate", "can_id": 305, "data_type": DataType.FLOAT,
            "unit": units.get("degree_per_second")},
        {"name": "rudder_position", "can_id": 306,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "stabilizer_position", "can_id": 307,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "elevator_position", "can_id": 308,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "left_aileron_position", "can_id": 309,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "right_aileron_position", "can_id": 310,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "body_pitch_angle", "can_id": 311,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "body_roll_angle", "can_id": 312,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "body_sideslip", "can_id": 313,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "altitude_rate", "can_id": 314, "data_type": DataType.FLOAT,
            "unit": units.get("meter_per_second")},
        {"name": "indicated_airspeed", "can_id": 315,
            "data_type": DataType.FLOAT, "unit": units.get("meter_per_second")},
        {"name": "true_airspeed", "can_id": 316, "data_type": DataType.FLOAT,
            "unit": units.get("meter_per_second")},
        {"name": "calibrated_airspeed", "can_id": 317,
            "data_type": DataType.FLOAT, "unit": units.get("meter_per_second")},
        {"name": "mach_number", "can_id": 318,
            "data_type": DataType.FLOAT, "unit": units.get("mach")},
        {"name": "baro_correction", "can_id": 319,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "baro_corrected_altitude", "can_id": 320,
            "data_type": DataType.FLOAT, "unit": units.get("meter")},
        {"name": "heading_angle", "can_id": 321,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "standard_altitude", "can_id": 322,
            "data_type": DataType.FLOAT, "unit": units.get("meter")},
        {"name": "total_air_temperature", "can_id": 323,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "static_air_temperature", "can_id": 324,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "differential_pressure", "can_id": 325,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "static_pressure", "can_id": 326,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "heading_rate", "can_id": 327, "data_type": DataType.FLOAT,
            "unit": units.get("degree_per_second")},
        {"name": "port_side_angle_of_attack", "can_id": 328,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "starbord_side_angle_of_attack", "can_id": 329,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "density_altitude", "can_id": 330,
            "data_type": DataType.FLOAT, "unit": units.get("meter")},
        {"name": "turn_coordination_rate", "can_id": 331, "data_type": DataType.FLOAT,
         "unit": units.get("degree_per_second")},
        {"name": "true_altitude", "can_id": 332,
            "data_type": DataType.FLOAT, "unit": units.get("meter")},
        {"name": "wind_speed", "can_id": 333, "data_type": DataType.FLOAT,
            "unit": units.get("meter_per_second")},
        {"name": "wind_direction", "can_id": 334,
            "data_type": DataType.FLOAT, "unit": units.get("degree")},
        {"name": "outside_air_temperature", "can_id": 335,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "body_normal_velocity", "can_id": 336, "data_type": DataType.FLOAT,
         "unit": units.get("meter_per_second")},
        {"name": "body_longitudinal_velocity", "can_id": 337, "data_type": DataType.FLOAT,
         "unit": units.get("meter_per_second")},
        {"name": "body_lateral_velocity", "can_id": 338, "data_type": DataType.FLOAT,
         "unit": units.get("meter_per_second")},
        {"name": "total_pressure", "can_id": 339,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
    ]
