from canaerospace.datatypes import DataType
from canaerospace.units import unit_map as units


#  @TODO Replace the norms unit with the correct unit per parameter
def get_navigation_data_parameters():
    """Electric System data 5.7"""
    return [{"name": "active_nav_system_waypoint_latitude", "can_id": 1000, "data_type": DataType.FLOAT,
             "unit": units.get("deg"), },
            {"name": "active_nav_system_waypoint_longitude", "can_id": 1001, "data_type": DataType.FLOAT,
             "unit": units.get("deg"), },
            {"name": "active_nav_system_waypoint_height_above_ellipsoid", "can_id": 1002, "data_type": DataType.FLOAT,
             "unit": units.get("m"), },
            {"name": "active_nav_system_waypoint_altitude", "can_id": 1003, "data_type": DataType.FLOAT,
             "unit": units.get("m"), },
            {"name": "active_nav_system_ground_speed", "can_id": 1004, "data_type": DataType.FLOAT,
             "unit": units.get("m/s"), },
            {"name": "active_nav_system_true_track", "can_id": 1005, "data_type": DataType.FLOAT,
             "unit": units.get("deg"), },
            {"name": "active_nav_system_magnetic_track", "can_id": 1006, "data_type": DataType.FLOAT,
             "unit": units.get("deg"), },
            {"name": "active_nav_system_cross_track_error", "can_id": 1007, "data_type": DataType.FLOAT,
             "unit": units.get("m"), },
            {"name": "active_nav_system_track_error_angle", "can_id": 1008, "data_type": DataType.FLOAT,
             "unit": units.get("deg"), },
            {"name": "active_nav_system_time_to_go", "can_id": 1009, "data_type": DataType.SHORT,
             "unit": units.get("min"), },
            {"name": "active_nav_system_estimated_time_of_arrival", "can_id": 1010, "data_type": DataType.SHORT,
             "unit": units.get("min"), },
            {"name": "active_nav_system_estimated_enroute_time", "can_id": 1011, "data_type": DataType.SHORT,
             "unit": units.get("min"), },
            {"name": "nav_waypoint_identifier_0_3", "can_id": 1012, "data_type": DataType.FLOAT,
            "unit": units.get('norm'), },
            {"name": "nav_waypoint_identifier_4_7", "can_id": 1013, "data_type": DataType.FLOAT,
            "unit": units.get('norm'), },
            {"name": "nav_waypoint_identifier_8_11", "can_id": 1014, "data_type": DataType.FLOAT,
            "unit": units.get('norm'), },
            {"name": "nav_waypoint_identifier_12_15", "can_id": 1015, "data_type": DataType.FLOAT,
            "unit": units.get('norm'), },
            {"name": "nav_waypoint_type_identifier", "can_id": 1016, "data_type": DataType.FLOAT,
            "unit": units.get('norm'), },
            {"name": "nav_waypoint_latitude", "can_id": 1017,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "nav_waypoint_longitude", "can_id": 1018,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "nav_waypoint_minimum_altitude", "can_id": 1019, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_minimum_flight_level", "can_id": 1020, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_minimum_radar_height", "can_id": 1021, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_minimum_height_above_ellipsoid", "can_id": 1022, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_maximum_altitude", "can_id": 1023, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_maximum_flight_level", "can_id": 1024, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_maximum_radar_height", "can_id": 1025, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_maximum_height_above_ellipsoid", "can_id": 1026, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_planned_altitude", "can_id": 1027, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_planned_flight_level", "can_id": 1028, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_planned_radar_height", "can_id": 1029, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "nav_waypoint_planned_height_above_ellipsoid", "can_id": 1030, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "distance_to_nav_waypoint", "can_id": 1031,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "time_to_go_to_nav_waypoint", "can_id": 1032,
            "data_type": DataType.FLOAT, "unit": units.get("min"), },
            {"name": "nav_waypoint_estimated_time_of_arrival", "can_id": 1033, "data_type": DataType.FLOAT,
            "unit": units.get("min"), },
            {"name": "nav_waypoint_estimated_enroute_time", "can_id": 1034, "data_type": DataType.FLOAT,
            "unit": units.get("min"), },
            {"name": "nav_waypoint_status_information", "can_id": 1035, "data_type": DataType.FLOAT,
            "unit": units.get('norm'), },
            {"name": "gps_aircraft_latitude", "can_id": 1036,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "gps_aircraft_longitude", "can_id": 1037,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "gps_aircraft_height_above_ellipsoid", "can_id": 1038, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "gps_ground_speed", "can_id": 1039,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "gps_true_track", "can_id": 1040,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "gps_magnetic_track", "can_id": 1041,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "gps_cross_track_error", "can_id": 1042,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "gps_track_error_angle", "can_id": 1043,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "gps_glideslope_deviation", "can_id": 1044,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "gps_predicted_raim", "can_id": 1045,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "gps_vertical_figure_of_merit", "can_id": 1046,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "gps_horizontal_figure_of_merit", "can_id": 1047, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "gps_mode_of_operation", "can_id": 1048,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "ins_aircraft_latitude", "can_id": 1049,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ins_aircraft_longitude", "can_id": 1050,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ins_aircraft_height_above_ellipsoid", "can_id": 1051, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "ins_aircraft_ground_speed", "can_id": 1052,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "ins_aircraft_true_track", "can_id": 1053,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ins_aircraft_magnetic_track", "can_id": 1054, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "ins_aircraft_cross_track_error", "can_id": 1055, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "ins_aircraft_track_error_angle", "can_id": 1056, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "ins_vertical_figure_of_merit", "can_id": 1057,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "ins_horizontal_figure_of_merit", "can_id": 1058, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "auxiliary_nav_system_aircraft_latitude", "can_id": 1059, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "auxiliary_nav_system_aircraft_longitude", "can_id": 1060, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "auxiliary_nav_system_aircraft_height_above_ellipsoid",
             "can_id": 1061, "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "auxiliary_nav_system_aircraft_ground_speed", "can_id": 1062, "data_type": DataType.FLOAT,
            "unit": units.get("m/s"), },
            {"name": "auxiliary_nav_system_aircraft_true_track", "can_id": 1063, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "auxiliary_nav_system_aircraft_magnetic_track", "can_id": 1064, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "auxiliary_nav_system_aircraft_cross_track_error", "can_id": 1065, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "auxiliary_nav_system_aircraft_track_error_angle", "can_id": 1066, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "auxiliary_nav_system_vertical_figure_of_merit", "can_id": 1067, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "auxiliary_nav_system_horizontal_figure_of_merit", "can_id": 1068, "data_type": DataType.FLOAT,
            "unit": units.get("m"), },
            {"name": "magnetic_heading", "can_id": 1069,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "radio_height", "can_id": 1070,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "dme_1_distance", "can_id": 1071,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "dme_2_distance", "can_id": 1072,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "dme_3_distance", "can_id": 1073,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "dme_4_distance", "can_id": 1074,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "dme_1_time_to_go", "can_id": 1075,
            "data_type": DataType.FLOAT, "unit": units.get("min"), },
            {"name": "dme_2_time_to_go", "can_id": 1076,
            "data_type": DataType.FLOAT, "unit": units.get("min"), },
            {"name": "dme_3_time_to_go", "can_id": 1077,
            "data_type": DataType.FLOAT, "unit": units.get("min"), },
            {"name": "dme_4_time_to_go", "can_id": 1078,
            "data_type": DataType.FLOAT, "unit": units.get("min"), },
            {"name": "dme_1_ground_speed", "can_id": 1079,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "dme_2_ground_speed", "can_id": 1080,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "dme_3_ground_speed", "can_id": 1081,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "dme_4_ground_speed", "can_id": 1082,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "adf_1_bearing", "can_id": 1083,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "adf_2_bearing", "can_id": 1084,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "adf_3_bearing", "can_id": 1085,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "adf_4_bearing", "can_id": 1086,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_1_localize_deviation", "can_id": 1087,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_2_localize_deviation", "can_id": 1088,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_3_localize_deviation", "can_id": 1089,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_4_localize_deviation", "can_id": 1090,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_1_glideslope_deviation", "can_id": 1091,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_2_glideslope_deviation", "can_id": 1092,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_3_glideslope_deviation", "can_id": 1093,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "ils_4_glideslope_deviation", "can_id": 1094,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "flight_director_1_pitch_deviation", "can_id": 1095, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "flight_director_2_pitch_deviation", "can_id": 1096, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "flight_director_1_roll_deviation", "can_id": 1097, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "flight_director_2_roll_deviation", "can_id": 1098, "data_type": DataType.FLOAT,
            "unit": units.get("deg"), },
            {"name": "decision_height", "can_id": 1099,
            "data_type": DataType.FLOAT, "unit": units.get("m"), },
            {"name": "vhf_1_com_frequency", "can_id": 1100,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vhf_2_com_frequency", "can_id": 1101,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vhf_3_com_frequency", "can_id": 1102,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vhf_4_com_frequency", "can_id": 1103,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vor_ils_1_frequency", "can_id": 1104,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vor_ils_2_frequency", "can_id": 1105,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vor_ils_3_frequency", "can_id": 1106,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "vor_ils_4_frequency", "can_id": 1107,
            "data_type": DataType.FLOAT, "unit": units.get("MHz"), },
            {"name": "adf_1_frequency", "can_id": 1108,
            "data_type": DataType.FLOAT, "unit": units.get("kHz"), },
            {"name": "adf_2_frequency", "can_id": 1109,
            "data_type": DataType.FLOAT, "unit": units.get("kHz"), },
            {"name": "adf_3_frequency", "can_id": 1110,
            "data_type": DataType.FLOAT, "unit": units.get("kHz"), },
            {"name": "adf_4_frequency", "can_id": 1111,
            "data_type": DataType.FLOAT, "unit": units.get("kHz"), },
            {"name": "dme_1_channel", "can_id": 1112,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "dme_2_channel", "can_id": 1113,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "dme_3_channel", "can_id": 1114,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "dme_4_channel", "can_id": 1115,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "transponder_1_code", "can_id": 1116,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "transponder_2_code", "can_id": 1117,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "transponder_3_code", "can_id": 1118,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "transponder_4_code", "can_id": 1119,
            "data_type": DataType.FLOAT, "unit": units.get('norm'), },
            {"name": "desired_track_angle", "can_id": 1120,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "magnetic_variation", "can_id": 1121,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "selected_glidepath_angle", "can_id": 1122,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "selected_runway_heading", "can_id": 1123,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "computed_vertical_velocity", "can_id": 1124,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "selected_course", "can_id": 1125,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "vor_1_radial", "can_id": 1126,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "vor_2_radial", "can_id": 1127,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "vor_3_radial", "can_id": 1128,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "vor_4_radial", "can_id": 1129,
            "data_type": DataType.FLOAT, "unit": units.get("deg"), },
            {"name": "true_east_velocity", "can_id": 1130,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "true_north_velocity", "can_id": 1131,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "true_up_velocity", "can_id": 1132,
            "data_type": DataType.FLOAT, "unit": units.get("m/s"), },
            {"name": "true_heading", "can_id": 1133, "data_type": DataType.FLOAT, "unit": units.get("deg"), }, ]
