from canaerospace.datatypes import DataType
from canaerospace.units import unit_map as units


#  @TODO Replace the norms unit with the correct unit per parameter
def get_power_transmission_parameters():
    """Power Transmission 5.4"""
    return [
        {"name": "rotor_1_rpm", "can_id": 700,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "rotor_2_rpm", "can_id": 701,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "rotor_3_rpm", "can_id": 702,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "rotor_4_rpm", "can_id": 703,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},

        {"name": "gearbox_1_speed", "can_id": 704,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_2_speed", "can_id": 705,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_3_speed", "can_id": 706,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_4_speed", "can_id": 707,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_5_speed", "can_id": 708,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_6_speed", "can_id": 709,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_7_speed", "can_id": 710,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},
        {"name": "gearbox_8_speed", "can_id": 711,
            "data_type": DataType.FLOAT, "unit": units.get("rpm")},

        {"name": "gearbox_1_oil_pressure", "can_id": 712,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_2_oil_pressure", "can_id": 713,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_3_oil_pressure", "can_id": 714,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_4_oil_pressure", "can_id": 715,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_5_oil_pressure", "can_id": 716,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_6_oil_pressure", "can_id": 717,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_7_oil_pressure", "can_id": 718,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "gearbox_8_oil_pressure", "can_id": 719,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},

        {"name": "gearbox_1_oil_temperature", "can_id": 720,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_2_oil_temperature", "can_id": 721,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_3_oil_temperature", "can_id": 722,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_4_oil_temperature", "can_id": 723,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_5_oil_temperature", "can_id": 724,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_6_oil_temperature", "can_id": 725,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_7_oil_temperature", "can_id": 726,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "gearbox_8_oil_temperature", "can_id": 727,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},

        {"name": "gearbox_1_oil_quantity", "can_id": 728,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_2_oil_quantity", "can_id": 729,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_3_oil_quantity", "can_id": 730,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_4_oil_quantity", "can_id": 731,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_5_oil_quantity", "can_id": 732,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_6_oil_quantity", "can_id": 733,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_7_oil_quantity", "can_id": 734,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
        {"name": "gearbox_8_oil_quantity", "can_id": 735,
            "data_type": DataType.FLOAT, "unit": units.get("liter")},
    ]
