# Generated by Django 2.1.7 on 2019-03-28 15:08

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('django_capitalist', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Batch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('batch_id', models.CharField(max_length=50, unique=True, verbose_name='batch ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'batch',
                'verbose_name_plural': 'batches',
            },
        ),
        migrations.CreateModel(
            name='BatchRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('state', models.CharField(choices=[('NEW', 'New'), ('READY', 'Ready'), ('INPROCESS', 'In process'), ('DECLINED', 'Declined'), ('PROCESSED', 'Processed')], default='NEW', max_length=20, verbose_name='status')),
                ('data', models.TextField(verbose_name='record data (CSV)')),
                ('internal_id', models.CharField(max_length=255, verbose_name='internal ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('batch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_capitalist.Batch', verbose_name='batch')),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'batch record',
                'verbose_name_plural': 'batch records',
            },
        ),
        migrations.AlterUniqueTogether(
            name='batchrecord',
            unique_together={('batch', 'internal_id')},
        ),
    ]
