#
# Autogenerated by Thrift
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

from thrift.Thrift import *
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(object):
  def login(self, keyspace, auth_request):
    """
    Parameters:
     - keyspace
     - auth_request
    """
    pass

  def get(self, keyspace, key, column_path, consistency_level):
    """
    Get the Column or SuperColumn at the given column_path. If no value is present, NotFoundException is thrown. (This is
    the only method that can throw an exception under non-failure conditions.)

    Parameters:
     - keyspace
     - key
     - column_path
     - consistency_level
    """
    pass

  def get_slice(self, keyspace, key, column_parent, predicate, consistency_level):
    """
    Get the group of columns contained by column_parent (either a ColumnFamily name or a ColumnFamily/SuperColumn name
    pair) specified by the given SlicePredicate. If no matching values are found, an empty list is returned.

    Parameters:
     - keyspace
     - key
     - column_parent
     - predicate
     - consistency_level
    """
    pass

  def multiget(self, keyspace, keys, column_path, consistency_level):
    """
    Perform a get for column_path in parallel on the given list<string> keys. The return value maps keys to the
    ColumnOrSuperColumn found. If no value corresponding to a key is present, the key will still be in the map, but both
    the column and super_column references of the ColumnOrSuperColumn object it maps to will be null.
    @deprecated; use multiget_slice

    Parameters:
     - keyspace
     - keys
     - column_path
     - consistency_level
    """
    pass

  def multiget_slice(self, keyspace, keys, column_parent, predicate, consistency_level):
    """
    Performs a get_slice for column_parent and predicate for the given keys in parallel.

    Parameters:
     - keyspace
     - keys
     - column_parent
     - predicate
     - consistency_level
    """
    pass

  def get_count(self, keyspace, key, column_parent, consistency_level):
    """
    returns the number of columns for a particular <code>key</code> and <code>ColumnFamily</code> or <code>SuperColumn</code>.

    Parameters:
     - keyspace
     - key
     - column_parent
     - consistency_level
    """
    pass

  def get_range_slice(self, keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level):
    """
    returns a subset of columns for a range of keys.
    @Deprecated.  Use get_range_slices instead

    Parameters:
     - keyspace
     - column_parent
     - predicate
     - start_key
     - finish_key
     - row_count
     - consistency_level
    """
    pass

  def get_range_slices(self, keyspace, column_parent, predicate, range, consistency_level):
    """
    returns a subset of columns for a range of keys.

    Parameters:
     - keyspace
     - column_parent
     - predicate
     - range
     - consistency_level
    """
    pass

  def insert(self, keyspace, key, column_path, value, timestamp, consistency_level):
    """
    Insert a Column consisting of (column_path.column, value, timestamp) at the given column_path.column_family and optional
    column_path.super_column. Note that column_path.column is here required, since a SuperColumn cannot directly contain binary
    values -- it can only contain sub-Columns.

    Parameters:
     - keyspace
     - key
     - column_path
     - value
     - timestamp
     - consistency_level
    """
    pass

  def batch_insert(self, keyspace, key, cfmap, consistency_level):
    """
    Insert Columns or SuperColumns across different Column Families for the same row key. batch_mutation is a
    map<string, list<ColumnOrSuperColumn>> -- a map which pairs column family names with the relevant ColumnOrSuperColumn
    objects to insert.
    @deprecated; use batch_mutate instead

    Parameters:
     - keyspace
     - key
     - cfmap
     - consistency_level
    """
    pass

  def remove(self, keyspace, key, column_path, timestamp, consistency_level):
    """
    Remove data from the row specified by key at the granularity specified by column_path, and the given timestamp. Note
    that all the values in column_path besides column_path.column_family are truly optional: you can remove the entire
    row by just specifying the ColumnFamily, or you can remove a SuperColumn or a single Column by specifying those levels too.

    Parameters:
     - keyspace
     - key
     - column_path
     - timestamp
     - consistency_level
    """
    pass

  def batch_mutate(self, keyspace, mutation_map, consistency_level):
    """
      Mutate many columns or super columns for many row keys. See also: Mutation.

      mutation_map maps key to column family to a list of Mutation objects to take place at that scope.
    *

    Parameters:
     - keyspace
     - mutation_map
     - consistency_level
    """
    pass

  def get_string_property(self, property):
    """
    get property whose value is of type string. @Deprecated

    Parameters:
     - property
    """
    pass

  def get_string_list_property(self, property):
    """
    get property whose value is list of strings. @Deprecated

    Parameters:
     - property
    """
    pass

  def describe_keyspaces(self, ):
    """
    list the defined keyspaces in this cluster
    """
    pass

  def describe_cluster_name(self, ):
    """
    get the cluster name
    """
    pass

  def describe_version(self, ):
    """
    get the thrift api version
    """
    pass

  def describe_ring(self, keyspace):
    """
    get the token ring: a map of ranges to host addresses,
    represented as a set of TokenRange instead of a map from range
    to list of endpoints, because you can't use Thrift structs as
    map keys:
    https://issues.apache.org/jira/browse/THRIFT-162

    for the same reason, we can't return a set here, even though
    order is neither important nor predictable.

    Parameters:
     - keyspace
    """
    pass

  def describe_keyspace(self, keyspace):
    """
    describe specified keyspace

    Parameters:
     - keyspace
    """
    pass

  def describe_splits(self, start_token, end_token, keys_per_split):
    """
    experimental API for hadoop/parallel query support.
    may change violently and without warning.

    returns list of token strings such that first subrange is (list[0], list[1]],
    next is (list[1], list[2]], etc.

    Parameters:
     - start_token
     - end_token
     - keys_per_split
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot != None:
      self._oprot = oprot
    self._seqid = 0

  def login(self, keyspace, auth_request):
    """
    Parameters:
     - keyspace
     - auth_request
    """
    self.send_login(keyspace, auth_request)
    self.recv_login()

  def send_login(self, keyspace, auth_request):
    self._oprot.writeMessageBegin('login', TMessageType.CALL, self._seqid)
    args = login_args()
    args.keyspace = keyspace
    args.auth_request = auth_request
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_login(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = login_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.authnx != None:
      raise result.authnx
    if result.authzx != None:
      raise result.authzx
    return

  def get(self, keyspace, key, column_path, consistency_level):
    """
    Get the Column or SuperColumn at the given column_path. If no value is present, NotFoundException is thrown. (This is
    the only method that can throw an exception under non-failure conditions.)

    Parameters:
     - keyspace
     - key
     - column_path
     - consistency_level
    """
    self.send_get(keyspace, key, column_path, consistency_level)
    return self.recv_get()

  def send_get(self, keyspace, key, column_path, consistency_level):
    self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
    args = get_args()
    args.keyspace = keyspace
    args.key = key
    args.column_path = column_path
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.nfe != None:
      raise result.nfe
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result");

  def get_slice(self, keyspace, key, column_parent, predicate, consistency_level):
    """
    Get the group of columns contained by column_parent (either a ColumnFamily name or a ColumnFamily/SuperColumn name
    pair) specified by the given SlicePredicate. If no matching values are found, an empty list is returned.

    Parameters:
     - keyspace
     - key
     - column_parent
     - predicate
     - consistency_level
    """
    self.send_get_slice(keyspace, key, column_parent, predicate, consistency_level)
    return self.recv_get_slice()

  def send_get_slice(self, keyspace, key, column_parent, predicate, consistency_level):
    self._oprot.writeMessageBegin('get_slice', TMessageType.CALL, self._seqid)
    args = get_slice_args()
    args.keyspace = keyspace
    args.key = key
    args.column_parent = column_parent
    args.predicate = predicate
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get_slice(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_slice_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get_slice failed: unknown result");

  def multiget(self, keyspace, keys, column_path, consistency_level):
    """
    Perform a get for column_path in parallel on the given list<string> keys. The return value maps keys to the
    ColumnOrSuperColumn found. If no value corresponding to a key is present, the key will still be in the map, but both
    the column and super_column references of the ColumnOrSuperColumn object it maps to will be null.
    @deprecated; use multiget_slice

    Parameters:
     - keyspace
     - keys
     - column_path
     - consistency_level
    """
    self.send_multiget(keyspace, keys, column_path, consistency_level)
    return self.recv_multiget()

  def send_multiget(self, keyspace, keys, column_path, consistency_level):
    self._oprot.writeMessageBegin('multiget', TMessageType.CALL, self._seqid)
    args = multiget_args()
    args.keyspace = keyspace
    args.keys = keys
    args.column_path = column_path
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_multiget(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = multiget_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "multiget failed: unknown result");

  def multiget_slice(self, keyspace, keys, column_parent, predicate, consistency_level):
    """
    Performs a get_slice for column_parent and predicate for the given keys in parallel.

    Parameters:
     - keyspace
     - keys
     - column_parent
     - predicate
     - consistency_level
    """
    self.send_multiget_slice(keyspace, keys, column_parent, predicate, consistency_level)
    return self.recv_multiget_slice()

  def send_multiget_slice(self, keyspace, keys, column_parent, predicate, consistency_level):
    self._oprot.writeMessageBegin('multiget_slice', TMessageType.CALL, self._seqid)
    args = multiget_slice_args()
    args.keyspace = keyspace
    args.keys = keys
    args.column_parent = column_parent
    args.predicate = predicate
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_multiget_slice(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = multiget_slice_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "multiget_slice failed: unknown result");

  def get_count(self, keyspace, key, column_parent, consistency_level):
    """
    returns the number of columns for a particular <code>key</code> and <code>ColumnFamily</code> or <code>SuperColumn</code>.

    Parameters:
     - keyspace
     - key
     - column_parent
     - consistency_level
    """
    self.send_get_count(keyspace, key, column_parent, consistency_level)
    return self.recv_get_count()

  def send_get_count(self, keyspace, key, column_parent, consistency_level):
    self._oprot.writeMessageBegin('get_count', TMessageType.CALL, self._seqid)
    args = get_count_args()
    args.keyspace = keyspace
    args.key = key
    args.column_parent = column_parent
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get_count(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_count_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get_count failed: unknown result");

  def get_range_slice(self, keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level):
    """
    returns a subset of columns for a range of keys.
    @Deprecated.  Use get_range_slices instead

    Parameters:
     - keyspace
     - column_parent
     - predicate
     - start_key
     - finish_key
     - row_count
     - consistency_level
    """
    self.send_get_range_slice(keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level)
    return self.recv_get_range_slice()

  def send_get_range_slice(self, keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level):
    self._oprot.writeMessageBegin('get_range_slice', TMessageType.CALL, self._seqid)
    args = get_range_slice_args()
    args.keyspace = keyspace
    args.column_parent = column_parent
    args.predicate = predicate
    args.start_key = start_key
    args.finish_key = finish_key
    args.row_count = row_count
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get_range_slice(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_range_slice_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get_range_slice failed: unknown result");

  def get_range_slices(self, keyspace, column_parent, predicate, range, consistency_level):
    """
    returns a subset of columns for a range of keys.

    Parameters:
     - keyspace
     - column_parent
     - predicate
     - range
     - consistency_level
    """
    self.send_get_range_slices(keyspace, column_parent, predicate, range, consistency_level)
    return self.recv_get_range_slices()

  def send_get_range_slices(self, keyspace, column_parent, predicate, range, consistency_level):
    self._oprot.writeMessageBegin('get_range_slices', TMessageType.CALL, self._seqid)
    args = get_range_slices_args()
    args.keyspace = keyspace
    args.column_parent = column_parent
    args.predicate = predicate
    args.range = range
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get_range_slices(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_range_slices_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get_range_slices failed: unknown result");

  def insert(self, keyspace, key, column_path, value, timestamp, consistency_level):
    """
    Insert a Column consisting of (column_path.column, value, timestamp) at the given column_path.column_family and optional
    column_path.super_column. Note that column_path.column is here required, since a SuperColumn cannot directly contain binary
    values -- it can only contain sub-Columns.

    Parameters:
     - keyspace
     - key
     - column_path
     - value
     - timestamp
     - consistency_level
    """
    self.send_insert(keyspace, key, column_path, value, timestamp, consistency_level)
    self.recv_insert()

  def send_insert(self, keyspace, key, column_path, value, timestamp, consistency_level):
    self._oprot.writeMessageBegin('insert', TMessageType.CALL, self._seqid)
    args = insert_args()
    args.keyspace = keyspace
    args.key = key
    args.column_path = column_path
    args.value = value
    args.timestamp = timestamp
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_insert(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = insert_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    return

  def batch_insert(self, keyspace, key, cfmap, consistency_level):
    """
    Insert Columns or SuperColumns across different Column Families for the same row key. batch_mutation is a
    map<string, list<ColumnOrSuperColumn>> -- a map which pairs column family names with the relevant ColumnOrSuperColumn
    objects to insert.
    @deprecated; use batch_mutate instead

    Parameters:
     - keyspace
     - key
     - cfmap
     - consistency_level
    """
    self.send_batch_insert(keyspace, key, cfmap, consistency_level)
    self.recv_batch_insert()

  def send_batch_insert(self, keyspace, key, cfmap, consistency_level):
    self._oprot.writeMessageBegin('batch_insert', TMessageType.CALL, self._seqid)
    args = batch_insert_args()
    args.keyspace = keyspace
    args.key = key
    args.cfmap = cfmap
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_batch_insert(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = batch_insert_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    return

  def remove(self, keyspace, key, column_path, timestamp, consistency_level):
    """
    Remove data from the row specified by key at the granularity specified by column_path, and the given timestamp. Note
    that all the values in column_path besides column_path.column_family are truly optional: you can remove the entire
    row by just specifying the ColumnFamily, or you can remove a SuperColumn or a single Column by specifying those levels too.

    Parameters:
     - keyspace
     - key
     - column_path
     - timestamp
     - consistency_level
    """
    self.send_remove(keyspace, key, column_path, timestamp, consistency_level)
    self.recv_remove()

  def send_remove(self, keyspace, key, column_path, timestamp, consistency_level):
    self._oprot.writeMessageBegin('remove', TMessageType.CALL, self._seqid)
    args = remove_args()
    args.keyspace = keyspace
    args.key = key
    args.column_path = column_path
    args.timestamp = timestamp
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_remove(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = remove_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    return

  def batch_mutate(self, keyspace, mutation_map, consistency_level):
    """
      Mutate many columns or super columns for many row keys. See also: Mutation.

      mutation_map maps key to column family to a list of Mutation objects to take place at that scope.
    *

    Parameters:
     - keyspace
     - mutation_map
     - consistency_level
    """
    self.send_batch_mutate(keyspace, mutation_map, consistency_level)
    self.recv_batch_mutate()

  def send_batch_mutate(self, keyspace, mutation_map, consistency_level):
    self._oprot.writeMessageBegin('batch_mutate', TMessageType.CALL, self._seqid)
    args = batch_mutate_args()
    args.keyspace = keyspace
    args.mutation_map = mutation_map
    args.consistency_level = consistency_level
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_batch_mutate(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = batch_mutate_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.ire != None:
      raise result.ire
    if result.ue != None:
      raise result.ue
    if result.te != None:
      raise result.te
    return

  def get_string_property(self, property):
    """
    get property whose value is of type string. @Deprecated

    Parameters:
     - property
    """
    self.send_get_string_property(property)
    return self.recv_get_string_property()

  def send_get_string_property(self, property):
    self._oprot.writeMessageBegin('get_string_property', TMessageType.CALL, self._seqid)
    args = get_string_property_args()
    args.property = property
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get_string_property(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_string_property_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get_string_property failed: unknown result");

  def get_string_list_property(self, property):
    """
    get property whose value is list of strings. @Deprecated

    Parameters:
     - property
    """
    self.send_get_string_list_property(property)
    return self.recv_get_string_list_property()

  def send_get_string_list_property(self, property):
    self._oprot.writeMessageBegin('get_string_list_property', TMessageType.CALL, self._seqid)
    args = get_string_list_property_args()
    args.property = property
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get_string_list_property(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_string_list_property_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get_string_list_property failed: unknown result");

  def describe_keyspaces(self, ):
    """
    list the defined keyspaces in this cluster
    """
    self.send_describe_keyspaces()
    return self.recv_describe_keyspaces()

  def send_describe_keyspaces(self, ):
    self._oprot.writeMessageBegin('describe_keyspaces', TMessageType.CALL, self._seqid)
    args = describe_keyspaces_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describe_keyspaces(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = describe_keyspaces_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describe_keyspaces failed: unknown result");

  def describe_cluster_name(self, ):
    """
    get the cluster name
    """
    self.send_describe_cluster_name()
    return self.recv_describe_cluster_name()

  def send_describe_cluster_name(self, ):
    self._oprot.writeMessageBegin('describe_cluster_name', TMessageType.CALL, self._seqid)
    args = describe_cluster_name_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describe_cluster_name(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = describe_cluster_name_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describe_cluster_name failed: unknown result");

  def describe_version(self, ):
    """
    get the thrift api version
    """
    self.send_describe_version()
    return self.recv_describe_version()

  def send_describe_version(self, ):
    self._oprot.writeMessageBegin('describe_version', TMessageType.CALL, self._seqid)
    args = describe_version_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describe_version(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = describe_version_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describe_version failed: unknown result");

  def describe_ring(self, keyspace):
    """
    get the token ring: a map of ranges to host addresses,
    represented as a set of TokenRange instead of a map from range
    to list of endpoints, because you can't use Thrift structs as
    map keys:
    https://issues.apache.org/jira/browse/THRIFT-162

    for the same reason, we can't return a set here, even though
    order is neither important nor predictable.

    Parameters:
     - keyspace
    """
    self.send_describe_ring(keyspace)
    return self.recv_describe_ring()

  def send_describe_ring(self, keyspace):
    self._oprot.writeMessageBegin('describe_ring', TMessageType.CALL, self._seqid)
    args = describe_ring_args()
    args.keyspace = keyspace
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describe_ring(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = describe_ring_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describe_ring failed: unknown result");

  def describe_keyspace(self, keyspace):
    """
    describe specified keyspace

    Parameters:
     - keyspace
    """
    self.send_describe_keyspace(keyspace)
    return self.recv_describe_keyspace()

  def send_describe_keyspace(self, keyspace):
    self._oprot.writeMessageBegin('describe_keyspace', TMessageType.CALL, self._seqid)
    args = describe_keyspace_args()
    args.keyspace = keyspace
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describe_keyspace(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = describe_keyspace_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    if result.nfe != None:
      raise result.nfe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describe_keyspace failed: unknown result");

  def describe_splits(self, start_token, end_token, keys_per_split):
    """
    experimental API for hadoop/parallel query support.
    may change violently and without warning.

    returns list of token strings such that first subrange is (list[0], list[1]],
    next is (list[1], list[2]], etc.

    Parameters:
     - start_token
     - end_token
     - keys_per_split
    """
    self.send_describe_splits(start_token, end_token, keys_per_split)
    return self.recv_describe_splits()

  def send_describe_splits(self, start_token, end_token, keys_per_split):
    self._oprot.writeMessageBegin('describe_splits', TMessageType.CALL, self._seqid)
    args = describe_splits_args()
    args.start_token = start_token
    args.end_token = end_token
    args.keys_per_split = keys_per_split
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describe_splits(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = describe_splits_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success != None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describe_splits failed: unknown result");


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["login"] = Processor.process_login
    self._processMap["get"] = Processor.process_get
    self._processMap["get_slice"] = Processor.process_get_slice
    self._processMap["multiget"] = Processor.process_multiget
    self._processMap["multiget_slice"] = Processor.process_multiget_slice
    self._processMap["get_count"] = Processor.process_get_count
    self._processMap["get_range_slice"] = Processor.process_get_range_slice
    self._processMap["get_range_slices"] = Processor.process_get_range_slices
    self._processMap["insert"] = Processor.process_insert
    self._processMap["batch_insert"] = Processor.process_batch_insert
    self._processMap["remove"] = Processor.process_remove
    self._processMap["batch_mutate"] = Processor.process_batch_mutate
    self._processMap["get_string_property"] = Processor.process_get_string_property
    self._processMap["get_string_list_property"] = Processor.process_get_string_list_property
    self._processMap["describe_keyspaces"] = Processor.process_describe_keyspaces
    self._processMap["describe_cluster_name"] = Processor.process_describe_cluster_name
    self._processMap["describe_version"] = Processor.process_describe_version
    self._processMap["describe_ring"] = Processor.process_describe_ring
    self._processMap["describe_keyspace"] = Processor.process_describe_keyspace
    self._processMap["describe_splits"] = Processor.process_describe_splits

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_login(self, seqid, iprot, oprot):
    args = login_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = login_result()
    try:
      self._handler.login(args.keyspace, args.auth_request)
    except AuthenticationException, authnx:
      result.authnx = authnx
    except AuthorizationException, authzx:
      result.authzx = authzx
    oprot.writeMessageBegin("login", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get(self, seqid, iprot, oprot):
    args = get_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_result()
    try:
      result.success = self._handler.get(args.keyspace, args.key, args.column_path, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except NotFoundException, nfe:
      result.nfe = nfe
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("get", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get_slice(self, seqid, iprot, oprot):
    args = get_slice_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_slice_result()
    try:
      result.success = self._handler.get_slice(args.keyspace, args.key, args.column_parent, args.predicate, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("get_slice", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_multiget(self, seqid, iprot, oprot):
    args = multiget_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = multiget_result()
    try:
      result.success = self._handler.multiget(args.keyspace, args.keys, args.column_path, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("multiget", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_multiget_slice(self, seqid, iprot, oprot):
    args = multiget_slice_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = multiget_slice_result()
    try:
      result.success = self._handler.multiget_slice(args.keyspace, args.keys, args.column_parent, args.predicate, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("multiget_slice", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get_count(self, seqid, iprot, oprot):
    args = get_count_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_count_result()
    try:
      result.success = self._handler.get_count(args.keyspace, args.key, args.column_parent, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("get_count", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get_range_slice(self, seqid, iprot, oprot):
    args = get_range_slice_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_range_slice_result()
    try:
      result.success = self._handler.get_range_slice(args.keyspace, args.column_parent, args.predicate, args.start_key, args.finish_key, args.row_count, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("get_range_slice", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get_range_slices(self, seqid, iprot, oprot):
    args = get_range_slices_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_range_slices_result()
    try:
      result.success = self._handler.get_range_slices(args.keyspace, args.column_parent, args.predicate, args.range, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("get_range_slices", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_insert(self, seqid, iprot, oprot):
    args = insert_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = insert_result()
    try:
      self._handler.insert(args.keyspace, args.key, args.column_path, args.value, args.timestamp, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("insert", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_batch_insert(self, seqid, iprot, oprot):
    args = batch_insert_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = batch_insert_result()
    try:
      self._handler.batch_insert(args.keyspace, args.key, args.cfmap, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("batch_insert", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_remove(self, seqid, iprot, oprot):
    args = remove_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = remove_result()
    try:
      self._handler.remove(args.keyspace, args.key, args.column_path, args.timestamp, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("remove", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_batch_mutate(self, seqid, iprot, oprot):
    args = batch_mutate_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = batch_mutate_result()
    try:
      self._handler.batch_mutate(args.keyspace, args.mutation_map, args.consistency_level)
    except InvalidRequestException, ire:
      result.ire = ire
    except UnavailableException, ue:
      result.ue = ue
    except TimedOutException, te:
      result.te = te
    oprot.writeMessageBegin("batch_mutate", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get_string_property(self, seqid, iprot, oprot):
    args = get_string_property_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_string_property_result()
    result.success = self._handler.get_string_property(args.property)
    oprot.writeMessageBegin("get_string_property", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get_string_list_property(self, seqid, iprot, oprot):
    args = get_string_list_property_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_string_list_property_result()
    result.success = self._handler.get_string_list_property(args.property)
    oprot.writeMessageBegin("get_string_list_property", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describe_keyspaces(self, seqid, iprot, oprot):
    args = describe_keyspaces_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describe_keyspaces_result()
    result.success = self._handler.describe_keyspaces()
    oprot.writeMessageBegin("describe_keyspaces", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describe_cluster_name(self, seqid, iprot, oprot):
    args = describe_cluster_name_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describe_cluster_name_result()
    result.success = self._handler.describe_cluster_name()
    oprot.writeMessageBegin("describe_cluster_name", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describe_version(self, seqid, iprot, oprot):
    args = describe_version_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describe_version_result()
    result.success = self._handler.describe_version()
    oprot.writeMessageBegin("describe_version", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describe_ring(self, seqid, iprot, oprot):
    args = describe_ring_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describe_ring_result()
    result.success = self._handler.describe_ring(args.keyspace)
    oprot.writeMessageBegin("describe_ring", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describe_keyspace(self, seqid, iprot, oprot):
    args = describe_keyspace_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describe_keyspace_result()
    try:
      result.success = self._handler.describe_keyspace(args.keyspace)
    except NotFoundException, nfe:
      result.nfe = nfe
    oprot.writeMessageBegin("describe_keyspace", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describe_splits(self, seqid, iprot, oprot):
    args = describe_splits_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describe_splits_result()
    result.success = self._handler.describe_splits(args.start_token, args.end_token, args.keys_per_split)
    oprot.writeMessageBegin("describe_splits", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class login_args(object):
  """
  Attributes:
   - keyspace
   - auth_request
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRUCT, 'auth_request', (AuthenticationRequest, AuthenticationRequest.thrift_spec), None, ), # 2
  )

  def __init__(self, keyspace=None, auth_request=None,):
    self.keyspace = keyspace
    self.auth_request = auth_request

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.auth_request = AuthenticationRequest()
          self.auth_request.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('login_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.auth_request != None:
      oprot.writeFieldBegin('auth_request', TType.STRUCT, 2)
      self.auth_request.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class login_result(object):
  """
  Attributes:
   - authnx
   - authzx
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'authnx', (AuthenticationException, AuthenticationException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'authzx', (AuthorizationException, AuthorizationException.thrift_spec), None, ), # 2
  )

  def __init__(self, authnx=None, authzx=None,):
    self.authnx = authnx
    self.authzx = authzx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.authnx = AuthenticationException()
          self.authnx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.authzx = AuthorizationException()
          self.authzx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('login_result')
    if self.authnx != None:
      oprot.writeFieldBegin('authnx', TType.STRUCT, 1)
      self.authnx.write(oprot)
      oprot.writeFieldEnd()
    if self.authzx != None:
      oprot.writeFieldBegin('authzx', TType.STRUCT, 2)
      self.authzx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_args(object):
  """
  Attributes:
   - keyspace
   - key
   - column_path
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRING, 'key', None, None, ), # 2
    (3, TType.STRUCT, 'column_path', (ColumnPath, ColumnPath.thrift_spec), None, ), # 3
    (4, TType.I32, 'consistency_level', None,     1, ), # 4
  )

  def __init__(self, keyspace=None, key=None, column_path=None, consistency_level=thrift_spec[4][4],):
    self.keyspace = keyspace
    self.key = key
    self.column_path = column_path
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_path = ColumnPath()
          self.column_path.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.key != None:
      oprot.writeFieldBegin('key', TType.STRING, 2)
      oprot.writeString(self.key)
      oprot.writeFieldEnd()
    if self.column_path != None:
      oprot.writeFieldBegin('column_path', TType.STRUCT, 3)
      self.column_path.write(oprot)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 4)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_result(object):
  """
  Attributes:
   - success
   - ire
   - nfe
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ColumnOrSuperColumn, ColumnOrSuperColumn.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'nfe', (NotFoundException, NotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 4
  )

  def __init__(self, success=None, ire=None, nfe=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.nfe = nfe
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ColumnOrSuperColumn()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.nfe = NotFoundException()
          self.nfe.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.nfe != None:
      oprot.writeFieldBegin('nfe', TType.STRUCT, 2)
      self.nfe.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 3)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 4)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_slice_args(object):
  """
  Attributes:
   - keyspace
   - key
   - column_parent
   - predicate
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRING, 'key', None, None, ), # 2
    (3, TType.STRUCT, 'column_parent', (ColumnParent, ColumnParent.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'predicate', (SlicePredicate, SlicePredicate.thrift_spec), None, ), # 4
    (5, TType.I32, 'consistency_level', None,     1, ), # 5
  )

  def __init__(self, keyspace=None, key=None, column_parent=None, predicate=None, consistency_level=thrift_spec[5][4],):
    self.keyspace = keyspace
    self.key = key
    self.column_parent = column_parent
    self.predicate = predicate
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_parent = ColumnParent()
          self.column_parent.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.predicate = SlicePredicate()
          self.predicate.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_slice_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.key != None:
      oprot.writeFieldBegin('key', TType.STRING, 2)
      oprot.writeString(self.key)
      oprot.writeFieldEnd()
    if self.column_parent != None:
      oprot.writeFieldBegin('column_parent', TType.STRUCT, 3)
      self.column_parent.write(oprot)
      oprot.writeFieldEnd()
    if self.predicate != None:
      oprot.writeFieldBegin('predicate', TType.STRUCT, 4)
      self.predicate.write(oprot)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 5)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_slice_result(object):
  """
  Attributes:
   - success
   - ire
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(ColumnOrSuperColumn, ColumnOrSuperColumn.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, ire=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype40, _size37) = iprot.readListBegin()
          for _i41 in xrange(_size37):
            _elem42 = ColumnOrSuperColumn()
            _elem42.read(iprot)
            self.success.append(_elem42)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_slice_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter43 in self.success:
        iter43.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class multiget_args(object):
  """
  Attributes:
   - keyspace
   - keys
   - column_path
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.LIST, 'keys', (TType.STRING,None), None, ), # 2
    (3, TType.STRUCT, 'column_path', (ColumnPath, ColumnPath.thrift_spec), None, ), # 3
    (4, TType.I32, 'consistency_level', None,     1, ), # 4
  )

  def __init__(self, keyspace=None, keys=None, column_path=None, consistency_level=thrift_spec[4][4],):
    self.keyspace = keyspace
    self.keys = keys
    self.column_path = column_path
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.keys = []
          (_etype47, _size44) = iprot.readListBegin()
          for _i48 in xrange(_size44):
            _elem49 = iprot.readString();
            self.keys.append(_elem49)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_path = ColumnPath()
          self.column_path.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('multiget_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.keys != None:
      oprot.writeFieldBegin('keys', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.keys))
      for iter50 in self.keys:
        oprot.writeString(iter50)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.column_path != None:
      oprot.writeFieldBegin('column_path', TType.STRUCT, 3)
      self.column_path.write(oprot)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 4)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class multiget_result(object):
  """
  Attributes:
   - success
   - ire
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.STRUCT,(ColumnOrSuperColumn, ColumnOrSuperColumn.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, ire=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype52, _vtype53, _size51 ) = iprot.readMapBegin()
          for _i55 in xrange(_size51):
            _key56 = iprot.readString();
            _val57 = ColumnOrSuperColumn()
            _val57.read(iprot)
            self.success[_key56] = _val57
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('multiget_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
      for kiter58,viter59 in self.success.items():
        oprot.writeString(kiter58)
        viter59.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class multiget_slice_args(object):
  """
  Attributes:
   - keyspace
   - keys
   - column_parent
   - predicate
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.LIST, 'keys', (TType.STRING,None), None, ), # 2
    (3, TType.STRUCT, 'column_parent', (ColumnParent, ColumnParent.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'predicate', (SlicePredicate, SlicePredicate.thrift_spec), None, ), # 4
    (5, TType.I32, 'consistency_level', None,     1, ), # 5
  )

  def __init__(self, keyspace=None, keys=None, column_parent=None, predicate=None, consistency_level=thrift_spec[5][4],):
    self.keyspace = keyspace
    self.keys = keys
    self.column_parent = column_parent
    self.predicate = predicate
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.keys = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = iprot.readString();
            self.keys.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_parent = ColumnParent()
          self.column_parent.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.predicate = SlicePredicate()
          self.predicate.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('multiget_slice_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.keys != None:
      oprot.writeFieldBegin('keys', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.keys))
      for iter66 in self.keys:
        oprot.writeString(iter66)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.column_parent != None:
      oprot.writeFieldBegin('column_parent', TType.STRUCT, 3)
      self.column_parent.write(oprot)
      oprot.writeFieldEnd()
    if self.predicate != None:
      oprot.writeFieldBegin('predicate', TType.STRUCT, 4)
      self.predicate.write(oprot)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 5)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class multiget_slice_result(object):
  """
  Attributes:
   - success
   - ire
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.LIST,(TType.STRUCT,(ColumnOrSuperColumn, ColumnOrSuperColumn.thrift_spec))), None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, ire=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype68, _vtype69, _size67 ) = iprot.readMapBegin()
          for _i71 in xrange(_size67):
            _key72 = iprot.readString();
            _val73 = []
            (_etype77, _size74) = iprot.readListBegin()
            for _i78 in xrange(_size74):
              _elem79 = ColumnOrSuperColumn()
              _elem79.read(iprot)
              _val73.append(_elem79)
            iprot.readListEnd()
            self.success[_key72] = _val73
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('multiget_slice_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.success))
      for kiter80,viter81 in self.success.items():
        oprot.writeString(kiter80)
        oprot.writeListBegin(TType.STRUCT, len(viter81))
        for iter82 in viter81:
          iter82.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_count_args(object):
  """
  Attributes:
   - keyspace
   - key
   - column_parent
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRING, 'key', None, None, ), # 2
    (3, TType.STRUCT, 'column_parent', (ColumnParent, ColumnParent.thrift_spec), None, ), # 3
    (4, TType.I32, 'consistency_level', None,     1, ), # 4
  )

  def __init__(self, keyspace=None, key=None, column_parent=None, consistency_level=thrift_spec[4][4],):
    self.keyspace = keyspace
    self.key = key
    self.column_parent = column_parent
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_parent = ColumnParent()
          self.column_parent.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_count_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.key != None:
      oprot.writeFieldBegin('key', TType.STRING, 2)
      oprot.writeString(self.key)
      oprot.writeFieldEnd()
    if self.column_parent != None:
      oprot.writeFieldBegin('column_parent', TType.STRUCT, 3)
      self.column_parent.write(oprot)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 4)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_count_result(object):
  """
  Attributes:
   - success
   - ire
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, ire=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_count_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_range_slice_args(object):
  """
  Attributes:
   - keyspace
   - column_parent
   - predicate
   - start_key
   - finish_key
   - row_count
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRUCT, 'column_parent', (ColumnParent, ColumnParent.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'predicate', (SlicePredicate, SlicePredicate.thrift_spec), None, ), # 3
    (4, TType.STRING, 'start_key', None, "", ), # 4
    (5, TType.STRING, 'finish_key', None, "", ), # 5
    (6, TType.I32, 'row_count', None, 100, ), # 6
    (7, TType.I32, 'consistency_level', None,     1, ), # 7
  )

  def __init__(self, keyspace=None, column_parent=None, predicate=None, start_key=thrift_spec[4][4], finish_key=thrift_spec[5][4], row_count=thrift_spec[6][4], consistency_level=thrift_spec[7][4],):
    self.keyspace = keyspace
    self.column_parent = column_parent
    self.predicate = predicate
    self.start_key = start_key
    self.finish_key = finish_key
    self.row_count = row_count
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.column_parent = ColumnParent()
          self.column_parent.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.predicate = SlicePredicate()
          self.predicate.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.start_key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.finish_key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.row_count = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_range_slice_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.column_parent != None:
      oprot.writeFieldBegin('column_parent', TType.STRUCT, 2)
      self.column_parent.write(oprot)
      oprot.writeFieldEnd()
    if self.predicate != None:
      oprot.writeFieldBegin('predicate', TType.STRUCT, 3)
      self.predicate.write(oprot)
      oprot.writeFieldEnd()
    if self.start_key != None:
      oprot.writeFieldBegin('start_key', TType.STRING, 4)
      oprot.writeString(self.start_key)
      oprot.writeFieldEnd()
    if self.finish_key != None:
      oprot.writeFieldBegin('finish_key', TType.STRING, 5)
      oprot.writeString(self.finish_key)
      oprot.writeFieldEnd()
    if self.row_count != None:
      oprot.writeFieldBegin('row_count', TType.I32, 6)
      oprot.writeI32(self.row_count)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 7)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_range_slice_result(object):
  """
  Attributes:
   - success
   - ire
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(KeySlice, KeySlice.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, ire=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype86, _size83) = iprot.readListBegin()
          for _i87 in xrange(_size83):
            _elem88 = KeySlice()
            _elem88.read(iprot)
            self.success.append(_elem88)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_range_slice_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter89 in self.success:
        iter89.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_range_slices_args(object):
  """
  Attributes:
   - keyspace
   - column_parent
   - predicate
   - range
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRUCT, 'column_parent', (ColumnParent, ColumnParent.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'predicate', (SlicePredicate, SlicePredicate.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'range', (KeyRange, KeyRange.thrift_spec), None, ), # 4
    (5, TType.I32, 'consistency_level', None,     1, ), # 5
  )

  def __init__(self, keyspace=None, column_parent=None, predicate=None, range=None, consistency_level=thrift_spec[5][4],):
    self.keyspace = keyspace
    self.column_parent = column_parent
    self.predicate = predicate
    self.range = range
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.column_parent = ColumnParent()
          self.column_parent.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.predicate = SlicePredicate()
          self.predicate.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.range = KeyRange()
          self.range.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_range_slices_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.column_parent != None:
      oprot.writeFieldBegin('column_parent', TType.STRUCT, 2)
      self.column_parent.write(oprot)
      oprot.writeFieldEnd()
    if self.predicate != None:
      oprot.writeFieldBegin('predicate', TType.STRUCT, 3)
      self.predicate.write(oprot)
      oprot.writeFieldEnd()
    if self.range != None:
      oprot.writeFieldBegin('range', TType.STRUCT, 4)
      self.range.write(oprot)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 5)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_range_slices_result(object):
  """
  Attributes:
   - success
   - ire
   - ue
   - te
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(KeySlice, KeySlice.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, ire=None, ue=None, te=None,):
    self.success = success
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype93, _size90) = iprot.readListBegin()
          for _i94 in xrange(_size90):
            _elem95 = KeySlice()
            _elem95.read(iprot)
            self.success.append(_elem95)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_range_slices_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter96 in self.success:
        iter96.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class insert_args(object):
  """
  Attributes:
   - keyspace
   - key
   - column_path
   - value
   - timestamp
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRING, 'key', None, None, ), # 2
    (3, TType.STRUCT, 'column_path', (ColumnPath, ColumnPath.thrift_spec), None, ), # 3
    (4, TType.STRING, 'value', None, None, ), # 4
    (5, TType.I64, 'timestamp', None, None, ), # 5
    (6, TType.I32, 'consistency_level', None,     1, ), # 6
  )

  def __init__(self, keyspace=None, key=None, column_path=None, value=None, timestamp=None, consistency_level=thrift_spec[6][4],):
    self.keyspace = keyspace
    self.key = key
    self.column_path = column_path
    self.value = value
    self.timestamp = timestamp
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_path = ColumnPath()
          self.column_path.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.value = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('insert_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.key != None:
      oprot.writeFieldBegin('key', TType.STRING, 2)
      oprot.writeString(self.key)
      oprot.writeFieldEnd()
    if self.column_path != None:
      oprot.writeFieldBegin('column_path', TType.STRUCT, 3)
      self.column_path.write(oprot)
      oprot.writeFieldEnd()
    if self.value != None:
      oprot.writeFieldBegin('value', TType.STRING, 4)
      oprot.writeString(self.value)
      oprot.writeFieldEnd()
    if self.timestamp != None:
      oprot.writeFieldBegin('timestamp', TType.I64, 5)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 6)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class insert_result(object):
  """
  Attributes:
   - ire
   - ue
   - te
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, ire=None, ue=None, te=None,):
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('insert_result')
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class batch_insert_args(object):
  """
  Attributes:
   - keyspace
   - key
   - cfmap
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRING, 'key', None, None, ), # 2
    (3, TType.MAP, 'cfmap', (TType.STRING,None,TType.LIST,(TType.STRUCT,(ColumnOrSuperColumn, ColumnOrSuperColumn.thrift_spec))), None, ), # 3
    (4, TType.I32, 'consistency_level', None,     1, ), # 4
  )

  def __init__(self, keyspace=None, key=None, cfmap=None, consistency_level=thrift_spec[4][4],):
    self.keyspace = keyspace
    self.key = key
    self.cfmap = cfmap
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.cfmap = {}
          (_ktype98, _vtype99, _size97 ) = iprot.readMapBegin()
          for _i101 in xrange(_size97):
            _key102 = iprot.readString();
            _val103 = []
            (_etype107, _size104) = iprot.readListBegin()
            for _i108 in xrange(_size104):
              _elem109 = ColumnOrSuperColumn()
              _elem109.read(iprot)
              _val103.append(_elem109)
            iprot.readListEnd()
            self.cfmap[_key102] = _val103
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('batch_insert_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.key != None:
      oprot.writeFieldBegin('key', TType.STRING, 2)
      oprot.writeString(self.key)
      oprot.writeFieldEnd()
    if self.cfmap != None:
      oprot.writeFieldBegin('cfmap', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.cfmap))
      for kiter110,viter111 in self.cfmap.items():
        oprot.writeString(kiter110)
        oprot.writeListBegin(TType.STRUCT, len(viter111))
        for iter112 in viter111:
          iter112.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 4)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class batch_insert_result(object):
  """
  Attributes:
   - ire
   - ue
   - te
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, ire=None, ue=None, te=None,):
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('batch_insert_result')
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class remove_args(object):
  """
  Attributes:
   - keyspace
   - key
   - column_path
   - timestamp
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.STRING, 'key', None, None, ), # 2
    (3, TType.STRUCT, 'column_path', (ColumnPath, ColumnPath.thrift_spec), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.I32, 'consistency_level', None,     1, ), # 5
  )

  def __init__(self, keyspace=None, key=None, column_path=None, timestamp=None, consistency_level=thrift_spec[5][4],):
    self.keyspace = keyspace
    self.key = key
    self.column_path = column_path
    self.timestamp = timestamp
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.key = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.column_path = ColumnPath()
          self.column_path.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('remove_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.key != None:
      oprot.writeFieldBegin('key', TType.STRING, 2)
      oprot.writeString(self.key)
      oprot.writeFieldEnd()
    if self.column_path != None:
      oprot.writeFieldBegin('column_path', TType.STRUCT, 3)
      self.column_path.write(oprot)
      oprot.writeFieldEnd()
    if self.timestamp != None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 5)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class remove_result(object):
  """
  Attributes:
   - ire
   - ue
   - te
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, ire=None, ue=None, te=None,):
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('remove_result')
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class batch_mutate_args(object):
  """
  Attributes:
   - keyspace
   - mutation_map
   - consistency_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
    (2, TType.MAP, 'mutation_map', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.LIST,(TType.STRUCT,(Mutation, Mutation.thrift_spec)))), None, ), # 2
    (3, TType.I32, 'consistency_level', None,     1, ), # 3
  )

  def __init__(self, keyspace=None, mutation_map=None, consistency_level=thrift_spec[3][4],):
    self.keyspace = keyspace
    self.mutation_map = mutation_map
    self.consistency_level = consistency_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.mutation_map = {}
          (_ktype114, _vtype115, _size113 ) = iprot.readMapBegin()
          for _i117 in xrange(_size113):
            _key118 = iprot.readString();
            _val119 = {}
            (_ktype121, _vtype122, _size120 ) = iprot.readMapBegin()
            for _i124 in xrange(_size120):
              _key125 = iprot.readString();
              _val126 = []
              (_etype130, _size127) = iprot.readListBegin()
              for _i131 in xrange(_size127):
                _elem132 = Mutation()
                _elem132.read(iprot)
                _val126.append(_elem132)
              iprot.readListEnd()
              _val119[_key125] = _val126
            iprot.readMapEnd()
            self.mutation_map[_key118] = _val119
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.consistency_level = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('batch_mutate_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    if self.mutation_map != None:
      oprot.writeFieldBegin('mutation_map', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.mutation_map))
      for kiter133,viter134 in self.mutation_map.items():
        oprot.writeString(kiter133)
        oprot.writeMapBegin(TType.STRING, TType.LIST, len(viter134))
        for kiter135,viter136 in viter134.items():
          oprot.writeString(kiter135)
          oprot.writeListBegin(TType.STRUCT, len(viter136))
          for iter137 in viter136:
            iter137.write(oprot)
          oprot.writeListEnd()
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.consistency_level != None:
      oprot.writeFieldBegin('consistency_level', TType.I32, 3)
      oprot.writeI32(self.consistency_level)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class batch_mutate_result(object):
  """
  Attributes:
   - ire
   - ue
   - te
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ire', (InvalidRequestException, InvalidRequestException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ue', (UnavailableException, UnavailableException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'te', (TimedOutException, TimedOutException.thrift_spec), None, ), # 3
  )

  def __init__(self, ire=None, ue=None, te=None,):
    self.ire = ire
    self.ue = ue
    self.te = te

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ire = InvalidRequestException()
          self.ire.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ue = UnavailableException()
          self.ue.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.te = TimedOutException()
          self.te.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('batch_mutate_result')
    if self.ire != None:
      oprot.writeFieldBegin('ire', TType.STRUCT, 1)
      self.ire.write(oprot)
      oprot.writeFieldEnd()
    if self.ue != None:
      oprot.writeFieldBegin('ue', TType.STRUCT, 2)
      self.ue.write(oprot)
      oprot.writeFieldEnd()
    if self.te != None:
      oprot.writeFieldBegin('te', TType.STRUCT, 3)
      self.te.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_string_property_args(object):
  """
  Attributes:
   - property
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'property', None, None, ), # 1
  )

  def __init__(self, property=None,):
    self.property = property

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.property = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_string_property_args')
    if self.property != None:
      oprot.writeFieldBegin('property', TType.STRING, 1)
      oprot.writeString(self.property)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_string_property_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_string_property_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_string_list_property_args(object):
  """
  Attributes:
   - property
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'property', None, None, ), # 1
  )

  def __init__(self, property=None,):
    self.property = property

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.property = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_string_list_property_args')
    if self.property != None:
      oprot.writeFieldBegin('property', TType.STRING, 1)
      oprot.writeString(self.property)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_string_list_property_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype141, _size138) = iprot.readListBegin()
          for _i142 in xrange(_size138):
            _elem143 = iprot.readString();
            self.success.append(_elem143)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_string_list_property_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter144 in self.success:
        oprot.writeString(iter144)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_keyspaces_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_keyspaces_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_keyspaces_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.SET, 'success', (TType.STRING,None), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.SET:
          self.success = set()
          (_etype148, _size145) = iprot.readSetBegin()
          for _i149 in xrange(_size145):
            _elem150 = iprot.readString();
            self.success.add(_elem150)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_keyspaces_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.SET, 0)
      oprot.writeSetBegin(TType.STRING, len(self.success))
      for iter151 in self.success:
        oprot.writeString(iter151)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_cluster_name_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_cluster_name_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_cluster_name_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_cluster_name_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_version_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_version_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_version_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_version_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_ring_args(object):
  """
  Attributes:
   - keyspace
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
  )

  def __init__(self, keyspace=None,):
    self.keyspace = keyspace

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_ring_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_ring_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TokenRange, TokenRange.thrift_spec)), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype155, _size152) = iprot.readListBegin()
          for _i156 in xrange(_size152):
            _elem157 = TokenRange()
            _elem157.read(iprot)
            self.success.append(_elem157)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_ring_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter158 in self.success:
        iter158.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_keyspace_args(object):
  """
  Attributes:
   - keyspace
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'keyspace', None, None, ), # 1
  )

  def __init__(self, keyspace=None,):
    self.keyspace = keyspace

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.keyspace = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_keyspace_args')
    if self.keyspace != None:
      oprot.writeFieldBegin('keyspace', TType.STRING, 1)
      oprot.writeString(self.keyspace)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_keyspace_result(object):
  """
  Attributes:
   - success
   - nfe
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.STRING,None)), None, ), # 0
    (1, TType.STRUCT, 'nfe', (NotFoundException, NotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, nfe=None,):
    self.success = success
    self.nfe = nfe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype160, _vtype161, _size159 ) = iprot.readMapBegin()
          for _i163 in xrange(_size159):
            _key164 = iprot.readString();
            _val165 = {}
            (_ktype167, _vtype168, _size166 ) = iprot.readMapBegin()
            for _i170 in xrange(_size166):
              _key171 = iprot.readString();
              _val172 = iprot.readString();
              _val165[_key171] = _val172
            iprot.readMapEnd()
            self.success[_key164] = _val165
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.nfe = NotFoundException()
          self.nfe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_keyspace_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.success))
      for kiter173,viter174 in self.success.items():
        oprot.writeString(kiter173)
        oprot.writeMapBegin(TType.STRING, TType.STRING, len(viter174))
        for kiter175,viter176 in viter174.items():
          oprot.writeString(kiter175)
          oprot.writeString(viter176)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.nfe != None:
      oprot.writeFieldBegin('nfe', TType.STRUCT, 1)
      self.nfe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_splits_args(object):
  """
  Attributes:
   - start_token
   - end_token
   - keys_per_split
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'start_token', None, None, ), # 1
    (2, TType.STRING, 'end_token', None, None, ), # 2
    (3, TType.I32, 'keys_per_split', None, None, ), # 3
  )

  def __init__(self, start_token=None, end_token=None, keys_per_split=None,):
    self.start_token = start_token
    self.end_token = end_token
    self.keys_per_split = keys_per_split

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.start_token = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.end_token = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.keys_per_split = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_splits_args')
    if self.start_token != None:
      oprot.writeFieldBegin('start_token', TType.STRING, 1)
      oprot.writeString(self.start_token)
      oprot.writeFieldEnd()
    if self.end_token != None:
      oprot.writeFieldBegin('end_token', TType.STRING, 2)
      oprot.writeString(self.end_token)
      oprot.writeFieldEnd()
    if self.keys_per_split != None:
      oprot.writeFieldBegin('keys_per_split', TType.I32, 3)
      oprot.writeI32(self.keys_per_split)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describe_splits_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype180, _size177) = iprot.readListBegin()
          for _i181 in xrange(_size177):
            _elem182 = iprot.readString();
            self.success.append(_elem182)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describe_splits_result')
    if self.success != None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter183 in self.success:
        oprot.writeString(iter183)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
