""" Tests for pkg utils """

from functools import partial
from operator import eq
from os import path
from platform import platform
from site import getsitepackages
from unittest import TestCase, skipIf

from cdd.shared.pkg_utils import get_python_lib, relative_filename
from cdd.tests.utils_for_tests import unittest_main


class TestPkgUtils(TestCase):
    """Test class for pkg utils"""

    def test_relative_filename(self) -> None:
        """Tests relative_filename ident"""
        expect: str = "gaffe"
        self.assertEqual(relative_filename(expect), expect)

    @skipIf(platform == "win32", "Skip hack for sitepackages check on Windows")
    def test_get_python_lib(self) -> None:
        """Tests that `get_python_lib` works"""
        python_lib: str = get_python_lib()
        site_packages: str = getsitepackages()[0]
        site_packages: str = next(
            filter(
                partial(eq, python_lib),
                (
                    lambda two_dir_above: (
                        site_packages,
                        two_dir_above,
                        path.join(two_dir_above, "python3", "dist-packages"),
                    )
                )(path.dirname(path.dirname(site_packages))),
            ),
            site_packages,
        )
        self.assertEqual(site_packages, python_lib)


unittest_main()
