"""Each kind of Bootstrap alert is generated by looping
over the classes created from parsing Bootstrap example
and using the `type` type to make classes."""

from .... import ChameleonTemplate
from ....constants import Join
from ....constants import global_safe
from ...components.constants import ATTRIBUTE_LOOKUP
from ...components.constants import COMPONENT_CLASS_NAMES
from ...components.constants import DIV_TEMPLATE_STRING
from .. import _Component


def compontent(
    class_name: str = None,
    chameleon_template: ChameleonTemplate = None,
    contextual_class_name: str = None,
):
    """Create a custom component class."""
    return type(
        class_name,
        (dict, _Component),
        dict(
            template=chameleon_template.html_string,
            attrib=ATTRIBUTE_LOOKUP[contextual_class_name],
        ),
    )


def get_repr(class_name):
    """Return a function to use for __repr__"""

    def __repr__(self):
        return Join.SPACES(("<", class_name, ": ", self.html_string, ">"))

    return __repr__


ALERT_COMPONENTS = dict(
    zip(
        COMPONENT_CLASS_NAMES,
        (
            type(
                class_name,
                (dict, _Component),
                dict(
                    template=DIV_TEMPLATE_STRING,
                    attrib=ATTRIBUTE_LOOKUP[class_name],
                    __str__=lambda self: self.html_string,
                    __repr__=get_repr(class_name),
                ),
            )
            for class_name in COMPONENT_CLASS_NAMES
        ),
    )
)
if global_safe(ALERT_COMPONENTS):
    globals().update(ALERT_COMPONENTS)

if __name__ == "__main__":
    from ....constants import FAKE

    for key, value in ALERT_COMPONENTS.items():
        inner_html = value(inner_content=FAKE.paragraph()).html_string
        print(inner_html)
