# Copyright 2021 University of Chicago
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# These should correspond to machine names and descriptions on Balena's docs:
# https://www.balena.io/docs/reference/base-images/devicetypes/
SUPPORTED_MACHINE_NAMES = {
    "raspberrypi3-64": "Raspberry Pi 3 (using 64bit OS)",
    "raspberrypi4-64": "Raspberry Pi 4 (using 64bit OS)",
    "jetson-nano": "Jetson Nano Devkit (SD Card, rev B01)",
    "jetson-xavier-nx-emmc": "Jetson Xavier NX Devkit (eMMC)",
}

LOCAL_EGRESS = [
    "allow",
    "deny",
]
