import os
import sys

sys.path.insert(0, os.path.abspath("../.."))

project = "Chameleon Cloud API"
copyright = "2019, University of Chicago"
author = "Jason Anderson"
# author = 'Nick Timkovich'

# The short X.Y version
version = "0.1"
# The full version, including alpha/beta/rc tags
release = "0.1"

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.viewcode",
]

templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
source_suffix = [".rst"]

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "alabaster"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    # 'logo': '480px-Claw-hammer.jpg',
    "github_user": "ChameleonCloud",
    "github_repo": "python-chi",
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {
#     '**': [
#         'about.html',
#         'navigation.html',
#         'relations.html',
#         'searchbox.html',
#     ],
# }

# Output file base name for HTML help builder.
htmlhelp_basename = "ChameleonCloudAPIDoc"

description = "{} Documentation".format(project)

# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "ChameleonCloudAPI.tex", description, "Nick Timkovich", "manual"),
]

# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "chameleoncloudapi", description, [author], 1)]

# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "ChameleonCloudAPI",
        description,
        author,
        "ChameleonCloudAPI",
        "A set of Python abstractions for interfacing with the Chameleon testbed",
        "Miscellaneous",
    ),
]

intersphinx_mapping = {
    "python": ("https://docs.python.org/2", None),
    "python3": ("https://docs.python.org/3/", None),
    "python37": ("https://docs.python.org/3.7/", None),
    "MySQLdb": ("https://mysqlclient.readthedocs.io/", None),
}
