# Executing pyCIAM
This README describes the workflow used to produce results contained in Depsky et al. 2022. Asterisks correspond to notebooks that contain necessary steps even for those wishing to run pyCIAM in a different context. For example, notebooks that generate figures or conduct auxilliary analyses for Depsky et al. 2022 are not starred.

The aggregated coastal input datasets required for pyCIAM are [SLIIDERS-ECON](https://doi.org/10.5281/zenodo.6010452) and [SLIIDERS-SLR](https://doi.org/10.5281/zenodo.6012027). Alternatively, users may construct their own inputs, for example to integrate alternative underlying data layers. In this case, they must still conform to the format of the SLIIDERS datasets. We would recommend starting from the SLIIDERS construction code found in the [SLIIDERS repository](https://github.com/ClimateImpactLab/sliiders)

A set of common filepaths, settings, and helper functions used for this worfkflow are contained in [shared.py](./shared.py). These should be adjusted as needed. In particular, you will need to adjust the filepaths to suit your data storage structure.

The following notebooks should be run in the described order to replicate the manuscript results. 
1. *[collapse-sliiders-econ-to-seg.ipynb](./collapse-sliiders-econ-to-seg.ipynb): SLIIDERS-ECON is provided where each analysis unit corresponds to a unique combination of admin1 region and coastal segment. This is helpful for aggregating results to admin1-level outputs, since the decision-making agent must occur at the segment level. For certain use cases, e.g. creating the surge lookup table, the additional admin1 dimension is unnecessary and leads to excess computational demands. Thus, we collapse the dataset to the segment level. This notebook would not be necessary if, for example, a user created a SLIIDERS-ECON alternative that was only indexed by segment.
2. [create-diaz-pyCIAM-inputs.ipynb](./create-diaz-pyCIAM-inputs.ipynb): This notebook generates a SLIIDERS-like input dataset that reflects the inputs used in [Diaz 2016](https://link.springer.com/article/10.1007/s10584-016-1675-4#Sec13). This is necessary for comparisons of results from the original CIAM paper to the updated version. These comparsions are performed and reported on in Depsky et al. 2022.
3. [create-slr-quantile.ipynb](./create-slr-quantile.ipynb): This notebook reduces the Monte Carlo-based SLIIDERS-SLR dataset to a set of quantiles defined in [shared.py](./shared.py) because these are all that are reported in Depsky et al. 2022. pyCIAM is also fully capable of running on the full set of Monte Carlo simulations from SLIIDERS-SLR, so users may choose to skip this step and point later notebooks to the raw SLIIDERS-SLR dataset.
4. *[create-surge-lookup-tables.ipynb](./create-surge-lookup-tables.ipynb): This notebook creates segment-adm1-specific lookup tables that estimate fraction of total capital stock lost and fraction of total population killed as a function of extreme sea level height. Computing these on the fly for a large number of SLR simulations is computationally intractable given the numerical integration needed, so lookup tables are used to enable these calculations.
5. [fit-movefactor.ipynb](./fit-movefactor.ipynb): This notebook performs the empirical estimation of the relocation cost parameter `movefactor`, as detailed in Depsky et al. 2022. It is purely for analysis and does not create any output datasets necessary for other notebooks.
6. *[run-pyCIAM-slrquantiles.ipynb](./run-pyCIAM-slrquantiles.ipynb): Run pyCIAM on the SLR quantile outputs from `create-slr-quantile.ipynb`.
7. [run-pyCIAM-diaz2016.ipynb](./run-pyCIAM-diaz2016.ipynb): Run pyCIAM using a configuration and parameter set analagous to that used in the original CIAM paper. These outputs are used for validation and comparison within Depsky et al. 2022.
8. [pyCIAM-results-figures.ipynb](./pyCIAM-results-figures.ipynb): This notebook generates numbers and figures used in Depsky et al. 2022.