/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.warnings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.ohdsi.circe.check.Warning;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.warnings.BaseWarning;
import org.ohdsi.circe.cohortdefinition.ConceptSet;

public class ConceptSetWarning
extends BaseWarning
implements Warning {
    private String template;
    private ConceptSet conceptSet;

    public ConceptSetWarning(WarningSeverity severity, String template, ConceptSet conceptSet) {
        super(severity);
        this.template = template;
        this.conceptSet = conceptSet;
    }

    @JsonIgnore
    public ConceptSet getConceptSet() {
        return this.conceptSet;
    }

    @JsonProperty(value="conceptSetId")
    public Integer getConceptSetId() {
        return Objects.nonNull(this.conceptSet) ? this.conceptSet.id : 0;
    }

    @Override
    public String toMessage() {
        return String.format(this.template, this.conceptSet.name);
    }
}

