/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.ObservationPeriod;
import org.ohdsi.circe.cohortdefinition.Period;
import org.ohdsi.circe.cohortdefinition.builders.BuilderOptions;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class ObservationPeriodSqlBuilder<T extends ObservationPeriod>
extends CriteriaSqlBuilder<T> {
    private static final String OBSERVATION_PERIOD_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/observationPeriod.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    public String getCriteriaSql(T criteria, BuilderOptions options) {
        String query = super.getCriteriaSql(criteria, options);
        String startDateExpression = ((ObservationPeriod)criteria).userDefinedPeriod != null && ((ObservationPeriod)criteria).userDefinedPeriod.startDate != null ? BuilderUtils.dateStringToSql(((ObservationPeriod)criteria).userDefinedPeriod.startDate) : "C.observation_period_start_date";
        query = StringUtils.replace((String)query, (String)"@startDateExpression", (String)startDateExpression);
        String endDateExpression = ((ObservationPeriod)criteria).userDefinedPeriod != null && ((ObservationPeriod)criteria).userDefinedPeriod.endDate != null ? BuilderUtils.dateStringToSql(((ObservationPeriod)criteria).userDefinedPeriod.endDate) : "C.observation_period_end_date";
        query = StringUtils.replace((String)query, (String)"@endDateExpression", (String)endDateExpression);
        return query;
    }

    @Override
    protected String getQueryTemplate() {
        return OBSERVATION_PERIOD_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.period_type_concept_id";
            }
            case DURATION: {
                return "DATEDIFF(d, @startDateExpression, @endDateExpression)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Observation Period:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return query;
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((ObservationPeriod)criteria).ageAtStart != null || ((ObservationPeriod)criteria).ageAtEnd != null) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((ObservationPeriod)criteria).first != null && ((ObservationPeriod)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
        }
        if (((ObservationPeriod)criteria).userDefinedPeriod != null) {
            Period userDefinedPeriod = ((ObservationPeriod)criteria).userDefinedPeriod;
            if (userDefinedPeriod.startDate != null) {
                String startDateExpression = BuilderUtils.dateStringToSql(userDefinedPeriod.startDate);
                whereClauses.add(String.format("C.OBSERVATION_PERIOD_START_DATE <= %s and C.OBSERVATION_PERIOD_END_DATE >= %s", startDateExpression, startDateExpression));
            }
            if (userDefinedPeriod.endDate != null) {
                String endDateExpression = BuilderUtils.dateStringToSql(userDefinedPeriod.endDate);
                whereClauses.add(String.format("C.OBSERVATION_PERIOD_START_DATE <= %s and C.OBSERVATION_PERIOD_END_DATE >= %s", endDateExpression, endDateExpression));
            }
        }
        if (((ObservationPeriod)criteria).periodStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.observation_period_start_date", ((ObservationPeriod)criteria).periodStartDate));
        }
        if (((ObservationPeriod)criteria).periodEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.observation_period_end_date", ((ObservationPeriod)criteria).periodEndDate));
        }
        if (((ObservationPeriod)criteria).periodType != null && ((ObservationPeriod)criteria).periodType.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((ObservationPeriod)criteria).periodType);
            whereClauses.add(String.format("C.period_type_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((ObservationPeriod)criteria).periodLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.observation_period_start_date, C.observation_period_end_date)", ((ObservationPeriod)criteria).periodLength));
        }
        if (((ObservationPeriod)criteria).ageAtStart != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.observation_period_start_date) - P.year_of_birth", ((ObservationPeriod)criteria).ageAtStart));
        }
        if (((ObservationPeriod)criteria).ageAtEnd != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.observation_period_end_date) - P.year_of_birth", ((ObservationPeriod)criteria).ageAtEnd));
        }
        return whereClauses;
    }
}

