/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class DeviceExposureSqlBuilder<T extends DeviceExposure>
extends CriteriaSqlBuilder<T> {
    private static final String DEVICE_EXPOSURE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/deviceExposure.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return DEVICE_EXPOSURE_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.device_concept_id";
            }
            case QUANTITY: {
                return "C.quantity";
            }
            case DURATION: {
                return "DATEDIFF(d,device_exposure_start_date, COALESCE(C.device_exposure_end_date, DATEADD(d,1,C.device_exposure_start_date)))";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Device Exposure:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((DeviceExposure)criteria).codesetId, "de.device_concept_id", ((DeviceExposure)criteria).deviceSourceConcept, "de.device_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((DeviceExposure)criteria).first != null && ((DeviceExposure)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY de.person_id ORDER BY de.device_exposure_start_date, de.device_exposure_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((DeviceExposure)criteria).age != null || ((DeviceExposure)criteria).gender != null && ((DeviceExposure)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((DeviceExposure)criteria).visitType != null && ((DeviceExposure)criteria).visitType.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.VISIT_OCCURRENCE V on C.visit_occurrence_id = V.visit_occurrence_id and C.person_id = V.person_id");
        }
        if (((DeviceExposure)criteria).providerSpecialty != null && ((DeviceExposure)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((DeviceExposure)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.device_exposure_start_date", ((DeviceExposure)criteria).occurrenceStartDate));
        }
        if (((DeviceExposure)criteria).occurrenceEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.device_exposure_end_date", ((DeviceExposure)criteria).occurrenceEndDate));
        }
        if (((DeviceExposure)criteria).deviceType != null && ((DeviceExposure)criteria).deviceType.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((DeviceExposure)criteria).deviceType);
            whereClauses.add(String.format("C.device_type_concept_id %s in (%s)", ((DeviceExposure)criteria).deviceTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((DeviceExposure)criteria).uniqueDeviceId != null) {
            whereClauses.add(BuilderUtils.buildTextFilterClause("C.unique_device_id", ((DeviceExposure)criteria).uniqueDeviceId));
        }
        if (((DeviceExposure)criteria).quantity != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.quantity", ((DeviceExposure)criteria).quantity));
        }
        if (((DeviceExposure)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.device_exposure_start_date) - P.year_of_birth", ((DeviceExposure)criteria).age));
        }
        if (((DeviceExposure)criteria).gender != null && ((DeviceExposure)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DeviceExposure)criteria).gender), (String)",")));
        }
        if (((DeviceExposure)criteria).providerSpecialty != null && ((DeviceExposure)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DeviceExposure)criteria).providerSpecialty), (String)",")));
        }
        if (((DeviceExposure)criteria).visitType != null && ((DeviceExposure)criteria).visitType.length > 0) {
            whereClauses.add(String.format("V.visit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DeviceExposure)criteria).visitType), (String)",")));
        }
        return whereClauses;
    }
}

