/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConceptSet;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.CriteriaGroup;
import org.ohdsi.circe.cohortdefinition.CustomEraStrategy;
import org.ohdsi.circe.cohortdefinition.DateOffsetStrategy;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.IGetCriteriaSqlDispatcher;
import org.ohdsi.circe.cohortdefinition.IGetEndStrategySqlDispatcher;
import org.ohdsi.circe.cohortdefinition.LocationRegion;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ObservationPeriod;
import org.ohdsi.circe.cohortdefinition.PayerPlanPeriod;
import org.ohdsi.circe.cohortdefinition.Period;
import org.ohdsi.circe.cohortdefinition.PrimaryCriteria;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;
import org.ohdsi.circe.cohortdefinition.Window;
import org.ohdsi.circe.cohortdefinition.WindowedCriteria;
import org.ohdsi.circe.cohortdefinition.builders.BuilderOptions;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.ConditionEraSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.ConditionOccurrenceSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.DeathSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.DeviceExposureSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.DoseEraSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.DrugEraSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.DrugExposureSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.LocationRegionSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.MeasurementSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.ObservationPeriodSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.ObservationSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.PayerPlanPeriodSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.ProcedureOccurrenceSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.SpecimenSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.VisitDetailSqlBuilder;
import org.ohdsi.circe.cohortdefinition.builders.VisitOccurrenceSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;
import org.ohdsi.circe.vocabulary.ConceptSetExpressionQueryBuilder;

public class CohortExpressionQueryBuilder
implements IGetCriteriaSqlDispatcher,
IGetEndStrategySqlDispatcher {
    private static final ConceptSetExpressionQueryBuilder conceptSetQueryBuilder = new ConceptSetExpressionQueryBuilder();
    private static final String CODESET_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/codesetQuery.sql");
    private static final String COHORT_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/generateCohort.sql");
    private static final String PRIMARY_EVENTS_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/primaryEventsQuery.sql");
    private static final String WINDOWED_CRITERIA_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/windowedCriteria.sql");
    private static final String ADDITIONAL_CRITERIA_INNER_TEMPLATE = StringUtils.replace((String)ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/additionalCriteriaInclude.sql"), (String)"@windowedCriteria", (String)WINDOWED_CRITERIA_TEMPLATE);
    private static final String ADDITIONAL_CRITERIA_LEFT_TEMPLATE = StringUtils.replace((String)ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/additionalCriteriaExclude.sql"), (String)"@windowedCriteria", (String)WINDOWED_CRITERIA_TEMPLATE);
    private static final String GROUP_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/groupQuery.sql");
    private static final String INCLUSION_RULE_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/inclusionrule.sql");
    private static final String INCLUSION_RULE_TEMP_TABLE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/inclusionRuleTempTable.sql");
    private static final String CENSORING_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/censoringInsert.sql");
    private static final String EVENT_TABLE_EXPRESSION_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/eventTableExpression.sql");
    private static final String DEMOGRAPHIC_CRITERIA_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/demographicCriteria.sql");
    private static final String COHORT_INCLUSION_ANALYSIS_TEMPALTE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/cohortInclusionAnalysis.sql");
    private static final String COHORT_CENSORED_STATS_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/cohortCensoredStats.sql");
    private static final String DATE_OFFSET_STRATEGY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/dateOffsetStrategy.sql");
    private static final String CUSTOM_ERA_STRATEGY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/customEraStrategy.sql");
    private static final String DEFAULT_DRUG_EXPOSURE_END_DATE_EXPRESSION = "COALESCE(DRUG_EXPOSURE_END_DATE, DATEADD(day,DAYS_SUPPLY,DRUG_EXPOSURE_START_DATE), DATEADD(day,1,DRUG_EXPOSURE_START_DATE))";
    private static final ConditionOccurrenceSqlBuilder<ConditionOccurrence> conditionOccurrenceSqlBuilder = new ConditionOccurrenceSqlBuilder();
    private static final DeathSqlBuilder<Death> deathSqlBuilder = new DeathSqlBuilder();
    private static final DeviceExposureSqlBuilder<DeviceExposure> deviceExposureSqlBuilder = new DeviceExposureSqlBuilder();
    private static final DoseEraSqlBuilder<DoseEra> doseEraSqlBuilder = new DoseEraSqlBuilder();
    private static final DrugEraSqlBuilder<DrugEra> drugEraSqlBuilder = new DrugEraSqlBuilder();
    private static final DrugExposureSqlBuilder<DrugExposure> drugExposureSqlBuilder = new DrugExposureSqlBuilder();
    private static final LocationRegionSqlBuilder<LocationRegion> locationRegionSqlBuilder = new LocationRegionSqlBuilder();
    private static final MeasurementSqlBuilder<Measurement> measurementSqlBuilder = new MeasurementSqlBuilder();
    private static final ObservationPeriodSqlBuilder<ObservationPeriod> observationPeriodSqlBuilder = new ObservationPeriodSqlBuilder();
    private static final ObservationSqlBuilder<Observation> observationSqlBuilder = new ObservationSqlBuilder();
    private static final PayerPlanPeriodSqlBuilder<PayerPlanPeriod> payerPlanPeriodSqlBuilder = new PayerPlanPeriodSqlBuilder();
    private static final ProcedureOccurrenceSqlBuilder<ProcedureOccurrence> procedureOccurrenceSqlBuilder = new ProcedureOccurrenceSqlBuilder();
    private static final SpecimenSqlBuilder<Specimen> specimenSqlBuilder = new SpecimenSqlBuilder();
    private static final VisitOccurrenceSqlBuilder<VisitOccurrence> visitOccurrenceSqlBuilder = new VisitOccurrenceSqlBuilder();
    private static final VisitDetailSqlBuilder<VisitDetail> visitDetailSqlBuilder = new VisitDetailSqlBuilder();
    private static final ConditionEraSqlBuilder<ConditionEra> conditionEraSqlBuilder = new ConditionEraSqlBuilder();
    private static final String DEFAULT_COHORT_ID_FIELD_NAME = "cohort_definition_id";

    private String getOccurrenceOperator(int type) {
        switch (type) {
            case 0: {
                return "=";
            }
            case 1: {
                return "<=";
            }
            case 2: {
                return ">=";
            }
        }
        throw new RuntimeException(String.format("Invalid occurrene operator recieved: type=%d.", type));
    }

    private String getAdditionalColumns(List<CriteriaColumn> columns, String prefix) {
        return String.join((CharSequence)",", columns.stream().map(column -> prefix + column.columnName()).collect(Collectors.toList()));
    }

    private String wrapCriteriaQuery(String query, CriteriaGroup group) {
        String eventQuery = StringUtils.replace((String)EVENT_TABLE_EXPRESSION_TEMPLATE, (String)"@eventQuery", (String)query);
        String groupQuery = this.getCriteriaGroupQuery(group, String.format("(%s)", eventQuery));
        groupQuery = StringUtils.replace((String)groupQuery, (String)"@indexId", (String)"0");
        String wrappedQuery = String.format("select PE.person_id, PE.event_id, PE.start_date, PE.end_date, PE.visit_occurrence_id, PE.sort_date FROM (\n%s\n) PE\nJOIN (\n%s) AC on AC.person_id = pe.person_id and AC.event_id = pe.event_id\n", query, groupQuery);
        return wrappedQuery;
    }

    public String getCodesetQuery(ConceptSet[] conceptSets) {
        if (conceptSets == null || conceptSets.length <= 0) {
            return StringUtils.replace((String)CODESET_QUERY_TEMPLATE, (String)"@codesetInserts", (String)"");
        }
        String unionSelectsQuery = Arrays.stream(conceptSets).map(cs -> String.format("SELECT %d as codeset_id, c.concept_id FROM (%s) C", cs.id, conceptSetQueryBuilder.buildExpressionQuery(cs.expression))).collect(Collectors.joining(" UNION ALL \n"));
        String queryWithInsert = StringUtils.replace((String)CODESET_QUERY_TEMPLATE, (String)"@codesetInserts", (String)("INSERT INTO #Codesets (codeset_id, concept_id)\n" + unionSelectsQuery));
        return queryWithInsert + ";";
    }

    private String getCensoringEventsQuery(Criteria[] censoringCriteria) {
        ArrayList<String> criteriaQueries = new ArrayList<String>();
        for (Criteria c : censoringCriteria) {
            String criteriaQuery = c.accept(this);
            criteriaQueries.add(StringUtils.replace((String)CENSORING_QUERY_TEMPLATE, (String)"@criteriaQuery", (String)criteriaQuery));
        }
        return StringUtils.join(criteriaQueries, (String)"\nUNION ALL\n");
    }

    public String getPrimaryEventsQuery(PrimaryCriteria primaryCriteria) {
        String query = PRIMARY_EVENTS_TEMPLATE;
        ArrayList<String> criteriaQueries = new ArrayList<String>();
        for (Criteria c : primaryCriteria.criteriaList) {
            criteriaQueries.add(c.accept(this));
        }
        query = StringUtils.replace((String)query, (String)"@criteriaQueries", (String)StringUtils.join(criteriaQueries, (String)"\nUNION ALL\n"));
        ArrayList<String> primaryEventsFilters = new ArrayList<String>();
        primaryEventsFilters.add(String.format("DATEADD(day,%d,OP.OBSERVATION_PERIOD_START_DATE) <= E.START_DATE AND DATEADD(day,%d,E.START_DATE) <= OP.OBSERVATION_PERIOD_END_DATE", primaryCriteria.observationWindow.priorDays, primaryCriteria.observationWindow.postDays));
        query = StringUtils.replace((String)query, (String)"@primaryEventsFilter", (String)StringUtils.join(primaryEventsFilters, (String)" AND "));
        query = StringUtils.replace((String)query, (String)"@EventSort", (String)(primaryCriteria.primaryLimit.type != null && primaryCriteria.primaryLimit.type.equalsIgnoreCase("LAST") ? "DESC" : "ASC"));
        query = StringUtils.replace((String)query, (String)"@primaryEventLimit", (String)(!primaryCriteria.primaryLimit.type.equalsIgnoreCase("ALL") ? "WHERE P.ordinal = 1" : ""));
        return query;
    }

    public String getFinalCohortQuery(Period censorWindow) {
        String query = "select @target_cohort_id as @cohort_id_field_name, person_id, @start_date, @end_date \nFROM #final_cohort CO";
        String startDate = "start_date";
        String endDate = "end_date";
        if (censorWindow != null && (censorWindow.startDate != null || censorWindow.endDate != null)) {
            if (censorWindow.startDate != null) {
                String censorStartDate = BuilderUtils.dateStringToSql(censorWindow.startDate);
                startDate = "CASE WHEN start_date > " + censorStartDate + " THEN start_date ELSE " + censorStartDate + " END";
            }
            if (censorWindow.endDate != null) {
                String censorEndDate = BuilderUtils.dateStringToSql(censorWindow.endDate);
                endDate = "CASE WHEN end_date < " + censorEndDate + " THEN end_date ELSE " + censorEndDate + " END";
            }
            query = query + "\nWHERE @start_date <= @end_date";
        }
        query = StringUtils.replace((String)query, (String)"@start_date", (String)startDate);
        query = StringUtils.replace((String)query, (String)"@end_date", (String)endDate);
        return query;
    }

    private String getInclusionRuleTableSql(CohortExpression expression) {
        String EMPTY_TABLE = "CREATE TABLE #inclusion_rules (rule_sequence int);";
        if (expression.inclusionRules.size() == 0) {
            return EMPTY_TABLE;
        }
        String UNION_TEMPLATE = "SELECT CAST(%d as int) as rule_sequence";
        List unionList = IntStream.range(0, expression.inclusionRules.size()).mapToObj(i -> String.format(UNION_TEMPLATE, i)).collect(Collectors.toList());
        return StringUtils.replace((String)INCLUSION_RULE_TEMP_TABLE_TEMPLATE, (String)"@inclusionRuleUnions", (String)StringUtils.join(unionList, (String)" UNION ALL "));
    }

    private String getInclusionAnalysisQuery(String eventTable, int modeId) {
        String resultSql = COHORT_INCLUSION_ANALYSIS_TEMPALTE;
        resultSql = StringUtils.replace((String)resultSql, (String)"@inclusionImpactMode", (String)Integer.toString(modeId));
        resultSql = StringUtils.replace((String)resultSql, (String)"@eventTable", (String)eventTable);
        return resultSql;
    }

    public String buildExpressionQuery(String expression, BuildExpressionQueryOptions options) {
        return this.buildExpressionQuery(CohortExpression.fromJson(expression), options);
    }

    public String buildExpressionQuery(CohortExpression expression, BuildExpressionQueryOptions options) {
        String resultSql = COHORT_QUERY_TEMPLATE;
        String codesetQuery = this.getCodesetQuery(expression.conceptSets);
        resultSql = StringUtils.replace((String)resultSql, (String)"@codesetQuery", (String)codesetQuery);
        String primaryEventsQuery = this.getPrimaryEventsQuery(expression.primaryCriteria);
        resultSql = StringUtils.replace((String)resultSql, (String)"@primaryEventsQuery", (String)primaryEventsQuery);
        String additionalCriteriaQuery = "";
        if (expression.additionalCriteria != null && !expression.additionalCriteria.isEmpty()) {
            CriteriaGroup acGroup = expression.additionalCriteria;
            String acGroupQuery = this.getCriteriaGroupQuery(acGroup, String.format("(%s)", primaryEventsQuery));
            acGroupQuery = StringUtils.replace((String)acGroupQuery, (String)"@indexId", (String)"0");
            additionalCriteriaQuery = "\nJOIN (\n" + acGroupQuery + ") AC on AC.person_id = pe.person_id and AC.event_id = pe.event_id\n";
        }
        resultSql = StringUtils.replace((String)resultSql, (String)"@additionalCriteriaQuery", (String)additionalCriteriaQuery);
        resultSql = StringUtils.replace((String)resultSql, (String)"@QualifiedEventSort", (String)(expression.qualifiedLimit.type != null && expression.qualifiedLimit.type.equalsIgnoreCase("LAST") ? "DESC" : "ASC"));
        resultSql = expression.additionalCriteria != null && expression.qualifiedLimit.type != null && !expression.qualifiedLimit.type.equalsIgnoreCase("ALL") ? StringUtils.replace((String)resultSql, (String)"@QualifiedLimitFilter", (String)"WHERE QE.ordinal = 1") : StringUtils.replace((String)resultSql, (String)"@QualifiedLimitFilter", (String)"");
        if (expression.inclusionRules.size() > 0) {
            ArrayList<String> inclusionRuleInserts = new ArrayList<String>();
            ArrayList<String> inclusionRuleTempTables = new ArrayList<String>();
            for (int i = 0; i < expression.inclusionRules.size(); ++i) {
                CriteriaGroup cg = expression.inclusionRules.get((int)i).expression;
                String inclusionRuleInsert = this.getInclusionRuleQuery(cg);
                inclusionRuleInsert = StringUtils.replace((String)inclusionRuleInsert, (String)"@inclusion_rule_id", (String)("" + i));
                inclusionRuleInserts.add(inclusionRuleInsert);
                inclusionRuleTempTables.add(String.format("#Inclusion_%d", i));
            }
            String irTempUnion = inclusionRuleTempTables.stream().map(d -> String.format("select inclusion_rule_id, person_id, event_id from %s", d)).collect(Collectors.joining("\nUNION ALL\n"));
            inclusionRuleInserts.add(String.format("SELECT inclusion_rule_id, person_id, event_id\nINTO #inclusion_events\nFROM (%s) I;", irTempUnion));
            inclusionRuleInserts.addAll(inclusionRuleTempTables.stream().map(d -> String.format("TRUNCATE TABLE %s;\nDROP TABLE %s;\n", d, d)).collect(Collectors.toList()));
            resultSql = StringUtils.replace((String)resultSql, (String)"@inclusionCohortInserts", (String)StringUtils.join(inclusionRuleInserts, (String)"\n"));
        } else {
            resultSql = StringUtils.replace((String)resultSql, (String)"@inclusionCohortInserts", (String)"create table #inclusion_events (inclusion_rule_id bigint,\n\tperson_id bigint,\n\tevent_id bigint\n);");
        }
        resultSql = StringUtils.replace((String)resultSql, (String)"@IncludedEventSort", (String)(expression.expressionLimit.type != null && expression.expressionLimit.type.equalsIgnoreCase("LAST") ? "DESC" : "ASC"));
        resultSql = expression.expressionLimit.type != null && !expression.expressionLimit.type.equalsIgnoreCase("ALL") ? StringUtils.replace((String)resultSql, (String)"@ResultLimitFilter", (String)"WHERE Results.ordinal = 1") : StringUtils.replace((String)resultSql, (String)"@ResultLimitFilter", (String)"");
        resultSql = StringUtils.replace((String)resultSql, (String)"@ruleTotal", (String)String.valueOf(expression.inclusionRules.size()));
        ArrayList<String> endDateSelects = new ArrayList<String>();
        if (!(expression.endStrategy instanceof DateOffsetStrategy)) {
            endDateSelects.add("-- By default, cohort exit at the event's op end date\nselect event_id, person_id, op_end_date as end_date from #included_events");
        }
        if (expression.endStrategy != null) {
            resultSql = StringUtils.replace((String)resultSql, (String)"@strategy_ends_temp_tables", (String)expression.endStrategy.accept(this, "#included_events"));
            resultSql = StringUtils.replace((String)resultSql, (String)"@strategy_ends_cleanup", (String)"TRUNCATE TABLE #strategy_ends;\nDROP TABLE #strategy_ends;\n");
            endDateSelects.add(String.format("-- End Date Strategy\n%s\n", "SELECT event_id, person_id, end_date from #strategy_ends"));
        } else {
            resultSql = StringUtils.replace((String)resultSql, (String)"@strategy_ends_temp_tables", (String)"");
            resultSql = StringUtils.replace((String)resultSql, (String)"@strategy_ends_cleanup", (String)"");
        }
        if (expression.censoringCriteria != null && expression.censoringCriteria.length > 0) {
            endDateSelects.add(String.format("-- Censor Events\n%s\n", this.getCensoringEventsQuery(expression.censoringCriteria)));
        }
        resultSql = StringUtils.replace((String)resultSql, (String)"@finalCohortQuery", (String)this.getFinalCohortQuery(expression.censorWindow));
        resultSql = StringUtils.replace((String)resultSql, (String)"@cohort_end_unions", (String)StringUtils.join(endDateSelects, (String)"\nUNION ALL\n"));
        resultSql = StringUtils.replace((String)resultSql, (String)"@eraconstructorpad", (String)Integer.toString(expression.collapseSettings.eraPad));
        resultSql = StringUtils.replace((String)resultSql, (String)"@inclusionRuleTable", (String)this.getInclusionRuleTableSql(expression));
        resultSql = StringUtils.replace((String)resultSql, (String)"@inclusionImpactAnalysisByEventQuery", (String)this.getInclusionAnalysisQuery("#qualified_events", 0));
        resultSql = StringUtils.replace((String)resultSql, (String)"@inclusionImpactAnalysisByPersonQuery", (String)this.getInclusionAnalysisQuery("#best_events", 1));
        resultSql = StringUtils.replace((String)resultSql, (String)"@cohortCensoredStatsQuery", (String)(expression.censorWindow != null && (!StringUtils.isEmpty((CharSequence)expression.censorWindow.startDate) || !StringUtils.isEmpty((CharSequence)expression.censorWindow.endDate)) ? COHORT_CENSORED_STATS_TEMPLATE : ""));
        if (options != null) {
            if (options.cdmSchema != null) {
                resultSql = StringUtils.replace((String)resultSql, (String)"@cdm_database_schema", (String)options.cdmSchema);
            }
            if (options.targetTable != null) {
                resultSql = StringUtils.replace((String)resultSql, (String)"@target_database_schema.@target_cohort_table", (String)options.targetTable);
            }
            if (options.resultSchema != null) {
                resultSql = StringUtils.replace((String)resultSql, (String)"@results_database_schema", (String)options.resultSchema);
            }
            if (options.vocabularySchema != null) {
                resultSql = StringUtils.replace((String)resultSql, (String)"@vocabulary_database_schema", (String)options.vocabularySchema);
            } else if (options.cdmSchema != null) {
                resultSql = StringUtils.replace((String)resultSql, (String)"@vocabulary_database_schema", (String)options.cdmSchema);
            }
            if (options.cohortId != null) {
                resultSql = StringUtils.replace((String)resultSql, (String)"@target_cohort_id", (String)options.cohortId.toString());
            }
            resultSql = StringUtils.replace((String)resultSql, (String)"@generateStats", (String)(options.generateStats ? "1" : "0"));
            resultSql = options.cohortIdFieldName != null ? StringUtils.replaceAll((String)resultSql, (String)"@cohort_id_field_name", (String)options.cohortIdFieldName) : StringUtils.replaceAll((String)resultSql, (String)"@cohort_id_field_name", (String)DEFAULT_COHORT_ID_FIELD_NAME);
        } else {
            resultSql = StringUtils.replaceAll((String)resultSql, (String)"@cohort_id_field_name", (String)DEFAULT_COHORT_ID_FIELD_NAME);
        }
        return resultSql;
    }

    public String getCriteriaGroupQuery(CriteriaGroup group, String eventTable) {
        String query = GROUP_QUERY_TEMPLATE;
        ArrayList<String> additionalCriteriaQueries = new ArrayList<String>();
        String joinType = "INNER";
        int indexId = 0;
        for (CorelatedCriteria cc : group.criteriaList) {
            String acQuery = this.getCorelatedlCriteriaQuery(cc, eventTable);
            acQuery = StringUtils.replace((String)acQuery, (String)"@indexId", (String)("" + indexId));
            additionalCriteriaQueries.add(acQuery);
            ++indexId;
        }
        for (DemographicCriteria dc : group.demographicCriteriaList) {
            String dcQuery = this.getDemographicCriteriaQuery(dc, eventTable);
            dcQuery = StringUtils.replace((String)dcQuery, (String)"@indexId", (String)("" + indexId));
            additionalCriteriaQueries.add(dcQuery);
            ++indexId;
        }
        for (CriteriaGroup g : group.groups) {
            String gQuery = this.getCriteriaGroupQuery(g, eventTable);
            gQuery = StringUtils.replace((String)gQuery, (String)"@indexId", (String)("" + indexId));
            additionalCriteriaQueries.add(gQuery);
            ++indexId;
        }
        if (!group.isEmpty()) {
            query = StringUtils.replace((String)query, (String)"@criteriaQueries", (String)StringUtils.join(additionalCriteriaQueries, (String)"\nUNION ALL\n"));
            String occurrenceCountClause = "HAVING COUNT(index_id) ";
            if (group.type.equalsIgnoreCase("ALL")) {
                occurrenceCountClause = occurrenceCountClause + "= " + indexId;
            }
            if (group.type.equalsIgnoreCase("ANY")) {
                occurrenceCountClause = occurrenceCountClause + "> 0";
            }
            if (group.type.toUpperCase().startsWith("AT_")) {
                if (group.type.toUpperCase().endsWith("LEAST")) {
                    occurrenceCountClause = occurrenceCountClause + ">= " + group.count;
                } else {
                    occurrenceCountClause = occurrenceCountClause + "<= " + group.count;
                    joinType = "LEFT";
                }
                if (group.count == 0) {
                    joinType = "LEFT";
                }
            }
            query = StringUtils.replace((String)query, (String)"@occurrenceCountClause", (String)occurrenceCountClause);
            query = StringUtils.replace((String)query, (String)"@joinType", (String)joinType);
        } else {
            query = "-- Begin Criteria Group\n select @indexId as index_id, person_id, event_id FROM @eventTable\n-- End Criteria Group\n";
        }
        query = StringUtils.replace((String)query, (String)"@eventTable", (String)eventTable);
        return query;
    }

    private String getInclusionRuleQuery(CriteriaGroup inclusionRule) {
        String resultSql = INCLUSION_RULE_QUERY_TEMPLATE;
        String additionalCriteriaQuery = "\nJOIN (\n" + this.getCriteriaGroupQuery(inclusionRule, "#qualified_events") + ") AC on AC.person_id = pe.person_id AND AC.event_id = pe.event_id";
        additionalCriteriaQuery = StringUtils.replace((String)additionalCriteriaQuery, (String)"@indexId", (String)"0");
        resultSql = StringUtils.replace((String)resultSql, (String)"@additionalCriteriaQuery", (String)additionalCriteriaQuery);
        return resultSql;
    }

    public String getDemographicCriteriaQuery(DemographicCriteria criteria, String eventTable) {
        String query = DEMOGRAPHIC_CRITERIA_QUERY_TEMPLATE;
        query = StringUtils.replace((String)query, (String)"@eventTable", (String)eventTable);
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (criteria.age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(E.start_date) - P.year_of_birth", criteria.age));
        }
        if (criteria.gender != null && criteria.gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(criteria.gender), (String)",")));
        }
        if (criteria.race != null && criteria.race.length > 0) {
            whereClauses.add(String.format("P.race_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(criteria.race), (String)",")));
        }
        if (criteria.race != null && criteria.race.length > 0) {
            whereClauses.add(String.format("P.race_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(criteria.race), (String)",")));
        }
        if (criteria.ethnicity != null && criteria.ethnicity.length > 0) {
            whereClauses.add(String.format("P.ethnicity_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(criteria.ethnicity), (String)",")));
        }
        if (criteria.occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("E.start_date", criteria.occurrenceStartDate));
        }
        if (criteria.occurrenceEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("E.end_date", criteria.occurrenceEndDate));
        }
        query = whereClauses.size() > 0 ? StringUtils.replace((String)query, (String)"@whereClause", (String)("WHERE " + StringUtils.join(whereClauses, (String)" AND "))) : StringUtils.replace((String)query, (String)"@whereClause", (String)"");
        return query;
    }

    public String getWindowedCriteriaQuery(String sqlTemplate, WindowedCriteria criteria, String eventTable, BuilderOptions options) {
        boolean restrictVisit;
        Window endWindow;
        String endExpression;
        String startExpression;
        String startEventDateExpression;
        String query = sqlTemplate;
        boolean checkObservationPeriod = !criteria.ignoreObservationPeriod;
        String criteriaQuery = criteria.criteria.accept(this, options);
        query = StringUtils.replace((String)query, (String)"@criteriaQuery", (String)criteriaQuery);
        query = StringUtils.replace((String)query, (String)"@eventTable", (String)eventTable);
        query = options != null && options.additionalColumns.size() > 0 ? StringUtils.replace((String)query, (String)"@additionalColumns", (String)(", " + this.getAdditionalColumns(options.additionalColumns, "A."))) : StringUtils.replace((String)query, (String)"@additionalColumns", (String)"");
        ArrayList<String> clauses = new ArrayList<String>();
        if (checkObservationPeriod) {
            clauses.add("A.START_DATE >= P.OP_START_DATE AND A.START_DATE <= P.OP_END_DATE");
        }
        Window startWindow = criteria.startWindow;
        String startIndexDateExpression = startWindow.useIndexEnd != null && startWindow.useIndexEnd != false ? "P.END_DATE" : "P.START_DATE";
        String string = startEventDateExpression = startWindow.useEventEnd != null && startWindow.useEventEnd != false ? "A.END_DATE" : "A.START_DATE";
        if (startWindow.start.days != null) {
            startExpression = String.format("DATEADD(day,%d,%s)", startWindow.start.coeff * startWindow.start.days, startIndexDateExpression);
        } else {
            String string2 = checkObservationPeriod ? (startWindow.start.coeff == -1 ? "P.OP_START_DATE" : "P.OP_END_DATE") : (startExpression = null);
        }
        if (startExpression != null) {
            clauses.add(String.format("%s >= %s", startEventDateExpression, startExpression));
        }
        if (startWindow.end.days != null) {
            endExpression = String.format("DATEADD(day,%d,%s)", startWindow.end.coeff * startWindow.end.days, startIndexDateExpression);
        } else {
            String string3 = checkObservationPeriod ? (startWindow.end.coeff == -1 ? "P.OP_START_DATE" : "P.OP_END_DATE") : (endExpression = null);
        }
        if (endExpression != null) {
            clauses.add(String.format("%s <= %s", startEventDateExpression, endExpression));
        }
        if ((endWindow = criteria.endWindow) != null) {
            String endEventDateExpression;
            String endIndexDateExpression = endWindow.useIndexEnd != null && endWindow.useIndexEnd != false ? "P.END_DATE" : "P.START_DATE";
            String string4 = endEventDateExpression = endWindow.useEventEnd == null || endWindow.useEventEnd != false ? "A.END_DATE" : "A.START_DATE";
            if (endWindow.start.days != null) {
                startExpression = String.format("DATEADD(day,%d,%s)", endWindow.start.coeff * endWindow.start.days, endIndexDateExpression);
            } else {
                String string5 = checkObservationPeriod ? (endWindow.start.coeff == -1 ? "P.OP_START_DATE" : "P.OP_END_DATE") : (startExpression = null);
            }
            if (startExpression != null) {
                clauses.add(String.format("%s >= %s", endEventDateExpression, startExpression));
            }
            if (endWindow.end.days != null) {
                endExpression = String.format("DATEADD(day,%d,%s)", endWindow.end.coeff * endWindow.end.days, endIndexDateExpression);
            } else {
                String string6 = checkObservationPeriod ? (endWindow.end.coeff == -1 ? "P.OP_START_DATE" : "P.OP_END_DATE") : (endExpression = null);
            }
            if (endExpression != null) {
                clauses.add(String.format("%s <= %s", endEventDateExpression, endExpression));
            }
        }
        if (restrictVisit = criteria.restrictVisit) {
            clauses.add("A.visit_occurrence_id = P.visit_occurrence_id");
        }
        query = StringUtils.replace((String)query, (String)"@windowCriteria", (String)(clauses.size() > 0 ? " AND " + StringUtils.join(clauses, (String)" AND ") : ""));
        return query;
    }

    public String getWindowedCriteriaQuery(WindowedCriteria criteria, String eventTable) {
        String query = this.getWindowedCriteriaQuery(WINDOWED_CRITERIA_TEMPLATE, criteria, eventTable, null);
        return query;
    }

    public String getWindowedCriteriaQuery(WindowedCriteria criteria, String eventTable, BuilderOptions options) {
        String query = this.getWindowedCriteriaQuery(WINDOWED_CRITERIA_TEMPLATE, criteria, eventTable, options);
        return query;
    }

    public String getCorelatedlCriteriaQuery(CorelatedCriteria corelatedCriteria, String eventTable) {
        String query = corelatedCriteria.occurrence.type == 1 || corelatedCriteria.occurrence.count == 0 ? ADDITIONAL_CRITERIA_LEFT_TEMPLATE : ADDITIONAL_CRITERIA_INNER_TEMPLATE;
        String countColumnExpression = "cc.event_id";
        BuilderOptions builderOptions = new BuilderOptions();
        if (corelatedCriteria.occurrence.isDistinct) {
            if (corelatedCriteria.occurrence.countColumn == null) {
                builderOptions.additionalColumns.add(CriteriaColumn.DOMAIN_CONCEPT);
                countColumnExpression = String.format("cc.%s", CriteriaColumn.DOMAIN_CONCEPT.columnName());
            } else {
                builderOptions.additionalColumns.add(corelatedCriteria.occurrence.countColumn);
                countColumnExpression = String.format("cc.%s", corelatedCriteria.occurrence.countColumn.columnName());
            }
        }
        query = this.getWindowedCriteriaQuery(query, corelatedCriteria, eventTable, builderOptions);
        String occurrenceCriteria = String.format("HAVING COUNT(%s%s) %s %d", corelatedCriteria.occurrence.isDistinct ? "DISTINCT " : "", countColumnExpression, this.getOccurrenceOperator(corelatedCriteria.occurrence.type), corelatedCriteria.occurrence.count);
        query = StringUtils.replace((String)query, (String)"@occurrenceCriteria", (String)occurrenceCriteria);
        return query;
    }

    protected <T extends Criteria> String getCriteriaSql(CriteriaSqlBuilder<T> builder, T criteria, BuilderOptions options) {
        String query = builder.getCriteriaSql(criteria, options);
        return this.processCorrelatedCriteria(query, criteria);
    }

    protected <T extends Criteria> String getCriteriaSql(CriteriaSqlBuilder<T> builder, T criteria) {
        return this.getCriteriaSql(builder, criteria, null);
    }

    protected String processCorrelatedCriteria(String query, Criteria criteria) {
        if (criteria.CorrelatedCriteria != null && !criteria.CorrelatedCriteria.isEmpty()) {
            query = this.wrapCriteriaQuery(query, criteria.CorrelatedCriteria);
        }
        return query;
    }

    @Override
    public String getCriteriaSql(ConditionEra criteria, BuilderOptions options) {
        return this.getCriteriaSql(conditionEraSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(ConditionOccurrence criteria, BuilderOptions options) {
        return this.getCriteriaSql(conditionOccurrenceSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(Death criteria, BuilderOptions options) {
        return this.getCriteriaSql(deathSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(DeviceExposure criteria, BuilderOptions options) {
        return this.getCriteriaSql(deviceExposureSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(DoseEra criteria, BuilderOptions options) {
        return this.getCriteriaSql(doseEraSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(DrugEra criteria, BuilderOptions options) {
        return this.getCriteriaSql(drugEraSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(DrugExposure criteria, BuilderOptions options) {
        return this.getCriteriaSql(drugExposureSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(Measurement criteria, BuilderOptions options) {
        return this.getCriteriaSql(measurementSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(Observation criteria, BuilderOptions options) {
        return this.getCriteriaSql(observationSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(ObservationPeriod criteria, BuilderOptions options) {
        return this.getCriteriaSql(observationPeriodSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(PayerPlanPeriod criteria, BuilderOptions options) {
        return this.getCriteriaSql(payerPlanPeriodSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(ProcedureOccurrence criteria, BuilderOptions options) {
        return this.getCriteriaSql(procedureOccurrenceSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(Specimen criteria, BuilderOptions options) {
        return this.getCriteriaSql(specimenSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(VisitOccurrence criteria, BuilderOptions options) {
        return this.getCriteriaSql(visitOccurrenceSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(VisitDetail criteria, BuilderOptions options) {
        return this.getCriteriaSql(visitDetailSqlBuilder, criteria, options);
    }

    @Override
    public String getCriteriaSql(LocationRegion criteria, BuilderOptions options) {
        return this.getCriteriaSql(locationRegionSqlBuilder, criteria, options);
    }

    private String getDateFieldForOffsetStrategy(DateOffsetStrategy.DateField dateField) {
        switch (dateField) {
            case StartDate: {
                return "start_date";
            }
            case EndDate: {
                return "end_date";
            }
        }
        return "start_date";
    }

    @Override
    public String getStrategySql(DateOffsetStrategy strat, String eventTable) {
        String strategySql = StringUtils.replace((String)DATE_OFFSET_STRATEGY_TEMPLATE, (String)"@eventTable", (String)eventTable);
        strategySql = StringUtils.replace((String)strategySql, (String)"@offset", (String)Integer.toString(strat.offset));
        strategySql = StringUtils.replace((String)strategySql, (String)"@dateField", (String)this.getDateFieldForOffsetStrategy(strat.dateField));
        return strategySql;
    }

    @Override
    public String getStrategySql(CustomEraStrategy strat, String eventTable) {
        if (strat.drugCodesetId == null) {
            throw new RuntimeException("Drug Codeset ID can not be NULL.");
        }
        String drugExposureEndDateExpression = DEFAULT_DRUG_EXPOSURE_END_DATE_EXPRESSION;
        if (strat.daysSupplyOverride != null) {
            drugExposureEndDateExpression = String.format("DATEADD(day,%d,DRUG_EXPOSURE_START_DATE)", strat.daysSupplyOverride);
        }
        String strategySql = StringUtils.replace((String)CUSTOM_ERA_STRATEGY_TEMPLATE, (String)"@eventTable", (String)eventTable);
        strategySql = StringUtils.replace((String)strategySql, (String)"@drugCodesetId", (String)strat.drugCodesetId.toString());
        strategySql = StringUtils.replace((String)strategySql, (String)"@gapDays", (String)Integer.toString(strat.gapDays));
        strategySql = StringUtils.replace((String)strategySql, (String)"@offset", (String)Integer.toString(strat.offset));
        strategySql = StringUtils.replace((String)strategySql, (String)"@drugExposureEndDateExpression", (String)drugExposureEndDateExpression);
        return strategySql;
    }

    public static class BuildExpressionQueryOptions {
        private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
        @JsonProperty(value="cohortIdFieldName")
        public String cohortIdFieldName;
        @JsonProperty(value="cohortId")
        public Integer cohortId;
        @JsonProperty(value="cdmSchema")
        public String cdmSchema;
        @JsonProperty(value="targetTable")
        public String targetTable;
        @JsonProperty(value="resultSchema")
        public String resultSchema;
        @JsonProperty(value="vocabularySchema")
        public String vocabularySchema;
        @JsonProperty(value="generateStats")
        public boolean generateStats;

        public static BuildExpressionQueryOptions fromJson(String json) {
            try {
                BuildExpressionQueryOptions options = (BuildExpressionQueryOptions)JSON_MAPPER.readValue(json, BuildExpressionQueryOptions.class);
                return options;
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing expression query options", e);
            }
        }
    }
}

