/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.PayerPlanPeriod;
import org.ohdsi.circe.cohortdefinition.Period;
import org.ohdsi.circe.cohortdefinition.builders.BuilderOptions;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class PayerPlanPeriodSqlBuilder<T extends PayerPlanPeriod>
extends CriteriaSqlBuilder<T> {
    private static final String PAYER_PLAN_PERIOD_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/payerPlanPeriod.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    public String getCriteriaSql(T criteria, BuilderOptions options) {
        String query = super.getCriteriaSql(criteria, options);
        String startDateExpression = ((PayerPlanPeriod)criteria).userDefinedPeriod != null && ((PayerPlanPeriod)criteria).userDefinedPeriod.startDate != null ? BuilderUtils.dateStringToSql(((PayerPlanPeriod)criteria).userDefinedPeriod.startDate) : "C.payer_plan_period_start_date";
        query = StringUtils.replace((String)query, (String)"@startDateExpression", (String)startDateExpression);
        String endDateExpression = ((PayerPlanPeriod)criteria).userDefinedPeriod != null && ((PayerPlanPeriod)criteria).userDefinedPeriod.endDate != null ? BuilderUtils.dateStringToSql(((PayerPlanPeriod)criteria).userDefinedPeriod.endDate) : "C.payer_plan_period_end_date";
        query = StringUtils.replace((String)query, (String)"@endDateExpression", (String)endDateExpression);
        return query;
    }

    @Override
    protected String getQueryTemplate() {
        return PAYER_PLAN_PERIOD_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.payer_concept_id";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Payer Plan Period:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return query;
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((PayerPlanPeriod)criteria).ageAtStart != null || ((PayerPlanPeriod)criteria).ageAtEnd != null || ((PayerPlanPeriod)criteria).gender != null && ((PayerPlanPeriod)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((PayerPlanPeriod)criteria).first != null && ((PayerPlanPeriod)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
        }
        if (((PayerPlanPeriod)criteria).userDefinedPeriod != null) {
            Period userDefinedPeriod = ((PayerPlanPeriod)criteria).userDefinedPeriod;
            if (userDefinedPeriod.startDate != null) {
                String startDateExpression = BuilderUtils.dateStringToSql(userDefinedPeriod.startDate);
                whereClauses.add(String.format("C.PAYER_PLAN_PERIOD_START_DATE <= %s and C.PAYER_PLAN_PERIOD_END_DATE >= %s", startDateExpression, startDateExpression));
            }
            if (userDefinedPeriod.endDate != null) {
                String endDateExpression = BuilderUtils.dateStringToSql(userDefinedPeriod.endDate);
                whereClauses.add(String.format("C.PAYER_PLAN_PERIOD_START_DATE <= %s and C.PAYER_PLAN_PERIOD_END_DATE >= %s", endDateExpression, endDateExpression));
            }
        }
        if (((PayerPlanPeriod)criteria).periodStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.payer_plan_period_start_date", ((PayerPlanPeriod)criteria).periodStartDate));
        }
        if (((PayerPlanPeriod)criteria).periodEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.payer_plan_period_end_date", ((PayerPlanPeriod)criteria).periodEndDate));
        }
        if (((PayerPlanPeriod)criteria).periodLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.payer_plan_period_start_date, C.payer_plan_period_end_date)", ((PayerPlanPeriod)criteria).periodLength));
        }
        if (((PayerPlanPeriod)criteria).ageAtStart != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.payer_plan_period_start_date) - P.year_of_birth", ((PayerPlanPeriod)criteria).ageAtStart));
        }
        if (((PayerPlanPeriod)criteria).ageAtEnd != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.payer_plan_period_end_date) - P.year_of_birth", ((PayerPlanPeriod)criteria).ageAtEnd));
        }
        if (((PayerPlanPeriod)criteria).gender != null && ((PayerPlanPeriod)criteria).gender.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((PayerPlanPeriod)criteria).gender);
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((PayerPlanPeriod)criteria).payerConcept != null) {
            whereClauses.add(String.format("C.payer_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).payerConcept));
        }
        if (((PayerPlanPeriod)criteria).planConcept != null) {
            whereClauses.add(String.format("C.plan_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).planConcept));
        }
        if (((PayerPlanPeriod)criteria).sponsorConcept != null) {
            whereClauses.add(String.format("C.sponsor_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).sponsorConcept));
        }
        if (((PayerPlanPeriod)criteria).stopReasonConcept != null) {
            whereClauses.add(String.format("C.stop_reason_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).stopReasonConcept));
        }
        if (((PayerPlanPeriod)criteria).payerSourceConcept != null) {
            whereClauses.add(String.format("C.payer_source_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).payerSourceConcept));
        }
        if (((PayerPlanPeriod)criteria).planSourceConcept != null) {
            whereClauses.add(String.format("C.plan_source_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).planSourceConcept));
        }
        if (((PayerPlanPeriod)criteria).sponsorSourceConcept != null) {
            whereClauses.add(String.format("C.sponsor_source_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).sponsorSourceConcept));
        }
        if (((PayerPlanPeriod)criteria).stopReasonSourceConcept != null) {
            whereClauses.add(String.format("C.stop_reason_source_concept_id in (SELECT concept_id from #Codesets where codeset_id = %d)", ((PayerPlanPeriod)criteria).stopReasonSourceConcept));
        }
        return whereClauses;
    }
}

