/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class MeasurementSqlBuilder<T extends Measurement>
extends CriteriaSqlBuilder<T> {
    private static final String MEASUREMENT_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/measurement.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return MEASUREMENT_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.measurement_concept_id";
            }
            case DURATION: {
                return "CAST(1 as int)";
            }
            case VALUE_AS_NUMBER: {
                return "C.value_as_number";
            }
            case RANGE_HIGH: {
                return "C.range_high";
            }
            case RANGE_LOW: {
                return "C.range_low";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Measurement:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((Measurement)criteria).codesetId, "m.measurement_concept_id", ((Measurement)criteria).measurementSourceConcept, "m.measurement_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((Measurement)criteria).first != null && ((Measurement)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY m.person_id ORDER BY m.measurement_date, m.measurement_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((Measurement)criteria).age != null || ((Measurement)criteria).gender != null && ((Measurement)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((Measurement)criteria).visitType != null && ((Measurement)criteria).visitType.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.VISIT_OCCURRENCE V on C.visit_occurrence_id = V.visit_occurrence_id and C.person_id = V.person_id");
        }
        if (((Measurement)criteria).providerSpecialty != null && ((Measurement)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<Long> conceptIds;
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((Measurement)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.measurement_date", ((Measurement)criteria).occurrenceStartDate));
        }
        if (((Measurement)criteria).measurementType != null && ((Measurement)criteria).measurementType.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).measurementType);
            whereClauses.add(String.format("C.measurement_type_concept_id %s in (%s)", ((Measurement)criteria).measurementTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Measurement)criteria).operator != null && ((Measurement)criteria).operator.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).operator);
            whereClauses.add(String.format("C.operator_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Measurement)criteria).valueAsNumber != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.value_as_number", ((Measurement)criteria).valueAsNumber, ".4f"));
        }
        if (((Measurement)criteria).valueAsConcept != null && ((Measurement)criteria).valueAsConcept.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).valueAsConcept);
            whereClauses.add(String.format("C.value_as_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Measurement)criteria).unit != null && ((Measurement)criteria).unit.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).unit);
            whereClauses.add(String.format("C.unit_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Measurement)criteria).rangeLow != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.range_low", ((Measurement)criteria).rangeLow, ".4f"));
        }
        if (((Measurement)criteria).rangeHigh != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.range_high", ((Measurement)criteria).rangeHigh, ".4f"));
        }
        if (((Measurement)criteria).rangeLowRatio != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("(C.value_as_number / NULLIF(C.range_low, 0))", ((Measurement)criteria).rangeLowRatio, ".4f"));
        }
        if (((Measurement)criteria).rangeHighRatio != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("(C.value_as_number / NULLIF(C.range_high, 0))", ((Measurement)criteria).rangeHighRatio, ".4f"));
        }
        if (((Measurement)criteria).abnormal != null && ((Measurement)criteria).abnormal.booleanValue()) {
            whereClauses.add("(C.value_as_number < C.range_low or C.value_as_number > C.range_high or C.value_as_concept_id in (4155142, 4155143))");
        }
        if (((Measurement)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.measurement_date) - P.year_of_birth", ((Measurement)criteria).age));
        }
        if (((Measurement)criteria).gender != null && ((Measurement)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).gender), (String)",")));
        }
        if (((Measurement)criteria).providerSpecialty != null && ((Measurement)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).providerSpecialty), (String)",")));
        }
        if (((Measurement)criteria).visitType != null && ((Measurement)criteria).visitType.length > 0) {
            whereClauses.add(String.format("V.visit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Measurement)criteria).visitType), (String)",")));
        }
        return whereClauses;
    }
}

