/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class VisitOccurrenceSqlBuilder<T extends VisitOccurrence>
extends CriteriaSqlBuilder<T> {
    private static final String VISIT_OCCURRENCE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/visitOccurrence.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return VISIT_OCCURRENCE_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.visit_concept_id";
            }
            case DURATION: {
                return "DATEDIFF(d, C.visit_start_date, C.visit_end_date)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Visit Occurrence:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((VisitOccurrence)criteria).codesetId, "vo.visit_concept_id", ((VisitOccurrence)criteria).visitSourceConcept, "vo.visit_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((VisitOccurrence)criteria).first != null && ((VisitOccurrence)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY vo.person_id ORDER BY vo.visit_start_date, vo.visit_occurrence_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((VisitOccurrence)criteria).age != null || ((VisitOccurrence)criteria).gender != null && ((VisitOccurrence)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((VisitOccurrence)criteria).placeOfService != null && ((VisitOccurrence)criteria).placeOfService.length > 0 || ((VisitOccurrence)criteria).placeOfServiceLocation != null) {
            joinClauses.add("JOIN @cdm_database_schema.CARE_SITE CS on C.care_site_id = CS.care_site_id");
        }
        if (((VisitOccurrence)criteria).providerSpecialty != null && ((VisitOccurrence)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        if (((VisitOccurrence)criteria).placeOfServiceLocation != null) {
            this.addFilteringByCareSiteLocationRegion(joinClauses, ((VisitOccurrence)criteria).placeOfServiceLocation);
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((VisitOccurrence)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.visit_start_date", ((VisitOccurrence)criteria).occurrenceStartDate));
        }
        if (((VisitOccurrence)criteria).occurrenceEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.visit_end_date", ((VisitOccurrence)criteria).occurrenceEndDate));
        }
        if (((VisitOccurrence)criteria).visitType != null && ((VisitOccurrence)criteria).visitType.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((VisitOccurrence)criteria).visitType);
            whereClauses.add(String.format("C.visit_type_concept_id %s in (%s)", ((VisitOccurrence)criteria).visitTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((VisitOccurrence)criteria).visitLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.visit_start_date, C.visit_end_date)", ((VisitOccurrence)criteria).visitLength));
        }
        if (((VisitOccurrence)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.visit_start_date) - P.year_of_birth", ((VisitOccurrence)criteria).age));
        }
        if (((VisitOccurrence)criteria).gender != null && ((VisitOccurrence)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((VisitOccurrence)criteria).gender), (String)",")));
        }
        if (((VisitOccurrence)criteria).providerSpecialty != null && ((VisitOccurrence)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((VisitOccurrence)criteria).providerSpecialty), (String)",")));
        }
        if (((VisitOccurrence)criteria).placeOfService != null && ((VisitOccurrence)criteria).placeOfService.length > 0) {
            whereClauses.add(String.format("CS.place_of_service_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((VisitOccurrence)criteria).placeOfService), (String)",")));
        }
        return whereClauses;
    }

    protected void addFilteringByCareSiteLocationRegion(List<String> joinClauses, Integer codesetId) {
        joinClauses.add(this.getLocationHistoryJoin("LH", "CARE_SITE", "C.care_site_id"));
        joinClauses.add("JOIN @cdm_database_schema.LOCATION LOC on LOC.location_id = LH.location_id");
        joinClauses.add(BuilderUtils.getCodesetJoinExpression(codesetId, "LOC.region_concept_id", null, null));
    }

    protected String getLocationHistoryJoin(String alias, String domain, String entityIdField) {
        return "JOIN @cdm_database_schema.LOCATION_HISTORY " + alias + " on " + alias + ".entity_id = " + entityIdField + " AND " + alias + ".domain_id = '" + domain + "' AND C.visit_start_date >= " + alias + ".start_date AND C.visit_end_date <= ISNULL(" + alias + ".end_date, DATEFROMPARTS(2099,12,31))";
    }
}

