/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.vocabulary;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.helper.ResourceHelper;
import org.ohdsi.circe.vocabulary.Concept;
import org.ohdsi.circe.vocabulary.ConceptSetExpression;

public class ConceptSetExpressionQueryBuilder {
    private static final String CONCEPT_SET_QUERY_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/vocabulary/sql/conceptSetQuery.sql");
    private static final String CONCEPT_SET_DESCENDANTS_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/vocabulary/sql/conceptSetDescendants.sql");
    private static final String CONCEPT_SET_MAPPED_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/vocabulary/sql/conceptSetMapped.sql");
    private static final String CONCEPT_SET_INCLUDE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/vocabulary/sql/conceptSetInclude.sql");
    private static final String CONCEPT_SET_EXCLUDE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/vocabulary/sql/conceptSetExclude.sql");

    private ArrayList<Long> getConceptIds(ArrayList<Concept> concepts) {
        ArrayList<Long> conceptIdList = new ArrayList<Long>();
        for (Concept concept : concepts) {
            conceptIdList.add(concept.conceptId);
        }
        return conceptIdList;
    }

    private String buildConceptSetSubQuery(ArrayList<Concept> concepts, ArrayList<Concept> descendantConcepts) {
        ArrayList<String> queries = new ArrayList<String>();
        if (concepts.size() > 0) {
            queries.add(StringUtils.replace((String)CONCEPT_SET_QUERY_TEMPLATE, (String)"@conceptIds", (String)StringUtils.join(this.getConceptIds(concepts), (String)",")));
        }
        if (descendantConcepts.size() > 0) {
            queries.add(StringUtils.replace((String)CONCEPT_SET_DESCENDANTS_TEMPLATE, (String)"@conceptIds", (String)StringUtils.join(this.getConceptIds(descendantConcepts), (String)",")));
        }
        return StringUtils.join(queries, (String)"UNION");
    }

    private String buildConceptSetMappedQuery(ArrayList<Concept> mappedConcepts, ArrayList<Concept> mappedDescendantConcepts) {
        String conceptSetQuery = this.buildConceptSetSubQuery(mappedConcepts, mappedDescendantConcepts);
        return StringUtils.replace((String)CONCEPT_SET_MAPPED_TEMPLATE, (String)"@conceptsetQuery", (String)conceptSetQuery);
    }

    private String buildConceptSetQuery(ArrayList<Concept> concepts, ArrayList<Concept> descendantConcepts, ArrayList<Concept> mappedConcepts, ArrayList<Concept> mappedDesandantConcepts) {
        if (concepts.size() == 0) {
            return "select concept_id from @vocabulary_database_schema.CONCEPT where 0=1";
        }
        String conceptSetQuery = this.buildConceptSetSubQuery(concepts, descendantConcepts);
        if (mappedConcepts.size() > 0 || mappedDesandantConcepts.size() > 0) {
            this.buildConceptSetMappedQuery(mappedConcepts, mappedDesandantConcepts);
            conceptSetQuery = conceptSetQuery + "UNION\n" + this.buildConceptSetMappedQuery(mappedConcepts, mappedDesandantConcepts);
        }
        return conceptSetQuery;
    }

    public String buildExpressionQuery(ConceptSetExpression expression) {
        ArrayList<Concept> includeConcepts = new ArrayList<Concept>();
        ArrayList<Concept> includeDescendantConcepts = new ArrayList<Concept>();
        ArrayList<Concept> includeMappedConcepts = new ArrayList<Concept>();
        ArrayList<Concept> includeMappedDescendantConcepts = new ArrayList<Concept>();
        ArrayList<Concept> excludeConcepts = new ArrayList<Concept>();
        ArrayList<Concept> excludeDescendantConcepts = new ArrayList<Concept>();
        ArrayList<Concept> excludeMappedConcepts = new ArrayList<Concept>();
        ArrayList<Concept> excludeMappedDescendantConcepts = new ArrayList<Concept>();
        for (ConceptSetExpression.ConceptSetItem item : expression.items) {
            if (!item.isExcluded) {
                includeConcepts.add(item.concept);
                if (item.includeDescendants) {
                    includeDescendantConcepts.add(item.concept);
                }
                if (!item.includeMapped) continue;
                includeMappedConcepts.add(item.concept);
                if (!item.includeDescendants) continue;
                includeMappedDescendantConcepts.add(item.concept);
                continue;
            }
            excludeConcepts.add(item.concept);
            if (item.includeDescendants) {
                excludeDescendantConcepts.add(item.concept);
            }
            if (!item.includeMapped) continue;
            excludeMappedConcepts.add(item.concept);
            if (!item.includeDescendants) continue;
            excludeMappedDescendantConcepts.add(item.concept);
        }
        String conceptSetQuery = StringUtils.replace((String)CONCEPT_SET_INCLUDE_TEMPLATE, (String)"@includeQuery", (String)this.buildConceptSetQuery(includeConcepts, includeDescendantConcepts, includeMappedConcepts, includeMappedDescendantConcepts));
        if (excludeConcepts.size() > 0) {
            String excludeConceptsQuery = StringUtils.replace((String)CONCEPT_SET_EXCLUDE_TEMPLATE, (String)"@excludeQuery", (String)this.buildConceptSetQuery(excludeConcepts, excludeDescendantConcepts, excludeMappedConcepts, excludeMappedDescendantConcepts));
            conceptSetQuery = conceptSetQuery + excludeConceptsQuery;
        }
        return conceptSetQuery;
    }
}

