/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.analysis.versioning;

import com.google.common.base.MoreObjects;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.ohdsi.analysis.versioning.CdmCompatibilitySpec;
import org.ohdsi.analysis.versioning.CdmVersion;
import org.ohdsi.analysis.versioning.IncompatibleVersionsException;
import org.ohdsi.analysis.versioning.SemverUtils;

public class CdmVersionUtils {
    private static final String VERSION_X_RANGE = "*";

    public static void determineCdmCompatibility(CdmCompatibilitySpec compatibilitySpec) {
        compatibilitySpec.setCdmVersionRange((String)MoreObjects.firstNonNull((Object)compatibilitySpec.getCdmVersionRange(), (Object)VERSION_X_RANGE));
        HashMap<String, String> derivedCdmRanges = new HashMap<String, String>();
        CdmVersionUtils.resolveCdmRanges(derivedCdmRanges, null, compatibilitySpec);
        if (derivedCdmRanges.size() > 0) {
            String derivedIntersection = SemverUtils.getRangesIntersection(new ArrayList<String>(derivedCdmRanges.values()));
            if (derivedIntersection == null) {
                throw new IncompatibleVersionsException("Selected parameters don't have a common compatible CDM range");
            }
            if (!compatibilitySpec.getCdmVersionRange().equals(VERSION_X_RANGE)) {
                String overallIntersection = SemverUtils.getRangesIntersection(Arrays.asList(compatibilitySpec.getCdmVersionRange(), derivedIntersection));
                if (overallIntersection == null) {
                    throw new IncompatibleVersionsException(String.format("User-defined CDM range (%s) does not include derived CDM range (%s)", compatibilitySpec.getCdmVersionRange(), derivedIntersection));
                }
                compatibilitySpec.setCdmVersionRange(overallIntersection);
            } else {
                compatibilitySpec.setCdmVersionRange(derivedIntersection);
            }
        }
    }

    private static void resolveCdmRanges(Map<String, String> ranges, String path, Object obj) {
        try {
            String r = CdmVersionUtils.parseCdmRange(obj.getClass());
            if (r != null) {
                ranges.put(CdmVersionUtils.rangeKey(obj.getClass().getSimpleName(), null, path), r);
            }
            for (Field field : obj.getClass().getFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) continue;
                String fieldPath = CdmVersionUtils.joinPath(path, field);
                r = CdmVersionUtils.parseCdmRange(field);
                if (r != null) {
                    ranges.put(CdmVersionUtils.rangeKey(obj.getClass().getSimpleName(), field.getName(), fieldPath), r);
                }
                if (ClassUtils.isPrimitiveOrWrapper(field.getType()) || value instanceof Enum || value instanceof String) continue;
                if (value instanceof Object[]) {
                    int i = 0;
                    for (Object v2 : (Object[])value) {
                        CdmVersionUtils.resolveCdmRanges(ranges, CdmVersionUtils.joinPathIdx(fieldPath, i++), v2);
                    }
                    continue;
                }
                if (value instanceof Iterable) {
                    int[] idx = new int[]{0};
                    ((Iterable)value).forEach(v -> {
                        int n = idx[0];
                        idx[0] = n + 1;
                        CdmVersionUtils.resolveCdmRanges(ranges, CdmVersionUtils.joinPathIdx(fieldPath, n), v);
                    });
                    continue;
                }
                CdmVersionUtils.resolveCdmRanges(ranges, fieldPath, value);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String joinPath(String path, Field field) {
        return CdmVersionUtils.joinPath(path, field.getName());
    }

    private static String joinPathIdx(String path, int i) {
        return path + "[" + i + "]";
    }

    private static String joinPath(String path, String crumb) {
        return Arrays.asList(path, crumb).stream().filter(Objects::nonNull).collect(Collectors.joining("."));
    }

    private static String parseCdmRange(AnnotatedElement element) {
        CdmVersion cdmVersion = element.getAnnotation(CdmVersion.class);
        return cdmVersion != null ? cdmVersion.range() : null;
    }

    private static String rangeKey(String clazz, String prop, String path) {
        return clazz + (prop != null ? "." + prop : "") + " (" + path + ")";
    }
}

