/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class DoseEraSqlBuilder<T extends DoseEra>
extends CriteriaSqlBuilder<T> {
    private static final String DOSE_ERA_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/doseEra.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return DOSE_ERA_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.drug_concept_id";
            }
            case DURATION: {
                return "DATEDIFF(d, C.dose_era_start_date, C.dose_era_end_date)";
            }
            case UNIT: {
                return "C.unit_concept_id";
            }
            case VALUE_AS_NUMBER: {
                return "C.dose_value";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Device Exposure:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        String codesetClause = "";
        if (((DoseEra)criteria).codesetId != null) {
            codesetClause = String.format("where de.drug_concept_id in (SELECT concept_id from  #Codesets where codeset_id = %d)", ((DoseEra)criteria).codesetId);
        }
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)codesetClause);
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((DoseEra)criteria).first != null && ((DoseEra)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY de.person_id ORDER BY de.dose_era_start_date, de.dose_era_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((DoseEra)criteria).ageAtStart != null || ((DoseEra)criteria).ageAtEnd != null || ((DoseEra)criteria).gender != null && ((DoseEra)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((DoseEra)criteria).eraStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.dose_era_start_date", ((DoseEra)criteria).eraStartDate));
        }
        if (((DoseEra)criteria).eraEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.dose_era_end_date", ((DoseEra)criteria).eraEndDate));
        }
        if (((DoseEra)criteria).unit != null && ((DoseEra)criteria).unit.length > 0) {
            whereClauses.add(String.format("c.unit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DoseEra)criteria).unit), (String)",")));
        }
        if (((DoseEra)criteria).doseValue != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("c.dose_value", ((DoseEra)criteria).doseValue, ".4f"));
        }
        if (((DoseEra)criteria).eraLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.dose_era_start_date, C.dose_era_end_date)", ((DoseEra)criteria).eraLength));
        }
        if (((DoseEra)criteria).ageAtStart != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.dose_era_start_date) - P.year_of_birth", ((DoseEra)criteria).ageAtStart));
        }
        if (((DoseEra)criteria).ageAtEnd != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.dose_era_end_date) - P.year_of_birth", ((DoseEra)criteria).ageAtEnd));
        }
        if (((DoseEra)criteria).gender != null && ((DoseEra)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((DoseEra)criteria).gender), (String)",")));
        }
        return whereClauses;
    }
}

