# Changelog

## [v2.2.5](https://github.com/btschwertfeger/python-cmethods/tree/v2.2.5) (2024-05-28)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.2.4...v2.2.5)

**Merged pull requests:**

- Bump codecov/codecov-action from 4.4.0 to 4.4.1 [\#108](https://github.com/btschwertfeger/python-cmethods/pull/108) ([dependabot[bot]](https://github.com/apps/dependabot))
- Adjust the DQM formula [\#107](https://github.com/btschwertfeger/python-cmethods/pull/107) ([btschwertfeger](https://github.com/btschwertfeger))
- Fix the --version flag [\#106](https://github.com/btschwertfeger/python-cmethods/pull/106) ([btschwertfeger](https://github.com/btschwertfeger))
- Bump codecov/codecov-action from 4.3.1 to 4.4.0 [\#105](https://github.com/btschwertfeger/python-cmethods/pull/105) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dependabot/fetch-metadata from 1.1.1 to 2.1.0 [\#104](https://github.com/btschwertfeger/python-cmethods/pull/104) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 4.1.5 to 4.1.6 [\#103](https://github.com/btschwertfeger/python-cmethods/pull/103) ([dependabot[bot]](https://github.com/apps/dependabot))

## [v2.2.4](https://github.com/btschwertfeger/python-cmethods/tree/v2.2.4) (2024-05-20)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.2.3...v2.2.4)

**Fixed bugs:**

- QDM not working with longer simp length [\#101](https://github.com/btschwertfeger/python-cmethods/issues/101)

**Merged pull requests:**

- Resolve "QDM not working with longer simp length" [\#102](https://github.com/btschwertfeger/python-cmethods/pull/102) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.2.3](https://github.com/btschwertfeger/python-cmethods/tree/v2.2.3) (2024-05-17)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.2.2...v2.2.3)

**Fixed bugs:**

- A very small error [\#95](https://github.com/btschwertfeger/python-cmethods/issues/95)
- The behavior for data sets with different temporal resolution are not uniform [\#99](https://github.com/btschwertfeger/python-cmethods/issues/99)

**Merged pull requests:**

- Bump actions/checkout from 4.1.4 to 4.1.5 [\#98](https://github.com/btschwertfeger/python-cmethods/pull/98) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ossf/scorecard-action from 2.3.1 to 2.3.3 [\#97](https://github.com/btschwertfeger/python-cmethods/pull/97) ([dependabot[bot]](https://github.com/apps/dependabot))
- Resolve "The behavior for data sets with different temporal resolution are not uniform" [\#100](https://github.com/btschwertfeger/python-cmethods/pull/100) ([btschwertfeger](https://github.com/btschwertfeger))
- Extend the documentation [\#96](https://github.com/btschwertfeger/python-cmethods/pull/96) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.2.2](https://github.com/btschwertfeger/python-cmethods/tree/v2.2.2) (2024-05-07)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.2.1...v2.2.2)

**Implemented enhancements:**

- Add python-cmethods to the conda registry [\#17](https://github.com/btschwertfeger/python-cmethods/issues/17)

**Merged pull requests:**

- Bump codecov/codecov-action from 4.3.0 to 4.3.1 [\#93](https://github.com/btschwertfeger/python-cmethods/pull/93) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/upload-artifact from 4.3.2 to 4.3.3 [\#91](https://github.com/btschwertfeger/python-cmethods/pull/91) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 4.1.2 to 4.1.4 [\#90](https://github.com/btschwertfeger/python-cmethods/pull/90) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/upload-artifact from 4.3.1 to 4.3.2 [\#89](https://github.com/btschwertfeger/python-cmethods/pull/89) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump codecov/codecov-action from 4.2.0 to 4.3.0 [\#87](https://github.com/btschwertfeger/python-cmethods/pull/87) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update the publishing process [\#94](https://github.com/btschwertfeger/python-cmethods/pull/94) ([btschwertfeger](https://github.com/btschwertfeger))
- Fix CI - Failing due to missing hdf5 and netcdf headers [\#92](https://github.com/btschwertfeger/python-cmethods/pull/92) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.2.1](https://github.com/btschwertfeger/python-cmethods/tree/v2.2.1) (2024-04-10)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.2.0...v2.2.1)

**Merged pull requests:**

- Fix missing function documentation [\#85](https://github.com/btschwertfeger/python-cmethods/pull/85) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.2.0](https://github.com/btschwertfeger/python-cmethods/tree/v2.2.0) (2024-04-09)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.1.0...v2.2.0)

**Implemented enhancements:**

- Add a command-line interface [\#82](https://github.com/btschwertfeger/python-cmethods/issues/82)
- Resolve "Add a command-line interface" [\#83](https://github.com/btschwertfeger/python-cmethods/pull/83) ([btschwertfeger](https://github.com/btschwertfeger))

**Merged pull requests:**

- Bump codecov/codecov-action from 4.1.0 to 4.2.0 [\#80](https://github.com/btschwertfeger/python-cmethods/pull/80) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/setup-python from 5.0.0 to 5.1.0 [\#79](https://github.com/btschwertfeger/python-cmethods/pull/79) ([dependabot[bot]](https://github.com/apps/dependabot))
- Adjust GitHub Action permissions [\#75](https://github.com/btschwertfeger/python-cmethods/pull/75) ([btschwertfeger](https://github.com/btschwertfeger))
- Bump actions/upload-artifact from 3.1.0 to 4.3.1 [\#74](https://github.com/btschwertfeger/python-cmethods/pull/74) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 3.1.0 to 4.1.2 [\#72](https://github.com/btschwertfeger/python-cmethods/pull/72) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ossf/scorecard-action from 2.1.2 to 2.3.1 [\#71](https://github.com/btschwertfeger/python-cmethods/pull/71) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update the documentation + project maintenance [\#70](https://github.com/btschwertfeger/python-cmethods/pull/70) ([btschwertfeger](https://github.com/btschwertfeger))
- Add `scorecard.yml` workflow [\#69](https://github.com/btschwertfeger/python-cmethods/pull/69) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.1.0](https://github.com/btschwertfeger/python-cmethods/tree/v2.1.0) (2024-03-10)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.0.2...v2.1.0)

**Implemented enhancements:**

- Adjustments using `adjust` require the input data of the control period to have the same size for the time dimension [\#66](https://github.com/btschwertfeger/python-cmethods/issues/66)
- Resolve "Adjustments using `adjust` require the input data of the control period to have the same size for the time dimension" [\#67](https://github.com/btschwertfeger/python-cmethods/pull/67) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.0.2](https://github.com/btschwertfeger/python-cmethods/tree/v2.0.2) (2024-02-02)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.0.1...v2.0.2)

**Merged pull requests:**

- Bump GitHub action versions [\#59](https://github.com/btschwertfeger/python-cmethods/pull/59) ([btschwertfeger](https://github.com/btschwertfeger))
- Fix typos and update pre-commit hooks [\#64](https://github.com/btschwertfeger/python-cmethods/pull/64) ([btschwertfeger](https://github.com/btschwertfeger))
- Update documentation -- QM and QDM formulas [\#62](https://github.com/btschwertfeger/python-cmethods/pull/62) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.0.1](https://github.com/btschwertfeger/python-cmethods/tree/v2.0.1) (2024-02-01)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v2.0.0...v2.0.1)

**Closed issues:**

- The latest documentation still describes the legacy max_scaling_factor [\#60](https://github.com/btschwertfeger/python-cmethods/issues/60)

**Merged pull requests:**

- adjust CI workflows [\#58](https://github.com/btschwertfeger/python-cmethods/pull/58) ([btschwertfeger](https://github.com/btschwertfeger))
- Resolve "The latest documentation still describes the legacy max scaling factor" [\#61](https://github.com/btschwertfeger/python-cmethods/pull/61) ([btschwertfeger](https://github.com/btschwertfeger))

## [v2.0.0](https://github.com/btschwertfeger/python-cmethods/tree/v2.0.0) (2024-01-23)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v1.0.3...v2.0.0)

**Breaking changes:**

- Rework python-cmethods: replace the `CMethods` class by the new `adjust` function [\#48](https://github.com/btschwertfeger/python-cmethods/pull/48) ([btschwertfeger](https://github.com/btschwertfeger))

**Implemented enhancements:**

- Optimization for `adjust_3d` [\#47](https://github.com/btschwertfeger/python-cmethods/issues/47)
- Find a solution to process large data sets more efficient [\#6](https://github.com/btschwertfeger/python-cmethods/issues/6)

**Merged pull requests:**

- Fix the CodeQL workflow execution; prepare v2.0.0 release [\#50](https://github.com/btschwertfeger/python-cmethods/pull/50) ([btschwertfeger](https://github.com/btschwertfeger))

## [v1.0.3](https://github.com/btschwertfeger/python-cmethods/tree/v1.0.3) (2023-08-09)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v1.0.2...v1.0.3)

**Implemented enhancements:**

- Validate types during runtime [\#42](https://github.com/btschwertfeger/python-cmethods/issues/42)

**Fixed bugs:**

- The tool fails when input time series include np.nan for distribution-based methods [\#41](https://github.com/btschwertfeger/python-cmethods/issues/41)
- Fix error when time series includes nan values [\#40](https://github.com/btschwertfeger/python-cmethods/pull/40) ([btschwertfeger](https://github.com/btschwertfeger))

**Merged pull requests:**

- Merge `.pylintrc` and `.coveragerc` into `pyproject.toml` [\#44](https://github.com/btschwertfeger/python-cmethods/pull/44) ([btschwertfeger](https://github.com/btschwertfeger))
- Add type checking for parameters of bias correction techniques [\#43](https://github.com/btschwertfeger/python-cmethods/pull/43) ([btschwertfeger](https://github.com/btschwertfeger))

## [v1.0.2](https://github.com/btschwertfeger/python-cmethods/tree/v1.0.2) (2023-06-18)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v1.0.1...v1.0.2)

**Merged pull requests:**

- Clarified difference between stochastic and non-stochastic climate variables in doc and readme [\#36](https://github.com/btschwertfeger/python-cmethods/pull/36) ([btschwertfeger](https://github.com/btschwertfeger))
- Fix typos [\#38](https://github.com/btschwertfeger/python-cmethods/pull/38) ([btschwertfeger](https://github.com/btschwertfeger))

## [v1.0.1](https://github.com/btschwertfeger/python-cmethods/tree/v1.0.1) (2023-04-17)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v1.0.0...v1.0.1)

**Breaking changes:**

- Split Quantile Mapping into Quantile Mapping and Detrended Quantile Mapping [\#18](https://github.com/btschwertfeger/python-cmethods/issues/18)
- Split Quantile Mapping into Quantile Mapping and Detrended Quantile Mapping [\#34](https://github.com/btschwertfeger/python-cmethods/pull/34) ([btschwertfeger](https://github.com/btschwertfeger))

**Fixed bugs:**

- Multiplicative Quantile Delta Mapping is not applying scaling where the delta is infinite [\#32](https://github.com/btschwertfeger/python-cmethods/issues/32)
- Fixed PyPI repository URL [\#16](https://github.com/btschwertfeger/python-cmethods/pull/16) ([btschwertfeger](https://github.com/btschwertfeger))
- Fixed bug where division lead to nan or inf values [\#33](https://github.com/btschwertfeger/python-cmethods/pull/33) ([btschwertfeger](https://github.com/btschwertfeger))

**Closed issues:**

- Create a changelog [\#19](https://github.com/btschwertfeger/python-cmethods/issues/19)

**Merged pull requests:**

- Create a Changelog [\#21](https://github.com/btschwertfeger/python-cmethods/pull/21) ([btschwertfeger](https://github.com/btschwertfeger))
- Extended the description of quantile mapping with text and images [\#20](https://github.com/btschwertfeger/python-cmethods/pull/20) ([btschwertfeger](https://github.com/btschwertfeger))
- Prepare release [\#35](https://github.com/btschwertfeger/python-cmethods/pull/35) ([btschwertfeger](https://github.com/btschwertfeger))

## [v1.0.0](https://github.com/btschwertfeger/python-cmethods/tree/v1.0.0) (2023-04-10)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.6.3...v1.0.0)

**Breaking changes:**

- Remove the unnecessary `CMethods.py` module to access the CMethods class more easily [\#10](https://github.com/btschwertfeger/python-cmethods/issues/10)

**Implemented enhancements:**

- Create a release workflow for dev and production releases [\#8](https://github.com/btschwertfeger/python-cmethods/issues/8)
- Move from setup.py to pyproject.toml [\#7](https://github.com/btschwertfeger/python-cmethods/issues/7)
- Adjusted and improved the examples [\#15](https://github.com/btschwertfeger/python-cmethods/pull/15) ([btschwertfeger](https://github.com/btschwertfeger))
- Improving workflows - adding release workflow [\#12](https://github.com/btschwertfeger/python-cmethods/pull/12) ([btschwertfeger](https://github.com/btschwertfeger))

**Closed issues:**

- Create a documentation [\#9](https://github.com/btschwertfeger/python-cmethods/issues/9)

**Merged pull requests:**

- Moved the content of `CMethods.py` to `__init__.py` and adjusted the imports [\#14](https://github.com/btschwertfeger/python-cmethods/pull/14) ([btschwertfeger](https://github.com/btschwertfeger))
- Create the documentation [\#13](https://github.com/btschwertfeger/python-cmethods/pull/13) ([btschwertfeger](https://github.com/btschwertfeger))
- Move from setup.py to pyproject.toml [\#11](https://github.com/btschwertfeger/python-cmethods/pull/11) ([btschwertfeger](https://github.com/btschwertfeger))

## [v0.6.3](https://github.com/btschwertfeger/python-cmethods/tree/v0.6.3) (2023-03-22)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.6.2...v0.6.3)

**Breaking changes:**

- adjust_3d forces group to be "time.month" if group is set to the default \(None\) [\#5](https://github.com/btschwertfeger/python-cmethods/issues/5)

**Implemented enhancements:**

- Add pre-commit [\#2](https://github.com/btschwertfeger/python-cmethods/issues/2)

**Fixed bugs:**

- Removed forced 'time.month' grouping in `adjust_3d` when no group was specified [\#4](https://github.com/btschwertfeger/python-cmethods/pull/4) ([btschwertfeger](https://github.com/btschwertfeger))

## [v0.6.2](https://github.com/btschwertfeger/python-cmethods/tree/v0.6.2) (2023-03-14)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.6.1...v0.6.2)

**Fixed bugs:**

- KeyError when Quantile\* Mapping and group != None [\#3](https://github.com/btschwertfeger/python-cmethods/issues/3)

**Merged pull requests:**

- Added pre-commit workflow to standardize the code base [\#1](https://github.com/btschwertfeger/python-cmethods/pull/1) ([btschwertfeger](https://github.com/btschwertfeger))

## [v0.6.1](https://github.com/btschwertfeger/python-cmethods/tree/v0.6.1) (2022-12-02)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.6...v0.6.1)

## [v0.6](https://github.com/btschwertfeger/python-cmethods/tree/v0.6) (2022-11-28)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.5.4.2...v0.6)

## [v0.5.4.2](https://github.com/btschwertfeger/python-cmethods/tree/v0.5.4.2) (2022-11-14)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/0.5.4.1...v0.5.4.2)

## [0.5.4.1](https://github.com/btschwertfeger/python-cmethods/tree/0.5.4.1) (2022-11-09)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.5.4...0.5.4.1)

## [v0.5.4](https://github.com/btschwertfeger/python-cmethods/tree/v0.5.4) (2022-11-05)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.5.3...v0.5.4)

## [v0.5.3](https://github.com/btschwertfeger/python-cmethods/tree/v0.5.3) (2022-10-26)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.5.2...v0.5.3)

## [v0.5.2](https://github.com/btschwertfeger/python-cmethods/tree/v0.5.2) (2022-10-14)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.5.1...v0.5.2)

## [v0.5.1](https://github.com/btschwertfeger/python-cmethods/tree/v0.5.1) (2022-08-19)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/v0.5...v0.5.1)

## [v0.5](https://github.com/btschwertfeger/python-cmethods/tree/v0.5) (2022-08-19)

[Full Changelog](https://github.com/btschwertfeger/python-cmethods/compare/41c1837e5d23c300656c8ee2ce0079d6a8baac2f...v0.5)

\* _This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)_
