# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cmr']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'python-cmr',
    'version': '0.7.0',
    'description': 'Python wrapper to the NASA Common Metadata Repository (CMR) API.',
    'long_description': 'This repository is a copy\nof [jddeal/python_cmr](https://github.com/jddeal/python-cmr/tree/ef0f9e7d67ce99d342a568bd6a098c3462df16d2) which is no\nlonger maintained. It has been copied here with the permission of the original author for the purpose of continuing to\ndevelop a python library that can be used for CMR access.\n\n----\n\nPython CMR\n==========\n\n[![CodeQL](https://github.com/nasa/python_cmr/actions/workflows/codeql-analysis.yml/badge.svg)](https://github.com/nasa/python_cmr/actions/workflows/codeql-analysis.yml)\n\nPython CMR is an easy to use wrapper to the NASA\nEOSDIS [Common Metadata Repository API](https://cmr.earthdata.nasa.gov/search/). This package aims to make querying the\nAPI intuitive and less error-prone by providing methods that will preemptively check for invalid input and handle the\nURL encoding the CMR API expects.\n\nGetting access to NASA\'s earth science metadata is as simple as this:\n\n    >>> from cmr import CollectionQuery, GranuleQuery, ToolQuery, ServiceQuery, VariableQuery\n\n    >>> api = CollectionQuery()\n    >>> collections = api.archive_center("LP DAAC").keyword("AST_L1*").get(5)\n\n    >>> for collection in collections:\n    >>>   print(collection["short_name"])\n    AST_L1A\n    AST_L1AE\n    AST_L1T\n\n    >>> api = GranuleQuery()\n    >>> granules = api.short_name("AST_L1T").point(-112.73, 42.5).get(3)\n\n    >>> for granule in granules:\n    >>>   print(granule["title"])\n    SC:AST_L1T.003:2149105822\n    SC:AST_L1T.003:2149105820\n    SC:AST_L1T.003:2149155037\n\nInstallation\n============\n\nTo install from pypi:\n\n    $ pip install python-cmr\n\nTo install from github, perhaps to try out the dev branch:\n\n    $ git clone https://github.com/nasa/python_cmr\n    $ cd python-cmr\n    $ pip install .\n\nExamples\n========\n\nThis library is broken into two classes, CollectionQuery and GranuleQuery. Each of these classes provide a large set of\nmethods used to build a query for CMR. Not all parameters provided by the CMR API are covered by this version of\npython-cmr.\n\nThe following methods are available to both collecton and granule queries:\n\n    # search for granules matching a specific product/short_name\n    >>> api.short_name("AST_L1T")\n\n    # search for granules matching a specific version\n    >>> api.version("006")\n\n    # search for granules at a specific longitude and latitude\n    >>> api.point(-112.73, 42.5)\n\n    # search for granules in an area bound by a box (lower left lon/lat, upper right lon/lat)\n    >>> api.bounding_box(-112.70, 42.5, -110, 44.5)\n\n    # search for granules in a polygon (these need to be in counter clockwise order and the\n    # last coordinate must match the first in order to close the polygon)\n    >>> api.polygon([(-100, 40), (-110, 40), (-105, 38), (-100, 40)])\n\n    # search for granules in a line\n    >>> api.line([(-100, 40), (-90, 40), (-95, 38)])\n\n    # search for granules in an open or closed date range\n    >>> api.temporal("2016-10-10T01:02:00Z", "2016-10-12T00:00:30Z")\n    >>> api.temporal("2016-10-10T01:02:00Z", None)\n    >>> api.temporal(datetime(2016, 10, 10, 1, 2, 0), datetime.now())\n\n    # only include granules available for download\n    >>> api.downloadable()\n\n    # only include granules that are unavailable for download\n    >>> api.online_only()\n\n    # search for collections/granules associated with or identified by concept IDs\n    # note: often the ECHO collection ID can be used here as well\n    # note: when using CollectionQuery, only collection concept IDs can be passed\n    # note: when uses GranuleQuery, passing a collection\'s concept ID will filter by granules associated\n    #       with that particular collection.\n    >>> api.concept_id("C1299783579-LPDAAC_ECS")\n    >>> api.concept_id(["G1327299284-LPDAAC_ECS", "G1326330014-LPDAAC_ECS"])\n\n    # search by provider\n    >>> api.provider(\'POCLOUD\')\n\nGranule searches support these methods (in addition to the shared methods above):\n\n    # search for a granule by its unique ID\n    >>> api.granule_ur("SC:AST_L1T.003:2150315169")\n    # search for granules from a specific orbit\n    >>> api.orbit_number(5000)\n\n    # filter by the day/night flag\n    >>> api.day_night_flag("day")\n\n    # filter by cloud cover percentage range\n    >>> api.cloud_cover(25, 75)\n\n    # filter by specific instrument or platform\n    >>> api.instrument("MODIS")\n    >>> api.platform("Terra")\n\nCollection searches support these methods (in addition to the shared methods above):\n\n    # search for collections from a specific archive center\n    >>> api.archive_center("LP DAAC")\n\n    # case insensitive, wildcard enabled text search through most collection fields\n    >>> api.keyword("M*D09")\n\n    # search by native_id\n    >>> api.native_id(\'native_id\')\n\n    # filter by tool concept id\n    >>> api.tool_concept_id(\'TL2092786348-POCLOUD\')\n\n    # filter by service concept id\n    >>> api.service_concept_id(\'S1962070864-POCLOUD\')\n\nService searches support the following methods\n\n    # Search via provider\n    >>> api = ServiceQuery()\n    >>> api.provider(\'POCLOUD\')\n    \n    # Search via native_id\n    >>> api.native_id(\'POCLOUD_podaac_l2_cloud_subsetter\')\n\n    # Search via name\n    >>> api.name(\'PODAAC L2 Cloud Subsetter\')\n\n    # Search via concept_id\n    >>> api.concept_id(\'S1962070864-POCLOUD\')\n\nTool searches support the following methods\n\n    # Search via provider\n    >>> api = ToolQuery()\n    >>> api.provider(\'POCLOUD\')\n\n    # Search via native_id\n    >>> api.native_id(\'POCLOUD_hitide\')\n\n    # Search via name\n    >>> api.name(\'hitide\')\n\n    # Search via concept_id\n    >>> api.concept_id(\'TL2092786348-POCLOUD\')\n\nVariable searches support the following methods\n\n    # Search via provider\n    >>> api = VariableQuery()\n    >>> api.provider(\'POCLOUD\')\n\n    # Search via native_id\n    >>> api.native_id(\'JASON_CS_S6A_L2_AMR_RAD_STATIC_CALIBRATION-AMR_Side_1-acc_lat\')\n\n    # Search via name\n    >>> api.name(\'/AMR_Side_1/acc_lat\')\n\n    # Search via concept_id\n    >>> api.concept_id(\'V2112019824-POCLOUD\')\n\nAs an alternative to chaining methods together to set the parameters of your query, a method exists to allow you to pass\nyour parameters as keyword arguments:\n\n    # search for AST_L1T version 003 granules at latitude 42, longitude -100\n    >>> api.parameters(\n        short_name="AST_L1T",\n        version="003",\n        point=(-100, 42)\n    )\n\nNote: the kwarg key should match the name of a method from the above examples, and the value should be a tuple if it\'s a\nparameter that requires multiple values.\n\nTo inspect and retreive results from the API, the following methods are available:\n\n    # inspect the number of results the query will return without downloading the results\n    >>> print(api.hits())\n\n    # retrieve 100 granules\n    >>> granules = api.get(100)\n\n    # retrieve 25,000 granules\n    >>> granules = api.get(25000)\n\n    # retrieve all the granules possible for the query\n    >>> granules = api.get_all()  # this is a shortcut for api.get(api.hits())\n\nBy default the responses will return as json and be accessible as a list of python dictionaries. Other formats can be\nspecified before making the request:\n\n    >>> granules = api.format("echo10").get(100)\n\nThe following formats are supported for both granule and collection queries:\n\n- json (default)\n- xml\n- echo10\n- iso\n- iso19115\n- csv\n- atom\n- kml\n- native\n\nCollection queries also support the following formats:\n\n- dif\n- dif10\n- opendata\n- umm\\_json\n- umm\\_json\\_vX\\_Y (ex: umm\\_json\\_v1\\_9)\n\n# Developing\n\npython-cmr uses the [poetry](https://python-poetry.org/) build system. Download and install poetry before starting\ndevelopment\n\n## Install Dependencies\n\nWith dev dependencies:\n```shell\npoetry install\n```\n\nWithout dev dependencies:\n```shell\npoetry install --no-dev\n```\n\n## Update Dependencies\n\n```shell\npoetry update\n```\n\n## Add new Dependency\n\n```shell\npoetry add requests\n```\nDevelopment-only dependency:\n```shell\npoetry add --dev pytest\n```\n\n## Build project\n\n```shell\npoetry build\n```\n\n## Lint project\n\n```shell\npoetry run flake8\n```\n\n## Run Tests\n\n```shell\npoetry run pytest\n```',
    'author': 'python_cmr',
    'author_email': 'nasa/python_cmr@github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nasa/python_cmr',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
