# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class ArtifactoryService:    
	def __init__(self, client):
		self._client = client

	# 删除制品标签。 Delete the specific tag under specific package
	def delete_package_tag(self,
		slug: str,
		t: str,
		name: str,
		tag: str,
	    ):
		u = "/%s/-/packages/%s/%s/-/tag/%s" % (slug, t, name, tag, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 

	# 删除制品仓库。Delete the artifact repository.
	def delete_registry(self,
		registry: str,
	    ):
		u = "/%s" % (registry, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 

	# 下载制品配额信息。 Download registry quota details.
	def download_quotas_by_project_name(self,
		slug: str,
		t: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		) -> list[dto.QuotaRsp]:
		u = "/%s/-/packages/%s/-/quotas/download" % (slug, t, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.QuotaRsp.safe_parse(item) for item in data]

	# 获取某一制品的详细信息。 Get the package detail.
	def get_package(self,
		slug: str,
		t: str,
		name: str,
	    ) -> dto.PackageDetail:
		u = "/%s/-/packages/%s/%s" % (slug, t, name, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.PackageDetail.safe_parse(data)

	# 获取制品标签详情。 Get the specific tag under specific package.
	def get_package_tag_detail(self,
		slug: str,
		t: str,
		name: str,
		tag: str,
	    sha256: Optional[str] = None,
		) -> dto.TagDetail:
		u = "/%s/-/packages/%s/%s/-/tag/%s" % (slug, t, name, tag, )

		query_params = {
			"sha256": sha256,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.TagDetail.safe_parse(data)

	# 查询制品配额。 Get quota of specific registry.
	def get_quota_by_project_name(self,
		slug: str,
		t: str,
	    ) -> dto.QuotaRsp:
		u = "/%s/-/packages/%s/-/quota" % (slug, t, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.QuotaRsp.safe_parse(data)

	# 查询全部制品配额。 Get quotas of packages under one registry.
	def get_quotas_by_project_name(self,
		slug: str,
		t: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		) -> list[dto.QuotaRsp]:
		u = "/%s/-/packages/%s/-/quotas" % (slug, t, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.QuotaRsp.safe_parse(item) for item in data]

	# 查询制品数量。 Head all packages.
	def head_packages(self,
		slug: str,
	    type: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		name: Optional[str] = None,
		):
		u = "/%s/-/packages" % (slug, )

		query_params = {
			"type": type,
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			"name": name,
			}
		data = self._client.request(
			method="HEAD", 
			endpoint=u,
			params=query_params,
			)
		return 

	# 查询制品标签列表。 List all tags under specific package.
	def list_package_tags(self,
		slug: str,
		t: str,
		pkgname: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		name: Optional[str] = None,
		) -> dto.Tag:
		u = "/%s/-/packages/%s/%s/-/tags" % (slug, t, pkgname, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			"name": name,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.Tag.safe_parse(data)

	# 查询制品列表。 List all packages.
	def list_packages(self,
		slug: str,
	    type: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		name: Optional[str] = None,
		) -> list[dto.Package]:
		u = "/%s/-/packages" % (slug, )

		query_params = {
			"type": type,
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			"name": name,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Package.safe_parse(item) for item in data]

	