# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class AssetsService:    
	def __init__(self, client):
		self._client = client

	# 发起一个获取 commits 附件的请求，返回内容或者 302 到某个地址。Get a request to fetch a commit assets and returns the content directly or a 302 redirect to the assets URL.
	def get_commit_assets(self,
		repo: str,
		fileName: str,
	    ):
		u = "/%s/-/commit-assets/download/%s" % (repo, fileName, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 发起一个获取 files 的请求，返回内容或者 302 到某个地址。Initiate a request to retrieve files, returns content or 302 redirect.
	def get_files(self,
		repo: str,
		userIdKey: str,
		randomUUID: str,
		fileName: str,
	    ):
		u = "/%s/-/files/%s/%s/%s" % (repo, userIdKey, randomUUID, fileName, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 发起一个获取 imgs 的请求，返回内容或者 302 到某个地址。Initiate a request to get images, returns content or 302 redirect.
	def get_imgs(self,
		repo: str,
		userIdKey: str,
		fileName: str,
	    ):
		u = "/%s/-/imgs/%s/%s" % (repo, userIdKey, fileName, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 发起一个获取 latest release 附件的请求，返回内容或者 302 到某个地址。Initiate a request to get latest release attachments, returns content or 302 redirect.
	def get_latest_releases_asset(self,
		repo: str,
		fileName: str,
	    ):
		u = "/%s/-/releases/latest/download/%s" % (repo, fileName, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 发起一个获取 logo 的请求，返回内容或者 302 到某个地址。Post a request to fetch a logo and returns the content directly or a 302 redirect to the logo URL.
	def get_logos(self,
		group: str,
		size: str,
	    ):
		u = "/%s/-/logos/%s" % (group, size, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 发起一个获取 release 附件的请求，返回内容或者 302 到某个地址。Initiate a request to get release attachments, returns content or 302 redirect.
	def get_releases_asset(self,
		repo: str,
		fileName: str,
	    ):
		u = "/%s/-/releases/download/%s" % (repo, fileName, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 获取指定用户的用户头像。Get the user's avatar.
	def get_user_avatar(self,
		username: str,
		size: str,
	    ):
		u = "/users/%s/avatar/%s" % (username, size, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 

	# 发起一个确认 files 的请求，上传的图片要调用此接口才能生效。Initiate a request to confirm files, uploaded images need to call this API to take effect.
	def put_files(self,
		repo: str,
		userIdKey: str,
		randomUUID: str,
		fileName: str,
	    token: Optional[str] = None,
		):
		u = "/%s/-/files/%s/%s/%s" % (repo, userIdKey, randomUUID, fileName, )

		query_params = {
			"token": token,
			}
		data = self._client.request(
			method="PUT", 
			endpoint=u,
			params=query_params,
			)
		return 

	# 发起一个确认 imgs 的请求，上传的图片要调用此接口才能生效。Initiate a request to confirm images, uploaded images need to call this API to take effect.
	def put_imgs(self,
		repo: str,
		userIdKey: str,
		fileName: str,
	    token: Optional[str] = None,
		):
		u = "/%s/-/imgs/%s/%s" % (repo, userIdKey, fileName, )

		query_params = {
			"token": token,
			}
		data = self._client.request(
			method="PUT", 
			endpoint=u,
			params=query_params,
			)
		return 

	# 确认上传的logo。Confirms the uploaded logo.
	def put_logos(self,
		group: str,
	    token: Optional[str] = None,
		):
		u = "/%s/-/logos" % (group, )

		query_params = {
			"token": token,
			}
		data = self._client.request(
			method="PUT", 
			endpoint=u,
			params=query_params,
			)
		return 

	# 发起一个上传 files 的请求，返回上传 cos 的 url 和 form 内容。Initiate a request to upload files,returns COS upload URL and form data.
	def upload_files(self,
		repo: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/files" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)

	# 发起一个上传 imgs 的请求，返回上传 cos 的 url 和 form 内容。发起一个上传 imgs 的请求，返回上传 cos 的 url 和 form 内容.
	def upload_imgs(self,
		repo: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/imgs" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)

	# 发起一个上传 logo 的请求，返回上传 cos 的 url 和 form 内容。Post a request to upload a logo.
	def upload_logos(self,
		group: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/logos" % (group, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)

	# 发起一个上传 release 附件的请求，返回上传 cos 的 url 和 form 内容。Initiate a request to upload release attachments, returns COS upload URL and form data.
	def upload_releases(self,
		repo: str,
		tagName: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/releases/%s" % (repo, tagName, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)

	