# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class BuildService:    
	def __init__(self, client):
		self._client = client

	# 查询流水线构建列表。List pipeline builds.
	def get_build_logs(self,
		repo: str,
	    createTime: Optional[str] = None,
		endTime: Optional[str] = None,
		event: Optional[str] = None,
		page: Optional[int] = None,
		pagesize: Optional[int] = None,
		sha: Optional[str] = None,
		sn: Optional[str] = None,
		sourceRef: Optional[str] = None,
		status: Optional[str] = None,
		targetRef: Optional[str] = None,
		userId: Optional[str] = None,
		userName: Optional[str] = None,
		) -> dto.BuildLogsResult:
		u = "/%s/-/build/logs" % (repo, )

		query_params = {
			"createTime": createTime,
			"endTime": endTime,
			"event": event,
			"page": page,
			"pagesize": pagesize,
			"sha": sha,
			"sn": sn,
			"sourceRef": sourceRef,
			"status": status,
			"targetRef": targetRef,
			"userId": userId,
			"userName": userName,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.BuildLogsResult.safe_parse(data)
		
	# 查询流水线构建状态。Get pipeline build status.
	def get_build_status(self,
		repo: str,
		sn: str,
	    ) -> dto.BuildStatusResult:
		u = "/%s/-/build/status/%s" % (repo, sn, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.BuildStatusResult.safe_parse(data)
		
	# 开始一个构建。Start a build.
	def start_build(self,
		repo: str,
	    body_params: dto.StartBuildReq,
		) -> dto.BuildResult:
		u = "/%s/-/build/start" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.BuildResult.safe_parse(data)
		
	# 停止一个构建。 Stop a build.
	def stop_build(self,
		repo: str,
		sn: str,
	    ) -> dto.BuildResult:
		u = "/%s/-/build/stop/%s" % (repo, sn, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return dto.BuildResult.safe_parse(data)
		
	