# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class AssetsService:    
	def __init__(self, client):
		self._client = client

	# 发起一个获取 commits 附件的请求，返回内容或者 302 到某个地址。Get a request to fetch a commit assets and returns the content directly or a 302 redirect to the assets URL.
	def get_commit_assets(self,
		repo: str,
		commit_id: str,
		filename: str,
	    share: Optional[bool] = None,
		):
		u = "/%s/-/commit-assets/download/%s/%s" % (repo, commit_id, filename, )

		query_params = {
			"share": share,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return 
		
	# 发起一个获取 latest release 附件的请求，返回内容或者 302 到某个地址。Initiate a request to get latest release attachments, returns content or 302 redirect.
	def get_latest_releases_asset(self,
		repo: str,
		fileName: str,
	    ):
		u = "/%s/-/releases/latest/download/%s" % (repo, fileName, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 发起一个获取 release 附件的请求，返回内容或者 302 到某个地址。Initiate a request to get release attachments, returns content or 302 redirect.
	def get_releases_asset(self,
		repo: str,
		tag: str,
		filename: str,
	    share: Optional[bool] = None,
		):
		u = "/%s/-/releases/download/%s/%s" % (repo, tag, filename, )

		query_params = {
			"share": share,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return 
		
	# 发起一个上传 files 的请求，返回上传 cos 的 url 和 form 内容。Initiate a request to upload files,returns COS upload URL and form data.
	def upload_files(self,
		repo: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/files" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)
		
	# 发起一个上传 imgs 的请求，返回上传 cos 的 url 和 form 内容。发起一个上传 imgs 的请求，返回上传 cos 的 url 和 form 内容.
	def upload_imgs(self,
		repo: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/imgs" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)
		
	# 发起一个上传 logo 的请求，返回上传 cos 的 url 和 form 内容。Post a request to upload a logo.
	def upload_logos(self,
		group: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/logos" % (group, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)
		
	# 发起一个上传 release 附件的请求，返回上传 cos 的 url 。Initiate a request to upload release attachments,
	def upload_releases(self,
		repo: str,
		tagName: str,
	    body_params: dto.UploadRequestParams,
		) -> dto.UploadAssetsResponse:
		u = "/%s/-/upload/releases/%s" % (repo, tagName, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.UploadAssetsResponse.safe_parse(data)
		
	