# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class OrganizationsService:    
	def __init__(self, client):
		self._client = client

	# 创建新组织。Create new organization.
	def create_organization(self,
	    body_params: dto.CreateGroupReq,
		):
		u = "/groups" % ()

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 删除指定组织。Delete the specified organization.
	def delete_organization(self,
		group: str,
	    ):
		u = "/%s" % (group, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 获取指定组织信息。Get information for the specified organization.
	def get_group(self,
		group: str,
	    ) -> dto.OrganizationAccess:
		u = "/%s" % (group, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.OrganizationAccess.safe_parse(data)
		
	# 获取指定组织的配置详情。Get the configuration details for the specified organization.
	def get_group_setting(self,
		group: str,
	    ) -> dto.OrganizationSettingWithParent:
		u = "/%s/-/settings" % (group, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.OrganizationSettingWithParent.safe_parse(data)
		
	# 获取指定用户拥有权限的顶层组织列表。 Get a list of top-level organizations that the specified user has permissions to access.
	def get_groups_by_user_id(self,
		username: str,
	    search: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		desc: Optional[bool] = None,
		order_by: Optional[str] = None,
		) -> dto.OrganizationUnion:
		u = "/users/%s/groups" % (username, )

		query_params = {
			"search": search,
			"page": page,
			"page_size": page_size,
			"desc": desc,
			"order_by": order_by,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.OrganizationUnion.safe_parse(data)
		
	# 查询当前用户在指定组织下拥有指定权限的子组织列表。Get the list of sub-organizations that the current user has access to in the specified organization.
	def list_groups(self,
		group: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		access: Optional[int] = None,
		) -> list[dto.OrganizationAccess]:
		u = "/user/groups/%s" % (group, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"access": access,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.OrganizationAccess.safe_parse(item) for item in data]
		
	# 获取指定组织下的子组织列表。Get the list of sub-organizations under the specified organization.
	def list_subgroups(self,
		group: str,
	    search: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[dto.OrganizationUnion]:
		u = "/%s/-/sub-groups" % (group, )

		query_params = {
			"search": search,
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.OrganizationUnion.safe_parse(item) for item in data]
		
	# 获取当前用户拥有权限的顶层组织列表。Get top-level organizations list that the current user has access to.
	def list_top_groups(self,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		search: Optional[str] = None,
		role: Optional[str] = None,
		) -> list[dto.OrganizationAccess]:
		u = "/user/groups" % ()

		query_params = {
			"page": page,
			"page_size": page_size,
			"search": search,
			"role": role,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.OrganizationAccess.safe_parse(item) for item in data]
		
	# 转移组织
	def transfer_group(self,
		group: str,
	    body_params: dto.TransferSlugReq,
		):
		u = "/%s/-/transfer" % (group, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 更新指定组织的配置。Updates the configuration for the specified organization.
	def update_group_setting(self,
		group: str,
	    body_params: dto.GroupSettingReq,
		):
		u = "/%s/-/settings" % (group, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 更新组织信息, 可更新的内容为: 组织描述, 组织展示名称, 组织网站, 组织联系邮箱。Updates organization information including: description, display name, website URL and contact email.
	def update_organization(self,
		group: str,
	    body_params: dto.UpdateGroupReq,
		):
		u = "/%s" % (group, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	