# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import api
from .models import git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api
from .models import web
from .models import webapi
class PullsService:    
	def __init__(self, client):
		self._client = client

	# 检查用户是否可以被添加到 PullRequest 的 Assignees 中。 Checks if a user can be assigned to a pull request.
	def can_user_be_assigned_to_pull(self,
		repo: str,
		number: str,
		assignee: str,
	    ):
		u = "/%s/-/pulls/%s/assignees/%s" % (repo, number, assignee, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 拣选一个已合并的 Pull Request 的提交到选定的分支
	def cherry_pick_pull_request(self,
		repo: str,
		number: str,
	    body_params: webapi.CherryPickPullRequestForm,
		) -> web.CommitCherryPick:
		u = "/%s/-/pulls/%s/cherry-pick" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return web.CommitCherryPick.safe_parse(data)
		
	# 删除 PullRequest 中的 Assignees。 Removes one or more assignees from a pull request.
	def delete_pull_assignees(self,
		repo: str,
		number: str,
	    body_params: api.DeletePullAssigneesForm,
		) -> api.Pull:
		u = "/%s/-/pulls/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 删除 Pull 标签。Remove a label from a pull.
	def delete_pull_label(self,
		repo: str,
		number: str,
		name: str,
	    ) -> api.Label:
		u = "/%s/-/pulls/%s/labels/%s" % (repo, number, name, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return api.Label.safe_parse(data)
		
	# 清空 Pull 标签。Remove all labels from a pull.
	def delete_pull_labels(self,
		repo: str,
		number: str,
	    ):
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询指定 Pull。Get a pull request.
	def get_pull(self,
		repo: str,
		number: str,
	    ) -> api.Pull:
		u = "/%s/-/pulls/%s" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Pull.safe_parse(data)
		
	# 查询指定 PullRequest 的 Assignees。List repository pull request assignees.
	def list_pull_assignees(self,
		repo: str,
		number: str,
	    ) -> list[git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api.UserInfo]:
		u = "/%s/-/pulls/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api.UserInfo.safe_parse(item) for item in data]
		
	# 查询 Pull Comments 列表。List pull comments requests.
	def list_pull_comments(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.PullRequestComment]:
		u = "/%s/-/pulls/%s/comments" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullRequestComment.safe_parse(item) for item in data]
		
	# 查询 Pull 的标签(label) 列表。List labels for a pull.
	def list_pull_labels(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Label]:
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Label.safe_parse(item) for item in data]
		
	# 查询 Pull 列表。List pull requests.
	def list_pulls(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		state: Optional[str] = None,
		authors: Optional[str] = None,
		reviewers: Optional[str] = None,
		assignees: Optional[str] = None,
		base_ref: Optional[str] = None,
		) -> list[api.PullRequest]:
		u = "/%s/-/pulls" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"state": state,
			"authors": authors,
			"reviewers": reviewers,
			"assignees": assignees,
			"base_ref": base_ref,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullRequest.safe_parse(item) for item in data]
		
	# 根据numbers查询 Pull 列表。List pull requests by numbers.
	def list_pulls_by_numbers(self,
		repo: str,
	    n: Optional[list[str]] = None,
		) -> list[api.PullRequestInfo]:
		u = "/%s/-/pull-in-batch" % (repo, )

		query_params = {
			"n": n,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullRequestInfo.safe_parse(item) for item in data]
		
	# 合并一个 Pull Request。Merge a pull request.
	def merge_pull(self,
		repo: str,
		number: str,
	    body_params: api.MergePullRequest,
		) -> api.MergePullResponse:
		u = "/%s/-/pulls/%s/merge" % (repo, number, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.MergePullResponse.safe_parse(data)
		
	# 更新一个 Pull Request。Update a pull request.
	def patch_pull(self,
		repo: str,
		number: str,
	    body_params: api.PatchPullRequest,
		) -> api.Pull:
		u = "/%s/-/pulls/%s" % (repo, number, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 新增一个 Pull。Create a pull request.
	def post_pull(self,
		repo: str,
	    body_params: api.PullCreationForm,
		) -> api.Pull:
		u = "/%s/-/pulls" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 添加 Assignees 到指定的 PullRequest。 Adds up to 10 assignees to a pull request. Users already assigned to an issue are not replaced.
	def post_pull_assignees(self,
		repo: str,
		number: str,
	    body_params: api.PostPullAssigneesForm,
		) -> api.Pull:
		u = "/%s/-/pulls/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 新增一个 Pull Comment。Create a pull comment.
	def post_pull_comment(self,
		repo: str,
		number: str,
	    body_params: api.PullCommentCreationForm,
		):
		u = "/%s/-/pulls/%s/comments" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 新增 Pull 标签。Add labels to a pull.
	def post_pull_labels(self,
		repo: str,
		number: str,
	    body_params: api.PostPullLabelsForm,
		) -> api.Label:
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	# 新增一次 pull request 评审。Create a pull review.
	def post_pull_review(self,
		repo: str,
		number: str,
	    body_params: api.PullReviewCreationForm,
		):
		u = "/%s/-/pulls/%s/reviews" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 设置 Pull 标签。Set the new labels for a pull.
	def put_pull_labels(self,
		repo: str,
		number: str,
	    body_params: api.PutPullLabelsForm,
		) -> api.Label:
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	# 还原一个已合并的 Pull Request
	def revert_pull_request(self,
		repo: str,
		number: str,
	    body_params: webapi.RevertPullRequestForm,
		) -> web.CommitRevert:
		u = "/%s/-/pulls/%s/revert" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return web.CommitRevert.safe_parse(data)
		
	