# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class StarringService:    
	def __init__(self, client):
		self._client = client

	# 获取指定用户的 star 仓库列表。Get the list of repositories starred by the specified user.
	def get_user_stared_repos(self,
		username: str,
	    search: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		desc: Optional[bool] = None,
		order_by: Optional[str] = None,
		) -> list[dto.Repos4User]:
		u = "/users/%s/stared-repos" % (username, )

		query_params = {
			"search": search,
			"page": page,
			"page_size": page_size,
			"desc": desc,
			"order_by": order_by,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Repos4User.safe_parse(item) for item in data]
		
	# 获取指定仓库的star用户列表。Get the list of users who starred the specified repository.
	def list_star_users(self,
		repo: str,
	    filter_type: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> dto.RepoStarUsers:
		u = "/%s/-/stars" % (repo, )

		query_params = {
			"filter_type": filter_type,
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.RepoStarUsers.safe_parse(data)
		
	