# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import dto
class WorkspaceService:    
	def __init__(self, client):
		self._client = client

	# 删除我的云原生开发环境。Delete my workspace.
	def delete_workspace(self,
	    body_params: dto.WorkspaceDeleteReq,
		) -> dto.WorkspaceDeleteResult:
		u = "/workspace/delete" % ()

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.WorkspaceDeleteResult.safe_parse(data)
		
	# 根据流水线sn查询云原生开发访问地址。Query cloud-native development access address by pipeline SN.
	def get_workspace_detail(self,
		repo: str,
		sn: str,
	    ) -> dto.WorkspaceDetailResult:
		u = "/%s/-/workspace/detail/%s" % (repo, sn, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.WorkspaceDetailResult.safe_parse(data)
		
	# 获取我的云原生开发环境列表。List my workspaces.
	def list_workspaces(self,
	    branch: Optional[str] = None,
		end: Optional[str] = None,
		page: Optional[int] = None,
		pageSize: Optional[int] = None,
		slug: Optional[str] = None,
		start: Optional[str] = None,
		status: Optional[str] = None,
		) -> dto.WorkspaceListResult:
		u = "/workspace/list" % ()

		query_params = {
			"branch": branch,
			"end": end,
			"page": page,
			"pageSize": pageSize,
			"slug": slug,
			"start": start,
			"status": status,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.WorkspaceListResult.safe_parse(data)
		
	# 启动云原生开发环境，已存在环境则直接打开，否则重新创建开发环境。Start cloud-native dev. Opens existing env or creates a new one.
	def start_workspace(self,
		repo: str,
	    body_params: dto.StartWorkspaceReq,
		) -> dto.StartWorkspaceResult:
		u = "/%s/-/workspace/start" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.StartWorkspaceResult.safe_parse(data)
		
	