# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb.cool/swagger.json

from typing import Optional
from .models import api
from .models import openapi
class ReleasesService:    
	def __init__(self, client):
		self._client = client

	# 删除指定的 release。Delete a release.
	def delete_release(self,
		repo: str,
		release_id: str,
	    ):
		u = "/%s/-/releases/%s" % (repo, release_id, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除指定的 release asset。Delete the specified release asset.
	def delete_release_asset(self,
		repo: str,
		release_id: str,
		asset_id: str,
	    ):
		u = "/%s/-/releases/%s/assets/%s" % (repo, release_id, asset_id, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询 latest release。Query the latest release.
	def get_latest_release(self,
		repo: str,
	    ) -> api.Release:
		u = "/%s/-/releases/latest" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Release.safe_parse(data)
		
	# 查询指定的 release asset。Get the specified release asset.
	def get_release_asset(self,
		repo: str,
		release_id: str,
		asset_id: str,
	    ) -> api.ReleaseAsset:
		u = "/%s/-/releases/%s/assets/%s" % (repo, release_id, asset_id, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.ReleaseAsset.safe_parse(data)
		
	# 根据 id	查询指定 release, 包含附件信息。Get a release by id, include assets information.
	def get_release_by_id(self,
		repo: str,
		release_id: str,
	    ) -> api.Release:
		u = "/%s/-/releases/%s" % (repo, release_id, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Release.safe_parse(data)
		
	# 通过 tag 查询指定 release,包含附件信息。Get a release by tag, include assets information.
	def get_release_by_tag(self,
		repo: str,
		tag: str,
	    ) -> api.Release:
		u = "/%s/-/releases/tags/%s" % (repo, tag, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Release.safe_parse(data)
		
	# 查询 release 列表。List releases.
	def list_releases(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Release]:
		u = "/%s/-/releases" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Release.safe_parse(item) for item in data]
		
	# 更新 release。Update a release.
	def patch_release(self,
		repo: str,
		release_id: str,
	    body_params: openapi.PatchReleaseForm,
		):
		u = "/%s/-/releases/%s" % (repo, release_id, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 新增一个 Release。Create a release.
	def post_release(self,
		repo: str,
	    body_params: openapi.PostReleaseForm,
		) -> api.Release:
		u = "/%s/-/releases" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Release.safe_parse(data)
		
	# 确认 Release asset 上传完成。Confirm release asset upload.
	def post_release_asset_upload_confirmation(self,
		repo: str,
		release_id: str,
		upload_token: str,
		asset_path: str,
	    ):
		u = "/%s/-/releases/%s/asset-upload-confirmation/%s/%s" % (repo, release_id, upload_token, asset_path, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return 
		
	# 新增一个 Release asset。Create a release asset.
	def post_release_asset_upload_url(self,
		repo: str,
		release_id: str,
	    body_params: openapi.PostReleaseAssetUploadURLForm,
		) -> openapi.ReleaseAssetUploadURL:
		u = "/%s/-/releases/%s/asset-upload-url" % (repo, release_id, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return openapi.ReleaseAssetUploadURL.safe_parse(data)
		
	