# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import api
class GitsettingsService:    
	def __init__(self, client):
		self._client = client

	# 删除仓库保护分支规则。 Delete branch protection rule.
	def delete_branch_protection(self,
		repo: str,
		id: str,
	    ):
		u = "/%s/-/settings/branch-protections/%s" % (repo, id, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询仓库保护分支规则。Get branch protection rule.
	def get_branch_protection(self,
		repo: str,
		id: str,
	    ) -> api.BranchProtection:
		u = "/%s/-/settings/branch-protections/%s" % (repo, id, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.BranchProtection.safe_parse(data)
		
	# 查询仓库云原生构建设置。List pipeline settings.
	def get_pipeline_settings(self,
		repo: str,
	    ) -> api.PipelineSettings:
		u = "/%s/-/settings/cloud-native-build" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.PipelineSettings.safe_parse(data)
		
	# 查询仓库合并请求设置。List pull request settings.
	def get_pull_request_settings(self,
		repo: str,
	    ) -> api.PullRequestSettings:
		u = "/%s/-/settings/pull-request" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.PullRequestSettings.safe_parse(data)
		
	# 查询仓库推送设置。List push limit settings.
	def get_push_limit_settings(self,
		repo: str,
	    ) -> api.PushLimitSettings:
		u = "/%s/-/settings/push-limit" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.PushLimitSettings.safe_parse(data)
		
	# 查询仓库保护分支规则列表。List branch protection rules.
	def list_branch_protections(self,
		repo: str,
	    ) -> list[api.BranchProtection]:
		u = "/%s/-/settings/branch-protections" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [api.BranchProtection.safe_parse(item) for item in data]
		
	# 更新仓库保护分支规则。Update branch protection rule.
	def patch_branch_protection(self,
		repo: str,
		id: str,
	    body_params: api.BranchProtection,
		):
		u = "/%s/-/settings/branch-protections/%s" % (repo, id, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 新增仓库保护分支规则。Create branch protection rule.
	def post_branch_protection(self,
		repo: str,
	    body_params: api.BranchProtection,
		):
		u = "/%s/-/settings/branch-protections" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 更新仓库云原生构建设置。Update pipeline settings.
	def put_pipeline_settings(self,
		repo: str,
	    body_params: api.PipelineSettings,
		):
		u = "/%s/-/settings/cloud-native-build" % (repo, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 更新仓库合并请求设置。Set pull request settings.
	def put_pull_request_settings(self,
		repo: str,
	    body_params: api.PullRequestSettings,
		):
		u = "/%s/-/settings/pull-request" % (repo, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 设置仓库推送设置。Set push limit settings.
	def put_push_limit_settings(self,
		repo: str,
	    body_params: api.PushLimitSettings,
		):
		u = "/%s/-/settings/push-limit" % (repo, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	