# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import api
from .models import git_woa_com_cnb_monorepo_git_internal_app_vcs_service_bff_api
from .models import openapi
class IssuesService:    
	def __init__(self, client):
		self._client = client

	# 检查用户是否可以被添加到 issue 的处理人中。 Checks if a user can be assigned to an issue.
	def can_user_be_assigned_to_issue(self,
		repo: str,
		number: str,
		assignee: str,
	    ):
		u = "/%s/-/issues/%s/assignees/%s" % (repo, number, assignee, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 创建一个 Issue。Create an issue.
	def create_issue(self,
		repo: str,
	    body_params: api.PostIssueForm,
		) -> api.IssueDetail:
		u = "/%s/-/issues" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueDetail.safe_parse(data)
		
	# 批量设置Issue自定义属性值
	def create_issue_properties(self,
		repo: str,
		number: str,
	    body_params: openapi.IssuePropertiesForm,
		):
		u = "/%s/-/issues/%s/property" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 删除 issue 中的处理人。 Removes one or more assignees from an issue.
	def delete_issue_assignees(self,
		repo: str,
		number: str,
	    body_params: api.DeleteIssueAssigneesForm,
		) -> api.IssueDetail:
		u = "/%s/-/issues/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueDetail.safe_parse(data)
		
	# 删除 issue 标签。Remove a label from an issue.
	def delete_issue_label(self,
		repo: str,
		number: str,
		name: str,
	    ) -> api.Label:
		u = "/%s/-/issues/%s/labels/%s" % (repo, number, name, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return api.Label.safe_parse(data)
		
	# 清空 issue 标签。Remove all labels from an issue.
	def delete_issue_labels(self,
		repo: str,
		number: str,
	    ):
		u = "/%s/-/issues/%s/labels" % (repo, number, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询指定的 Issues。Get an issue.
	def get_issue(self,
		repo: str,
		number: str,
	    ) -> api.IssueDetail:
		u = "/%s/-/issues/%s" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.IssueDetail.safe_parse(data)
		
	# 获取指定 issue 评论。Get an issue comment.
	def get_issue_comment(self,
		repo: str,
		number: str,
		comment_id: str,
	    ) -> api.IssueComment:
		u = "/%s/-/issues/%s/comments/%s" % (repo, number, comment_id, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.IssueComment.safe_parse(data)
		
	# 查询指定 issue 的处理人。 List repository issue assignees.
	def list_issue_assignees(self,
		repo: str,
		number: str,
	    ) -> list[git_woa_com_cnb_monorepo_git_internal_app_vcs_service_bff_api.UserInfo]:
		u = "/%s/-/issues/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [git_woa_com_cnb_monorepo_git_internal_app_vcs_service_bff_api.UserInfo.safe_parse(item) for item in data]
		
	# 查询仓库的 issue 评论列表。List repository issue comments.
	def list_issue_comments(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.IssueComment]:
		u = "/%s/-/issues/%s/comments" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.IssueComment.safe_parse(item) for item in data]
		
	# 查询 issue 的标签列表。List labels for an issue.
	def list_issue_labels(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Label]:
		u = "/%s/-/issues/%s/labels" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Label.safe_parse(item) for item in data]
		
	# 查询仓库的 Issues。List issues.
	def list_issues(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		state: Optional[str] = None,
		keyword: Optional[str] = None,
		priority: Optional[str] = None,
		labels: Optional[str] = None,
		labels_operator: Optional[str] = None,
		authors: Optional[str] = None,
		assignees: Optional[str] = None,
		updated_time_begin: Optional[str] = None,
		updated_time_end: Optional[str] = None,
		close_time_begin: Optional[str] = None,
		close_time_end: Optional[str] = None,
		order_by: Optional[str] = None,
		) -> list[api.Issue]:
		u = "/%s/-/issues" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"state": state,
			"keyword": keyword,
			"priority": priority,
			"labels": labels,
			"labels_operator": labels_operator,
			"authors": authors,
			"assignees": assignees,
			"updated_time_begin": updated_time_begin,
			"updated_time_end": updated_time_end,
			"close_time_begin": close_time_begin,
			"close_time_end": close_time_end,
			"order_by": order_by,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Issue.safe_parse(item) for item in data]
		
	# 更新 issue 中的处理人。 Updates the assignees of an issue.
	def patch_issue_assignees(self,
		repo: str,
		number: str,
	    body_params: api.PatchIssueAssigneesForm,
		) -> api.IssueDetail:
		u = "/%s/-/issues/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueDetail.safe_parse(data)
		
	# 修改一个 issue 评论。Update an issue comment.
	def patch_issue_comment(self,
		repo: str,
		number: str,
		comment_id: str,
	    body_params: api.PatchIssueCommentForm,
		) -> api.IssueComment:
		u = "/%s/-/issues/%s/comments/%s" % (repo, number, comment_id, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueComment.safe_parse(data)
		
	# 添加处理人到指定的 issue。  Adds up to assignees to a issue, Users already assigned to an issue are not replaced.
	def post_issue_assignees(self,
		repo: str,
		number: str,
	    body_params: api.PostIssueAssigneesForm,
		) -> api.IssueDetail:
		u = "/%s/-/issues/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueDetail.safe_parse(data)
		
	# 创建一个 issue 评论。Create an issue comment.
	def post_issue_comment(self,
		repo: str,
		number: str,
	    body_params: api.PostIssueCommentForm,
		) -> api.IssueComment:
		u = "/%s/-/issues/%s/comments" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueComment.safe_parse(data)
		
	# 新增 issue 标签。Add labels to an issue.
	def post_issue_labels(self,
		repo: str,
		number: str,
	    body_params: api.PostIssueLabelsForm,
		) -> api.Label:
		u = "/%s/-/issues/%s/labels" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	# 设置 issue 标签。 Set the new labels for an issue.
	def put_issue_labels(self,
		repo: str,
		number: str,
	    body_params: api.PutIssueLabelsForm,
		) -> api.Label:
		u = "/%s/-/issues/%s/labels" % (repo, number, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	# 更新一个 Issue。Update an issue.
	def update_issue(self,
		repo: str,
		number: str,
	    body_params: api.PatchIssueForm,
		) -> api.IssueDetail:
		u = "/%s/-/issues/%s" % (repo, number, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.IssueDetail.safe_parse(data)
		
	