# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import dto
class RegistriesService:    
	def __init__(self, client):
		self._client = client

	# 删除制品。 Delete the specific package.
	def delete_package(self,
		slug: str,
		t: str,
		name: str,
	    ):
		u = "/%s/-/packages/%s/%s" % (slug, t, name, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除制品标签。 Delete the specific tag under specific package
	def delete_package_tag(self,
		slug: str,
		t: str,
		name: str,
		tag: str,
	    ):
		u = "/%s/-/packages/%s/%s/-/tag/%s" % (slug, t, name, tag, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除制品库。Delete the registry.
	def delete_registry(self,
		registry: str,
	    ):
		u = "/%s" % (registry, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询组织下面用户有权限查看到的制品仓库。Query all registries that the user has permission to see under specific organization.
	def get_group_sub_registries(self,
		slug: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		registry_type: Optional[str] = None,
		filter_type: Optional[str] = None,
		order_by: Optional[str] = None,
		desc: Optional[bool] = None,
		descendant: Optional[str] = None,
		search: Optional[str] = None,
		) -> list[dto.Registry4User]:
		u = "/%s/-/registries" % (slug, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"registry_type": registry_type,
			"filter_type": filter_type,
			"order_by": order_by,
			"desc": desc,
			"descendant": descendant,
			"search": search,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Registry4User.safe_parse(item) for item in data]
		
	# 获取指定制品的详细信息。 Get the package detail.
	def get_package(self,
		slug: str,
		t: str,
		name: str,
	    ) -> dto.PackageDetail:
		u = "/%s/-/packages/%s/%s" % (slug, t, name, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.PackageDetail.safe_parse(data)
		
	# 获取制品标签详情。 Get the specific tag under specific package.
	def get_package_tag_detail(self,
		slug: str,
		t: str,
		name: str,
		tag: str,
	    sha256: Optional[str] = None,
		arch: Optional[str] = None,
		) -> dto.TagDetail:
		u = "/%s/-/packages/%s/%s/-/tag/%s" % (slug, t, name, tag, )

		query_params = {
			"sha256": sha256,
			"arch": arch,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.TagDetail.safe_parse(data)
		
	# 查询制品标签列表。 List all tags under specific package.
	def list_package_tags(self,
		slug: str,
		t: str,
		name: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		key: Optional[str] = None,
		) -> dto.Tag:
		u = "/%s/-/packages/%s/%s/-/tags" % (slug, t, name, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			"name": key,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.Tag.safe_parse(data)
		
	# 查询制品列表。 List all packages.
	def list_packages(self,
		slug: str,
	    type: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		ordering: Optional[str] = None,
		name: Optional[str] = None,
		) -> list[dto.Package]:
		u = "/%s/-/packages" % (slug, )

		query_params = {
			"type": type,
			"page": page,
			"page_size": page_size,
			"ordering": ordering,
			"name": name,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Package.safe_parse(item) for item in data]
		
	# 改变制品仓库可见性。Update visibility of registry.
	def set_registry_visibility(self,
		registry: str,
	    visibility: Optional[str] = None,
		):
		u = "/%s/-/settings/set_visibility" % (registry, )

		query_params = {
			"visibility": visibility,
			}
		data = self._client.request(
			method="POST", 
			endpoint=u,
			params=query_params,
			)
		return 
		
	