# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import api
class RepolabelsService:    
	def __init__(self, client):
		self._client = client

	# 删除指定的仓库标签。Delete the specified repository label.
	def delete_label(self,
		repo: str,
		name: str,
	    ):
		u = "/%s/-/labels/%s" % (repo, name, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询仓库的标签列表。List repository labels.
	def list_labels(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		keyword: Optional[str] = None,
		) -> list[api.Label]:
		u = "/%s/-/labels" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"keyword": keyword,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Label.safe_parse(item) for item in data]
		
	# 更新标签信息。Update label information.
	def patch_label(self,
		repo: str,
		name: str,
	    body_params: api.PatchLabelForm,
		) -> api.Label:
		u = "/%s/-/labels/%s" % (repo, name, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	# 创建一个 标签。Create a label.
	def post_label(self,
		repo: str,
	    body_params: api.PostLabelForm,
		) -> api.Label:
		u = "/%s/-/labels" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	