# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import api
from .models import git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api
from .models import openapi
from .models import web
class GitService:    
	def __init__(self, client):
		self._client = client

	# 创建一个 blob。Create a blob.
	def create_blob(self,
		repo: str,
	    body_params: api.PostBlobForm,
		) -> api.Blob:
		u = "/%s/-/git/blobs" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Blob.safe_parse(data)
		
	# 创建新分支。Create a new branch based on a start point.
	def create_branch(self,
		repo: str,
	    body_params: openapi.CreateBranchForm,
		):
		u = "/%s/-/git/branches" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 创建一个 tag。Create a tag.
	def create_tag(self,
		repo: str,
	    body_params: api.PostTagFrom,
		) -> api.Tag:
		u = "/%s/-/git/tags" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Tag.safe_parse(data)
		
	# 删除指定分支。Delete the specified branch.
	def delete_branch(self,
		repo: str,
		branch: str,
	    ):
		u = "/%s/-/git/branches/%s" % (repo, branch, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除指定 commit 的元数据。Delete commit annotation.
	def delete_commit_annotation(self,
		repo: str,
		sha: str,
		key: str,
	    ):
		u = "/%s/-/git/commit-annotations/%s/%s" % (repo, sha, key, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除指定 commit 的附件。Delete commit asset.
	def delete_commit_asset(self,
		repo: str,
		sha1: str,
		asset_id: str,
	    ):
		u = "/%s/-/git/commit-assets/%s/%s" % (repo, sha1, asset_id, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除指定 tag。Delete the specified tag.
	def delete_tag(self,
		repo: str,
		tag: str,
	    ):
		u = "/%s/-/git/tags/%s" % (repo, tag, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 删除指定 tag 的元数据。Delete the metadata of the specified tag.
	def delete_tag_annotation(self,
		repo: str,
		tag_with_key: str,
	    ):
		u = "/%s/-/git/tag-annotations/%s" % (repo, tag_with_key, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 下载仓库内容
	def get_archive(self,
		repo: str,
		ref_with_path: str,
	    ):
		u = "/%s/-/git/archive/%s" % (repo, ref_with_path, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 打包下载 commit 变更文件。Download archive of changed files for a commit.
	def get_archive_commit_changed_files(self,
		repo: str,
		sha1: str,
	    ):
		u = "/%s/-/git/archive-commit-changed-files/%s" % (repo, sha1, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 打包下载两次 ref 之间的变更文件。Download archive of changed files for a compare.
	def get_archive_compare_changed_files(self,
		repo: str,
		base_head: str,
	    ):
		u = "/%s/-/git/archive-compare-changed-files/%s" % (repo, base_head, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 查询指定分支。Get a branch.
	def get_branch(self,
		repo: str,
		branch: str,
	    ) -> api.BranchDetail:
		u = "/%s/-/git/branches/%s" % (repo, branch, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.BranchDetail.safe_parse(data)
		
	# 查询指定 commit。Get a commit.
	def get_commit(self,
		repo: str,
		ref: str,
	    ) -> api.Commit:
		u = "/%s/-/git/commits/%s" % (repo, ref, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Commit.safe_parse(data)
		
	# 查询指定 commit 的元数据。Get commit annotations.
	def get_commit_annotations(self,
		repo: str,
		sha: str,
	    ) -> list[web.CommitAnnotation]:
		u = "/%s/-/git/commit-annotations/%s" % (repo, sha, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [web.CommitAnnotation.safe_parse(item) for item in data]
		
	# 查询指定 commit 的元数据。Get commit annotations in batch.
	def get_commit_annotations_in_batch(self,
		repo: str,
	    body_params: web.GetCommitAnnotationsInBatchForm,
		) -> list[web.CommitAnnotationInBatch]:
		u = "/%s/-/git/commit-annotations-in-batch" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return [web.CommitAnnotationInBatch.safe_parse(item) for item in data]
		
	# 查询指定 commit 的附件。List commit assets.
	def get_commit_assets_by_sha(self,
		repo: str,
		sha1: str,
	    ) -> list[api.CommitAsset]:
		u = "/%s/-/git/commit-assets/%s" % (repo, sha1, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [api.CommitAsset.safe_parse(item) for item in data]
		
	# 查询指定 commit 的提交状态。List commit check statuses.
	def get_commit_statuses(self,
		repo: str,
		commitish: str,
	    ) -> list[git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api.CommitStatus]:
		u = "/%s/-/git/commit-statuses/%s" % (repo, commitish, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api.CommitStatus.safe_parse(item) for item in data]
		
	# 比较两个提交、分支或标签之间差异的接口。Compare two commits, branches, or tags.
	def get_compare_commits(self,
		repo: str,
		base_head: str,
	    ) -> api.CompareResponse:
		u = "/%s/-/git/compare/%s" % (repo, base_head, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.CompareResponse.safe_parse(data)
		
	# 查询仓库文件列表或文件。List repository files or file.
	def get_content(self,
		repo: str,
		file_path: str,
	    ref: Optional[str] = None,
		) -> api.Content:
		u = "/%s/-/git/contents/%s" % (repo, file_path, )

		query_params = {
			"ref": ref,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return api.Content.safe_parse(data)
		
	# 查询仓库文件和目录内容。List repository files and directories.
	def get_content_without_path(self,
		repo: str,
	    ref: Optional[str] = None,
		) -> api.Content:
		u = "/%s/-/git/contents" % (repo, )

		query_params = {
			"ref": ref,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return api.Content.safe_parse(data)
		
	# 获取仓库默认分支。Get the default branch of the repository.
	def get_head(self,
		repo: str,
	    ) -> openapi.HeadRef:
		u = "/%s/-/git/head" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return openapi.HeadRef.safe_parse(data)
		
	# 获得仓库指定文件内容
	def get_raw(self,
		repo: str,
		ref_with_path: str,
	    max_in_byte: Optional[int] = None,
		) -> str:
		u = "/%s/-/git/raw/%s" % (repo, ref_with_path, )

		query_params = {
			"max_in_byte": max_in_byte,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return str.safe_parse(data)
		
	# 查询指定 tag。Get a tag.
	def get_tag(self,
		repo: str,
		tag: str,
	    ) -> api.Tag:
		u = "/%s/-/git/tags/%s" % (repo, tag, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Tag.safe_parse(data)
		
	# 查询指定 tag 的元数据。Query the metadata of the specified tag.
	def get_tag_annotations(self,
		repo: str,
		tag: str,
	    ) -> list[web.TagAnnotation]:
		u = "/%s/-/git/tag-annotations/%s" % (repo, tag, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [web.TagAnnotation.safe_parse(item) for item in data]
		
	# 查询分支列表。List branches.
	def list_branches(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Branch]:
		u = "/%s/-/git/branches" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Branch.safe_parse(item) for item in data]
		
	# 查询 commit 列表。List commits.
	def list_commits(self,
		repo: str,
	    sha: Optional[str] = None,
		author: Optional[str] = None,
		committer: Optional[str] = None,
		since: Optional[str] = None,
		until: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Commit]:
		u = "/%s/-/git/commits" % (repo, )

		query_params = {
			"sha": sha,
			"author": author,
			"committer": committer,
			"since": since,
			"until": until,
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Commit.safe_parse(item) for item in data]
		
	# 查询 tag 列表。List tags.
	def list_tags(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Tag]:
		u = "/%s/-/git/tags" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Tag.safe_parse(item) for item in data]
		
	# 确认 commit 附件上传完成。Confirm commit asset upload.
	def post_commit_asset_upload_confirmation(self,
		repo: str,
		sha1: str,
		upload_token: str,
		asset_path: str,
	    ):
		u = "/%s/-/git/commit-assets/%s/asset-upload-confirmation/%s/%s" % (repo, sha1, upload_token, asset_path, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return 
		
	# 新增一个 commit 附件。Create a commit asset.
	def post_commit_asset_upload_url(self,
		repo: str,
		sha1: str,
	    body_params: openapi.PostCommitAssetUploadURLForm,
		) -> openapi.CommitAssetUploadURL:
		u = "/%s/-/git/commit-assets/%s/asset-upload-url" % (repo, sha1, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return openapi.CommitAssetUploadURL.safe_parse(data)
		
	# 设定指定 commit 的元数据。Put commit annotations.
	def put_commit_annotations(self,
		repo: str,
		sha: str,
	    body_params: openapi.PutCommitAnnotationsForm,
		):
		u = "/%s/-/git/commit-annotations/%s" % (repo, sha, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 设定指定 tag 的元数据。Set the metadata of the specified tag.
	def put_tag_annotations(self,
		repo: str,
		tag: str,
	    body_params: openapi.PutTagAnnotationsForm,
		):
		u = "/%s/-/git/tag-annotations/%s" % (repo, tag, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	