# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import dto
class MissionsService:    
	def __init__(self, client):
		self._client = client

	# 创建任务集。Create a mission.
	def create_mission(self,
		slug: str,
	    body_params: dto.CreateMissionReq,
		):
		u = "/%s/-/missions" % (slug, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 删除指定任务集。Delete the specified mission.
	def delete_mission(self,
		mission: str,
	    ):
		u = "/%s" % (mission, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询组织下面用户有权限查看到的任务集。Query all missions that the user has permission to see under the specific organization.
	def get_group_sub_missions(self,
		slug: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		filter_type: Optional[str] = None,
		order_by: Optional[str] = None,
		desc: Optional[bool] = None,
		descendant: Optional[str] = None,
		search: Optional[str] = None,
		) -> list[dto.Missions4User]:
		u = "/%s/-/missions" % (slug, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"filter_type": filter_type,
			"order_by": order_by,
			"desc": desc,
			"descendant": descendant,
			"search": search,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Missions4User.safe_parse(item) for item in data]
		
	# 查询任务集视图配置信息。Get mission view config.
	def get_mission_view_config(self,
		mission: str,
	    id: Optional[str] = None,
		) -> dto.MissionViewConfig:
		u = "/%s/-/mission/view" % (mission, )

		query_params = {
			"id": id,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.MissionViewConfig.safe_parse(data)
		
	# 获取任务集视图列表。Get view list of a mission.
	def get_mission_view_list(self,
		mission: str,
	    ) -> list[dto.MissionView]:
		u = "/%s/-/mission/view-list" % (mission, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [dto.MissionView.safe_parse(item) for item in data]
		
	# 设置任务集视图配置信息。Set mission view config.
	def post_mission_view_config(self,
		mission: str,
	    body_params: dto.MissionViewConfig,
		):
		u = "/%s/-/mission/view" % (mission, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 排序任务集视图。Sort mission view list.
	def post_mission_view_list(self,
		mission: str,
	    body_params: dto.MissionPostViewReq,
		):
		u = "/%s/-/mission/view-list" % (mission, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 添加、修改任务集视图。Update a mission view or add a new one.
	def put_mission_view_list(self,
		mission: str,
	    body_params: dto.MissionView,
		):
		u = "/%s/-/mission/view-list" % (mission, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 改变任务集可见性。Update the visibility of a mission.
	def set_mission_visibility(self,
		mission: str,
	    visibility: Optional[str] = None,
		):
		u = "/%s/-/settings/set_visibility" % (mission, )

		query_params = {
			"visibility": visibility,
			}
		data = self._client.request(
			method="POST", 
			endpoint=u,
			params=query_params,
			)
		return 
		
	