# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import api
from .models import git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api
class PullsService:    
	def __init__(self, client):
		self._client = client

	# 检查用户是否可以被添加到合并请求的处理人中。 Checks if a user can be assigned to a pull request.
	def can_user_be_assigned_to_pull(self,
		repo: str,
		number: str,
		assignee: str,
	    ):
		u = "/%s/-/pulls/%s/assignees/%s" % (repo, number, assignee, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 删除合并请求中的处理人 Removes one or more assignees from a pull request.
	def delete_pull_assignees(self,
		repo: str,
		number: str,
	    body_params: api.DeletePullAssigneesForm,
		) -> api.Pull:
		u = "/%s/-/pulls/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 删除合并请求标签。Remove a label from a pull.
	def delete_pull_label(self,
		repo: str,
		number: str,
		name: str,
	    ) -> api.Label:
		u = "/%s/-/pulls/%s/labels/%s" % (repo, number, name, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return api.Label.safe_parse(data)
		
	# 清空合并请求标签。Remove all labels from a pull.
	def delete_pull_labels(self,
		repo: str,
		number: str,
	    ):
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 查询指定合并请求。Get a pull request.
	def get_pull(self,
		repo: str,
		number: str,
	    ) -> api.Pull:
		u = "/%s/-/pulls/%s" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.Pull.safe_parse(data)
		
	# 获取一个合并请求评论。Get a pull comment.
	def get_pull_comment(self,
		repo: str,
		number: str,
		comment_id: str,
	    ) -> api.PullRequestComment:
		u = "/%s/-/pulls/%s/comments/%s" % (repo, number, comment_id, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.PullRequestComment.safe_parse(data)
		
	# 查询指定合并请求的处理人。List repository pull request assignees.
	def list_pull_assignees(self,
		repo: str,
		number: str,
	    ) -> list[git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api.UserInfo]:
		u = "/%s/-/pulls/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [git_woa_com_cnb_monorepo_git_internal_app_git_service_bff_api.UserInfo.safe_parse(item) for item in data]
		
	# 查询合并请求评论列表。List pull comments requests.
	def list_pull_comments(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.PullRequestComment]:
		u = "/%s/-/pulls/%s/comments" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullRequestComment.safe_parse(item) for item in data]
		
	# 查询 Pull 的状态检查
	def list_pull_commit_statuses(self,
		repo: str,
		number: str,
	    ) -> api.CommitStatuses:
		u = "/%s/-/pulls/%s/commit-statuses" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return api.CommitStatuses.safe_parse(data)
		
	# 查询指定合并请求的提交列表。Lists the commits in a specified pull request.
	def list_pull_commits(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Commit]:
		u = "/%s/-/pulls/%s/commits" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Commit.safe_parse(item) for item in data]
		
	# 查询指定合并请求的文件列表。Lists the files in a specified pull request.
	def list_pull_files(self,
		repo: str,
		number: str,
	    ) -> list[api.PullFile]:
		u = "/%s/-/pulls/%s/files" % (repo, number, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [api.PullFile.safe_parse(item) for item in data]
		
	# 查询指定合并请求的标签列表。List labels for a pull.
	def list_pull_labels(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.Label]:
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.Label.safe_parse(item) for item in data]
		
	# 查询指定合并请求评审评论列表。List pull review comments.
	def list_pull_review_comments(self,
		repo: str,
		number: str,
		review_id: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.PullReviewComment]:
		u = "/%s/-/pulls/%s/reviews/%s/comments" % (repo, number, review_id, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullReviewComment.safe_parse(item) for item in data]
		
	# 查询特定合并请求的评审列表。List pull reviews.
	def list_pull_reviews(self,
		repo: str,
		number: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> list[api.PullReview]:
		u = "/%s/-/pulls/%s/reviews" % (repo, number, )

		query_params = {
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullReview.safe_parse(item) for item in data]
		
	# 查询合并请求列表。List pull requests.
	def list_pulls(self,
		repo: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		state: Optional[str] = None,
		authors: Optional[str] = None,
		reviewers: Optional[str] = None,
		assignees: Optional[str] = None,
		base_ref: Optional[str] = None,
		) -> list[api.PullRequest]:
		u = "/%s/-/pulls" % (repo, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"state": state,
			"authors": authors,
			"reviewers": reviewers,
			"assignees": assignees,
			"base_ref": base_ref,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullRequest.safe_parse(item) for item in data]
		
	# 根据 number 列表查询合并请求列表。List pull requests by numbers.
	def list_pulls_by_numbers(self,
		repo: str,
	    n: Optional[list[str]] = None,
		) -> list[api.PullRequestInfo]:
		u = "/%s/-/pull-in-batch" % (repo, )

		query_params = {
			"n": n,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [api.PullRequestInfo.safe_parse(item) for item in data]
		
	# 合并一个合并请求。Merge a pull request.
	def merge_pull(self,
		repo: str,
		number: str,
	    body_params: api.MergePullRequest,
		) -> api.MergePullResponse:
		u = "/%s/-/pulls/%s/merge" % (repo, number, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.MergePullResponse.safe_parse(data)
		
	# 更新一个合并请求。Update a pull request.
	def patch_pull(self,
		repo: str,
		number: str,
	    body_params: api.PatchPullRequest,
		) -> api.Pull:
		u = "/%s/-/pulls/%s" % (repo, number, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 更新一个合并请求评论。Update a pull comment.
	def patch_pull_comment(self,
		repo: str,
		number: str,
		comment_id: str,
	    body_params: api.PatchPullCommentForm,
		) -> api.PullRequestComment:
		u = "/%s/-/pulls/%s/comments/%s" % (repo, number, comment_id, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.PullRequestComment.safe_parse(data)
		
	# 新增一个合并请求。Create a pull request.
	def post_pull(self,
		repo: str,
	    body_params: api.PullCreationForm,
		) -> api.Pull:
		u = "/%s/-/pulls" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 添加处理人到指定的合并请求。 Adds up to assignees to a pull request. Users already assigned to an issue are not replaced.
	def post_pull_assignees(self,
		repo: str,
		number: str,
	    body_params: api.PostPullAssigneesForm,
		) -> api.Pull:
		u = "/%s/-/pulls/%s/assignees" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Pull.safe_parse(data)
		
	# 新增一个合并请求评论。Create a pull comment.
	def post_pull_comment(self,
		repo: str,
		number: str,
	    body_params: api.PullCommentCreationForm,
		) -> api.PullRequestComment:
		u = "/%s/-/pulls/%s/comments" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.PullRequestComment.safe_parse(data)
		
	# 新增合并请求标签。Add labels to a pull.
	def post_pull_labels(self,
		repo: str,
		number: str,
	    body_params: api.PostPullLabelsForm,
		) -> api.Label:
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	# 新增一次合并请求评审。Create a pull review.
	def post_pull_review(self,
		repo: str,
		number: str,
	    body_params: api.PullReviewCreationForm,
		):
		u = "/%s/-/pulls/%s/reviews" % (repo, number, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 设置合并请求标签。Set the new labels for a pull.
	def put_pull_labels(self,
		repo: str,
		number: str,
	    body_params: api.PutPullLabelsForm,
		) -> api.Label:
		u = "/%s/-/pulls/%s/labels" % (repo, number, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return api.Label.safe_parse(data)
		
	