# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import dto
class BuildService:    
	def __init__(self, client):
		self._client = client

	# 同步仓库分支下的定时任务。 Synchronize the content under the repository branch.
	def build_crontab_sync(self,
		repo: str,
		branch: str,
	    ) -> dto.BuildCommonResult:
		u = "/%s/-/build/crontab/sync/%s" % (repo, branch, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return dto.BuildCommonResult.safe_parse(data)
		
	# 删除流水线日志内容。Delete pipeline logs content.
	def build_logs_delete(self,
		repo: str,
		sn: str,
	    ) -> dto.BuildCommonResult:
		u = "/%s/-/build/logs/%s" % (repo, sn, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return dto.BuildCommonResult.safe_parse(data)
		
	# 流水线runner日志下载。Pipeline runner log download.
	def build_runner_download_log(self,
		repo: str,
		pipelineId: str,
	    ):
		u = "/%s/-/build/runner/download/log/%s" % (repo, pipelineId, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return 
		
	# 查询流水线构建列表。List pipeline builds.
	def get_build_logs(self,
		repo: str,
	    createTime: Optional[str] = None,
		endTime: Optional[str] = None,
		event: Optional[str] = None,
		page: Optional[int] = None,
		pagesize: Optional[int] = None,
		sha: Optional[str] = None,
		sn: Optional[str] = None,
		sourceRef: Optional[str] = None,
		status: Optional[str] = None,
		targetRef: Optional[str] = None,
		userId: Optional[str] = None,
		userName: Optional[str] = None,
		) -> dto.BuildLogsResult:
		u = "/%s/-/build/logs" % (repo, )

		query_params = {
			"createTime": createTime,
			"endTime": endTime,
			"event": event,
			"page": page,
			"pagesize": pagesize,
			"sha": sha,
			"sn": sn,
			"sourceRef": sourceRef,
			"status": status,
			"targetRef": targetRef,
			"userId": userId,
			"userName": userName,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.BuildLogsResult.safe_parse(data)
		
	# 查询流水线Stage详情。Get pipeline build stage detail.
	def get_build_stage(self,
		repo: str,
		sn: str,
		pipelineId: str,
		stageId: str,
	    ) -> dto.BuildStageResult:
		u = "/%s/-/build/logs/stage/%s/%s/%s" % (repo, sn, pipelineId, stageId, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.BuildStageResult.safe_parse(data)
		
	# 查询流水线构建状态。Get pipeline build status.
	def get_build_status(self,
		repo: str,
		sn: str,
	    ) -> dto.BuildStatusResult:
		u = "/%s/-/build/status/%s" % (repo, sn, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.BuildStatusResult.safe_parse(data)
		
	# 开始一个构建。Start a build.
	def start_build(self,
		repo: str,
	    body_params: dto.StartBuildReq,
		) -> dto.BuildResult:
		u = "/%s/-/build/start" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return dto.BuildResult.safe_parse(data)
		
	# 停止一个构建。 Stop a build.
	def stop_build(self,
		repo: str,
		sn: str,
	    ) -> dto.BuildResult:
		u = "/%s/-/build/stop/%s" % (repo, sn, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return dto.BuildResult.safe_parse(data)
		
	