# Code generated by cnb.cool/cnb/sdk/cnb-sdk-generator. DO NOT EDIT.
# versions:
#    cnb-sdk-generator: 1.0.2
# source: https://api.cnb-dev.woa.com/swagger.json

from typing import Optional
from .models import dto
class RepositoriesService:    
	def __init__(self, client):
		self._client = client

	# 仓库归档。Archive a repository.
	def archive_repo(self,
		slug: str,
	    ):
		u = "/%s/-/settings/archive" % (slug, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return 
		
	# 创建仓库。Create repositories.
	def create_repo(self,
		slug: str,
	    body_params: dto.CreateRepoReq,
		):
		u = "/%s/-/repos" % (slug, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 删除指定仓库。Delete the specified repository.
	def delete_repo(self,
		repo: str,
	    ):
		u = "/%s" % (repo, )

		data = self._client.request(
			method="DELETE", 
			endpoint=u,
			)
		return 
		
	# 获取指定仓库信息。Get information for the specified repository.
	def get_by_id(self,
		repo: str,
	    ) -> dto.Repos4User:
		u = "/%s" % (repo, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return dto.Repos4User.safe_parse(data)
		
	# 查询组织下访问用户有权限查看到仓库。List the repositories that the user has access to.
	def get_group_sub_repos(self,
		slug: str,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		filter_type: Optional[str] = None,
		flags: Optional[str] = None,
		status: Optional[str] = None,
		order_by: Optional[str] = None,
		desc: Optional[bool] = None,
		descendant: Optional[str] = None,
		search: Optional[str] = None,
		) -> list[dto.Repos4User]:
		u = "/%s/-/repos" % (slug, )

		query_params = {
			"page": page,
			"page_size": page_size,
			"filter_type": filter_type,
			"flags": flags,
			"status": status,
			"order_by": order_by,
			"desc": desc,
			"descendant": descendant,
			"search": search,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Repos4User.safe_parse(item) for item in data]
		
	# 获取指定组织的仓库墙列表。List the pinned repositories of a group.
	def get_pinned_repo_by_group(self,
		slug: str,
	    ) -> list[dto.Repos4UserBase]:
		u = "/%s/-/pinned-repos" % (slug, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [dto.Repos4UserBase.safe_parse(item) for item in data]
		
	# 获取指定用户的用户仓库墙。 Get a list of repositories that the specified user has pinned.
	def get_pinned_repo_by_id(self,
		username: str,
	    ) -> list[dto.Repos4User]:
		u = "/users/%s/pinned-repos" % (username, )

		data = self._client.request(
			method="GET", 
			endpoint=u,
			)
		return [dto.Repos4User.safe_parse(item) for item in data]
		
	# 获取当前用户拥有指定权限及其以上权限的仓库。List repositories owned by the current user with the specified permissions or higher.
	def get_repos(self,
	    page: Optional[int] = None,
		page_size: Optional[int] = None,
		search: Optional[str] = None,
		filter_type: Optional[str] = None,
		role: Optional[str] = None,
		flags: Optional[str] = None,
		status: Optional[str] = None,
		order_by: Optional[str] = None,
		desc: Optional[bool] = None,
		) -> list[dto.Repos4User]:
		u = "/user/repos" % ()

		query_params = {
			"page": page,
			"page_size": page_size,
			"search": search,
			"filter_type": filter_type,
			"role": role,
			"flags": flags,
			"status": status,
			"order_by": order_by,
			"desc": desc,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Repos4User.safe_parse(item) for item in data]
		
	# 获取指定用户有指定以上权限并且客人态可见的仓库。List repositories where the specified user has the specified permission level or higher and are visible to guests.
	def get_repos_by_user_name(self,
		username: str,
	    search: Optional[str] = None,
		filter_type: Optional[str] = None,
		flags: Optional[str] = None,
		status: Optional[str] = None,
		role: Optional[str] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		desc: Optional[bool] = None,
		order_by: Optional[str] = None,
		) -> list[dto.Repos4User]:
		u = "/users/%s/repos" % (username, )

		query_params = {
			"search": search,
			"filter_type": filter_type,
			"flags": flags,
			"status": status,
			"role": role,
			"page": page,
			"page_size": page_size,
			"desc": desc,
			"order_by": order_by,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return [dto.Repos4User.safe_parse(item) for item in data]
		
	# 获取指定仓库的 fork 列表。Get fork list for specified repository.
	def list_forks_repos(self,
		repo: str,
	    start_from_root: Optional[bool] = None,
		page: Optional[int] = None,
		page_size: Optional[int] = None,
		) -> dto.ListForks:
		u = "/%s/-/forks" % (repo, )

		query_params = {
			"start_from_root": start_from_root,
			"page": page,
			"page_size": page_size,
			}
		data = self._client.request(
			method="GET", 
			endpoint=u,
			params=query_params,
			)
		return dto.ListForks.safe_parse(data)
		
	# 更新指定组织仓库墙。Update the pinned repositories of a group.
	def set_pinned_repo_by_group(self,
		slug: str,
	    body_params: list[str],
		) -> list[dto.Repos4UserBase]:
		u = "/%s/-/pinned-repos" % (slug, )

		data = self._client.request(
			method="PUT", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return [dto.Repos4UserBase.safe_parse(item) for item in data]
		
	# 改变仓库可见性。Update visibility of repository.
	def set_repo_visibility(self,
		repo: str,
	    visibility: Optional[str] = None,
		):
		u = "/%s/-/settings/set_visibility" % (repo, )

		query_params = {
			"visibility": visibility,
			}
		data = self._client.request(
			method="POST", 
			endpoint=u,
			params=query_params,
			)
		return 
		
	# 转移仓库。Transfer a repository.
	def transfer_repo(self,
		repo: str,
	    body_params: dto.TransferSlugReq,
		):
		u = "/%s/-/transfer" % (repo, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	# 解除仓库归档。Unarchive a repository.
	def un_archive_repo(self,
		slug: str,
	    ):
		u = "/%s/-/settings/unarchive" % (slug, )

		data = self._client.request(
			method="POST", 
			endpoint=u,
			)
		return 
		
	# 更新仓库信息, 可更新的内容为: 仓库简介, 仓库站点, 仓库主题, 开源许可证。updates repository details including description, website URL,topics and license type.
	def update_repo(self,
		repo: str,
	    body_params: dto.RepoPatch,
		):
		u = "/%s" % (repo, )

		data = self._client.request(
			method="PATCH", 
			endpoint=u,
			json=body_params.to_dict(),
			)
		return 
		
	