# -*- coding: utf-8 -*-


def get_indexed_data(key_func):

    data = {
        'municipalities':{},
        'countries': {},
        'codes': {},
    }
    deleted_suffix = '(soppresso)'
    for municipality in _MUNICIPALITIES:
        code = municipality['code']
        names = municipality['name'].replace(deleted_suffix, '').strip().split('/')
        province = municipality['province'].lower()
        for name in names:
            key = key_func(name)
            data['municipalities'][key] = municipality
            data['municipalities'][key + '-' + province] = municipality
        if code not in data['codes'] or deleted_suffix not in municipality['name']:
            data['codes'][code] = municipality

    for country in _COUNTRIES:
        code = country['code']
        names = country['name'].strip().split('/')
        for name in names:
            key = key_func(name)
            data['countries'][key] = country
        data['codes'][code] = country

    return data


_MUNICIPALITIES = [
    { "code": "A001", "province": "PD", "name": "ABANO (soppresso)" },
    { "code": "A001", "province": "PD", "name": "ABANO TERME" },
    { "code": "A003", "province": "TO", "name": "ABBADIA ALPINA (soppresso)" },
    { "code": "A004", "province": "MI", "name": "ABBADIA CERRETO (soppresso)" },
    { "code": "A004", "province": "LO", "name": "ABBADIA CERRETO" },
    { "code": "A005", "province": "CO", "name": "ABBADIA LARIANA (soppresso)" },
    { "code": "A005", "province": "LC", "name": "ABBADIA LARIANA" },
    { "code": "A006", "province": "SI", "name": "ABBADIA SAN SALVATORE" },
    { "code": "A002", "province": "CO", "name": "ABBADIA SOPRA ADDA (soppresso)" },
    { "code": "A007", "province": "CA", "name": "ABBASANTA (soppresso)" },
    { "code": "A007", "province": "OR", "name": "ABBASANTA" },
    { "code": "A008", "province": "CH", "name": "ABBATEGGIO (soppresso)" },
    { "code": "A008", "province": "PE", "name": "ABBATEGGIO" },
    { "code": "A009", "province": "FU", "name": "ABBAZIA (soppresso)" },
    { "code": "A010", "province": "MI", "name": "ABBIATEGRASSO" },
    { "code": "A011", "province": "CO", "name": "ABBIATEGUAZZONE (soppresso)" },
    { "code": "A011", "province": "VA", "name": "ABBIATEGUAZZONE (soppresso)" },
    { "code": "A012", "province": "PT", "name": "ABETONE (soppresso)" },
    { "code": "M376", "province": "PT", "name": "ABETONE CUTIGLIANO" },
    { "code": "A013", "province": "PZ", "name": "ABRIOLA" },
    { "code": "A014", "province": "RG", "name": "ACATE" },
    { "code": "A015", "province": "AV", "name": "ACCADIA (soppresso)" },
    { "code": "A015", "province": "FG", "name": "ACCADIA" },
    { "code": "A016", "province": "CN", "name": "ACCEGLIO" },
    { "code": "A017", "province": "PZ", "name": "ACCETTURA (soppresso)" },
    { "code": "A017", "province": "MT", "name": "ACCETTURA" },
    { "code": "A018", "province": "AQ", "name": "ACCIANO" },
    { "code": "A019", "province": "AQ", "name": "ACCUMOLI (soppresso)" },
    { "code": "A019", "province": "RI", "name": "ACCUMOLI" },
    { "code": "A020", "province": "PZ", "name": "ACERENZA" },
    { "code": "A021", "province": "TN", "name": "ACERETO (soppresso)" },
    { "code": "A021", "province": "BZ", "name": "ACERETO (soppresso)" },
    { "code": "A022", "province": "TN", "name": "ACERNES (soppresso)" },
    { "code": "A023", "province": "SA", "name": "ACERNO" },
    { "code": "A024", "province": "CE", "name": "ACERRA (soppresso)" },
    { "code": "A024", "province": "NA", "name": "ACERRA" },
    { "code": "A025", "province": "CT", "name": "ACI BONACCORSI" },
    { "code": "A026", "province": "CT", "name": "ACI CASTELLO" },
    { "code": "A027", "province": "CT", "name": "ACI CATENA" },
    { "code": "A029", "province": "CT", "name": "ACI SANT'ANTONIO" },
    { "code": "A028", "province": "CT", "name": "ACIREALE" },
    { "code": "A031", "province": "MC", "name": "ACQUACANINA (soppresso)" },
    { "code": "A032", "province": "CE", "name": "ACQUAFONDATA (soppresso)" },
    { "code": "A032", "province": "FR", "name": "ACQUAFONDATA" },
    { "code": "A033", "province": "CS", "name": "ACQUAFORMOSA" },
    { "code": "A034", "province": "BS", "name": "ACQUAFREDDA" },
    { "code": "A035", "province": "PS", "name": "ACQUALAGNA (soppresso)" },
    { "code": "A035", "province": "PU", "name": "ACQUALAGNA" },
    { "code": "A036", "province": "BS", "name": "ACQUALUNGA (soppresso)" },
    { "code": "A039", "province": "CR", "name": "ACQUANEGRA CREMONESE" },
    { "code": "A038", "province": "MN", "name": "ACQUANEGRA SUL CHIESE" },
    { "code": "A040", "province": "RM", "name": "ACQUAPENDENTE (soppresso)" },
    { "code": "A040", "province": "VT", "name": "ACQUAPENDENTE" },
    { "code": "A041", "province": "CS", "name": "ACQUAPPESA" },
    { "code": "A042", "province": "LE", "name": "ACQUARICA DEL CAPO (soppresso)" },
    { "code": "A043", "province": "CZ", "name": "ACQUARO (soppresso)" },
    { "code": "A043", "province": "VV", "name": "ACQUARO" },
    { "code": "A044", "province": "AP", "name": "ACQUASANTA (soppresso)" },
    { "code": "A044", "province": "AP", "name": "ACQUASANTA TERME" },
    { "code": "A045", "province": "PG", "name": "ACQUASPARTA (soppresso)" },
    { "code": "A045", "province": "TR", "name": "ACQUASPARTA" },
    { "code": "A046", "province": "CO", "name": "ACQUATE (soppresso)" },
    { "code": "A050", "province": "CB", "name": "ACQUAVIVA COLLECROCE" },
    { "code": "A048", "province": "BA", "name": "ACQUAVIVA DELLE FONTI" },
    { "code": "A051", "province": "CB", "name": "ACQUAVIVA D'ISERNIA (soppresso)" },
    { "code": "A051", "province": "IS", "name": "ACQUAVIVA D'ISERNIA" },
    { "code": "A047", "province": "AP", "name": "ACQUAVIVA PICENA" },
    { "code": "A049", "province": "CL", "name": "ACQUAVIVA PLATANI" },
    { "code": "M211", "province": "ME", "name": "ACQUEDOLCI" },
    { "code": "A052", "province": "AL", "name": "ACQUI (soppresso)" },
    { "code": "A052", "province": "AL", "name": "ACQUI TERME" },
    { "code": "A053", "province": "CS", "name": "ACRI" },
    { "code": "A054", "province": "RM", "name": "ACUTO (soppresso)" },
    { "code": "A054", "province": "FR", "name": "ACUTO" },
    { "code": "A055", "province": "BA", "name": "ADELFIA" },
    { "code": "A056", "province": "CT", "name": "ADERNO' (soppresso)" },
    { "code": "A056", "province": "CT", "name": "ADRANO" },
    { "code": "A057", "province": "BG", "name": "ADRARA SAN MARTINO" },
    { "code": "A058", "province": "BG", "name": "ADRARA SAN ROCCO" },
    { "code": "A059", "province": "RO", "name": "ADRIA" },
    { "code": "A060", "province": "BS", "name": "ADRO" },
    { "code": "A061", "province": "VR", "name": "AFFI" },
    { "code": "A062", "province": "RM", "name": "AFFILE" },
    { "code": "A063", "province": "MI", "name": "AFFORI (soppresso)" },
    { "code": "A064", "province": "NA", "name": "AFRAGOLA" },
    { "code": "A065", "province": "RC", "name": "AFRICO" },
    { "code": "A066", "province": "NO", "name": "AGARO (soppresso)" },
    { "code": "A067", "province": "PC", "name": "AGAZZANO" },
    { "code": "A068", "province": "NA", "name": "AGEROLA" },
    { "code": "A069", "province": "SS", "name": "AGGIUS" },
    { "code": "A069", "province": "OT", "name": "AGGIUS (soppresso)" },
    { "code": "A070", "province": "CT", "name": "AGIRA (soppresso)" },
    { "code": "A070", "province": "EN", "name": "AGIRA" },
    { "code": "A071", "province": "FI", "name": "AGLIANA (soppresso)" },
    { "code": "A071", "province": "PT", "name": "AGLIANA" },
    { "code": "A072", "province": "AL", "name": "AGLIANO (soppresso)" },
    { "code": "A072", "province": "AT", "name": "AGLIANO (soppresso)" },
    { "code": "A072", "province": "AT", "name": "AGLIANO TERME" },
    { "code": "A074", "province": "TO", "name": "AGLIE'" },
    { "code": "A074", "province": "AO", "name": "AGLIE' (soppresso)" },
    { "code": "H848", "province": "SS", "name": "AGLIENTU" },
    { "code": "H848", "province": "OT", "name": "AGLIENTU (soppresso)" },
    { "code": "A075", "province": "PD", "name": "AGNA" },
    { "code": "A076", "province": "CR", "name": "AGNADELLO" },
    { "code": "A077", "province": "RC", "name": "AGNANA CALABRA" },
    { "code": "A078", "province": "NO", "name": "AGNELLENGO (soppresso)" },
    { "code": "A079", "province": "NO", "name": "AGNONA (soppresso)" },
    { "code": "A079", "province": "VC", "name": "AGNONA (soppresso)" },
    { "code": "A080", "province": "CB", "name": "AGNONE (soppresso)" },
    { "code": "A080", "province": "IS", "name": "AGNONE" },
    { "code": "A082", "province": "BS", "name": "AGNOSINE" },
    { "code": "A083", "province": "BL", "name": "AGORDO" },
    { "code": "A084", "province": "RM", "name": "AGOSTA" },
    { "code": "A085", "province": "CO", "name": "AGRA (soppresso)" },
    { "code": "A085", "province": "VA", "name": "AGRA" },
    { "code": "A086", "province": "NO", "name": "AGRANO (soppresso)" },
    { "code": "A087", "province": "MI", "name": "AGRATE BRIANZA (soppresso)" },
    { "code": "A087", "province": "MB", "name": "AGRATE BRIANZA" },
    { "code": "A088", "province": "NO", "name": "AGRATE CONTURBIA" },
    { "code": "A089", "province": "AG", "name": "AGRIGENTO" },
    { "code": "A090", "province": "TN", "name": "AGRONE (soppresso)" },
    { "code": "A091", "province": "SA", "name": "AGROPOLI" },
    { "code": "A092", "province": "AN", "name": "AGUGLIANO" },
    { "code": "A093", "province": "VI", "name": "AGUGLIARO" },
    { "code": "A094", "province": "AO", "name": "AIAS (soppresso)" },
    { "code": "A095", "province": "GO", "name": "AIBA (soppresso)" },
    { "code": "A095", "province": "UD", "name": "AIBA (soppresso)" },
    { "code": "A096", "province": "MI", "name": "AICURZIO (soppresso)" },
    { "code": "A096", "province": "MB", "name": "AICURZIO" },
    { "code": "A097", "province": "CA", "name": "AIDOMAGGIORE (soppresso)" },
    { "code": "A097", "province": "OR", "name": "AIDOMAGGIORE" },
    { "code": "A098", "province": "CL", "name": "AIDONE (soppresso)" },
    { "code": "A098", "province": "EN", "name": "AIDONE" },
    { "code": "A099", "province": "GO", "name": "AIDUSSINA (soppresso)" },
    { "code": "A099", "province": "UD", "name": "AIDUSSINA (soppresso)" },
    { "code": "A100", "province": "AQ", "name": "AIELLI" },
    { "code": "A102", "province": "CS", "name": "AIELLO CALABRO" },
    { "code": "A103", "province": "UD", "name": "AIELLO DEL FRIULI" },
    { "code": "A101", "province": "AV", "name": "AIELLO DEL SABATO" },
    { "code": "A104", "province": "CS", "name": "AIELLO IN CALABRIA (soppresso)" },
    { "code": "A105", "province": "CS", "name": "AIETA" },
    { "code": "A106", "province": "CE", "name": "AILANO" },
    { "code": "A106", "province": "BN", "name": "AILANO (soppresso)" },
    { "code": "A107", "province": "NO", "name": "AILOCHE (soppresso)" },
    { "code": "A107", "province": "VC", "name": "AILOCHE (soppresso)" },
    { "code": "A107", "province": "BI", "name": "AILOCHE" },
    { "code": "A108", "province": "AO", "name": "AIMAVILLA (soppresso)" },
    { "code": "A109", "province": "TO", "name": "AIRASCA" },
    { "code": "A110", "province": "BN", "name": "AIROLA" },
    { "code": "A111", "province": "IM", "name": "AIROLE" },
    { "code": "A112", "province": "CO", "name": "AIRUNO (soppresso)" },
    { "code": "A112", "province": "LC", "name": "AIRUNO" },
    { "code": "A113", "province": "CN", "name": "AISONE" },
    { "code": "A114", "province": "CO", "name": "AIZURRO (soppresso)" },
    { "code": "A116", "province": "TN", "name": "ALA" },
    { "code": "A115", "province": "SS", "name": "ALA' DEI SARDI" },
    { "code": "A115", "province": "OT", "name": "ALA' DEI SARDI (soppresso)" },
    { "code": "A117", "province": "TO", "name": "ALA DI STURA" },
    { "code": "A118", "province": "PV", "name": "ALAGNA" },
    { "code": "A119", "province": "NO", "name": "ALAGNA VALSESIA (soppresso)" },
    { "code": "A119", "province": "VC", "name": "ALAGNA VALSESIA" },
    { "code": "A120", "province": "TE", "name": "ALANNO (soppresso)" },
    { "code": "A120", "province": "PE", "name": "ALANNO" },
    { "code": "A121", "province": "BL", "name": "ALANO DI PIAVE" },
    { "code": "A122", "province": "GE", "name": "ALASSIO (soppresso)" },
    { "code": "A122", "province": "SV", "name": "ALASSIO" },
    { "code": "A123", "province": "RM", "name": "ALATRI (soppresso)" },
    { "code": "A123", "province": "FR", "name": "ALATRI" },
    { "code": "A124", "province": "CN", "name": "ALBA" },
    { "code": "A125", "province": "TE", "name": "ALBA ADRIATICA" },
    { "code": "A126", "province": "CA", "name": "ALBAGIARA (soppresso)" },
    { "code": "A126", "province": "OR", "name": "ALBAGIARA" },
    { "code": "A127", "province": "MI", "name": "ALBAIRATE" },
    { "code": "A128", "province": "SA", "name": "ALBANELLA" },
    { "code": "A131", "province": "PZ", "name": "ALBANO DI LUCANIA" },
    { "code": "A132", "province": "RM", "name": "ALBANO LAZIALE" },
    { "code": "A129", "province": "BG", "name": "ALBANO SANT'ALESSANDRO" },
    { "code": "A130", "province": "NO", "name": "ALBANO VERCELLESE (soppresso)" },
    { "code": "A130", "province": "VC", "name": "ALBANO VERCELLESE" },
    { "code": "A133", "province": "NA", "name": "ALBANOVA (soppresso)" },
    { "code": "A133", "province": "CE", "name": "ALBANOVA (soppresso)" },
    { "code": "A134", "province": "PV", "name": "ALBAREDO ARNABOLDI" },
    { "code": "A137", "province": "VR", "name": "ALBAREDO D'ADIGE" },
    { "code": "A135", "province": "SO", "name": "ALBAREDO PER SAN MARCO" },
    { "code": "A138", "province": "PR", "name": "ALBARETO" },
    { "code": "A138", "province": "PR", "name": "ALBARETO DI BORGOTARO (soppresso)" },
    { "code": "A139", "province": "CN", "name": "ALBARETTO DELLA TORRE" },
    { "code": "A140", "province": "CN", "name": "ALBARETTO VALLE DI MACRA (soppresso)" },
    { "code": "A142", "province": "CO", "name": "ALBATE (soppresso)" },
    { "code": "A143", "province": "CO", "name": "ALBAVILLA" },
    { "code": "A144", "province": "BG", "name": "ALBEGNO (soppresso)" },
    { "code": "A145", "province": "GE", "name": "ALBENGA (soppresso)" },
    { "code": "A145", "province": "SV", "name": "ALBENGA" },
    { "code": "A148", "province": "TS", "name": "ALBER DI SESANA (soppresso)" },
    { "code": "A146", "province": "AL", "name": "ALBERA LIGURE" },
    { "code": "A149", "province": "BA", "name": "ALBEROBELLO" },
    { "code": "A150", "province": "FG", "name": "ALBERONA" },
    { "code": "A151", "province": "TN", "name": "ALBES (soppresso)" },
    { "code": "A151", "province": "BZ", "name": "ALBES (soppresso)" },
    { "code": "A152", "province": "CO", "name": "ALBESE (soppresso)" },
    { "code": "A153", "province": "CO", "name": "ALBESE CON CASSANO" },
    { "code": "A154", "province": "VI", "name": "ALBETTONE" },
    { "code": "A155", "province": "CZ", "name": "ALBI" },
    { "code": "A158", "province": "TN", "name": "ALBIANO" },
    { "code": "A157", "province": "TO", "name": "ALBIANO D'IVREA" },
    { "code": "A157", "province": "AO", "name": "ALBIANO D'IVREA (soppresso)" },
    { "code": "A159", "province": "MI", "name": "ALBIATE (soppresso)" },
    { "code": "A159", "province": "MB", "name": "ALBIATE" },
    { "code": "A160", "province": "CS", "name": "ALBIDONA" },
    { "code": "A161", "province": "PD", "name": "ALBIGNASEGO" },
    { "code": "A162", "province": "RE", "name": "ALBINEA" },
    { "code": "A163", "province": "BG", "name": "ALBINO" },
    { "code": "A164", "province": "CO", "name": "ALBIOLO" },
    { "code": "A166", "province": "GE", "name": "ALBISOLA SUPERIORE (soppresso)" },
    { "code": "A166", "province": "SV", "name": "ALBISOLA SUPERIORE" },
    { "code": "A165", "province": "GE", "name": "ALBISSOLA MARINA (soppresso)" },
    { "code": "A165", "province": "SV", "name": "ALBISSOLA MARINA" },
    { "code": "A167", "province": "MI", "name": "ALBIZZATE (soppresso)" },
    { "code": "A167", "province": "VA", "name": "ALBIZZATE" },
    { "code": "A168", "province": "CO", "name": "ALBOGASIO (soppresso)" },
    { "code": "A169", "province": "NO", "name": "ALBOGNO (soppresso)" },
    { "code": "A170", "province": "PL", "name": "ALBONA (soppresso)" },
    { "code": "A171", "province": "PV", "name": "ALBONESE" },
    { "code": "A172", "province": "SO", "name": "ALBOSAGGIA" },
    { "code": "A173", "province": "AL", "name": "ALBUGNANO (soppresso)" },
    { "code": "A173", "province": "AT", "name": "ALBUGNANO" },
    { "code": "A175", "province": "PV", "name": "ALBUZZANO" },
    { "code": "A176", "province": "TP", "name": "ALCAMO" },
    { "code": "A177", "province": "ME", "name": "ALCARA LI FUSI" },
    { "code": "A178", "province": "TN", "name": "ALDENO" },
    { "code": "A179", "province": "BZ", "name": "ALDINO" },
    { "code": "A180", "province": "CA", "name": "ALES (soppresso)" },
    { "code": "A180", "province": "OR", "name": "ALES" },
    { "code": "A182", "province": "AL", "name": "ALESSANDRIA" },
    { "code": "A183", "province": "CS", "name": "ALESSANDRIA DEL CARRETTO" },
    { "code": "A181", "province": "AG", "name": "ALESSANDRIA DELLA ROCCA" },
    { "code": "A184", "province": "LE", "name": "ALESSANO" },
    { "code": "A185", "province": "LE", "name": "ALEZIO" },
    { "code": "A186", "province": "SA", "name": "ALFANO" },
    { "code": "A187", "province": "AQ", "name": "ALFEDENA" },
    { "code": "A188", "province": "BS", "name": "ALFIANELLO" },
    { "code": "A189", "province": "AL", "name": "ALFIANO NATTA" },
    { "code": "A191", "province": "RA", "name": "ALFONSINE" },
    { "code": "A192", "province": "SS", "name": "ALGHERO" },
    { "code": "A193", "province": "BG", "name": "ALGUA" },
    { "code": "A193", "province": "BG", "name": "ALGUA DI COSTA SERINA (soppresso)" },
    { "code": "A194", "province": "ME", "name": "ALI'" },
    { "code": "A201", "province": "ME", "name": "ALI' MARINA (soppresso)" },
    { "code": "A201", "province": "ME", "name": "ALI' TERME" },
    { "code": "A195", "province": "PA", "name": "ALIA" },
    { "code": "A196", "province": "PZ", "name": "ALIANO (soppresso)" },
    { "code": "A196", "province": "MT", "name": "ALIANO" },
    { "code": "A197", "province": "AL", "name": "ALICE BEL COLLE" },
    { "code": "A198", "province": "NO", "name": "ALICE CASTELLO (soppresso)" },
    { "code": "A198", "province": "VC", "name": "ALICE CASTELLO" },
    { "code": "A199", "province": "TO", "name": "ALICE SUPERIORE (soppresso)" },
    { "code": "A199", "province": "AO", "name": "ALICE SUPERIORE (soppresso)" },
    { "code": "A200", "province": "CE", "name": "ALIFE" },
    { "code": "A200", "province": "BN", "name": "ALIFE (soppresso)" },
    { "code": "A202", "province": "PA", "name": "ALIMENA" },
    { "code": "A203", "province": "PA", "name": "ALIMINUSA" },
    { "code": "A204", "province": "CA", "name": "ALLAI (soppresso)" },
    { "code": "A204", "province": "OR", "name": "ALLAI" },
    { "code": "A205", "province": "TO", "name": "ALLAIN (soppresso)" },
    { "code": "A205", "province": "AO", "name": "ALLAIN (soppresso)" },
    { "code": "A206", "province": "BL", "name": "ALLEGHE" },
    { "code": "A205", "province": "AO", "name": "ALLEIN" },
    { "code": "A205", "province": "AO", "name": "ALLENO (soppresso)" },
    { "code": "A207", "province": "PG", "name": "ALLERONA (soppresso)" },
    { "code": "A207", "province": "TR", "name": "ALLERONA" },
    { "code": "A208", "province": "LE", "name": "ALLISTE" },
    { "code": "A209", "province": "TN", "name": "ALLIZ (soppresso)" },
    { "code": "A209", "province": "BZ", "name": "ALLIZ (soppresso)" },
    { "code": "A210", "province": "RM", "name": "ALLUMIERE" },
    { "code": "A211", "province": "AL", "name": "ALLUVIONI CAMBIO' (soppresso)" },
    { "code": "M397", "province": "AL", "name": "ALLUVIONI PIOVERA" },
    { "code": "A212", "province": "CN", "name": "ALMA (soppresso)" },
    { "code": "A213", "province": "TN", "name": "ALMAZZAGO (soppresso)" },
    { "code": "A214", "province": "BG", "name": "ALME'" },
    { "code": "M305", "province": "BG", "name": "ALME' CON VILLA (soppresso)" },
    { "code": "A216", "province": "BG", "name": "ALMENNO SAN BARTOLOMEO" },
    { "code": "A217", "province": "BG", "name": "ALMENNO SAN SALVATORE" },
    { "code": "A218", "province": "TO", "name": "ALMESE" },
    { "code": "A219", "province": "BS", "name": "ALONE (soppresso)" },
    { "code": "A220", "province": "VI", "name": "ALONTE" },
    { "code": "M375", "province": "BL", "name": "ALPAGO" },
    { "code": "A221", "province": "TO", "name": "ALPETTE" },
    { "code": "A221", "province": "AO", "name": "ALPETTE (soppresso)" },
    { "code": "A222", "province": "TO", "name": "ALPIGNANO" },
    { "code": "A223", "province": "PC", "name": "ALSENO" },
    { "code": "A224", "province": "CO", "name": "ALSERIO" },
    { "code": "M386", "province": "PC", "name": "ALTA VAL TIDONE" },
    { "code": "M383", "province": "CO", "name": "ALTA VALLE INTELVI" },
    { "code": "A225", "province": "BA", "name": "ALTAMURA" },
    { "code": "A226", "province": "GE", "name": "ALTARE (soppresso)" },
    { "code": "A226", "province": "SV", "name": "ALTARE" },
    { "code": "M349", "province": "TN", "name": "ALTAVALLE" },
    { "code": "A228", "province": "AV", "name": "ALTAVILLA IRPINA" },
    { "code": "A229", "province": "PA", "name": "ALTAVILLA MILICIA" },
    { "code": "A227", "province": "AL", "name": "ALTAVILLA MONFERRATO" },
    { "code": "A230", "province": "SA", "name": "ALTAVILLA SILENTINA" },
    { "code": "A231", "province": "VI", "name": "ALTAVILLA VICENTINA" },
    { "code": "A233", "province": "AP", "name": "ALTIDONA (soppresso)" },
    { "code": "A233", "province": "FM", "name": "ALTIDONA" },
    { "code": "A234", "province": "CS", "name": "ALTILIA" },
    { "code": "A235", "province": "CH", "name": "ALTINO" },
    { "code": "A236", "province": "VI", "name": "ALTISSIMO" },
    { "code": "A237", "province": "TV", "name": "ALTIVOLE" },
    { "code": "A238", "province": "CN", "name": "ALTO" },
    { "code": "M369", "province": "BO", "name": "ALTO RENO TERME" },
    { "code": "M389", "province": "VC", "name": "ALTO SERMENZA" },
    { "code": "A239", "province": "PA", "name": "ALTOFONTE" },
    { "code": "A240", "province": "CS", "name": "ALTOMONTE" },
    { "code": "A241", "province": "LU", "name": "ALTOPASCIO" },
    { "code": "M350", "province": "TN", "name": "ALTOPIANO DELLA VIGOLANA" },
    { "code": "A242", "province": "PG", "name": "ALVIANO (soppresso)" },
    { "code": "A242", "province": "TR", "name": "ALVIANO" },
    { "code": "A243", "province": "CE", "name": "ALVIGNANO" },
    { "code": "A243", "province": "BN", "name": "ALVIGNANO (soppresso)" },
    { "code": "A244", "province": "CE", "name": "ALVITO (soppresso)" },
    { "code": "A244", "province": "FR", "name": "ALVITO" },
    { "code": "A245", "province": "AL", "name": "ALZANO (soppresso)" },
    { "code": "A246", "province": "BG", "name": "ALZANO LOMBARDO" },
    { "code": "A247", "province": "BG", "name": "ALZANO MAGGIORE (soppresso)" },
    { "code": "A245", "province": "AL", "name": "ALZANO SCRIVIA" },
    { "code": "A248", "province": "BG", "name": "ALZANO SOPRA (soppresso)" },
    { "code": "A249", "province": "CO", "name": "ALZATE BRIANZA" },
    { "code": "A250", "province": "NO", "name": "ALZATE CON LINDUNO (soppresso)" },
    { "code": "A249", "province": "CO", "name": "ALZATE CON VERZAGO (soppresso)" },
    { "code": "A251", "province": "SA", "name": "AMALFI" },
    { "code": "A252", "province": "AP", "name": "AMANDOLA (soppresso)" },
    { "code": "A252", "province": "FM", "name": "AMANDOLA" },
    { "code": "A253", "province": "CS", "name": "AMANTEA" },
    { "code": "A254", "province": "UD", "name": "AMARO" },
    { "code": "A255", "province": "CZ", "name": "AMARONI" },
    { "code": "A256", "province": "RM", "name": "AMASENO (soppresso)" },
    { "code": "A256", "province": "FR", "name": "AMASENO" },
    { "code": "A257", "province": "CZ", "name": "AMATO" },
    { "code": "A258", "province": "AQ", "name": "AMATRICE (soppresso)" },
    { "code": "A258", "province": "RI", "name": "AMATRICE" },
    { "code": "A259", "province": "BG", "name": "AMBIVERE" },
    { "code": "A260", "province": "TN", "name": "AMBLAR (soppresso)" },
    { "code": "M351", "province": "TN", "name": "AMBLAR-DON" },
    { "code": "A261", "province": "GE", "name": "AMEGLIA (soppresso)" },
    { "code": "A261", "province": "SP", "name": "AMEGLIA" },
    { "code": "A262", "province": "PG", "name": "AMELIA (soppresso)" },
    { "code": "A262", "province": "TR", "name": "AMELIA" },
    { "code": "A263", "province": "CS", "name": "AMENDOLARA" },
    { "code": "A264", "province": "NO", "name": "AMENO" },
    { "code": "A265", "province": "BN", "name": "AMOROSI" },
    { "code": "A267", "province": "UD", "name": "AMPEZZO" },
    { "code": "A266", "province": "BL", "name": "AMPEZZO (soppresso)" },
    { "code": "A268", "province": "NA", "name": "ANACAPRI" },
    { "code": "A269", "province": "RM", "name": "ANAGNI (soppresso)" },
    { "code": "A269", "province": "FR", "name": "ANAGNI" },
    { "code": "A270", "province": "TE", "name": "ANCARANO" },
    { "code": "A271", "province": "AN", "name": "ANCONA" },
    { "code": "A272", "province": "CZ", "name": "ANDALI" },
    { "code": "A273", "province": "SO", "name": "ANDALO (soppresso)" },
    { "code": "A274", "province": "TN", "name": "ANDALO" },
    { "code": "A273", "province": "SO", "name": "ANDALO VALTELLINO" },
    { "code": "A275", "province": "TO", "name": "ANDEZENO" },
    { "code": "A276", "province": "TN", "name": "ANDOGNO (soppresso)" },
    { "code": "A277", "province": "CN", "name": "ANDONNO (soppresso)" },
    { "code": "A278", "province": "GE", "name": "ANDORA (soppresso)" },
    { "code": "A278", "province": "SV", "name": "ANDORA" },
    { "code": "A279", "province": "NO", "name": "ANDORNO CACCIORNA (soppresso)" },
    { "code": "A279", "province": "VC", "name": "ANDORNO CACCIORNA (soppresso)" },
    { "code": "A280", "province": "VC", "name": "ANDORNO MICCA (soppresso)" },
    { "code": "A280", "province": "BI", "name": "ANDORNO MICCA" },
    { "code": "A281", "province": "LE", "name": "ANDRANO" },
    { "code": "A282", "province": "TO", "name": "ANDRATE" },
    { "code": "A282", "province": "AO", "name": "ANDRATE (soppresso)" },
    { "code": "A283", "province": "UD", "name": "ANDREIS (soppresso)" },
    { "code": "A283", "province": "PN", "name": "ANDREIS" },
    { "code": "A284", "province": "AV", "name": "ANDRETTA" },
    { "code": "A285", "province": "BA", "name": "ANDRIA (soppresso)" },
    { "code": "A285", "province": "BT", "name": "ANDRIA" },
    { "code": "A286", "province": "TN", "name": "ANDRIANO (soppresso)" },
    { "code": "A286", "province": "BZ", "name": "ANDRIANO" },
    { "code": "A287", "province": "SS", "name": "ANELA" },
    { "code": "A288", "province": "BS", "name": "ANFO" },
    { "code": "A289", "province": "BS", "name": "ANFURRO (soppresso)" },
    { "code": "A290", "province": "CO", "name": "ANGERA (soppresso)" },
    { "code": "A290", "province": "VA", "name": "ANGERA" },
    { "code": "A291", "province": "AR", "name": "ANGHIARI" },
    { "code": "A292", "province": "VR", "name": "ANGIARI" },
    { "code": "A293", "province": "BS", "name": "ANGOLO (soppresso)" },
    { "code": "A293", "province": "BS", "name": "ANGOLO TERME" },
    { "code": "A294", "province": "SA", "name": "ANGRI" },
    { "code": "A295", "province": "TO", "name": "ANGROGNA" },
    { "code": "A297", "province": "RM", "name": "ANGUILLARA SABAZIA" },
    { "code": "A296", "province": "PD", "name": "ANGUILLARA VENETA" },
    { "code": "A298", "province": "GO", "name": "ANHOVO (soppresso)" },
    { "code": "A298", "province": "UD", "name": "ANHOVO (soppresso)" },
    { "code": "A298", "province": "UD", "name": "ANICOVA CORADA (soppresso)" },
    { "code": "A298", "province": "GO", "name": "ANICOVA CORADA (soppresso)" },
    { "code": "A299", "province": "CR", "name": "ANNICCO" },
    { "code": "A301", "province": "CO", "name": "ANNONE DI BRIANZA (soppresso)" },
    { "code": "A301", "province": "LC", "name": "ANNONE DI BRIANZA" },
    { "code": "A302", "province": "VE", "name": "ANNONE VENETO" },
    { "code": "A303", "province": "RC", "name": "ANOIA" },
    { "code": "A304", "province": "BG", "name": "ANTEGNATE" },
    { "code": "A305", "province": "AO", "name": "ANTEI SAN ANDREA (soppresso)" },
    { "code": "A306", "province": "TN", "name": "ANTERIVO (soppresso)" },
    { "code": "A306", "province": "BZ", "name": "ANTERIVO" },
    { "code": "A307", "province": "TN", "name": "ANTERSELVA (soppresso)" },
    { "code": "A307", "province": "BZ", "name": "ANTERSELVA (soppresso)" },
    { "code": "A305", "province": "TO", "name": "ANTEY SAINT ANDRE' (soppresso)" },
    { "code": "A305", "province": "AO", "name": "ANTEY SAINT ANDRE' (soppresso)" },
    { "code": "A305", "province": "AO", "name": "ANTEY-SAINT-ANDRE'" },
    { "code": "A309", "province": "RM", "name": "ANTICOLI CORRADO" },
    { "code": "A310", "province": "RM", "name": "ANTICOLI DI CAMPAGNA (soppresso)" },
    { "code": "A311", "province": "PL", "name": "ANTIGNANA (soppresso)" },
    { "code": "A312", "province": "AL", "name": "ANTIGNANO (soppresso)" },
    { "code": "A312", "province": "AT", "name": "ANTIGNANO" },
    { "code": "A313", "province": "ME", "name": "ANTILLO" },
    { "code": "A314", "province": "RC", "name": "ANTONIMINA" },
    { "code": "A315", "province": "AQ", "name": "ANTRODOCO (soppresso)" },
    { "code": "A315", "province": "RI", "name": "ANTRODOCO" },
    { "code": "A317", "province": "NO", "name": "ANTRONA SCHIERANCO (soppresso)" },
    { "code": "A317", "province": "VB", "name": "ANTRONA SCHIERANCO" },
    { "code": "A316", "province": "NO", "name": "ANTRONAPIANA (soppresso)" },
    { "code": "A318", "province": "AQ", "name": "ANVERSA (soppresso)" },
    { "code": "A318", "province": "AQ", "name": "ANVERSA DEGLI ABRUZZI" },
    { "code": "A320", "province": "AV", "name": "ANZANO DEGLI IRPINI (soppresso)" },
    { "code": "A320", "province": "FG", "name": "ANZANO DEGLI IRPINI (soppresso)" },
    { "code": "A319", "province": "CO", "name": "ANZANO DEL PARCO" },
    { "code": "A320", "province": "FG", "name": "ANZANO DI PUGLIA" },
    { "code": "A321", "province": "PZ", "name": "ANZI" },
    { "code": "A322", "province": "NO", "name": "ANZINO (soppresso)" },
    { "code": "A323", "province": "RM", "name": "ANZIO" },
    { "code": "A324", "province": "BO", "name": "ANZOLA DELL'EMILIA" },
    { "code": "A325", "province": "NO", "name": "ANZOLA D'OSSOLA (soppresso)" },
    { "code": "A325", "province": "VB", "name": "ANZOLA D'OSSOLA" },
    { "code": "A326", "province": "TO", "name": "AOSTA (soppresso)" },
    { "code": "A326", "province": "AO", "name": "AOSTA" },
    { "code": "A327", "province": "PS", "name": "APECCHIO (soppresso)" },
    { "code": "A327", "province": "PU", "name": "APECCHIO" },
    { "code": "A328", "province": "BN", "name": "APICE" },
    { "code": "A329", "province": "MC", "name": "APIRO" },
    { "code": "A330", "province": "BN", "name": "APOLLOSA" },
    { "code": "A331", "province": "GE", "name": "APPARIZIONE (soppresso)" },
    { "code": "A333", "province": "CO", "name": "APPIANO (soppresso)" },
    { "code": "A332", "province": "TN", "name": "APPIANO (soppresso)" },
    { "code": "A332", "province": "BZ", "name": "APPIANO (soppresso)" },
    { "code": "A333", "province": "CO", "name": "APPIANO GENTILE" },
    { "code": "A332", "province": "BZ", "name": "APPIANO SULLA STRADA DEL VINO" },
    { "code": "A334", "province": "MC", "name": "APPIGNANO" },
    { "code": "A335", "province": "AP", "name": "APPIGNANO DEL TRONTO" },
    { "code": "A336", "province": "FU", "name": "APRIANO (soppresso)" },
    { "code": "A336", "province": "PL", "name": "APRIANO (soppresso)" },
    { "code": "A337", "province": "SO", "name": "APRICA" },
    { "code": "A338", "province": "IM", "name": "APRICALE" },
    { "code": "A339", "province": "FG", "name": "APRICENA" },
    { "code": "A340", "province": "CS", "name": "APRIGLIANO" },
    { "code": "A341", "province": "LT", "name": "APRILIA" },
    { "code": "A342", "province": "MS", "name": "APUANIA (soppresso)" },
    { "code": "A343", "province": "SA", "name": "AQUARA" },
    { "code": "A344", "province": "IM", "name": "AQUILA D'ARROSCIA" },
    { "code": "A345", "province": "AQ", "name": "AQUILA DEGLI ABRUZZI (soppresso)" },
    { "code": "A346", "province": "UD", "name": "AQUILEIA" },
    { "code": "A347", "province": "AV", "name": "AQUILONIA" },
    { "code": "A348", "province": "CE", "name": "AQUINO (soppresso)" },
    { "code": "A348", "province": "FR", "name": "AQUINO" },
    { "code": "A349", "province": "NO", "name": "ARA (soppresso)" },
    { "code": "A350", "province": "LE", "name": "ARADEO" },
    { "code": "A351", "province": "AG", "name": "ARAGONA" },
    { "code": "A352", "province": "AL", "name": "ARAMENGO (soppresso)" },
    { "code": "A352", "province": "AT", "name": "ARAMENGO" },
    { "code": "A353", "province": "NO", "name": "ARANCO (soppresso)" },
    { "code": "A353", "province": "VC", "name": "ARANCO (soppresso)" },
    { "code": "A354", "province": "UD", "name": "ARBA (soppresso)" },
    { "code": "A354", "province": "PN", "name": "ARBA" },
    { "code": "A355", "province": "NU", "name": "ARBATAX DI TORTOLI' (soppresso)" },
    { "code": "A356", "province": "CO", "name": "ARBIZZO (soppresso)" },
    { "code": "A356", "province": "VA", "name": "ARBIZZO (soppresso)" },
    { "code": "A357", "province": "CA", "name": "ARBOREA (soppresso)" },
    { "code": "A357", "province": "OR", "name": "ARBOREA" },
    { "code": "A358", "province": "NO", "name": "ARBORIO (soppresso)" },
    { "code": "A358", "province": "VC", "name": "ARBORIO" },
    { "code": "A359", "province": "CA", "name": "ARBUS (soppresso)" },
    { "code": "A359", "province": "VS", "name": "ARBUS (soppresso)" },
    { "code": "A359", "province": "SU", "name": "ARBUS" },
    { "code": "A360", "province": "TV", "name": "ARCADE" },
    { "code": "A363", "province": "CE", "name": "ARCE (soppresso)" },
    { "code": "A363", "province": "FR", "name": "ARCE" },
    { "code": "A364", "province": "CO", "name": "ARCELLASCO (soppresso)" },
    { "code": "A365", "province": "BG", "name": "ARCENE" },
    { "code": "A366", "province": "AN", "name": "ARCEVIA" },
    { "code": "A367", "province": "CH", "name": "ARCHI" },
    { "code": "A369", "province": "GR", "name": "ARCIDOSSO" },
    { "code": "A370", "province": "RM", "name": "ARCINAZZO ROMANO" },
    { "code": "A371", "province": "CO", "name": "ARCISATE (soppresso)" },
    { "code": "A371", "province": "VA", "name": "ARCISATE" },
    { "code": "A372", "province": "TN", "name": "ARCO" },
    { "code": "A373", "province": "GE", "name": "ARCOLA (soppresso)" },
    { "code": "A373", "province": "SP", "name": "ARCOLA" },
    { "code": "A374", "province": "VR", "name": "ARCOLE" },
    { "code": "A375", "province": "MI", "name": "ARCONATE" },
    { "code": "A376", "province": "MI", "name": "ARCORE (soppresso)" },
    { "code": "A376", "province": "MB", "name": "ARCORE" },
    { "code": "A377", "province": "VI", "name": "ARCUGNANO" },
    { "code": "A378", "province": "CO", "name": "ARCUMEGGIA (soppresso)" },
    { "code": "A378", "province": "VA", "name": "ARCUMEGGIA (soppresso)" },
    { "code": "A379", "province": "SS", "name": "ARDARA" },
    { "code": "A380", "province": "CA", "name": "ARDAULI (soppresso)" },
    { "code": "A380", "province": "OR", "name": "ARDAULI" },
    { "code": "M213", "province": "RM", "name": "ARDEA" },
    { "code": "A381", "province": "CO", "name": "ARDENA (soppresso)" },
    { "code": "A381", "province": "VA", "name": "ARDENA (soppresso)" },
    { "code": "A382", "province": "SO", "name": "ARDENNO" },
    { "code": "A383", "province": "BG", "name": "ARDESIO" },
    { "code": "A385", "province": "RC", "name": "ARDORE" },
    { "code": "A386", "province": "CZ", "name": "ARENA (soppresso)" },
    { "code": "A386", "province": "VV", "name": "ARENA" },
    { "code": "A387", "province": "PV", "name": "ARENA PO" },
    { "code": "A388", "province": "GE", "name": "ARENZANO" },
    { "code": "A389", "province": "MI", "name": "ARESE" },
    { "code": "A390", "province": "AR", "name": "AREZZO" },
    { "code": "A391", "province": "CO", "name": "ARGEGNO" },
    { "code": "A392", "province": "BO", "name": "ARGELATO" },
    { "code": "A393", "province": "FE", "name": "ARGENTA" },
    { "code": "A394", "province": "CN", "name": "ARGENTERA" },
    { "code": "A396", "province": "CN", "name": "ARGUELLO" },
    { "code": "A397", "province": "CZ", "name": "ARGUSTO" },
    { "code": "A398", "province": "CH", "name": "ARI" },
    { "code": "A399", "province": "AV", "name": "ARIANO DI PUGLIA (soppresso)" },
    { "code": "A399", "province": "AV", "name": "ARIANO IRPINO" },
    { "code": "A400", "province": "RO", "name": "ARIANO NEL POLESINE" },
    { "code": "A401", "province": "RM", "name": "ARICCIA" },
    { "code": "A402", "province": "CH", "name": "ARIELLI" },
    { "code": "A403", "province": "CE", "name": "ARIENZO" },
    { "code": "A403", "province": "NA", "name": "ARIENZO (soppresso)" },
    { "code": "A404", "province": "NA", "name": "ARIENZO SAN FELICE (soppresso)" },
    { "code": "A404", "province": "CE", "name": "ARIENZO SAN FELICE (soppresso)" },
    { "code": "A405", "province": "TO", "name": "ARIGNANO" },
    { "code": "A406", "province": "AQ", "name": "ARISCHIA (soppresso)" },
    { "code": "A407", "province": "CA", "name": "ARITZO (soppresso)" },
    { "code": "A407", "province": "NU", "name": "ARITZO" },
    { "code": "A408", "province": "CA", "name": "ARIXI (soppresso)" },
    { "code": "ND", "province": "NO", "name": "ARIZZANO (soppresso)" },
    { "code": "A409", "province": "NO", "name": "ARIZZANO (soppresso)" },
    { "code": "A409", "province": "VB", "name": "ARIZZANO" },
    { "code": "A410", "province": "NO", "name": "ARIZZANO INFERIORE (soppresso)" },
    { "code": "A411", "province": "NO", "name": "ARIZZANO SUPERIORE (soppresso)" },
    { "code": "A412", "province": "RM", "name": "ARLENA DI CASTRO (soppresso)" },
    { "code": "A412", "province": "VT", "name": "ARLENA DI CASTRO" },
    { "code": "A413", "province": "MI", "name": "ARLUNO" },
    { "code": "A414", "province": "NO", "name": "ARMENO" },
    { "code": "A415", "province": "PZ", "name": "ARMENTO" },
    { "code": "A416", "province": "CO", "name": "ARMIO (soppresso)" },
    { "code": "A416", "province": "VA", "name": "ARMIO (soppresso)" },
    { "code": "A418", "province": "IM", "name": "ARMO" },
    { "code": "A417", "province": "TN", "name": "ARMO (soppresso)" },
    { "code": "A419", "province": "CA", "name": "ARMUNGIA (soppresso)" },
    { "code": "A419", "province": "SU", "name": "ARMUNGIA" },
    { "code": "A424", "province": "AO", "name": "ARNAD" },
    { "code": "A420", "province": "TN", "name": "ARNAGO (soppresso)" },
    { "code": "A421", "province": "RM", "name": "ARNARA (soppresso)" },
    { "code": "A421", "province": "FR", "name": "ARNARA" },
    { "code": "A422", "province": "GE", "name": "ARNASCO (soppresso)" },
    { "code": "A422", "province": "SV", "name": "ARNASCO" },
    { "code": "A424", "province": "TO", "name": "ARNAZ (soppresso)" },
    { "code": "A424", "province": "AO", "name": "ARNAZ (soppresso)" },
    { "code": "A425", "province": "LE", "name": "ARNESANO" },
    { "code": "A426", "province": "TN", "name": "ARNO' (soppresso)" },
    { "code": "A427", "province": "NO", "name": "AROLA (soppresso)" },
    { "code": "A427", "province": "VB", "name": "AROLA" },
    { "code": "A428", "province": "CO", "name": "AROLO (soppresso)" },
    { "code": "A428", "province": "VA", "name": "AROLO (soppresso)" },
    { "code": "A429", "province": "NO", "name": "ARONA" },
    { "code": "A430", "province": "CO", "name": "AROSIO" },
    { "code": "A431", "province": "BN", "name": "ARPAIA" },
    { "code": "A432", "province": "BN", "name": "ARPAISE" },
    { "code": "A433", "province": "CE", "name": "ARPINO (soppresso)" },
    { "code": "A433", "province": "FR", "name": "ARPINO" },
    { "code": "A434", "province": "PD", "name": "ARQUA' PETRARCA" },
    { "code": "A435", "province": "RO", "name": "ARQUA' POLESINE" },
    { "code": "A437", "province": "AP", "name": "ARQUATA DEL TRONTO" },
    { "code": "A436", "province": "AL", "name": "ARQUATA SCRIVIA" },
    { "code": "A438", "province": "PD", "name": "ARRE" },
    { "code": "A439", "province": "PG", "name": "ARRONE (soppresso)" },
    { "code": "A439", "province": "TR", "name": "ARRONE" },
    { "code": "A440", "province": "BG", "name": "ARSAGO (soppresso)" },
    { "code": "A441", "province": "MI", "name": "ARSAGO (soppresso)" },
    { "code": "A441", "province": "VA", "name": "ARSAGO (soppresso)" },
    { "code": "A441", "province": "VA", "name": "ARSAGO SEPRIO" },
    { "code": "A442", "province": "PL", "name": "ARSIA (soppresso)" },
    { "code": "A443", "province": "BL", "name": "ARSIE'" },
    { "code": "A444", "province": "VI", "name": "ARSIERO" },
    { "code": "A445", "province": "TE", "name": "ARSITA" },
    { "code": "A446", "province": "RM", "name": "ARSOLI" },
    { "code": "A447", "province": "UD", "name": "ARTA (soppresso)" },
    { "code": "A447", "province": "UD", "name": "ARTA TERME" },
    { "code": "A448", "province": "UD", "name": "ARTEGNA" },
    { "code": "A449", "province": "RM", "name": "ARTENA" },
    { "code": "A450", "province": "NO", "name": "ARTO' (soppresso)" },
    { "code": "A451", "province": "BS", "name": "ARTOGNE" },
    { "code": "A452", "province": "AO", "name": "ARVIE' (soppresso)" },
    { "code": "A452", "province": "TO", "name": "ARVIER (soppresso)" },
    { "code": "A452", "province": "AO", "name": "ARVIER" },
    { "code": "A453", "province": "SS", "name": "ARZACHENA" },
    { "code": "A453", "province": "OT", "name": "ARZACHENA (soppresso)" },
    { "code": "A440", "province": "BG", "name": "ARZAGO D'ADDA" },
    { "code": "A454", "province": "CA", "name": "ARZANA (soppresso)" },
    { "code": "A454", "province": "NU", "name": "ARZANA" },
    { "code": "A454", "province": "OG", "name": "ARZANA (soppresso)" },
    { "code": "A455", "province": "NA", "name": "ARZANO" },
    { "code": "A456", "province": "UD", "name": "ARZENE (soppresso)" },
    { "code": "A456", "province": "PN", "name": "ARZENE (soppresso)" },
    { "code": "A457", "province": "IM", "name": "ARZENO D'ONEGLIA (soppresso)" },
    { "code": "A458", "province": "PD", "name": "ARZERGRANDE" },
    { "code": "A459", "province": "VI", "name": "ARZIGNANO" },
    { "code": "A460", "province": "SA", "name": "ASCEA" },
    { "code": "A461", "province": "SI", "name": "ASCIANO" },
    { "code": "A462", "province": "AP", "name": "ASCOLI PICENO" },
    { "code": "A463", "province": "FG", "name": "ASCOLI SATRIANO" },
    { "code": "A464", "province": "PG", "name": "ASCREA (soppresso)" },
    { "code": "A464", "province": "RM", "name": "ASCREA (soppresso)" },
    { "code": "A464", "province": "RI", "name": "ASCREA" },
    { "code": "A465", "province": "VI", "name": "ASIAGO" },
    { "code": "A466", "province": "NO", "name": "ASIGLIANO (soppresso)" },
    { "code": "A467", "province": "VI", "name": "ASIGLIANO (soppresso)" },
    { "code": "A466", "province": "VC", "name": "ASIGLIANO (soppresso)" },
    { "code": "A467", "province": "VI", "name": "ASIGLIANO VENETO" },
    { "code": "A466", "province": "VC", "name": "ASIGLIANO VERCELLESE" },
    { "code": "A469", "province": "CO", "name": "ASNAGO (soppresso)" },
    { "code": "A470", "province": "MN", "name": "ASOLA" },
    { "code": "A471", "province": "TV", "name": "ASOLO" },
    { "code": "A472", "province": "PG", "name": "ASPRA SABINA (soppresso)" },
    { "code": "A472", "province": "RM", "name": "ASPRA SABINA (soppresso)" },
    { "code": "A472", "province": "RI", "name": "ASPRA SABINA (soppresso)" },
    { "code": "A473", "province": "MI", "name": "ASSAGO" },
    { "code": "A474", "province": "CA", "name": "ASSEMINI" },
    { "code": "A475", "province": "PG", "name": "ASSISI" },
    { "code": "A476", "province": "CO", "name": "ASSO" },
    { "code": "A477", "province": "CA", "name": "ASSOLO (soppresso)" },
    { "code": "A477", "province": "OR", "name": "ASSOLO" },
    { "code": "A478", "province": "CT", "name": "ASSORO (soppresso)" },
    { "code": "A478", "province": "EN", "name": "ASSORO" },
    { "code": "A479", "province": "AL", "name": "ASTI (soppresso)" },
    { "code": "A479", "province": "AT", "name": "ASTI" },
    { "code": "A480", "province": "CA", "name": "ASUNI (soppresso)" },
    { "code": "A480", "province": "OR", "name": "ASUNI" },
    { "code": "A481", "province": "AQ", "name": "ATELETA" },
    { "code": "A482", "province": "PZ", "name": "ATELLA" },
    { "code": "A483", "province": "NA", "name": "ATELLA DI NAPOLI (soppresso)" },
    { "code": "A483", "province": "CE", "name": "ATELLA DI NAPOLI (soppresso)" },
    { "code": "A484", "province": "SA", "name": "ATENA LUCANA" },
    { "code": "A485", "province": "CH", "name": "ATESSA" },
    { "code": "A486", "province": "CE", "name": "ATINA (soppresso)" },
    { "code": "A486", "province": "FR", "name": "ATINA" },
    { "code": "A487", "province": "SA", "name": "ATRANI" },
    { "code": "A488", "province": "TE", "name": "ATRI" },
    { "code": "A489", "province": "AV", "name": "ATRIPALDA" },
    { "code": "A490", "province": "PG", "name": "ATTIGLIANO (soppresso)" },
    { "code": "A490", "province": "TR", "name": "ATTIGLIANO" },
    { "code": "A491", "province": "UD", "name": "ATTIMIS" },
    { "code": "A492", "province": "CA", "name": "ATZARA (soppresso)" },
    { "code": "A492", "province": "NU", "name": "ATZARA" },
    { "code": "A148", "province": "TS", "name": "AUBER (soppresso)" },
    { "code": "A493", "province": "PS", "name": "AUDITORE (soppresso)" },
    { "code": "A493", "province": "PU", "name": "AUDITORE (soppresso)" },
    { "code": "A494", "province": "SR", "name": "AUGUSTA" },
    { "code": "A495", "province": "SA", "name": "AULETTA" },
    { "code": "A496", "province": "MS", "name": "AULLA" },
    { "code": "A497", "province": "NO", "name": "AURANO (soppresso)" },
    { "code": "A497", "province": "VB", "name": "AURANO" },
    { "code": "A498", "province": "TS", "name": "AUREMO DI SOPRA (soppresso)" },
    { "code": "A499", "province": "IM", "name": "AURIGO" },
    { "code": "A500", "province": "TS", "name": "AURISINA (soppresso)" },
    { "code": "A501", "province": "BL", "name": "AURONZO (soppresso)" },
    { "code": "A501", "province": "BL", "name": "AURONZO DI CADORE" },
    { "code": "A502", "province": "CE", "name": "AUSONIA (soppresso)" },
    { "code": "A502", "province": "FR", "name": "AUSONIA" },
    { "code": "A503", "province": "CA", "name": "AUSTIS (soppresso)" },
    { "code": "A503", "province": "NU", "name": "AUSTIS" },
    { "code": "A504", "province": "NO", "name": "AUZATE (soppresso)" },
    { "code": "A505", "province": "GO", "name": "AUZZA (soppresso)" },
    { "code": "A505", "province": "UD", "name": "AUZZA (soppresso)" },
    { "code": "A506", "province": "GE", "name": "AVEGNO" },
    { "code": "A507", "province": "TN", "name": "AVELENGO (soppresso)" },
    { "code": "A507", "province": "BZ", "name": "AVELENGO" },
    { "code": "A507", "province": "TN", "name": "AVELIGNA (soppresso)" },
    { "code": "A508", "province": "AV", "name": "AVELLA" },
    { "code": "A509", "province": "AV", "name": "AVELLINO" },
    { "code": "A510", "province": "BS", "name": "AVENONE (soppresso)" },
    { "code": "A511", "province": "BG", "name": "AVERARA" },
    { "code": "A512", "province": "CE", "name": "AVERSA" },
    { "code": "A512", "province": "NA", "name": "AVERSA (soppresso)" },
    { "code": "A513", "province": "VR", "name": "AVESA (soppresso)" },
    { "code": "A514", "province": "LE", "name": "AVETRANA (soppresso)" },
    { "code": "A514", "province": "TA", "name": "AVETRANA" },
    { "code": "A515", "province": "AQ", "name": "AVEZZANO" },
    { "code": "A516", "province": "UD", "name": "AVIANO (soppresso)" },
    { "code": "A516", "province": "PN", "name": "AVIANO" },
    { "code": "A517", "province": "BG", "name": "AVIATICO" },
    { "code": "A518", "province": "TO", "name": "AVIGLIANA" },
    { "code": "A519", "province": "PZ", "name": "AVIGLIANO" },
    { "code": "M258", "province": "TR", "name": "AVIGLIANO UMBRO" },
    { "code": "A520", "province": "TN", "name": "AVIO" },
    { "code": "A521", "province": "TO", "name": "AVISE (soppresso)" },
    { "code": "A521", "province": "AO", "name": "AVISE" },
    { "code": "A522", "province": "SR", "name": "AVOLA" },
    { "code": "A523", "province": "AL", "name": "AVOLASCA" },
    { "code": "A524", "province": "TO", "name": "AVUGLIONE E VERNONE (soppresso)" },
    { "code": "A094", "province": "TO", "name": "AYAS (soppresso)" },
    { "code": "A094", "province": "AO", "name": "AYAS" },
    { "code": "A108", "province": "AO", "name": "AYMAVILLE (soppresso)" },
    { "code": "A108", "province": "TO", "name": "AYMAVILLES (soppresso)" },
    { "code": "A108", "province": "AO", "name": "AYMAVILLES" },
    { "code": "A525", "province": "TO", "name": "AZEGLIO" },
    { "code": "A525", "province": "AO", "name": "AZEGLIO (soppresso)" },
    { "code": "A526", "province": "CR", "name": "AZZANELLO" },
    { "code": "A527", "province": "AL", "name": "AZZANO D'ASTI (soppresso)" },
    { "code": "A527", "province": "AT", "name": "AZZANO D'ASTI" },
    { "code": "A530", "province": "UD", "name": "AZZANO DECIMO (soppresso)" },
    { "code": "A530", "province": "PN", "name": "AZZANO DECIMO" },
    { "code": "A527", "province": "AL", "name": "AZZANO DEL TANARO (soppresso)" },
    { "code": "A529", "province": "BS", "name": "AZZANO MELLA" },
    { "code": "A528", "province": "BG", "name": "AZZANO SAN PAOLO" },
    { "code": "A531", "province": "CO", "name": "AZZATE (soppresso)" },
    { "code": "A531", "province": "VA", "name": "AZZATE" },
    { "code": "A532", "province": "CO", "name": "AZZIO (soppresso)" },
    { "code": "A532", "province": "VA", "name": "AZZIO" },
    { "code": "A533", "province": "BG", "name": "AZZONE" },
    { "code": "A534", "province": "NO", "name": "BACENO (soppresso)" },
    { "code": "A534", "province": "VB", "name": "BACENO" },
    { "code": "A535", "province": "NA", "name": "BACOLI" },
    { "code": "A445", "province": "TE", "name": "BACUCCO (soppresso)" },
    { "code": "A536", "province": "IM", "name": "BADALUCCO" },
    { "code": "M214", "province": "SS", "name": "BADESI" },
    { "code": "M214", "province": "OT", "name": "BADESI (soppresso)" },
    { "code": "A538", "province": "PV", "name": "BADIA (soppresso)" },
    { "code": "A537", "province": "TN", "name": "BADIA (soppresso)" },
    { "code": "A537", "province": "BZ", "name": "BADIA" },
    { "code": "A540", "province": "VR", "name": "BADIA CALAVENA" },
    { "code": "A538", "province": "PV", "name": "BADIA PAVESE" },
    { "code": "A539", "province": "RO", "name": "BADIA POLESINE" },
    { "code": "A541", "province": "AR", "name": "BADIA TEDALDA" },
    { "code": "A542", "province": "CZ", "name": "BADOLATO" },
    { "code": "A543", "province": "CO", "name": "BAGAGGERA (soppresso)" },
    { "code": "A544", "province": "RC", "name": "BAGALADI" },
    { "code": "A545", "province": "MI", "name": "BAGGIO (soppresso)" },
    { "code": "A546", "province": "PA", "name": "BAGHERIA" },
    { "code": "A547", "province": "RA", "name": "BAGNACAVALLO" },
    { "code": "A548", "province": "RM", "name": "BAGNAJA (soppresso)" },
    { "code": "A548", "province": "VT", "name": "BAGNAJA (soppresso)" },
    { "code": "A552", "province": "RC", "name": "BAGNARA CALABRA" },
    { "code": "A551", "province": "RA", "name": "BAGNARA DI ROMAGNA" },
    { "code": "A550", "province": "PV", "name": "BAGNARIA" },
    { "code": "A553", "province": "UD", "name": "BAGNARIA ARSA" },
    { "code": "A555", "province": "CN", "name": "BAGNASCO" },
    { "code": "A556", "province": "AL", "name": "BAGNASCO D'ASTI (soppresso)" },
    { "code": "A557", "province": "BG", "name": "BAGNATICA" },
    { "code": "A558", "province": "BO", "name": "BAGNI DELLA PORRETTA (soppresso)" },
    { "code": "A559", "province": "PI", "name": "BAGNI DI CASCIANA (soppresso)" },
    { "code": "A560", "province": "LU", "name": "BAGNI DI LUCCA" },
    { "code": "A561", "province": "LU", "name": "BAGNI DI MONTECATINI (soppresso)" },
    { "code": "A561", "province": "PT", "name": "BAGNI DI MONTECATINI (soppresso)" },
    { "code": "A562", "province": "PI", "name": "BAGNI SAN GIULIANO (soppresso)" },
    { "code": "A563", "province": "AQ", "name": "BAGNO (soppresso)" },
    { "code": "A564", "province": "FI", "name": "BAGNO A RIPOLI" },
    { "code": "A565", "province": "FI", "name": "BAGNO DI ROMAGNA (soppresso)" },
    { "code": "A565", "province": "FO", "name": "BAGNO DI ROMAGNA (soppresso)" },
    { "code": "A565", "province": "FC", "name": "BAGNO DI ROMAGNA" },
    { "code": "A567", "province": "CB", "name": "BAGNOLI DEL TRIGNO (soppresso)" },
    { "code": "A567", "province": "IS", "name": "BAGNOLI DEL TRIGNO" },
    { "code": "A568", "province": "PD", "name": "BAGNOLI DI SOPRA" },
    { "code": "A566", "province": "AV", "name": "BAGNOLI IRPINO" },
    { "code": "A570", "province": "CR", "name": "BAGNOLO CREMASCO" },
    { "code": "A572", "province": "LE", "name": "BAGNOLO DEL SALENTO" },
    { "code": "A574", "province": "RO", "name": "BAGNOLO DI PO" },
    { "code": "A573", "province": "RE", "name": "BAGNOLO IN PIANO" },
    { "code": "A569", "province": "BS", "name": "BAGNOLO MELLA" },
    { "code": "A571", "province": "CN", "name": "BAGNOLO PIEMONTE" },
    { "code": "A575", "province": "MN", "name": "BAGNOLO SAN VITO" },
    { "code": "A576", "province": "MS", "name": "BAGNONE" },
    { "code": "A577", "province": "RM", "name": "BAGNOREA (soppresso)" },
    { "code": "A577", "province": "RM", "name": "BAGNOREGIO (soppresso)" },
    { "code": "A577", "province": "VT", "name": "BAGNOREGIO" },
    { "code": "A578", "province": "BS", "name": "BAGOLINO" },
    { "code": "A579", "province": "CE", "name": "BAIA E LATINA" },
    { "code": "A579", "province": "NA", "name": "BAIA E LATINA (soppresso)" },
    { "code": "A580", "province": "AV", "name": "BAIANO" },
    { "code": "A582", "province": "CO", "name": "BAIEDO (soppresso)" },
    { "code": "I355", "province": "GO", "name": "BAINSIZZA SANTO SPIRITO (soppresso)" },
    { "code": "I355", "province": "UD", "name": "BAINSIZZA SANTO SPIRITO (soppresso)" },
    { "code": "A583", "province": "TO", "name": "BAIO (soppresso)" },
    { "code": "A583", "province": "TO", "name": "BAIO DORA (soppresso)" },
    { "code": "A583", "province": "AO", "name": "BAIO DORA (soppresso)" },
    { "code": "A584", "province": "TO", "name": "BAIRO" },
    { "code": "A584", "province": "AO", "name": "BAIRO (soppresso)" },
    { "code": "A585", "province": "AO", "name": "BAIRO TORRE (soppresso)" },
    { "code": "A585", "province": "TO", "name": "BAIRO TORRE (soppresso)" },
    { "code": "A586", "province": "RE", "name": "BAISO" },
    { "code": "A581", "province": "IM", "name": "BAJARDO" },
    { "code": "A587", "province": "TO", "name": "BALANGERO" },
    { "code": "A588", "province": "AL", "name": "BALDICHIERI D'ASTI (soppresso)" },
    { "code": "A588", "province": "AT", "name": "BALDICHIERI D'ASTI" },
    { "code": "A590", "province": "TO", "name": "BALDISSERO CANAVESE" },
    { "code": "A590", "province": "AO", "name": "BALDISSERO CANAVESE (soppresso)" },
    { "code": "A589", "province": "CN", "name": "BALDISSERO D'ALBA" },
    { "code": "A591", "province": "TO", "name": "BALDISSERO TORINESE" },
    { "code": "A592", "province": "PA", "name": "BALESTRATE" },
    { "code": "A593", "province": "GE", "name": "BALESTRINO (soppresso)" },
    { "code": "A593", "province": "SV", "name": "BALESTRINO" },
    { "code": "A594", "province": "CO", "name": "BALLABIO (soppresso)" },
    { "code": "A594", "province": "LC", "name": "BALLABIO" },
    { "code": "A595", "province": "CO", "name": "BALLABIO INFERIORE (soppresso)" },
    { "code": "A596", "province": "CO", "name": "BALLABIO SUPERIORE (soppresso)" },
    { "code": "A597", "province": "CA", "name": "BALLAO (soppresso)" },
    { "code": "A597", "province": "SU", "name": "BALLAO" },
    { "code": "A598", "province": "CO", "name": "BALLARATE (soppresso)" },
    { "code": "A598", "province": "VA", "name": "BALLARATE (soppresso)" },
    { "code": "A599", "province": "TO", "name": "BALME" },
    { "code": "A600", "province": "NO", "name": "BALMUCCIA (soppresso)" },
    { "code": "A600", "province": "VC", "name": "BALMUCCIA" },
    { "code": "A601", "province": "NO", "name": "BALOCCO (soppresso)" },
    { "code": "A601", "province": "VC", "name": "BALOCCO" },
    { "code": "A602", "province": "MI", "name": "BALSAMO (soppresso)" },
    { "code": "A603", "province": "AQ", "name": "BALSORANO" },
    { "code": "A604", "province": "PZ", "name": "BALVANO" },
    { "code": "A605", "province": "AL", "name": "BALZOLA" },
    { "code": "A606", "province": "SS", "name": "BANARI" },
    { "code": "A607", "province": "TO", "name": "BANCHETTE" },
    { "code": "A607", "province": "AO", "name": "BANCHETTE (soppresso)" },
    { "code": "A608", "province": "TN", "name": "BANCO (soppresso)" },
    { "code": "A609", "province": "CA", "name": "BANNARI DI USELLUS (soppresso)" },
    { "code": "A610", "province": "NO", "name": "BANNIO (soppresso)" },
    { "code": "A610", "province": "NO", "name": "BANNIO ANZINO (soppresso)" },
    { "code": "A610", "province": "VB", "name": "BANNIO ANZINO" },
    { "code": "A612", "province": "PZ", "name": "BANZI" },
    { "code": "A612", "province": "MT", "name": "BANZI (soppresso)" },
    { "code": "A613", "province": "PD", "name": "BAONE" },
    { "code": "A614", "province": "CA", "name": "BARADILI (soppresso)" },
    { "code": "A614", "province": "OR", "name": "BARADILI" },
    { "code": "A615", "province": "PZ", "name": "BARAGIANO" },
    { "code": "A616", "province": "CB", "name": "BARANELLO" },
    { "code": "A617", "province": "NA", "name": "BARANO D'ISCHIA" },
    { "code": "A618", "province": "MI", "name": "BARANZATE" },
    { "code": "A619", "province": "CO", "name": "BARASSO (soppresso)" },
    { "code": "A619", "province": "VA", "name": "BARASSO" },
    { "code": "A621", "province": "CA", "name": "BARATILI SAN PIETRO (soppresso)" },
    { "code": "A621", "province": "OR", "name": "BARATILI SAN PIETRO" },
    { "code": "A624", "province": "PL", "name": "BARBANA D'ISTRIA (soppresso)" },
    { "code": "A625", "province": "TO", "name": "BARBANIA" },
    { "code": "A626", "province": "AN", "name": "BARBARA" },
    { "code": "A627", "province": "VI", "name": "BARBARANO (soppresso)" },
    { "code": "M401", "province": "VI", "name": "BARBARANO MOSSANO" },
    { "code": "A628", "province": "RM", "name": "BARBARANO ROMANO (soppresso)" },
    { "code": "A628", "province": "VT", "name": "BARBARANO ROMANO" },
    { "code": "A627", "province": "VI", "name": "BARBARANO VICENTINO (soppresso)" },
    { "code": "A629", "province": "CN", "name": "BARBARESCO" },
    { "code": "A630", "province": "BS", "name": "BARBARIGA" },
    { "code": "A631", "province": "BG", "name": "BARBATA" },
    { "code": "A632", "province": "FI", "name": "BARBERINO DI MUGELLO" },
    { "code": "M408", "province": "FI", "name": "BARBERINO TAVARNELLE" },
    { "code": "A633", "province": "FI", "name": "BARBERINO VAL D'ELSA (soppresso)" },
    { "code": "A634", "province": "PV", "name": "BARBIANELLO" },
    { "code": "A635", "province": "TN", "name": "BARBIANO (soppresso)" },
    { "code": "A635", "province": "BZ", "name": "BARBIANO" },
    { "code": "A637", "province": "PD", "name": "BARBONA" },
    { "code": "A638", "province": "ME", "name": "BARCELLONA POZZO DI GOTTO" },
    { "code": "A639", "province": "PS", "name": "BARCHI (soppresso)" },
    { "code": "A639", "province": "PU", "name": "BARCHI (soppresso)" },
    { "code": "A640", "province": "UD", "name": "BARCIS (soppresso)" },
    { "code": "A640", "province": "PN", "name": "BARCIS" },
    { "code": "A641", "province": "BS", "name": "BARCO (soppresso)" },
    { "code": "A642", "province": "CO", "name": "BARCONE (soppresso)" },
    { "code": "A643", "province": "TO", "name": "BARD (soppresso)" },
    { "code": "A643", "province": "AO", "name": "BARD" },
    { "code": "A644", "province": "TO", "name": "BARDASSANO (soppresso)" },
    { "code": "A645", "province": "CO", "name": "BARDELLO (soppresso)" },
    { "code": "A645", "province": "VA", "name": "BARDELLO" },
    { "code": "A646", "province": "PC", "name": "BARDI (soppresso)" },
    { "code": "A646", "province": "PR", "name": "BARDI" },
    { "code": "A647", "province": "GE", "name": "BARDINETO (soppresso)" },
    { "code": "A647", "province": "SV", "name": "BARDINETO" },
    { "code": "A648", "province": "GE", "name": "BARDINO NUOVO (soppresso)" },
    { "code": "A648", "province": "SV", "name": "BARDINO NUOVO (soppresso)" },
    { "code": "A649", "province": "GE", "name": "BARDINO VECCHIO (soppresso)" },
    { "code": "A649", "province": "SV", "name": "BARDINO VECCHIO (soppresso)" },
    { "code": "A650", "province": "VR", "name": "BARDOLINO" },
    { "code": "A651", "province": "TO", "name": "BARDONECCHIA" },
    { "code": "A652", "province": "MI", "name": "BAREGGIO" },
    { "code": "A653", "province": "NO", "name": "BARENGO" },
    { "code": "A654", "province": "BG", "name": "BARESI (soppresso)" },
    { "code": "A655", "province": "CA", "name": "BARESSA (soppresso)" },
    { "code": "A655", "province": "OR", "name": "BARESSA" },
    { "code": "A656", "province": "AQ", "name": "BARETE" },
    { "code": "A657", "province": "LU", "name": "BARGA" },
    { "code": "A658", "province": "GE", "name": "BARGAGLI" },
    { "code": "A659", "province": "MI", "name": "BARGANO (soppresso)" },
    { "code": "A660", "province": "CN", "name": "BARGE" },
    { "code": "A661", "province": "BS", "name": "BARGHE" },
    { "code": "A662", "province": "BA", "name": "BARI" },
    { "code": "A662", "province": "BA", "name": "BARI DELLE PUGLIE (soppresso)" },
    { "code": "A663", "province": "CA", "name": "BARI SARDO (soppresso)" },
    { "code": "A663", "province": "NU", "name": "BARI SARDO" },
    { "code": "A663", "province": "OG", "name": "BARI SARDO (soppresso)" },
    { "code": "A664", "province": "BG", "name": "BARIANO" },
    { "code": "A665", "province": "BO", "name": "BARICELLA" },
    { "code": "A666", "province": "PZ", "name": "BARILE" },
    { "code": "A667", "province": "AQ", "name": "BARISCIANO" },
    { "code": "A668", "province": "MI", "name": "BARLASSINA (soppresso)" },
    { "code": "A668", "province": "MB", "name": "BARLASSINA" },
    { "code": "A669", "province": "BA", "name": "BARLETTA (soppresso)" },
    { "code": "A669", "province": "BT", "name": "BARLETTA" },
    { "code": "A670", "province": "CO", "name": "BARNI" },
    { "code": "A671", "province": "CN", "name": "BAROLO" },
    { "code": "A673", "province": "TO", "name": "BARONE CANAVESE" },
    { "code": "A673", "province": "AO", "name": "BARONE CANAVESE (soppresso)" },
    { "code": "A674", "province": "SA", "name": "BARONISSI" },
    { "code": "A675", "province": "NA", "name": "BARRA (soppresso)" },
    { "code": "A676", "province": "CL", "name": "BARRAFRANCA (soppresso)" },
    { "code": "A676", "province": "EN", "name": "BARRAFRANCA" },
    { "code": "A677", "province": "CA", "name": "BARRALI (soppresso)" },
    { "code": "A677", "province": "SU", "name": "BARRALI" },
    { "code": "A678", "province": "AQ", "name": "BARREA" },
    { "code": "A679", "province": "BG", "name": "BARSIZZA (soppresso)" },
    { "code": "A680", "province": "CO", "name": "BARTESATE (soppresso)" },
    { "code": "A681", "province": "CA", "name": "BARUMINI (soppresso)" },
    { "code": "A681", "province": "VS", "name": "BARUMINI (soppresso)" },
    { "code": "A681", "province": "SU", "name": "BARUMINI" },
    { "code": "A682", "province": "CO", "name": "BARZA (soppresso)" },
    { "code": "A682", "province": "VA", "name": "BARZA (soppresso)" },
    { "code": "A683", "province": "CO", "name": "BARZAGO (soppresso)" },
    { "code": "A683", "province": "LC", "name": "BARZAGO" },
    { "code": "A684", "province": "BG", "name": "BARZANA" },
    { "code": "A685", "province": "CR", "name": "BARZANIGA (soppresso)" },
    { "code": "A686", "province": "CO", "name": "BARZANO' (soppresso)" },
    { "code": "A686", "province": "LC", "name": "BARZANO'" },
    { "code": "A687", "province": "CO", "name": "BARZIO (soppresso)" },
    { "code": "A687", "province": "LC", "name": "BARZIO" },
    { "code": "A688", "province": "CO", "name": "BARZOLA (soppresso)" },
    { "code": "A688", "province": "VA", "name": "BARZOLA (soppresso)" },
    { "code": "A689", "province": "AL", "name": "BASALUZZO" },
    { "code": "A690", "province": "PV", "name": "BASCAPE'" },
    { "code": "A691", "province": "PG", "name": "BASCHI (soppresso)" },
    { "code": "A691", "province": "TR", "name": "BASCHI" },
    { "code": "A692", "province": "TE", "name": "BASCIANO" },
    { "code": "A693", "province": "TN", "name": "BASELGA (soppresso)" },
    { "code": "A694", "province": "TN", "name": "BASELGA DI PINE'" },
    { "code": "A693", "province": "TN", "name": "BASELGA DI VEZZANO (soppresso)" },
    { "code": "A695", "province": "PV", "name": "BASELICA BOLOGNA (soppresso)" },
    { "code": "A696", "province": "BN", "name": "BASELICE" },
    { "code": "A697", "province": "MI", "name": "BASIANO" },
    { "code": "A698", "province": "ME", "name": "BASICO'" },
    { "code": "A699", "province": "MI", "name": "BASIGLIO" },
    { "code": "A700", "province": "UD", "name": "BASILIANO" },
    { "code": "A701", "province": "RM", "name": "BASSANELLO (soppresso)" },
    { "code": "A701", "province": "VT", "name": "BASSANELLO (soppresso)" },
    { "code": "A703", "province": "VI", "name": "BASSANO (soppresso)" },
    { "code": "L914", "province": "TS", "name": "BASSANO (soppresso)" },
    { "code": "A702", "province": "BS", "name": "BASSANO BRESCIANO" },
    { "code": "A703", "province": "VI", "name": "BASSANO DEL GRAPPA" },
    { "code": "A704", "province": "RM", "name": "BASSANO DI SUTRI (soppresso)" },
    { "code": "A704", "province": "VT", "name": "BASSANO DI SUTRI (soppresso)" },
    { "code": "A706", "province": "RM", "name": "BASSANO IN TEVERINA (soppresso)" },
    { "code": "A706", "province": "VT", "name": "BASSANO IN TEVERINA" },
    { "code": "A704", "province": "VT", "name": "BASSANO ROMANO" },
    { "code": "A707", "province": "RM", "name": "BASSIANO (soppresso)" },
    { "code": "A707", "province": "LT", "name": "BASSIANO" },
    { "code": "A708", "province": "AL", "name": "BASSIGNANA" },
    { "code": "A709", "province": "CN", "name": "BASTIA MONDOVI'" },
    { "code": "A710", "province": "PG", "name": "BASTIA UMBRA" },
    { "code": "A711", "province": "PV", "name": "BASTIDA DE' DOSSI (soppresso)" },
    { "code": "A712", "province": "PV", "name": "BASTIDA PANCARANA" },
    { "code": "A713", "province": "MO", "name": "BASTIGLIA" },
    { "code": "A715", "province": "GO", "name": "BATE (soppresso)" },
    { "code": "A715", "province": "UD", "name": "BATE (soppresso)" },
    { "code": "A714", "province": "PD", "name": "BATTAGLIA (soppresso)" },
    { "code": "A715", "province": "UD", "name": "BATTAGLIA DELLA BAINSIZZA (soppresso)" },
    { "code": "A715", "province": "GO", "name": "BATTAGLIA DELLA BAINSIZZA (soppresso)" },
    { "code": "A714", "province": "PD", "name": "BATTAGLIA TERME" },
    { "code": "A716", "province": "CN", "name": "BATTIFOLLO" },
    { "code": "A717", "province": "SA", "name": "BATTIPAGLIA" },
    { "code": "A718", "province": "PV", "name": "BATTUDA" },
    { "code": "A719", "province": "PA", "name": "BAUCINA" },
    { "code": "A720", "province": "RM", "name": "BAUCO (soppresso)" },
    { "code": "A721", "province": "CA", "name": "BAULADU (soppresso)" },
    { "code": "A721", "province": "OR", "name": "BAULADU" },
    { "code": "A722", "province": "CA", "name": "BAUNEI (soppresso)" },
    { "code": "A722", "province": "NU", "name": "BAUNEI" },
    { "code": "A722", "province": "OG", "name": "BAUNEI (soppresso)" },
    { "code": "A723", "province": "ME", "name": "BAUSO (soppresso)" },
    { "code": "A724", "province": "GE", "name": "BAVARI (soppresso)" },
    { "code": "A725", "province": "NO", "name": "BAVENO (soppresso)" },
    { "code": "A725", "province": "VB", "name": "BAVENO" },
    { "code": "A726", "province": "BO", "name": "BAZZANO (soppresso)" },
    { "code": "A727", "province": "TO", "name": "BEAULARD (soppresso)" },
    { "code": "A728", "province": "CO", "name": "BEDERO VALCUVIA (soppresso)" },
    { "code": "A728", "province": "VA", "name": "BEDERO VALCUVIA" },
    { "code": "A729", "province": "BS", "name": "BEDIZZOLE" },
    { "code": "A730", "province": "TN", "name": "BEDOLLO" },
    { "code": "A731", "province": "PR", "name": "BEDONIA" },
    { "code": "A732", "province": "BG", "name": "BEDULITA" },
    { "code": "A733", "province": "NO", "name": "BEE (soppresso)" },
    { "code": "A733", "province": "VB", "name": "BEE" },
    { "code": "A734", "province": "TO", "name": "BEINASCO" },
    { "code": "A735", "province": "CN", "name": "BEINETTE" },
    { "code": "A767", "province": "BS", "name": "BEL PRATO (soppresso)" },
    { "code": "A736", "province": "CZ", "name": "BELCASTRO" },
    { "code": "A737", "province": "VR", "name": "BELFIORE" },
    { "code": "A740", "province": "PS", "name": "BELFORTE ALL'ISAURO (soppresso)" },
    { "code": "A740", "province": "PU", "name": "BELFORTE ALL'ISAURO" },
    { "code": "A739", "province": "MC", "name": "BELFORTE DEL CHIENTI" },
    { "code": "A739", "province": "MC", "name": "BELFORTE DEL CHIENTO (soppresso)" },
    { "code": "A738", "province": "AL", "name": "BELFORTE MONFERRATO" },
    { "code": "A741", "province": "PV", "name": "BELGIOIOSO" },
    { "code": "A742", "province": "NO", "name": "BELGIRATE (soppresso)" },
    { "code": "A742", "province": "VB", "name": "BELGIRATE" },
    { "code": "A743", "province": "PZ", "name": "BELLA" },
    { "code": "A744", "province": "CO", "name": "BELLAGIO (soppresso)" },
    { "code": "M335", "province": "CO", "name": "BELLAGIO" },
    { "code": "A745", "province": "CO", "name": "BELLANO (soppresso)" },
    { "code": "A745", "province": "LC", "name": "BELLANO" },
    { "code": "A746", "province": "TE", "name": "BELLANTE" },
    { "code": "A747", "province": "FO", "name": "BELLARIA-IGEA MARINA (soppresso)" },
    { "code": "A747", "province": "RN", "name": "BELLARIA-IGEA MARINA" },
    { "code": "A749", "province": "RM", "name": "BELLEGRA" },
    { "code": "A750", "province": "CN", "name": "BELLINO" },
    { "code": "A751", "province": "MI", "name": "BELLINZAGO LOMBARDO" },
    { "code": "A752", "province": "NO", "name": "BELLINZAGO NOVARESE" },
    { "code": "A753", "province": "AV", "name": "BELLIZZI (soppresso)" },
    { "code": "M294", "province": "SA", "name": "BELLIZZI" },
    { "code": "A753", "province": "AV", "name": "BELLIZZI IRPINO (soppresso)" },
    { "code": "A754", "province": "RO", "name": "BELLOMBRA (soppresso)" },
    { "code": "A755", "province": "CE", "name": "BELLONA" },
    { "code": "A755", "province": "NA", "name": "BELLONA (soppresso)" },
    { "code": "A756", "province": "SA", "name": "BELLOSGUARDO" },
    { "code": "A757", "province": "BL", "name": "BELLUNO" },
    { "code": "A758", "province": "VR", "name": "BELLUNO VERONESE (soppresso)" },
    { "code": "A759", "province": "MI", "name": "BELLUSCO (soppresso)" },
    { "code": "A759", "province": "MB", "name": "BELLUSCO" },
    { "code": "A762", "province": "CS", "name": "BELMONTE CALABRO" },
    { "code": "A763", "province": "CE", "name": "BELMONTE CASTELLO (soppresso)" },
    { "code": "A763", "province": "FR", "name": "BELMONTE CASTELLO" },
    { "code": "A761", "province": "CB", "name": "BELMONTE DEL SANNIO (soppresso)" },
    { "code": "A761", "province": "IS", "name": "BELMONTE DEL SANNIO" },
    { "code": "A765", "province": "PG", "name": "BELMONTE IN SABINA (soppresso)" },
    { "code": "A765", "province": "RM", "name": "BELMONTE IN SABINA (soppresso)" },
    { "code": "A765", "province": "RI", "name": "BELMONTE IN SABINA" },
    { "code": "A764", "province": "PA", "name": "BELMONTE MEZZAGNO" },
    { "code": "A760", "province": "AP", "name": "BELMONTE PICENO (soppresso)" },
    { "code": "A760", "province": "FM", "name": "BELMONTE PICENO" },
    { "code": "A766", "province": "CT", "name": "BELPASSO" },
    { "code": "A768", "province": "CS", "name": "BELSITO" },
    { "code": "A772", "province": "CZ", "name": "BELVEDERE DI SPINELLO (soppresso)" },
    { "code": "A772", "province": "KR", "name": "BELVEDERE DI SPINELLO" },
    { "code": "A774", "province": "CN", "name": "BELVEDERE LANGHE" },
    { "code": "A773", "province": "CS", "name": "BELVEDERE MARITTIMO" },
    { "code": "A769", "province": "AN", "name": "BELVEDERE OSTRENSE" },
    { "code": "A770", "province": "AL", "name": "BELVEGLIO (soppresso)" },
    { "code": "A770", "province": "AT", "name": "BELVEGLIO" },
    { "code": "A776", "province": "CA", "name": "BELVI' (soppresso)" },
    { "code": "A776", "province": "NU", "name": "BELVI'" },
    { "code": "A777", "province": "SO", "name": "BEMA" },
    { "code": "A778", "province": "CO", "name": "BENE LARIO" },
    { "code": "A779", "province": "CN", "name": "BENE VAGIENNA" },
    { "code": "A780", "province": "RC", "name": "BENESTARE" },
    { "code": "A781", "province": "SS", "name": "BENETUTTI" },
    { "code": "A782", "province": "CN", "name": "BENEVELLO" },
    { "code": "A783", "province": "BN", "name": "BENEVENTO" },
    { "code": "A784", "province": "NO", "name": "BENNA (soppresso)" },
    { "code": "A784", "province": "VC", "name": "BENNA (soppresso)" },
    { "code": "A784", "province": "BI", "name": "BENNA" },
    { "code": "A785", "province": "BO", "name": "BENTIVOGLIO" },
    { "code": "A786", "province": "BG", "name": "BERBENNO" },
    { "code": "A787", "province": "SO", "name": "BERBENNO DI VALTELLINA" },
    { "code": "A788", "province": "PR", "name": "BERCETO" },
    { "code": "A789", "province": "SS", "name": "BERCHIDDA" },
    { "code": "A789", "province": "OT", "name": "BERCHIDDA (soppresso)" },
    { "code": "A790", "province": "FU", "name": "BERDO SAN GIOVANNI (soppresso)" },
    { "code": "A790", "province": "PL", "name": "BERDO SAN GIOVANNI (soppresso)" },
    { "code": "A791", "province": "CO", "name": "BEREGAZZO (soppresso)" },
    { "code": "A791", "province": "CO", "name": "BEREGAZZO CON FIGLIARO" },
    { "code": "A792", "province": "PV", "name": "BEREGUARDO" },
    { "code": "A793", "province": "AL", "name": "BERGAMASCO" },
    { "code": "A794", "province": "BG", "name": "BERGAMO" },
    { "code": "A795", "province": "RO", "name": "BERGANTINO" },
    { "code": "A796", "province": "GE", "name": "BERGEGGI (soppresso)" },
    { "code": "A796", "province": "SV", "name": "BERGEGGI" },
    { "code": "A797", "province": "GO", "name": "BERGOGNA (soppresso)" },
    { "code": "A797", "province": "UD", "name": "BERGOGNA (soppresso)" },
    { "code": "A798", "province": "CN", "name": "BERGOLO" },
    { "code": "B047", "province": "GO", "name": "BERIE (soppresso)" },
    { "code": "B047", "province": "UD", "name": "BERIE (soppresso)" },
    { "code": "A799", "province": "BS", "name": "BERLINGO" },
    { "code": "A801", "province": "PZ", "name": "BERNALDA (soppresso)" },
    { "code": "A801", "province": "MT", "name": "BERNALDA" },
    { "code": "A802", "province": "MI", "name": "BERNAREGGIO (soppresso)" },
    { "code": "A802", "province": "MB", "name": "BERNAREGGIO" },
    { "code": "A803", "province": "CO", "name": "BERNATE DI COMO (soppresso)" },
    { "code": "A803", "province": "CO", "name": "BERNATE ROSALES (soppresso)" },
    { "code": "A804", "province": "MI", "name": "BERNATE TICINO" },
    { "code": "A805", "province": "CN", "name": "BERNEZZO" },
    { "code": "A806", "province": "FE", "name": "BERRA (soppresso)" },
    { "code": "A824", "province": "FU", "name": "BERSEZ (soppresso)" },
    { "code": "A824", "province": "PL", "name": "BERSEZ (soppresso)" },
    { "code": "A807", "province": "CN", "name": "BERSEZIO (soppresso)" },
    { "code": "A824", "province": "PL", "name": "BERSEZIO DEL QUARNARO (soppresso)" },
    { "code": "A824", "province": "FU", "name": "BERSEZIO DEL QUARNARO (soppresso)" },
    { "code": "A808", "province": "TN", "name": "BERSONE (soppresso)" },
    { "code": "A809", "province": "FO", "name": "BERTINORO (soppresso)" },
    { "code": "A809", "province": "FC", "name": "BERTINORO" },
    { "code": "A810", "province": "UD", "name": "BERTIOLO" },
    { "code": "A811", "province": "MI", "name": "BERTONICO (soppresso)" },
    { "code": "A811", "province": "LO", "name": "BERTONICO" },
    { "code": "A812", "province": "AL", "name": "BERZANO DI SAN PIETRO (soppresso)" },
    { "code": "A812", "province": "AT", "name": "BERZANO DI SAN PIETRO" },
    { "code": "A813", "province": "AL", "name": "BERZANO DI TORTONA" },
    { "code": "A816", "province": "BS", "name": "BERZO DEMO" },
    { "code": "A817", "province": "BS", "name": "BERZO INFERIORE" },
    { "code": "A815", "province": "BG", "name": "BERZO SAN FERMO" },
    { "code": "A818", "province": "MI", "name": "BESANA IN BRIANZA (soppresso)" },
    { "code": "A818", "province": "MB", "name": "BESANA IN BRIANZA" },
    { "code": "A819", "province": "CO", "name": "BESANO (soppresso)" },
    { "code": "A819", "province": "VA", "name": "BESANO" },
    { "code": "A820", "province": "MI", "name": "BESATE" },
    { "code": "A821", "province": "TN", "name": "BESENELLO" },
    { "code": "A822", "province": "TN", "name": "BESENO (soppresso)" },
    { "code": "A823", "province": "PC", "name": "BESENZONE" },
    { "code": "A825", "province": "MI", "name": "BESNATE (soppresso)" },
    { "code": "A825", "province": "VA", "name": "BESNATE" },
    { "code": "A826", "province": "CO", "name": "BESOZZO (soppresso)" },
    { "code": "A826", "province": "VA", "name": "BESOZZO" },
    { "code": "A827", "province": "SS", "name": "BESSUDE" },
    { "code": "A828", "province": "IM", "name": "BESTAGNO (soppresso)" },
    { "code": "A831", "province": "PC", "name": "BETTOLA" },
    { "code": "A832", "province": "PG", "name": "BETTONA" },
    { "code": "A833", "province": "NO", "name": "BEURA (soppresso)" },
    { "code": "A834", "province": "NO", "name": "BEURA-CARDEZZA (soppresso)" },
    { "code": "A834", "province": "VB", "name": "BEURA-CARDEZZA" },
    { "code": "A835", "province": "PG", "name": "BEVAGNA" },
    { "code": "A836", "province": "GE", "name": "BEVERINO (soppresso)" },
    { "code": "A836", "province": "SP", "name": "BEVERINO" },
    { "code": "A837", "province": "VR", "name": "BEVILACQUA" },
    { "code": "A838", "province": "VR", "name": "BEVILACQUA-BOSCHI (soppresso)" },
    { "code": "A839", "province": "TN", "name": "BEZZECCA (soppresso)" },
    { "code": "A840", "province": "TN", "name": "BIACESA (soppresso)" },
    { "code": "A841", "province": "CT", "name": "BIANCAVILLA" },
    { "code": "A842", "province": "CS", "name": "BIANCHI" },
    { "code": "A843", "province": "RC", "name": "BIANCO" },
    { "code": "A844", "province": "NO", "name": "BIANDRATE" },
    { "code": "A845", "province": "CO", "name": "BIANDRONNO (soppresso)" },
    { "code": "A845", "province": "VA", "name": "BIANDRONNO" },
    { "code": "A846", "province": "BG", "name": "BIANZANO" },
    { "code": "A847", "province": "NO", "name": "BIANZE' (soppresso)" },
    { "code": "A847", "province": "VC", "name": "BIANZE'" },
    { "code": "A848", "province": "SO", "name": "BIANZONE" },
    { "code": "A849", "province": "MI", "name": "BIASSONO (soppresso)" },
    { "code": "A849", "province": "MB", "name": "BIASSONO" },
    { "code": "A850", "province": "RE", "name": "BIBBIANO" },
    { "code": "A851", "province": "AR", "name": "BIBBIENA" },
    { "code": "A852", "province": "PI", "name": "BIBBONA (soppresso)" },
    { "code": "A852", "province": "LI", "name": "BIBBONA" },
    { "code": "A853", "province": "TO", "name": "BIBIANA" },
    { "code": "A854", "province": "FG", "name": "BICCARI" },
    { "code": "A855", "province": "UD", "name": "BICINICCO" },
    { "code": "A856", "province": "CA", "name": "BIDONI' (soppresso)" },
    { "code": "A856", "province": "OR", "name": "BIDONI'" },
    { "code": "A857", "province": "RM", "name": "BIEDA (soppresso)" },
    { "code": "A857", "province": "VT", "name": "BIEDA (soppresso)" },
    { "code": "A858", "province": "CO", "name": "BIEGNO (soppresso)" },
    { "code": "A858", "province": "VA", "name": "BIEGNO (soppresso)" },
    { "code": "A859", "province": "NO", "name": "BIELLA (soppresso)" },
    { "code": "A859", "province": "VC", "name": "BIELLA (soppresso)" },
    { "code": "A859", "province": "BI", "name": "BIELLA" },
    { "code": "A861", "province": "BS", "name": "BIENNO" },
    { "code": "A862", "province": "NO", "name": "BIENO (soppresso)" },
    { "code": "A863", "province": "TN", "name": "BIENO" },
    { "code": "A864", "province": "PI", "name": "BIENTINA" },
    { "code": "A865", "province": "GE", "name": "BIESTRO (soppresso)" },
    { "code": "A865", "province": "SV", "name": "BIESTRO (soppresso)" },
    { "code": "A866", "province": "MN", "name": "BIGARELLO (soppresso)" },
    { "code": "A867", "province": "GO", "name": "BIGLIA (soppresso)" },
    { "code": "A867", "province": "UD", "name": "BIGLIA (soppresso)" },
    { "code": "A868", "province": "GO", "name": "BIGLIANA (soppresso)" },
    { "code": "A868", "province": "UD", "name": "BIGLIANA (soppresso)" },
    { "code": "A869", "province": "CO", "name": "BIGLIO (soppresso)" },
    { "code": "A870", "province": "CO", "name": "BINAGO" },
    { "code": "A871", "province": "CR", "name": "BINANUOVA (soppresso)" },
    { "code": "A872", "province": "MI", "name": "BINASCO" },
    { "code": "A873", "province": "CO", "name": "BINDO (soppresso)" },
    { "code": "A874", "province": "BA", "name": "BINETTO" },
    { "code": "A876", "province": "NO", "name": "BIOGLIO (soppresso)" },
    { "code": "A876", "province": "VC", "name": "BIOGLIO (soppresso)" },
    { "code": "A876", "province": "BI", "name": "BIOGLIO" },
    { "code": "A877", "province": "AO", "name": "BIONA (soppresso)" },
    { "code": "A877", "province": "TO", "name": "BIONAZ (soppresso)" },
    { "code": "A877", "province": "AO", "name": "BIONAZ" },
    { "code": "A878", "province": "BS", "name": "BIONE" },
    { "code": "A880", "province": "CA", "name": "BIRORI (soppresso)" },
    { "code": "A880", "province": "NU", "name": "BIRORI" },
    { "code": "A881", "province": "AV", "name": "BISACCIA" },
    { "code": "A882", "province": "PA", "name": "BISACQUINO" },
    { "code": "A014", "province": "SR", "name": "BISCARI (soppresso)" },
    { "code": "A014", "province": "RG", "name": "BISCARI (soppresso)" },
    { "code": "A883", "province": "BA", "name": "BISCEGLIE (soppresso)" },
    { "code": "A883", "province": "BT", "name": "BISCEGLIE" },
    { "code": "A884", "province": "AQ", "name": "BISEGNA" },
    { "code": "A885", "province": "TE", "name": "BISENTI" },
    { "code": "A887", "province": "CS", "name": "BISIGNANO" },
    { "code": "A888", "province": "AL", "name": "BISIO (soppresso)" },
    { "code": "A889", "province": "AL", "name": "BISTAGNO" },
    { "code": "A890", "province": "FU", "name": "BISTERZA (soppresso)" },
    { "code": "A890", "province": "PL", "name": "BISTERZA (soppresso)" },
    { "code": "A891", "province": "CO", "name": "BISUSCHIO (soppresso)" },
    { "code": "A891", "province": "VA", "name": "BISUSCHIO" },
    { "code": "A892", "province": "BA", "name": "BITETTO" },
    { "code": "A893", "province": "BA", "name": "BITONTO" },
    { "code": "A894", "province": "BA", "name": "BITRITTO" },
    { "code": "A895", "province": "SS", "name": "BITTI (soppresso)" },
    { "code": "A895", "province": "NU", "name": "BITTI" },
    { "code": "A896", "province": "AG", "name": "BIVONA" },
    { "code": "A897", "province": "RC", "name": "BIVONGI" },
    { "code": "A898", "province": "CO", "name": "BIZZARONE" },
    { "code": "A899", "province": "CO", "name": "BIZZOZERO (soppresso)" },
    { "code": "A899", "province": "VA", "name": "BIZZOZERO (soppresso)" },
    { "code": "A900", "province": "TN", "name": "BLEGGIO (soppresso)" },
    { "code": "A901", "province": "TN", "name": "BLEGGIO INFERIORE (soppresso)" },
    { "code": "A902", "province": "TN", "name": "BLEGGIO SUPERIORE" },
    { "code": "A903", "province": "BG", "name": "BLELLO" },
    { "code": "A857", "province": "VT", "name": "BLERA" },
    { "code": "A904", "province": "CO", "name": "BLESSAGNO" },
    { "code": "A905", "province": "CO", "name": "BLEVIO" },
    { "code": "M268", "province": "PA", "name": "BLUFI" },
    { "code": "A906", "province": "PD", "name": "BOARA PISANI" },
    { "code": "A907", "province": "RO", "name": "BOARA POLESINE (soppresso)" },
    { "code": "A908", "province": "CO", "name": "BOBBIATE (soppresso)" },
    { "code": "A908", "province": "VA", "name": "BOBBIATE (soppresso)" },
    { "code": "A909", "province": "PV", "name": "BOBBIO (soppresso)" },
    { "code": "A909", "province": "PC", "name": "BOBBIO" },
    { "code": "A910", "province": "TO", "name": "BOBBIO PELLICE" },
    { "code": "A911", "province": "NO", "name": "BOCA" },
    { "code": "A912", "province": "CS", "name": "BOCCHIGLIERO" },
    { "code": "A914", "province": "NO", "name": "BOCCIOLETO (soppresso)" },
    { "code": "A914", "province": "VC", "name": "BOCCIOLETO" },
    { "code": "A915", "province": "PC", "name": "BOCCOLO DE' TASSI (soppresso)" },
    { "code": "A915", "province": "PR", "name": "BOCCOLO DE' TASSI (soppresso)" },
    { "code": "A916", "province": "TN", "name": "BOCENAGO" },
    { "code": "A917", "province": "CO", "name": "BODIO (soppresso)" },
    { "code": "A917", "province": "VA", "name": "BODIO (soppresso)" },
    { "code": "A918", "province": "VA", "name": "BODIO LOMNAGO" },
    { "code": "A919", "province": "MI", "name": "BOFFALORA D'ADDA (soppresso)" },
    { "code": "A919", "province": "LO", "name": "BOFFALORA D'ADDA" },
    { "code": "A920", "province": "MI", "name": "BOFFALORA SOPRA TICINO" },
    { "code": "A922", "province": "GE", "name": "BOGLIASCO" },
    { "code": "A923", "province": "GE", "name": "BOGLIASCO PIEVE (soppresso)" },
    { "code": "A924", "province": "PL", "name": "BOGLIUNO (soppresso)" },
    { "code": "A925", "province": "NO", "name": "BOGNANCO (soppresso)" },
    { "code": "A925", "province": "VB", "name": "BOGNANCO" },
    { "code": "A926", "province": "NO", "name": "BOGNANCO DENTRO (soppresso)" },
    { "code": "A927", "province": "NO", "name": "BOGNANCO FUORI (soppresso)" },
    { "code": "A928", "province": "CO", "name": "BOGNO (soppresso)" },
    { "code": "A928", "province": "VA", "name": "BOGNO (soppresso)" },
    { "code": "A929", "province": "NO", "name": "BOGOGNO" },
    { "code": "A931", "province": "GE", "name": "BOISSANO (soppresso)" },
    { "code": "A931", "province": "SV", "name": "BOISSANO" },
    { "code": "A930", "province": "CB", "name": "BOJANO" },
    { "code": "A932", "province": "GE", "name": "BOLANO (soppresso)" },
    { "code": "A932", "province": "SP", "name": "BOLANO" },
    { "code": "A933", "province": "TN", "name": "BOLBENO (soppresso)" },
    { "code": "A935", "province": "TN", "name": "BOLENTINA (soppresso)" },
    { "code": "A936", "province": "NO", "name": "BOLETO (soppresso)" },
    { "code": "A937", "province": "BG", "name": "BOLGARE" },
    { "code": "A940", "province": "MI", "name": "BOLLATE" },
    { "code": "A941", "province": "TO", "name": "BOLLENGO" },
    { "code": "A941", "province": "AO", "name": "BOLLENGO (soppresso)" },
    { "code": "A943", "province": "TN", "name": "BOLLONE (soppresso)" },
    { "code": "A944", "province": "BO", "name": "BOLOGNA" },
    { "code": "A945", "province": "CH", "name": "BOLOGNANO (soppresso)" },
    { "code": "A945", "province": "PE", "name": "BOLOGNANO" },
    { "code": "A946", "province": "PA", "name": "BOLOGNETTA" },
    { "code": "A947", "province": "MC", "name": "BOLOGNOLA" },
    { "code": "A948", "province": "SS", "name": "BOLOTANA (soppresso)" },
    { "code": "A948", "province": "NU", "name": "BOLOTANA" },
    { "code": "A949", "province": "RM", "name": "BOLSENA (soppresso)" },
    { "code": "A949", "province": "VT", "name": "BOLSENA" },
    { "code": "A950", "province": "BG", "name": "BOLTIERE" },
    { "code": "A951", "province": "GE", "name": "BOLZANETO (soppresso)" },
    { "code": "A952", "province": "TN", "name": "BOLZANO (soppresso)" },
    { "code": "A952", "province": "BZ", "name": "BOLZANO" },
    { "code": "A953", "province": "NO", "name": "BOLZANO NOVARESE" },
    { "code": "A954", "province": "VI", "name": "BOLZANO VICENTINO" },
    { "code": "A955", "province": "RM", "name": "BOMARZO (soppresso)" },
    { "code": "A955", "province": "VT", "name": "BOMARZO" },
    { "code": "A956", "province": "CH", "name": "BOMBA" },
    { "code": "A957", "province": "CL", "name": "BOMPENSIERE" },
    { "code": "A958", "province": "PA", "name": "BOMPIETRO" },
    { "code": "A959", "province": "MO", "name": "BOMPORTO" },
    { "code": "A960", "province": "CA", "name": "BONARCADO (soppresso)" },
    { "code": "A960", "province": "OR", "name": "BONARCADO" },
    { "code": "A961", "province": "GE", "name": "BONASSOLA (soppresso)" },
    { "code": "A961", "province": "SP", "name": "BONASSOLA" },
    { "code": "A963", "province": "BG", "name": "BONATE SOPRA" },
    { "code": "A962", "province": "BG", "name": "BONATE SOTTO" },
    { "code": "A964", "province": "VR", "name": "BONAVIGO" },
    { "code": "A965", "province": "FE", "name": "BONDENO" },
    { "code": "A966", "province": "BG", "name": "BONDIONE (soppresso)" },
    { "code": "A967", "province": "TN", "name": "BONDO (soppresso)" },
    { "code": "A426", "province": "TN", "name": "BONDO BREGUZZO (soppresso)" },
    { "code": "A969", "province": "BG", "name": "BONDO PETELLO (soppresso)" },
    { "code": "A968", "province": "TN", "name": "BONDONE" },
    { "code": "A970", "province": "BN", "name": "BONEA" },
    { "code": "A971", "province": "CB", "name": "BONEFRO" },
    { "code": "A972", "province": "CR", "name": "BONEMERSE" },
    { "code": "A973", "province": "CS", "name": "BONIFATI" },
    { "code": "A975", "province": "AV", "name": "BONITO" },
    { "code": "A976", "province": "SS", "name": "BONNANARO" },
    { "code": "A977", "province": "SS", "name": "BONO" },
    { "code": "A978", "province": "SS", "name": "BONORVA" },
    { "code": "A979", "province": "CN", "name": "BONVICINO" },
    { "code": "A980", "province": "TO", "name": "BONZO (soppresso)" },
    { "code": "A981", "province": "AQ", "name": "BORBONA (soppresso)" },
    { "code": "A981", "province": "RI", "name": "BORBONA" },
    { "code": "A982", "province": "BL", "name": "BORCA (soppresso)" },
    { "code": "A982", "province": "BL", "name": "BORCA DI CADORE" },
    { "code": "A983", "province": "UD", "name": "BORDANO" },
    { "code": "A984", "province": "IM", "name": "BORDIGHERA" },
    { "code": "A985", "province": "BG", "name": "BORDOGNA (soppresso)" },
    { "code": "A986", "province": "CR", "name": "BORDOLANO" },
    { "code": "A987", "province": "PR", "name": "BORE" },
    { "code": "A988", "province": "RE", "name": "BORETTO" },
    { "code": "A989", "province": "PV", "name": "BORGARELLO" },
    { "code": "A990", "province": "TO", "name": "BORGARO TORINESE" },
    { "code": "A991", "province": "PA", "name": "BORGETTO" },
    { "code": "A997", "province": "TN", "name": "BORGHETTO (soppresso)" },
    { "code": "A993", "province": "IM", "name": "BORGHETTO D'ARROSCIA" },
    { "code": "A993", "province": "IM", "name": "BORGHETTO DI ARROSCIA (soppresso)" },
    { "code": "A998", "province": "AL", "name": "BORGHETTO DI BORBERA" },
    { "code": "A992", "province": "GE", "name": "BORGHETTO DI VARA (soppresso)" },
    { "code": "A992", "province": "SP", "name": "BORGHETTO DI VARA" },
    { "code": "A995", "province": "MI", "name": "BORGHETTO LODIGIANO (soppresso)" },
    { "code": "A995", "province": "LO", "name": "BORGHETTO LODIGIANO" },
    { "code": "A994", "province": "IM", "name": "BORGHETTO SAN NICOLO' (soppresso)" },
    { "code": "A999", "province": "GE", "name": "BORGHETTO SANTO SPIRITO (soppresso)" },
    { "code": "A999", "province": "SV", "name": "BORGHETTO SANTO SPIRITO" },
    { "code": "B001", "province": "FO", "name": "BORGHI (soppresso)" },
    { "code": "B001", "province": "FC", "name": "BORGHI" },
    { "code": "B002", "province": "CZ", "name": "BORGIA" },
    { "code": "B003", "province": "TO", "name": "BORGIALLO" },
    { "code": "B003", "province": "AO", "name": "BORGIALLO (soppresso)" },
    { "code": "B004", "province": "GE", "name": "BORGIO (soppresso)" },
    { "code": "B004", "province": "SV", "name": "BORGIO (soppresso)" },
    { "code": "B005", "province": "SV", "name": "BORGIO VEREZZI" },
    { "code": "B007", "province": "LU", "name": "BORGO A MOZZANO" },
    { "code": "M352", "province": "TN", "name": "BORGO CHIESE" },
    { "code": "B009", "province": "NO", "name": "BORGO D'ALE (soppresso)" },
    { "code": "B009", "province": "VC", "name": "BORGO D'ALE" },
    { "code": "B010", "province": "BG", "name": "BORGO DI TERZO" },
    { "code": "M353", "province": "TN", "name": "BORGO LARES" },
    { "code": "B017", "province": "MI", "name": "BORGO LITTORIO (soppresso)" },
    { "code": "M396", "province": "MN", "name": "BORGO MANTOVANO" },
    { "code": "B026", "province": "PS", "name": "BORGO PACE (soppresso)" },
    { "code": "B026", "province": "PU", "name": "BORGO PACE" },
    { "code": "B027", "province": "BO", "name": "BORGO PANIGALE (soppresso)" },
    { "code": "B028", "province": "PV", "name": "BORGO PRIOLO" },
    { "code": "B033", "province": "CN", "name": "BORGO SAN DALMAZZO" },
    { "code": "B034", "province": "PR", "name": "BORGO SAN DONNINO (soppresso)" },
    { "code": "B035", "province": "BS", "name": "BORGO SAN GIACOMO" },
    { "code": "B017", "province": "MI", "name": "BORGO SAN GIOVANNI (soppresso)" },
    { "code": "B017", "province": "LO", "name": "BORGO SAN GIOVANNI" },
    { "code": "B036", "province": "FI", "name": "BORGO SAN LORENZO" },
    { "code": "B037", "province": "AL", "name": "BORGO SAN MARTINO" },
    { "code": "B038", "province": "PV", "name": "BORGO SAN SIRO" },
    { "code": "B039", "province": "IM", "name": "BORGO SANT'AGATA (soppresso)" },
    { "code": "B042", "province": "PR", "name": "BORGO TARO (soppresso)" },
    { "code": "B043", "province": "NO", "name": "BORGO TICINO" },
    { "code": "B044", "province": "BO", "name": "BORGO TOSSIGNANO" },
    { "code": "B042", "province": "PR", "name": "BORGO VAL DI TARO" },
    { "code": "M421", "province": "BL", "name": "BORGO VALBELLUNA" },
    { "code": "B006", "province": "TN", "name": "BORGO VALSUGANA" },
    { "code": "A996", "province": "AQ", "name": "BORGO VELINO (soppresso)" },
    { "code": "A996", "province": "RI", "name": "BORGO VELINO" },
    { "code": "M402", "province": "PD", "name": "BORGO VENETO" },
    { "code": "B046", "province": "NO", "name": "BORGO VERCELLI (soppresso)" },
    { "code": "B046", "province": "VC", "name": "BORGO VERCELLI" },
    { "code": "M340", "province": "MN", "name": "BORGO VIRGILIO" },
    { "code": "M406", "province": "MN", "name": "BORGOCARBONARA" },
    { "code": "B008", "province": "AQ", "name": "BORGOCOLLEFEGATO (soppresso)" },
    { "code": "B008", "province": "RI", "name": "BORGOCOLLEFEGATO (soppresso)" },
    { "code": "B011", "province": "MN", "name": "BORGOFORTE (soppresso)" },
    { "code": "B015", "province": "TO", "name": "BORGOFRANCO D'IVREA" },
    { "code": "B015", "province": "AO", "name": "BORGOFRANCO D'IVREA (soppresso)" },
    { "code": "B013", "province": "MN", "name": "BORGOFRANCO SUL PO (soppresso)" },
    { "code": "B016", "province": "NO", "name": "BORGOLAVEZZARO" },
    { "code": "B018", "province": "CN", "name": "BORGOMALE" },
    { "code": "B019", "province": "NO", "name": "BORGOMANERO" },
    { "code": "B020", "province": "IM", "name": "BORGOMARO" },
    { "code": "B021", "province": "TO", "name": "BORGOMASINO" },
    { "code": "B021", "province": "AO", "name": "BORGOMASINO (soppresso)" },
    { "code": "M370", "province": "VB", "name": "BORGOMEZZAVALLE" },
    { "code": "B022", "province": "BS", "name": "BORGONATO (soppresso)" },
    { "code": "B024", "province": "TO", "name": "BORGONE SUSA" },
    { "code": "B025", "province": "PC", "name": "BORGONOVO VAL TIDONE" },
    { "code": "B029", "province": "AL", "name": "BORGORATTO ALESSANDRINO" },
    { "code": "B030", "province": "PV", "name": "BORGORATTO MORMOROLO" },
    { "code": "B031", "province": "PD", "name": "BORGORICCO" },
    { "code": "B008", "province": "RI", "name": "BORGOROSE" },
    { "code": "B040", "province": "BS", "name": "BORGOSATOLLO" },
    { "code": "B041", "province": "NO", "name": "BORGOSESIA (soppresso)" },
    { "code": "B041", "province": "VC", "name": "BORGOSESIA" },
    { "code": "B045", "province": "BG", "name": "BORGOUNITO (soppresso)" },
    { "code": "B047", "province": "UD", "name": "BORIANO (soppresso)" },
    { "code": "B047", "province": "GO", "name": "BORIANO (soppresso)" },
    { "code": "B048", "province": "GE", "name": "BORMIDA (soppresso)" },
    { "code": "B048", "province": "SV", "name": "BORMIDA" },
    { "code": "B049", "province": "SO", "name": "BORMIO" },
    { "code": "B051", "province": "PV", "name": "BORNASCO" },
    { "code": "B052", "province": "NO", "name": "BORNATE (soppresso)" },
    { "code": "B052", "province": "VC", "name": "BORNATE (soppresso)" },
    { "code": "B053", "province": "BS", "name": "BORNATO (soppresso)" },
    { "code": "B054", "province": "BS", "name": "BORNO" },
    { "code": "B055", "province": "CA", "name": "BORONEDDU (soppresso)" },
    { "code": "B055", "province": "OR", "name": "BORONEDDU" },
    { "code": "B056", "province": "CA", "name": "BORORE (soppresso)" },
    { "code": "B056", "province": "NU", "name": "BORORE" },
    { "code": "B057", "province": "CH", "name": "BORRELLO" },
    { "code": "B058", "province": "NO", "name": "BORRIANA (soppresso)" },
    { "code": "B058", "province": "VC", "name": "BORRIANA (soppresso)" },
    { "code": "B058", "province": "BI", "name": "BORRIANA" },
    { "code": "B059", "province": "MI", "name": "BORSANO (soppresso)" },
    { "code": "B059", "province": "VA", "name": "BORSANO (soppresso)" },
    { "code": "B060", "province": "RO", "name": "BORSEA (soppresso)" },
    { "code": "B061", "province": "TV", "name": "BORSO (soppresso)" },
    { "code": "B061", "province": "TV", "name": "BORSO DEL GRAPPA" },
    { "code": "B062", "province": "CA", "name": "BORTIGALI (soppresso)" },
    { "code": "B062", "province": "NU", "name": "BORTIGALI" },
    { "code": "B063", "province": "SS", "name": "BORTIGIADAS" },
    { "code": "B063", "province": "OT", "name": "BORTIGIADAS (soppresso)" },
    { "code": "B064", "province": "SS", "name": "BORUTTA" },
    { "code": "B065", "province": "TN", "name": "BORZAGO (soppresso)" },
    { "code": "B066", "province": "GE", "name": "BORZOLI (soppresso)" },
    { "code": "B067", "province": "GE", "name": "BORZONASCA" },
    { "code": "B068", "province": "CA", "name": "BOSA (soppresso)" },
    { "code": "B068", "province": "NU", "name": "BOSA (soppresso)" },
    { "code": "B068", "province": "OR", "name": "BOSA" },
    { "code": "B069", "province": "RO", "name": "BOSARO" },
    { "code": "B070", "province": "VR", "name": "BOSCHI SANT'ANNA" },
    { "code": "B073", "province": "VR", "name": "BOSCO CHIESANUOVA" },
    { "code": "B071", "province": "AL", "name": "BOSCO MARENGO" },
    { "code": "B072", "province": "CO", "name": "BOSCO VALTRAVAGLIA (soppresso)" },
    { "code": "B072", "province": "VA", "name": "BOSCO VALTRAVAGLIA (soppresso)" },
    { "code": "B074", "province": "IM", "name": "BOSCOMARE (soppresso)" },
    { "code": "B075", "province": "TO", "name": "BOSCONERO" },
    { "code": "B076", "province": "NA", "name": "BOSCOREALE" },
    { "code": "B077", "province": "NA", "name": "BOSCOTRECASE" },
    { "code": "B078", "province": "TN", "name": "BOSENTINO (soppresso)" },
    { "code": "B079", "province": "CN", "name": "BOSIA" },
    { "code": "B080", "province": "AL", "name": "BOSIO" },
    { "code": "B081", "province": "CO", "name": "BOSISIO (soppresso)" },
    { "code": "B081", "province": "CO", "name": "BOSISIO PARINI (soppresso)" },
    { "code": "B081", "province": "LC", "name": "BOSISIO PARINI" },
    { "code": "B082", "province": "PV", "name": "BOSNASCO" },
    { "code": "B083", "province": "BG", "name": "BOSSICO" },
    { "code": "B084", "province": "CN", "name": "BOSSOLASCO" },
    { "code": "B085", "province": "CZ", "name": "BOTRICELLO" },
    { "code": "B086", "province": "LE", "name": "BOTRUGNO" },
    { "code": "B088", "province": "BG", "name": "BOTTANUCO" },
    { "code": "B089", "province": "PV", "name": "BOTTARONE (soppresso)" },
    { "code": "B091", "province": "BS", "name": "BOTTICINO" },
    { "code": "B092", "province": "BS", "name": "BOTTICINO MATTINA (soppresso)" },
    { "code": "B093", "province": "BS", "name": "BOTTICINO SERA (soppresso)" },
    { "code": "B094", "province": "SS", "name": "BOTTIDDA" },
    { "code": "B095", "province": "RO", "name": "BOTTRIGHE (soppresso)" },
    { "code": "B096", "province": "TO", "name": "BOUSSON (soppresso)" },
    { "code": "B097", "province": "RC", "name": "BOVA" },
    { "code": "B099", "province": "RC", "name": "BOVA MARINA" },
    { "code": "B098", "province": "RC", "name": "BOVALINO" },
    { "code": "B100", "province": "BS", "name": "BOVEGNO" },
    { "code": "B101", "province": "CN", "name": "BOVES" },
    { "code": "B102", "province": "BS", "name": "BOVEZZO" },
    { "code": "B103", "province": "TO", "name": "BOVILE (soppresso)" },
    { "code": "M299", "province": "RM", "name": "BOVILLE (soppresso)" },
    { "code": "A720", "province": "RM", "name": "BOVILLE ERNICA (soppresso)" },
    { "code": "A720", "province": "FR", "name": "BOVILLE ERNICA" },
    { "code": "B104", "province": "FG", "name": "BOVINO" },
    { "code": "B105", "province": "MI", "name": "BOVISIO (soppresso)" },
    { "code": "B105", "province": "MI", "name": "BOVISIO-MASCIAGO (soppresso)" },
    { "code": "B105", "province": "MB", "name": "BOVISIO-MASCIAGO" },
    { "code": "B106", "province": "PD", "name": "BOVOLENTA" },
    { "code": "B107", "province": "VR", "name": "BOVOLONE" },
    { "code": "B108", "province": "TN", "name": "BOZZANA (soppresso)" },
    { "code": "B109", "province": "AL", "name": "BOZZOLE" },
    { "code": "B110", "province": "MN", "name": "BOZZOLO" },
    { "code": "B111", "province": "CN", "name": "BRA" },
    { "code": "B112", "province": "BG", "name": "BRACCA" },
    { "code": "B113", "province": "BG", "name": "BRACCA DI COSTA SERINA (soppresso)" },
    { "code": "B114", "province": "RM", "name": "BRACCIANO" },
    { "code": "B115", "province": "SA", "name": "BRACIGLIANO" },
    { "code": "B116", "province": "TN", "name": "BRAIES (soppresso)" },
    { "code": "B116", "province": "BZ", "name": "BRAIES" },
    { "code": "B117", "province": "PV", "name": "BRALLO DI PREGOLA" },
    { "code": "B118", "province": "RC", "name": "BRANCALEONE" },
    { "code": "B120", "province": "BS", "name": "BRANDICO" },
    { "code": "B121", "province": "TO", "name": "BRANDIZZO" },
    { "code": "B122", "province": "PV", "name": "BRANDUZZO (soppresso)" },
    { "code": "B123", "province": "BG", "name": "BRANZI" },
    { "code": "B124", "province": "BS", "name": "BRAONE" },
    { "code": "B125", "province": "GO", "name": "BRAZZANO (soppresso)" },
    { "code": "B125", "province": "UD", "name": "BRAZZANO (soppresso)" },
    { "code": "B126", "province": "CO", "name": "BREBBIA (soppresso)" },
    { "code": "B126", "province": "VA", "name": "BREBBIA" },
    { "code": "B127", "province": "CO", "name": "BRECCIA (soppresso)" },
    { "code": "B128", "province": "TV", "name": "BREDA DI PIAVE" },
    { "code": "B131", "province": "CO", "name": "BREGANO (soppresso)" },
    { "code": "B131", "province": "VA", "name": "BREGANO" },
    { "code": "B132", "province": "VI", "name": "BREGANZE" },
    { "code": "B133", "province": "CO", "name": "BREGLIA (soppresso)" },
    { "code": "B134", "province": "CO", "name": "BREGNANO" },
    { "code": "B135", "province": "TN", "name": "BREGUZZO (soppresso)" },
    { "code": "B136", "province": "NO", "name": "BREIA (soppresso)" },
    { "code": "B136", "province": "VC", "name": "BREIA (soppresso)" },
    { "code": "B137", "province": "BG", "name": "BREMBATE" },
    { "code": "B138", "province": "BG", "name": "BREMBATE DI SOPRA" },
    { "code": "B139", "province": "BG", "name": "BREMBATE DI SOTTO (soppresso)" },
    { "code": "B140", "province": "BG", "name": "BREMBILLA (soppresso)" },
    { "code": "B141", "province": "MI", "name": "BREMBIO (soppresso)" },
    { "code": "B141", "province": "LO", "name": "BREMBIO" },
    { "code": "B142", "province": "PV", "name": "BREME" },
    { "code": "B143", "province": "VI", "name": "BRENDOLA" },
    { "code": "B144", "province": "CO", "name": "BRENNA" },
    { "code": "B145", "province": "BZ", "name": "BRENNERO" },
    { "code": "B146", "province": "CO", "name": "BRENNO USERIA (soppresso)" },
    { "code": "B146", "province": "VA", "name": "BRENNO USERIA (soppresso)" },
    { "code": "B149", "province": "BS", "name": "BRENO" },
    { "code": "B150", "province": "CO", "name": "BRENTA (soppresso)" },
    { "code": "B150", "province": "VA", "name": "BRENTA" },
    { "code": "B151", "province": "VR", "name": "BRENTINO (soppresso)" },
    { "code": "B152", "province": "VR", "name": "BRENTINO BELLUNO" },
    { "code": "B153", "province": "TN", "name": "BRENTONICO" },
    { "code": "B154", "province": "VR", "name": "BRENZONE (soppresso)" },
    { "code": "B154", "province": "VR", "name": "BRENZONE SUL GARDA" },
    { "code": "B155", "province": "VR", "name": "BREONIO (soppresso)" },
    { "code": "B156", "province": "RE", "name": "BRESCELLO" },
    { "code": "B157", "province": "BS", "name": "BRESCIA" },
    { "code": "B158", "province": "TN", "name": "BRESIMO" },
    { "code": "A395", "province": "PV", "name": "BRESSANA (soppresso)" },
    { "code": "B159", "province": "PV", "name": "BRESSANA BOTTARONE" },
    { "code": "B160", "province": "TN", "name": "BRESSANONE (soppresso)" },
    { "code": "B160", "province": "BZ", "name": "BRESSANONE" },
    { "code": "B161", "province": "VI", "name": "BRESSANVIDO" },
    { "code": "B162", "province": "MI", "name": "BRESSO" },
    { "code": "B163", "province": "GO", "name": "BRESTOVIZZA IN VALLE (soppresso)" },
    { "code": "B163", "province": "UD", "name": "BRESTOVIZZA IN VALLE (soppresso)" },
    { "code": "B164", "province": "UD", "name": "BRETTO (soppresso)" },
    { "code": "B164", "province": "GO", "name": "BRETTO (soppresso)" },
    { "code": "B165", "province": "TN", "name": "BREZ" },
    { "code": "B166", "province": "CO", "name": "BREZZO DI BEDERO (soppresso)" },
    { "code": "B166", "province": "VA", "name": "BREZZO DI BEDERO" },
    { "code": "B167", "province": "CN", "name": "BRIAGLIA" },
    { "code": "B168", "province": "CO", "name": "BRIANZOLA (soppresso)" },
    { "code": "B169", "province": "CZ", "name": "BRIATICO (soppresso)" },
    { "code": "B169", "province": "VV", "name": "BRIATICO" },
    { "code": "B171", "province": "TO", "name": "BRICHERASIO" },
    { "code": "B172", "province": "CO", "name": "BRIENNO" },
    { "code": "B173", "province": "PZ", "name": "BRIENZA" },
    { "code": "B175", "province": "CN", "name": "BRIGA ALTA" },
    { "code": "B174", "province": "CN", "name": "BRIGA MARITTIMA (soppresso)" },
    { "code": "B176", "province": "NO", "name": "BRIGA NOVARESE" },
    { "code": "B177", "province": "AL", "name": "BRIGNANO DEL CURONE (soppresso)" },
    { "code": "B178", "province": "BG", "name": "BRIGNANO GERA D'ADDA" },
    { "code": "B179", "province": "AL", "name": "BRIGNANO-FRASCATA" },
    { "code": "B180", "province": "LE", "name": "BRINDISI (soppresso)" },
    { "code": "B180", "province": "BR", "name": "BRINDISI" },
    { "code": "B181", "province": "PZ", "name": "BRINDISI MONTAGNA" },
    { "code": "B182", "province": "CO", "name": "BRINZIO (soppresso)" },
    { "code": "B182", "province": "VA", "name": "BRINZIO" },
    { "code": "B183", "province": "NO", "name": "BRIONA" },
    { "code": "B184", "province": "BS", "name": "BRIONE" },
    { "code": "B185", "province": "TN", "name": "BRIONE (soppresso)" },
    { "code": "B186", "province": "PL", "name": "BRIONI MAGGIORE (soppresso)" },
    { "code": "B187", "province": "MI", "name": "BRIOSCO (soppresso)" },
    { "code": "B187", "province": "MB", "name": "BRIOSCO" },
    { "code": "B188", "province": "RA", "name": "BRISIGHELLA" },
    { "code": "B189", "province": "NO", "name": "BRISINO (soppresso)" },
    { "code": "B190", "province": "CO", "name": "BRISSAGO (soppresso)" },
    { "code": "B190", "province": "VA", "name": "BRISSAGO (soppresso)" },
    { "code": "B191", "province": "VA", "name": "BRISSAGO-VALTRAVAGLIA" },
    { "code": "B192", "province": "TO", "name": "BRISSOGNE (soppresso)" },
    { "code": "B192", "province": "AO", "name": "BRISSOGNE" },
    { "code": "C391", "province": "TS", "name": "BRITOVA (soppresso)" },
    { "code": "B193", "province": "TE", "name": "BRITTOLI (soppresso)" },
    { "code": "B193", "province": "PE", "name": "BRITTOLI" },
    { "code": "B194", "province": "CO", "name": "BRIVIO (soppresso)" },
    { "code": "B194", "province": "LC", "name": "BRIVIO" },
    { "code": "B195", "province": "CE", "name": "BROCCO (soppresso)" },
    { "code": "B195", "province": "FR", "name": "BROCCO (soppresso)" },
    { "code": "B195", "province": "FR", "name": "BROCCOSTELLA" },
    { "code": "B196", "province": "VI", "name": "BROGLIANO" },
    { "code": "B197", "province": "CZ", "name": "BROGNATURO (soppresso)" },
    { "code": "B197", "province": "VV", "name": "BROGNATURO" },
    { "code": "B198", "province": "ME", "name": "BROLO" },
    { "code": "B200", "province": "CN", "name": "BRONDELLO" },
    { "code": "B201", "province": "PV", "name": "BRONI" },
    { "code": "B202", "province": "CT", "name": "BRONTE" },
    { "code": "B203", "province": "TN", "name": "BRONZOLO (soppresso)" },
    { "code": "B203", "province": "BZ", "name": "BRONZOLO" },
    { "code": "B204", "province": "CN", "name": "BROSSASCO" },
    { "code": "B205", "province": "TO", "name": "BROSSO" },
    { "code": "B205", "province": "AO", "name": "BROSSO (soppresso)" },
    { "code": "B206", "province": "NO", "name": "BROVELLO (soppresso)" },
    { "code": "B207", "province": "NO", "name": "BROVELLO-CARPUGNINO (soppresso)" },
    { "code": "B207", "province": "VB", "name": "BROVELLO-CARPUGNINO" },
    { "code": "B208", "province": "GE", "name": "BROVIDA (soppresso)" },
    { "code": "B208", "province": "SV", "name": "BROVIDA (soppresso)" },
    { "code": "B209", "province": "TO", "name": "BROZOLO" },
    { "code": "B210", "province": "FI", "name": "BROZZI (soppresso)" },
    { "code": "B211", "province": "BS", "name": "BROZZO (soppresso)" },
    { "code": "B212", "province": "MI", "name": "BRUGHERIO (soppresso)" },
    { "code": "B212", "province": "MB", "name": "BRUGHERIO" },
    { "code": "B213", "province": "PD", "name": "BRUGINE" },
    { "code": "B214", "province": "GE", "name": "BRUGNATO (soppresso)" },
    { "code": "B214", "province": "SP", "name": "BRUGNATO" },
    { "code": "B215", "province": "UD", "name": "BRUGNERA (soppresso)" },
    { "code": "B215", "province": "PN", "name": "BRUGNERA" },
    { "code": "B216", "province": "TO", "name": "BRUINO" },
    { "code": "B217", "province": "BG", "name": "BRUMANO" },
    { "code": "B218", "province": "CO", "name": "BRUNATE" },
    { "code": "B219", "province": "CO", "name": "BRUNELLO (soppresso)" },
    { "code": "B219", "province": "VA", "name": "BRUNELLO" },
    { "code": "B220", "province": "TN", "name": "BRUNICO (soppresso)" },
    { "code": "B220", "province": "BZ", "name": "BRUNICO" },
    { "code": "B221", "province": "AL", "name": "BRUNO (soppresso)" },
    { "code": "B221", "province": "AT", "name": "BRUNO" },
    { "code": "B222", "province": "BG", "name": "BRUNTINO (soppresso)" },
    { "code": "B223", "province": "BG", "name": "BRUSAPORTO" },
    { "code": "B224", "province": "AL", "name": "BRUSASCHETTO (soppresso)" },
    { "code": "B225", "province": "TO", "name": "BRUSASCO" },
    { "code": "B226", "province": "TO", "name": "BRUSASCO CAVAGNOLO (soppresso)" },
    { "code": "B227", "province": "CE", "name": "BRUSCIANO (soppresso)" },
    { "code": "B227", "province": "NA", "name": "BRUSCIANO" },
    { "code": "B228", "province": "CO", "name": "BRUSIMPIANO (soppresso)" },
    { "code": "B228", "province": "VA", "name": "BRUSIMPIANO" },
    { "code": "B229", "province": "NO", "name": "BRUSNENGO (soppresso)" },
    { "code": "B229", "province": "VC", "name": "BRUSNENGO (soppresso)" },
    { "code": "B229", "province": "BI", "name": "BRUSNENGO" },
    { "code": "B225", "province": "TO", "name": "BRUSSASCO (soppresso)" },
    { "code": "B230", "province": "TO", "name": "BRUSSON (soppresso)" },
    { "code": "B230", "province": "AO", "name": "BRUSSON" },
    { "code": "B230", "province": "AO", "name": "BRUSSONE (soppresso)" },
    { "code": "B232", "province": "TO", "name": "BRUZOLO" },
    { "code": "B234", "province": "RC", "name": "BRUZZANO ZEFFIRIO" },
    { "code": "B235", "province": "MI", "name": "BUBBIANO" },
    { "code": "B236", "province": "AL", "name": "BUBBIO (soppresso)" },
    { "code": "B236", "province": "AT", "name": "BUBBIO" },
    { "code": "B237", "province": "SR", "name": "BUCCHERI" },
    { "code": "B238", "province": "CH", "name": "BUCCHIANICO" },
    { "code": "B239", "province": "BN", "name": "BUCCIANO" },
    { "code": "B240", "province": "MI", "name": "BUCCINASCO" },
    { "code": "B241", "province": "CO", "name": "BUCCINIGO (soppresso)" },
    { "code": "B242", "province": "SA", "name": "BUCCINO" },
    { "code": "B243", "province": "AR", "name": "BUCINE" },
    { "code": "B244", "province": "TS", "name": "BUCUIE (soppresso)" },
    { "code": "B245", "province": "GO", "name": "BUDAGNE (soppresso)" },
    { "code": "B245", "province": "UD", "name": "BUDAGNE (soppresso)" },
    { "code": "B246", "province": "SS", "name": "BUDDUSO'" },
    { "code": "B246", "province": "OT", "name": "BUDDUSO' (soppresso)" },
    { "code": "B247", "province": "UD", "name": "BUDOIA (soppresso)" },
    { "code": "B247", "province": "PN", "name": "BUDOIA" },
    { "code": "B248", "province": "NU", "name": "BUDONI (soppresso)" },
    { "code": "B248", "province": "OT", "name": "BUDONI (soppresso)" },
    { "code": "B248", "province": "SS", "name": "BUDONI" },
    { "code": "B249", "province": "BO", "name": "BUDRIO" },
    { "code": "B250", "province": "CA", "name": "BUGGERRU (soppresso)" },
    { "code": "B250", "province": "CI", "name": "BUGGERRU (soppresso)" },
    { "code": "B250", "province": "SU", "name": "BUGGERRU" },
    { "code": "B251", "province": "LU", "name": "BUGGIANO (soppresso)" },
    { "code": "B251", "province": "PT", "name": "BUGGIANO" },
    { "code": "B252", "province": "CO", "name": "BUGGIOLO (soppresso)" },
    { "code": "B253", "province": "CO", "name": "BUGIALLO (soppresso)" },
    { "code": "B255", "province": "SO", "name": "BUGLIO IN MONTE" },
    { "code": "B256", "province": "AQ", "name": "BUGNARA" },
    { "code": "B257", "province": "NO", "name": "BUGNATE (soppresso)" },
    { "code": "B258", "province": "CO", "name": "BUGUGGIATE (soppresso)" },
    { "code": "B258", "province": "VA", "name": "BUGUGGIATE" },
    { "code": "B260", "province": "PL", "name": "BUIE D'ISTRIA (soppresso)" },
    { "code": "B259", "province": "UD", "name": "BUJA" },
    { "code": "B261", "province": "CO", "name": "BULCIAGO (soppresso)" },
    { "code": "B261", "province": "LC", "name": "BULCIAGO" },
    { "code": "B262", "province": "CO", "name": "BULGAROGRASSO" },
    { "code": "B263", "province": "CO", "name": "BULGORELLO (soppresso)" },
    { "code": "B264", "province": "SS", "name": "BULTEI" },
    { "code": "B265", "province": "SS", "name": "BULZI" },
    { "code": "A958", "province": "PA", "name": "BUOMPIETRO (soppresso)" },
    { "code": "B266", "province": "SA", "name": "BUONABITACOLO" },
    { "code": "B267", "province": "BN", "name": "BUONALBERGO" },
    { "code": "B268", "province": "CH", "name": "BUONANOTTE (soppresso)" },
    { "code": "B269", "province": "SI", "name": "BUONCONVENTO" },
    { "code": "B270", "province": "CS", "name": "BUONVICINO" },
    { "code": "B272", "province": "MI", "name": "BURAGO DI MOLGORA (soppresso)" },
    { "code": "B272", "province": "MB", "name": "BURAGO DI MOLGORA" },
    { "code": "B273", "province": "VE", "name": "BURANO (soppresso)" },
    { "code": "B274", "province": "CA", "name": "BURCEI (soppresso)" },
    { "code": "B274", "province": "SU", "name": "BURCEI" },
    { "code": "B275", "province": "AG", "name": "BURGIO" },
    { "code": "B276", "province": "SS", "name": "BURGOS" },
    { "code": "B277", "province": "TN", "name": "BURGUSIO (soppresso)" },
    { "code": "B277", "province": "BZ", "name": "BURGUSIO (soppresso)" },
    { "code": "B278", "province": "TO", "name": "BURIASCO" },
    { "code": "B279", "province": "TO", "name": "BUROLO" },
    { "code": "B279", "province": "AO", "name": "BUROLO (soppresso)" },
    { "code": "B280", "province": "NO", "name": "BURONZO (soppresso)" },
    { "code": "B280", "province": "VC", "name": "BURONZO" },
    { "code": "B281", "province": "CA", "name": "BUSACHI (soppresso)" },
    { "code": "B281", "province": "OR", "name": "BUSACHI" },
    { "code": "B282", "province": "GE", "name": "BUSALLA" },
    { "code": "B283", "province": "RE", "name": "BUSANA (soppresso)" },
    { "code": "B284", "province": "TO", "name": "BUSANO" },
    { "code": "B285", "province": "CN", "name": "BUSCA" },
    { "code": "B286", "province": "MI", "name": "BUSCATE" },
    { "code": "B287", "province": "SR", "name": "BUSCEMI" },
    { "code": "B288", "province": "TP", "name": "BUSETO PALIZZOLO" },
    { "code": "B289", "province": "MI", "name": "BUSNAGO (soppresso)" },
    { "code": "B289", "province": "MB", "name": "BUSNAGO" },
    { "code": "B290", "province": "RO", "name": "BUSO SARZANO (soppresso)" },
    { "code": "B291", "province": "IM", "name": "BUSSANA (soppresso)" },
    { "code": "B292", "province": "MI", "name": "BUSSERO" },
    { "code": "B293", "province": "PR", "name": "BUSSETO" },
    { "code": "B294", "province": "AQ", "name": "BUSSI SUL TIRINO (soppresso)" },
    { "code": "B294", "province": "PE", "name": "BUSSI SUL TIRINO" },
    { "code": "B295", "province": "CB", "name": "BUSSO" },
    { "code": "B296", "province": "VR", "name": "BUSSOLENGO" },
    { "code": "B297", "province": "TO", "name": "BUSSOLENO" },
    { "code": "B298", "province": "TO", "name": "BUSSOLINO GASSINESE (soppresso)" },
    { "code": "B300", "province": "MI", "name": "BUSTO ARSIZIO (soppresso)" },
    { "code": "B300", "province": "VA", "name": "BUSTO ARSIZIO" },
    { "code": "B301", "province": "MI", "name": "BUSTO GAROLFO" },
    { "code": "B302", "province": "CL", "name": "BUTERA" },
    { "code": "B303", "province": "PI", "name": "BUTI" },
    { "code": "B304", "province": "VR", "name": "BUTTAPIETRA" },
    { "code": "B305", "province": "TO", "name": "BUTTIGLIERA ALTA" },
    { "code": "B306", "province": "AL", "name": "BUTTIGLIERA D'ASTI (soppresso)" },
    { "code": "B306", "province": "AT", "name": "BUTTIGLIERA D'ASTI" },
    { "code": "B308", "province": "NO", "name": "BUTTOGNO (soppresso)" },
    { "code": "B309", "province": "UD", "name": "BUTTRIO" },
    { "code": "B320", "province": "CR", "name": "CA' D'ANDREA (soppresso)" },
    { "code": "B339", "province": "CR", "name": "CA' DE' STEFANI (soppresso)" },
    { "code": "B340", "province": "PV", "name": "CA' DE' TEDIOLI (soppresso)" },
    { "code": "B342", "province": "VR", "name": "CA' DI DAVID (soppresso)" },
    { "code": "B348", "province": "RO", "name": "CA' EMO (soppresso)" },
    { "code": "B311", "province": "AL", "name": "CABELLA LIGURE" },
    { "code": "B312", "province": "CO", "name": "CABIAGLIO (soppresso)" },
    { "code": "B312", "province": "VA", "name": "CABIAGLIO (soppresso)" },
    { "code": "B313", "province": "CO", "name": "CABIATE" },
    { "code": "B314", "province": "CA", "name": "CABRAS (soppresso)" },
    { "code": "B314", "province": "OR", "name": "CABRAS" },
    { "code": "B315", "province": "PA", "name": "CACCAMO" },
    { "code": "B316", "province": "BS", "name": "CACCAVERO (soppresso)" },
    { "code": "B317", "province": "CB", "name": "CACCAVONE (soppresso)" },
    { "code": "B318", "province": "TS", "name": "CACCIA (soppresso)" },
    { "code": "B319", "province": "CZ", "name": "CACCURI (soppresso)" },
    { "code": "B319", "province": "KR", "name": "CACCURI" },
    { "code": "B321", "province": "NO", "name": "CADDO (soppresso)" },
    { "code": "B325", "province": "CO", "name": "CADEGLIANO (soppresso)" },
    { "code": "B325", "province": "VA", "name": "CADEGLIANO (soppresso)" },
    { "code": "B326", "province": "VA", "name": "CADEGLIANO-VICONAGO" },
    { "code": "B328", "province": "RE", "name": "CADELBOSCO DI SOPRA" },
    { "code": "B332", "province": "PC", "name": "CADEO" },
    { "code": "B334", "province": "CO", "name": "CADERO CON GRAGLIO (soppresso)" },
    { "code": "B334", "province": "VA", "name": "CADERO CON GRAGLIO (soppresso)" },
    { "code": "B335", "province": "TN", "name": "CADERZONE (soppresso)" },
    { "code": "B335", "province": "TN", "name": "CADERZONE TERME" },
    { "code": "B343", "province": "BS", "name": "CADIGNANO (soppresso)" },
    { "code": "B344", "province": "TN", "name": "CADINE (soppresso)" },
    { "code": "B345", "province": "PD", "name": "CADONEGHE" },
    { "code": "B346", "province": "CO", "name": "CADORAGO" },
    { "code": "B347", "province": "CO", "name": "CADREZZATE (soppresso)" },
    { "code": "B347", "province": "VA", "name": "CADREZZATE (soppresso)" },
    { "code": "M425", "province": "VA", "name": "CADREZZATE CON OSMATE" },
    { "code": "B349", "province": "TV", "name": "CAERANO DI SAN MARCO" },
    { "code": "B350", "province": "TO", "name": "CAFASSE" },
    { "code": "B351", "province": "SA", "name": "CAGGIANO" },
    { "code": "B352", "province": "PS", "name": "CAGLI (soppresso)" },
    { "code": "B352", "province": "PU", "name": "CAGLI" },
    { "code": "B353", "province": "CO", "name": "CAGLIANO (soppresso)" },
    { "code": "B354", "province": "CA", "name": "CAGLIARI" },
    { "code": "B355", "province": "CO", "name": "CAGLIO" },
    { "code": "B358", "province": "AQ", "name": "CAGNANO AMITERNO" },
    { "code": "B357", "province": "FG", "name": "CAGNANO VARANO" },
    { "code": "B359", "province": "CO", "name": "CAGNO (soppresso)" },
    { "code": "B360", "province": "TN", "name": "CAGNO'" },
    { "code": "B361", "province": "CE", "name": "CAIANELLO" },
    { "code": "B361", "province": "NA", "name": "CAIANELLO (soppresso)" },
    { "code": "B362", "province": "CE", "name": "CAIAZZO" },
    { "code": "B362", "province": "BN", "name": "CAIAZZO (soppresso)" },
    { "code": "B364", "province": "TN", "name": "CAINES (soppresso)" },
    { "code": "B364", "province": "BZ", "name": "CAINES" },
    { "code": "B365", "province": "BS", "name": "CAINO" },
    { "code": "B366", "province": "SO", "name": "CAIOLO" },
    { "code": "B367", "province": "AV", "name": "CAIRANO" },
    { "code": "B368", "province": "MI", "name": "CAIRATE (soppresso)" },
    { "code": "B368", "province": "VA", "name": "CAIRATE" },
    { "code": "B369", "province": "GE", "name": "CAIRO MONTENOTTE (soppresso)" },
    { "code": "B369", "province": "SV", "name": "CAIRO MONTENOTTE" },
    { "code": "B371", "province": "NA", "name": "CAIVANO" },
    { "code": "B372", "province": "MI", "name": "CAJELLO (soppresso)" },
    { "code": "B373", "province": "BS", "name": "CAJONVICO (soppresso)" },
    { "code": "B401", "province": "GO", "name": "CAL DI CANALE (soppresso)" },
    { "code": "B401", "province": "UD", "name": "CAL DI CANALE (soppresso)" },
    { "code": "B374", "province": "AV", "name": "CALABRITTO" },
    { "code": "B375", "province": "BL", "name": "CALALZO (soppresso)" },
    { "code": "B375", "province": "BL", "name": "CALALZO DI CADORE" },
    { "code": "B376", "province": "AL", "name": "CALAMANDRANA (soppresso)" },
    { "code": "B376", "province": "AT", "name": "CALAMANDRANA" },
    { "code": "B377", "province": "AG", "name": "CALAMONACI" },
    { "code": "B378", "province": "SS", "name": "CALANGIANUS" },
    { "code": "B378", "province": "OT", "name": "CALANGIANUS (soppresso)" },
    { "code": "B379", "province": "RC", "name": "CALANNA" },
    { "code": "B380", "province": "NO", "name": "CALASCA (soppresso)" },
    { "code": "B380", "province": "NO", "name": "CALASCA-CASTIGLIONE (soppresso)" },
    { "code": "B380", "province": "VB", "name": "CALASCA-CASTIGLIONE" },
    { "code": "B381", "province": "CL", "name": "CALASCIBETTA (soppresso)" },
    { "code": "B381", "province": "EN", "name": "CALASCIBETTA" },
    { "code": "B382", "province": "AQ", "name": "CALASCIO" },
    { "code": "B383", "province": "CA", "name": "CALASETTA (soppresso)" },
    { "code": "B383", "province": "CI", "name": "CALASETTA (soppresso)" },
    { "code": "B383", "province": "SU", "name": "CALASETTA" },
    { "code": "B384", "province": "CT", "name": "CALATABIANO" },
    { "code": "B385", "province": "TP", "name": "CALATAFIMI (soppresso)" },
    { "code": "B385", "province": "TP", "name": "CALATAFIMI-SEGESTA" },
    { "code": "B386", "province": "TN", "name": "CALAVINO (soppresso)" },
    { "code": "B388", "province": "RM", "name": "CALCATA (soppresso)" },
    { "code": "B388", "province": "VT", "name": "CALCATA" },
    { "code": "B389", "province": "TN", "name": "CALCERANICA (soppresso)" },
    { "code": "B389", "province": "TN", "name": "CALCERANICA AL LAGO" },
    { "code": "B390", "province": "PI", "name": "CALCI" },
    { "code": "B391", "province": "PZ", "name": "CALCIANO (soppresso)" },
    { "code": "B391", "province": "MT", "name": "CALCIANO" },
    { "code": "B392", "province": "PI", "name": "CALCINAIA" },
    { "code": "B393", "province": "BG", "name": "CALCINATE" },
    { "code": "B394", "province": "BS", "name": "CALCINATO" },
    { "code": "B395", "province": "BG", "name": "CALCIO" },
    { "code": "B396", "province": "CO", "name": "CALCO (soppresso)" },
    { "code": "B396", "province": "LC", "name": "CALCO" },
    { "code": "B397", "province": "TN", "name": "CALDARO (soppresso)" },
    { "code": "B397", "province": "BZ", "name": "CALDARO (soppresso)" },
    { "code": "B397", "province": "BZ", "name": "CALDARO SULLA STRADA DEL VINO" },
    { "code": "B398", "province": "MC", "name": "CALDAROLA" },
    { "code": "B399", "province": "BO", "name": "CALDERARA DI RENO" },
    { "code": "B400", "province": "TN", "name": "CALDES" },
    { "code": "B402", "province": "VR", "name": "CALDIERO" },
    { "code": "B403", "province": "VI", "name": "CALDOGNO" },
    { "code": "B404", "province": "TN", "name": "CALDONAZZO" },
    { "code": "B405", "province": "PC", "name": "CALENDASCO" },
    { "code": "B406", "province": "FI", "name": "CALENZANO" },
    { "code": "B407", "province": "BG", "name": "CALEPIO (soppresso)" },
    { "code": "B408", "province": "PR", "name": "CALESTANO" },
    { "code": "B410", "province": "MS", "name": "CALICE AL CORNOVIGLIO (soppresso)" },
    { "code": "B410", "province": "SP", "name": "CALICE AL CORNOVIGLIO" },
    { "code": "B409", "province": "GE", "name": "CALICE LIGURE (soppresso)" },
    { "code": "B409", "province": "SV", "name": "CALICE LIGURE" },
    { "code": "B413", "province": "LE", "name": "CALIMERA" },
    { "code": "B414", "province": "BS", "name": "CALINO (soppresso)" },
    { "code": "B415", "province": "AV", "name": "CALITRI" },
    { "code": "B416", "province": "GE", "name": "CALIZZANO (soppresso)" },
    { "code": "B416", "province": "SV", "name": "CALIZZANO" },
    { "code": "B417", "province": "NO", "name": "CALLABIANA (soppresso)" },
    { "code": "B417", "province": "VC", "name": "CALLABIANA (soppresso)" },
    { "code": "B417", "province": "BI", "name": "CALLABIANA" },
    { "code": "B418", "province": "AL", "name": "CALLIANO (soppresso)" },
    { "code": "B419", "province": "TN", "name": "CALLIANO" },
    { "code": "B418", "province": "AT", "name": "CALLIANO" },
    { "code": "B421", "province": "NO", "name": "CALOGNA (soppresso)" },
    { "code": "B422", "province": "BG", "name": "CALOLZIO (soppresso)" },
    { "code": "B423", "province": "BG", "name": "CALOLZIOCORTE (soppresso)" },
    { "code": "B423", "province": "LC", "name": "CALOLZIOCORTE" },
    { "code": "B424", "province": "CS", "name": "CALOPEZZATI" },
    { "code": "B425", "province": "AL", "name": "CALOSSO (soppresso)" },
    { "code": "B425", "province": "AT", "name": "CALOSSO" },
    { "code": "B426", "province": "CS", "name": "CALOVETO" },
    { "code": "B427", "province": "AG", "name": "CALTABELLOTTA" },
    { "code": "B428", "province": "CT", "name": "CALTAGIRONE" },
    { "code": "B429", "province": "CL", "name": "CALTANISSETTA" },
    { "code": "B430", "province": "PA", "name": "CALTAVUTURO" },
    { "code": "B431", "province": "NO", "name": "CALTIGNAGA" },
    { "code": "B432", "province": "RO", "name": "CALTO" },
    { "code": "B433", "province": "VI", "name": "CALTRANO" },
    { "code": "B434", "province": "BG", "name": "CALUSCO D'ADDA" },
    { "code": "B435", "province": "TO", "name": "CALUSO" },
    { "code": "B435", "province": "AO", "name": "CALUSO (soppresso)" },
    { "code": "B436", "province": "BS", "name": "CALVAGESE (soppresso)" },
    { "code": "B436", "province": "BS", "name": "CALVAGESE DELLA RIVIERA" },
    { "code": "B437", "province": "SA", "name": "CALVANICO" },
    { "code": "B438", "province": "ME", "name": "CALVARUSO (soppresso)" },
    { "code": "B439", "province": "CR", "name": "CALVATONE" },
    { "code": "B440", "province": "PZ", "name": "CALVELLO" },
    { "code": "B441", "province": "VI", "name": "CALVENE" },
    { "code": "B442", "province": "BG", "name": "CALVENZANO" },
    { "code": "B443", "province": "PZ", "name": "CALVERA" },
    { "code": "B444", "province": "BN", "name": "CALVI" },
    { "code": "B446", "province": "PG", "name": "CALVI DELL'UMBRIA (soppresso)" },
    { "code": "B446", "province": "TR", "name": "CALVI DELL'UMBRIA" },
    { "code": "B445", "province": "CE", "name": "CALVI RISORTA" },
    { "code": "B445", "province": "NA", "name": "CALVI RISORTA (soppresso)" },
    { "code": "B449", "province": "BN", "name": "CALVI SAN NAZZARO (soppresso)" },
    { "code": "B447", "province": "PV", "name": "CALVIGNANO" },
    { "code": "B448", "province": "MI", "name": "CALVIGNASCO" },
    { "code": "B450", "province": "BS", "name": "CALVISANO" },
    { "code": "B452", "province": "NA", "name": "CALVIZZANO" },
    { "code": "B454", "province": "TO", "name": "CAMAGNA DI TORINO (soppresso)" },
    { "code": "B453", "province": "AL", "name": "CAMAGNA MONFERRATO" },
    { "code": "B455", "province": "LU", "name": "CAMAIORE" },
    { "code": "B456", "province": "MI", "name": "CAMAIRAGO (soppresso)" },
    { "code": "B456", "province": "LO", "name": "CAMAIRAGO (soppresso)" },
    { "code": "B457", "province": "NO", "name": "CAMANDONA (soppresso)" },
    { "code": "B457", "province": "VC", "name": "CAMANDONA (soppresso)" },
    { "code": "B457", "province": "BI", "name": "CAMANDONA" },
    { "code": "B458", "province": "AQ", "name": "CAMARDA (soppresso)" },
    { "code": "B459", "province": "NO", "name": "CAMASCO (soppresso)" },
    { "code": "B459", "province": "VC", "name": "CAMASCO (soppresso)" },
    { "code": "B460", "province": "AG", "name": "CAMASTRA" },
    { "code": "B461", "province": "MI", "name": "CAMBIAGO" },
    { "code": "B462", "province": "TO", "name": "CAMBIANO" },
    { "code": "B463", "province": "NO", "name": "CAMBIASCA (soppresso)" },
    { "code": "B463", "province": "VB", "name": "CAMBIASCA" },
    { "code": "B465", "province": "NO", "name": "CAMBURZANO (soppresso)" },
    { "code": "B465", "province": "VC", "name": "CAMBURZANO (soppresso)" },
    { "code": "B465", "province": "BI", "name": "CAMBURZANO" },
    { "code": "B467", "province": "CN", "name": "CAMERANA" },
    { "code": "B468", "province": "AN", "name": "CAMERANO" },
    { "code": "B469", "province": "AL", "name": "CAMERANO CASASCO (soppresso)" },
    { "code": "B469", "province": "AT", "name": "CAMERANO CASASCO" },
    { "code": "B471", "province": "BG", "name": "CAMERATA CORNELLO" },
    { "code": "B472", "province": "RM", "name": "CAMERATA NUOVA" },
    { "code": "B470", "province": "AN", "name": "CAMERATA PICENA" },
    { "code": "B473", "province": "NO", "name": "CAMERI" },
    { "code": "B474", "province": "MC", "name": "CAMERINO" },
    { "code": "B476", "province": "SA", "name": "CAMEROTA" },
    { "code": "B477", "province": "CE", "name": "CAMIGLIANO" },
    { "code": "B477", "province": "NA", "name": "CAMIGLIANO (soppresso)" },
    { "code": "B793", "province": "UD", "name": "CAMIGNA (soppresso)" },
    { "code": "B793", "province": "GO", "name": "CAMIGNA (soppresso)" },
    { "code": "B478", "province": "BS", "name": "CAMIGNONE (soppresso)" },
    { "code": "B479", "province": "PV", "name": "CAMINATA (soppresso)" },
    { "code": "B479", "province": "PC", "name": "CAMINATA (soppresso)" },
    { "code": "B480", "province": "TN", "name": "CAMINATA IN TURES (soppresso)" },
    { "code": "B480", "province": "BZ", "name": "CAMINATA IN TURES (soppresso)" },
    { "code": "B481", "province": "RC", "name": "CAMINI" },
    { "code": "B482", "province": "AL", "name": "CAMINO" },
    { "code": "B483", "province": "UD", "name": "CAMINO AL TAGLIAMENTO" },
    { "code": "B483", "province": "UD", "name": "CAMINO DI CODROIPO (soppresso)" },
    { "code": "B484", "province": "CR", "name": "CAMISANO" },
    { "code": "B485", "province": "VI", "name": "CAMISANO VICENTINO" },
    { "code": "B486", "province": "AG", "name": "CAMMARATA" },
    { "code": "B488", "province": "CO", "name": "CAMNAGO FALOPPIA (soppresso)" },
    { "code": "B487", "province": "CO", "name": "CAMNAGO VOLTA (soppresso)" },
    { "code": "B793", "province": "GO", "name": "CAMNIE (soppresso)" },
    { "code": "B793", "province": "UD", "name": "CAMNIE (soppresso)" },
    { "code": "B489", "province": "CN", "name": "CAMO (soppresso)" },
    { "code": "B490", "province": "GE", "name": "CAMOGLI" },
    { "code": "B491", "province": "AO", "name": "CAMOSIO (soppresso)" },
    { "code": "B492", "province": "SA", "name": "CAMPAGNA" },
    { "code": "B493", "province": "VE", "name": "CAMPAGNA LUPIA" },
    { "code": "B496", "province": "RM", "name": "CAMPAGNANO DI ROMA" },
    { "code": "B495", "province": "CO", "name": "CAMPAGNANO VEDASCA (soppresso)" },
    { "code": "B495", "province": "VA", "name": "CAMPAGNANO VEDASCA (soppresso)" },
    { "code": "B497", "province": "GR", "name": "CAMPAGNATICO" },
    { "code": "B498", "province": "CR", "name": "CAMPAGNOLA CREMASCA" },
    { "code": "B499", "province": "RE", "name": "CAMPAGNOLA EMILIA" },
    { "code": "B500", "province": "CS", "name": "CAMPANA" },
    { "code": "B501", "province": "MI", "name": "CAMPARADA (soppresso)" },
    { "code": "B501", "province": "MB", "name": "CAMPARADA" },
    { "code": "B502", "province": "RE", "name": "CAMPEGINE" },
    { "code": "B503", "province": "NO", "name": "CAMPELLO MONTI (soppresso)" },
    { "code": "B503", "province": "VC", "name": "CAMPELLO MONTI (soppresso)" },
    { "code": "B504", "province": "PG", "name": "CAMPELLO SUL CLITUNNO" },
    { "code": "B505", "province": "NO", "name": "CAMPERTOGNO (soppresso)" },
    { "code": "B505", "province": "VC", "name": "CAMPERTOGNO" },
    { "code": "B507", "province": "FI", "name": "CAMPI BISENZIO" },
    { "code": "B506", "province": "LE", "name": "CAMPI SALENTINA" },
    { "code": "B508", "province": "NO", "name": "CAMPIGLIA CERVO (soppresso)" },
    { "code": "B508", "province": "VC", "name": "CAMPIGLIA CERVO (soppresso)" },
    { "code": "B508", "province": "BI", "name": "CAMPIGLIA CERVO (soppresso)" },
    { "code": "M373", "province": "BI", "name": "CAMPIGLIA CERVO" },
    { "code": "B511", "province": "VI", "name": "CAMPIGLIA DEI BERICI" },
    { "code": "B509", "province": "PI", "name": "CAMPIGLIA MARITTIMA (soppresso)" },
    { "code": "B509", "province": "LI", "name": "CAMPIGLIA MARITTIMA" },
    { "code": "ND", "province": "TO", "name": "CAMPIGLIA SOANA (soppresso)" },
    { "code": "ND", "province": "AO", "name": "CAMPIGLIA SOANA (soppresso)" },
    { "code": "B512", "province": "TO", "name": "CAMPIGLIONE (soppresso)" },
    { "code": "B512", "province": "TO", "name": "CAMPIGLIONE FENILE" },
    { "code": "B513", "province": "CO", "name": "CAMPIONE (soppresso)" },
    { "code": "B513", "province": "CO", "name": "CAMPIONE D'ITALIA" },
    { "code": "B514", "province": "TN", "name": "CAMPITELLO (soppresso)" },
    { "code": "B514", "province": "TN", "name": "CAMPITELLO DI FASSA" },
    { "code": "B515", "province": "TE", "name": "CAMPLI" },
    { "code": "B518", "province": "TN", "name": "CAMPO (soppresso)" },
    { "code": "B516", "province": "RC", "name": "CAMPO CALABRO" },
    { "code": "B517", "province": "TO", "name": "CAMPO CANAVESE (soppresso)" },
    { "code": "B517", "province": "AO", "name": "CAMPO CANAVESE (soppresso)" },
    { "code": "B516", "province": "RC", "name": "CAMPO DI CALABRIA (soppresso)" },
    { "code": "B526", "province": "AQ", "name": "CAMPO DI GIOVE" },
    { "code": "B529", "province": "BZ", "name": "CAMPO DI TRENS" },
    { "code": "B540", "province": "AO", "name": "CAMPO LARIS (soppresso)" },
    { "code": "B538", "province": "GE", "name": "CAMPO LIGURE" },
    { "code": "B553", "province": "LI", "name": "CAMPO NELL'ELBA" },
    { "code": "B564", "province": "PD", "name": "CAMPO SAN MARTINO" },
    { "code": "B570", "province": "TN", "name": "CAMPO TURES (soppresso)" },
    { "code": "B570", "province": "BZ", "name": "CAMPO TURES" },
    { "code": "B519", "province": "CB", "name": "CAMPOBASSO" },
    { "code": "B520", "province": "AG", "name": "CAMPOBELLO DI LICATA" },
    { "code": "B521", "province": "TP", "name": "CAMPOBELLO DI MAZARA" },
    { "code": "B522", "province": "CB", "name": "CAMPOCHIARO" },
    { "code": "B523", "province": "GE", "name": "CAMPOCHIESA (soppresso)" },
    { "code": "B523", "province": "SV", "name": "CAMPOCHIESA (soppresso)" },
    { "code": "B524", "province": "PD", "name": "CAMPODARSEGO" },
    { "code": "B525", "province": "TN", "name": "CAMPODENNO" },
    { "code": "B527", "province": "CE", "name": "CAMPODIMELE (soppresso)" },
    { "code": "B527", "province": "RM", "name": "CAMPODIMELE (soppresso)" },
    { "code": "B527", "province": "LT", "name": "CAMPODIMELE" },
    { "code": "B528", "province": "CB", "name": "CAMPODIPIETRA" },
    { "code": "B530", "province": "SO", "name": "CAMPODOLCINO" },
    { "code": "B531", "province": "PD", "name": "CAMPODORO" },
    { "code": "B532", "province": "PA", "name": "CAMPOFELICE (soppresso)" },
    { "code": "B533", "province": "PA", "name": "CAMPOFELICE DI FITALIA" },
    { "code": "B532", "province": "PA", "name": "CAMPOFELICE DI ROCCELLA" },
    { "code": "B534", "province": "AP", "name": "CAMPOFILONE (soppresso)" },
    { "code": "B534", "province": "FM", "name": "CAMPOFILONE" },
    { "code": "B535", "province": "PA", "name": "CAMPOFIORITO" },
    { "code": "B536", "province": "UD", "name": "CAMPOFORMIDO" },
    { "code": "B537", "province": "CL", "name": "CAMPOFRANCO" },
    { "code": "B539", "province": "MO", "name": "CAMPOGALLIANO" },
    { "code": "B541", "province": "BN", "name": "CAMPOLATTARO" },
    { "code": "B543", "province": "CE", "name": "CAMPOLI APPENNINO (soppresso)" },
    { "code": "B543", "province": "FR", "name": "CAMPOLI APPENNINO" },
    { "code": "B542", "province": "BN", "name": "CAMPOLI DEL MONTE TABURNO" },
    { "code": "B544", "province": "CB", "name": "CAMPOLIETO" },
    { "code": "B545", "province": "UD", "name": "CAMPOLONGO (soppresso)" },
    { "code": "B545", "province": "UD", "name": "CAMPOLONGO AL TORRE (soppresso)" },
    { "code": "B546", "province": "VE", "name": "CAMPOLONGO MAGGIORE" },
    { "code": "B547", "province": "VI", "name": "CAMPOLONGO SUL BRENTA (soppresso)" },
    { "code": "M311", "province": "UD", "name": "CAMPOLONGO TAPOGLIANO" },
    { "code": "B549", "province": "PZ", "name": "CAMPOMAGGIORE" },
    { "code": "B550", "province": "CB", "name": "CAMPOMARINO" },
    { "code": "B551", "province": "GE", "name": "CAMPOMORONE" },
    { "code": "B554", "province": "VE", "name": "CAMPONOGARA" },
    { "code": "B555", "province": "SA", "name": "CAMPORA" },
    { "code": "B556", "province": "TP", "name": "CAMPOREALE (soppresso)" },
    { "code": "B556", "province": "PA", "name": "CAMPOREALE" },
    { "code": "B557", "province": "MS", "name": "CAMPORGIANO (soppresso)" },
    { "code": "B557", "province": "LU", "name": "CAMPORGIANO" },
    { "code": "B559", "province": "IM", "name": "CAMPOROSSO" },
    { "code": "B560", "province": "UD", "name": "CAMPOROSSO (soppresso)" },
    { "code": "B560", "province": "UD", "name": "CAMPOROSSO IN VALCANALE (soppresso)" },
    { "code": "B562", "province": "MC", "name": "CAMPOROTONDO DI FIASTRONE" },
    { "code": "B561", "province": "CT", "name": "CAMPOROTONDO ETNEO" },
    { "code": "B563", "province": "PD", "name": "CAMPOSAMPIERO" },
    { "code": "B565", "province": "CE", "name": "CAMPOSANO (soppresso)" },
    { "code": "B565", "province": "NA", "name": "CAMPOSANO" },
    { "code": "B566", "province": "MO", "name": "CAMPOSANTO" },
    { "code": "B567", "province": "PV", "name": "CAMPOSPINOSO" },
    { "code": "B568", "province": "PV", "name": "CAMPOSPINOSO ALBAREDO (soppresso)" },
    { "code": "B569", "province": "AQ", "name": "CAMPOTOSTO" },
    { "code": "B316", "province": "BS", "name": "CAMPOVERDE (soppresso)" },
    { "code": "B571", "province": "SO", "name": "CAMPOVICO (soppresso)" },
    { "code": "B572", "province": "BO", "name": "CAMUGNANO" },
    { "code": "B577", "province": "TN", "name": "CANAL SAN BOVO" },
    { "code": "B573", "province": "CN", "name": "CANALE" },
    { "code": "B574", "province": "BL", "name": "CANALE D'AGORDO" },
    { "code": "B575", "province": "GO", "name": "CANALE D'ISONZO (soppresso)" },
    { "code": "B575", "province": "UD", "name": "CANALE D'ISONZO (soppresso)" },
    { "code": "B576", "province": "RM", "name": "CANALE MONTERANO" },
    { "code": "B578", "province": "RO", "name": "CANARO" },
    { "code": "B579", "province": "TN", "name": "CANAZEI" },
    { "code": "B580", "province": "PZ", "name": "CANCELLARA" },
    { "code": "B581", "province": "CE", "name": "CANCELLO ED ARNONE" },
    { "code": "B581", "province": "NA", "name": "CANCELLO ED ARNONE (soppresso)" },
    { "code": "B582", "province": "RO", "name": "CANDA" },
    { "code": "B583", "province": "IM", "name": "CANDEASCO (soppresso)" },
    { "code": "B584", "province": "FG", "name": "CANDELA" },
    { "code": "B585", "province": "PS", "name": "CANDELARA (soppresso)" },
    { "code": "B586", "province": "NO", "name": "CANDELO (soppresso)" },
    { "code": "B586", "province": "VC", "name": "CANDELO (soppresso)" },
    { "code": "B586", "province": "BI", "name": "CANDELO" },
    { "code": "B588", "province": "TO", "name": "CANDIA CANAVESE" },
    { "code": "B588", "province": "AO", "name": "CANDIA CANAVESE (soppresso)" },
    { "code": "B587", "province": "PV", "name": "CANDIA LOMELLINA" },
    { "code": "B589", "province": "PD", "name": "CANDIANA" },
    { "code": "B590", "province": "AV", "name": "CANDIDA" },
    { "code": "B591", "province": "RC", "name": "CANDIDONI" },
    { "code": "B592", "province": "TO", "name": "CANDIOLO" },
    { "code": "B593", "province": "MI", "name": "CANEGRATE" },
    { "code": "B594", "province": "AL", "name": "CANELLI (soppresso)" },
    { "code": "B594", "province": "AT", "name": "CANELLI" },
    { "code": "B596", "province": "GE", "name": "CANEPA (soppresso)" },
    { "code": "B597", "province": "RM", "name": "CANEPINA (soppresso)" },
    { "code": "B597", "province": "VT", "name": "CANEPINA" },
    { "code": "B598", "province": "UD", "name": "CANEVA (soppresso)" },
    { "code": "B598", "province": "PN", "name": "CANEVA" },
    { "code": "B599", "province": "PV", "name": "CANEVINO (soppresso)" },
    { "code": "B600", "province": "TN", "name": "CANEZZA (soppresso)" },
    { "code": "B601", "province": "PL", "name": "CANFANARO (soppresso)" },
    { "code": "B602", "province": "AG", "name": "CANICATTI'" },
    { "code": "B603", "province": "SR", "name": "CANICATTINI BAGNI" },
    { "code": "B604", "province": "RM", "name": "CANINO (soppresso)" },
    { "code": "B604", "province": "VT", "name": "CANINO" },
    { "code": "B605", "province": "TO", "name": "CANISCHIO" },
    { "code": "B605", "province": "AO", "name": "CANISCHIO (soppresso)" },
    { "code": "B606", "province": "AQ", "name": "CANISTRO" },
    { "code": "B607", "province": "CS", "name": "CANNA" },
    { "code": "B608", "province": "SA", "name": "CANNALONGA" },
    { "code": "B609", "province": "PG", "name": "CANNARA" },
    { "code": "B610", "province": "NO", "name": "CANNERO (soppresso)" },
    { "code": "B610", "province": "NO", "name": "CANNERO RIVIERA (soppresso)" },
    { "code": "B610", "province": "VB", "name": "CANNERO RIVIERA" },
    { "code": "B611", "province": "BA", "name": "CANNETO DI BARI (soppresso)" },
    { "code": "B613", "province": "PV", "name": "CANNETO PAVESE" },
    { "code": "B612", "province": "MN", "name": "CANNETO SULL'OGLIO" },
    { "code": "B614", "province": "RC", "name": "CANNITELLO (soppresso)" },
    { "code": "B615", "province": "NO", "name": "CANNOBIO (soppresso)" },
    { "code": "B615", "province": "VB", "name": "CANNOBIO" },
    { "code": "B616", "province": "LE", "name": "CANNOLE" },
    { "code": "B617", "province": "RC", "name": "CANOLO" },
    { "code": "B618", "province": "BG", "name": "CANONICA D'ADDA" },
    { "code": "B619", "province": "BA", "name": "CANOSA DI PUGLIA (soppresso)" },
    { "code": "B619", "province": "BT", "name": "CANOSA DI PUGLIA" },
    { "code": "B620", "province": "CH", "name": "CANOSA SANNITA" },
    { "code": "B621", "province": "CN", "name": "CANOSIO" },
    { "code": "C669", "province": "RE", "name": "CANOSSA" },
    { "code": "B622", "province": "CR", "name": "CANOVA DEL MORBASCO (soppresso)" },
    { "code": "B624", "province": "AQ", "name": "CANSANO" },
    { "code": "B625", "province": "CR", "name": "CANSERO (soppresso)" },
    { "code": "B626", "province": "FI", "name": "CANTAGALLO (soppresso)" },
    { "code": "B626", "province": "PO", "name": "CANTAGALLO" },
    { "code": "B627", "province": "AQ", "name": "CANTALICE (soppresso)" },
    { "code": "B627", "province": "RI", "name": "CANTALICE" },
    { "code": "B628", "province": "TO", "name": "CANTALUPA" },
    { "code": "B631", "province": "PG", "name": "CANTALUPO IN SABINA (soppresso)" },
    { "code": "B631", "province": "RM", "name": "CANTALUPO IN SABINA (soppresso)" },
    { "code": "B631", "province": "RI", "name": "CANTALUPO IN SABINA" },
    { "code": "B629", "province": "AL", "name": "CANTALUPO LIGURE" },
    { "code": "B630", "province": "CB", "name": "CANTALUPO NEL SANNIO (soppresso)" },
    { "code": "B630", "province": "IS", "name": "CANTALUPO NEL SANNIO" },
    { "code": "B633", "province": "AL", "name": "CANTARANA (soppresso)" },
    { "code": "B633", "province": "AT", "name": "CANTARANA" },
    { "code": "B634", "province": "CO", "name": "CANTELLO (soppresso)" },
    { "code": "B634", "province": "VA", "name": "CANTELLO" },
    { "code": "B635", "province": "RM", "name": "CANTERANO" },
    { "code": "B636", "province": "PS", "name": "CANTIANO (soppresso)" },
    { "code": "B636", "province": "PU", "name": "CANTIANO" },
    { "code": "B637", "province": "TO", "name": "CANTOIRA" },
    { "code": "B638", "province": "MI", "name": "CANTONALE (soppresso)" },
    { "code": "B638", "province": "PV", "name": "CANTONALE (soppresso)" },
    { "code": "B639", "province": "CO", "name": "CANTU'" },
    { "code": "B640", "province": "TE", "name": "CANZANO" },
    { "code": "B641", "province": "CO", "name": "CANZO" },
    { "code": "B642", "province": "VE", "name": "CAORLE" },
    { "code": "B643", "province": "PC", "name": "CAORSO" },
    { "code": "B644", "province": "SA", "name": "CAPACCIO (soppresso)" },
    { "code": "B644", "province": "SA", "name": "CAPACCIO PAESTUM" },
    { "code": "B645", "province": "PA", "name": "CAPACI" },
    { "code": "B646", "province": "GR", "name": "CAPALBIO" },
    { "code": "B647", "province": "PI", "name": "CAPANNOLI" },
    { "code": "B648", "province": "LU", "name": "CAPANNORI" },
    { "code": "B649", "province": "RM", "name": "CAPENA" },
    { "code": "B650", "province": "CR", "name": "CAPERGNANICA" },
    { "code": "B651", "province": "AQ", "name": "CAPESTRANO" },
    { "code": "B652", "province": "CO", "name": "CAPIAGO (soppresso)" },
    { "code": "B653", "province": "CO", "name": "CAPIAGO INTIMIANO" },
    { "code": "B654", "province": "CO", "name": "CAPIATE (soppresso)" },
    { "code": "B655", "province": "CZ", "name": "CAPISTRANO (soppresso)" },
    { "code": "B655", "province": "VV", "name": "CAPISTRANO" },
    { "code": "B656", "province": "AQ", "name": "CAPISTRELLO" },
    { "code": "B657", "province": "SA", "name": "CAPITELLO (soppresso)" },
    { "code": "B658", "province": "AQ", "name": "CAPITIGNANO" },
    { "code": "B660", "province": "ME", "name": "CAPIZZI" },
    { "code": "B661", "province": "BG", "name": "CAPIZZONE" },
    { "code": "B664", "province": "BS", "name": "CAPO DI PONTE" },
    { "code": "B666", "province": "ME", "name": "CAPO D'ORLANDO" },
    { "code": "B663", "province": "RM", "name": "CAPODIMONTE (soppresso)" },
    { "code": "B663", "province": "VT", "name": "CAPODIMONTE" },
    { "code": "B665", "province": "PL", "name": "CAPODISTRIA (soppresso)" },
    { "code": "B667", "province": "CE", "name": "CAPODRISE" },
    { "code": "B667", "province": "NA", "name": "CAPODRISE (soppresso)" },
    { "code": "B668", "province": "CO", "name": "CAPOLAGO (soppresso)" },
    { "code": "B668", "province": "VA", "name": "CAPOLAGO (soppresso)" },
    { "code": "B669", "province": "LI", "name": "CAPOLIVERI" },
    { "code": "B670", "province": "AR", "name": "CAPOLONA" },
    { "code": "B671", "province": "MI", "name": "CAPONAGO (soppresso)" },
    { "code": "B671", "province": "MB", "name": "CAPONAGO" },
    { "code": "B672", "province": "AQ", "name": "CAPORCIANO" },
    { "code": "B673", "province": "GO", "name": "CAPORETTO (soppresso)" },
    { "code": "B673", "province": "UD", "name": "CAPORETTO (soppresso)" },
    { "code": "B674", "province": "AV", "name": "CAPOSELE" },
    { "code": "B675", "province": "CA", "name": "CAPOTERRA" },
    { "code": "B676", "province": "BS", "name": "CAPOVALLE" },
    { "code": "B677", "province": "AQ", "name": "CAPPADOCIA" },
    { "code": "B679", "province": "CR", "name": "CAPPELLA CANTONE" },
    { "code": "B680", "province": "CR", "name": "CAPPELLA DE' PICENARDI" },
    { "code": "B678", "province": "TV", "name": "CAPPELLA MAGGIORE" },
    { "code": "B681", "province": "TE", "name": "CAPPELLE (soppresso)" },
    { "code": "B681", "province": "TE", "name": "CAPPELLE SUL TAVO (soppresso)" },
    { "code": "B681", "province": "PE", "name": "CAPPELLE SUL TAVO" },
    { "code": "B682", "province": "CB", "name": "CAPRACOTTA (soppresso)" },
    { "code": "B682", "province": "IS", "name": "CAPRACOTTA" },
    { "code": "B684", "province": "FI", "name": "CAPRAIA E LIMITE" },
    { "code": "B685", "province": "GE", "name": "CAPRAIA ISOLA (soppresso)" },
    { "code": "B685", "province": "LI", "name": "CAPRAIA ISOLA" },
    { "code": "B686", "province": "CR", "name": "CAPRALBA" },
    { "code": "B688", "province": "RM", "name": "CAPRANICA (soppresso)" },
    { "code": "B688", "province": "VT", "name": "CAPRANICA" },
    { "code": "B687", "province": "RM", "name": "CAPRANICA PRENESTINA" },
    { "code": "B690", "province": "LE", "name": "CAPRARICA DI LECCE" },
    { "code": "B691", "province": "RM", "name": "CAPRAROLA (soppresso)" },
    { "code": "B691", "province": "VT", "name": "CAPRAROLA" },
    { "code": "B692", "province": "CN", "name": "CAPRAUNA" },
    { "code": "B693", "province": "AR", "name": "CAPRESE (soppresso)" },
    { "code": "B693", "province": "AR", "name": "CAPRESE MICHELANGELO" },
    { "code": "B694", "province": "NO", "name": "CAPREZZO (soppresso)" },
    { "code": "B694", "province": "VB", "name": "CAPREZZO" },
    { "code": "B696", "province": "NA", "name": "CAPRI" },
    { "code": "B695", "province": "ME", "name": "CAPRI LEONE" },
    { "code": "B697", "province": "TN", "name": "CAPRIANA" },
    { "code": "B700", "province": "BS", "name": "CAPRIANO AZZANO (soppresso)" },
    { "code": "B698", "province": "BS", "name": "CAPRIANO DEL COLLE" },
    { "code": "B701", "province": "AL", "name": "CAPRIATA D'ORBA" },
    { "code": "B702", "province": "BG", "name": "CAPRIATE D'ADDA (soppresso)" },
    { "code": "B703", "province": "BG", "name": "CAPRIATE SAN GERVASIO" },
    { "code": "B704", "province": "CE", "name": "CAPRIATI A VOLTURNO" },
    { "code": "B704", "province": "CB", "name": "CAPRIATI A VOLTURNO (soppresso)" },
    { "code": "B705", "province": "TO", "name": "CAPRIE" },
    { "code": "B706", "province": "AV", "name": "CAPRIGLIA IRPINA" },
    { "code": "B707", "province": "AL", "name": "CAPRIGLIO (soppresso)" },
    { "code": "B707", "province": "AT", "name": "CAPRIGLIO" },
    { "code": "B708", "province": "NO", "name": "CAPRILE (soppresso)" },
    { "code": "B708", "province": "VC", "name": "CAPRILE (soppresso)" },
    { "code": "B708", "province": "BI", "name": "CAPRILE" },
    { "code": "B710", "province": "BG", "name": "CAPRINO BERGAMASCO" },
    { "code": "B709", "province": "VR", "name": "CAPRINO VERONESE" },
    { "code": "B711", "province": "BS", "name": "CAPRIOLO" },
    { "code": "B713", "province": "TS", "name": "CAPRIVA (soppresso)" },
    { "code": "B712", "province": "GO", "name": "CAPRIVA (soppresso)" },
    { "code": "B712", "province": "UD", "name": "CAPRIVA (soppresso)" },
    { "code": "B712", "province": "GO", "name": "CAPRIVA DEL FRIULI" },
    { "code": "B712", "province": "UD", "name": "CAPRIVA DI CORMONS (soppresso)" },
    { "code": "B712", "province": "GO", "name": "CAPRIVA DI CORMONS (soppresso)" },
    { "code": "B713", "province": "TS", "name": "CAPRIVA NEL CARSO (soppresso)" },
    { "code": "B714", "province": "CO", "name": "CAPRONNO (soppresso)" },
    { "code": "B714", "province": "VA", "name": "CAPRONNO (soppresso)" },
    { "code": "B715", "province": "CE", "name": "CAPUA" },
    { "code": "B715", "province": "NA", "name": "CAPUA (soppresso)" },
    { "code": "B716", "province": "BA", "name": "CAPURSO" },
    { "code": "B718", "province": "RC", "name": "CARAFFA DEL BIANCO" },
    { "code": "B717", "province": "CZ", "name": "CARAFFA DI CATANZARO" },
    { "code": "B719", "province": "CN", "name": "CARAGLIO" },
    { "code": "B721", "province": "IM", "name": "CARAMAGNA LIGURE (soppresso)" },
    { "code": "B720", "province": "CN", "name": "CARAMAGNA PIEMONTE" },
    { "code": "B722", "province": "CH", "name": "CARAMANICO (soppresso)" },
    { "code": "B722", "province": "PE", "name": "CARAMANICO (soppresso)" },
    { "code": "B722", "province": "PE", "name": "CARAMANICO TERME" },
    { "code": "B723", "province": "TN", "name": "CARANO" },
    { "code": "B724", "province": "FG", "name": "CARAPELLE" },
    { "code": "B725", "province": "AQ", "name": "CARAPELLE CALVISIO" },
    { "code": "B726", "province": "GE", "name": "CARASCO" },
    { "code": "B727", "province": "AP", "name": "CARASSAI" },
    { "code": "B729", "province": "MI", "name": "CARATE BRIANZA (soppresso)" },
    { "code": "B729", "province": "MB", "name": "CARATE BRIANZA" },
    { "code": "B728", "province": "CO", "name": "CARATE LARIO (soppresso)" },
    { "code": "B730", "province": "CO", "name": "CARATE URIO" },
    { "code": "B731", "province": "BG", "name": "CARAVAGGIO" },
    { "code": "B732", "province": "CO", "name": "CARAVATE (soppresso)" },
    { "code": "B732", "province": "VA", "name": "CARAVATE" },
    { "code": "ND", "province": "TO", "name": "CARAVINO (soppresso)" },
    { "code": "ND", "province": "AO", "name": "CARAVINO (soppresso)" },
    { "code": "B733", "province": "TO", "name": "CARAVINO" },
    { "code": "B734", "province": "IM", "name": "CARAVONICA" },
    { "code": "B735", "province": "RM", "name": "CARBOGNANO (soppresso)" },
    { "code": "B735", "province": "VT", "name": "CARBOGNANO" },
    { "code": "B741", "province": "PV", "name": "CARBONARA AL TICINO" },
    { "code": "B737", "province": "BA", "name": "CARBONARA DI BARI (soppresso)" },
    { "code": "B740", "province": "CE", "name": "CARBONARA DI NOLA (soppresso)" },
    { "code": "B740", "province": "NA", "name": "CARBONARA DI NOLA" },
    { "code": "B739", "province": "MN", "name": "CARBONARA DI PO (soppresso)" },
    { "code": "B736", "province": "AL", "name": "CARBONARA SCRIVIA" },
    { "code": "B742", "province": "CO", "name": "CARBONATE" },
    { "code": "B743", "province": "PZ", "name": "CARBONE" },
    { "code": "B744", "province": "TV", "name": "CARBONERA" },
    { "code": "B745", "province": "CA", "name": "CARBONIA (soppresso)" },
    { "code": "B745", "province": "CI", "name": "CARBONIA (soppresso)" },
    { "code": "B745", "province": "SU", "name": "CARBONIA" },
    { "code": "B747", "province": "CO", "name": "CARCANO (soppresso)" },
    { "code": "B748", "province": "GE", "name": "CARCARE (soppresso)" },
    { "code": "B748", "province": "SV", "name": "CARCARE" },
    { "code": "B749", "province": "PD", "name": "CARCERI" },
    { "code": "B750", "province": "TN", "name": "CARCIATO (soppresso)" },
    { "code": "B751", "province": "BS", "name": "CARCINA (soppresso)" },
    { "code": "B752", "province": "NO", "name": "CARCOFORO (soppresso)" },
    { "code": "B752", "province": "VC", "name": "CARCOFORO" },
    { "code": "B753", "province": "CO", "name": "CARDANA (soppresso)" },
    { "code": "B753", "province": "VA", "name": "CARDANA (soppresso)" },
    { "code": "B754", "province": "MI", "name": "CARDANO AL CAMPO (soppresso)" },
    { "code": "B754", "province": "VA", "name": "CARDANO AL CAMPO" },
    { "code": "B755", "province": "CN", "name": "CARDE'" },
    { "code": "M285", "province": "NU", "name": "CARDEDU" },
    { "code": "M285", "province": "OG", "name": "CARDEDU (soppresso)" },
    { "code": "B756", "province": "RC", "name": "CARDETO" },
    { "code": "B757", "province": "NO", "name": "CARDEZZA (soppresso)" },
    { "code": "B758", "province": "CZ", "name": "CARDINALE" },
    { "code": "B759", "province": "NA", "name": "CARDITO" },
    { "code": "B760", "province": "MS", "name": "CAREGGINE (soppresso)" },
    { "code": "B760", "province": "LU", "name": "CAREGGINE" },
    { "code": "B761", "province": "CO", "name": "CARELLA CON MARIAGA (soppresso)" },
    { "code": "B762", "province": "TO", "name": "CAREMA" },
    { "code": "B762", "province": "AO", "name": "CAREMA (soppresso)" },
    { "code": "B763", "province": "BG", "name": "CARENNO (soppresso)" },
    { "code": "B763", "province": "LC", "name": "CARENNO" },
    { "code": "B764", "province": "CO", "name": "CARENO (soppresso)" },
    { "code": "B765", "province": "AL", "name": "CARENTINO" },
    { "code": "B766", "province": "RC", "name": "CARERI" },
    { "code": "B767", "province": "NO", "name": "CARESANA (soppresso)" },
    { "code": "B767", "province": "VC", "name": "CARESANA" },
    { "code": "B768", "province": "NO", "name": "CARESANABLOT (soppresso)" },
    { "code": "B768", "province": "VC", "name": "CARESANABLOT" },
    { "code": "B769", "province": "AL", "name": "CAREZZANO" },
    { "code": "B769", "province": "AL", "name": "CAREZZANO INFERIORE (soppresso)" },
    { "code": "B769", "province": "AL", "name": "CAREZZANO MAGGIORE (soppresso)" },
    { "code": "B770", "province": "AL", "name": "CAREZZANO SUPERIORE (soppresso)" },
    { "code": "B771", "province": "CZ", "name": "CARFIZZI (soppresso)" },
    { "code": "B771", "province": "KR", "name": "CARFIZZI" },
    { "code": "B772", "province": "SS", "name": "CARGEGHE" },
    { "code": "B773", "province": "NO", "name": "CARGIAGO (soppresso)" },
    { "code": "B774", "province": "CS", "name": "CARIATI" },
    { "code": "B775", "province": "RC", "name": "CARIDA' (soppresso)" },
    { "code": "B776", "province": "AV", "name": "CARIFE" },
    { "code": "B777", "province": "TO", "name": "CARIGNANO" },
    { "code": "B778", "province": "CO", "name": "CARIMATE" },
    { "code": "B779", "province": "CE", "name": "CARINARO" },
    { "code": "B779", "province": "NA", "name": "CARINARO (soppresso)" },
    { "code": "B780", "province": "PA", "name": "CARINI" },
    { "code": "B781", "province": "CE", "name": "CARINOLA" },
    { "code": "B781", "province": "NA", "name": "CARINOLA (soppresso)" },
    { "code": "B782", "province": "NO", "name": "CARISIO (soppresso)" },
    { "code": "B782", "province": "VC", "name": "CARISIO" },
    { "code": "B783", "province": "TN", "name": "CARISOLO" },
    { "code": "B784", "province": "FG", "name": "CARLANTINO" },
    { "code": "B785", "province": "CO", "name": "CARLAZZO" },
    { "code": "B786", "province": "CO", "name": "CARLAZZO VALSOLDA (soppresso)" },
    { "code": "B787", "province": "SR", "name": "CARLENTINI" },
    { "code": "B788", "province": "UD", "name": "CARLINO" },
    { "code": "B789", "province": "CA", "name": "CARLOFORTE (soppresso)" },
    { "code": "B789", "province": "CI", "name": "CARLOFORTE (soppresso)" },
    { "code": "B789", "province": "SU", "name": "CARLOFORTE" },
    { "code": "B790", "province": "CZ", "name": "CARLOPOLI" },
    { "code": "B791", "province": "TO", "name": "CARMAGNOLA" },
    { "code": "B792", "province": "LE", "name": "CARMIANO" },
    { "code": "B794", "province": "FI", "name": "CARMIGNANO (soppresso)" },
    { "code": "B794", "province": "PO", "name": "CARMIGNANO" },
    { "code": "B795", "province": "PD", "name": "CARMIGNANO DI BRENTA" },
    { "code": "B796", "province": "CO", "name": "CARNAGO (soppresso)" },
    { "code": "B796", "province": "VA", "name": "CARNAGO" },
    { "code": "B798", "province": "MI", "name": "CARNATE (soppresso)" },
    { "code": "B798", "province": "MB", "name": "CARNATE" },
    { "code": "B799", "province": "TN", "name": "CARNEDO (soppresso)" },
    { "code": "B800", "province": "BG", "name": "CAROBBIO (soppresso)" },
    { "code": "B801", "province": "BG", "name": "CAROBBIO DEGLI ANGELI" },
    { "code": "B802", "province": "CS", "name": "CAROLEI" },
    { "code": "B803", "province": "BG", "name": "CARONA" },
    { "code": "B804", "province": "ME", "name": "CARONIA" },
    { "code": "B806", "province": "CO", "name": "CARONNO CORBELLARO (soppresso)" },
    { "code": "B806", "province": "VA", "name": "CARONNO CORBELLARO (soppresso)" },
    { "code": "B807", "province": "CO", "name": "CARONNO GHIRINGHELLO (soppresso)" },
    { "code": "B807", "province": "VA", "name": "CARONNO GHIRINGHELLO (soppresso)" },
    { "code": "B805", "province": "MI", "name": "CARONNO MILANESE (soppresso)" },
    { "code": "B805", "province": "VA", "name": "CARONNO MILANESE (soppresso)" },
    { "code": "B805", "province": "VA", "name": "CARONNO PERTUSELLA" },
    { "code": "B807", "province": "VA", "name": "CARONNO VARESINO" },
    { "code": "B808", "province": "LE", "name": "CAROSINO (soppresso)" },
    { "code": "B808", "province": "TA", "name": "CAROSINO" },
    { "code": "B809", "province": "LE", "name": "CAROVIGNO (soppresso)" },
    { "code": "B809", "province": "BR", "name": "CAROVIGNO" },
    { "code": "B810", "province": "CB", "name": "CAROVILLI (soppresso)" },
    { "code": "B810", "province": "IS", "name": "CAROVILLI" },
    { "code": "B811", "province": "CR", "name": "CARPANETA CON DOSIMO (soppresso)" },
    { "code": "B812", "province": "PC", "name": "CARPANETO (soppresso)" },
    { "code": "B812", "province": "PC", "name": "CARPANETO PIACENTINO" },
    { "code": "B813", "province": "CS", "name": "CARPANZANO" },
    { "code": "B814", "province": "IM", "name": "CARPASIO (soppresso)" },
    { "code": "B816", "province": "PS", "name": "CARPEGNA (soppresso)" },
    { "code": "B816", "province": "PU", "name": "CARPEGNA" },
    { "code": "B817", "province": "BS", "name": "CARPENEDOLO" },
    { "code": "B818", "province": "AL", "name": "CARPENETO" },
    { "code": "B819", "province": "MO", "name": "CARPI" },
    { "code": "B820", "province": "MI", "name": "CARPIANO" },
    { "code": "B821", "province": "PV", "name": "CARPIGNAGO (soppresso)" },
    { "code": "B822", "province": "LE", "name": "CARPIGNANO SALENTINO" },
    { "code": "B823", "province": "NO", "name": "CARPIGNANO SESIA" },
    { "code": "B825", "province": "RE", "name": "CARPINETI" },
    { "code": "B827", "province": "TE", "name": "CARPINETO DELLA NORA (soppresso)" },
    { "code": "B827", "province": "PE", "name": "CARPINETO DELLA NORA" },
    { "code": "B828", "province": "RM", "name": "CARPINETO ROMANO" },
    { "code": "B826", "province": "CH", "name": "CARPINETO SINELLO" },
    { "code": "B829", "province": "FG", "name": "CARPINO" },
    { "code": "B830", "province": "CB", "name": "CARPINONE (soppresso)" },
    { "code": "B830", "province": "IS", "name": "CARPINONE" },
    { "code": "B831", "province": "NO", "name": "CARPUGNINO (soppresso)" },
    { "code": "B832", "province": "MS", "name": "CARRARA" },
    { "code": "B833", "province": "PD", "name": "CARRARA SAN GIORGIO (soppresso)" },
    { "code": "B834", "province": "PD", "name": "CARRARA SANTO STEFANO (soppresso)" },
    { "code": "B835", "province": "VI", "name": "CARRE'" },
    { "code": "B836", "province": "AL", "name": "CARREGA LIGURE" },
    { "code": "B838", "province": "GE", "name": "CARRO (soppresso)" },
    { "code": "B838", "province": "SP", "name": "CARRO" },
    { "code": "B839", "province": "GE", "name": "CARRODANO (soppresso)" },
    { "code": "B839", "province": "SP", "name": "CARRODANO" },
    { "code": "B840", "province": "AL", "name": "CARROSIO" },
    { "code": "B841", "province": "CN", "name": "CARRU'" },
    { "code": "B842", "province": "AQ", "name": "CARSOLI" },
    { "code": "B843", "province": "IM", "name": "CARTARI E CALDERARA (soppresso)" },
    { "code": "B844", "province": "VI", "name": "CARTIGLIANO" },
    { "code": "B845", "province": "CN", "name": "CARTIGNANO" },
    { "code": "B846", "province": "PS", "name": "CARTOCETO (soppresso)" },
    { "code": "B846", "province": "PU", "name": "CARTOCETO" },
    { "code": "B847", "province": "AL", "name": "CARTOSIO" },
    { "code": "B848", "province": "PD", "name": "CARTURA" },
    { "code": "B850", "province": "MI", "name": "CARUGATE" },
    { "code": "B851", "province": "CO", "name": "CARUGO" },
    { "code": "B852", "province": "CO", "name": "CARUGO AROSIO (soppresso)" },
    { "code": "B852", "province": "CO", "name": "CARUGO CON AROSIO (soppresso)" },
    { "code": "B853", "province": "CH", "name": "CARUNCHIO" },
    { "code": "B854", "province": "BG", "name": "CARVICO" },
    { "code": "B855", "province": "BS", "name": "CARZAGO (soppresso)" },
    { "code": "B855", "province": "BS", "name": "CARZAGO DELLA RIVIERA (soppresso)" },
    { "code": "B856", "province": "TN", "name": "CARZANO" },
    { "code": "B857", "province": "CZ", "name": "CASABONA (soppresso)" },
    { "code": "B857", "province": "KR", "name": "CASABONA" },
    { "code": "B858", "province": "CB", "name": "CASACALENDA" },
    { "code": "B859", "province": "CH", "name": "CASACANDITELLA" },
    { "code": "B860", "province": "CE", "name": "CASAGIOVE" },
    { "code": "B860", "province": "NA", "name": "CASAGIOVE (soppresso)" },
    { "code": "B870", "province": "AL", "name": "CASAL CERMELLI" },
    { "code": "B872", "province": "CE", "name": "CASAL DI PRINCIPE" },
    { "code": "B872", "province": "NA", "name": "CASAL DI PRINCIPE (soppresso)" },
    { "code": "B912", "province": "PD", "name": "CASAL SERUGO (soppresso)" },
    { "code": "B895", "province": "SA", "name": "CASAL VELINO" },
    { "code": "B861", "province": "CH", "name": "CASALANGUIDA" },
    { "code": "B862", "province": "CE", "name": "CASALATTICO (soppresso)" },
    { "code": "B862", "province": "FR", "name": "CASALATTICO" },
    { "code": "B863", "province": "NA", "name": "CASALBA (soppresso)" },
    { "code": "B863", "province": "CE", "name": "CASALBA (soppresso)" },
    { "code": "B864", "province": "NO", "name": "CASALBELTRAME" },
    { "code": "B865", "province": "CH", "name": "CASALBORDINO" },
    { "code": "B866", "province": "AV", "name": "CASALBORE" },
    { "code": "B867", "province": "TO", "name": "CASALBORGONE" },
    { "code": "B868", "province": "SA", "name": "CASALBUONO" },
    { "code": "B869", "province": "CR", "name": "CASALBUTTANO ED UNITI" },
    { "code": "B871", "province": "CB", "name": "CASALCIPRANO" },
    { "code": "B873", "province": "BN", "name": "CASALDUNI" },
    { "code": "B876", "province": "NO", "name": "CASALE CORTE CERRO (soppresso)" },
    { "code": "B876", "province": "VB", "name": "CASALE CORTE CERRO" },
    { "code": "B874", "province": "CR", "name": "CASALE CREMASCO (soppresso)" },
    { "code": "B881", "province": "CR", "name": "CASALE CREMASCO-VIDOLASCO" },
    { "code": "B877", "province": "PD", "name": "CASALE DI SCODOSIA" },
    { "code": "B875", "province": "MI", "name": "CASALE LITTA (soppresso)" },
    { "code": "B875", "province": "VA", "name": "CASALE LITTA" },
    { "code": "B878", "province": "PI", "name": "CASALE MARITTIMO" },
    { "code": "B885", "province": "AL", "name": "CASALE MONFERRATO" },
    { "code": "B879", "province": "TV", "name": "CASALE SUL SILE" },
    { "code": "B880", "province": "BO", "name": "CASALECCHIO DI RENO" },
    { "code": "B882", "province": "AL", "name": "CASALEGGIO BOIRO" },
    { "code": "B884", "province": "NO", "name": "CASALEGGIO CASTELLAZZO (soppresso)" },
    { "code": "B883", "province": "NO", "name": "CASALEGGIO NOVARA" },
    { "code": "B886", "province": "VR", "name": "CASALEONE" },
    { "code": "B889", "province": "CR", "name": "CASALETTO CEREDANO" },
    { "code": "B890", "province": "CR", "name": "CASALETTO DI SOPRA" },
    { "code": "B887", "province": "MI", "name": "CASALETTO LODIGIANO (soppresso)" },
    { "code": "B887", "province": "LO", "name": "CASALETTO LODIGIANO" },
    { "code": "B888", "province": "SA", "name": "CASALETTO SPARTANO" },
    { "code": "B891", "province": "CR", "name": "CASALETTO VAPRIO" },
    { "code": "B892", "province": "BO", "name": "CASALFIUMANESE" },
    { "code": "B893", "province": "RE", "name": "CASALGRANDE" },
    { "code": "B894", "province": "CN", "name": "CASALGRASSO" },
    { "code": "M385", "province": "CS", "name": "CASALI DEL MANCO" },
    { "code": "B896", "province": "CH", "name": "CASALINCONTRADA" },
    { "code": "B897", "province": "NO", "name": "CASALINO" },
    { "code": "B898", "province": "CR", "name": "CASALMAGGIORE" },
    { "code": "B899", "province": "MI", "name": "CASALMAIOCCO (soppresso)" },
    { "code": "B899", "province": "LO", "name": "CASALMAIOCCO" },
    { "code": "B900", "province": "CR", "name": "CASALMORANO" },
    { "code": "B901", "province": "MN", "name": "CASALMORO" },
    { "code": "B902", "province": "AL", "name": "CASALNOCETO" },
    { "code": "B905", "province": "NA", "name": "CASALNUOVO DI NAPOLI" },
    { "code": "B906", "province": "PZ", "name": "CASALNUOVO LUCANO (soppresso)" },
    { "code": "B904", "province": "FG", "name": "CASALNUOVO MONTEROTARO" },
    { "code": "B907", "province": "MN", "name": "CASALOLDO" },
    { "code": "B908", "province": "CR", "name": "CASALORZO GEROLDI (soppresso)" },
    { "code": "B909", "province": "MN", "name": "CASALPOGLIO (soppresso)" },
    { "code": "B910", "province": "MI", "name": "CASALPUSTERLENGO (soppresso)" },
    { "code": "B910", "province": "LO", "name": "CASALPUSTERLENGO" },
    { "code": "B911", "province": "MN", "name": "CASALROMANO" },
    { "code": "B912", "province": "PD", "name": "CASALSERUGO" },
    { "code": "B916", "province": "CE", "name": "CASALUCE" },
    { "code": "B916", "province": "NA", "name": "CASALUCE (soppresso)" },
    { "code": "B917", "province": "FG", "name": "CASALVECCHIO DI PUGLIA" },
    { "code": "B918", "province": "ME", "name": "CASALVECCHIO SICULO" },
    { "code": "B919", "province": "CE", "name": "CASALVIERI (soppresso)" },
    { "code": "B919", "province": "FR", "name": "CASALVIERI" },
    { "code": "B920", "province": "NO", "name": "CASALVOLONE" },
    { "code": "B921", "province": "CO", "name": "CASALZUIGNO (soppresso)" },
    { "code": "B921", "province": "VA", "name": "CASALZUIGNO" },
    { "code": "B922", "province": "CE", "name": "CASAMARCIANO (soppresso)" },
    { "code": "B922", "province": "NA", "name": "CASAMARCIANO" },
    { "code": "B923", "province": "BA", "name": "CASAMASSIMA" },
    { "code": "B924", "province": "NA", "name": "CASAMICCIOLA (soppresso)" },
    { "code": "B924", "province": "NA", "name": "CASAMICCIOLA TERME" },
    { "code": "B925", "province": "NA", "name": "CASANDRINO" },
    { "code": "B926", "province": "CO", "name": "CASANOVA DI UGGIATE (soppresso)" },
    { "code": "B928", "province": "NO", "name": "CASANOVA ELVO (soppresso)" },
    { "code": "B928", "province": "VC", "name": "CASANOVA ELVO" },
    { "code": "B926", "province": "CO", "name": "CASANOVA LANZA (soppresso)" },
    { "code": "B927", "province": "GE", "name": "CASANOVA LERRONE (soppresso)" },
    { "code": "B927", "province": "SV", "name": "CASANOVA LERRONE" },
    { "code": "B929", "province": "PV", "name": "CASANOVA LONATI" },
    { "code": "B932", "province": "RM", "name": "CASAPE" },
    { "code": "M260", "province": "CE", "name": "CASAPESENNA" },
    { "code": "B933", "province": "NO", "name": "CASAPINTA (soppresso)" },
    { "code": "B933", "province": "VC", "name": "CASAPINTA (soppresso)" },
    { "code": "B933", "province": "BI", "name": "CASAPINTA" },
    { "code": "B934", "province": "PG", "name": "CASAPROTA (soppresso)" },
    { "code": "B934", "province": "RM", "name": "CASAPROTA (soppresso)" },
    { "code": "B934", "province": "RI", "name": "CASAPROTA" },
    { "code": "B935", "province": "CE", "name": "CASAPULLA" },
    { "code": "B935", "province": "NA", "name": "CASAPULLA (soppresso)" },
    { "code": "B936", "province": "LE", "name": "CASARANO" },
    { "code": "B937", "province": "CO", "name": "CASARGO (soppresso)" },
    { "code": "B937", "province": "LC", "name": "CASARGO" },
    { "code": "B938", "province": "MI", "name": "CASARILE" },
    { "code": "B940", "province": "UD", "name": "CASARSA DELLA DELIZIA (soppresso)" },
    { "code": "B940", "province": "PN", "name": "CASARSA DELLA DELIZIA" },
    { "code": "B939", "province": "GE", "name": "CASARZA LIGURE" },
    { "code": "B941", "province": "AL", "name": "CASASCO" },
    { "code": "B942", "province": "CO", "name": "CASASCO D'INTELVI (soppresso)" },
    { "code": "B943", "province": "CO", "name": "CASATENOVO (soppresso)" },
    { "code": "B943", "province": "LC", "name": "CASATENOVO" },
    { "code": "B945", "province": "PV", "name": "CASATISMA" },
    { "code": "B946", "province": "NA", "name": "CASAVATORE" },
    { "code": "B947", "province": "BG", "name": "CASAZZA" },
    { "code": "B948", "province": "PG", "name": "CASCIA" },
    { "code": "B949", "province": "CO", "name": "CASCIAGO (soppresso)" },
    { "code": "B949", "province": "VA", "name": "CASCIAGO" },
    { "code": "A559", "province": "PI", "name": "CASCIANA TERME (soppresso)" },
    { "code": "M327", "province": "PI", "name": "CASCIANA TERME LARI" },
    { "code": "B950", "province": "PI", "name": "CASCINA" },
    { "code": "B952", "province": "NO", "name": "CASCINE SAN GIACOMO (soppresso)" },
    { "code": "B952", "province": "VC", "name": "CASCINE SAN GIACOMO (soppresso)" },
    { "code": "B953", "province": "TO", "name": "CASCINETTE D'IVREA" },
    { "code": "B953", "province": "AO", "name": "CASCINETTE D'IVREA (soppresso)" },
    { "code": "B954", "province": "PV", "name": "CASEI GEROLA" },
    { "code": "B955", "province": "TO", "name": "CASELETTE" },
    { "code": "B956", "province": "GE", "name": "CASELLA" },
    { "code": "B959", "province": "SA", "name": "CASELLE IN PITTARI" },
    { "code": "B961", "province": "MI", "name": "CASELLE LANDI (soppresso)" },
    { "code": "B961", "province": "LO", "name": "CASELLE LANDI" },
    { "code": "B958", "province": "MI", "name": "CASELLE LURANI (soppresso)" },
    { "code": "B958", "province": "LO", "name": "CASELLE LURANI" },
    { "code": "B960", "province": "TO", "name": "CASELLE TORINESE" },
    { "code": "B962", "province": "FI", "name": "CASELLINA E TORRI (soppresso)" },
    { "code": "B963", "province": "CE", "name": "CASERTA" },
    { "code": "B963", "province": "NA", "name": "CASERTA (soppresso)" },
    { "code": "B964", "province": "TN", "name": "CASEZ (soppresso)" },
    { "code": "B965", "province": "TV", "name": "CASIER" },
    { "code": "B966", "province": "RC", "name": "CASIGNANA" },
    { "code": "B967", "province": "RE", "name": "CASINA" },
    { "code": "B968", "province": "CZ", "name": "CASINO (soppresso)" },
    { "code": "B970", "province": "CO", "name": "CASIRAGO (soppresso)" },
    { "code": "B971", "province": "BG", "name": "CASIRATE D'ADDA" },
    { "code": "B973", "province": "CO", "name": "CASLETTO (soppresso)" },
    { "code": "B975", "province": "CO", "name": "CASLINO AL PIANO (soppresso)" },
    { "code": "B974", "province": "CO", "name": "CASLINO D'ERBA" },
    { "code": "B976", "province": "CO", "name": "CASNATE (soppresso)" },
    { "code": "B977", "province": "CO", "name": "CASNATE CON BERNATE" },
    { "code": "B978", "province": "BG", "name": "CASNIGO" },
    { "code": "B980", "province": "NA", "name": "CASOLA DI NAPOLI" },
    { "code": "B979", "province": "MS", "name": "CASOLA IN LUNIGIANA" },
    { "code": "B982", "province": "RA", "name": "CASOLA VALSENIO" },
    { "code": "B983", "province": "CS", "name": "CASOLE BRUZIO (soppresso)" },
    { "code": "B984", "province": "SI", "name": "CASOLE D'ELSA" },
    { "code": "B985", "province": "CH", "name": "CASOLI" },
    { "code": "B988", "province": "PV", "name": "CASORATE PRIMO" },
    { "code": "B987", "province": "MI", "name": "CASORATE SEMPIONE (soppresso)" },
    { "code": "B987", "province": "VA", "name": "CASORATE SEMPIONE" },
    { "code": "B989", "province": "MI", "name": "CASOREZZO" },
    { "code": "B990", "province": "NA", "name": "CASORIA" },
    { "code": "B991", "province": "AL", "name": "CASORZO (soppresso)" },
    { "code": "B991", "province": "AT", "name": "CASORZO" },
    { "code": "B992", "province": "TN", "name": "CASOTTO (soppresso)" },
    { "code": "B992", "province": "VI", "name": "CASOTTO (soppresso)" },
    { "code": "A472", "province": "RI", "name": "CASPERIA" },
    { "code": "B993", "province": "SO", "name": "CASPOGGIO" },
    { "code": "B994", "province": "UD", "name": "CASSACCO" },
    { "code": "B995", "province": "CO", "name": "CASSAGO (soppresso)" },
    { "code": "B996", "province": "CO", "name": "CASSAGO BRIANZA (soppresso)" },
    { "code": "B996", "province": "LC", "name": "CASSAGO BRIANZA" },
    { "code": "C001", "province": "CO", "name": "CASSANO ALBESE (soppresso)" },
    { "code": "C002", "province": "CS", "name": "CASSANO ALL'IONIO" },
    { "code": "C003", "province": "MI", "name": "CASSANO D'ADDA" },
    { "code": "B998", "province": "BA", "name": "CASSANO DELLE MURGE" },
    { "code": "B997", "province": "AV", "name": "CASSANO IRPINO" },
    { "code": "C004", "province": "MI", "name": "CASSANO MAGNAGO (soppresso)" },
    { "code": "C004", "province": "VA", "name": "CASSANO MAGNAGO" },
    { "code": "C005", "province": "AL", "name": "CASSANO SPINOLA (soppresso)" },
    { "code": "M388", "province": "AL", "name": "CASSANO SPINOLA" },
    { "code": "B999", "province": "CO", "name": "CASSANO VALCUVIA (soppresso)" },
    { "code": "B999", "province": "VA", "name": "CASSANO VALCUVIA" },
    { "code": "C006", "province": "SR", "name": "CASSARO" },
    { "code": "C007", "province": "BG", "name": "CASSIGLIO" },
    { "code": "C014", "province": "MI", "name": "CASSINA DE' PECCHI" },
    { "code": "C016", "province": "CO", "name": "CASSINA MARIAGA (soppresso)" },
    { "code": "C020", "province": "CO", "name": "CASSINA RIZZARDI" },
    { "code": "C024", "province": "CO", "name": "CASSINA VALSASSINA (soppresso)" },
    { "code": "C024", "province": "LC", "name": "CASSINA VALSASSINA" },
    { "code": "C022", "province": "AL", "name": "CASSINASCO (soppresso)" },
    { "code": "C022", "province": "AT", "name": "CASSINASCO" },
    { "code": "C027", "province": "AL", "name": "CASSINE" },
    { "code": "C029", "province": "CR", "name": "CASSINE GANDINE (soppresso)" },
    { "code": "C030", "province": "AL", "name": "CASSINELLE" },
    { "code": "C033", "province": "MI", "name": "CASSINETTA DI LUGAGNANO" },
    { "code": "C034", "province": "CE", "name": "CASSINO (soppresso)" },
    { "code": "C034", "province": "FR", "name": "CASSINO" },
    { "code": "C037", "province": "VI", "name": "CASSOLA" },
    { "code": "C038", "province": "PV", "name": "CASSOLNOVO" },
    { "code": "C041", "province": "VR", "name": "CASTAGNARO" },
    { "code": "C043", "province": "TN", "name": "CASTAGNE' (soppresso)" },
    { "code": "C044", "province": "PI", "name": "CASTAGNETO (soppresso)" },
    { "code": "C045", "province": "TO", "name": "CASTAGNETO (soppresso)" },
    { "code": "C044", "province": "PI", "name": "CASTAGNETO CARDUCCI (soppresso)" },
    { "code": "C044", "province": "LI", "name": "CASTAGNETO CARDUCCI" },
    { "code": "C044", "province": "PI", "name": "CASTAGNETO MARITTIMO (soppresso)" },
    { "code": "C045", "province": "TO", "name": "CASTAGNETO PO" },
    { "code": "C046", "province": "CN", "name": "CASTAGNITO" },
    { "code": "C049", "province": "AL", "name": "CASTAGNOLE DELLE LANZE (soppresso)" },
    { "code": "C049", "province": "AT", "name": "CASTAGNOLE DELLE LANZE" },
    { "code": "C047", "province": "AL", "name": "CASTAGNOLE MONFERRATO (soppresso)" },
    { "code": "C047", "province": "AT", "name": "CASTAGNOLE MONFERRATO" },
    { "code": "C048", "province": "TO", "name": "CASTAGNOLE PIEMONTE" },
    { "code": "C050", "province": "PV", "name": "CASTANA" },
    { "code": "C052", "province": "MI", "name": "CASTANO PRIMO" },
    { "code": "C053", "province": "PV", "name": "CASTEGGIO" },
    { "code": "C055", "province": "BS", "name": "CASTEGNATO" },
    { "code": "C056", "province": "VI", "name": "CASTEGNERO" },
    { "code": "C058", "province": "AV", "name": "CASTEL BARONIA" },
    { "code": "C064", "province": "AL", "name": "CASTEL BOGLIONE (soppresso)" },
    { "code": "C064", "province": "AT", "name": "CASTEL BOGLIONE" },
    { "code": "C065", "province": "RA", "name": "CASTEL BOLOGNESE" },
    { "code": "B494", "province": "CE", "name": "CASTEL CAMPAGNANO" },
    { "code": "B494", "province": "BN", "name": "CASTEL CAMPAGNANO (soppresso)" },
    { "code": "C040", "province": "TE", "name": "CASTEL CASTAGNA" },
    { "code": "C068", "province": "RM", "name": "CASTEL CELLESI (soppresso)" },
    { "code": "C068", "province": "VT", "name": "CASTEL CELLESI (soppresso)" },
    { "code": "C071", "province": "AN", "name": "CASTEL COLONNA (soppresso)" },
    { "code": "C183", "province": "TN", "name": "CASTEL CONDINO" },
    { "code": "C075", "province": "BO", "name": "CASTEL D'AIANO" },
    { "code": "C076", "province": "MN", "name": "CASTEL D'ARIO" },
    { "code": "C078", "province": "VR", "name": "CASTEL D'AZZANO" },
    { "code": "C087", "province": "AL", "name": "CASTEL DE' RATTI (soppresso)" },
    { "code": "C082", "province": "CB", "name": "CASTEL DEL GIUDICE (soppresso)" },
    { "code": "C082", "province": "IS", "name": "CASTEL DEL GIUDICE" },
    { "code": "C083", "province": "AQ", "name": "CASTEL DEL MONTE" },
    { "code": "C085", "province": "GR", "name": "CASTEL DEL PIANO" },
    { "code": "C086", "province": "BO", "name": "CASTEL DEL RIO" },
    { "code": "B969", "province": "BO", "name": "CASTEL DI CASIO" },
    { "code": "C090", "province": "AQ", "name": "CASTEL DI IERI" },
    { "code": "C091", "province": "CT", "name": "CASTEL DI IUDICA" },
    { "code": "C093", "province": "AP", "name": "CASTEL DI LAMA" },
    { "code": "C094", "province": "ME", "name": "CASTEL DI LUCIO" },
    { "code": "C096", "province": "AQ", "name": "CASTEL DI SANGRO" },
    { "code": "C097", "province": "CE", "name": "CASTEL DI SASSO" },
    { "code": "C097", "province": "NA", "name": "CASTEL DI SASSO (soppresso)" },
    { "code": "C098", "province": "PG", "name": "CASTEL DI TORA (soppresso)" },
    { "code": "C098", "province": "RM", "name": "CASTEL DI TORA (soppresso)" },
    { "code": "C098", "province": "RI", "name": "CASTEL DI TORA" },
    { "code": "C099", "province": "GO", "name": "CASTEL DOBRA (soppresso)" },
    { "code": "C102", "province": "AR", "name": "CASTEL FOCOGNANO" },
    { "code": "C114", "province": "CH", "name": "CASTEL FRENTANO" },
    { "code": "C115", "province": "CR", "name": "CASTEL GABBIANO" },
    { "code": "C116", "province": "RM", "name": "CASTEL GANDOLFO" },
    { "code": "C117", "province": "PG", "name": "CASTEL GIORGIO (soppresso)" },
    { "code": "C117", "province": "TR", "name": "CASTEL GIORGIO" },
    { "code": "C118", "province": "MN", "name": "CASTEL GOFFREDO" },
    { "code": "C121", "province": "BO", "name": "CASTEL GUELFO DI BOLOGNA" },
    { "code": "C124", "province": "PL", "name": "CASTEL IABLANIZZA (soppresso)" },
    { "code": "C124", "province": "FU", "name": "CASTEL IABLANIZZA (soppresso)" },
    { "code": "M354", "province": "TN", "name": "CASTEL IVANO" },
    { "code": "C131", "province": "PV", "name": "CASTEL LAMBRO (soppresso)" },
    { "code": "C203", "province": "RM", "name": "CASTEL MADAMA" },
    { "code": "C204", "province": "BO", "name": "CASTEL MAGGIORE" },
    { "code": "C208", "province": "BS", "name": "CASTEL MELLA" },
    { "code": "C211", "province": "CE", "name": "CASTEL MORRONE" },
    { "code": "C211", "province": "NA", "name": "CASTEL MORRONE (soppresso)" },
    { "code": "C252", "province": "PG", "name": "CASTEL RITALDI" },
    { "code": "C252", "province": "PG", "name": "CASTEL RITALDI E SAN GIOVANNI (soppresso)" },
    { "code": "C253", "province": "AL", "name": "CASTEL ROCCHERO (soppresso)" },
    { "code": "C253", "province": "AT", "name": "CASTEL ROCCHERO" },
    { "code": "C255", "province": "BG", "name": "CASTEL ROZZONE" },
    { "code": "C259", "province": "SA", "name": "CASTEL SAN GIORGIO" },
    { "code": "C261", "province": "PC", "name": "CASTEL SAN GIOVANNI" },
    { "code": "C262", "province": "SA", "name": "CASTEL SAN LORENZO" },
    { "code": "C263", "province": "AR", "name": "CASTEL SAN NICCOLO'" },
    { "code": "C265", "province": "BO", "name": "CASTEL SAN PIETRO DELL'EMILIA (soppresso)" },
    { "code": "C264", "province": "AL", "name": "CASTEL SAN PIETRO MONFERRATO (soppresso)" },
    { "code": "C266", "province": "RM", "name": "CASTEL SAN PIETRO ROMANO" },
    { "code": "C265", "province": "BO", "name": "CASTEL SAN PIETRO TERME" },
    { "code": "C270", "province": "CB", "name": "CASTEL SAN VINCENZO (soppresso)" },
    { "code": "C270", "province": "IS", "name": "CASTEL SAN VINCENZO" },
    { "code": "C268", "province": "AQ", "name": "CASTEL SANT'ANGELO (soppresso)" },
    { "code": "C268", "province": "RI", "name": "CASTEL SANT'ANGELO" },
    { "code": "C269", "province": "RM", "name": "CASTEL SANT'ELIA (soppresso)" },
    { "code": "C269", "province": "VT", "name": "CASTEL SANT'ELIA" },
    { "code": "C282", "province": "AO", "name": "CASTEL VERRES (soppresso)" },
    { "code": "C200", "province": "CB", "name": "CASTEL VERRINO (soppresso)" },
    { "code": "C289", "province": "PG", "name": "CASTEL VISCARDO (soppresso)" },
    { "code": "C289", "province": "TR", "name": "CASTEL VISCARDO" },
    { "code": "C110", "province": "IM", "name": "CASTEL VITTORIO" },
    { "code": "C291", "province": "CE", "name": "CASTEL VOLTURNO" },
    { "code": "C291", "province": "NA", "name": "CASTEL VOLTURNO (soppresso)" },
    { "code": "C057", "province": "PD", "name": "CASTELBALDO" },
    { "code": "C059", "province": "MN", "name": "CASTELBELFORTE" },
    { "code": "C060", "province": "AN", "name": "CASTELBELLINO" },
    { "code": "C061", "province": "TN", "name": "CASTELBELLO (soppresso)" },
    { "code": "C061", "province": "BZ", "name": "CASTELBELLO (soppresso)" },
    { "code": "C062", "province": "BZ", "name": "CASTELBELLO-CIARDES" },
    { "code": "C063", "province": "GE", "name": "CASTELBIANCO (soppresso)" },
    { "code": "C063", "province": "SV", "name": "CASTELBIANCO" },
    { "code": "C066", "province": "CB", "name": "CASTELBOTTACCIO" },
    { "code": "C067", "province": "PA", "name": "CASTELBUONO" },
    { "code": "C069", "province": "SA", "name": "CASTELCIVITA" },
    { "code": "C072", "province": "BS", "name": "CASTELCOVATI" },
    { "code": "C073", "province": "TV", "name": "CASTELCUCCO" },
    { "code": "C074", "province": "PA", "name": "CASTELDACCIA" },
    { "code": "C077", "province": "TN", "name": "CASTELDARNE (soppresso)" },
    { "code": "C077", "province": "BZ", "name": "CASTELDARNE (soppresso)" },
    { "code": "C080", "province": "PS", "name": "CASTELDELCI (soppresso)" },
    { "code": "C080", "province": "PU", "name": "CASTELDELCI (soppresso)" },
    { "code": "C080", "province": "RN", "name": "CASTELDELCI" },
    { "code": "C081", "province": "CN", "name": "CASTELDELFINO" },
    { "code": "C089", "province": "CR", "name": "CASTELDIDONE" },
    { "code": "C100", "province": "AN", "name": "CASTELFIDARDO" },
    { "code": "C101", "province": "FI", "name": "CASTELFIORENTINO" },
    { "code": "C103", "province": "TN", "name": "CASTELFONDO" },
    { "code": "C104", "province": "CE", "name": "CASTELFORTE (soppresso)" },
    { "code": "C104", "province": "RM", "name": "CASTELFORTE (soppresso)" },
    { "code": "C104", "province": "LT", "name": "CASTELFORTE" },
    { "code": "C105", "province": "AV", "name": "CASTELFRANCI" },
    { "code": "C107", "province": "BO", "name": "CASTELFRANCO DELL'EMILIA (soppresso)" },
    { "code": "C107", "province": "MO", "name": "CASTELFRANCO DELL'EMILIA (soppresso)" },
    { "code": "C112", "province": "AR", "name": "CASTELFRANCO DI SOPRA (soppresso)" },
    { "code": "C113", "province": "FI", "name": "CASTELFRANCO DI SOTTO (soppresso)" },
    { "code": "C113", "province": "PI", "name": "CASTELFRANCO DI SOTTO" },
    { "code": "C107", "province": "MO", "name": "CASTELFRANCO EMILIA" },
    { "code": "C106", "province": "BN", "name": "CASTELFRANCO IN MISCANO" },
    { "code": "M322", "province": "AR", "name": "CASTELFRANCO PIANDISCO'" },
    { "code": "C111", "province": "TV", "name": "CASTELFRANCO VENETO" },
    { "code": "M393", "province": "LO", "name": "CASTELGERUNDO" },
    { "code": "C119", "province": "VI", "name": "CASTELGOMBERTO" },
    { "code": "C120", "province": "PZ", "name": "CASTELGRANDE" },
    { "code": "C122", "province": "RO", "name": "CASTELGUGLIELMO" },
    { "code": "C123", "province": "CH", "name": "CASTELGUIDONE" },
    { "code": "C125", "province": "SA", "name": "CASTELLABATE" },
    { "code": "C126", "province": "AQ", "name": "CASTELLAFIUME" },
    { "code": "C127", "province": "AL", "name": "CASTELL'ALFERO (soppresso)" },
    { "code": "C127", "province": "AT", "name": "CASTELL'ALFERO" },
    { "code": "C128", "province": "TE", "name": "CASTELLALTO" },
    { "code": "C132", "province": "TE", "name": "CASTELLAMMARE (soppresso)" },
    { "code": "C132", "province": "TE", "name": "CASTELLAMMARE ADRIATICO (soppresso)" },
    { "code": "C132", "province": "PE", "name": "CASTELLAMMARE ADRIATICO (soppresso)" },
    { "code": "C130", "province": "TP", "name": "CASTELLAMMARE DEL GOLFO" },
    { "code": "C129", "province": "NA", "name": "CASTELLAMMARE DI STABIA" },
    { "code": "C133", "province": "TO", "name": "CASTELLAMONTE" },
    { "code": "C133", "province": "AO", "name": "CASTELLAMONTE (soppresso)" },
    { "code": "C134", "province": "BA", "name": "CASTELLANA (soppresso)" },
    { "code": "C134", "province": "BA", "name": "CASTELLANA GROTTE" },
    { "code": "C135", "province": "PA", "name": "CASTELLANA SICULA" },
    { "code": "C136", "province": "LE", "name": "CASTELLANETA (soppresso)" },
    { "code": "C136", "province": "TA", "name": "CASTELLANETA" },
    { "code": "C137", "province": "AL", "name": "CASTELLANIA (soppresso)" },
    { "code": "C137", "province": "AL", "name": "CASTELLANIA COPPI" },
    { "code": "C138", "province": "TN", "name": "CASTELLANO (soppresso)" },
    { "code": "C139", "province": "MI", "name": "CASTELLANZA (soppresso)" },
    { "code": "C139", "province": "VA", "name": "CASTELLANZA" },
    { "code": "C140", "province": "CN", "name": "CASTELLAR (soppresso)" },
    { "code": "C142", "province": "AL", "name": "CASTELLAR GUIDOBONO" },
    { "code": "C141", "province": "RE", "name": "CASTELLARANO" },
    { "code": "C143", "province": "IM", "name": "CASTELLARO" },
    { "code": "C144", "province": "PV", "name": "CASTELLARO DE' GIORGI (soppresso)" },
    { "code": "C145", "province": "PC", "name": "CASTELL'ARQUATO" },
    { "code": "C146", "province": "BL", "name": "CASTELLAVAZZO (soppresso)" },
    { "code": "C147", "province": "GR", "name": "CASTELL'AZZARA" },
    { "code": "C148", "province": "AL", "name": "CASTELLAZZO BORMIDA" },
    { "code": "C149", "province": "NO", "name": "CASTELLAZZO NOVARESE" },
    { "code": "C151", "province": "NO", "name": "CASTELLENGO (soppresso)" },
    { "code": "C151", "province": "VC", "name": "CASTELLENGO (soppresso)" },
    { "code": "C153", "province": "CR", "name": "CASTELLEONE" },
    { "code": "C152", "province": "AN", "name": "CASTELLEONE DI SUASA" },
    { "code": "C154", "province": "AL", "name": "CASTELLERO (soppresso)" },
    { "code": "C154", "province": "AT", "name": "CASTELLERO" },
    { "code": "C155", "province": "NO", "name": "CASTELLETTO CERVO (soppresso)" },
    { "code": "C155", "province": "VC", "name": "CASTELLETTO CERVO (soppresso)" },
    { "code": "C155", "province": "BI", "name": "CASTELLETTO CERVO" },
    { "code": "C156", "province": "AL", "name": "CASTELLETTO D'ERRO" },
    { "code": "C157", "province": "PV", "name": "CASTELLETTO DI BRANDUZZO" },
    { "code": "B154", "province": "VR", "name": "CASTELLETTO DI BRENZONE (soppresso)" },
    { "code": "C158", "province": "AL", "name": "CASTELLETTO D'ORBA" },
    { "code": "C160", "province": "AL", "name": "CASTELLETTO MERLI" },
    { "code": "C161", "province": "AL", "name": "CASTELLETTO MOLINA (soppresso)" },
    { "code": "C161", "province": "AT", "name": "CASTELLETTO MOLINA" },
    { "code": "C162", "province": "AL", "name": "CASTELLETTO MONFERRATO" },
    { "code": "C163", "province": "CN", "name": "CASTELLETTO MONFORTE (soppresso)" },
    { "code": "C164", "province": "PV", "name": "CASTELLETTO PO (soppresso)" },
    { "code": "C162", "province": "AL", "name": "CASTELLETTO SCAZZOSO (soppresso)" },
    { "code": "C166", "province": "NO", "name": "CASTELLETTO SOPRA TICINO" },
    { "code": "C165", "province": "CN", "name": "CASTELLETTO STURA" },
    { "code": "C167", "province": "CN", "name": "CASTELLETTO UZZONE" },
    { "code": "C168", "province": "NO", "name": "CASTELLETTO VILLA (soppresso)" },
    { "code": "C168", "province": "VC", "name": "CASTELLETTO VILLA (soppresso)" },
    { "code": "C169", "province": "TE", "name": "CASTELLI" },
    { "code": "C079", "province": "BG", "name": "CASTELLI CALEPIO" },
    { "code": "C171", "province": "NO", "name": "CASTELLI CUSIANI (soppresso)" },
    { "code": "C172", "province": "SI", "name": "CASTELLINA IN CHIANTI" },
    { "code": "C174", "province": "PI", "name": "CASTELLINA MARITTIMA" },
    { "code": "C173", "province": "CN", "name": "CASTELLINALDO (soppresso)" },
    { "code": "C173", "province": "CN", "name": "CASTELLINALDO D'ALBA" },
    { "code": "C175", "province": "CB", "name": "CASTELLINO DEL BIFERNO" },
    { "code": "C176", "province": "CN", "name": "CASTELLINO TANARO" },
    { "code": "C177", "province": "CE", "name": "CASTELLIRI (soppresso)" },
    { "code": "C177", "province": "FR", "name": "CASTELLIRI" },
    { "code": "C182", "province": "TN", "name": "CASTELLO (soppresso)" },
    { "code": "C183", "province": "TN", "name": "CASTELLO (soppresso)" },
    { "code": "B312", "province": "VA", "name": "CASTELLO CABIAGLIO" },
    { "code": "C184", "province": "PV", "name": "CASTELLO D'AGOGNA" },
    { "code": "C178", "province": "CE", "name": "CASTELLO D'ALIFE (soppresso)" },
    { "code": "C178", "province": "BN", "name": "CASTELLO D'ALIFE (soppresso)" },
    { "code": "C185", "province": "BO", "name": "CASTELLO D'ARGILE" },
    { "code": "C178", "province": "CE", "name": "CASTELLO DEL MATESE" },
    { "code": "C186", "province": "SO", "name": "CASTELLO DELL'ACQUA" },
    { "code": "A300", "province": "AL", "name": "CASTELLO DI ANNONE (soppresso)" },
    { "code": "A300", "province": "AT", "name": "CASTELLO DI ANNONE" },
    { "code": "C187", "province": "CO", "name": "CASTELLO DI BRIANZA (soppresso)" },
    { "code": "C187", "province": "LC", "name": "CASTELLO DI BRIANZA" },
    { "code": "B494", "province": "CE", "name": "CASTELLO DI CAMPAGNANO (soppresso)" },
    { "code": "C188", "province": "CE", "name": "CASTELLO DI CISTERNA (soppresso)" },
    { "code": "C188", "province": "NA", "name": "CASTELLO DI CISTERNA" },
    { "code": "C189", "province": "TN", "name": "CASTELLO DI FIEMME (soppresso)" },
    { "code": "C190", "province": "TV", "name": "CASTELLO DI GODEGO" },
    { "code": "C077", "province": "TN", "name": "CASTELLO DI PUSTERIA (soppresso)" },
    { "code": "C191", "province": "BO", "name": "CASTELLO DI SERRAVALLE (soppresso)" },
    { "code": "C180", "province": "CO", "name": "CASTELLO SOPRA LECCO (soppresso)" },
    { "code": "C194", "province": "TN", "name": "CASTELLO TESINO" },
    { "code": "C179", "province": "CO", "name": "CASTELLO VALSOLDA (soppresso)" },
    { "code": "C181", "province": "CO", "name": "CASTELLO VALTRAVAGLIA (soppresso)" },
    { "code": "C181", "province": "VA", "name": "CASTELLO VALTRAVAGLIA (soppresso)" },
    { "code": "C189", "province": "TN", "name": "CASTELLO-MOLINA DI FIEMME" },
    { "code": "C192", "province": "CB", "name": "CASTELLONE AL VOLTURNO (soppresso)" },
    { "code": "C193", "province": "CE", "name": "CASTELLONORATO (soppresso)" },
    { "code": "C193", "province": "RM", "name": "CASTELLONORATO (soppresso)" },
    { "code": "C195", "province": "MN", "name": "CASTELLUCCHIO" },
    { "code": "C196", "province": "PZ", "name": "CASTELLUCCIO (soppresso)" },
    { "code": "C198", "province": "FG", "name": "CASTELLUCCIO DEI SAURI" },
    { "code": "C199", "province": "PZ", "name": "CASTELLUCCIO INFERIORE" },
    { "code": "C201", "province": "PZ", "name": "CASTELLUCCIO SUPERIORE" },
    { "code": "C202", "province": "FG", "name": "CASTELLUCCIO VALMAGGIORE" },
    { "code": "C051", "province": "ME", "name": "CASTELL'UMBERTO" },
    { "code": "C205", "province": "CN", "name": "CASTELMAGNO" },
    { "code": "C206", "province": "CO", "name": "CASTELMARTE" },
    { "code": "C207", "province": "RO", "name": "CASTELMASSA" },
    { "code": "C197", "province": "CB", "name": "CASTELMAURO" },
    { "code": "C209", "province": "PZ", "name": "CASTELMEZZANO" },
    { "code": "C210", "province": "ME", "name": "CASTELMOLA" },
    { "code": "C213", "province": "PV", "name": "CASTELNOVETTO" },
    { "code": "C215", "province": "RO", "name": "CASTELNOVO BARIANO" },
    { "code": "C217", "province": "UD", "name": "CASTELNOVO DEL FRIULI (soppresso)" },
    { "code": "C217", "province": "PN", "name": "CASTELNOVO DEL FRIULI" },
    { "code": "C218", "province": "RE", "name": "CASTELNOVO DI SOTTO" },
    { "code": "C219", "province": "RE", "name": "CASTELNOVO NE' MONTI" },
    { "code": "C216", "province": "TN", "name": "CASTELNUOVO" },
    { "code": "C220", "province": "CO", "name": "CASTELNUOVO BAZENTE (soppresso)" },
    { "code": "C226", "province": "AL", "name": "CASTELNUOVO BELBO (soppresso)" },
    { "code": "C226", "province": "AT", "name": "CASTELNUOVO BELBO" },
    { "code": "C227", "province": "SI", "name": "CASTELNUOVO BERARDENGA" },
    { "code": "C228", "province": "MI", "name": "CASTELNUOVO BOCCA D'ADDA (soppresso)" },
    { "code": "C228", "province": "LO", "name": "CASTELNUOVO BOCCA D'ADDA" },
    { "code": "C229", "province": "AL", "name": "CASTELNUOVO BORMIDA" },
    { "code": "C220", "province": "CO", "name": "CASTELNUOVO BOZZENTE" },
    { "code": "C230", "province": "AL", "name": "CASTELNUOVO CALCEA (soppresso)" },
    { "code": "C230", "province": "AT", "name": "CASTELNUOVO CALCEA" },
    { "code": "C231", "province": "SA", "name": "CASTELNUOVO CILENTO" },
    { "code": "C232", "province": "AL", "name": "CASTELNUOVO D'ASTI (soppresso)" },
    { "code": "C225", "province": "VR", "name": "CASTELNUOVO DEL GARDA" },
    { "code": "C222", "province": "FG", "name": "CASTELNUOVO DELLA DAUNIA" },
    { "code": "C214", "province": "CN", "name": "CASTELNUOVO DI CEVA" },
    { "code": "C235", "province": "SA", "name": "CASTELNUOVO DI CONZA" },
    { "code": "C224", "province": "PG", "name": "CASTELNUOVO DI FARFA (soppresso)" },
    { "code": "C224", "province": "RM", "name": "CASTELNUOVO DI FARFA (soppresso)" },
    { "code": "C224", "province": "RI", "name": "CASTELNUOVO DI FARFA" },
    { "code": "C236", "province": "MS", "name": "CASTELNUOVO DI GARFAGNANA (soppresso)" },
    { "code": "C236", "province": "LU", "name": "CASTELNUOVO DI GARFAGNANA" },
    { "code": "C237", "province": "RM", "name": "CASTELNUOVO DI PORTO" },
    { "code": "C244", "province": "PI", "name": "CASTELNUOVO DI VAL DI CECINA" },
    { "code": "C225", "province": "VR", "name": "CASTELNUOVO DI VERONA (soppresso)" },
    { "code": "C238", "province": "FU", "name": "CASTELNUOVO D'ISTRIA (soppresso)" },
    { "code": "C238", "province": "PL", "name": "CASTELNUOVO D'ISTRIA (soppresso)" },
    { "code": "C232", "province": "AL", "name": "CASTELNUOVO DON BOSCO (soppresso)" },
    { "code": "C232", "province": "AT", "name": "CASTELNUOVO DON BOSCO" },
    { "code": "C240", "province": "GE", "name": "CASTELNUOVO MAGRA (soppresso)" },
    { "code": "C240", "province": "SP", "name": "CASTELNUOVO MAGRA" },
    { "code": "C241", "province": "AO", "name": "CASTELNUOVO NIGRA (soppresso)" },
    { "code": "C241", "province": "TO", "name": "CASTELNUOVO NIGRA" },
    { "code": "C223", "province": "CE", "name": "CASTELNUOVO PARANO (soppresso)" },
    { "code": "C223", "province": "FR", "name": "CASTELNUOVO PARANO" },
    { "code": "C242", "province": "MO", "name": "CASTELNUOVO RANGONE" },
    { "code": "C243", "province": "AL", "name": "CASTELNUOVO SCRIVIA" },
    { "code": "C245", "province": "BN", "name": "CASTELPAGANO" },
    { "code": "C246", "province": "CB", "name": "CASTELPETROSO (soppresso)" },
    { "code": "C246", "province": "IS", "name": "CASTELPETROSO" },
    { "code": "C247", "province": "CB", "name": "CASTELPIZZUTO (soppresso)" },
    { "code": "C247", "province": "IS", "name": "CASTELPIZZUTO" },
    { "code": "C248", "province": "AN", "name": "CASTELPLANIO" },
    { "code": "C249", "province": "CR", "name": "CASTELPONZONE (soppresso)" },
    { "code": "C250", "province": "BN", "name": "CASTELPOTO" },
    { "code": "C251", "province": "MC", "name": "CASTELRAIMONDO" },
    { "code": "C254", "province": "TN", "name": "CASTELROTTO (soppresso)" },
    { "code": "C254", "province": "BZ", "name": "CASTELROTTO" },
    { "code": "C256", "province": "SA", "name": "CASTELRUGGIERO (soppresso)" },
    { "code": "C267", "province": "MC", "name": "CASTELSANTANGELO (soppresso)" },
    { "code": "C267", "province": "MC", "name": "CASTELSANTANGELO SUL NERA" },
    { "code": "C271", "province": "PZ", "name": "CASTELSARACENO" },
    { "code": "C272", "province": "SS", "name": "CASTELSARDO" },
    { "code": "C273", "province": "CO", "name": "CASTELSEPRIO (soppresso)" },
    { "code": "C273", "province": "VA", "name": "CASTELSEPRIO" },
    { "code": "B968", "province": "CZ", "name": "CASTELSILANO (soppresso)" },
    { "code": "B968", "province": "KR", "name": "CASTELSILANO" },
    { "code": "C274", "province": "AL", "name": "CASTELSPINA" },
    { "code": "C275", "province": "AG", "name": "CASTELTERMINI" },
    { "code": "C181", "province": "VA", "name": "CASTELVECCANA" },
    { "code": "C278", "province": "AQ", "name": "CASTELVECCHIO CALVISIO" },
    { "code": "C276", "province": "GE", "name": "CASTELVECCHIO DI ROCCA BARBENA (soppresso)" },
    { "code": "C276", "province": "SV", "name": "CASTELVECCHIO DI ROCCA BARBENA" },
    { "code": "C277", "province": "IM", "name": "CASTELVECCHIO DI SANTA MARIA MAGGIORE (soppresso)" },
    { "code": "C279", "province": "AQ", "name": "CASTELVECCHIO SUBEQUO" },
    { "code": "C280", "province": "BN", "name": "CASTELVENERE" },
    { "code": "B129", "province": "CR", "name": "CASTELVERDE" },
    { "code": "C281", "province": "AL", "name": "CASTELVERO D'ASTI (soppresso)" },
    { "code": "C200", "province": "CB", "name": "CASTELVERRINO (soppresso)" },
    { "code": "C200", "province": "IS", "name": "CASTELVERRINO" },
    { "code": "C283", "province": "AV", "name": "CASTELVETERE DI CALORE (soppresso)" },
    { "code": "C284", "province": "BN", "name": "CASTELVETERE IN VAL FORTORE" },
    { "code": "C283", "province": "AV", "name": "CASTELVETERE SUL CALORE" },
    { "code": "C286", "province": "TP", "name": "CASTELVETRANO" },
    { "code": "C287", "province": "MO", "name": "CASTELVETRO DI MODENA" },
    { "code": "C288", "province": "PC", "name": "CASTELVETRO PIACENTINO" },
    { "code": "C290", "province": "CR", "name": "CASTELVISCONTI" },
    { "code": "C292", "province": "BO", "name": "CASTENASO" },
    { "code": "C293", "province": "BS", "name": "CASTENEDOLO" },
    { "code": "M288", "province": "CA", "name": "CASTIADAS (soppresso)" },
    { "code": "M288", "province": "SU", "name": "CASTIADAS" },
    { "code": "C294", "province": "AO", "name": "CASTIGLION DORA (soppresso)" },
    { "code": "C318", "province": "AR", "name": "CASTIGLION FIBOCCHI" },
    { "code": "C319", "province": "AR", "name": "CASTIGLION FIORENTINO" },
    { "code": "C308", "province": "TE", "name": "CASTIGLIONE A CASAURIA (soppresso)" },
    { "code": "C308", "province": "PE", "name": "CASTIGLIONE A CASAURIA" },
    { "code": "C302", "province": "GE", "name": "CASTIGLIONE CHIAVARESE" },
    { "code": "C301", "province": "CS", "name": "CASTIGLIONE COSENTINO" },
    { "code": "C304", "province": "MI", "name": "CASTIGLIONE D'ADDA (soppresso)" },
    { "code": "C304", "province": "LO", "name": "CASTIGLIONE D'ADDA" },
    { "code": "C295", "province": "AL", "name": "CASTIGLIONE D'ASTI (soppresso)" },
    { "code": "C296", "province": "BO", "name": "CASTIGLIONE DEI PEPOLI" },
    { "code": "C306", "province": "SA", "name": "CASTIGLIONE DEL GENOVESI" },
    { "code": "C309", "province": "PG", "name": "CASTIGLIONE DEL LAGO" },
    { "code": "C310", "province": "GR", "name": "CASTIGLIONE DELLA PESCAIA" },
    { "code": "C311", "province": "TE", "name": "CASTIGLIONE DELLA VALLE (soppresso)" },
    { "code": "C312", "province": "MN", "name": "CASTIGLIONE DELLE STIVIERE" },
    { "code": "C303", "province": "MS", "name": "CASTIGLIONE DI GARFAGNANA (soppresso)" },
    { "code": "C303", "province": "LU", "name": "CASTIGLIONE DI GARFAGNANA" },
    { "code": "C297", "province": "CT", "name": "CASTIGLIONE DI SICILIA" },
    { "code": "C299", "province": "CO", "name": "CASTIGLIONE D'INTELVI (soppresso)" },
    { "code": "C313", "province": "SI", "name": "CASTIGLIONE D'ORCIA" },
    { "code": "C305", "province": "NO", "name": "CASTIGLIONE D'OSSOLA (soppresso)" },
    { "code": "C314", "province": "CN", "name": "CASTIGLIONE FALLETTO" },
    { "code": "C315", "province": "RM", "name": "CASTIGLIONE IN TEVERINA (soppresso)" },
    { "code": "C315", "province": "VT", "name": "CASTIGLIONE IN TEVERINA" },
    { "code": "C298", "province": "CH", "name": "CASTIGLIONE MESSER MARINO" },
    { "code": "C316", "province": "TE", "name": "CASTIGLIONE MESSER RAIMONDO" },
    { "code": "C300", "province": "CO", "name": "CASTIGLIONE OLONA (soppresso)" },
    { "code": "C300", "province": "VA", "name": "CASTIGLIONE OLONA" },
    { "code": "C317", "province": "CN", "name": "CASTIGLIONE TINELLA" },
    { "code": "C307", "province": "TO", "name": "CASTIGLIONE TORINESE" },
    { "code": "C321", "province": "AP", "name": "CASTIGNANO" },
    { "code": "C322", "province": "TE", "name": "CASTILENTI" },
    { "code": "C323", "province": "CN", "name": "CASTINO" },
    { "code": "C325", "province": "SO", "name": "CASTIONE ANDEVENNO" },
    { "code": "C324", "province": "BG", "name": "CASTIONE DELLA PRESOLANA" },
    { "code": "C326", "province": "VR", "name": "CASTIONE VERONESE (soppresso)" },
    { "code": "C327", "province": "UD", "name": "CASTIONS DI STRADA" },
    { "code": "C329", "province": "MI", "name": "CASTIRAGA VIDARDO (soppresso)" },
    { "code": "C329", "province": "LO", "name": "CASTIRAGA VIDARDO" },
    { "code": "C330", "province": "BS", "name": "CASTO" },
    { "code": "C331", "province": "AP", "name": "CASTORANO" },
    { "code": "C332", "province": "BS", "name": "CASTREZZATO" },
    { "code": "C333", "province": "BS", "name": "CASTREZZONE (soppresso)" },
    { "code": "C334", "province": "LE", "name": "CASTRI DI LECCE" },
    { "code": "C335", "province": "LE", "name": "CASTRIGNANO DE' GRECI" },
    { "code": "C336", "province": "LE", "name": "CASTRIGNANO DEL CAPO" },
    { "code": "C337", "province": "BG", "name": "CASTRO" },
    { "code": "M261", "province": "LE", "name": "CASTRO" },
    { "code": "C338", "province": "RM", "name": "CASTRO DEI VOLSCI (soppresso)" },
    { "code": "C338", "province": "FR", "name": "CASTRO DEI VOLSCI" },
    { "code": "C339", "province": "FO", "name": "CASTROCARO E TERRA DEL SOLE (soppresso)" },
    { "code": "C339", "province": "FO", "name": "CASTROCARO TERME E TERRA DEL SOLE (soppresso)" },
    { "code": "C339", "province": "FC", "name": "CASTROCARO TERME E TERRA DEL SOLE" },
    { "code": "C340", "province": "CE", "name": "CASTROCIELO (soppresso)" },
    { "code": "C340", "province": "FR", "name": "CASTROCIELO" },
    { "code": "C341", "province": "AG", "name": "CASTROFILIPPO" },
    { "code": "C342", "province": "CL", "name": "CASTROGIOVANNI (soppresso)" },
    { "code": "C342", "province": "EN", "name": "CASTROGIOVANNI (soppresso)" },
    { "code": "C108", "province": "CS", "name": "CASTROLIBERO" },
    { "code": "C343", "province": "CO", "name": "CASTRONNO (soppresso)" },
    { "code": "C343", "province": "VA", "name": "CASTRONNO" },
    { "code": "C344", "province": "PA", "name": "CASTRONOVO DI SICILIA" },
    { "code": "C345", "province": "PZ", "name": "CASTRONUOVO DI SANT'ANDREA" },
    { "code": "C346", "province": "CB", "name": "CASTROPIGNANO" },
    { "code": "C347", "province": "ME", "name": "CASTROREALE" },
    { "code": "C348", "province": "CS", "name": "CASTROREGIO" },
    { "code": "C349", "province": "CS", "name": "CASTROVILLARI" },
    { "code": "C350", "province": "RC", "name": "CATAFORIO (soppresso)" },
    { "code": "C351", "province": "CT", "name": "CATANIA" },
    { "code": "C352", "province": "CZ", "name": "CATANZARO" },
    { "code": "C353", "province": "CT", "name": "CATENANUOVA (soppresso)" },
    { "code": "C353", "province": "EN", "name": "CATENANUOVA" },
    { "code": "C354", "province": "TE", "name": "CATIGNANO (soppresso)" },
    { "code": "C354", "province": "PE", "name": "CATIGNANO" },
    { "code": "C355", "province": "RC", "name": "CATONA (soppresso)" },
    { "code": "C357", "province": "FO", "name": "CATTOLICA (soppresso)" },
    { "code": "C357", "province": "RN", "name": "CATTOLICA" },
    { "code": "C356", "province": "AG", "name": "CATTOLICA ERACLEA" },
    { "code": "C285", "province": "RC", "name": "CAULONIA" },
    { "code": "C358", "province": "TN", "name": "CAURIA (soppresso)" },
    { "code": "C359", "province": "BN", "name": "CAUTANO" },
    { "code": "C361", "province": "SA", "name": "CAVA DE' TIRRENI" },
    { "code": "C360", "province": "PV", "name": "CAVA MANARA" },
    { "code": "C362", "province": "MI", "name": "CAVACURTA (soppresso)" },
    { "code": "C362", "province": "LO", "name": "CAVACURTA (soppresso)" },
    { "code": "C363", "province": "NO", "name": "CAVAGLIA' (soppresso)" },
    { "code": "C363", "province": "VC", "name": "CAVAGLIA' (soppresso)" },
    { "code": "C363", "province": "BI", "name": "CAVAGLIA'" },
    { "code": "C364", "province": "NO", "name": "CAVAGLIETTO" },
    { "code": "C365", "province": "NO", "name": "CAVAGLIO D'AGOGNA" },
    { "code": "C366", "province": "NO", "name": "CAVAGLIO SAN DONNINO (soppresso)" },
    { "code": "C367", "province": "NO", "name": "CAVAGLIO-SPOCCIA (soppresso)" },
    { "code": "C367", "province": "VB", "name": "CAVAGLIO-SPOCCIA (soppresso)" },
    { "code": "C369", "province": "TO", "name": "CAVAGNOLO" },
    { "code": "C370", "province": "VR", "name": "CAVAION VERONESE" },
    { "code": "C372", "province": "TN", "name": "CAVALESE" },
    { "code": "C374", "province": "CO", "name": "CAVALLASCA (soppresso)" },
    { "code": "C375", "province": "CN", "name": "CAVALLERLEONE" },
    { "code": "C376", "province": "CN", "name": "CAVALLERMAGGIORE" },
    { "code": "C377", "province": "LE", "name": "CAVALLINO" },
    { "code": "M308", "province": "VE", "name": "CAVALLINO-TREPORTI" },
    { "code": "C378", "province": "NO", "name": "CAVALLIRIO" },
    { "code": "C379", "province": "NO", "name": "CAVANDONE (soppresso)" },
    { "code": "C380", "province": "TN", "name": "CAVARENO" },
    { "code": "C381", "province": "CO", "name": "CAVARGNA" },
    { "code": "C382", "province": "MI", "name": "CAVARIA CON PREMEZZO (soppresso)" },
    { "code": "C382", "province": "VA", "name": "CAVARIA CON PREMEZZO" },
    { "code": "C382", "province": "MI", "name": "CAVARIA ED UNITI (soppresso)" },
    { "code": "C383", "province": "VE", "name": "CAVARZERE" },
    { "code": "C384", "province": "TV", "name": "CAVASO (soppresso)" },
    { "code": "C384", "province": "TV", "name": "CAVASO DEL TOMBA" },
    { "code": "C385", "province": "UD", "name": "CAVASSO NUOVO (soppresso)" },
    { "code": "C385", "province": "PN", "name": "CAVASSO NUOVO" },
    { "code": "C387", "province": "AL", "name": "CAVATORE" },
    { "code": "C388", "province": "VE", "name": "CAVAZUCCHERINA (soppresso)" },
    { "code": "C389", "province": "UD", "name": "CAVAZZO CARNICO" },
    { "code": "C390", "province": "RM", "name": "CAVE" },
    { "code": "C391", "province": "TS", "name": "CAVE AUREMIANE (soppresso)" },
    { "code": "C392", "province": "TN", "name": "CAVEDAGO" },
    { "code": "C393", "province": "TN", "name": "CAVEDINE" },
    { "code": "C394", "province": "MI", "name": "CAVENAGO D'ADDA (soppresso)" },
    { "code": "C394", "province": "LO", "name": "CAVENAGO D'ADDA" },
    { "code": "C395", "province": "MI", "name": "CAVENAGO DI BRIANZA (soppresso)" },
    { "code": "C395", "province": "MB", "name": "CAVENAGO DI BRIANZA" },
    { "code": "C396", "province": "BG", "name": "CAVERNAGO" },
    { "code": "C397", "province": "CO", "name": "CAVERSACCIO (soppresso)" },
    { "code": "C398", "province": "MO", "name": "CAVEZZO" },
    { "code": "C400", "province": "TN", "name": "CAVIZZANA" },
    { "code": "C401", "province": "TN", "name": "CAVOLANO (soppresso)" },
    { "code": "C402", "province": "CO", "name": "CAVONA (soppresso)" },
    { "code": "C402", "province": "VA", "name": "CAVONA (soppresso)" },
    { "code": "C404", "province": "TO", "name": "CAVOUR" },
    { "code": "C405", "province": "RE", "name": "CAVRIAGO" },
    { "code": "C406", "province": "MN", "name": "CAVRIANA" },
    { "code": "C407", "province": "AR", "name": "CAVRIGLIA" },
    { "code": "C409", "province": "CO", "name": "CAZZAGO BRABBIA (soppresso)" },
    { "code": "C409", "province": "VA", "name": "CAZZAGO BRABBIA" },
    { "code": "C408", "province": "BS", "name": "CAZZAGO SAN MARTINO" },
    { "code": "C412", "province": "VR", "name": "CAZZANO DI TRAMIGNA" },
    { "code": "C410", "province": "BG", "name": "CAZZANO SANT'ANDREA" },
    { "code": "B017", "province": "MI", "name": "CAZZIMANI (soppresso)" },
    { "code": "C413", "province": "RM", "name": "CECCANO (soppresso)" },
    { "code": "C413", "province": "FR", "name": "CECCANO" },
    { "code": "C414", "province": "PV", "name": "CECIMA" },
    { "code": "C415", "province": "PI", "name": "CECINA (soppresso)" },
    { "code": "C415", "province": "LI", "name": "CECINA" },
    { "code": "C416", "province": "GO", "name": "CECONICO (soppresso)" },
    { "code": "C416", "province": "UD", "name": "CECONICO (soppresso)" },
    { "code": "C417", "province": "BS", "name": "CEDEGOLO" },
    { "code": "C418", "province": "SO", "name": "CEDRASCO" },
    { "code": "C420", "province": "PA", "name": "CEFALA' DIANA" },
    { "code": "C421", "province": "PA", "name": "CEFALU'" },
    { "code": "C422", "province": "VE", "name": "CEGGIA" },
    { "code": "C425", "province": "FU", "name": "CEGLIE (soppresso)" },
    { "code": "C425", "province": "PL", "name": "CEGLIE (soppresso)" },
    { "code": "C423", "province": "BA", "name": "CEGLIE DEL CAMPO (soppresso)" },
    { "code": "C424", "province": "BR", "name": "CEGLIE MESSAPICA" },
    { "code": "C424", "province": "LE", "name": "CEGLIE MESSAPICO (soppresso)" },
    { "code": "C424", "province": "BR", "name": "CEGLIE MESSAPICO (soppresso)" },
    { "code": "C426", "province": "AQ", "name": "CELANO" },
    { "code": "C427", "province": "TN", "name": "CELENTINO (soppresso)" },
    { "code": "C428", "province": "CH", "name": "CELENZA SUL TRIGNO" },
    { "code": "C429", "province": "FG", "name": "CELENZA VALFORTORE" },
    { "code": "C430", "province": "CS", "name": "CELICO" },
    { "code": "C435", "province": "CR", "name": "CELLA DATI" },
    { "code": "C434", "province": "PV", "name": "CELLA DI BOBBIO (soppresso)" },
    { "code": "C432", "province": "AL", "name": "CELLA MONTE" },
    { "code": "C436", "province": "BA", "name": "CELLAMARE" },
    { "code": "C437", "province": "CS", "name": "CELLARA" },
    { "code": "C438", "province": "AL", "name": "CELLARENGO (soppresso)" },
    { "code": "C438", "province": "AT", "name": "CELLARENGO" },
    { "code": "C439", "province": "BS", "name": "CELLATICA" },
    { "code": "C444", "province": "SA", "name": "CELLE DI BULGHERIA" },
    { "code": "C441", "province": "CN", "name": "CELLE DI MACRA" },
    { "code": "C442", "province": "FG", "name": "CELLE DI SAN VITO" },
    { "code": "C440", "province": "AL", "name": "CELLE ENOMONDO (soppresso)" },
    { "code": "C440", "province": "AT", "name": "CELLE ENOMONDO" },
    { "code": "C443", "province": "GE", "name": "CELLE LIGURE (soppresso)" },
    { "code": "C443", "province": "SV", "name": "CELLE LIGURE" },
    { "code": "C445", "province": "TN", "name": "CELLEDIZZO (soppresso)" },
    { "code": "C446", "province": "RM", "name": "CELLENO (soppresso)" },
    { "code": "C446", "province": "VT", "name": "CELLENO" },
    { "code": "C447", "province": "RM", "name": "CELLERE (soppresso)" },
    { "code": "C447", "province": "VT", "name": "CELLERE" },
    { "code": "C431", "province": "CO", "name": "CELLINA (soppresso)" },
    { "code": "C431", "province": "VA", "name": "CELLINA (soppresso)" },
    { "code": "C449", "province": "TE", "name": "CELLINO ATTANASIO" },
    { "code": "C448", "province": "LE", "name": "CELLINO SAN MARCO (soppresso)" },
    { "code": "C448", "province": "BR", "name": "CELLINO SAN MARCO" },
    { "code": "C450", "province": "NO", "name": "CELLIO (soppresso)" },
    { "code": "C450", "province": "VC", "name": "CELLIO (soppresso)" },
    { "code": "M398", "province": "VC", "name": "CELLIO CON BREIA" },
    { "code": "M262", "province": "CE", "name": "CELLOLE" },
    { "code": "C452", "province": "TN", "name": "CEMBRA (soppresso)" },
    { "code": "M355", "province": "TN", "name": "CEMBRA LISIGNAGO" },
    { "code": "C453", "province": "CZ", "name": "CENADI" },
    { "code": "C454", "province": "BG", "name": "CENATE (soppresso)" },
    { "code": "C455", "province": "BG", "name": "CENATE D'ARGON (soppresso)" },
    { "code": "C456", "province": "BG", "name": "CENATE SOPRA" },
    { "code": "C457", "province": "BG", "name": "CENATE SOTTO" },
    { "code": "C458", "province": "BL", "name": "CENCENIGHE (soppresso)" },
    { "code": "C458", "province": "BL", "name": "CENCENIGHE AGORDINO" },
    { "code": "C459", "province": "BG", "name": "CENE" },
    { "code": "C461", "province": "RO", "name": "CENESELLI" },
    { "code": "C462", "province": "GE", "name": "CENESI (soppresso)" },
    { "code": "C462", "province": "SV", "name": "CENESI (soppresso)" },
    { "code": "C463", "province": "GE", "name": "CENGIO (soppresso)" },
    { "code": "C463", "province": "SV", "name": "CENGIO" },
    { "code": "C464", "province": "TN", "name": "CENGLES (soppresso)" },
    { "code": "C464", "province": "BZ", "name": "CENGLES (soppresso)" },
    { "code": "C465", "province": "IM", "name": "CENOVA (soppresso)" },
    { "code": "C467", "province": "TN", "name": "CENTA SAN NICOLO' (soppresso)" },
    { "code": "C466", "province": "CN", "name": "CENTALLO" },
    { "code": "C469", "province": "FE", "name": "CENTO" },
    { "code": "C470", "province": "SA", "name": "CENTOLA" },
    { "code": "C472", "province": "CZ", "name": "CENTRACHE" },
    { "code": "C473", "province": "BG", "name": "CENTRISOLA (soppresso)" },
    { "code": "M394", "province": "CO", "name": "CENTRO VALLE INTELVI" },
    { "code": "C471", "province": "CT", "name": "CENTURIPE (soppresso)" },
    { "code": "C471", "province": "EN", "name": "CENTURIPE" },
    { "code": "C474", "province": "TE", "name": "CEPAGATTI (soppresso)" },
    { "code": "C474", "province": "PE", "name": "CEPAGATTI" },
    { "code": "C475", "province": "BG", "name": "CEPINO (soppresso)" },
    { "code": "C476", "province": "BN", "name": "CEPPALONI" },
    { "code": "C478", "province": "NO", "name": "CEPPO MORELLI (soppresso)" },
    { "code": "C478", "province": "VB", "name": "CEPPO MORELLI" },
    { "code": "C479", "province": "RM", "name": "CEPRANO (soppresso)" },
    { "code": "C479", "province": "FR", "name": "CEPRANO" },
    { "code": "C480", "province": "CT", "name": "CERAMI (soppresso)" },
    { "code": "C480", "province": "EN", "name": "CERAMI" },
    { "code": "C481", "province": "GE", "name": "CERANESI" },
    { "code": "C483", "province": "NO", "name": "CERANO" },
    { "code": "C482", "province": "CO", "name": "CERANO D'INTELVI" },
    { "code": "C484", "province": "PV", "name": "CERANOVA" },
    { "code": "C485", "province": "SA", "name": "CERASO" },
    { "code": "C486", "province": "BN", "name": "CERCEMAGGIORE (soppresso)" },
    { "code": "C486", "province": "CB", "name": "CERCEMAGGIORE" },
    { "code": "C487", "province": "TO", "name": "CERCENASCO" },
    { "code": "C488", "province": "CB", "name": "CERCEPICCOLA" },
    { "code": "C489", "province": "CS", "name": "CERCHIARA DI CALABRIA" },
    { "code": "C491", "province": "MI", "name": "CERCHIATE (soppresso)" },
    { "code": "C492", "province": "AQ", "name": "CERCHIO" },
    { "code": "C493", "province": "SO", "name": "CERCINO" },
    { "code": "C494", "province": "UD", "name": "CERCIVENTO" },
    { "code": "C495", "province": "NA", "name": "CERCOLA" },
    { "code": "C496", "province": "PA", "name": "CERDA" },
    { "code": "C497", "province": "TO", "name": "CERE (soppresso)" },
    { "code": "C498", "province": "VR", "name": "CEREA" },
    { "code": "C500", "province": "RO", "name": "CEREGNANO" },
    { "code": "C501", "province": "CZ", "name": "CERENZIA (soppresso)" },
    { "code": "C501", "province": "KR", "name": "CERENZIA" },
    { "code": "C497", "province": "TO", "name": "CERES" },
    { "code": "C502", "province": "MN", "name": "CERESARA" },
    { "code": "C503", "province": "AL", "name": "CERESETO" },
    { "code": "C504", "province": "CN", "name": "CERESOLE ALBA" },
    { "code": "C505", "province": "TO", "name": "CERESOLE REALE" },
    { "code": "C505", "province": "AO", "name": "CERESOLE REALE (soppresso)" },
    { "code": "C506", "province": "BG", "name": "CERETE" },
    { "code": "C507", "province": "AL", "name": "CERETTO GRUE (soppresso)" },
    { "code": "C508", "province": "PV", "name": "CERETTO LOMELLINA" },
    { "code": "C509", "province": "PV", "name": "CERGNAGO" },
    { "code": "C510", "province": "GE", "name": "CERIALE (soppresso)" },
    { "code": "C510", "province": "SV", "name": "CERIALE" },
    { "code": "C511", "province": "IM", "name": "CERIANA" },
    { "code": "C512", "province": "MI", "name": "CERIANO LAGHETTO (soppresso)" },
    { "code": "C512", "province": "MB", "name": "CERIANO LAGHETTO" },
    { "code": "C513", "province": "PV", "name": "CERIGNALE (soppresso)" },
    { "code": "C513", "province": "PC", "name": "CERIGNALE" },
    { "code": "C514", "province": "FG", "name": "CERIGNOLA" },
    { "code": "C515", "province": "CS", "name": "CERISANO" },
    { "code": "C516", "province": "CO", "name": "CERMENATE" },
    { "code": "A022", "province": "TN", "name": "CERMES (soppresso)" },
    { "code": "A022", "province": "BZ", "name": "CERMES" },
    { "code": "C517", "province": "TE", "name": "CERMIGNANO" },
    { "code": "C519", "province": "GO", "name": "CERNIZZA GORIZIANA (soppresso)" },
    { "code": "C519", "province": "UD", "name": "CERNIZZA GORIZIANA (soppresso)" },
    { "code": "C520", "province": "CO", "name": "CERNOBBIO" },
    { "code": "C521", "province": "CO", "name": "CERNUSCO LOMBARDONE (soppresso)" },
    { "code": "C521", "province": "LC", "name": "CERNUSCO LOMBARDONE" },
    { "code": "C522", "province": "CO", "name": "CERNUSCO MONTEVECCHIA (soppresso)" },
    { "code": "C523", "province": "MI", "name": "CERNUSCO SUL NAVIGLIO" },
    { "code": "C526", "province": "NO", "name": "CERRETO CASTELLO (soppresso)" },
    { "code": "C526", "province": "VC", "name": "CERRETO CASTELLO (soppresso)" },
    { "code": "C526", "province": "BI", "name": "CERRETO CASTELLO (soppresso)" },
    { "code": "C528", "province": "AL", "name": "CERRETO D'ASTI (soppresso)" },
    { "code": "C528", "province": "AT", "name": "CERRETO D'ASTI" },
    { "code": "C524", "province": "AN", "name": "CERRETO D'ESI" },
    { "code": "C527", "province": "PG", "name": "CERRETO DI SPOLETO" },
    { "code": "C507", "province": "AL", "name": "CERRETO GRUE" },
    { "code": "C529", "province": "FI", "name": "CERRETO GUIDI" },
    { "code": "C518", "province": "RM", "name": "CERRETO LAZIALE" },
    { "code": "C525", "province": "BN", "name": "CERRETO SANNITA" },
    { "code": "C530", "province": "CN", "name": "CERRETTO DELLE LANGHE (soppresso)" },
    { "code": "C530", "province": "CN", "name": "CERRETTO LANGHE" },
    { "code": "C508", "province": "PV", "name": "CERRETTO LOMELLINO (soppresso)" },
    { "code": "C531", "province": "AL", "name": "CERRINA MONFERRATO" },
    { "code": "C532", "province": "NO", "name": "CERRIONE (soppresso)" },
    { "code": "C532", "province": "VC", "name": "CERRIONE (soppresso)" },
    { "code": "C532", "province": "BI", "name": "CERRIONE" },
    { "code": "C536", "province": "MI", "name": "CERRO AL LAMBRO" },
    { "code": "C534", "province": "CB", "name": "CERRO AL VOLTURNO (soppresso)" },
    { "code": "C534", "province": "IS", "name": "CERRO AL VOLTURNO" },
    { "code": "C535", "province": "CO", "name": "CERRO LAGO MAGGIORE (soppresso)" },
    { "code": "C535", "province": "VA", "name": "CERRO LAGO MAGGIORE (soppresso)" },
    { "code": "C537", "province": "MI", "name": "CERRO MAGGIORE" },
    { "code": "C533", "province": "AL", "name": "CERRO TANARO (soppresso)" },
    { "code": "C533", "province": "AT", "name": "CERRO TANARO" },
    { "code": "C538", "province": "VR", "name": "CERRO VERONESE" },
    { "code": "C539", "province": "PZ", "name": "CERSOSIMO" },
    { "code": "C540", "province": "FI", "name": "CERTALDO" },
    { "code": "C541", "province": "PV", "name": "CERTOSA DI PAVIA" },
    { "code": "C542", "province": "CZ", "name": "CERVA" },
    { "code": "C543", "province": "RM", "name": "CERVARA DI ROMA" },
    { "code": "C544", "province": "PD", "name": "CERVARESE SANTA CROCE" },
    { "code": "C545", "province": "CE", "name": "CERVARO (soppresso)" },
    { "code": "C545", "province": "FR", "name": "CERVARO" },
    { "code": "C546", "province": "NO", "name": "CERVAROLO (soppresso)" },
    { "code": "C546", "province": "VC", "name": "CERVAROLO (soppresso)" },
    { "code": "C547", "province": "CN", "name": "CERVASCA" },
    { "code": "C548", "province": "NO", "name": "CERVATTO (soppresso)" },
    { "code": "C548", "province": "VC", "name": "CERVATTO" },
    { "code": "C549", "province": "BS", "name": "CERVENO" },
    { "code": "C550", "province": "CN", "name": "CERVERE" },
    { "code": "C551", "province": "PV", "name": "CERVESINA" },
    { "code": "C552", "province": "RM", "name": "CERVETERI" },
    { "code": "C553", "province": "RA", "name": "CERVIA" },
    { "code": "C554", "province": "CS", "name": "CERVICATI" },
    { "code": "C555", "province": "MI", "name": "CERVIGNANO (soppresso)" },
    { "code": "C556", "province": "UD", "name": "CERVIGNANO (soppresso)" },
    { "code": "C555", "province": "MI", "name": "CERVIGNANO D'ADDA (soppresso)" },
    { "code": "C555", "province": "LO", "name": "CERVIGNANO D'ADDA" },
    { "code": "C556", "province": "UD", "name": "CERVIGNANO DEL FRIULI" },
    { "code": "C557", "province": "AV", "name": "CERVINARA" },
    { "code": "C558", "province": "CE", "name": "CERVINO" },
    { "code": "C558", "province": "NA", "name": "CERVINO (soppresso)" },
    { "code": "C559", "province": "IM", "name": "CERVO" },
    { "code": "C560", "province": "CS", "name": "CERZETO" },
    { "code": "C561", "province": "CE", "name": "CESA" },
    { "code": "C561", "province": "NA", "name": "CESA (soppresso)" },
    { "code": "C563", "province": "CO", "name": "CESANA BRIANZA (soppresso)" },
    { "code": "C563", "province": "LC", "name": "CESANA BRIANZA" },
    { "code": "C564", "province": "TO", "name": "CESANA TORINESE" },
    { "code": "C565", "province": "MI", "name": "CESANO BOSCONE" },
    { "code": "C566", "province": "MI", "name": "CESANO MADERNO (soppresso)" },
    { "code": "C566", "province": "MB", "name": "CESANO MADERNO" },
    { "code": "C567", "province": "NO", "name": "CESARA (soppresso)" },
    { "code": "C567", "province": "VB", "name": "CESARA" },
    { "code": "C568", "province": "ME", "name": "CESARO'" },
    { "code": "C569", "province": "MI", "name": "CESATE" },
    { "code": "C572", "province": "CO", "name": "CESELLO BRIANZA (soppresso)" },
    { "code": "C573", "province": "FO", "name": "CESENA (soppresso)" },
    { "code": "C573", "province": "FC", "name": "CESENA" },
    { "code": "C574", "province": "FO", "name": "CESENATICO (soppresso)" },
    { "code": "C574", "province": "FC", "name": "CESENATICO" },
    { "code": "C575", "province": "PG", "name": "CESI (soppresso)" },
    { "code": "C575", "province": "TR", "name": "CESI (soppresso)" },
    { "code": "C576", "province": "AV", "name": "CESINALI" },
    { "code": "C578", "province": "IM", "name": "CESIO" },
    { "code": "C577", "province": "BL", "name": "CESIOMAGGIORE" },
    { "code": "C579", "province": "TO", "name": "CESNOLA (soppresso)" },
    { "code": "C579", "province": "AO", "name": "CESNOLA (soppresso)" },
    { "code": "C580", "province": "TV", "name": "CESSALTO" },
    { "code": "C581", "province": "CZ", "name": "CESSANITI (soppresso)" },
    { "code": "C581", "province": "VV", "name": "CESSANITI" },
    { "code": "C582", "province": "MC", "name": "CESSAPALOMBO" },
    { "code": "C583", "province": "AL", "name": "CESSOLE (soppresso)" },
    { "code": "C583", "province": "AT", "name": "CESSOLE" },
    { "code": "C584", "province": "SA", "name": "CETARA" },
    { "code": "C585", "province": "BS", "name": "CETO" },
    { "code": "C586", "province": "BS", "name": "CETO-CERVENO (soppresso)" },
    { "code": "C587", "province": "SI", "name": "CETONA" },
    { "code": "C588", "province": "CS", "name": "CETRARO" },
    { "code": "C589", "province": "CN", "name": "CEVA" },
    { "code": "C590", "province": "TN", "name": "CEVES (soppresso)" },
    { "code": "C590", "province": "BZ", "name": "CEVES (soppresso)" },
    { "code": "C591", "province": "BS", "name": "CEVO" },
    { "code": "C593", "province": "AO", "name": "CHALLAND-SAINT-ANSELME" },
    { "code": "C594", "province": "AO", "name": "CHALLAND-SAINT-VICTOR" },
    { "code": "C592", "province": "AO", "name": "CHALLANT (soppresso)" },
    { "code": "C593", "province": "TO", "name": "CHALLANT SAINT ANSELME (soppresso)" },
    { "code": "C593", "province": "AO", "name": "CHALLANT SAINT ANSELME (soppresso)" },
    { "code": "C592", "province": "AO", "name": "CHALLANT SAINT ANSELME ET CHALLANT SAINT VICTOR (soppresso)" },
    { "code": "C594", "province": "TO", "name": "CHALLANT SAINT VICTOR (soppresso)" },
    { "code": "C594", "province": "AO", "name": "CHALLANT SAINT VICTOR (soppresso)" },
    { "code": "C595", "province": "TO", "name": "CHAMBAVE (soppresso)" },
    { "code": "C595", "province": "AO", "name": "CHAMBAVE" },
    { "code": "B491", "province": "TO", "name": "CHAMOIS (soppresso)" },
    { "code": "B491", "province": "AO", "name": "CHAMOIS" },
    { "code": "C596", "province": "TO", "name": "CHAMPDEPRAZ (soppresso)" },
    { "code": "C596", "province": "AO", "name": "CHAMPDEPRAZ" },
    { "code": "C597", "province": "TO", "name": "CHAMPLAS-DU-COL (soppresso)" },
    { "code": "B540", "province": "TO", "name": "CHAMPORCHER (soppresso)" },
    { "code": "B540", "province": "AO", "name": "CHAMPORCHER" },
    { "code": "C598", "province": "TO", "name": "CHARVENSOD (soppresso)" },
    { "code": "C598", "province": "AO", "name": "CHARVENSOD" },
    { "code": "C294", "province": "TO", "name": "CHATILLON (soppresso)" },
    { "code": "C294", "province": "AO", "name": "CHATILLON" },
    { "code": "C599", "province": "CN", "name": "CHERASCO" },
    { "code": "C600", "province": "SS", "name": "CHEREMULE" },
    { "code": "C601", "province": "PL", "name": "CHERSO (soppresso)" },
    { "code": "C602", "province": "TO", "name": "CHIABRANO (soppresso)" },
    { "code": "C603", "province": "NA", "name": "CHIAIANO ED UNITI (soppresso)" },
    { "code": "C604", "province": "TO", "name": "CHIALAMBERTO" },
    { "code": "C605", "province": "VI", "name": "CHIAMPO" },
    { "code": "C606", "province": "AV", "name": "CHIANCHE" },
    { "code": "C607", "province": "AV", "name": "CHIANCHETELLE (soppresso)" },
    { "code": "C608", "province": "SI", "name": "CHIANCIANO (soppresso)" },
    { "code": "C608", "province": "SI", "name": "CHIANCIANO TERME" },
    { "code": "C609", "province": "PI", "name": "CHIANNI" },
    { "code": "C610", "province": "TO", "name": "CHIANOC (soppresso)" },
    { "code": "C610", "province": "TO", "name": "CHIANOCCO" },
    { "code": "C611", "province": "GO", "name": "CHIAPOVANO (soppresso)" },
    { "code": "C611", "province": "UD", "name": "CHIAPOVANO (soppresso)" },
    { "code": "C612", "province": "SR", "name": "CHIARAMONTE GULFI (soppresso)" },
    { "code": "C612", "province": "RG", "name": "CHIARAMONTE GULFI" },
    { "code": "C613", "province": "SS", "name": "CHIARAMONTI" },
    { "code": "C614", "province": "TV", "name": "CHIARANO" },
    { "code": "C615", "province": "AN", "name": "CHIARAVALLE" },
    { "code": "C616", "province": "CZ", "name": "CHIARAVALLE CENTRALE" },
    { "code": "C617", "province": "MI", "name": "CHIARAVALLE MILANESE (soppresso)" },
    { "code": "C618", "province": "BS", "name": "CHIARI" },
    { "code": "C619", "province": "PZ", "name": "CHIAROMONTE" },
    { "code": "C620", "province": "CB", "name": "CHIAUCI (soppresso)" },
    { "code": "C620", "province": "IS", "name": "CHIAUCI" },
    { "code": "C621", "province": "GE", "name": "CHIAVARI" },
    { "code": "C622", "province": "NO", "name": "CHIAVAZZA (soppresso)" },
    { "code": "C622", "province": "VC", "name": "CHIAVAZZA (soppresso)" },
    { "code": "C623", "province": "SO", "name": "CHIAVENNA" },
    { "code": "C624", "province": "TO", "name": "CHIAVERANO" },
    { "code": "C624", "province": "AO", "name": "CHIAVERANO (soppresso)" },
    { "code": "B705", "province": "TO", "name": "CHIAVRIE (soppresso)" },
    { "code": "C625", "province": "TN", "name": "CHIENES (soppresso)" },
    { "code": "C625", "province": "BZ", "name": "CHIENES" },
    { "code": "C626", "province": "TN", "name": "CHIENIS (soppresso)" },
    { "code": "C627", "province": "TO", "name": "CHIERI" },
    { "code": "C630", "province": "BL", "name": "CHIES D'ALPAGO" },
    { "code": "C628", "province": "SO", "name": "CHIESA (soppresso)" },
    { "code": "C628", "province": "SO", "name": "CHIESA IN VALMALENCO" },
    { "code": "C629", "province": "TO", "name": "CHIESANUOVA" },
    { "code": "C629", "province": "AO", "name": "CHIESANUOVA (soppresso)" },
    { "code": "C631", "province": "PT", "name": "CHIESINA UZZANESE" },
    { "code": "C632", "province": "CH", "name": "CHIETI" },
    { "code": "C633", "province": "FG", "name": "CHIEUTI" },
    { "code": "C634", "province": "CR", "name": "CHIEVE" },
    { "code": "C635", "province": "BG", "name": "CHIGNOLO D'ISOLA" },
    { "code": "C637", "province": "PV", "name": "CHIGNOLO PO" },
    { "code": "C636", "province": "NO", "name": "CHIGNOLO VERBANO (soppresso)" },
    { "code": "C638", "province": "VE", "name": "CHIOGGIA" },
    { "code": "C639", "province": "TO", "name": "CHIOMONTE" },
    { "code": "C640", "province": "UD", "name": "CHIONS (soppresso)" },
    { "code": "C640", "province": "PN", "name": "CHIONS" },
    { "code": "C641", "province": "UD", "name": "CHIOPRIS-VISCONE" },
    { "code": "C647", "province": "VE", "name": "CHIRIGNAGO (soppresso)" },
    { "code": "C648", "province": "AR", "name": "CHITIGNANO" },
    { "code": "C649", "province": "BG", "name": "CHIUDUNO" },
    { "code": "C650", "province": "VI", "name": "CHIUPPANO" },
    { "code": "C651", "province": "SO", "name": "CHIURO" },
    { "code": "C652", "province": "TN", "name": "CHIUSA (soppresso)" },
    { "code": "C652", "province": "BZ", "name": "CHIUSA" },
    { "code": "C652", "province": "TN", "name": "CHIUSA ALL'ISARCO (soppresso)" },
    { "code": "C653", "province": "CN", "name": "CHIUSA DI PESIO" },
    { "code": "C655", "province": "TO", "name": "CHIUSA DI SAN MICHELE" },
    { "code": "C654", "province": "PA", "name": "CHIUSA SCLAFANI" },
    { "code": "C656", "province": "UD", "name": "CHIUSAFORTE" },
    { "code": "C657", "province": "IM", "name": "CHIUSANICO" },
    { "code": "C658", "province": "AL", "name": "CHIUSANO D'ASTI (soppresso)" },
    { "code": "C658", "province": "AT", "name": "CHIUSANO D'ASTI" },
    { "code": "C659", "province": "AV", "name": "CHIUSANO DI SAN DOMENICO" },
    { "code": "C660", "province": "IM", "name": "CHIUSAVECCHIA" },
    { "code": "C661", "province": "SI", "name": "CHIUSDINO" },
    { "code": "C662", "province": "SI", "name": "CHIUSI" },
    { "code": "C663", "province": "AR", "name": "CHIUSI DELLA VERNA" },
    { "code": "C663", "province": "AR", "name": "CHIUSI IN CASENTINO (soppresso)" },
    { "code": "C665", "province": "TO", "name": "CHIVASSO" },
    { "code": "C666", "province": "TN", "name": "CHIZZOLA (soppresso)" },
    { "code": "C667", "province": "TN", "name": "CIAGO (soppresso)" },
    { "code": "C595", "province": "AO", "name": "CIAMBAVE (soppresso)" },
    { "code": "M272", "province": "RM", "name": "CIAMPINO" },
    { "code": "C668", "province": "AG", "name": "CIANCIANA" },
    { "code": "C669", "province": "RE", "name": "CIANO D'ENZA (soppresso)" },
    { "code": "C671", "province": "TN", "name": "CIARDES (soppresso)" },
    { "code": "C671", "province": "BZ", "name": "CIARDES (soppresso)" },
    { "code": "C671", "province": "TN", "name": "CIARS (soppresso)" },
    { "code": "C672", "province": "BL", "name": "CIBIANA (soppresso)" },
    { "code": "C672", "province": "BL", "name": "CIBIANA DI CADORE" },
    { "code": "C673", "province": "GE", "name": "CICAGNA" },
    { "code": "C674", "province": "CZ", "name": "CICALA" },
    { "code": "C675", "province": "CE", "name": "CICCIANO (soppresso)" },
    { "code": "C675", "province": "NA", "name": "CICCIANO" },
    { "code": "C676", "province": "SA", "name": "CICERALE" },
    { "code": "C677", "province": "RM", "name": "CICILIANO" },
    { "code": "C678", "province": "CR", "name": "CICOGNOLO" },
    { "code": "C679", "province": "TO", "name": "CICONIO" },
    { "code": "C679", "province": "AO", "name": "CICONIO (soppresso)" },
    { "code": "C680", "province": "NO", "name": "CIGLIANO (soppresso)" },
    { "code": "C680", "province": "VC", "name": "CIGLIANO" },
    { "code": "C681", "province": "CN", "name": "CIGLIE'" },
    { "code": "C682", "province": "BS", "name": "CIGNANO (soppresso)" },
    { "code": "C684", "province": "PV", "name": "CIGOGNOLA" },
    { "code": "C685", "province": "BS", "name": "CIGOLE" },
    { "code": "C686", "province": "PV", "name": "CILAVEGNA" },
    { "code": "C687", "province": "BS", "name": "CILIVERGHE (soppresso)" },
    { "code": "C688", "province": "CO", "name": "CIMA (soppresso)" },
    { "code": "C689", "province": "TV", "name": "CIMADOLMO" },
    { "code": "C690", "province": "NO", "name": "CIMAMULERA (soppresso)" },
    { "code": "C691", "province": "BS", "name": "CIMBERGO" },
    { "code": "C692", "province": "BS", "name": "CIMBERGO-PASPARDO (soppresso)" },
    { "code": "C694", "province": "TN", "name": "CIMEGO (soppresso)" },
    { "code": "C695", "province": "RC", "name": "CIMINA'" },
    { "code": "C696", "province": "PA", "name": "CIMINNA" },
    { "code": "C697", "province": "CE", "name": "CIMITILE (soppresso)" },
    { "code": "C697", "province": "NA", "name": "CIMITILE" },
    { "code": "C698", "province": "BS", "name": "CIMMO (soppresso)" },
    { "code": "C699", "province": "UD", "name": "CIMOLAIS (soppresso)" },
    { "code": "C699", "province": "PN", "name": "CIMOLAIS" },
    { "code": "C700", "province": "TN", "name": "CIMONE" },
    { "code": "C701", "province": "AL", "name": "CINAGLIO (soppresso)" },
    { "code": "C701", "province": "AT", "name": "CINAGLIO" },
    { "code": "C702", "province": "RM", "name": "CINETO ROMANO" },
    { "code": "C703", "province": "CR", "name": "CINGIA DE' BOTTI" },
    { "code": "C704", "province": "MC", "name": "CINGOLI" },
    { "code": "C705", "province": "GR", "name": "CINIGIANO" },
    { "code": "C706", "province": "MI", "name": "CINISELLO (soppresso)" },
    { "code": "C707", "province": "MI", "name": "CINISELLO BALSAMO" },
    { "code": "C708", "province": "PA", "name": "CINISI" },
    { "code": "C709", "province": "SO", "name": "CINO" },
    { "code": "C710", "province": "RC", "name": "CINQUEFRONDI" },
    { "code": "C711", "province": "TO", "name": "CINTANO" },
    { "code": "C711", "province": "AO", "name": "CINTANO (soppresso)" },
    { "code": "C712", "province": "TN", "name": "CINTE TESINO" },
    { "code": "C714", "province": "VE", "name": "CINTO CAOMAGGIORE" },
    { "code": "C713", "province": "PD", "name": "CINTO EUGANEO" },
    { "code": "C715", "province": "TO", "name": "CINZANO" },
    { "code": "C716", "province": "CE", "name": "CIORLANO" },
    { "code": "C716", "province": "CB", "name": "CIORLANO (soppresso)" },
    { "code": "C717", "province": "CS", "name": "CIPOLLINA (soppresso)" },
    { "code": "C718", "province": "IM", "name": "CIPRESSA" },
    { "code": "C719", "province": "BN", "name": "CIRCELLO" },
    { "code": "C720", "province": "GO", "name": "CIRCHINA (soppresso)" },
    { "code": "C720", "province": "UD", "name": "CIRCHINA (soppresso)" },
    { "code": "C721", "province": "NO", "name": "CIREGGIO (soppresso)" },
    { "code": "C722", "province": "TO", "name": "CIRIE'" },
    { "code": "C723", "province": "PZ", "name": "CIRIGLIANO (soppresso)" },
    { "code": "C723", "province": "MT", "name": "CIRIGLIANO" },
    { "code": "C724", "province": "CO", "name": "CIRIMIDO" },
    { "code": "C725", "province": "CZ", "name": "CIRO' (soppresso)" },
    { "code": "C725", "province": "KR", "name": "CIRO'" },
    { "code": "C726", "province": "CZ", "name": "CIRO' MARINA (soppresso)" },
    { "code": "C726", "province": "KR", "name": "CIRO' MARINA" },
    { "code": "C727", "province": "TN", "name": "CIS" },
    { "code": "C728", "province": "BG", "name": "CISANO BERGAMASCO" },
    { "code": "C729", "province": "GE", "name": "CISANO SUL NEVA (soppresso)" },
    { "code": "C729", "province": "SV", "name": "CISANO SUL NEVA" },
    { "code": "C730", "province": "BG", "name": "CISERANO" },
    { "code": "C731", "province": "UD", "name": "CISERIIS (soppresso)" },
    { "code": "C732", "province": "MI", "name": "CISLAGO (soppresso)" },
    { "code": "C732", "province": "VA", "name": "CISLAGO" },
    { "code": "C733", "province": "MI", "name": "CISLIANO" },
    { "code": "C734", "province": "VI", "name": "CISMON (soppresso)" },
    { "code": "C734", "province": "VI", "name": "CISMON DEL GRAPPA (soppresso)" },
    { "code": "C735", "province": "TV", "name": "CISON DI VALMARINO" },
    { "code": "C737", "province": "TN", "name": "CISSICO (soppresso)" },
    { "code": "C738", "province": "CN", "name": "CISSONE" },
    { "code": "C739", "province": "AL", "name": "CISTERNA D'ASTI (soppresso)" },
    { "code": "C739", "province": "AT", "name": "CISTERNA D'ASTI" },
    { "code": "C740", "province": "LT", "name": "CISTERNA DI LATINA" },
    { "code": "C740", "province": "LT", "name": "CISTERNA DI LITTORIA (soppresso)" },
    { "code": "C740", "province": "RM", "name": "CISTERNA DI ROMA (soppresso)" },
    { "code": "C740", "province": "LT", "name": "CISTERNA DI ROMA (soppresso)" },
    { "code": "C741", "province": "BA", "name": "CISTERNINO (soppresso)" },
    { "code": "C741", "province": "BR", "name": "CISTERNINO" },
    { "code": "C742", "province": "PG", "name": "CITERNA" },
    { "code": "C744", "province": "PG", "name": "CITTA' DELLA PIEVE" },
    { "code": "C745", "province": "PG", "name": "CITTA' DI CASTELLO" },
    { "code": "C750", "province": "TE", "name": "CITTA' SANT'ANGELO (soppresso)" },
    { "code": "C750", "province": "PE", "name": "CITTA' SANT'ANGELO" },
    { "code": "C743", "province": "PD", "name": "CITTADELLA" },
    { "code": "C746", "province": "AQ", "name": "CITTADUCALE (soppresso)" },
    { "code": "C746", "province": "RI", "name": "CITTADUCALE" },
    { "code": "C747", "province": "RC", "name": "CITTANOVA" },
    { "code": "C748", "province": "PL", "name": "CITTANOVA D'ISTRIA (soppresso)" },
    { "code": "C749", "province": "AQ", "name": "CITTAREALE (soppresso)" },
    { "code": "C749", "province": "RI", "name": "CITTAREALE" },
    { "code": "C751", "province": "CO", "name": "CITTIGLIO (soppresso)" },
    { "code": "C751", "province": "VA", "name": "CITTIGLIO" },
    { "code": "C752", "province": "CO", "name": "CIVATE (soppresso)" },
    { "code": "C752", "province": "LC", "name": "CIVATE" },
    { "code": "C753", "province": "CO", "name": "CIVELLO (soppresso)" },
    { "code": "C754", "province": "CO", "name": "CIVENNA (soppresso)" },
    { "code": "C755", "province": "IM", "name": "CIVEZZA" },
    { "code": "C756", "province": "TN", "name": "CIVEZZANO" },
    { "code": "C757", "province": "NO", "name": "CIVIASCO (soppresso)" },
    { "code": "C757", "province": "VC", "name": "CIVIASCO" },
    { "code": "C758", "province": "UD", "name": "CIVIDALE DEL FRIULI" },
    { "code": "C759", "province": "BG", "name": "CIVIDATE AL PIANO" },
    { "code": "C760", "province": "BS", "name": "CIVIDATE CAMUNO" },
    { "code": "C761", "province": "BS", "name": "CIVIDATE MALEGNO (soppresso)" },
    { "code": "C762", "province": "CO", "name": "CIVIGLIO (soppresso)" },
    { "code": "C763", "province": "CS", "name": "CIVITA" },
    { "code": "C765", "province": "RM", "name": "CIVITA CASTELLANA (soppresso)" },
    { "code": "C765", "province": "VT", "name": "CIVITA CASTELLANA" },
    { "code": "C766", "province": "AQ", "name": "CIVITA D'ANTINO" },
    { "code": "C767", "province": "RM", "name": "CIVITA LAVINIA (soppresso)" },
    { "code": "C764", "province": "CB", "name": "CIVITACAMPOMARANO" },
    { "code": "C768", "province": "CH", "name": "CIVITALUPARELLA" },
    { "code": "C769", "province": "CB", "name": "CIVITANOVA DEL SANNIO (soppresso)" },
    { "code": "C769", "province": "IS", "name": "CIVITANOVA DEL SANNIO" },
    { "code": "C770", "province": "MC", "name": "CIVITANOVA MARCHE" },
    { "code": "C771", "province": "TE", "name": "CIVITAQUANA (soppresso)" },
    { "code": "C771", "province": "PE", "name": "CIVITAQUANA" },
    { "code": "C773", "province": "RM", "name": "CIVITAVECCHIA" },
    { "code": "C778", "province": "AQ", "name": "CIVITELLA ALFEDENA" },
    { "code": "C779", "province": "TE", "name": "CIVITELLA CASANOVA (soppresso)" },
    { "code": "C779", "province": "PE", "name": "CIVITELLA CASANOVA" },
    { "code": "C780", "province": "RM", "name": "CIVITELLA D'AGLIANO (soppresso)" },
    { "code": "C780", "province": "VT", "name": "CIVITELLA D'AGLIANO" },
    { "code": "C781", "province": "TE", "name": "CIVITELLA DEL TRONTO" },
    { "code": "C777", "province": "FO", "name": "CIVITELLA DI ROMAGNA (soppresso)" },
    { "code": "C777", "province": "FC", "name": "CIVITELLA DI ROMAGNA" },
    { "code": "C774", "province": "AR", "name": "CIVITELLA IN VAL DI CHIANA" },
    { "code": "C776", "province": "CH", "name": "CIVITELLA MESSER RAIMONDO" },
    { "code": "C782", "province": "GR", "name": "CIVITELLA PAGANICO" },
    { "code": "C783", "province": "AQ", "name": "CIVITELLA ROVETO" },
    { "code": "C784", "province": "RM", "name": "CIVITELLA SAN PAOLO" },
    { "code": "C785", "province": "SO", "name": "CIVO" },
    { "code": "C786", "province": "BS", "name": "CIZZAGO (soppresso)" },
    { "code": "C787", "province": "CO", "name": "CLAINO CON OSTENO" },
    { "code": "C788", "province": "FU", "name": "CLANA (soppresso)" },
    { "code": "C789", "province": "BG", "name": "CLANEZZO (soppresso)" },
    { "code": "C790", "province": "UD", "name": "CLAUT (soppresso)" },
    { "code": "C790", "province": "PN", "name": "CLAUT" },
    { "code": "C791", "province": "UD", "name": "CLAUZETTO (soppresso)" },
    { "code": "C791", "province": "PN", "name": "CLAUZETTO" },
    { "code": "C792", "province": "CN", "name": "CLAVESANA" },
    { "code": "C793", "province": "TO", "name": "CLAVIERE" },
    { "code": "C793", "province": "TO", "name": "CLAVIERES (soppresso)" },
    { "code": "C794", "province": "TN", "name": "CLES" },
    { "code": "C795", "province": "CS", "name": "CLETO" },
    { "code": "C796", "province": "CO", "name": "CLIVIO (soppresso)" },
    { "code": "C796", "province": "VA", "name": "CLIVIO" },
    { "code": "C797", "province": "TN", "name": "CLOZ" },
    { "code": "C798", "province": "BS", "name": "CLUSANE SUL LAGO (soppresso)" },
    { "code": "C799", "province": "TN", "name": "CLUSIO (soppresso)" },
    { "code": "C799", "province": "BZ", "name": "CLUSIO (soppresso)" },
    { "code": "C800", "province": "BG", "name": "CLUSONE" },
    { "code": "C801", "province": "TO", "name": "COASSOLO TORINESE" },
    { "code": "C803", "province": "TO", "name": "COAZZE" },
    { "code": "C804", "province": "AL", "name": "COAZZOLO (soppresso)" },
    { "code": "C804", "province": "AT", "name": "COAZZOLO" },
    { "code": "C805", "province": "UD", "name": "COBBIA (soppresso)" },
    { "code": "C805", "province": "GO", "name": "COBBIA (soppresso)" },
    { "code": "C805", "province": "GO", "name": "COBILAGLAVA (soppresso)" },
    { "code": "C805", "province": "UD", "name": "COBILAGLAVA (soppresso)" },
    { "code": "C806", "province": "BS", "name": "COCCAGLIO" },
    { "code": "C807", "province": "AL", "name": "COCCONATO (soppresso)" },
    { "code": "C807", "province": "AT", "name": "COCCONATO" },
    { "code": "C809", "province": "CO", "name": "COCQUIO (soppresso)" },
    { "code": "C809", "province": "VA", "name": "COCQUIO (soppresso)" },
    { "code": "C810", "province": "VA", "name": "COCQUIO-TREVISAGO" },
    { "code": "C811", "province": "AQ", "name": "COCULLO" },
    { "code": "C812", "province": "PD", "name": "CODEVIGO" },
    { "code": "C813", "province": "PV", "name": "CODEVILLA" },
    { "code": "C814", "province": "FE", "name": "CODIGORO" },
    { "code": "C815", "province": "TV", "name": "CODOGNE'" },
    { "code": "C816", "province": "MI", "name": "CODOGNO (soppresso)" },
    { "code": "C816", "province": "LO", "name": "CODOGNO" },
    { "code": "C817", "province": "UD", "name": "CODROIPO" },
    { "code": "C818", "province": "SS", "name": "CODRONGIANOS" },
    { "code": "C819", "province": "NO", "name": "COGGIOLA (soppresso)" },
    { "code": "C819", "province": "VC", "name": "COGGIOLA (soppresso)" },
    { "code": "C819", "province": "BI", "name": "COGGIOLA" },
    { "code": "C820", "province": "MI", "name": "COGLIATE (soppresso)" },
    { "code": "C820", "province": "MB", "name": "COGLIATE" },
    { "code": "C821", "province": "TO", "name": "COGNE (soppresso)" },
    { "code": "C821", "province": "AO", "name": "COGNE" },
    { "code": "C822", "province": "TN", "name": "COGNOLA (soppresso)" },
    { "code": "C823", "province": "GE", "name": "COGOLETO" },
    { "code": "C823", "province": "SV", "name": "COGOLETO (soppresso)" },
    { "code": "C824", "province": "VI", "name": "COGOLLO (soppresso)" },
    { "code": "C824", "province": "VI", "name": "COGOLLO DEL CENGIO" },
    { "code": "C825", "province": "TN", "name": "COGOLO (soppresso)" },
    { "code": "C826", "province": "GE", "name": "COGORNO" },
    { "code": "C827", "province": "NO", "name": "COIMO (soppresso)" },
    { "code": "C828", "province": "NO", "name": "COIROMONTE (soppresso)" },
    { "code": "C834", "province": "IM", "name": "COL DI RODI (soppresso)" },
    { "code": "C906", "province": "TO", "name": "COL SAN GIOVANNI (soppresso)" },
    { "code": "C829", "province": "NO", "name": "COLAZZA" },
    { "code": "C830", "province": "PS", "name": "COLBORDOLO (soppresso)" },
    { "code": "C830", "province": "PU", "name": "COLBORDOLO (soppresso)" },
    { "code": "C831", "province": "AL", "name": "COLCAVAGNO (soppresso)" },
    { "code": "C831", "province": "AT", "name": "COLCAVAGNO (soppresso)" },
    { "code": "M426", "province": "VI", "name": "COLCERESA" },
    { "code": "C832", "province": "CO", "name": "COLCIAGO (soppresso)" },
    { "code": "C833", "province": "TN", "name": "COLDERANO (soppresso)" },
    { "code": "C833", "province": "TN", "name": "COLDRANO (soppresso)" },
    { "code": "C833", "province": "BZ", "name": "COLDRANO (soppresso)" },
    { "code": "C835", "province": "BG", "name": "COLERE" },
    { "code": "C836", "province": "CE", "name": "COLFELICE (soppresso)" },
    { "code": "C836", "province": "FR", "name": "COLFELICE" },
    { "code": "C837", "province": "TN", "name": "COLFOSCO (soppresso)" },
    { "code": "C838", "province": "PC", "name": "COLI" },
    { "code": "C839", "province": "CO", "name": "COLICO (soppresso)" },
    { "code": "C839", "province": "LC", "name": "COLICO" },
    { "code": "C840", "province": "RE", "name": "COLLAGNA (soppresso)" },
    { "code": "C841", "province": "PG", "name": "COLLALTO SABINO (soppresso)" },
    { "code": "C841", "province": "RM", "name": "COLLALTO SABINO (soppresso)" },
    { "code": "C841", "province": "RI", "name": "COLLALTO SABINO" },
    { "code": "C844", "province": "AQ", "name": "COLLARMELE" },
    { "code": "C845", "province": "PG", "name": "COLLAZZONE" },
    { "code": "C851", "province": "CO", "name": "COLLE BRIANZA (soppresso)" },
    { "code": "C851", "province": "LC", "name": "COLLE BRIANZA" },
    { "code": "C854", "province": "CB", "name": "COLLE D'ANCHISE" },
    { "code": "C857", "province": "RI", "name": "COLLE DI TORA" },
    { "code": "C847", "province": "SI", "name": "COLLE DI VAL D'ELSA" },
    { "code": "C861", "province": "TN", "name": "COLLE IN CASIES (soppresso)" },
    { "code": "C861", "province": "BZ", "name": "COLLE IN CASIES (soppresso)" },
    { "code": "B145", "province": "TN", "name": "COLLE ISARCO (soppresso)" },
    { "code": "B145", "province": "BZ", "name": "COLLE ISARCO (soppresso)" },
    { "code": "C870", "province": "CE", "name": "COLLE SAN MAGNO (soppresso)" },
    { "code": "C870", "province": "FR", "name": "COLLE SAN MAGNO" },
    { "code": "C846", "province": "BN", "name": "COLLE SANNITA" },
    { "code": "C872", "province": "BL", "name": "COLLE SANTA LUCIA" },
    { "code": "C848", "province": "TV", "name": "COLLE UMBERTO" },
    { "code": "C850", "province": "BS", "name": "COLLEBEATO" },
    { "code": "C852", "province": "PR", "name": "COLLECCHIO" },
    { "code": "C853", "province": "TE", "name": "COLLECORVINO (soppresso)" },
    { "code": "C853", "province": "PE", "name": "COLLECORVINO" },
    { "code": "C311", "province": "TE", "name": "COLLEDARA" },
    { "code": "C855", "province": "CH", "name": "COLLEDIMACINE" },
    { "code": "C856", "province": "CH", "name": "COLLEDIMEZZO" },
    { "code": "C858", "province": "RM", "name": "COLLEFERRO" },
    { "code": "C859", "province": "PG", "name": "COLLEGIOVE (soppresso)" },
    { "code": "C859", "province": "RM", "name": "COLLEGIOVE (soppresso)" },
    { "code": "C859", "province": "RI", "name": "COLLEGIOVE" },
    { "code": "C860", "province": "TO", "name": "COLLEGNO" },
    { "code": "C862", "province": "AQ", "name": "COLLELONGO" },
    { "code": "C864", "province": "RM", "name": "COLLEPARDO (soppresso)" },
    { "code": "C864", "province": "FR", "name": "COLLEPARDO" },
    { "code": "C865", "province": "LE", "name": "COLLEPASSO" },
    { "code": "C866", "province": "AQ", "name": "COLLEPIETRO" },
    { "code": "C867", "province": "TO", "name": "COLLERETTO CASTELNUOVO" },
    { "code": "C867", "province": "AO", "name": "COLLERETTO CASTELNUOVO (soppresso)" },
    { "code": "C868", "province": "TO", "name": "COLLERETTO GIACOSA" },
    { "code": "C868", "province": "TO", "name": "COLLERETTO PARELLA (soppresso)" },
    { "code": "C868", "province": "AO", "name": "COLLERETTO PARELLA (soppresso)" },
    { "code": "C869", "province": "PI", "name": "COLLESALVETTI (soppresso)" },
    { "code": "C869", "province": "LI", "name": "COLLESALVETTI" },
    { "code": "C871", "province": "PA", "name": "COLLESANO" },
    { "code": "C873", "province": "PG", "name": "COLLESCIPOLI (soppresso)" },
    { "code": "C873", "province": "TR", "name": "COLLESCIPOLI (soppresso)" },
    { "code": "C874", "province": "PG", "name": "COLLESTATTE (soppresso)" },
    { "code": "C874", "province": "TR", "name": "COLLESTATTE (soppresso)" },
    { "code": "C875", "province": "CB", "name": "COLLETORTO" },
    { "code": "C876", "province": "PG", "name": "COLLEVECCHIO (soppresso)" },
    { "code": "C876", "province": "RM", "name": "COLLEVECCHIO (soppresso)" },
    { "code": "C876", "province": "RI", "name": "COLLEVECCHIO" },
    { "code": "C878", "province": "CB", "name": "COLLI A VOLTURNO (soppresso)" },
    { "code": "C878", "province": "IS", "name": "COLLI A VOLTURNO" },
    { "code": "M380", "province": "PU", "name": "COLLI AL METAURO" },
    { "code": "C877", "province": "AP", "name": "COLLI DEL TRONTO" },
    { "code": "C880", "province": "RI", "name": "COLLI DI LABRO (soppresso)" },
    { "code": "C881", "province": "TN", "name": "COLLI IN PUSTERIA (soppresso)" },
    { "code": "C881", "province": "BZ", "name": "COLLI IN PUSTERIA (soppresso)" },
    { "code": "C880", "province": "RI", "name": "COLLI SUL VELINO" },
    { "code": "M419", "province": "PV", "name": "COLLI VERDI" },
    { "code": "C879", "province": "SA", "name": "COLLIANO" },
    { "code": "C882", "province": "CA", "name": "COLLINAS (soppresso)" },
    { "code": "C882", "province": "VS", "name": "COLLINAS (soppresso)" },
    { "code": "C882", "province": "SU", "name": "COLLINAS" },
    { "code": "C883", "province": "BS", "name": "COLLIO" },
    { "code": "C884", "province": "NO", "name": "COLLOBIANO (soppresso)" },
    { "code": "C884", "province": "VC", "name": "COLLOBIANO" },
    { "code": "C885", "province": "UD", "name": "COLLOREDO DI MONTE ALBANO" },
    { "code": "C886", "province": "MC", "name": "COLMURANO" },
    { "code": "C888", "province": "PZ", "name": "COLOBRARO (soppresso)" },
    { "code": "C888", "province": "MT", "name": "COLOBRARO" },
    { "code": "C889", "province": "CO", "name": "COLOGNA (soppresso)" },
    { "code": "C892", "province": "TN", "name": "COLOGNA IN GIUDICARIE (soppresso)" },
    { "code": "C890", "province": "VR", "name": "COLOGNA VENETA" },
    { "code": "C891", "province": "TN", "name": "COLOGNA-GAVAZZO (soppresso)" },
    { "code": "C893", "province": "BS", "name": "COLOGNE" },
    { "code": "C894", "province": "BG", "name": "COLOGNO AL SERIO" },
    { "code": "C895", "province": "MI", "name": "COLOGNO MONZESE" },
    { "code": "C897", "province": "VR", "name": "COLOGNOLA AI COLLI" },
    { "code": "C896", "province": "BG", "name": "COLOGNOLA DEL PIANO (soppresso)" },
    { "code": "C898", "province": "BS", "name": "COLOMBARO (soppresso)" },
    { "code": "C900", "province": "RM", "name": "COLONNA" },
    { "code": "C901", "province": "TE", "name": "COLONNELLA" },
    { "code": "C902", "province": "CO", "name": "COLONNO" },
    { "code": "C903", "province": "SO", "name": "COLORINA" },
    { "code": "C904", "province": "PR", "name": "COLORNO" },
    { "code": "C905", "province": "CS", "name": "COLOSIMI" },
    { "code": "C907", "province": "TN", "name": "COLSANO (soppresso)" },
    { "code": "C907", "province": "BZ", "name": "COLSANO (soppresso)" },
    { "code": "C908", "province": "MI", "name": "COLTURANO" },
    { "code": "M336", "province": "CO", "name": "COLVERDE" },
    { "code": "C910", "province": "BG", "name": "COLZATE" },
    { "code": "C911", "province": "CO", "name": "COMABBIO (soppresso)" },
    { "code": "C911", "province": "VA", "name": "COMABBIO" },
    { "code": "C912", "province": "FE", "name": "COMACCHIO" },
    { "code": "C913", "province": "PV", "name": "COMAIRANO (soppresso)" },
    { "code": "C914", "province": "MS", "name": "COMANO" },
    { "code": "C915", "province": "TN", "name": "COMANO (soppresso)" },
    { "code": "M314", "province": "TN", "name": "COMANO TERME" },
    { "code": "C916", "province": "TN", "name": "COMASINE (soppresso)" },
    { "code": "C917", "province": "MI", "name": "COMAZZO (soppresso)" },
    { "code": "C917", "province": "LO", "name": "COMAZZO" },
    { "code": "C918", "province": "UD", "name": "COMEGLIANS" },
    { "code": "C920", "province": "BL", "name": "COMELICO SUPERIORE" },
    { "code": "C921", "province": "GO", "name": "COMEN (soppresso)" },
    { "code": "C921", "province": "UD", "name": "COMEN (soppresso)" },
    { "code": "C921", "province": "UD", "name": "COMENO (soppresso)" },
    { "code": "C921", "province": "GO", "name": "COMENO (soppresso)" },
    { "code": "C922", "province": "CO", "name": "COMERIO (soppresso)" },
    { "code": "C922", "province": "VA", "name": "COMERIO" },
    { "code": "C923", "province": "BS", "name": "COMERO (soppresso)" },
    { "code": "C924", "province": "BS", "name": "COMEZZANO (soppresso)" },
    { "code": "C925", "province": "BS", "name": "COMEZZANO-CIZZAGO" },
    { "code": "C926", "province": "NO", "name": "COMIGNAGO" },
    { "code": "C927", "province": "SR", "name": "COMISO (soppresso)" },
    { "code": "C927", "province": "RG", "name": "COMISO" },
    { "code": "C928", "province": "AG", "name": "COMITINI" },
    { "code": "C929", "province": "CE", "name": "COMIZIANO (soppresso)" },
    { "code": "C929", "province": "NA", "name": "COMIZIANO" },
    { "code": "C930", "province": "MN", "name": "COMMESSAGGIO" },
    { "code": "C931", "province": "TN", "name": "COMMEZZADURA" },
    { "code": "C932", "province": "NO", "name": "COMNAGO (soppresso)" },
    { "code": "C933", "province": "CO", "name": "COMO" },
    { "code": "C934", "province": "PR", "name": "COMPIANO" },
    { "code": "C937", "province": "BG", "name": "COMUN NUOVO" },
    { "code": "C935", "province": "AP", "name": "COMUNANZA" },
    { "code": "C935", "province": "AP", "name": "COMUNANZA DEL LITTORIO (soppresso)" },
    { "code": "C936", "province": "CO", "name": "COMUNE DELLA VALSOLDA (soppresso)" },
    { "code": "C938", "province": "VE", "name": "CONA" },
    { "code": "C941", "province": "CB", "name": "CONCA CASALE (soppresso)" },
    { "code": "C941", "province": "IS", "name": "CONCA CASALE" },
    { "code": "C940", "province": "SA", "name": "CONCA DEI MARINI" },
    { "code": "C939", "province": "CE", "name": "CONCA DELLA CAMPANIA" },
    { "code": "C939", "province": "NA", "name": "CONCA DELLA CAMPANIA (soppresso)" },
    { "code": "C942", "province": "RO", "name": "CONCADIRAME (soppresso)" },
    { "code": "C943", "province": "VR", "name": "CONCAMARISE" },
    { "code": "C944", "province": "TN", "name": "CONCEI (soppresso)" },
    { "code": "C945", "province": "CO", "name": "CONCENEDO (soppresso)" },
    { "code": "C946", "province": "PG", "name": "CONCERVIANO (soppresso)" },
    { "code": "C946", "province": "RM", "name": "CONCERVIANO (soppresso)" },
    { "code": "C946", "province": "RI", "name": "CONCERVIANO" },
    { "code": "C948", "province": "BS", "name": "CONCESIO" },
    { "code": "C949", "province": "VI", "name": "CONCO (soppresso)" },
    { "code": "C950", "province": "VE", "name": "CONCORDIA SAGITARIA (soppresso)" },
    { "code": "C950", "province": "VE", "name": "CONCORDIA SAGITTARIA" },
    { "code": "C951", "province": "MO", "name": "CONCORDIA SULLA SECCHIA" },
    { "code": "C952", "province": "MI", "name": "CONCOREZZO (soppresso)" },
    { "code": "C952", "province": "MB", "name": "CONCOREZZO" },
    { "code": "C953", "province": "TN", "name": "CONDINO (soppresso)" },
    { "code": "C954", "province": "RC", "name": "CONDOFURI" },
    { "code": "C955", "province": "TO", "name": "CONDOVE" },
    { "code": "C956", "province": "ME", "name": "CONDRO'" },
    { "code": "C957", "province": "TV", "name": "CONEGLIANO" },
    { "code": "C958", "province": "PV", "name": "CONFIENZA" },
    { "code": "C959", "province": "PG", "name": "CONFIGNI (soppresso)" },
    { "code": "C959", "province": "RM", "name": "CONFIGNI (soppresso)" },
    { "code": "C959", "province": "RI", "name": "CONFIGNI" },
    { "code": "C960", "province": "CZ", "name": "CONFLENTI" },
    { "code": "C961", "province": "IM", "name": "CONIO (soppresso)" },
    { "code": "C962", "province": "AL", "name": "CONIOLO" },
    { "code": "C963", "province": "RA", "name": "CONSELICE" },
    { "code": "C964", "province": "PD", "name": "CONSELVE" },
    { "code": "C965", "province": "CO", "name": "CONSIGLIO DI RUMO (soppresso)" },
    { "code": "C966", "province": "CO", "name": "CONSONNO (soppresso)" },
    { "code": "M356", "province": "TN", "name": "CONTA'" },
    { "code": "C967", "province": "RO", "name": "CONTARINA (soppresso)" },
    { "code": "C968", "province": "PA", "name": "CONTESSA ENTELLINA" },
    { "code": "C969", "province": "PG", "name": "CONTIGLIANO (soppresso)" },
    { "code": "C969", "province": "RM", "name": "CONTIGLIANO (soppresso)" },
    { "code": "C969", "province": "RI", "name": "CONTIGLIANO" },
    { "code": "C970", "province": "CO", "name": "CONTRA (soppresso)" },
    { "code": "C971", "province": "AV", "name": "CONTRADA" },
    { "code": "C972", "province": "TE", "name": "CONTROGUERRA" },
    { "code": "C973", "province": "SA", "name": "CONTRONE" },
    { "code": "C974", "province": "SA", "name": "CONTURSI (soppresso)" },
    { "code": "C974", "province": "SA", "name": "CONTURSI TERME" },
    { "code": "C975", "province": "BA", "name": "CONVERSANO" },
    { "code": "C976", "province": "AV", "name": "CONZA DELLA CAMPANIA" },
    { "code": "C977", "province": "AL", "name": "CONZANO" },
    { "code": "C978", "province": "LE", "name": "COPERTINO" },
    { "code": "C979", "province": "PV", "name": "COPIANO" },
    { "code": "C980", "province": "FE", "name": "COPPARO" },
    { "code": "C982", "province": "PV", "name": "CORANA" },
    { "code": "C983", "province": "BA", "name": "CORATO" },
    { "code": "C984", "province": "SA", "name": "CORBARA" },
    { "code": "C986", "province": "MI", "name": "CORBETTA" },
    { "code": "C987", "province": "RO", "name": "CORBOLA" },
    { "code": "C988", "province": "RM", "name": "CORCHIANO (soppresso)" },
    { "code": "C988", "province": "VT", "name": "CORCHIANO" },
    { "code": "C989", "province": "NO", "name": "CORCIAGO (soppresso)" },
    { "code": "C990", "province": "PG", "name": "CORCIANO" },
    { "code": "C991", "province": "UD", "name": "CORDENONS (soppresso)" },
    { "code": "C991", "province": "PN", "name": "CORDENONS" },
    { "code": "C992", "province": "TV", "name": "CORDIGNANO" },
    { "code": "C993", "province": "UD", "name": "CORDOVADO (soppresso)" },
    { "code": "C993", "province": "PN", "name": "CORDOVADO" },
    { "code": "C994", "province": "TN", "name": "COREDO (soppresso)" },
    { "code": "C996", "province": "LU", "name": "COREGLIA ANTELMINELLI" },
    { "code": "C995", "province": "GE", "name": "COREGLIA LIGURE" },
    { "code": "C997", "province": "CO", "name": "CORENNO PLINIO (soppresso)" },
    { "code": "C998", "province": "CE", "name": "CORENO AUSONIO (soppresso)" },
    { "code": "C998", "province": "FR", "name": "CORENO AUSONIO" },
    { "code": "C999", "province": "AQ", "name": "CORFINIO" },
    { "code": "D002", "province": "TS", "name": "CORGNALE (soppresso)" },
    { "code": "D003", "province": "RM", "name": "CORI (soppresso)" },
    { "code": "D003", "province": "LT", "name": "CORI" },
    { "code": "D004", "province": "FO", "name": "CORIANO (soppresso)" },
    { "code": "D004", "province": "RN", "name": "CORIANO" },
    { "code": "D005", "province": "CS", "name": "CORIGLIANO CALABRO (soppresso)" },
    { "code": "D006", "province": "LE", "name": "CORIGLIANO D'OTRANTO" },
    { "code": "M403", "province": "CS", "name": "CORIGLIANO-ROSSANO" },
    { "code": "D007", "province": "AN", "name": "CORINALDO" },
    { "code": "D008", "province": "TO", "name": "CORIO" },
    { "code": "D009", "province": "PA", "name": "CORLEONE" },
    { "code": "D011", "province": "SA", "name": "CORLETO MONFORTE" },
    { "code": "D010", "province": "PZ", "name": "CORLETO PERTICARA" },
    { "code": "D012", "province": "AO", "name": "CORMAIORE (soppresso)" },
    { "code": "D013", "province": "MI", "name": "CORMANO" },
    { "code": "D014", "province": "GO", "name": "CORMONS" },
    { "code": "D014", "province": "UD", "name": "CORMONS (soppresso)" },
    { "code": "D015", "province": "BG", "name": "CORNA IMAGNA" },
    { "code": "D016", "province": "BG", "name": "CORNALBA" },
    { "code": "D017", "province": "PV", "name": "CORNALE (soppresso)" },
    { "code": "M338", "province": "PV", "name": "CORNALE E BASTIDA" },
    { "code": "D018", "province": "MI", "name": "CORNAREDO" },
    { "code": "D019", "province": "MI", "name": "CORNATE (soppresso)" },
    { "code": "D019", "province": "MI", "name": "CORNATE D'ADDA (soppresso)" },
    { "code": "D019", "province": "MB", "name": "CORNATE D'ADDA" },
    { "code": "D020", "province": "VI", "name": "CORNEDO (soppresso)" },
    { "code": "B799", "province": "TN", "name": "CORNEDO (soppresso)" },
    { "code": "B799", "province": "BZ", "name": "CORNEDO (soppresso)" },
    { "code": "B799", "province": "BZ", "name": "CORNEDO ALL'ISARCO" },
    { "code": "D020", "province": "VI", "name": "CORNEDO VICENTINO" },
    { "code": "D021", "province": "MI", "name": "CORNEGLIANO LAUDENSE (soppresso)" },
    { "code": "D021", "province": "LO", "name": "CORNEGLIANO LAUDENSE" },
    { "code": "D022", "province": "CN", "name": "CORNELIANO D'ALBA" },
    { "code": "D024", "province": "RM", "name": "CORNETO TARQUINIA (soppresso)" },
    { "code": "D025", "province": "GE", "name": "CORNIGLIANO LIGURE (soppresso)" },
    { "code": "D026", "province": "PR", "name": "CORNIGLIO" },
    { "code": "D027", "province": "UD", "name": "CORNO DI ROSAZZO" },
    { "code": "D028", "province": "MI", "name": "CORNO GIOVINE (soppresso)" },
    { "code": "D028", "province": "LO", "name": "CORNO GIOVINE" },
    { "code": "D029", "province": "MI", "name": "CORNOVECCHIO (soppresso)" },
    { "code": "D029", "province": "LO", "name": "CORNOVECCHIO" },
    { "code": "D030", "province": "TV", "name": "CORNUDA" },
    { "code": "D031", "province": "GO", "name": "CORONA (soppresso)" },
    { "code": "D031", "province": "UD", "name": "CORONA (soppresso)" },
    { "code": "D032", "province": "TN", "name": "CORONA ALLA MUTA (soppresso)" },
    { "code": "D037", "province": "RE", "name": "CORREGGIO" },
    { "code": "D038", "province": "MI", "name": "CORREZZANA (soppresso)" },
    { "code": "D038", "province": "MB", "name": "CORREZZANA" },
    { "code": "D039", "province": "VR", "name": "CORREZZO (soppresso)" },
    { "code": "D040", "province": "PD", "name": "CORREZZOLA" },
    { "code": "D041", "province": "CO", "name": "CORRIDO" },
    { "code": "D042", "province": "MC", "name": "CORRIDONIA" },
    { "code": "D043", "province": "TE", "name": "CORROPOLI" },
    { "code": "D044", "province": "LE", "name": "CORSANO" },
    { "code": "D045", "province": "MI", "name": "CORSICO" },
    { "code": "D046", "province": "AL", "name": "CORSIONE (soppresso)" },
    { "code": "D046", "province": "AT", "name": "CORSIONE" },
    { "code": "D047", "province": "CO", "name": "CORTABBIO (soppresso)" },
    { "code": "D048", "province": "TN", "name": "CORTACCIA (soppresso)" },
    { "code": "D048", "province": "BZ", "name": "CORTACCIA (soppresso)" },
    { "code": "D048", "province": "BZ", "name": "CORTACCIA SULLA STRADA DEL VINO" },
    { "code": "D049", "province": "CZ", "name": "CORTALE" },
    { "code": "D050", "province": "AL", "name": "CORTANDONE (soppresso)" },
    { "code": "D050", "province": "AT", "name": "CORTANDONE" },
    { "code": "D051", "province": "AL", "name": "CORTANZE (soppresso)" },
    { "code": "D051", "province": "AT", "name": "CORTANZE" },
    { "code": "D052", "province": "AL", "name": "CORTAZZONE (soppresso)" },
    { "code": "D052", "province": "AT", "name": "CORTAZZONE" },
    { "code": "D053", "province": "BG", "name": "CORTE (soppresso)" },
    { "code": "D054", "province": "PV", "name": "CORTE BRUGNATELLA (soppresso)" },
    { "code": "D054", "province": "PC", "name": "CORTE BRUGNATELLA" },
    { "code": "D056", "province": "CR", "name": "CORTE DE' CORTESI CON CIGNONE" },
    { "code": "D057", "province": "CR", "name": "CORTE DE' FRATI" },
    { "code": "D058", "province": "BS", "name": "CORTE FRANCA" },
    { "code": "D059", "province": "TN", "name": "CORTE IN PUSTERIA (soppresso)" },
    { "code": "D068", "province": "MI", "name": "CORTE PALASIO (soppresso)" },
    { "code": "D068", "province": "LO", "name": "CORTE PALASIO" },
    { "code": "D061", "province": "PC", "name": "CORTEMAGGIORE" },
    { "code": "D062", "province": "CN", "name": "CORTEMILIA" },
    { "code": "D063", "province": "BS", "name": "CORTENEDOLO (soppresso)" },
    { "code": "D064", "province": "BS", "name": "CORTENO (soppresso)" },
    { "code": "D064", "province": "BS", "name": "CORTENO GOLGI" },
    { "code": "D065", "province": "CO", "name": "CORTENOVA (soppresso)" },
    { "code": "D065", "province": "LC", "name": "CORTENOVA" },
    { "code": "D066", "province": "BG", "name": "CORTENUOVA" },
    { "code": "D067", "province": "PV", "name": "CORTEOLONA (soppresso)" },
    { "code": "M372", "province": "PV", "name": "CORTEOLONA E GENZONE" },
    { "code": "D069", "province": "AL", "name": "CORTERANZO (soppresso)" },
    { "code": "D059", "province": "TN", "name": "CORTI IN PUSTERIA (soppresso)" },
    { "code": "D059", "province": "BZ", "name": "CORTI IN PUSTERIA (soppresso)" },
    { "code": "D073", "province": "BS", "name": "CORTICELLE PIEVE (soppresso)" },
    { "code": "D072", "province": "AL", "name": "CORTIGLIONE (soppresso)" },
    { "code": "D072", "province": "AT", "name": "CORTIGLIONE" },
    { "code": "D074", "province": "PR", "name": "CORTILE SAN MARTINO (soppresso)" },
    { "code": "D075", "province": "TN", "name": "CORTINA ALL'ADIGE (soppresso)" },
    { "code": "D075", "province": "BZ", "name": "CORTINA ALL'ADIGE (soppresso)" },
    { "code": "A266", "province": "BL", "name": "CORTINA D'AMPEZZO" },
    { "code": "D075", "province": "BZ", "name": "CORTINA SULLA STRADA DEL VINO" },
    { "code": "D076", "province": "TE", "name": "CORTINO" },
    { "code": "D077", "province": "AR", "name": "CORTONA" },
    { "code": "D078", "province": "TE", "name": "CORVARA (soppresso)" },
    { "code": "D078", "province": "PE", "name": "CORVARA" },
    { "code": "D079", "province": "TN", "name": "CORVARA IN BADIA (soppresso)" },
    { "code": "D079", "province": "BZ", "name": "CORVARA IN BADIA" },
    { "code": "D080", "province": "TN", "name": "CORVARA IN PASSIRIA (soppresso)" },
    { "code": "D080", "province": "BZ", "name": "CORVARA IN PASSIRIA (soppresso)" },
    { "code": "D081", "province": "PV", "name": "CORVINO SAN QUIRICO" },
    { "code": "D082", "province": "BS", "name": "CORZANO" },
    { "code": "D083", "province": "TN", "name": "CORZES (soppresso)" },
    { "code": "D083", "province": "BZ", "name": "CORZES (soppresso)" },
    { "code": "D084", "province": "GO", "name": "COSBANA (soppresso)" },
    { "code": "D084", "province": "UD", "name": "COSBANA (soppresso)" },
    { "code": "D084", "province": "UD", "name": "COSBANA DEL COLLIO (soppresso)" },
    { "code": "D084", "province": "GO", "name": "COSBANA DEL COLLIO (soppresso)" },
    { "code": "D085", "province": "UD", "name": "COSEANO" },
    { "code": "D086", "province": "CS", "name": "COSENZA" },
    { "code": "D087", "province": "IM", "name": "COSIO D'ARROSCIA" },
    { "code": "D088", "province": "SO", "name": "COSIO VALTELLINO" },
    { "code": "D089", "province": "RC", "name": "COSOLETO" },
    { "code": "D090", "province": "TS", "name": "COSSANA (soppresso)" },
    { "code": "D093", "province": "CN", "name": "COSSANO BELBO" },
    { "code": "D092", "province": "TO", "name": "COSSANO CANAVESE" },
    { "code": "D092", "province": "AO", "name": "COSSANO CANAVESE (soppresso)" },
    { "code": "D094", "province": "NO", "name": "COSSATO (soppresso)" },
    { "code": "D094", "province": "VC", "name": "COSSATO (soppresso)" },
    { "code": "D094", "province": "BI", "name": "COSSATO" },
    { "code": "D095", "province": "GE", "name": "COSSERIA (soppresso)" },
    { "code": "D095", "province": "SV", "name": "COSSERIA" },
    { "code": "D096", "province": "AP", "name": "COSSIGNANO" },
    { "code": "D097", "province": "NO", "name": "COSSILA (soppresso)" },
    { "code": "D097", "province": "VC", "name": "COSSILA (soppresso)" },
    { "code": "D098", "province": "BS", "name": "COSSIRANO (soppresso)" },
    { "code": "D099", "province": "NO", "name": "COSSOGNO (soppresso)" },
    { "code": "D099", "province": "VB", "name": "COSSOGNO" },
    { "code": "D100", "province": "SS", "name": "COSSOINE" },
    { "code": "D101", "province": "AL", "name": "COSSOMBRATO (soppresso)" },
    { "code": "D101", "province": "AT", "name": "COSSOMBRATO" },
    { "code": "D109", "province": "PV", "name": "COSTA DE' NOBILI" },
    { "code": "D110", "province": "BG", "name": "COSTA DI MEZZATE" },
    { "code": "D110", "province": "BG", "name": "COSTA DI MONTICELLI (soppresso)" },
    { "code": "D105", "province": "RO", "name": "COSTA DI ROVIGO" },
    { "code": "D104", "province": "IM", "name": "COSTA D'ONEGLIA (soppresso)" },
    { "code": "D112", "province": "CO", "name": "COSTA MASNAGA (soppresso)" },
    { "code": "D112", "province": "LC", "name": "COSTA MASNAGA" },
    { "code": "D111", "province": "BG", "name": "COSTA SERINA" },
    { "code": "D103", "province": "BG", "name": "COSTA VALLE IMAGNA" },
    { "code": "D102", "province": "AL", "name": "COSTA VESCOVATO" },
    { "code": "D117", "province": "BG", "name": "COSTA VOLPINO" },
    { "code": "D107", "province": "VI", "name": "COSTABISSARA" },
    { "code": "D108", "province": "PG", "name": "COSTACCIARO" },
    { "code": "D113", "province": "NO", "name": "COSTANZANA (soppresso)" },
    { "code": "D113", "province": "VC", "name": "COSTANZANA" },
    { "code": "D114", "province": "IM", "name": "COSTARAINERA" },
    { "code": "D116", "province": "TN", "name": "COSTASAVINA (soppresso)" },
    { "code": "D118", "province": "VR", "name": "COSTERMANO (soppresso)" },
    { "code": "D118", "province": "VR", "name": "COSTERMANO SUL GARDA" },
    { "code": "D119", "province": "AL", "name": "COSTIGLIOLE D'ASTI (soppresso)" },
    { "code": "D119", "province": "AT", "name": "COSTIGLIOLE D'ASTI" },
    { "code": "D120", "province": "CN", "name": "COSTIGLIOLE SALUZZO" },
    { "code": "D121", "province": "RA", "name": "COTIGNOLA" },
    { "code": "D122", "province": "CZ", "name": "COTRONE (soppresso)" },
    { "code": "D123", "province": "CZ", "name": "COTRONEI (soppresso)" },
    { "code": "D123", "province": "KR", "name": "COTRONEI" },
    { "code": "D124", "province": "PG", "name": "COTTANELLO (soppresso)" },
    { "code": "D124", "province": "RM", "name": "COTTANELLO (soppresso)" },
    { "code": "D124", "province": "RI", "name": "COTTANELLO" },
    { "code": "D012", "province": "TO", "name": "COURMAYEUR (soppresso)" },
    { "code": "D012", "province": "AO", "name": "COURMAYEUR" },
    { "code": "C401", "province": "TN", "name": "COVELANO (soppresso)" },
    { "code": "C401", "province": "BZ", "name": "COVELANO (soppresso)" },
    { "code": "D125", "province": "TN", "name": "COVELO (soppresso)" },
    { "code": "D126", "province": "BG", "name": "COVO" },
    { "code": "D127", "province": "PV", "name": "COZZO" },
    { "code": "D128", "province": "PZ", "name": "CRACO (soppresso)" },
    { "code": "D128", "province": "MT", "name": "CRACO" },
    { "code": "D130", "province": "NO", "name": "CRANA GATTUGNO (soppresso)" },
    { "code": "D131", "province": "CO", "name": "CRANDOLA (soppresso)" },
    { "code": "D131", "province": "CO", "name": "CRANDOLA VALSASSINA (soppresso)" },
    { "code": "D131", "province": "LC", "name": "CRANDOLA VALSASSINA" },
    { "code": "D132", "province": "NO", "name": "CRAVAGLIANA (soppresso)" },
    { "code": "D132", "province": "VC", "name": "CRAVAGLIANA" },
    { "code": "D133", "province": "CN", "name": "CRAVANZANA" },
    { "code": "D134", "province": "NO", "name": "CRAVEGGIA (soppresso)" },
    { "code": "D134", "province": "VB", "name": "CRAVEGGIA" },
    { "code": "D135", "province": "NO", "name": "CRAVEGNA (soppresso)" },
    { "code": "D136", "province": "VI", "name": "CREAZZO" },
    { "code": "D137", "province": "CH", "name": "CRECCHIO" },
    { "code": "D138", "province": "GO", "name": "CREDA (soppresso)" },
    { "code": "D138", "province": "UD", "name": "CREDA (soppresso)" },
    { "code": "D139", "province": "BG", "name": "CREDARO" },
    { "code": "D140", "province": "CR", "name": "CREDERA (soppresso)" },
    { "code": "D141", "province": "CR", "name": "CREDERA RUBBIANO" },
    { "code": "D142", "province": "CR", "name": "CREMA" },
    { "code": "D143", "province": "CO", "name": "CREMELLA (soppresso)" },
    { "code": "D143", "province": "LC", "name": "CREMELLA" },
    { "code": "D144", "province": "CO", "name": "CREMENAGA (soppresso)" },
    { "code": "D144", "province": "VA", "name": "CREMENAGA" },
    { "code": "D145", "province": "CO", "name": "CREMENO (soppresso)" },
    { "code": "D145", "province": "LC", "name": "CREMENO" },
    { "code": "D146", "province": "BS", "name": "CREMEZZANO (soppresso)" },
    { "code": "D147", "province": "CO", "name": "CREMIA" },
    { "code": "D148", "province": "CO", "name": "CREMNAGO (soppresso)" },
    { "code": "D149", "province": "AL", "name": "CREMOLINO" },
    { "code": "D150", "province": "CR", "name": "CREMONA" },
    { "code": "D150", "province": "CR", "name": "CREMONA ED UNITI (soppresso)" },
    { "code": "D151", "province": "CR", "name": "CREMOSANO" },
    { "code": "D152", "province": "MI", "name": "CRENNA (soppresso)" },
    { "code": "D153", "province": "TS", "name": "CRENOVIZZA (soppresso)" },
    { "code": "D154", "province": "NO", "name": "CRESCENTINO (soppresso)" },
    { "code": "D154", "province": "VC", "name": "CRESCENTINO" },
    { "code": "D155", "province": "MI", "name": "CRESCENZAGO (soppresso)" },
    { "code": "D156", "province": "VI", "name": "CRESPADORO" },
    { "code": "D157", "province": "TV", "name": "CRESPANO DEL GRAPPA (soppresso)" },
    { "code": "D157", "province": "TV", "name": "CRESPANO VENETO (soppresso)" },
    { "code": "D158", "province": "BO", "name": "CRESPELLANO (soppresso)" },
    { "code": "D159", "province": "MI", "name": "CRESPIATICA (soppresso)" },
    { "code": "D159", "province": "LO", "name": "CRESPIATICA" },
    { "code": "D160", "province": "PI", "name": "CRESPINA (soppresso)" },
    { "code": "M328", "province": "PI", "name": "CRESPINA LORENZANA" },
    { "code": "D161", "province": "RO", "name": "CRESPINO" },
    { "code": "D162", "province": "NO", "name": "CRESSA" },
    { "code": "D163", "province": "CO", "name": "CRESSOGNO (soppresso)" },
    { "code": "D164", "province": "TN", "name": "CRETO (soppresso)" },
    { "code": "D165", "province": "NO", "name": "CREVACUORE (soppresso)" },
    { "code": "D165", "province": "VC", "name": "CREVACUORE (soppresso)" },
    { "code": "D165", "province": "BI", "name": "CREVACUORE" },
    { "code": "D166", "province": "BO", "name": "CREVALCORE" },
    { "code": "D167", "province": "CO", "name": "CREVENNA (soppresso)" },
    { "code": "D168", "province": "NO", "name": "CREVOLA D'OSSOLA (soppresso)" },
    { "code": "D169", "province": "NO", "name": "CREVOLA SESIA (soppresso)" },
    { "code": "D169", "province": "VC", "name": "CREVOLA SESIA (soppresso)" },
    { "code": "D168", "province": "NO", "name": "CREVOLADOSSOLA (soppresso)" },
    { "code": "D168", "province": "VB", "name": "CREVOLADOSSOLA" },
    { "code": "D170", "province": "NA", "name": "CRISPANO" },
    { "code": "D171", "province": "LE", "name": "CRISPIANO (soppresso)" },
    { "code": "D171", "province": "TA", "name": "CRISPIANO" },
    { "code": "D172", "province": "CN", "name": "CRISSOLO" },
    { "code": "D173", "province": "CO", "name": "CROCE (soppresso)" },
    { "code": "D174", "province": "NO", "name": "CROCE DI MOSSO (soppresso)" },
    { "code": "D174", "province": "VC", "name": "CROCE DI MOSSO (soppresso)" },
    { "code": "D175", "province": "GE", "name": "CROCEFIESCHI" },
    { "code": "D176", "province": "RO", "name": "CROCETTA (soppresso)" },
    { "code": "C670", "province": "TV", "name": "CROCETTA DEL MONTELLO" },
    { "code": "C670", "province": "TV", "name": "CROCETTA TREVIGIANA (soppresso)" },
    { "code": "D177", "province": "NO", "name": "CRODO (soppresso)" },
    { "code": "D177", "province": "VB", "name": "CRODO" },
    { "code": "D179", "province": "TE", "name": "CROGNALETO" },
    { "code": "D180", "province": "CS", "name": "CROPALATI" },
    { "code": "D181", "province": "CZ", "name": "CROPANI" },
    { "code": "D182", "province": "NO", "name": "CROSA (soppresso)" },
    { "code": "D182", "province": "VC", "name": "CROSA (soppresso)" },
    { "code": "D182", "province": "BI", "name": "CROSA (soppresso)" },
    { "code": "D183", "province": "VI", "name": "CROSARA (soppresso)" },
    { "code": "D184", "province": "CS", "name": "CROSIA" },
    { "code": "D185", "province": "CO", "name": "CROSIO DELLA VALLE (soppresso)" },
    { "code": "D185", "province": "VA", "name": "CROSIO DELLA VALLE" },
    { "code": "D122", "province": "CZ", "name": "CROTONE (soppresso)" },
    { "code": "D122", "province": "KR", "name": "CROTONE" },
    { "code": "D186", "province": "CR", "name": "CROTTA D'ADDA" },
    { "code": "D187", "province": "NO", "name": "CROVA (soppresso)" },
    { "code": "D187", "province": "VC", "name": "CROVA" },
    { "code": "D188", "province": "TN", "name": "CROVIANA" },
    { "code": "D189", "province": "CZ", "name": "CRUCOLI (soppresso)" },
    { "code": "D189", "province": "KR", "name": "CRUCOLI" },
    { "code": "D191", "province": "NO", "name": "CRUSINALLO (soppresso)" },
    { "code": "D192", "province": "CO", "name": "CUASSO AL MONTE (soppresso)" },
    { "code": "D192", "province": "VA", "name": "CUASSO AL MONTE" },
    { "code": "D193", "province": "VR", "name": "CUCCA (soppresso)" },
    { "code": "D194", "province": "AL", "name": "CUCCARO MONFERRATO (soppresso)" },
    { "code": "D195", "province": "SA", "name": "CUCCARO VETERE" },
    { "code": "D196", "province": "CO", "name": "CUCCIAGO" },
    { "code": "D197", "province": "TO", "name": "CUCEGLIO" },
    { "code": "D197", "province": "AO", "name": "CUCEGLIO (soppresso)" },
    { "code": "D198", "province": "MI", "name": "CUGGIONO" },
    { "code": "ND", "province": "CO", "name": "CUGLIATE (soppresso)" },
    { "code": "ND", "province": "VA", "name": "CUGLIATE (soppresso)" },
    { "code": "D199", "province": "VA", "name": "CUGLIATE-FABIASCO" },
    { "code": "D200", "province": "CA", "name": "CUGLIERI (soppresso)" },
    { "code": "D200", "province": "NU", "name": "CUGLIERI (soppresso)" },
    { "code": "D200", "province": "OR", "name": "CUGLIERI" },
    { "code": "D201", "province": "TE", "name": "CUGNOLI (soppresso)" },
    { "code": "D201", "province": "PE", "name": "CUGNOLI" },
    { "code": "D202", "province": "TO", "name": "CUMIANA" },
    { "code": "C929", "province": "CE", "name": "CUMIGNANO E GALLO DI NOLA (soppresso)" },
    { "code": "D203", "province": "CR", "name": "CUMIGNANO SUL NAVIGLIO" },
    { "code": "D204", "province": "CO", "name": "CUNARDO (soppresso)" },
    { "code": "D204", "province": "VA", "name": "CUNARDO" },
    { "code": "D205", "province": "CN", "name": "CUNEO" },
    { "code": "D206", "province": "TN", "name": "CUNEVO (soppresso)" },
    { "code": "D207", "province": "AL", "name": "CUNICO (soppresso)" },
    { "code": "D207", "province": "AT", "name": "CUNICO" },
    { "code": "D208", "province": "TO", "name": "CUORGNE'" },
    { "code": "D208", "province": "AO", "name": "CUORGNE' (soppresso)" },
    { "code": "D209", "province": "CH", "name": "CUPELLO" },
    { "code": "D210", "province": "AP", "name": "CUPRA MARITTIMA" },
    { "code": "D211", "province": "AN", "name": "CUPRAMONTANA" },
    { "code": "D212", "province": "AL", "name": "CUQUELLO (soppresso)" },
    { "code": "B824", "province": "PV", "name": "CURA CARPIGNANO" },
    { "code": "D213", "province": "TN", "name": "CURACES (soppresso)" },
    { "code": "D214", "province": "CA", "name": "CURCURIS (soppresso)" },
    { "code": "D214", "province": "OR", "name": "CURCURIS" },
    { "code": "D215", "province": "BG", "name": "CURDOMO (soppresso)" },
    { "code": "D216", "province": "NO", "name": "CUREGGIO" },
    { "code": "D217", "province": "CO", "name": "CURIGLIA (soppresso)" },
    { "code": "D217", "province": "VA", "name": "CURIGLIA (soppresso)" },
    { "code": "D217", "province": "VA", "name": "CURIGLIA CON MONTEVIASCO" },
    { "code": "D218", "province": "CZ", "name": "CURINGA" },
    { "code": "D219", "province": "NO", "name": "CURINO (soppresso)" },
    { "code": "D219", "province": "VC", "name": "CURINO (soppresso)" },
    { "code": "D219", "province": "BI", "name": "CURINO" },
    { "code": "D220", "province": "BG", "name": "CURNASCO (soppresso)" },
    { "code": "D221", "province": "BG", "name": "CURNO" },
    { "code": "D032", "province": "TN", "name": "CURON (soppresso)" },
    { "code": "D032", "province": "BZ", "name": "CURON (soppresso)" },
    { "code": "D222", "province": "BZ", "name": "CURON VENOSTA" },
    { "code": "D223", "province": "LE", "name": "CURSI" },
    { "code": "D224", "province": "NO", "name": "CURSOLO (soppresso)" },
    { "code": "D225", "province": "NO", "name": "CURSOLO-ORASSO (soppresso)" },
    { "code": "D225", "province": "VB", "name": "CURSOLO-ORASSO (soppresso)" },
    { "code": "D226", "province": "PD", "name": "CURTAROLO" },
    { "code": "D227", "province": "MN", "name": "CURTATONE" },
    { "code": "D228", "province": "CE", "name": "CURTI" },
    { "code": "D228", "province": "NA", "name": "CURTI (soppresso)" },
    { "code": "D229", "province": "MI", "name": "CUSAGO" },
    { "code": "D231", "province": "MI", "name": "CUSANO MILANINO" },
    { "code": "D230", "province": "BN", "name": "CUSANO MUTRI" },
    { "code": "D231", "province": "MI", "name": "CUSANO SUL SEVESO (soppresso)" },
    { "code": "D232", "province": "CO", "name": "CUSINO" },
    { "code": "D233", "province": "BG", "name": "CUSIO" },
    { "code": "D234", "province": "TP", "name": "CUSTONACI" },
    { "code": "D235", "province": "FI", "name": "CUTIGLIANO (soppresso)" },
    { "code": "D235", "province": "PT", "name": "CUTIGLIANO (soppresso)" },
    { "code": "D236", "province": "CZ", "name": "CUTRO (soppresso)" },
    { "code": "D236", "province": "KR", "name": "CUTRO" },
    { "code": "D237", "province": "LE", "name": "CUTROFIANO" },
    { "code": "D238", "province": "VA", "name": "CUVEGLIO" },
    { "code": "ND", "province": "CO", "name": "CUVEGLIO IN VALLE (soppresso)" },
    { "code": "ND", "province": "VA", "name": "CUVEGLIO IN VALLE (soppresso)" },
    { "code": "D239", "province": "CO", "name": "CUVIO (soppresso)" },
    { "code": "D239", "province": "VA", "name": "CUVIO" },
    { "code": "D241", "province": "NO", "name": "CUZZAGO (soppresso)" },
    { "code": "D242", "province": "NO", "name": "DAGNENTE (soppresso)" },
    { "code": "D243", "province": "TN", "name": "DAIANO" },
    { "code": "D244", "province": "MI", "name": "DAIRAGO" },
    { "code": "D245", "province": "BG", "name": "DALMINE" },
    { "code": "D246", "province": "TN", "name": "DAMBEL" },
    { "code": "D247", "province": "BL", "name": "DANTA (soppresso)" },
    { "code": "D247", "province": "BL", "name": "DANTA DI CADORE" },
    { "code": "D248", "province": "TN", "name": "DAONE (soppresso)" },
    { "code": "D249", "province": "TN", "name": "DARDINE (soppresso)" },
    { "code": "D250", "province": "TN", "name": "DARE' (soppresso)" },
    { "code": "D251", "province": "BS", "name": "DARFO (soppresso)" },
    { "code": "D251", "province": "BS", "name": "DARFO BOARIO TERME" },
    { "code": "D252", "province": "TN", "name": "DARZO (soppresso)" },
    { "code": "D253", "province": "CZ", "name": "DASA' (soppresso)" },
    { "code": "D253", "province": "VV", "name": "DASA'" },
    { "code": "D254", "province": "CO", "name": "DASIO (soppresso)" },
    { "code": "D255", "province": "GE", "name": "DAVAGNA" },
    { "code": "D256", "province": "CO", "name": "DAVERIO (soppresso)" },
    { "code": "D256", "province": "VA", "name": "DAVERIO" },
    { "code": "D257", "province": "CZ", "name": "DAVOLI" },
    { "code": "D258", "province": "SO", "name": "DAZIO" },
    { "code": "L932", "province": "PL", "name": "DECANI (soppresso)" },
    { "code": "D259", "province": "CA", "name": "DECIMOMANNU" },
    { "code": "D260", "province": "CA", "name": "DECIMOPUTZU (soppresso)" },
    { "code": "D260", "province": "SU", "name": "DECIMOPUTZU" },
    { "code": "D261", "province": "CZ", "name": "DECOLLATURA" },
    { "code": "D262", "province": "BS", "name": "DEGAGNA (soppresso)" },
    { "code": "D263", "province": "TN", "name": "DEGGIANO (soppresso)" },
    { "code": "D264", "province": "GE", "name": "DEGO (soppresso)" },
    { "code": "D264", "province": "SV", "name": "DEGO" },
    { "code": "D265", "province": "GE", "name": "DEIVA (soppresso)" },
    { "code": "D265", "province": "SP", "name": "DEIVA (soppresso)" },
    { "code": "D265", "province": "SP", "name": "DEIVA MARINA" },
    { "code": "D266", "province": "SO", "name": "DELEBIO" },
    { "code": "D267", "province": "CL", "name": "DELIA" },
    { "code": "D268", "province": "RC", "name": "DELIANUOVA" },
    { "code": "D269", "province": "FG", "name": "DELICETO" },
    { "code": "D270", "province": "BS", "name": "DELLO" },
    { "code": "D271", "province": "CN", "name": "DEMONTE" },
    { "code": "D272", "province": "AL", "name": "DENICE" },
    { "code": "D273", "province": "TN", "name": "DENNO" },
    { "code": "D274", "province": "TN", "name": "DERCOLO (soppresso)" },
    { "code": "D276", "province": "TN", "name": "DERMULO (soppresso)" },
    { "code": "D277", "province": "AL", "name": "DERNICE" },
    { "code": "D278", "province": "CR", "name": "DEROVERE" },
    { "code": "D279", "province": "PG", "name": "DERUTA" },
    { "code": "D280", "province": "CO", "name": "DERVIO (soppresso)" },
    { "code": "D280", "province": "LC", "name": "DERVIO" },
    { "code": "D281", "province": "NO", "name": "DESANA (soppresso)" },
    { "code": "D281", "province": "VC", "name": "DESANA" },
    { "code": "D282", "province": "GO", "name": "DESCLA (soppresso)" },
    { "code": "D282", "province": "UD", "name": "DESCLA (soppresso)" },
    { "code": "D283", "province": "BG", "name": "DESENZANO AL SERIO (soppresso)" },
    { "code": "D284", "province": "BS", "name": "DESENZANO DEL GARDA" },
    { "code": "D284", "province": "BS", "name": "DESENZANO SUL LAGO (soppresso)" },
    { "code": "D285", "province": "TO", "name": "DESERTES (soppresso)" },
    { "code": "D286", "province": "MI", "name": "DESIO (soppresso)" },
    { "code": "D286", "province": "MB", "name": "DESIO" },
    { "code": "D287", "province": "CA", "name": "DESULO (soppresso)" },
    { "code": "D287", "province": "NU", "name": "DESULO" },
    { "code": "D288", "province": "BG", "name": "DEZZO DI SCALVE (soppresso)" },
    { "code": "D289", "province": "CS", "name": "DIAMANTE" },
    { "code": "D293", "province": "IM", "name": "DIANO ARENTINO" },
    { "code": "D294", "province": "IM", "name": "DIANO BORELLO (soppresso)" },
    { "code": "D295", "province": "IM", "name": "DIANO CALDERINA (soppresso)" },
    { "code": "D296", "province": "IM", "name": "DIANO CASTELLO" },
    { "code": "D291", "province": "CN", "name": "DIANO D'ALBA" },
    { "code": "D297", "province": "IM", "name": "DIANO MARINA" },
    { "code": "D298", "province": "IM", "name": "DIANO SAN PIETRO" },
    { "code": "D299", "province": "FI", "name": "DICOMANO" },
    { "code": "D300", "province": "UD", "name": "DIGNANO" },
    { "code": "D301", "province": "PL", "name": "DIGNANO D'ISTRIA (soppresso)" },
    { "code": "D302", "province": "TN", "name": "DIMARO (soppresso)" },
    { "code": "M366", "province": "TN", "name": "DIMARO FOLGARIDA" },
    { "code": "D303", "province": "CZ", "name": "DINAMI (soppresso)" },
    { "code": "D303", "province": "VV", "name": "DINAMI" },
    { "code": "D304", "province": "CS", "name": "DIPIGNANO" },
    { "code": "D305", "province": "LE", "name": "DISO" },
    { "code": "D306", "province": "NO", "name": "DISSIMO (soppresso)" },
    { "code": "D307", "province": "TS", "name": "DIVACCIA GROTTE DEL TIMAVO (soppresso)" },
    { "code": "D308", "province": "TS", "name": "DIVACCIA SAN CANZIANO (soppresso)" },
    { "code": "D309", "province": "NO", "name": "DIVIGNANO" },
    { "code": "D310", "province": "CO", "name": "DIZZASCO" },
    { "code": "D311", "province": "TN", "name": "DOBBIACO (soppresso)" },
    { "code": "D311", "province": "BZ", "name": "DOBBIACO" },
    { "code": "D312", "province": "GO", "name": "DOBERDO' (soppresso)" },
    { "code": "D312", "province": "TS", "name": "DOBERDO' (soppresso)" },
    { "code": "D312", "province": "TS", "name": "DOBERDO' DEL LAGO (soppresso)" },
    { "code": "D312", "province": "GO", "name": "DOBERDO' DEL LAGO" },
    { "code": "D313", "province": "NO", "name": "DOCCIO (soppresso)" },
    { "code": "D313", "province": "VC", "name": "DOCCIO (soppresso)" },
    { "code": "D314", "province": "CN", "name": "DOGLIANI" },
    { "code": "D315", "province": "CH", "name": "DOGLIOLA" },
    { "code": "D316", "province": "UD", "name": "DOGNA" },
    { "code": "D322", "province": "UD", "name": "DOL GRANDE (soppresso)" },
    { "code": "D322", "province": "GO", "name": "DOL GRANDE (soppresso)" },
    { "code": "D317", "province": "VR", "name": "DOLCE'" },
    { "code": "D318", "province": "IM", "name": "DOLCEACQUA" },
    { "code": "D319", "province": "IM", "name": "DOLCEDO" },
    { "code": "D320", "province": "GO", "name": "DOLE (soppresso)" },
    { "code": "D320", "province": "UD", "name": "DOLE (soppresso)" },
    { "code": "D321", "province": "GO", "name": "DOLEGNA (soppresso)" },
    { "code": "D321", "province": "UD", "name": "DOLEGNA (soppresso)" },
    { "code": "D321", "province": "UD", "name": "DOLEGNA DEL COLLIO (soppresso)" },
    { "code": "D321", "province": "GO", "name": "DOLEGNA DEL COLLIO" },
    { "code": "D323", "province": "CA", "name": "DOLIANOVA (soppresso)" },
    { "code": "D323", "province": "SU", "name": "DOLIANOVA" },
    { "code": "D325", "province": "VE", "name": "DOLO" },
    { "code": "D326", "province": "GO", "name": "DOL-OTLIZA (soppresso)" },
    { "code": "D326", "province": "UD", "name": "DOL-OTLIZA (soppresso)" },
    { "code": "D326", "province": "UD", "name": "DOL-OTTELZA (soppresso)" },
    { "code": "D326", "province": "GO", "name": "DOL-OTTELZA (soppresso)" },
    { "code": "D327", "province": "CO", "name": "DOLZAGO (soppresso)" },
    { "code": "D327", "province": "LC", "name": "DOLZAGO" },
    { "code": "D328", "province": "CS", "name": "DOMANICO" },
    { "code": "D329", "province": "CO", "name": "DOMASO" },
    { "code": "D330", "province": "BL", "name": "DOMEGGE (soppresso)" },
    { "code": "D330", "province": "BL", "name": "DOMEGGE DI CADORE" },
    { "code": "D331", "province": "AV", "name": "DOMICELLA" },
    { "code": "D332", "province": "NO", "name": "DOMODOSSOLA (soppresso)" },
    { "code": "D332", "province": "VB", "name": "DOMODOSSOLA" },
    { "code": "D333", "province": "CA", "name": "DOMUS DE MARIA (soppresso)" },
    { "code": "D333", "province": "SU", "name": "DOMUS DE MARIA" },
    { "code": "D334", "province": "CA", "name": "DOMUSNOVAS (soppresso)" },
    { "code": "D334", "province": "CI", "name": "DOMUSNOVAS (soppresso)" },
    { "code": "D334", "province": "SU", "name": "DOMUSNOVAS" },
    { "code": "D335", "province": "CA", "name": "DOMUSNOVAS CANALES (soppresso)" },
    { "code": "D336", "province": "TN", "name": "DON (soppresso)" },
    { "code": "D337", "province": "RO", "name": "DONADA (soppresso)" },
    { "code": "D338", "province": "AO", "name": "DONAS (soppresso)" },
    { "code": "D339", "province": "NO", "name": "DONATO (soppresso)" },
    { "code": "D339", "province": "VC", "name": "DONATO (soppresso)" },
    { "code": "D339", "province": "BI", "name": "DONATO" },
    { "code": "D340", "province": "PV", "name": "DONELASCO (soppresso)" },
    { "code": "D341", "province": "CO", "name": "DONGO" },
    { "code": "D342", "province": "CA", "name": "DONIGALA FENUGHEDU (soppresso)" },
    { "code": "D343", "province": "CA", "name": "DONIGALA SIURGUS (soppresso)" },
    { "code": "D338", "province": "AO", "name": "DONNAS" },
    { "code": "D338", "province": "TO", "name": "DONNAZ (soppresso)" },
    { "code": "D338", "province": "AO", "name": "DONNAZ (soppresso)" },
    { "code": "D344", "province": "CA", "name": "DONORI (soppresso)" },
    { "code": "D344", "province": "SU", "name": "DONORI" },
    { "code": "D345", "province": "SS", "name": "DORGALI (soppresso)" },
    { "code": "D345", "province": "NU", "name": "DORGALI" },
    { "code": "D346", "province": "CO", "name": "DORIO (soppresso)" },
    { "code": "D346", "province": "LC", "name": "DORIO" },
    { "code": "D347", "province": "NO", "name": "DORMELLETTO" },
    { "code": "F649", "province": "GO", "name": "DORNBERG (soppresso)" },
    { "code": "F649", "province": "UD", "name": "DORNBERG (soppresso)" },
    { "code": "D348", "province": "PV", "name": "DORNO" },
    { "code": "D349", "province": "TN", "name": "DORSINO (soppresso)" },
    { "code": "D350", "province": "NO", "name": "DORZANO (soppresso)" },
    { "code": "D350", "province": "VC", "name": "DORZANO (soppresso)" },
    { "code": "D350", "province": "BI", "name": "DORZANO" },
    { "code": "D351", "province": "MN", "name": "DOSOLO" },
    { "code": "D352", "province": "BG", "name": "DOSSENA" },
    { "code": "D355", "province": "CO", "name": "DOSSO DEL LIRO" },
    { "code": "D356", "province": "TO", "name": "DOUES (soppresso)" },
    { "code": "D356", "province": "AO", "name": "DOUES" },
    { "code": "D357", "province": "FI", "name": "DOVADOLA (soppresso)" },
    { "code": "D357", "province": "FO", "name": "DOVADOLA (soppresso)" },
    { "code": "D357", "province": "FC", "name": "DOVADOLA" },
    { "code": "D358", "province": "CR", "name": "DOVERA" },
    { "code": "D356", "province": "AO", "name": "DOVIA DI AOSTA (soppresso)" },
    { "code": "D359", "province": "CO", "name": "DOZIO (soppresso)" },
    { "code": "D360", "province": "BO", "name": "DOZZA" },
    { "code": "D361", "province": "CE", "name": "DRAGONI" },
    { "code": "D361", "province": "BN", "name": "DRAGONI (soppresso)" },
    { "code": "D362", "province": "PL", "name": "DRAGUCCIO (soppresso)" },
    { "code": "D363", "province": "CO", "name": "DRANO (soppresso)" },
    { "code": "D364", "province": "CZ", "name": "DRAPIA (soppresso)" },
    { "code": "D364", "province": "VV", "name": "DRAPIA" },
    { "code": "D365", "province": "TN", "name": "DRENA" },
    { "code": "D366", "province": "UD", "name": "DRENCHIA" },
    { "code": "D367", "province": "MI", "name": "DRESANO" },
    { "code": "D368", "province": "GO", "name": "DRESENZA (soppresso)" },
    { "code": "D368", "province": "UD", "name": "DRESENZA (soppresso)" },
    { "code": "D369", "province": "CO", "name": "DREZZO (soppresso)" },
    { "code": "D370", "province": "CR", "name": "DRIZZONA (soppresso)" },
    { "code": "D371", "province": "TN", "name": "DRO" },
    { "code": "D372", "province": "CN", "name": "DRONERO" },
    { "code": "D373", "province": "TO", "name": "DRUENT (soppresso)" },
    { "code": "D373", "province": "TO", "name": "DRUENTO" },
    { "code": "D374", "province": "NO", "name": "DRUOGNO (soppresso)" },
    { "code": "D374", "province": "VB", "name": "DRUOGNO" },
    { "code": "D375", "province": "TO", "name": "DRUSACCO (soppresso)" },
    { "code": "D375", "province": "AO", "name": "DRUSACCO (soppresso)" },
    { "code": "D376", "province": "CA", "name": "DUALCHI (soppresso)" },
    { "code": "D376", "province": "NU", "name": "DUALCHI" },
    { "code": "D377", "province": "SO", "name": "DUBINO" },
    { "code": "M300", "province": "PD", "name": "DUE CARRARE" },
    { "code": "D091", "province": "CO", "name": "DUE COSSANI (soppresso)" },
    { "code": "D091", "province": "VA", "name": "DUE COSSANI (soppresso)" },
    { "code": "D378", "province": "CR", "name": "DUEMIGLIA (soppresso)" },
    { "code": "D379", "province": "VI", "name": "DUEVILLE" },
    { "code": "D380", "province": "BN", "name": "DUGENTA" },
    { "code": "D382", "province": "TS", "name": "DUINO (soppresso)" },
    { "code": "D383", "province": "TS", "name": "DUINO AURISINA" },
    { "code": "D384", "province": "CO", "name": "DUMENZA (soppresso)" },
    { "code": "D384", "province": "VA", "name": "DUMENZA" },
    { "code": "D385", "province": "CO", "name": "DUNO (soppresso)" },
    { "code": "D385", "province": "VA", "name": "DUNO" },
    { "code": "D386", "province": "BN", "name": "DURAZZANO" },
    { "code": "C772", "province": "CB", "name": "DURONIA" },
    { "code": "D387", "province": "AL", "name": "DUSINO (soppresso)" },
    { "code": "D388", "province": "AL", "name": "DUSINO SAN MICHELE (soppresso)" },
    { "code": "D388", "province": "AT", "name": "DUSINO SAN MICHELE" },
    { "code": "D389", "province": "TS", "name": "DUTTOGLIANO (soppresso)" },
    { "code": "D390", "province": "SA", "name": "EBOLI" },
    { "code": "D391", "province": "BS", "name": "EDOLO" },
    { "code": "D392", "province": "TN", "name": "EGNA (soppresso)" },
    { "code": "D392", "province": "BZ", "name": "EGNA" },
    { "code": "D393", "province": "CE", "name": "ELENA (soppresso)" },
    { "code": "D393", "province": "RM", "name": "ELENA (soppresso)" },
    { "code": "D394", "province": "TE", "name": "ELICE (soppresso)" },
    { "code": "D394", "province": "PE", "name": "ELICE" },
    { "code": "D395", "province": "NU", "name": "ELINI" },
    { "code": "D395", "province": "OG", "name": "ELINI (soppresso)" },
    { "code": "D396", "province": "TN", "name": "ELLE (soppresso)" },
    { "code": "D396", "province": "BZ", "name": "ELLE (soppresso)" },
    { "code": "D397", "province": "GE", "name": "ELLERA (soppresso)" },
    { "code": "D397", "province": "SV", "name": "ELLERA (soppresso)" },
    { "code": "D398", "province": "CO", "name": "ELLO (soppresso)" },
    { "code": "D398", "province": "LC", "name": "ELLO" },
    { "code": "D399", "province": "CA", "name": "ELMAS" },
    { "code": "D400", "province": "PL", "name": "ELSANE (soppresso)" },
    { "code": "D400", "province": "FU", "name": "ELSANE (soppresso)" },
    { "code": "D401", "province": "CN", "name": "ELVA" },
    { "code": "D402", "province": "TO", "name": "EMARESE (soppresso)" },
    { "code": "D402", "province": "AO", "name": "EMARESE" },
    { "code": "D403", "province": "FI", "name": "EMPOLI" },
    { "code": "D404", "province": "BG", "name": "ENDENNA (soppresso)" },
    { "code": "D405", "province": "BG", "name": "ENDINE (soppresso)" },
    { "code": "D406", "province": "BG", "name": "ENDINE GAIANO" },
    { "code": "D407", "province": "VI", "name": "ENEGO" },
    { "code": "D408", "province": "UD", "name": "ENEMONZO" },
    { "code": "D409", "province": "TN", "name": "ENGUISO (soppresso)" },
    { "code": "C342", "province": "EN", "name": "ENNA" },
    { "code": "D410", "province": "CN", "name": "ENTRACQUE" },
    { "code": "D410", "province": "CN", "name": "ENTRAQUE (soppresso)" },
    { "code": "D411", "province": "BG", "name": "ENTRATICO" },
    { "code": "D412", "province": "CN", "name": "ENVIE" },
    { "code": "D413", "province": "TN", "name": "EORES (soppresso)" },
    { "code": "D413", "province": "BZ", "name": "EORES (soppresso)" },
    { "code": "D414", "province": "PZ", "name": "EPISCOPIA" },
    { "code": "D415", "province": "VE", "name": "ERACLEA" },
    { "code": "D416", "province": "CO", "name": "ERBA" },
    { "code": "D417", "province": "CO", "name": "ERBA INCINO (soppresso)" },
    { "code": "D418", "province": "BS", "name": "ERBANNO (soppresso)" },
    { "code": "D419", "province": "VR", "name": "ERBE'" },
    { "code": "D420", "province": "VR", "name": "ERBEZZO" },
    { "code": "D421", "province": "BS", "name": "ERBUSCO" },
    { "code": "D422", "province": "LE", "name": "ERCHIE (soppresso)" },
    { "code": "D422", "province": "BR", "name": "ERCHIE" },
    { "code": "H243", "province": "NA", "name": "ERCOLANO" },
    { "code": "D423", "province": "TP", "name": "ERICE" },
    { "code": "D424", "province": "GE", "name": "ERLI (soppresso)" },
    { "code": "D424", "province": "SV", "name": "ERLI" },
    { "code": "D425", "province": "PL", "name": "ERPELLE-COSINA (soppresso)" },
    { "code": "D427", "province": "GO", "name": "ERSEL IN MONTE (soppresso)" },
    { "code": "D427", "province": "UD", "name": "ERSEL IN MONTE (soppresso)" },
    { "code": "D426", "province": "UD", "name": "ERTO E CASSO (soppresso)" },
    { "code": "D426", "province": "PN", "name": "ERTO E CASSO" },
    { "code": "M292", "province": "SS", "name": "ERULA" },
    { "code": "D428", "province": "BG", "name": "ERVE (soppresso)" },
    { "code": "D428", "province": "LC", "name": "ERVE" },
    { "code": "D429", "province": "MC", "name": "ESANATOGLIA" },
    { "code": "D430", "province": "CA", "name": "ESCALAPLANO (soppresso)" },
    { "code": "D430", "province": "NU", "name": "ESCALAPLANO (soppresso)" },
    { "code": "D430", "province": "SU", "name": "ESCALAPLANO" },
    { "code": "D431", "province": "CA", "name": "ESCOLCA (soppresso)" },
    { "code": "D431", "province": "NU", "name": "ESCOLCA (soppresso)" },
    { "code": "D431", "province": "SU", "name": "ESCOLCA" },
    { "code": "D432", "province": "CA", "name": "ESCOVEDU (soppresso)" },
    { "code": "D433", "province": "TO", "name": "ESILLE (soppresso)" },
    { "code": "D434", "province": "BS", "name": "ESINE" },
    { "code": "D435", "province": "CO", "name": "ESINO INFERIORE (soppresso)" },
    { "code": "D436", "province": "CO", "name": "ESINO LARIO (soppresso)" },
    { "code": "D436", "province": "LC", "name": "ESINO LARIO" },
    { "code": "D437", "province": "CO", "name": "ESINO SUPERIORE (soppresso)" },
    { "code": "D438", "province": "NO", "name": "ESIO (soppresso)" },
    { "code": "D439", "province": "BG", "name": "ESMATE (soppresso)" },
    { "code": "D440", "province": "CE", "name": "ESPERIA (soppresso)" },
    { "code": "D440", "province": "FR", "name": "ESPERIA" },
    { "code": "D441", "province": "SS", "name": "ESPORLATU" },
    { "code": "D442", "province": "PD", "name": "ESTE" },
    { "code": "D443", "province": "CA", "name": "ESTERZILI (soppresso)" },
    { "code": "D443", "province": "NU", "name": "ESTERZILI (soppresso)" },
    { "code": "D443", "province": "SU", "name": "ESTERZILI" },
    { "code": "D444", "province": "AO", "name": "ETROBLE (soppresso)" },
    { "code": "D444", "province": "AO", "name": "ETROUBLES (soppresso)" },
    { "code": "D444", "province": "TO", "name": "ETROUBLES (soppresso)" },
    { "code": "D445", "province": "CO", "name": "EUPILIO" },
    { "code": "D433", "province": "TO", "name": "EXILLES" },
    { "code": "D447", "province": "AL", "name": "FABBRICA CURONE" },
    { "code": "D448", "province": "CO", "name": "FABBRICA DURINI (soppresso)" },
    { "code": "D449", "province": "LU", "name": "FABBRICHE DI VALLICO (soppresso)" },
    { "code": "M319", "province": "LU", "name": "FABBRICHE DI VERGEMOLI" },
    { "code": "D450", "province": "RE", "name": "FABBRICO" },
    { "code": "D446", "province": "CO", "name": "FABIASCO (soppresso)" },
    { "code": "D446", "province": "VA", "name": "FABIASCO (soppresso)" },
    { "code": "D451", "province": "AN", "name": "FABRIANO" },
    { "code": "D452", "province": "RM", "name": "FABRICA DI ROMA (soppresso)" },
    { "code": "D452", "province": "VT", "name": "FABRICA DI ROMA" },
    { "code": "D453", "province": "CZ", "name": "FABRIZIA (soppresso)" },
    { "code": "D453", "province": "VV", "name": "FABRIZIA" },
    { "code": "D454", "province": "PG", "name": "FABRO (soppresso)" },
    { "code": "D454", "province": "TR", "name": "FABRO" },
    { "code": "D455", "province": "UD", "name": "FAEDIS" },
    { "code": "D456", "province": "SO", "name": "FAEDO (soppresso)" },
    { "code": "D457", "province": "TN", "name": "FAEDO" },
    { "code": "D456", "province": "SO", "name": "FAEDO VALTELLINO" },
    { "code": "D458", "province": "RA", "name": "FAENZA" },
    { "code": "D459", "province": "FG", "name": "FAETO" },
    { "code": "D460", "province": "TO", "name": "FAETTO (soppresso)" },
    { "code": "D461", "province": "UD", "name": "FAGAGNA" },
    { "code": "D462", "province": "CO", "name": "FAGGETO LARIO" },
    { "code": "D463", "province": "LE", "name": "FAGGIANO (soppresso)" },
    { "code": "D463", "province": "TA", "name": "FAGGIANO" },
    { "code": "D466", "province": "MI", "name": "FAGNANO (soppresso)" },
    { "code": "D465", "province": "AQ", "name": "FAGNANO ALTO" },
    { "code": "D464", "province": "CS", "name": "FAGNANO CASTELLO" },
    { "code": "D467", "province": "MI", "name": "FAGNANO OLONA (soppresso)" },
    { "code": "D467", "province": "VA", "name": "FAGNANO OLONA" },
    { "code": "D466", "province": "MI", "name": "FAGNANO SUL NAVIGLIO (soppresso)" },
    { "code": "D468", "province": "TN", "name": "FAI (soppresso)" },
    { "code": "D468", "province": "TN", "name": "FAI DELLA PAGANELLA" },
    { "code": "D469", "province": "BN", "name": "FAICCHIO" },
    { "code": "D470", "province": "BL", "name": "FALCADE" },
    { "code": "D471", "province": "CE", "name": "FALCIANO DEL MASSICO" },
    { "code": "D473", "province": "CS", "name": "FALCONARA ALBANESE" },
    { "code": "D472", "province": "AN", "name": "FALCONARA MARITTIMA" },
    { "code": "D474", "province": "ME", "name": "FALCONE" },
    { "code": "D475", "province": "RM", "name": "FALERIA (soppresso)" },
    { "code": "D475", "province": "VT", "name": "FALERIA" },
    { "code": "D476", "province": "CZ", "name": "FALERNA" },
    { "code": "D477", "province": "AP", "name": "FALERONE (soppresso)" },
    { "code": "D477", "province": "FM", "name": "FALERONE" },
    { "code": "D478", "province": "TN", "name": "FALESINA (soppresso)" },
    { "code": "D479", "province": "CH", "name": "FALLASCOSO (soppresso)" },
    { "code": "D480", "province": "CH", "name": "FALLO" },
    { "code": "D481", "province": "NO", "name": "FALMENTA (soppresso)" },
    { "code": "D481", "province": "VB", "name": "FALMENTA (soppresso)" },
    { "code": "D482", "province": "CO", "name": "FALOPPIO" },
    { "code": "D483", "province": "RM", "name": "FALVATERRA (soppresso)" },
    { "code": "D483", "province": "FR", "name": "FALVATERRA" },
    { "code": "D484", "province": "TN", "name": "FALZES (soppresso)" },
    { "code": "D484", "province": "BZ", "name": "FALZES" },
    { "code": "D485", "province": "TS", "name": "FAMIE (soppresso)" },
    { "code": "D485", "province": "TS", "name": "FAMLIE (soppresso)" },
    { "code": "D486", "province": "MO", "name": "FANANO" },
    { "code": "D487", "province": "UD", "name": "FANNA (soppresso)" },
    { "code": "D487", "province": "PN", "name": "FANNA" },
    { "code": "D488", "province": "PS", "name": "FANO (soppresso)" },
    { "code": "D488", "province": "PU", "name": "FANO" },
    { "code": "D489", "province": "TE", "name": "FANO ADRIANO" },
    { "code": "D490", "province": "BG", "name": "FARA D'ADDA (soppresso)" },
    { "code": "D494", "province": "CH", "name": "FARA FILIORUM PETRI" },
    { "code": "D490", "province": "BG", "name": "FARA GERA D'ADDA" },
    { "code": "D493", "province": "PG", "name": "FARA IN SABINA (soppresso)" },
    { "code": "D493", "province": "RM", "name": "FARA IN SABINA (soppresso)" },
    { "code": "D493", "province": "RI", "name": "FARA IN SABINA" },
    { "code": "D492", "province": "NO", "name": "FARA NOVARESE" },
    { "code": "D491", "province": "BG", "name": "FARA OLIVANA CON SOLA" },
    { "code": "D495", "province": "CH", "name": "FARA SAN MARTINO" },
    { "code": "D496", "province": "VI", "name": "FARA VICENTINO" },
    { "code": "D497", "province": "PZ", "name": "FARDELLA" },
    { "code": "D499", "province": "CN", "name": "FARIGLIANO" },
    { "code": "D501", "province": "TE", "name": "FARINDOLA (soppresso)" },
    { "code": "D501", "province": "PE", "name": "FARINDOLA" },
    { "code": "D502", "province": "PC", "name": "FARINI" },
    { "code": "D502", "province": "PC", "name": "FARINI D'OLMO (soppresso)" },
    { "code": "D503", "province": "RM", "name": "FARNESE (soppresso)" },
    { "code": "D503", "province": "VT", "name": "FARNESE" },
    { "code": "D504", "province": "GO", "name": "FARRA (soppresso)" },
    { "code": "D504", "province": "UD", "name": "FARRA (soppresso)" },
    { "code": "D506", "province": "BL", "name": "FARRA D'ALPAGO (soppresso)" },
    { "code": "D505", "province": "TV", "name": "FARRA DI SOLIGO" },
    { "code": "D504", "province": "UD", "name": "FARRA D'ISONZO (soppresso)" },
    { "code": "D504", "province": "GO", "name": "FARRA D'ISONZO" },
    { "code": "D498", "province": "BS", "name": "FARVENGO (soppresso)" },
    { "code": "D508", "province": "BA", "name": "FASANO (soppresso)" },
    { "code": "D508", "province": "BR", "name": "FASANO" },
    { "code": "D509", "province": "PV", "name": "FASCIA (soppresso)" },
    { "code": "D509", "province": "GE", "name": "FASCIA" },
    { "code": "D510", "province": "PI", "name": "FAUGLIA" },
    { "code": "D511", "province": "CN", "name": "FAULE" },
    { "code": "D512", "province": "GE", "name": "FAVALE DI MALVARO" },
    { "code": "D514", "province": "AG", "name": "FAVARA" },
    { "code": "D515", "province": "VE", "name": "FAVARO VENETO (soppresso)" },
    { "code": "D516", "province": "TN", "name": "FAVER (soppresso)" },
    { "code": "D517", "province": "BS", "name": "FAVERZANO (soppresso)" },
    { "code": "D518", "province": "TP", "name": "FAVIGNANA" },
    { "code": "D519", "province": "TN", "name": "FAVOGNA DI SOTTO (soppresso)" },
    { "code": "D519", "province": "BZ", "name": "FAVOGNA DI SOTTO (soppresso)" },
    { "code": "D520", "province": "TO", "name": "FAVRIA" },
    { "code": "D521", "province": "TO", "name": "FAVRIA-OGLIANICO (soppresso)" },
    { "code": "D523", "province": "CN", "name": "FEISOGLIO" },
    { "code": "D524", "province": "TO", "name": "FELETTO" },
    { "code": "D525", "province": "UD", "name": "FELETTO UMBERTO (soppresso)" },
    { "code": "D526", "province": "PR", "name": "FELINO" },
    { "code": "D527", "province": "SA", "name": "FELITTO" },
    { "code": "D528", "province": "AL", "name": "FELIZZANO" },
    { "code": "D529", "province": "MN", "name": "FELONICA (soppresso)" },
    { "code": "D530", "province": "BL", "name": "FELTRE" },
    { "code": "D531", "province": "CO", "name": "FENEGRO'" },
    { "code": "D532", "province": "TO", "name": "FENESTRELLE" },
    { "code": "D535", "province": "TO", "name": "FENILE (soppresso)" },
    { "code": "D536", "province": "TO", "name": "FENILS (soppresso)" },
    { "code": "D537", "province": "TO", "name": "FENIS (soppresso)" },
    { "code": "D537", "province": "AO", "name": "FENIS" },
    { "code": "D538", "province": "PG", "name": "FERENTILLO (soppresso)" },
    { "code": "D538", "province": "TR", "name": "FERENTILLO" },
    { "code": "D539", "province": "RM", "name": "FERENTINO (soppresso)" },
    { "code": "D539", "province": "FR", "name": "FERENTINO" },
    { "code": "D540", "province": "SR", "name": "FERLA" },
    { "code": "D541", "province": "PS", "name": "FERMIGNANO (soppresso)" },
    { "code": "D541", "province": "PU", "name": "FERMIGNANO" },
    { "code": "D542", "province": "AP", "name": "FERMO (soppresso)" },
    { "code": "D542", "province": "FM", "name": "FERMO" },
    { "code": "D543", "province": "MI", "name": "FERNO (soppresso)" },
    { "code": "D543", "province": "VA", "name": "FERNO" },
    { "code": "D544", "province": "CZ", "name": "FEROLETO ANTICO" },
    { "code": "D545", "province": "RC", "name": "FEROLETO DELLA CHIESA" },
    { "code": "D547", "province": "PZ", "name": "FERRANDINA (soppresso)" },
    { "code": "D547", "province": "MT", "name": "FERRANDINA" },
    { "code": "D548", "province": "FE", "name": "FERRARA" },
    { "code": "D549", "province": "VR", "name": "FERRARA DI MONTE BALDO" },
    { "code": "D550", "province": "CB", "name": "FERRAZZANO" },
    { "code": "D553", "province": "TO", "name": "FERRERA CENISIO (soppresso)" },
    { "code": "D551", "province": "CO", "name": "FERRERA DI VARESE (soppresso)" },
    { "code": "D551", "province": "VA", "name": "FERRERA DI VARESE" },
    { "code": "D552", "province": "PV", "name": "FERRERA ERBOGNONE" },
    { "code": "D554", "province": "AL", "name": "FERRERE (soppresso)" },
    { "code": "D554", "province": "AT", "name": "FERRERE" },
    { "code": "D555", "province": "PC", "name": "FERRIERE" },
    { "code": "D557", "province": "RC", "name": "FERRUZZANO" },
    { "code": "D558", "province": "NA", "name": "FERTILIA (soppresso)" },
    { "code": "D558", "province": "CE", "name": "FERTILIA (soppresso)" },
    { "code": "D559", "province": "AL", "name": "FIACCONE (soppresso)" },
    { "code": "D560", "province": "AQ", "name": "FIAMIGNANO (soppresso)" },
    { "code": "D560", "province": "RI", "name": "FIAMIGNANO" },
    { "code": "D562", "province": "TO", "name": "FIANO" },
    { "code": "D561", "province": "RM", "name": "FIANO ROMANO" },
    { "code": "D563", "province": "PL", "name": "FIANONA (soppresso)" },
    { "code": "D564", "province": "MC", "name": "FIASTRA" },
    { "code": "D565", "province": "TN", "name": "FIAVE'" },
    { "code": "D566", "province": "MC", "name": "FICANO (soppresso)" },
    { "code": "D567", "province": "PA", "name": "FICARAZZI" },
    { "code": "D568", "province": "RO", "name": "FICAROLO" },
    { "code": "D569", "province": "ME", "name": "FICARRA" },
    { "code": "D570", "province": "PG", "name": "FICULLE (soppresso)" },
    { "code": "D570", "province": "TR", "name": "FICULLE" },
    { "code": "B034", "province": "PR", "name": "FIDENZA" },
    { "code": "D571", "province": "TN", "name": "FIE' (soppresso)" },
    { "code": "D571", "province": "BZ", "name": "FIE' (soppresso)" },
    { "code": "D571", "province": "BZ", "name": "FIE' ALLO SCILIAR" },
    { "code": "D572", "province": "TN", "name": "FIERA DI PRIMIERO (soppresso)" },
    { "code": "D573", "province": "TN", "name": "FIEROZZO" },
    { "code": "D574", "province": "CR", "name": "FIESCO" },
    { "code": "D575", "province": "FI", "name": "FIESOLE" },
    { "code": "D576", "province": "BS", "name": "FIESSE" },
    { "code": "D578", "province": "VE", "name": "FIESSO D'ARTICO" },
    { "code": "D577", "province": "RO", "name": "FIESSO UMBERTIANO" },
    { "code": "D579", "province": "CO", "name": "FIGINO SERENZA" },
    { "code": "D581", "province": "CO", "name": "FIGLIARO (soppresso)" },
    { "code": "M321", "province": "FI", "name": "FIGLINE E INCISA VALDARNO" },
    { "code": "D583", "province": "FI", "name": "FIGLINE VALDARNO (soppresso)" },
    { "code": "D582", "province": "CS", "name": "FIGLINE VEGLIATURO" },
    { "code": "D584", "province": "CA", "name": "FIGU (soppresso)" },
    { "code": "D585", "province": "CA", "name": "FIGU-GONNOSNO' (soppresso)" },
    { "code": "D586", "province": "RM", "name": "FILACCIANO" },
    { "code": "D587", "province": "CZ", "name": "FILADELFIA (soppresso)" },
    { "code": "D587", "province": "VV", "name": "FILADELFIA" },
    { "code": "D588", "province": "BG", "name": "FILAGO" },
    { "code": "D589", "province": "CZ", "name": "FILANDARI (soppresso)" },
    { "code": "D589", "province": "VV", "name": "FILANDARI" },
    { "code": "D590", "province": "MS", "name": "FILATTIERA" },
    { "code": "D591", "province": "RM", "name": "FILETTINO (soppresso)" },
    { "code": "D591", "province": "FR", "name": "FILETTINO" },
    { "code": "D591", "province": "FR", "name": "FILETTINO GRAZIANI (soppresso)" },
    { "code": "D592", "province": "CH", "name": "FILETTO" },
    { "code": "D593", "province": "PZ", "name": "FILIANO" },
    { "code": "D594", "province": "PV", "name": "FILIGHERA" },
    { "code": "D595", "province": "CB", "name": "FILIGNANO (soppresso)" },
    { "code": "D595", "province": "IS", "name": "FILIGNANO" },
    { "code": "D596", "province": "CZ", "name": "FILOGASO (soppresso)" },
    { "code": "D596", "province": "VV", "name": "FILOGASO" },
    { "code": "D597", "province": "AN", "name": "FILOTTRANO" },
    { "code": "D598", "province": "GE", "name": "FINALBORGO (soppresso)" },
    { "code": "D598", "province": "SV", "name": "FINALBORGO (soppresso)" },
    { "code": "D599", "province": "MO", "name": "FINALE EMILIA" },
    { "code": "D600", "province": "SV", "name": "FINALE LIGURE" },
    { "code": "D601", "province": "GE", "name": "FINALE MARINA (soppresso)" },
    { "code": "D601", "province": "SV", "name": "FINALE MARINA (soppresso)" },
    { "code": "D599", "province": "MO", "name": "FINALE NELL'EMILIA (soppresso)" },
    { "code": "D602", "province": "GE", "name": "FINALE PIA (soppresso)" },
    { "code": "D602", "province": "SV", "name": "FINALE PIA (soppresso)" },
    { "code": "D603", "province": "NO", "name": "FINERO (soppresso)" },
    { "code": "D604", "province": "BG", "name": "FINO DEL MONTE" },
    { "code": "D605", "province": "CO", "name": "FINO MORNASCO" },
    { "code": "D606", "province": "BG", "name": "FIORANO AL SERIO" },
    { "code": "D608", "province": "TO", "name": "FIORANO CANAVESE" },
    { "code": "D608", "province": "AO", "name": "FIORANO CANAVESE (soppresso)" },
    { "code": "D607", "province": "MO", "name": "FIORANO MODENESE" },
    { "code": "D609", "province": "MC", "name": "FIORDIMONTE (soppresso)" },
    { "code": "D611", "province": "PC", "name": "FIORENZUOLA D'ARDA" },
    { "code": "D610", "province": "PS", "name": "FIORENZUOLA DI FOCARA (soppresso)" },
    { "code": "D612", "province": "FI", "name": "FIRENZE" },
    { "code": "D613", "province": "FI", "name": "FIRENZUOLA" },
    { "code": "D614", "province": "CS", "name": "FIRMO" },
    { "code": "M323", "province": "FE", "name": "FISCAGLIA" },
    { "code": "D615", "province": "SA", "name": "FISCIANO" },
    { "code": "D616", "province": "TN", "name": "FISTO (soppresso)" },
    { "code": "A310", "province": "RM", "name": "FIUGGI (soppresso)" },
    { "code": "A310", "province": "FR", "name": "FIUGGI" },
    { "code": "D617", "province": "MO", "name": "FIUMALBO" },
    { "code": "D618", "province": "FO", "name": "FIUMANA (soppresso)" },
    { "code": "D619", "province": "RC", "name": "FIUMARA" },
    { "code": "D621", "province": "UD", "name": "FIUME (soppresso)" },
    { "code": "D620", "province": "FU", "name": "FIUME (soppresso)" },
    { "code": "D621", "province": "UD", "name": "FIUME VENETO (soppresso)" },
    { "code": "D621", "province": "PN", "name": "FIUME VENETO" },
    { "code": "D622", "province": "ME", "name": "FIUMEDINISI" },
    { "code": "D624", "province": "CS", "name": "FIUMEFREDDO BRUZIO" },
    { "code": "D623", "province": "CT", "name": "FIUMEFREDDO DI SICILIA" },
    { "code": "D625", "province": "BG", "name": "FIUMENERO (soppresso)" },
    { "code": "D627", "province": "UD", "name": "FIUMICELLO (soppresso)" },
    { "code": "M400", "province": "UD", "name": "FIUMICELLO VILLA VICENTINA" },
    { "code": "M297", "province": "RM", "name": "FIUMICINO" },
    { "code": "D628", "province": "MC", "name": "FIUMINATA" },
    { "code": "D629", "province": "MS", "name": "FIVIZZANO" },
    { "code": "D630", "province": "UD", "name": "FLAIBANO" },
    { "code": "D631", "province": "TN", "name": "FLAVON (soppresso)" },
    { "code": "D632", "province": "NO", "name": "FLECCHIA (soppresso)" },
    { "code": "D632", "province": "VC", "name": "FLECCHIA (soppresso)" },
    { "code": "D633", "province": "TN", "name": "FLERES (soppresso)" },
    { "code": "D633", "province": "BZ", "name": "FLERES (soppresso)" },
    { "code": "D634", "province": "BS", "name": "FLERO" },
    { "code": "D635", "province": "ME", "name": "FLORESTA" },
    { "code": "D636", "province": "SR", "name": "FLORIDIA" },
    { "code": "D637", "province": "SS", "name": "FLORINAS" },
    { "code": "D638", "province": "AV", "name": "FLUMERI" },
    { "code": "D639", "province": "CA", "name": "FLUMINIMAGGIORE (soppresso)" },
    { "code": "D639", "province": "CI", "name": "FLUMINIMAGGIORE (soppresso)" },
    { "code": "D639", "province": "SU", "name": "FLUMINIMAGGIORE" },
    { "code": "D640", "province": "CA", "name": "FLUSSIO (soppresso)" },
    { "code": "D640", "province": "NU", "name": "FLUSSIO (soppresso)" },
    { "code": "D640", "province": "OR", "name": "FLUSSIO" },
    { "code": "D641", "province": "NO", "name": "FOBELLO (soppresso)" },
    { "code": "D641", "province": "VC", "name": "FOBELLO" },
    { "code": "D642", "province": "GE", "name": "FOCE (soppresso)" },
    { "code": "D643", "province": "FG", "name": "FOGGIA" },
    { "code": "D644", "province": "BN", "name": "FOGLIANISE" },
    { "code": "D645", "province": "GO", "name": "FOGLIANO (soppresso)" },
    { "code": "D645", "province": "TS", "name": "FOGLIANO (soppresso)" },
    { "code": "D645", "province": "TS", "name": "FOGLIANO DI MONFALCONE (soppresso)" },
    { "code": "D645", "province": "TS", "name": "FOGLIANO REDIPUGLIA (soppresso)" },
    { "code": "D645", "province": "GO", "name": "FOGLIANO REDIPUGLIA" },
    { "code": "D646", "province": "TO", "name": "FOGLIZZO" },
    { "code": "D648", "province": "TN", "name": "FOIANA (soppresso)" },
    { "code": "D648", "province": "BZ", "name": "FOIANA (soppresso)" },
    { "code": "D649", "province": "AR", "name": "FOIANO DELLA CHIANA" },
    { "code": "D650", "province": "BN", "name": "FOIANO DI VAL FORTORE" },
    { "code": "D651", "province": "TN", "name": "FOLGARIA" },
    { "code": "D652", "province": "AP", "name": "FOLIGNANO" },
    { "code": "D653", "province": "PG", "name": "FOLIGNO" },
    { "code": "D654", "province": "TV", "name": "FOLLINA" },
    { "code": "D655", "province": "GE", "name": "FOLLO (soppresso)" },
    { "code": "D655", "province": "SP", "name": "FOLLO" },
    { "code": "D656", "province": "GR", "name": "FOLLONICA" },
    { "code": "D657", "province": "NO", "name": "FOLSOGNO (soppresso)" },
    { "code": "D659", "province": "NO", "name": "FOMARCO (soppresso)" },
    { "code": "D660", "province": "MI", "name": "FOMBIO (soppresso)" },
    { "code": "D660", "province": "LO", "name": "FOMBIO" },
    { "code": "D661", "province": "ME", "name": "FONDACHELLI-FANTINA" },
    { "code": "D662", "province": "CE", "name": "FONDI (soppresso)" },
    { "code": "D662", "province": "RM", "name": "FONDI (soppresso)" },
    { "code": "D662", "province": "LT", "name": "FONDI" },
    { "code": "D663", "province": "TN", "name": "FONDO" },
    { "code": "D664", "province": "BG", "name": "FONDRA (soppresso)" },
    { "code": "D665", "province": "SS", "name": "FONNI (soppresso)" },
    { "code": "D665", "province": "NU", "name": "FONNI" },
    { "code": "D666", "province": "TO", "name": "FONTAINEMORE (soppresso)" },
    { "code": "D666", "province": "AO", "name": "FONTAINEMORE" },
    { "code": "D669", "province": "FU", "name": "FONTANA DEL CONTE (soppresso)" },
    { "code": "D669", "province": "PL", "name": "FONTANA DEL CONTE (soppresso)" },
    { "code": "D668", "province": "BO", "name": "FONTANA ELICE (soppresso)" },
    { "code": "D667", "province": "CE", "name": "FONTANA LIRI (soppresso)" },
    { "code": "D667", "province": "FR", "name": "FONTANA LIRI" },
    { "code": "D670", "province": "UD", "name": "FONTANAFREDDA (soppresso)" },
    { "code": "D670", "province": "PN", "name": "FONTANAFREDDA" },
    { "code": "D671", "province": "AV", "name": "FONTANAROSA" },
    { "code": "D668", "province": "BO", "name": "FONTANELICE" },
    { "code": "D672", "province": "BG", "name": "FONTANELLA" },
    { "code": "D673", "province": "PR", "name": "FONTANELLATO" },
    { "code": "D674", "province": "TV", "name": "FONTANELLE" },
    { "code": "D675", "province": "NO", "name": "FONTANETO D'AGOGNA" },
    { "code": "D676", "province": "NO", "name": "FONTANETTO DA PO (soppresso)" },
    { "code": "D676", "province": "VC", "name": "FONTANETTO DA PO (soppresso)" },
    { "code": "D676", "province": "VC", "name": "FONTANETTO PO" },
    { "code": "D677", "province": "PV", "name": "FONTANIGORDA (soppresso)" },
    { "code": "D677", "province": "GE", "name": "FONTANIGORDA" },
    { "code": "D678", "province": "AL", "name": "FONTANILE (soppresso)" },
    { "code": "D678", "province": "AT", "name": "FONTANILE" },
    { "code": "D679", "province": "PD", "name": "FONTANIVA" },
    { "code": "D680", "province": "TV", "name": "FONTE" },
    { "code": "M309", "province": "RM", "name": "FONTE NUOVA" },
    { "code": "D681", "province": "AQ", "name": "FONTECCHIO" },
    { "code": "D682", "province": "CE", "name": "FONTECHIARI (soppresso)" },
    { "code": "D682", "province": "FR", "name": "FONTECHIARI" },
    { "code": "D683", "province": "CE", "name": "FONTEGRECA" },
    { "code": "D683", "province": "CB", "name": "FONTEGRECA (soppresso)" },
    { "code": "D684", "province": "BG", "name": "FONTENO" },
    { "code": "D685", "province": "PR", "name": "FONTEVIVO" },
    { "code": "D686", "province": "BL", "name": "FONZASO" },
    { "code": "D688", "province": "BG", "name": "FOPPOLO" },
    { "code": "D689", "province": "PG", "name": "FORANO (soppresso)" },
    { "code": "D689", "province": "RM", "name": "FORANO (soppresso)" },
    { "code": "D689", "province": "RI", "name": "FORANO" },
    { "code": "D691", "province": "AP", "name": "FORCE" },
    { "code": "D693", "province": "BN", "name": "FORCHIA" },
    { "code": "D694", "province": "SO", "name": "FORCOLA" },
    { "code": "D695", "province": "CA", "name": "FORDONGIANUS (soppresso)" },
    { "code": "D695", "province": "OR", "name": "FORDONGIANUS" },
    { "code": "D696", "province": "PZ", "name": "FORENZA" },
    { "code": "D699", "province": "TO", "name": "FORESTO DI SUSA (soppresso)" },
    { "code": "D698", "province": "NO", "name": "FORESTO SESIA (soppresso)" },
    { "code": "D698", "province": "VC", "name": "FORESTO SESIA (soppresso)" },
    { "code": "D697", "province": "BG", "name": "FORESTO SPARSO" },
    { "code": "D700", "province": "UD", "name": "FORGARIA (soppresso)" },
    { "code": "D700", "province": "UD", "name": "FORGARIA NEL FRIULI" },
    { "code": "D700", "province": "PN", "name": "FORGARIA NEL FRIULI (soppresso)" },
    { "code": "D701", "province": "AV", "name": "FORINO" },
    { "code": "D702", "province": "NA", "name": "FORIO" },
    { "code": "D704", "province": "FO", "name": "FORLI' (soppresso)" },
    { "code": "D704", "province": "FC", "name": "FORLI'" },
    { "code": "D703", "province": "CB", "name": "FORLI' DEL SANNIO (soppresso)" },
    { "code": "D703", "province": "IS", "name": "FORLI' DEL SANNIO" },
    { "code": "D705", "province": "FO", "name": "FORLIMPOPOLI (soppresso)" },
    { "code": "D705", "province": "FC", "name": "FORLIMPOPOLI" },
    { "code": "D706", "province": "NO", "name": "FORMAZZA (soppresso)" },
    { "code": "D706", "province": "VB", "name": "FORMAZZA" },
    { "code": "D707", "province": "RM", "name": "FORMELLO" },
    { "code": "D708", "province": "CE", "name": "FORMIA (soppresso)" },
    { "code": "D708", "province": "RM", "name": "FORMIA (soppresso)" },
    { "code": "D708", "province": "LT", "name": "FORMIA" },
    { "code": "D709", "province": "CE", "name": "FORMICOLA" },
    { "code": "D709", "province": "NA", "name": "FORMICOLA (soppresso)" },
    { "code": "D710", "province": "CR", "name": "FORMIGARA" },
    { "code": "D711", "province": "MO", "name": "FORMIGINE" },
    { "code": "D712", "province": "NO", "name": "FORMIGLIANA (soppresso)" },
    { "code": "D712", "province": "VC", "name": "FORMIGLIANA" },
    { "code": "D713", "province": "FE", "name": "FORMIGNANA (soppresso)" },
    { "code": "D714", "province": "TN", "name": "FORNACE" },
    { "code": "D715", "province": "CB", "name": "FORNELLI (soppresso)" },
    { "code": "D715", "province": "IS", "name": "FORNELLI" },
    { "code": "D716", "province": "NO", "name": "FORNERO (soppresso)" },
    { "code": "D717", "province": "VI", "name": "FORNI (soppresso)" },
    { "code": "D718", "province": "UD", "name": "FORNI AVOLTRI" },
    { "code": "D719", "province": "UD", "name": "FORNI DI SOPRA" },
    { "code": "D720", "province": "UD", "name": "FORNI DI SOTTO" },
    { "code": "D721", "province": "VI", "name": "FORNI DI VAL D'ASTICO (soppresso)" },
    { "code": "D722", "province": "NO", "name": "FORNO (soppresso)" },
    { "code": "D723", "province": "TN", "name": "FORNO (soppresso)" },
    { "code": "D724", "province": "TO", "name": "FORNO ALPI GRAJE (soppresso)" },
    { "code": "D725", "province": "TO", "name": "FORNO CANAVESE" },
    { "code": "B574", "province": "BL", "name": "FORNO DI CANALE (soppresso)" },
    { "code": "D725", "province": "TO", "name": "FORNO DI RIVARA (soppresso)" },
    { "code": "D726", "province": "BL", "name": "FORNO DI ZOLDO (soppresso)" },
    { "code": "D727", "province": "BG", "name": "FORNOVO DI SAN GIOVANNI (soppresso)" },
    { "code": "D728", "province": "PR", "name": "FORNOVO DI TARO" },
    { "code": "D727", "province": "BG", "name": "FORNOVO SAN GIOVANNI" },
    { "code": "D729", "province": "AL", "name": "FOROTONDO (soppresso)" },
    { "code": "D730", "province": "LU", "name": "FORTE DEI MARMI" },
    { "code": "D731", "province": "BZ", "name": "FORTEZZA" },
    { "code": "D732", "province": "PV", "name": "FORTUNAGO" },
    { "code": "D733", "province": "ME", "name": "FORZA D'AGRO'" },
    { "code": "D734", "province": "MS", "name": "FOSCIANDORA (soppresso)" },
    { "code": "D734", "province": "LU", "name": "FOSCIANDORA" },
    { "code": "D735", "province": "MS", "name": "FOSDINOVO" },
    { "code": "D736", "province": "AQ", "name": "FOSSA" },
    { "code": "D739", "province": "CR", "name": "FOSSA GUAZZONA (soppresso)" },
    { "code": "D738", "province": "CH", "name": "FOSSACESIA" },
    { "code": "D740", "province": "VE", "name": "FOSSALTA DI PIAVE" },
    { "code": "D741", "province": "VE", "name": "FOSSALTA DI PORTOGRUARO" },
    { "code": "D737", "province": "CB", "name": "FOSSALTO" },
    { "code": "D742", "province": "CN", "name": "FOSSANO" },
    { "code": "D743", "province": "PV", "name": "FOSSARMATO (soppresso)" },
    { "code": "D745", "province": "PG", "name": "FOSSATO DI VICO" },
    { "code": "D744", "province": "CZ", "name": "FOSSATO SERRALTA" },
    { "code": "D747", "province": "NO", "name": "FOSSENO (soppresso)" },
    { "code": "D748", "province": "VE", "name": "FOSSO'" },
    { "code": "D749", "province": "PS", "name": "FOSSOMBRONE (soppresso)" },
    { "code": "D749", "province": "PU", "name": "FOSSOMBRONE" },
    { "code": "D750", "province": "VI", "name": "FOZA" },
    { "code": "D751", "province": "CN", "name": "FRABOSA SOPRANA" },
    { "code": "D752", "province": "CN", "name": "FRABOSA SOTTANA" },
    { "code": "D559", "province": "AL", "name": "FRACONALTO" },
    { "code": "D754", "province": "LE", "name": "FRAGAGNANO (soppresso)" },
    { "code": "D754", "province": "TA", "name": "FRAGAGNANO" },
    { "code": "D755", "province": "BN", "name": "FRAGNETO L'ABATE" },
    { "code": "D756", "province": "BN", "name": "FRAGNETO MONFORTE" },
    { "code": "D757", "province": "CH", "name": "FRAINE" },
    { "code": "D758", "province": "GE", "name": "FRAMURA (soppresso)" },
    { "code": "D758", "province": "SP", "name": "FRAMURA" },
    { "code": "D763", "province": "CH", "name": "FRANCAVILLA AL MARE" },
    { "code": "D762", "province": "CZ", "name": "FRANCAVILLA ANGITOLA (soppresso)" },
    { "code": "D762", "province": "VV", "name": "FRANCAVILLA ANGITOLA" },
    { "code": "D759", "province": "AL", "name": "FRANCAVILLA BISIO" },
    { "code": "D760", "province": "AP", "name": "FRANCAVILLA D'ETE (soppresso)" },
    { "code": "D760", "province": "FM", "name": "FRANCAVILLA D'ETE" },
    { "code": "D765", "province": "ME", "name": "FRANCAVILLA DI SICILIA" },
    { "code": "D761", "province": "LE", "name": "FRANCAVILLA FONTANA (soppresso)" },
    { "code": "D761", "province": "BR", "name": "FRANCAVILLA FONTANA" },
    { "code": "D766", "province": "PZ", "name": "FRANCAVILLA IN SINNI" },
    { "code": "D764", "province": "CS", "name": "FRANCAVILLA MARITTIMA" },
    { "code": "D767", "province": "CZ", "name": "FRANCICA (soppresso)" },
    { "code": "D767", "province": "VV", "name": "FRANCICA" },
    { "code": "D768", "province": "SR", "name": "FRANCOFONTE" },
    { "code": "D769", "province": "CE", "name": "FRANCOLISE" },
    { "code": "D769", "province": "NA", "name": "FRANCOLISE (soppresso)" },
    { "code": "D770", "province": "AL", "name": "FRASCARO" },
    { "code": "D771", "province": "PV", "name": "FRASCAROLO" },
    { "code": "D772", "province": "AL", "name": "FRASCATA (soppresso)" },
    { "code": "D773", "province": "RM", "name": "FRASCATI" },
    { "code": "D774", "province": "CS", "name": "FRASCINETO" },
    { "code": "D775", "province": "TN", "name": "FRASSILONGO" },
    { "code": "D776", "province": "RO", "name": "FRASSINELLE POLESINE" },
    { "code": "D777", "province": "AL", "name": "FRASSINELLO MONFERRATO" },
    { "code": "D778", "province": "AL", "name": "FRASSINELLO-OLIVOLA (soppresso)" },
    { "code": "D779", "province": "TO", "name": "FRASSINERE (soppresso)" },
    { "code": "D780", "province": "AL", "name": "FRASSINETO PO" },
    { "code": "D781", "province": "TO", "name": "FRASSINETTO" },
    { "code": "D781", "province": "AO", "name": "FRASSINETTO (soppresso)" },
    { "code": "D782", "province": "CN", "name": "FRASSINO" },
    { "code": "D783", "province": "MO", "name": "FRASSINORO" },
    { "code": "D785", "province": "PG", "name": "FRASSO SABINO (soppresso)" },
    { "code": "D785", "province": "RM", "name": "FRASSO SABINO (soppresso)" },
    { "code": "D785", "province": "RI", "name": "FRASSO SABINO" },
    { "code": "D784", "province": "BN", "name": "FRASSO TELESINO" },
    { "code": "D788", "province": "RO", "name": "FRATTA POLESINE" },
    { "code": "D787", "province": "PG", "name": "FRATTA TODINA" },
    { "code": "D789", "province": "NA", "name": "FRATTAMAGGIORE" },
    { "code": "D790", "province": "NA", "name": "FRATTAMINORE" },
    { "code": "D791", "province": "PS", "name": "FRATTE ROSA (soppresso)" },
    { "code": "D791", "province": "PU", "name": "FRATTE ROSA" },
    { "code": "D792", "province": "TN", "name": "FRAVEGGIO (soppresso)" },
    { "code": "D793", "province": "ME", "name": "FRAZZANO'" },
    { "code": "D794", "province": "TV", "name": "FREGONA" },
    { "code": "D795", "province": "BG", "name": "FREROLA (soppresso)" },
    { "code": "D796", "province": "CH", "name": "FRESAGRANDINARIA" },
    { "code": "D797", "province": "AL", "name": "FRESONARA" },
    { "code": "D798", "province": "AV", "name": "FRIGENTO" },
    { "code": "D799", "province": "NA", "name": "FRIGNANO (soppresso)" },
    { "code": "D799", "province": "CE", "name": "FRIGNANO" },
    { "code": "D800", "province": "CE", "name": "FRIGNANO MAGGIORE (soppresso)" },
    { "code": "D800", "province": "NA", "name": "FRIGNANO MAGGIORE (soppresso)" },
    { "code": "D801", "province": "CE", "name": "FRIGNANO PICCOLO (soppresso)" },
    { "code": "D801", "province": "NA", "name": "FRIGNANO PICCOLO (soppresso)" },
    { "code": "D802", "province": "AL", "name": "FRINCO (soppresso)" },
    { "code": "D802", "province": "AT", "name": "FRINCO" },
    { "code": "D803", "province": "CH", "name": "FRISA" },
    { "code": "D804", "province": "UD", "name": "FRISANCO (soppresso)" },
    { "code": "D804", "province": "PN", "name": "FRISANCO" },
    { "code": "D805", "province": "TO", "name": "FRONT" },
    { "code": "D806", "province": "BS", "name": "FRONTIGNANO (soppresso)" },
    { "code": "D807", "province": "PS", "name": "FRONTINO (soppresso)" },
    { "code": "D807", "province": "PU", "name": "FRONTINO" },
    { "code": "D808", "province": "PS", "name": "FRONTONE (soppresso)" },
    { "code": "D808", "province": "PU", "name": "FRONTONE" },
    { "code": "D809", "province": "PS", "name": "FRONTONE-SERRA (soppresso)" },
    { "code": "D810", "province": "RM", "name": "FROSINONE (soppresso)" },
    { "code": "D810", "province": "FR", "name": "FROSINONE" },
    { "code": "D811", "province": "CB", "name": "FROSOLONE (soppresso)" },
    { "code": "D811", "province": "IS", "name": "FROSOLONE" },
    { "code": "D812", "province": "TO", "name": "FROSSASCO" },
    { "code": "D813", "province": "AL", "name": "FRUGAROLO" },
    { "code": "D814", "province": "AL", "name": "FUBINE (soppresso)" },
    { "code": "D814", "province": "AL", "name": "FUBINE MONFERRATO" },
    { "code": "D815", "province": "FI", "name": "FUCECCHIO" },
    { "code": "D816", "province": "BG", "name": "FUIPIANO AL BREMBO (soppresso)" },
    { "code": "D817", "province": "BG", "name": "FUIPIANO VALLE IMAGNA" },
    { "code": "D818", "province": "VR", "name": "FUMANE" },
    { "code": "D819", "province": "RM", "name": "FUMONE (soppresso)" },
    { "code": "D819", "province": "FR", "name": "FUMONE" },
    { "code": "D820", "province": "TN", "name": "FUNDOLES (soppresso)" },
    { "code": "D820", "province": "TN", "name": "FUNDRES (soppresso)" },
    { "code": "D820", "province": "BZ", "name": "FUNDRES (soppresso)" },
    { "code": "D821", "province": "TN", "name": "FUNES (soppresso)" },
    { "code": "D821", "province": "BZ", "name": "FUNES" },
    { "code": "D823", "province": "CH", "name": "FURCI" },
    { "code": "D824", "province": "ME", "name": "FURCI SICULO" },
    { "code": "D825", "province": "ME", "name": "FURNARI" },
    { "code": "D826", "province": "SA", "name": "FURORE" },
    { "code": "D827", "province": "CA", "name": "FURTEI (soppresso)" },
    { "code": "D827", "province": "VS", "name": "FURTEI (soppresso)" },
    { "code": "D827", "province": "SU", "name": "FURTEI" },
    { "code": "D828", "province": "CS", "name": "FUSCALDO" },
    { "code": "D829", "province": "RA", "name": "FUSIGNANO" },
    { "code": "D830", "province": "SO", "name": "FUSINE" },
    { "code": "D831", "province": "UD", "name": "FUSINE IN VALROMANA (soppresso)" },
    { "code": "D832", "province": "SA", "name": "FUTANI" },
    { "code": "D833", "province": "CR", "name": "GABBIONETA (soppresso)" },
    { "code": "D834", "province": "CR", "name": "GABBIONETA-BINANUOVA" },
    { "code": "D837", "province": "GO", "name": "GABERIE (soppresso)" },
    { "code": "D837", "province": "UD", "name": "GABERIE (soppresso)" },
    { "code": "D835", "province": "AL", "name": "GABIANO" },
    { "code": "D836", "province": "PS", "name": "GABICCE (soppresso)" },
    { "code": "D836", "province": "PS", "name": "GABICCE MARE (soppresso)" },
    { "code": "D836", "province": "PU", "name": "GABICCE MARE" },
    { "code": "D837", "province": "UD", "name": "GABRIA (soppresso)" },
    { "code": "D837", "province": "GO", "name": "GABRIA (soppresso)" },
    { "code": "D838", "province": "GO", "name": "GABROVIZZA (soppresso)" },
    { "code": "D838", "province": "UD", "name": "GABROVIZZA (soppresso)" },
    { "code": "D839", "province": "AO", "name": "GABY" },
    { "code": "D840", "province": "CR", "name": "GADESCO (soppresso)" },
    { "code": "D841", "province": "CR", "name": "GADESCO-PIEVE DELMONA" },
    { "code": "D842", "province": "CA", "name": "GADONI (soppresso)" },
    { "code": "D842", "province": "NU", "name": "GADONI" },
    { "code": "D843", "province": "CE", "name": "GAETA (soppresso)" },
    { "code": "D843", "province": "RM", "name": "GAETA (soppresso)" },
    { "code": "D843", "province": "LT", "name": "GAETA" },
    { "code": "D844", "province": "ME", "name": "GAGGI" },
    { "code": "D845", "province": "MI", "name": "GAGGIANO" },
    { "code": "D846", "province": "CO", "name": "GAGGINO (soppresso)" },
    { "code": "D847", "province": "BO", "name": "GAGGIO MONTANO" },
    { "code": "D848", "province": "NO", "name": "GAGLIANICO (soppresso)" },
    { "code": "D848", "province": "VC", "name": "GAGLIANICO (soppresso)" },
    { "code": "D848", "province": "BI", "name": "GAGLIANICO" },
    { "code": "D850", "province": "AQ", "name": "GAGLIANO ATERNO" },
    { "code": "D849", "province": "CT", "name": "GAGLIANO CASTELFERRATO (soppresso)" },
    { "code": "D849", "province": "EN", "name": "GAGLIANO CASTELFERRATO" },
    { "code": "D851", "province": "LE", "name": "GAGLIANO DEL CAPO" },
    { "code": "D852", "province": "CZ", "name": "GAGLIATO" },
    { "code": "D853", "province": "MC", "name": "GAGLIOLE" },
    { "code": "D854", "province": "TV", "name": "GAIARINE" },
    { "code": "D855", "province": "RO", "name": "GAIBA" },
    { "code": "D856", "province": "CN", "name": "GAIOLA" },
    { "code": "D857", "province": "CN", "name": "GAIOLA MOIOLA (soppresso)" },
    { "code": "D858", "province": "SI", "name": "GAIOLE (soppresso)" },
    { "code": "D858", "province": "SI", "name": "GAIOLE IN CHIANTI" },
    { "code": "D859", "province": "CA", "name": "GAIRO (soppresso)" },
    { "code": "D859", "province": "NU", "name": "GAIRO" },
    { "code": "D859", "province": "OG", "name": "GAIRO (soppresso)" },
    { "code": "D860", "province": "TN", "name": "GAIS (soppresso)" },
    { "code": "D860", "province": "BZ", "name": "GAIS" },
    { "code": "D861", "province": "ME", "name": "GALATI MAMERTINO" },
    { "code": "D862", "province": "LE", "name": "GALATINA" },
    { "code": "D863", "province": "LE", "name": "GALATONE" },
    { "code": "D864", "province": "RC", "name": "GALATRO" },
    { "code": "D865", "province": "CO", "name": "GALBIATE (soppresso)" },
    { "code": "D865", "province": "LC", "name": "GALBIATE" },
    { "code": "D866", "province": "SA", "name": "GALDO (soppresso)" },
    { "code": "D867", "province": "FI", "name": "GALEATA (soppresso)" },
    { "code": "D867", "province": "FO", "name": "GALEATA (soppresso)" },
    { "code": "D867", "province": "FC", "name": "GALEATA" },
    { "code": "D868", "province": "MI", "name": "GALGAGNANO (soppresso)" },
    { "code": "D868", "province": "LO", "name": "GALGAGNANO" },
    { "code": "D869", "province": "MI", "name": "GALLARATE (soppresso)" },
    { "code": "D869", "province": "VA", "name": "GALLARATE" },
    { "code": "D870", "province": "RM", "name": "GALLESE (soppresso)" },
    { "code": "D870", "province": "VT", "name": "GALLESE" },
    { "code": "D872", "province": "NO", "name": "GALLIATE" },
    { "code": "D871", "province": "CO", "name": "GALLIATE LOMBARDO (soppresso)" },
    { "code": "D871", "province": "VA", "name": "GALLIATE LOMBARDO" },
    { "code": "D873", "province": "PV", "name": "GALLIAVOLA" },
    { "code": "D874", "province": "MS", "name": "GALLICANO (soppresso)" },
    { "code": "D874", "province": "LU", "name": "GALLICANO" },
    { "code": "D875", "province": "RM", "name": "GALLICANO NEL LAZIO" },
    { "code": "D876", "province": "PZ", "name": "GALLICCHIO" },
    { "code": "D877", "province": "RC", "name": "GALLICO (soppresso)" },
    { "code": "D878", "province": "BO", "name": "GALLIERA" },
    { "code": "D879", "province": "PD", "name": "GALLIERA VENETA" },
    { "code": "D880", "province": "RC", "name": "GALLINA (soppresso)" },
    { "code": "D881", "province": "FR", "name": "GALLINARO" },
    { "code": "D882", "province": "VI", "name": "GALLIO" },
    { "code": "D883", "province": "LE", "name": "GALLIPOLI" },
    { "code": "D884", "province": "CE", "name": "GALLO (soppresso)" },
    { "code": "D884", "province": "CB", "name": "GALLO (soppresso)" },
    { "code": "D884", "province": "CE", "name": "GALLO MATESE" },
    { "code": "D885", "province": "ME", "name": "GALLODORO" },
    { "code": "D886", "province": "CE", "name": "GALLUCCIO" },
    { "code": "D886", "province": "NA", "name": "GALLUCCIO (soppresso)" },
    { "code": "D887", "province": "FI", "name": "GALLUZZO (soppresso)" },
    { "code": "D888", "province": "SS", "name": "GALTELLI' (soppresso)" },
    { "code": "D888", "province": "NU", "name": "GALTELLI'" },
    { "code": "D889", "province": "PD", "name": "GALZIGNANO (soppresso)" },
    { "code": "D889", "province": "PD", "name": "GALZIGNANO TERME" },
    { "code": "D890", "province": "AL", "name": "GAMALERO" },
    { "code": "D891", "province": "BS", "name": "GAMBARA" },
    { "code": "D892", "province": "PV", "name": "GAMBARANA" },
    { "code": "D894", "province": "CN", "name": "GAMBASCA" },
    { "code": "D895", "province": "FI", "name": "GAMBASSI (soppresso)" },
    { "code": "D895", "province": "FI", "name": "GAMBASSI TERME" },
    { "code": "D896", "province": "CB", "name": "GAMBATESA" },
    { "code": "D897", "province": "VI", "name": "GAMBELLARA" },
    { "code": "D898", "province": "CH", "name": "GAMBERALE" },
    { "code": "D899", "province": "FO", "name": "GAMBETTOLA (soppresso)" },
    { "code": "D899", "province": "FC", "name": "GAMBETTOLA" },
    { "code": "D901", "province": "PV", "name": "GAMBOLO'" },
    { "code": "D902", "province": "VI", "name": "GAMBUGLIANO" },
    { "code": "D903", "province": "BG", "name": "GANDELLINO" },
    { "code": "D905", "province": "BG", "name": "GANDINO" },
    { "code": "D906", "province": "BG", "name": "GANDOSSO" },
    { "code": "D907", "province": "PA", "name": "GANGI" },
    { "code": "D908", "province": "CO", "name": "GARABIOLO (soppresso)" },
    { "code": "D908", "province": "VA", "name": "GARABIOLO (soppresso)" },
    { "code": "D909", "province": "PZ", "name": "GARAGUSO (soppresso)" },
    { "code": "D909", "province": "MT", "name": "GARAGUSO" },
    { "code": "D910", "province": "AL", "name": "GARBAGNA" },
    { "code": "D911", "province": "NO", "name": "GARBAGNA NOVARESE" },
    { "code": "D912", "province": "MI", "name": "GARBAGNATE MILANESE" },
    { "code": "D913", "province": "CO", "name": "GARBAGNATE MONASTERO (soppresso)" },
    { "code": "D913", "province": "LC", "name": "GARBAGNATE MONASTERO" },
    { "code": "D915", "province": "VR", "name": "GARDA" },
    { "code": "D916", "province": "TN", "name": "GARDOLO AL PIANO (soppresso)" },
    { "code": "D917", "province": "BS", "name": "GARDONE RIVIERA" },
    { "code": "D918", "province": "BS", "name": "GARDONE VAL TROMPIA" },
    { "code": "D919", "province": "MI", "name": "GAREGNANO (soppresso)" },
    { "code": "D920", "province": "CN", "name": "GARESSIO" },
    { "code": "D921", "province": "NO", "name": "GARGALLO" },
    { "code": "D922", "province": "GO", "name": "GARGARO (soppresso)" },
    { "code": "D922", "province": "UD", "name": "GARGARO (soppresso)" },
    { "code": "D923", "province": "TN", "name": "GARGAZZONE (soppresso)" },
    { "code": "D923", "province": "BZ", "name": "GARGAZZONE" },
    { "code": "D924", "province": "BS", "name": "GARGNANO" },
    { "code": "D925", "province": "PV", "name": "GARLASCO" },
    { "code": "D926", "province": "CO", "name": "GARLATE (soppresso)" },
    { "code": "D926", "province": "LC", "name": "GARLATE" },
    { "code": "D927", "province": "GE", "name": "GARLENDA (soppresso)" },
    { "code": "D927", "province": "SV", "name": "GARLENDA" },
    { "code": "D928", "province": "TN", "name": "GARNIGA (soppresso)" },
    { "code": "D928", "province": "TN", "name": "GARNIGA TERME" },
    { "code": "D930", "province": "CO", "name": "GARZENO" },
    { "code": "D931", "province": "TO", "name": "GARZIGLIANA" },
    { "code": "D932", "province": "CZ", "name": "GASPERINA" },
    { "code": "D933", "province": "TO", "name": "GASSINO (soppresso)" },
    { "code": "D933", "province": "TO", "name": "GASSINO TORINESE" },
    { "code": "D934", "province": "RE", "name": "GATTATICO" },
    { "code": "D935", "province": "FO", "name": "GATTEO (soppresso)" },
    { "code": "D935", "province": "FC", "name": "GATTEO" },
    { "code": "D937", "province": "NO", "name": "GATTICO (soppresso)" },
    { "code": "M416", "province": "NO", "name": "GATTICO-VERUNO" },
    { "code": "D938", "province": "NO", "name": "GATTINARA (soppresso)" },
    { "code": "D938", "province": "VC", "name": "GATTINARA" },
    { "code": "D939", "province": "TO", "name": "GAUNA (soppresso)" },
    { "code": "D939", "province": "AO", "name": "GAUNA (soppresso)" },
    { "code": "D940", "province": "BS", "name": "GAVARDO" },
    { "code": "D941", "province": "AL", "name": "GAVAZZANA (soppresso)" },
    { "code": "D942", "province": "RO", "name": "GAVELLO" },
    { "code": "D943", "province": "BG", "name": "GAVERINA (soppresso)" },
    { "code": "D943", "province": "BG", "name": "GAVERINA TERME" },
    { "code": "D944", "province": "AL", "name": "GAVI" },
    { "code": "D945", "province": "RM", "name": "GAVIGNANO" },
    { "code": "D946", "province": "CO", "name": "GAVIRATE (soppresso)" },
    { "code": "D946", "province": "VA", "name": "GAVIRATE" },
    { "code": "D947", "province": "SS", "name": "GAVOI (soppresso)" },
    { "code": "D947", "province": "NU", "name": "GAVOI" },
    { "code": "D948", "province": "GR", "name": "GAVORRANO" },
    { "code": "D949", "province": "MN", "name": "GAZOLDO DEGLI IPPOLITI" },
    { "code": "D950", "province": "CO", "name": "GAZZADA (soppresso)" },
    { "code": "D950", "province": "VA", "name": "GAZZADA (soppresso)" },
    { "code": "D951", "province": "VA", "name": "GAZZADA SCHIANNO" },
    { "code": "D952", "province": "BG", "name": "GAZZANIGA" },
    { "code": "D954", "province": "IM", "name": "GAZZELLI (soppresso)" },
    { "code": "D956", "province": "PD", "name": "GAZZO" },
    { "code": "D957", "province": "VR", "name": "GAZZO VERONESE" },
    { "code": "D958", "province": "PC", "name": "GAZZOLA" },
    { "code": "D959", "province": "MN", "name": "GAZZUOLO" },
    { "code": "D960", "province": "CL", "name": "GELA" },
    { "code": "D400", "province": "FU", "name": "GELSANE (soppresso)" },
    { "code": "D400", "province": "PL", "name": "GELSANE (soppresso)" },
    { "code": "D961", "province": "FO", "name": "GEMMANO (soppresso)" },
    { "code": "D961", "province": "RN", "name": "GEMMANO" },
    { "code": "D962", "province": "UD", "name": "GEMONA (soppresso)" },
    { "code": "D962", "province": "UD", "name": "GEMONA DEL FRIULI" },
    { "code": "D963", "province": "CO", "name": "GEMONIO (soppresso)" },
    { "code": "D963", "province": "VA", "name": "GEMONIO" },
    { "code": "D964", "province": "RM", "name": "GENAZZANO" },
    { "code": "D965", "province": "AN", "name": "GENGA" },
    { "code": "D966", "province": "CR", "name": "GENIVOLTA" },
    { "code": "D967", "province": "CN", "name": "GENOLA" },
    { "code": "D968", "province": "CA", "name": "GENONI (soppresso)" },
    { "code": "D968", "province": "NU", "name": "GENONI (soppresso)" },
    { "code": "D968", "province": "OR", "name": "GENONI (soppresso)" },
    { "code": "D968", "province": "SU", "name": "GENONI" },
    { "code": "D969", "province": "GE", "name": "GENOVA" },
    { "code": "D970", "province": "CA", "name": "GENURI (soppresso)" },
    { "code": "D970", "province": "VS", "name": "GENURI (soppresso)" },
    { "code": "D970", "province": "SU", "name": "GENURI" },
    { "code": "D971", "province": "PZ", "name": "GENZANO (soppresso)" },
    { "code": "D971", "province": "MT", "name": "GENZANO (soppresso)" },
    { "code": "D971", "province": "MT", "name": "GENZANO DI LUCANIA (soppresso)" },
    { "code": "D971", "province": "PZ", "name": "GENZANO DI LUCANIA" },
    { "code": "D972", "province": "RM", "name": "GENZANO DI ROMA" },
    { "code": "D973", "province": "PV", "name": "GENZONE (soppresso)" },
    { "code": "D974", "province": "CO", "name": "GERA (soppresso)" },
    { "code": "D974", "province": "CO", "name": "GERA LARIO" },
    { "code": "D975", "province": "RC", "name": "GERACE" },
    { "code": "D976", "province": "RC", "name": "GERACE MARINA (soppresso)" },
    { "code": "D975", "province": "RC", "name": "GERACE SUPERIORE (soppresso)" },
    { "code": "D977", "province": "PA", "name": "GERACI SICULO" },
    { "code": "D978", "province": "RM", "name": "GERANO" },
    { "code": "D980", "province": "PV", "name": "GERENZAGO" },
    { "code": "D981", "province": "MI", "name": "GERENZANO (soppresso)" },
    { "code": "D981", "province": "VA", "name": "GERENZANO" },
    { "code": "D982", "province": "CA", "name": "GERGEI (soppresso)" },
    { "code": "D982", "province": "NU", "name": "GERGEI (soppresso)" },
    { "code": "D982", "province": "SU", "name": "GERGEI" },
    { "code": "D983", "province": "TO", "name": "GERMAGNANO" },
    { "code": "D984", "province": "NO", "name": "GERMAGNO (soppresso)" },
    { "code": "D984", "province": "VB", "name": "GERMAGNO" },
    { "code": "D985", "province": "CO", "name": "GERMANEDO (soppresso)" },
    { "code": "D986", "province": "CO", "name": "GERMASINO (soppresso)" },
    { "code": "D987", "province": "CO", "name": "GERMIGNAGA (soppresso)" },
    { "code": "D987", "province": "VA", "name": "GERMIGNAGA" },
    { "code": "D988", "province": "CZ", "name": "GEROCARNE (soppresso)" },
    { "code": "D988", "province": "VV", "name": "GEROCARNE" },
    { "code": "D990", "province": "SO", "name": "GEROLA ALTA" },
    { "code": "D989", "province": "BS", "name": "GEROLANUOVA (soppresso)" },
    { "code": "D991", "province": "BG", "name": "GEROSA (soppresso)" },
    { "code": "D993", "province": "CR", "name": "GERRE DE' CAPRIOLI" },
    { "code": "D994", "province": "CA", "name": "GESICO (soppresso)" },
    { "code": "D994", "province": "SU", "name": "GESICO" },
    { "code": "D995", "province": "MI", "name": "GESSATE" },
    { "code": "D996", "province": "CH", "name": "GESSOPALENA" },
    { "code": "D997", "province": "CA", "name": "GESTURI (soppresso)" },
    { "code": "D997", "province": "VS", "name": "GESTURI (soppresso)" },
    { "code": "D997", "province": "SU", "name": "GESTURI" },
    { "code": "D998", "province": "AV", "name": "GESUALDO" },
    { "code": "D999", "province": "BS", "name": "GHEDI" },
    { "code": "E001", "province": "NO", "name": "GHEMME" },
    { "code": "E002", "province": "NO", "name": "GHEVIO (soppresso)" },
    { "code": "E003", "province": "NO", "name": "GHIFFA (soppresso)" },
    { "code": "E003", "province": "VB", "name": "GHIFFA" },
    { "code": "E004", "province": "CA", "name": "GHILARZA (soppresso)" },
    { "code": "E004", "province": "OR", "name": "GHILARZA" },
    { "code": "E006", "province": "BG", "name": "GHISALBA" },
    { "code": "E007", "province": "NO", "name": "GHISLARENGO (soppresso)" },
    { "code": "E007", "province": "VC", "name": "GHISLARENGO" },
    { "code": "E008", "province": "RO", "name": "GIACCIANO CON BARUCHELLA" },
    { "code": "E009", "province": "TO", "name": "GIAGLIONE" },
    { "code": "E010", "province": "BS", "name": "GIANICO" },
    { "code": "E012", "province": "PG", "name": "GIANO DELL'UMBRIA" },
    { "code": "E011", "province": "CE", "name": "GIANO VETUSTO" },
    { "code": "E011", "province": "NA", "name": "GIANO VETUSTO (soppresso)" },
    { "code": "E013", "province": "PA", "name": "GIARDINELLO" },
    { "code": "E014", "province": "ME", "name": "GIARDINI (soppresso)" },
    { "code": "E014", "province": "ME", "name": "GIARDINI-NAXOS" },
    { "code": "E015", "province": "AL", "name": "GIAROLE" },
    { "code": "E016", "province": "SR", "name": "GIARRATANA (soppresso)" },
    { "code": "E016", "province": "RG", "name": "GIARRATANA" },
    { "code": "E017", "province": "CT", "name": "GIARRE" },
    { "code": "E018", "province": "CT", "name": "GIARRE RIPOSTO (soppresso)" },
    { "code": "E019", "province": "SS", "name": "GIAVE" },
    { "code": "E020", "province": "TO", "name": "GIAVENO" },
    { "code": "E021", "province": "TV", "name": "GIAVERA DEL MONTELLO" },
    { "code": "E022", "province": "CA", "name": "GIBA (soppresso)" },
    { "code": "E022", "province": "CI", "name": "GIBA (soppresso)" },
    { "code": "E022", "province": "SU", "name": "GIBA" },
    { "code": "E023", "province": "TP", "name": "GIBELLINA" },
    { "code": "E024", "province": "NO", "name": "GIFFLENGA (soppresso)" },
    { "code": "E024", "province": "VC", "name": "GIFFLENGA (soppresso)" },
    { "code": "E024", "province": "BI", "name": "GIFFLENGA" },
    { "code": "E025", "province": "RC", "name": "GIFFONE" },
    { "code": "E026", "province": "SA", "name": "GIFFONI SEI CASALI" },
    { "code": "E027", "province": "SA", "name": "GIFFONI VALLE PIANA" },
    { "code": "E028", "province": "NO", "name": "GIGNESE (soppresso)" },
    { "code": "E028", "province": "VB", "name": "GIGNESE" },
    { "code": "E029", "province": "TO", "name": "GIGNOD (soppresso)" },
    { "code": "E029", "province": "AO", "name": "GIGNOD" },
    { "code": "E030", "province": "CB", "name": "GILDONE" },
    { "code": "E031", "province": "CZ", "name": "GIMIGLIANO" },
    { "code": "E032", "province": "PL", "name": "GIMINO (soppresso)" },
    { "code": "E033", "province": "PZ", "name": "GINESTRA" },
    { "code": "E034", "province": "BN", "name": "GINESTRA DEGLI SCHIAVONI" },
    { "code": "E035", "province": "PS", "name": "GINESTRETO (soppresso)" },
    { "code": "E036", "province": "LE", "name": "GINOSA (soppresso)" },
    { "code": "E036", "province": "TA", "name": "GINOSA" },
    { "code": "E037", "province": "SA", "name": "GIOI" },
    { "code": "E040", "province": "AQ", "name": "GIOIA DEI MARSI" },
    { "code": "E038", "province": "BA", "name": "GIOIA DEL COLLE" },
    { "code": "E039", "province": "CE", "name": "GIOIA SANNITICA" },
    { "code": "E039", "province": "BN", "name": "GIOIA SANNITICA (soppresso)" },
    { "code": "E041", "province": "RC", "name": "GIOIA TAURO" },
    { "code": "E044", "province": "RC", "name": "GIOIOSA IONICA" },
    { "code": "E043", "province": "ME", "name": "GIOIOSA MAREA" },
    { "code": "E045", "province": "PG", "name": "GIOVE (soppresso)" },
    { "code": "E045", "province": "TR", "name": "GIOVE" },
    { "code": "E047", "province": "BA", "name": "GIOVINAZZO" },
    { "code": "E048", "province": "TN", "name": "GIOVO" },
    { "code": "E049", "province": "CA", "name": "GIRASOLE (soppresso)" },
    { "code": "E049", "province": "NU", "name": "GIRASOLE" },
    { "code": "E049", "province": "OG", "name": "GIRASOLE (soppresso)" },
    { "code": "A089", "province": "AG", "name": "GIRGENTI (soppresso)" },
    { "code": "E050", "province": "CZ", "name": "GIRIFALCO" },
    { "code": "E051", "province": "CO", "name": "GIRONICO (soppresso)" },
    { "code": "E052", "province": "CH", "name": "GISSI" },
    { "code": "E053", "province": "LE", "name": "GIUGGIANELLO" },
    { "code": "E054", "province": "NA", "name": "GIUGLIANO IN CAMPANIA" },
    { "code": "E055", "province": "PA", "name": "GIULIANA" },
    { "code": "E057", "province": "RM", "name": "GIULIANO DI ROMA (soppresso)" },
    { "code": "E057", "province": "FR", "name": "GIULIANO DI ROMA" },
    { "code": "E056", "province": "CH", "name": "GIULIANO TEATINO" },
    { "code": "E058", "province": "TE", "name": "GIULIANOVA" },
    { "code": "E059", "province": "MS", "name": "GIUNCUGNANO (soppresso)" },
    { "code": "E059", "province": "LU", "name": "GIUNCUGNANO (soppresso)" },
    { "code": "E060", "province": "SA", "name": "GIUNGANO" },
    { "code": "E061", "province": "LE", "name": "GIURDIGNANO" },
    { "code": "E062", "province": "PV", "name": "GIUSSAGO" },
    { "code": "E063", "province": "MI", "name": "GIUSSANO (soppresso)" },
    { "code": "E063", "province": "MB", "name": "GIUSSANO" },
    { "code": "E064", "province": "GE", "name": "GIUSTENICE (soppresso)" },
    { "code": "E064", "province": "SV", "name": "GIUSTENICE" },
    { "code": "E065", "province": "TN", "name": "GIUSTINO" },
    { "code": "E066", "province": "GE", "name": "GIUSVALLA (soppresso)" },
    { "code": "E066", "province": "SV", "name": "GIUSVALLA" },
    { "code": "E067", "province": "TO", "name": "GIVOLETTO" },
    { "code": "E068", "province": "CZ", "name": "GIZZERIA" },
    { "code": "E069", "province": "TN", "name": "GLORENZA (soppresso)" },
    { "code": "E069", "province": "BZ", "name": "GLORENZA" },
    { "code": "E071", "province": "TV", "name": "GODEGA DI SANT'URBANO" },
    { "code": "E072", "province": "PV", "name": "GODIASCO (soppresso)" },
    { "code": "E072", "province": "PV", "name": "GODIASCO SALICE TERME" },
    { "code": "E073", "province": "GO", "name": "GODOVICI (soppresso)" },
    { "code": "E073", "province": "UD", "name": "GODOVICI (soppresso)" },
    { "code": "E074", "province": "PA", "name": "GODRANO" },
    { "code": "E075", "province": "BS", "name": "GOGLIONE SOPRA (soppresso)" },
    { "code": "E076", "province": "BS", "name": "GOGLIONE SOTTO (soppresso)" },
    { "code": "E042", "province": "UD", "name": "GOIACI (soppresso)" },
    { "code": "E042", "province": "GO", "name": "GOIACI (soppresso)" },
    { "code": "E042", "province": "GO", "name": "GOIAZE (soppresso)" },
    { "code": "E042", "province": "UD", "name": "GOIAZE (soppresso)" },
    { "code": "E077", "province": "PV", "name": "GOIDO (soppresso)" },
    { "code": "E078", "province": "MN", "name": "GOITO" },
    { "code": "E079", "province": "MI", "name": "GOLASECCA (soppresso)" },
    { "code": "E079", "province": "VA", "name": "GOLASECCA" },
    { "code": "E080", "province": "PR", "name": "GOLESE (soppresso)" },
    { "code": "E081", "province": "PV", "name": "GOLFERENZO" },
    { "code": "M274", "province": "SS", "name": "GOLFO ARANCI" },
    { "code": "M274", "province": "OT", "name": "GOLFO ARANCI (soppresso)" },
    { "code": "E082", "province": "CR", "name": "GOMBITO" },
    { "code": "E083", "province": "UD", "name": "GONARS" },
    { "code": "E084", "province": "CA", "name": "GONI (soppresso)" },
    { "code": "E084", "province": "SU", "name": "GONI" },
    { "code": "E086", "province": "CA", "name": "GONNESA (soppresso)" },
    { "code": "E086", "province": "CI", "name": "GONNESA (soppresso)" },
    { "code": "E086", "province": "SU", "name": "GONNESA" },
    { "code": "E087", "province": "CA", "name": "GONNOSCODINA (soppresso)" },
    { "code": "E087", "province": "OR", "name": "GONNOSCODINA" },
    { "code": "E085", "province": "CA", "name": "GONNOSFANADIGA (soppresso)" },
    { "code": "E085", "province": "VS", "name": "GONNOSFANADIGA (soppresso)" },
    { "code": "E085", "province": "SU", "name": "GONNOSFANADIGA" },
    { "code": "ND", "province": "CA", "name": "GONNOSNO' (soppresso)" },
    { "code": "D585", "province": "CA", "name": "GONNOSNO' (soppresso)" },
    { "code": "D585", "province": "OR", "name": "GONNOSNO'" },
    { "code": "E088", "province": "CA", "name": "GONNOSTRAMATZA (soppresso)" },
    { "code": "E088", "province": "OR", "name": "GONNOSTRAMATZA" },
    { "code": "E089", "province": "MN", "name": "GONZAGA" },
    { "code": "E090", "province": "SO", "name": "GORDONA" },
    { "code": "E091", "province": "RM", "name": "GORGA" },
    { "code": "E092", "province": "TV", "name": "GORGO AL MONTICANO" },
    { "code": "E093", "province": "PZ", "name": "GORGOGLIONE (soppresso)" },
    { "code": "E093", "province": "MT", "name": "GORGOGLIONE" },
    { "code": "E094", "province": "MI", "name": "GORGONZOLA" },
    { "code": "E095", "province": "UD", "name": "GORIANO (soppresso)" },
    { "code": "E095", "province": "GO", "name": "GORIANO (soppresso)" },
    { "code": "E096", "province": "AQ", "name": "GORIANO SICOLI" },
    { "code": "E095", "province": "GO", "name": "GORIASCO (soppresso)" },
    { "code": "E095", "province": "UD", "name": "GORIASCO (soppresso)" },
    { "code": "E098", "province": "GO", "name": "GORIZIA" },
    { "code": "E098", "province": "UD", "name": "GORIZIA (soppresso)" },
    { "code": "E101", "province": "MI", "name": "GORLA MAGGIORE (soppresso)" },
    { "code": "E101", "province": "VA", "name": "GORLA MAGGIORE" },
    { "code": "E102", "province": "MI", "name": "GORLA MINORE (soppresso)" },
    { "code": "E102", "province": "VA", "name": "GORLA MINORE" },
    { "code": "E099", "province": "MI", "name": "GORLA PRIMO (soppresso)" },
    { "code": "E100", "province": "BG", "name": "GORLAGO" },
    { "code": "E099", "province": "MI", "name": "GORLAPRECOTTO (soppresso)" },
    { "code": "E103", "province": "BG", "name": "GORLE" },
    { "code": "E104", "province": "CO", "name": "GORNATE INFERIORE (soppresso)" },
    { "code": "E104", "province": "VA", "name": "GORNATE INFERIORE (soppresso)" },
    { "code": "E104", "province": "VA", "name": "GORNATE OLONA" },
    { "code": "E105", "province": "CO", "name": "GORNATE-SUPERIORE (soppresso)" },
    { "code": "E105", "province": "VA", "name": "GORNATE-SUPERIORE (soppresso)" },
    { "code": "E106", "province": "BG", "name": "GORNO" },
    { "code": "E107", "province": "FE", "name": "GORO" },
    { "code": "E109", "province": "PV", "name": "GORRETO (soppresso)" },
    { "code": "E109", "province": "GE", "name": "GORRETO" },
    { "code": "E110", "province": "CN", "name": "GORRINO (soppresso)" },
    { "code": "E111", "province": "CN", "name": "GORZEGNO" },
    { "code": "E112", "province": "BS", "name": "GORZONE (soppresso)" },
    { "code": "E113", "province": "BL", "name": "GOSALDO" },
    { "code": "E114", "province": "PC", "name": "GOSSOLENGO" },
    { "code": "E115", "province": "CN", "name": "GOTTASECCA" },
    { "code": "E116", "province": "BS", "name": "GOTTOLENGO" },
    { "code": "E117", "province": "CO", "name": "GOTTRO (soppresso)" },
    { "code": "E118", "province": "CN", "name": "GOVONE" },
    { "code": "E119", "province": "GO", "name": "GOZZA (soppresso)" },
    { "code": "E119", "province": "UD", "name": "GOZZA (soppresso)" },
    { "code": "E120", "province": "NO", "name": "GOZZANO" },
    { "code": "E121", "province": "GO", "name": "GRACOVA SERRAVALLE (soppresso)" },
    { "code": "E121", "province": "UD", "name": "GRACOVA SERRAVALLE (soppresso)" },
    { "code": "E122", "province": "PS", "name": "GRADARA (soppresso)" },
    { "code": "E122", "province": "PU", "name": "GRADARA" },
    { "code": "E124", "province": "GO", "name": "GRADISCA (soppresso)" },
    { "code": "E124", "province": "UD", "name": "GRADISCA (soppresso)" },
    { "code": "E124", "province": "UD", "name": "GRADISCA D'ISONZO (soppresso)" },
    { "code": "E124", "province": "GO", "name": "GRADISCA D'ISONZO" },
    { "code": "E125", "province": "GO", "name": "GRADO" },
    { "code": "E125", "province": "TS", "name": "GRADO (soppresso)" },
    { "code": "E126", "province": "RM", "name": "GRADOLI (soppresso)" },
    { "code": "E126", "province": "VT", "name": "GRADOLI" },
    { "code": "E127", "province": "MI", "name": "GRAFFIGNANA (soppresso)" },
    { "code": "E127", "province": "LO", "name": "GRAFFIGNANA" },
    { "code": "E128", "province": "RM", "name": "GRAFFIGNANO (soppresso)" },
    { "code": "E128", "province": "VT", "name": "GRAFFIGNANO" },
    { "code": "E130", "province": "NO", "name": "GRAGLIA (soppresso)" },
    { "code": "E130", "province": "VC", "name": "GRAGLIA (soppresso)" },
    { "code": "E130", "province": "BI", "name": "GRAGLIA" },
    { "code": "E129", "province": "NO", "name": "GRAGLIA PIANA (soppresso)" },
    { "code": "E131", "province": "NA", "name": "GRAGNANO" },
    { "code": "E132", "province": "PC", "name": "GRAGNANO TREBBIENSE" },
    { "code": "E133", "province": "CT", "name": "GRAMMICHELE" },
    { "code": "E134", "province": "AL", "name": "GRANA (soppresso)" },
    { "code": "E134", "province": "AT", "name": "GRANA" },
    { "code": "E135", "province": "BO", "name": "GRANAGLIONE (soppresso)" },
    { "code": "E136", "province": "BO", "name": "GRANAROLO DELL'EMILIA" },
    { "code": "E138", "province": "VI", "name": "GRANCONA (soppresso)" },
    { "code": "E139", "province": "CO", "name": "GRANDATE" },
    { "code": "E140", "province": "CO", "name": "GRANDOLA (soppresso)" },
    { "code": "E141", "province": "CO", "name": "GRANDOLA ED UNITI" },
    { "code": "E142", "province": "ME", "name": "GRANITI" },
    { "code": "E143", "province": "NO", "name": "GRANOZZO CON MONTICELLO" },
    { "code": "E144", "province": "CO", "name": "GRANTOLA (soppresso)" },
    { "code": "E144", "province": "VA", "name": "GRANTOLA" },
    { "code": "E145", "province": "PD", "name": "GRANTORTO" },
    { "code": "E146", "province": "PD", "name": "GRANZE" },
    { "code": "E147", "province": "PZ", "name": "GRASSANO (soppresso)" },
    { "code": "E147", "province": "MT", "name": "GRASSANO" },
    { "code": "E148", "province": "BG", "name": "GRASSOBBIO" },
    { "code": "E149", "province": "PA", "name": "GRATTERI" },
    { "code": "E150", "province": "TN", "name": "GRAUNO (soppresso)" },
    { "code": "E151", "province": "CO", "name": "GRAVEDONA (soppresso)" },
    { "code": "M315", "province": "CO", "name": "GRAVEDONA ED UNITI" },
    { "code": "E152", "province": "PV", "name": "GRAVELLONA LOMELLINA" },
    { "code": "E153", "province": "NO", "name": "GRAVELLONA TOCE (soppresso)" },
    { "code": "E153", "province": "VB", "name": "GRAVELLONA TOCE" },
    { "code": "E154", "province": "TO", "name": "GRAVERE" },
    { "code": "E156", "province": "CT", "name": "GRAVINA DI CATANIA" },
    { "code": "E155", "province": "BA", "name": "GRAVINA IN PUGLIA" },
    { "code": "E158", "province": "CE", "name": "GRAZZANISE" },
    { "code": "E158", "province": "NA", "name": "GRAZZANISE (soppresso)" },
    { "code": "E159", "province": "AT", "name": "GRAZZANO BADOGLIO" },
    { "code": "E159", "province": "AL", "name": "GRAZZANO MONFERRATO (soppresso)" },
    { "code": "E159", "province": "AT", "name": "GRAZZANO MONFERRATO (soppresso)" },
    { "code": "E160", "province": "PG", "name": "GRECCIO (soppresso)" },
    { "code": "E160", "province": "RM", "name": "GRECCIO (soppresso)" },
    { "code": "E160", "province": "RI", "name": "GRECCIO" },
    { "code": "E161", "province": "AV", "name": "GRECI" },
    { "code": "E162", "province": "MI", "name": "GRECO MILANESE (soppresso)" },
    { "code": "E163", "province": "NO", "name": "GREGGIO (soppresso)" },
    { "code": "E163", "province": "VC", "name": "GREGGIO" },
    { "code": "E164", "province": "AL", "name": "GREMIASCO" },
    { "code": "E165", "province": "TO", "name": "GRESSAN (soppresso)" },
    { "code": "E165", "province": "AO", "name": "GRESSAN" },
    { "code": "E166", "province": "AO", "name": "GRESSONEI (soppresso)" },
    { "code": "E166", "province": "AO", "name": "GRESSONEY (soppresso)" },
    { "code": "E167", "province": "TO", "name": "GRESSONEY LA TRINITE' (soppresso)" },
    { "code": "E167", "province": "AO", "name": "GRESSONEY LA TRINITE' (soppresso)" },
    { "code": "E168", "province": "TO", "name": "GRESSONEY SAINT JEAN (soppresso)" },
    { "code": "E168", "province": "AO", "name": "GRESSONEY SAINT JEAN (soppresso)" },
    { "code": "E167", "province": "AO", "name": "GRESSONEY-LA-TRINITE'" },
    { "code": "E168", "province": "AO", "name": "GRESSONEY-SAINT-JEAN" },
    { "code": "E169", "province": "FI", "name": "GREVE (soppresso)" },
    { "code": "E169", "province": "FI", "name": "GREVE IN CHIANTI" },
    { "code": "C417", "province": "BS", "name": "GREVO (soppresso)" },
    { "code": "E170", "province": "MI", "name": "GREZZAGO" },
    { "code": "E171", "province": "VR", "name": "GREZZANA" },
    { "code": "E172", "province": "CO", "name": "GRIANTE" },
    { "code": "E173", "province": "CE", "name": "GRICIGNANO DI AVERSA" },
    { "code": "E173", "province": "NA", "name": "GRICIGNANO DI AVERSA (soppresso)" },
    { "code": "E174", "province": "TN", "name": "GRIES (soppresso)" },
    { "code": "E174", "province": "TN", "name": "GRIES DI BOLZANO (soppresso)" },
    { "code": "E175", "province": "BG", "name": "GRIGNANO (soppresso)" },
    { "code": "E176", "province": "RO", "name": "GRIGNANO DI POLESINE (soppresso)" },
    { "code": "E177", "province": "NO", "name": "GRIGNASCO" },
    { "code": "E178", "province": "TN", "name": "GRIGNO" },
    { "code": "E179", "province": "UD", "name": "GRIMACCO" },
    { "code": "E180", "province": "CS", "name": "GRIMALDI" },
    { "code": "E181", "province": "TN", "name": "GRIMALDO (soppresso)" },
    { "code": "E181", "province": "BZ", "name": "GRIMALDO (soppresso)" },
    { "code": "E182", "province": "CN", "name": "GRINZANE (soppresso)" },
    { "code": "E182", "province": "CN", "name": "GRINZANE CAVOUR" },
    { "code": "E183", "province": "PL", "name": "GRISIGNANA (soppresso)" },
    { "code": "E184", "province": "VI", "name": "GRISIGNANO DI ZOCCO" },
    { "code": "D415", "province": "VE", "name": "GRISOLERA (soppresso)" },
    { "code": "E185", "province": "CS", "name": "GRISOLIA" },
    { "code": "E186", "province": "CS", "name": "GRISOLIA CIPOLLINA (soppresso)" },
    { "code": "E187", "province": "BO", "name": "GRIZZANA (soppresso)" },
    { "code": "E187", "province": "BO", "name": "GRIZZANA MORANDI" },
    { "code": "E188", "province": "AL", "name": "GROGNARDO" },
    { "code": "E189", "province": "BG", "name": "GROMO" },
    { "code": "E190", "province": "CO", "name": "GRONA (soppresso)" },
    { "code": "E191", "province": "AL", "name": "GRONDONA" },
    { "code": "E192", "province": "BG", "name": "GRONE" },
    { "code": "E193", "province": "CR", "name": "GRONTARDO" },
    { "code": "E195", "province": "PV", "name": "GROPELLO CAIROLI" },
    { "code": "E196", "province": "PC", "name": "GROPPARELLO" },
    { "code": "E198", "province": "AL", "name": "GROPPO (soppresso)" },
    { "code": "E199", "province": "TO", "name": "GROSCAVALLO" },
    { "code": "E200", "province": "SO", "name": "GROSIO" },
    { "code": "E201", "province": "SO", "name": "GROSOTTO" },
    { "code": "E202", "province": "GR", "name": "GROSSETO" },
    { "code": "E203", "province": "TO", "name": "GROSSO" },
    { "code": "E204", "province": "RM", "name": "GROTTAFERRATA" },
    { "code": "E205", "province": "LE", "name": "GROTTAGLIE (soppresso)" },
    { "code": "E205", "province": "TA", "name": "GROTTAGLIE" },
    { "code": "E206", "province": "AV", "name": "GROTTAMINARDA" },
    { "code": "E207", "province": "AP", "name": "GROTTAMMARE" },
    { "code": "E208", "province": "AP", "name": "GROTTAZZOLINA (soppresso)" },
    { "code": "E208", "province": "FM", "name": "GROTTAZZOLINA" },
    { "code": "E209", "province": "AG", "name": "GROTTE" },
    { "code": "E210", "province": "RM", "name": "GROTTE DI CASTRO (soppresso)" },
    { "code": "E210", "province": "VT", "name": "GROTTE DI CASTRO" },
    { "code": "E211", "province": "RM", "name": "GROTTE SANTO STEFANO (soppresso)" },
    { "code": "E211", "province": "VT", "name": "GROTTE SANTO STEFANO (soppresso)" },
    { "code": "E212", "province": "RC", "name": "GROTTERIA" },
    { "code": "E213", "province": "PZ", "name": "GROTTOLE (soppresso)" },
    { "code": "E213", "province": "MT", "name": "GROTTOLE" },
    { "code": "E214", "province": "AV", "name": "GROTTOLELLA" },
    { "code": "E215", "province": "VE", "name": "GRUARO" },
    { "code": "E216", "province": "TO", "name": "GRUGLIASCO" },
    { "code": "E217", "province": "CR", "name": "GRUMELLO CON FARVENGO CREMONESE (soppresso)" },
    { "code": "E217", "province": "CR", "name": "GRUMELLO CREMONESE ED UNITI" },
    { "code": "E218", "province": "BG", "name": "GRUMELLO DE' ZANCHI (soppresso)" },
    { "code": "E219", "province": "BG", "name": "GRUMELLO DEL MONTE" },
    { "code": "E220", "province": "BG", "name": "GRUMELLO DEL PIANO (soppresso)" },
    { "code": "E221", "province": "PZ", "name": "GRUMENTO NOVA" },
    { "code": "E222", "province": "TN", "name": "GRUMES (soppresso)" },
    { "code": "E225", "province": "TN", "name": "GRUMO (soppresso)" },
    { "code": "E223", "province": "BA", "name": "GRUMO APPULA" },
    { "code": "E224", "province": "NA", "name": "GRUMO NEVANO" },
    { "code": "E226", "province": "VI", "name": "GRUMOLO DELLE ABBADESSE" },
    { "code": "E227", "province": "LE", "name": "GUAGNANO" },
    { "code": "E227", "province": "BR", "name": "GUAGNANO (soppresso)" },
    { "code": "E228", "province": "MC", "name": "GUALDO" },
    { "code": "E229", "province": "PG", "name": "GUALDO CATTANEO" },
    { "code": "E230", "province": "PG", "name": "GUALDO TADINO" },
    { "code": "E232", "province": "RE", "name": "GUALTIERI" },
    { "code": "E233", "province": "ME", "name": "GUALTIERI SICAMINO'" },
    { "code": "E234", "province": "CA", "name": "GUAMAGGIORE (soppresso)" },
    { "code": "E234", "province": "SU", "name": "GUAMAGGIORE" },
    { "code": "E235", "province": "CO", "name": "GUANZATE" },
    { "code": "E236", "province": "RM", "name": "GUARCINO (soppresso)" },
    { "code": "E236", "province": "FR", "name": "GUARCINO" },
    { "code": "E240", "province": "RO", "name": "GUARDA VENETA" },
    { "code": "E237", "province": "NO", "name": "GUARDABOSONE (soppresso)" },
    { "code": "E237", "province": "VC", "name": "GUARDABOSONE" },
    { "code": "E238", "province": "MI", "name": "GUARDAMIGLIO (soppresso)" },
    { "code": "E238", "province": "LO", "name": "GUARDAMIGLIO" },
    { "code": "E239", "province": "CZ", "name": "GUARDAVALLE" },
    { "code": "E241", "province": "PG", "name": "GUARDEA (soppresso)" },
    { "code": "E241", "province": "TR", "name": "GUARDEA" },
    { "code": "E245", "province": "AV", "name": "GUARDIA LOMBARDI" },
    { "code": "E246", "province": "PZ", "name": "GUARDIA PERTICARA" },
    { "code": "E242", "province": "CS", "name": "GUARDIA PIEMONTESE" },
    { "code": "E247", "province": "CS", "name": "GUARDIA PIEMONTESE TERME (soppresso)" },
    { "code": "E249", "province": "BN", "name": "GUARDIA SANFRAMONDI" },
    { "code": "E243", "province": "CH", "name": "GUARDIAGRELE" },
    { "code": "E244", "province": "CB", "name": "GUARDIALFIERA" },
    { "code": "E248", "province": "CB", "name": "GUARDIAREGIA" },
    { "code": "E250", "province": "PI", "name": "GUARDISTALLO" },
    { "code": "E251", "province": "CN", "name": "GUARENE" },
    { "code": "E252", "province": "CA", "name": "GUASILA (soppresso)" },
    { "code": "E252", "province": "SU", "name": "GUASILA" },
    { "code": "E253", "province": "RE", "name": "GUASTALLA" },
    { "code": "E255", "province": "AL", "name": "GUAZZORA" },
    { "code": "E256", "province": "PG", "name": "GUBBIO" },
    { "code": "E258", "province": "MI", "name": "GUDO VISCONTI" },
    { "code": "E257", "province": "TN", "name": "GUDON (soppresso)" },
    { "code": "E257", "province": "BZ", "name": "GUDON (soppresso)" },
    { "code": "E259", "province": "CB", "name": "GUGLIONESI" },
    { "code": "E261", "province": "MN", "name": "GUIDIZZOLO" },
    { "code": "E262", "province": "ME", "name": "GUIDOMANDRI (soppresso)" },
    { "code": "E263", "province": "RM", "name": "GUIDONIA MONTECELIO" },
    { "code": "E264", "province": "MO", "name": "GUIGLIA" },
    { "code": "E266", "province": "CH", "name": "GUILMI" },
    { "code": "E268", "province": "CO", "name": "GURONE (soppresso)" },
    { "code": "E268", "province": "VA", "name": "GURONE (soppresso)" },
    { "code": "E269", "province": "NO", "name": "GURRO (soppresso)" },
    { "code": "E269", "province": "VB", "name": "GURRO" },
    { "code": "E270", "province": "CA", "name": "GUSPINI (soppresso)" },
    { "code": "E270", "province": "VS", "name": "GUSPINI (soppresso)" },
    { "code": "E270", "province": "SU", "name": "GUSPINI" },
    { "code": "E271", "province": "BS", "name": "GUSSAGO" },
    { "code": "E272", "province": "CR", "name": "GUSSOLA" },
    { "code": "B676", "province": "BS", "name": "HANO (soppresso)" },
    { "code": "E273", "province": "TO", "name": "HONE (soppresso)" },
    { "code": "E273", "province": "AO", "name": "HONE" },
    { "code": "C124", "province": "FU", "name": "IABLANIZZA (soppresso)" },
    { "code": "C124", "province": "PL", "name": "IABLANIZZA (soppresso)" },
    { "code": "E275", "province": "RC", "name": "IATRINOLI (soppresso)" },
    { "code": "E276", "province": "TN", "name": "IAVRE' (soppresso)" },
    { "code": "E277", "province": "GO", "name": "IDRESCA D'ISONZO (soppresso)" },
    { "code": "E277", "province": "UD", "name": "IDRESCA D'ISONZO (soppresso)" },
    { "code": "E278", "province": "GO", "name": "IDRIA (soppresso)" },
    { "code": "E278", "province": "UD", "name": "IDRIA (soppresso)" },
    { "code": "E279", "province": "GO", "name": "IDRIA DI SOTTO (soppresso)" },
    { "code": "E279", "province": "UD", "name": "IDRIA DI SOTTO (soppresso)" },
    { "code": "E280", "province": "BS", "name": "IDRO" },
    { "code": "E281", "province": "CA", "name": "IGLESIAS (soppresso)" },
    { "code": "E281", "province": "CI", "name": "IGLESIAS (soppresso)" },
    { "code": "E281", "province": "SU", "name": "IGLESIAS" },
    { "code": "E282", "province": "CN", "name": "IGLIANO" },
    { "code": "E283", "province": "CA", "name": "ILBONO (soppresso)" },
    { "code": "E283", "province": "NU", "name": "ILBONO" },
    { "code": "E283", "province": "OG", "name": "ILBONO (soppresso)" },
    { "code": "E284", "province": "VR", "name": "ILLASI" },
    { "code": "E285", "province": "SS", "name": "ILLORAI" },
    { "code": "E286", "province": "CO", "name": "IMBERIDO (soppresso)" },
    { "code": "E287", "province": "CO", "name": "IMBERSAGO (soppresso)" },
    { "code": "E287", "province": "LC", "name": "IMBERSAGO" },
    { "code": "E288", "province": "TN", "name": "IMER" },
    { "code": "E289", "province": "BO", "name": "IMOLA" },
    { "code": "E290", "province": "IM", "name": "IMPERIA" },
    { "code": "E291", "province": "FI", "name": "IMPRUNETA" },
    { "code": "E292", "province": "VA", "name": "INARZO" },
    { "code": "E293", "province": "CO", "name": "INCINO (soppresso)" },
    { "code": "E295", "province": "AL", "name": "INCISA BELBO (soppresso)" },
    { "code": "E296", "province": "FI", "name": "INCISA IN VAL D'ARNO (soppresso)" },
    { "code": "E295", "province": "AL", "name": "INCISA SCAPACCINO (soppresso)" },
    { "code": "E295", "province": "AT", "name": "INCISA SCAPACCINO" },
    { "code": "E297", "province": "BS", "name": "INCUDINE" },
    { "code": "E298", "province": "CO", "name": "INDOVERO (soppresso)" },
    { "code": "E299", "province": "CO", "name": "INDUNO OLONA (soppresso)" },
    { "code": "E299", "province": "VA", "name": "INDUNO OLONA" },
    { "code": "E301", "province": "TO", "name": "INGRIA" },
    { "code": "E301", "province": "AO", "name": "INGRIA (soppresso)" },
    { "code": "E302", "province": "CO", "name": "INTIMIANO (soppresso)" },
    { "code": "E303", "province": "NO", "name": "INTRA (soppresso)" },
    { "code": "E304", "province": "NO", "name": "INTRAGNA (soppresso)" },
    { "code": "E304", "province": "VB", "name": "INTRAGNA" },
    { "code": "E305", "province": "CO", "name": "INTROBIO (soppresso)" },
    { "code": "E305", "province": "LC", "name": "INTROBIO" },
    { "code": "E306", "province": "TO", "name": "INTROD (soppresso)" },
    { "code": "E306", "province": "AO", "name": "INTROD" },
    { "code": "E307", "province": "AQ", "name": "INTRODACQUA" },
    { "code": "E308", "province": "CO", "name": "INTROZZO (soppresso)" },
    { "code": "E308", "province": "LC", "name": "INTROZZO (soppresso)" },
    { "code": "E309", "province": "CO", "name": "INVERIGO" },
    { "code": "E310", "province": "PV", "name": "INVERNO (soppresso)" },
    { "code": "E310", "province": "PV", "name": "INVERNO E MONTELEONE" },
    { "code": "E311", "province": "TO", "name": "INVERSO PINASCA" },
    { "code": "E312", "province": "TO", "name": "INVERSO PORTE (soppresso)" },
    { "code": "E313", "province": "MI", "name": "INVERUNO" },
    { "code": "E314", "province": "NO", "name": "INVORIO" },
    { "code": "E315", "province": "NO", "name": "INVORIO INFERIORE (soppresso)" },
    { "code": "E316", "province": "NO", "name": "INVORIO SUPERIORE (soppresso)" },
    { "code": "E317", "province": "MI", "name": "INZAGO" },
    { "code": "E318", "province": "BS", "name": "INZINO (soppresso)" },
    { "code": "E319", "province": "UD", "name": "IOANNIS (soppresso)" },
    { "code": "E321", "province": "CZ", "name": "IONADI (soppresso)" },
    { "code": "E321", "province": "VV", "name": "IONADI" },
    { "code": "E018", "province": "CT", "name": "IONIA (soppresso)" },
    { "code": "E322", "province": "UD", "name": "IPPLIS (soppresso)" },
    { "code": "E323", "province": "SS", "name": "IRGOLI (soppresso)" },
    { "code": "E323", "province": "NU", "name": "IRGOLI" },
    { "code": "E324", "province": "NU", "name": "IRGOLI DI GALTELLI (soppresso)" },
    { "code": "E325", "province": "BS", "name": "IRMA" },
    { "code": "E326", "province": "PZ", "name": "IRSINA (soppresso)" },
    { "code": "E326", "province": "MT", "name": "IRSINA" },
    { "code": "E327", "province": "CN", "name": "ISASCA" },
    { "code": "E328", "province": "CZ", "name": "ISCA SULLO IONIO" },
    { "code": "E329", "province": "NA", "name": "ISCHIA" },
    { "code": "E331", "province": "TN", "name": "ISCHIA (soppresso)" },
    { "code": "E330", "province": "RM", "name": "ISCHIA DI CASTRO (soppresso)" },
    { "code": "E330", "province": "VT", "name": "ISCHIA DI CASTRO" },
    { "code": "E332", "province": "FG", "name": "ISCHITELLA" },
    { "code": "E333", "province": "BS", "name": "ISEO" },
    { "code": "E334", "province": "TN", "name": "ISERA" },
    { "code": "E335", "province": "CB", "name": "ISERNIA (soppresso)" },
    { "code": "E335", "province": "IS", "name": "ISERNIA" },
    { "code": "E336", "province": "CA", "name": "ISILI (soppresso)" },
    { "code": "E336", "province": "NU", "name": "ISILI (soppresso)" },
    { "code": "E336", "province": "SU", "name": "ISILI" },
    { "code": "E337", "province": "PA", "name": "ISNELLO" },
    { "code": "E344", "province": "MI", "name": "ISOLA BALBA (soppresso)" },
    { "code": "E347", "province": "CO", "name": "ISOLA COMACINA (soppresso)" },
    { "code": "E338", "province": "AL", "name": "ISOLA D'ASTI (soppresso)" },
    { "code": "E338", "province": "AT", "name": "ISOLA D'ASTI" },
    { "code": "E341", "province": "GE", "name": "ISOLA DEL CANTONE" },
    { "code": "E348", "province": "GR", "name": "ISOLA DEL GIGLIO" },
    { "code": "E343", "province": "TE", "name": "ISOLA DEL GRAN SASSO D'ITALIA" },
    { "code": "E340", "province": "CE", "name": "ISOLA DEL LIRI (soppresso)" },
    { "code": "E340", "province": "FR", "name": "ISOLA DEL LIRI" },
    { "code": "E351", "province": "PS", "name": "ISOLA DEL PIANO (soppresso)" },
    { "code": "E351", "province": "PU", "name": "ISOLA DEL PIANO" },
    { "code": "E349", "province": "VR", "name": "ISOLA DELLA SCALA" },
    { "code": "E350", "province": "PA", "name": "ISOLA DELLE FEMMINE" },
    { "code": "E339", "province": "CZ", "name": "ISOLA DI CAPO RIZZUTO (soppresso)" },
    { "code": "E339", "province": "KR", "name": "ISOLA DI CAPO RIZZUTO" },
    { "code": "E353", "province": "BG", "name": "ISOLA DI FONDRA" },
    { "code": "E354", "province": "VI", "name": "ISOLA DI MALO (soppresso)" },
    { "code": "E355", "province": "PL", "name": "ISOLA D'ISTRIA (soppresso)" },
    { "code": "E356", "province": "CR", "name": "ISOLA DOVARESE" },
    { "code": "E358", "province": "VR", "name": "ISOLA RIZZA" },
    { "code": "E359", "province": "NO", "name": "ISOLA SAN GIULIO (soppresso)" },
    { "code": "E360", "province": "AL", "name": "ISOLA SANT'ANTONIO" },
    { "code": "E354", "province": "VI", "name": "ISOLA VICENTINA" },
    { "code": "E345", "province": "TO", "name": "ISOLABELLA" },
    { "code": "E346", "province": "IM", "name": "ISOLABONA" },
    { "code": "E342", "province": "SO", "name": "ISOLATO (soppresso)" },
    { "code": "E363", "province": "FG", "name": "ISOLE TREMITI" },
    { "code": "E361", "province": "NO", "name": "ISOLELLA (soppresso)" },
    { "code": "E361", "province": "VC", "name": "ISOLELLA (soppresso)" },
    { "code": "E364", "province": "BS", "name": "ISORELLA" },
    { "code": "E365", "province": "SA", "name": "ISPANI" },
    { "code": "E366", "province": "RG", "name": "ISPICA" },
    { "code": "E367", "province": "CO", "name": "ISPRA (soppresso)" },
    { "code": "E367", "province": "VA", "name": "ISPRA" },
    { "code": "C737", "province": "TN", "name": "ISSENGO (soppresso)" },
    { "code": "C737", "province": "BZ", "name": "ISSENGO (soppresso)" },
    { "code": "E368", "province": "TO", "name": "ISSIGLIO" },
    { "code": "E368", "province": "AO", "name": "ISSIGLIO (soppresso)" },
    { "code": "E369", "province": "TO", "name": "ISSIME (soppresso)" },
    { "code": "E369", "province": "AO", "name": "ISSIME" },
    { "code": "E370", "province": "BG", "name": "ISSO" },
    { "code": "E371", "province": "TO", "name": "ISSOGNE (soppresso)" },
    { "code": "E371", "province": "AO", "name": "ISSOGNE" },
    { "code": "E372", "province": "CH", "name": "ISTONIO (soppresso)" },
    { "code": "E373", "province": "TV", "name": "ISTRANA" },
    { "code": "E374", "province": "ME", "name": "ITALA" },
    { "code": "E375", "province": "CE", "name": "ITRI (soppresso)" },
    { "code": "E375", "province": "RM", "name": "ITRI (soppresso)" },
    { "code": "E375", "province": "LT", "name": "ITRI" },
    { "code": "E376", "province": "SS", "name": "ITTIREDDU" },
    { "code": "E377", "province": "SS", "name": "ITTIRI" },
    { "code": "E378", "province": "TN", "name": "IVANO-FRACENA (soppresso)" },
    { "code": "E379", "province": "TO", "name": "IVREA" },
    { "code": "E379", "province": "AO", "name": "IVREA (soppresso)" },
    { "code": "E380", "province": "CR", "name": "IZANO" },
    { "code": "E274", "province": "CZ", "name": "JACURSO" },
    { "code": "E381", "province": "CB", "name": "JELSI" },
    { "code": "E382", "province": "RM", "name": "JENNE" },
    { "code": "E385", "province": "MI", "name": "JERAGO CON BESNATE ED ORAGO (soppresso)" },
    { "code": "E386", "province": "MI", "name": "JERAGO CON ORAGO (soppresso)" },
    { "code": "E386", "province": "VA", "name": "JERAGO CON ORAGO" },
    { "code": "E387", "province": "CA", "name": "JERZU (soppresso)" },
    { "code": "E387", "province": "NU", "name": "JERZU" },
    { "code": "E387", "province": "OG", "name": "JERZU (soppresso)" },
    { "code": "E388", "province": "AN", "name": "JESI" },
    { "code": "C388", "province": "VE", "name": "JESOLO" },
    { "code": "E319", "province": "UD", "name": "JOANNIZ (soppresso)" },
    { "code": "E320", "province": "FE", "name": "JOLANDA DI SAVOIA" },
    { "code": "E389", "province": "CZ", "name": "JOPPOLO (soppresso)" },
    { "code": "E389", "province": "VV", "name": "JOPPOLO" },
    { "code": "E390", "province": "AG", "name": "JOPPOLO GIANCAXIO" },
    { "code": "E391", "province": "TO", "name": "JOVENCAN (soppresso)" },
    { "code": "E391", "province": "AO", "name": "JOVENCAN" },
    { "code": "D844", "province": "ME", "name": "KAGGI (soppresso)" },
    { "code": "E394", "province": "TO", "name": "LA CASSA" },
    { "code": "E423", "province": "TO", "name": "LA LOGGIA" },
    { "code": "E425", "province": "SS", "name": "LA MADDALENA" },
    { "code": "E425", "province": "OT", "name": "LA MADDALENA (soppresso)" },
    { "code": "A308", "province": "AO", "name": "LA MADDALENA D'AOSTA (soppresso)" },
    { "code": "A308", "province": "TO", "name": "LA MAGDELEINE (soppresso)" },
    { "code": "A308", "province": "AO", "name": "LA MAGDELEINE" },
    { "code": "E430", "province": "CN", "name": "LA MORRA" },
    { "code": "E458", "province": "TO", "name": "LA SALLE (soppresso)" },
    { "code": "E458", "province": "AO", "name": "LA SALLE" },
    { "code": "E463", "province": "SP", "name": "LA SPEZIA" },
    { "code": "E470", "province": "TO", "name": "LA THUILE (soppresso)" },
    { "code": "E470", "province": "AO", "name": "LA THUILE" },
    { "code": "E490", "province": "BL", "name": "LA VALLE (soppresso)" },
    { "code": "E491", "province": "TN", "name": "LA VALLE (soppresso)" },
    { "code": "E491", "province": "BZ", "name": "LA VALLE" },
    { "code": "E490", "province": "BL", "name": "LA VALLE AGORDINA" },
    { "code": "M348", "province": "LC", "name": "LA VALLETTA BRIANZA" },
    { "code": "E392", "province": "RM", "name": "LABICO" },
    { "code": "E393", "province": "PG", "name": "LABRO (soppresso)" },
    { "code": "E393", "province": "RM", "name": "LABRO (soppresso)" },
    { "code": "E393", "province": "RI", "name": "LABRO" },
    { "code": "E395", "province": "MI", "name": "LACCHIARELLA" },
    { "code": "E396", "province": "NA", "name": "LACCO AMENO" },
    { "code": "E397", "province": "AV", "name": "LACEDONIA" },
    { "code": "E398", "province": "TN", "name": "LACES (soppresso)" },
    { "code": "E398", "province": "BZ", "name": "LACES" },
    { "code": "E399", "province": "TN", "name": "LACIGNO (soppresso)" },
    { "code": "E399", "province": "TN", "name": "LACINIGO (soppresso)" },
    { "code": "E399", "province": "BZ", "name": "LACINIGO (soppresso)" },
    { "code": "E400", "province": "CA", "name": "LACONI (soppresso)" },
    { "code": "E400", "province": "NU", "name": "LACONI (soppresso)" },
    { "code": "E400", "province": "OR", "name": "LACONI" },
    { "code": "D079", "province": "TN", "name": "LADINIA (soppresso)" },
    { "code": "D079", "province": "BZ", "name": "LADINIA (soppresso)" },
    { "code": "M212", "province": "RM", "name": "LADISPOLI" },
    { "code": "E401", "province": "SS", "name": "LAERRU" },
    { "code": "E402", "province": "RC", "name": "LAGANADI" },
    { "code": "E403", "province": "VI", "name": "LAGHI" },
    { "code": "E404", "province": "UD", "name": "LAGLESIE SAN LEOPOLDO (soppresso)" },
    { "code": "E405", "province": "CO", "name": "LAGLIO" },
    { "code": "E405", "province": "CO", "name": "LAGLIO-BRIENNO (soppresso)" },
    { "code": "E406", "province": "CN", "name": "LAGNASCO" },
    { "code": "E407", "province": "CS", "name": "LAGO" },
    { "code": "E408", "province": "TV", "name": "LAGO (soppresso)" },
    { "code": "E409", "province": "PZ", "name": "LAGONEGRO" },
    { "code": "E410", "province": "FE", "name": "LAGOSANTO" },
    { "code": "E411", "province": "ZA", "name": "LAGOSTA (soppresso)" },
    { "code": "E412", "province": "TN", "name": "LAGUNDO (soppresso)" },
    { "code": "E412", "province": "BZ", "name": "LAGUNDO" },
    { "code": "E414", "province": "GE", "name": "LAIGUEGLIA (soppresso)" },
    { "code": "E414", "province": "SV", "name": "LAIGUEGLIA" },
    { "code": "E415", "province": "MI", "name": "LAINATE" },
    { "code": "E416", "province": "CO", "name": "LAINO" },
    { "code": "E417", "province": "CS", "name": "LAINO BORGO" },
    { "code": "E418", "province": "CS", "name": "LAINO BRUZIO (soppresso)" },
    { "code": "E419", "province": "CS", "name": "LAINO CASTELLO" },
    { "code": "E420", "province": "TN", "name": "LAION (soppresso)" },
    { "code": "E420", "province": "BZ", "name": "LAION" },
    { "code": "E421", "province": "TN", "name": "LAIVES (soppresso)" },
    { "code": "E421", "province": "BZ", "name": "LAIVES" },
    { "code": "E413", "province": "PI", "name": "LAJATICO" },
    { "code": "E422", "province": "BG", "name": "LALLIO" },
    { "code": "E424", "province": "CH", "name": "LAMA DEI PELIGNI" },
    { "code": "E426", "province": "MO", "name": "LAMA MOCOGNO" },
    { "code": "E427", "province": "MI", "name": "LAMBRATE (soppresso)" },
    { "code": "E428", "province": "CO", "name": "LAMBRUGO" },
    { "code": "M208", "province": "CZ", "name": "LAMEZIA TERME" },
    { "code": "E429", "province": "BL", "name": "LAMON" },
    { "code": "E431", "province": "AG", "name": "LAMPEDUSA E LINOSA" },
    { "code": "E432", "province": "FI", "name": "LAMPORECCHIO (soppresso)" },
    { "code": "E432", "province": "PT", "name": "LAMPORECCHIO" },
    { "code": "E433", "province": "NO", "name": "LAMPORO (soppresso)" },
    { "code": "E433", "province": "VC", "name": "LAMPORO" },
    { "code": "E434", "province": "TN", "name": "LANA (soppresso)" },
    { "code": "E434", "province": "BZ", "name": "LANA" },
    { "code": "E435", "province": "CH", "name": "LANCIANO" },
    { "code": "E436", "province": "NO", "name": "LANDIONA" },
    { "code": "E437", "province": "PV", "name": "LANDRIANO" },
    { "code": "E438", "province": "PR", "name": "LANGHIRANO" },
    { "code": "E439", "province": "PV", "name": "LANGOSCO" },
    { "code": "E440", "province": "PL", "name": "LANISCHIE (soppresso)" },
    { "code": "E441", "province": "CA", "name": "LANUSEI (soppresso)" },
    { "code": "E441", "province": "NU", "name": "LANUSEI" },
    { "code": "E441", "province": "OG", "name": "LANUSEI (soppresso)" },
    { "code": "C767", "province": "RM", "name": "LANUVIO" },
    { "code": "E442", "province": "ME", "name": "LANZA (soppresso)" },
    { "code": "E443", "province": "SO", "name": "LANZADA" },
    { "code": "E444", "province": "CO", "name": "LANZO D'INTELVI (soppresso)" },
    { "code": "E445", "province": "TO", "name": "LANZO TORINESE" },
    { "code": "E446", "province": "CO", "name": "LAORCA (soppresso)" },
    { "code": "E447", "province": "AP", "name": "LAPEDONA (soppresso)" },
    { "code": "E447", "province": "FM", "name": "LAPEDONA" },
    { "code": "E448", "province": "AV", "name": "LAPIO" },
    { "code": "E449", "province": "TN", "name": "LAPPAGO (soppresso)" },
    { "code": "E449", "province": "BZ", "name": "LAPPAGO (soppresso)" },
    { "code": "E450", "province": "CS", "name": "LAPPANO" },
    { "code": "A345", "province": "AQ", "name": "L'AQUILA" },
    { "code": "E451", "province": "FI", "name": "LARCIANO (soppresso)" },
    { "code": "E451", "province": "PT", "name": "LARCIANO" },
    { "code": "E452", "province": "TN", "name": "LARDARO (soppresso)" },
    { "code": "E454", "province": "PV", "name": "LARDIRAGO" },
    { "code": "E455", "province": "PI", "name": "LARI (soppresso)" },
    { "code": "M207", "province": "RM", "name": "LARIANO" },
    { "code": "E456", "province": "CB", "name": "LARINO" },
    { "code": "E464", "province": "CA", "name": "LAS PLASSAS (soppresso)" },
    { "code": "E464", "province": "VS", "name": "LAS PLASSAS (soppresso)" },
    { "code": "E464", "province": "SU", "name": "LAS PLASSAS" },
    { "code": "E457", "province": "TN", "name": "LASA (soppresso)" },
    { "code": "E457", "province": "BZ", "name": "LASA" },
    { "code": "E459", "province": "PA", "name": "LASCARI" },
    { "code": "E460", "province": "TS", "name": "LASE (soppresso)" },
    { "code": "E461", "province": "TN", "name": "LASINO (soppresso)" },
    { "code": "E462", "province": "CO", "name": "LASNIGO" },
    { "code": "E465", "province": "VI", "name": "LASTEBASSE" },
    { "code": "E466", "province": "FI", "name": "LASTRA A SIGNA" },
    { "code": "E467", "province": "RM", "name": "LATERA (soppresso)" },
    { "code": "E467", "province": "VT", "name": "LATERA" },
    { "code": "E468", "province": "AR", "name": "LATERINA (soppresso)" },
    { "code": "M392", "province": "AR", "name": "LATERINA PERGINE VALDARNO" },
    { "code": "E469", "province": "LE", "name": "LATERZA (soppresso)" },
    { "code": "E469", "province": "TA", "name": "LATERZA" },
    { "code": "E471", "province": "LE", "name": "LATIANO (soppresso)" },
    { "code": "E471", "province": "BR", "name": "LATIANO" },
    { "code": "E472", "province": "LT", "name": "LATINA" },
    { "code": "E473", "province": "UD", "name": "LATISANA" },
    { "code": "E474", "province": "PZ", "name": "LATRONICO" },
    { "code": "E475", "province": "CS", "name": "LATTARICO" },
    { "code": "E476", "province": "UD", "name": "LAUCO" },
    { "code": "E477", "province": "TN", "name": "LAUDES (soppresso)" },
    { "code": "E477", "province": "BZ", "name": "LAUDES (soppresso)" },
    { "code": "E478", "province": "FU", "name": "LAURANA (soppresso)" },
    { "code": "E478", "province": "PL", "name": "LAURANA (soppresso)" },
    { "code": "E480", "province": "SA", "name": "LAUREANA CILENTO" },
    { "code": "E479", "province": "RC", "name": "LAUREANA DI BORELLO (soppresso)" },
    { "code": "E479", "province": "RC", "name": "LAUREANA DI BORRELLO" },
    { "code": "E481", "province": "TN", "name": "LAUREGNO (soppresso)" },
    { "code": "E481", "province": "BZ", "name": "LAUREGNO" },
    { "code": "E482", "province": "PZ", "name": "LAURENZANA" },
    { "code": "E483", "province": "PZ", "name": "LAURIA" },
    { "code": "E484", "province": "TO", "name": "LAURIANO" },
    { "code": "E485", "province": "SA", "name": "LAURINO" },
    { "code": "E486", "province": "SA", "name": "LAURITO" },
    { "code": "E487", "province": "AV", "name": "LAURO" },
    { "code": "E488", "province": "GE", "name": "LAVAGNA" },
    { "code": "E489", "province": "VR", "name": "LAVAGNO" },
    { "code": "E492", "province": "TN", "name": "LAVARONE" },
    { "code": "E493", "province": "PZ", "name": "LAVELLO" },
    { "code": "E494", "province": "CO", "name": "LAVENA (soppresso)" },
    { "code": "E494", "province": "VA", "name": "LAVENA (soppresso)" },
    { "code": "E494", "province": "VA", "name": "LAVENA PONTE TRESA" },
    { "code": "E495", "province": "CO", "name": "LAVENO (soppresso)" },
    { "code": "E495", "province": "VA", "name": "LAVENO (soppresso)" },
    { "code": "E496", "province": "VA", "name": "LAVENO-MOMBELLO" },
    { "code": "E497", "province": "BS", "name": "LAVENONE" },
    { "code": "E498", "province": "SA", "name": "LAVIANO" },
    { "code": "E499", "province": "IM", "name": "LAVINA (soppresso)" },
    { "code": "E500", "province": "TN", "name": "LAVIS" },
    { "code": "E501", "province": "TN", "name": "LAZFONS (soppresso)" },
    { "code": "E501", "province": "BZ", "name": "LAZFONS (soppresso)" },
    { "code": "E502", "province": "VR", "name": "LAZISE" },
    { "code": "E503", "province": "AL", "name": "LAZZARONE (soppresso)" },
    { "code": "E504", "province": "MI", "name": "LAZZATE (soppresso)" },
    { "code": "E504", "province": "MB", "name": "LAZZATE" },
    { "code": "E320", "province": "FE", "name": "LE VENEZIE (soppresso)" },
    { "code": "E506", "province": "LE", "name": "LECCE" },
    { "code": "E505", "province": "AQ", "name": "LECCE NEI MARSI" },
    { "code": "E507", "province": "CO", "name": "LECCO (soppresso)" },
    { "code": "E507", "province": "LC", "name": "LECCO" },
    { "code": "E508", "province": "GO", "name": "LEDINE (soppresso)" },
    { "code": "E508", "province": "UD", "name": "LEDINE (soppresso)" },
    { "code": "M313", "province": "TN", "name": "LEDRO" },
    { "code": "E509", "province": "BG", "name": "LEFFE" },
    { "code": "E510", "province": "CO", "name": "LEGGIUNO (soppresso)" },
    { "code": "E510", "province": "VA", "name": "LEGGIUNO" },
    { "code": "E511", "province": "VA", "name": "LEGGIUNO-SANGIANO (soppresso)" },
    { "code": "E512", "province": "VR", "name": "LEGNAGO" },
    { "code": "E514", "province": "MI", "name": "LEGNANO" },
    { "code": "E515", "province": "PD", "name": "LEGNARO" },
    { "code": "E516", "province": "TN", "name": "LEGOS (soppresso)" },
    { "code": "E517", "province": "SS", "name": "LEI (soppresso)" },
    { "code": "E517", "province": "NU", "name": "LEI" },
    { "code": "E518", "province": "TO", "name": "LEINI" },
    { "code": "E519", "province": "GE", "name": "LEIVI" },
    { "code": "E520", "province": "TO", "name": "LEMIE" },
    { "code": "E521", "province": "CO", "name": "LEMNA (soppresso)" },
    { "code": "E522", "province": "RO", "name": "LENDINARA" },
    { "code": "E523", "province": "ME", "name": "LENI" },
    { "code": "E524", "province": "BG", "name": "LENNA" },
    { "code": "E525", "province": "CO", "name": "LENNO (soppresso)" },
    { "code": "E526", "province": "BS", "name": "LENO" },
    { "code": "E527", "province": "CE", "name": "LENOLA (soppresso)" },
    { "code": "E527", "province": "RM", "name": "LENOLA (soppresso)" },
    { "code": "E527", "province": "LT", "name": "LENOLA" },
    { "code": "E528", "province": "NO", "name": "LENTA (soppresso)" },
    { "code": "E528", "province": "VC", "name": "LENTA" },
    { "code": "E530", "province": "MI", "name": "LENTATE SUL SEVESO (soppresso)" },
    { "code": "E530", "province": "MB", "name": "LENTATE SUL SEVESO" },
    { "code": "E531", "province": "CH", "name": "LENTELLA" },
    { "code": "C562", "province": "BL", "name": "LENTIAI (soppresso)" },
    { "code": "E532", "province": "SR", "name": "LENTINI" },
    { "code": "E533", "province": "TN", "name": "LENZIMA (soppresso)" },
    { "code": "E534", "province": "TN", "name": "LENZUMO (soppresso)" },
    { "code": "E535", "province": "AQ", "name": "LEONESSA (soppresso)" },
    { "code": "E535", "province": "RI", "name": "LEONESSA" },
    { "code": "E536", "province": "CT", "name": "LEONFORTE (soppresso)" },
    { "code": "E536", "province": "EN", "name": "LEONFORTE" },
    { "code": "E537", "province": "LE", "name": "LEPORANO (soppresso)" },
    { "code": "E537", "province": "TA", "name": "LEPORANO" },
    { "code": "B649", "province": "RM", "name": "LEPRIGNANO (soppresso)" },
    { "code": "E538", "province": "LE", "name": "LEQUILE" },
    { "code": "E540", "province": "CN", "name": "LEQUIO BERRIA" },
    { "code": "E539", "province": "CN", "name": "LEQUIO TANARO" },
    { "code": "E541", "province": "PA", "name": "LERCARA FRIDDI" },
    { "code": "E542", "province": "GE", "name": "LERICI (soppresso)" },
    { "code": "E542", "province": "SP", "name": "LERICI" },
    { "code": "E543", "province": "AL", "name": "LERMA" },
    { "code": "E544", "province": "NO", "name": "LESA" },
    { "code": "E545", "province": "NO", "name": "LESA BELGIRATE (soppresso)" },
    { "code": "E546", "province": "CN", "name": "LESEGNO" },
    { "code": "E547", "province": "PR", "name": "LESIGNANO DE' BAGNI" },
    { "code": "E549", "province": "FG", "name": "LESINA" },
    { "code": "E550", "province": "MI", "name": "LESMO (soppresso)" },
    { "code": "E550", "province": "MB", "name": "LESMO" },
    { "code": "E551", "province": "TO", "name": "LESSOLO" },
    { "code": "E551", "province": "AO", "name": "LESSOLO (soppresso)" },
    { "code": "E552", "province": "NO", "name": "LESSONA (soppresso)" },
    { "code": "E552", "province": "VC", "name": "LESSONA (soppresso)" },
    { "code": "E552", "province": "BI", "name": "LESSONA (soppresso)" },
    { "code": "M371", "province": "BI", "name": "LESSONA" },
    { "code": "E553", "province": "UD", "name": "LESTIZZA" },
    { "code": "E554", "province": "CE", "name": "LETINO" },
    { "code": "E554", "province": "CB", "name": "LETINO (soppresso)" },
    { "code": "E555", "province": "ME", "name": "LETOJANNI" },
    { "code": "E556", "province": "ME", "name": "LETOJANNI GALLODORO (soppresso)" },
    { "code": "E557", "province": "NA", "name": "LETTERE" },
    { "code": "E558", "province": "CH", "name": "LETTOMANOPPELLO (soppresso)" },
    { "code": "E558", "province": "PE", "name": "LETTOMANOPPELLO" },
    { "code": "E559", "province": "CH", "name": "LETTOPALENA" },
    { "code": "E560", "province": "GE", "name": "LEVANTO (soppresso)" },
    { "code": "E560", "province": "SP", "name": "LEVANTO" },
    { "code": "E562", "province": "BG", "name": "LEVATE" },
    { "code": "E563", "province": "LE", "name": "LEVERANO" },
    { "code": "E564", "province": "CN", "name": "LEVICE" },
    { "code": "E565", "province": "TN", "name": "LEVICO (soppresso)" },
    { "code": "E565", "province": "TN", "name": "LEVICO TERME" },
    { "code": "E566", "province": "TO", "name": "LEVONE" },
    { "code": "E567", "province": "BS", "name": "LEVRANGE (soppresso)" },
    { "code": "E518", "province": "TO", "name": "LEYNI (soppresso)" },
    { "code": "E568", "province": "CO", "name": "LEZZA (soppresso)" },
    { "code": "E569", "province": "CO", "name": "LEZZENO" },
    { "code": "E570", "province": "CE", "name": "LIBERI" },
    { "code": "E570", "province": "NA", "name": "LIBERI (soppresso)" },
    { "code": "E571", "province": "ME", "name": "LIBRIZZI" },
    { "code": "E572", "province": "GO", "name": "LIBUSSINA (soppresso)" },
    { "code": "E572", "province": "UD", "name": "LIBUSSINA (soppresso)" },
    { "code": "E573", "province": "AG", "name": "LICATA" },
    { "code": "E574", "province": "MS", "name": "LICCIANA (soppresso)" },
    { "code": "E574", "province": "MS", "name": "LICCIANA NARDI" },
    { "code": "E576", "province": "RM", "name": "LICENZA" },
    { "code": "E577", "province": "NA", "name": "LICIGNANO DI NAPOLI (soppresso)" },
    { "code": "E578", "province": "CT", "name": "LICODIA EUBEA" },
    { "code": "E580", "province": "SA", "name": "LICUSATI (soppresso)" },
    { "code": "E581", "province": "CO", "name": "LIERNA (soppresso)" },
    { "code": "E581", "province": "LC", "name": "LIERNA" },
    { "code": "E582", "province": "CO", "name": "LIETO COLLE (soppresso)" },
    { "code": "E583", "province": "NO", "name": "LIGNANA (soppresso)" },
    { "code": "E583", "province": "VC", "name": "LIGNANA" },
    { "code": "E584", "province": "UD", "name": "LIGNANO SABBIADORO" },
    { "code": "E585", "province": "RE", "name": "LIGONCHIO (soppresso)" },
    { "code": "E586", "province": "UD", "name": "LIGOSULLO (soppresso)" },
    { "code": "E587", "province": "AO", "name": "LILLIANA (soppresso)" },
    { "code": "E587", "province": "TO", "name": "LILLIANES (soppresso)" },
    { "code": "E587", "province": "AO", "name": "LILLIANES" },
    { "code": "E588", "province": "BL", "name": "LIMANA" },
    { "code": "E589", "province": "BN", "name": "LIMATOLA" },
    { "code": "E590", "province": "CZ", "name": "LIMBADI (soppresso)" },
    { "code": "E590", "province": "VV", "name": "LIMBADI" },
    { "code": "E591", "province": "MI", "name": "LIMBIATE (soppresso)" },
    { "code": "E591", "province": "MB", "name": "LIMBIATE" },
    { "code": "E592", "province": "PD", "name": "LIMENA" },
    { "code": "E593", "province": "CO", "name": "LIMIDO (soppresso)" },
    { "code": "E593", "province": "CO", "name": "LIMIDO COMASCO" },
    { "code": "E594", "province": "ME", "name": "LIMINA" },
    { "code": "E597", "province": "CN", "name": "LIMONE PIEMONTE" },
    { "code": "E596", "province": "BS", "name": "LIMONE SAN GIOVANNI (soppresso)" },
    { "code": "E596", "province": "BS", "name": "LIMONE SUL GARDA" },
    { "code": "E598", "province": "CO", "name": "LIMONTA (soppresso)" },
    { "code": "E599", "province": "CB", "name": "LIMOSANO" },
    { "code": "E600", "province": "PV", "name": "LINAROLO" },
    { "code": "E601", "province": "MI", "name": "LINATE AL LAMBRO (soppresso)" },
    { "code": "E602", "province": "CT", "name": "LINGUAGLOSSA" },
    { "code": "E603", "province": "IM", "name": "LINGUEGLIETTA (soppresso)" },
    { "code": "E604", "province": "CO", "name": "LINZANICO (soppresso)" },
    { "code": "E605", "province": "AV", "name": "LIONI" },
    { "code": "E606", "province": "ME", "name": "LIPARI" },
    { "code": "E607", "province": "CO", "name": "LIPOMO" },
    { "code": "E608", "province": "PV", "name": "LIRIO" },
    { "code": "E609", "province": "CO", "name": "LISANZA (soppresso)" },
    { "code": "E609", "province": "VA", "name": "LISANZA (soppresso)" },
    { "code": "E610", "province": "MI", "name": "LISCATE" },
    { "code": "E611", "province": "CH", "name": "LISCIA" },
    { "code": "E613", "province": "PG", "name": "LISCIANO NICCONE" },
    { "code": "E614", "province": "TN", "name": "LISIGNAGO (soppresso)" },
    { "code": "E615", "province": "CN", "name": "LISIO" },
    { "code": "E616", "province": "CO", "name": "LISSAGO (soppresso)" },
    { "code": "E616", "province": "VA", "name": "LISSAGO (soppresso)" },
    { "code": "E617", "province": "MI", "name": "LISSONE (soppresso)" },
    { "code": "E617", "province": "MB", "name": "LISSONE" },
    { "code": "E472", "province": "RM", "name": "LITTORIA (soppresso)" },
    { "code": "E472", "province": "LT", "name": "LITTORIA (soppresso)" },
    { "code": "E618", "province": "CL", "name": "LITTORIA NISSENA (soppresso)" },
    { "code": "E619", "province": "BS", "name": "LIVEMMO (soppresso)" },
    { "code": "E620", "province": "CE", "name": "LIVERI (soppresso)" },
    { "code": "E620", "province": "NA", "name": "LIVERI" },
    { "code": "E621", "province": "SO", "name": "LIVIGNO" },
    { "code": "E622", "province": "BL", "name": "LIVINALLONGO (soppresso)" },
    { "code": "E622", "province": "BL", "name": "LIVINALLONGO DEL COL DI LANA" },
    { "code": "E623", "province": "CO", "name": "LIVO" },
    { "code": "E624", "province": "TN", "name": "LIVO" },
    { "code": "E625", "province": "LI", "name": "LIVORNO" },
    { "code": "E626", "province": "NO", "name": "LIVORNO FERRARIS (soppresso)" },
    { "code": "E626", "province": "VC", "name": "LIVORNO FERRARIS" },
    { "code": "E626", "province": "NO", "name": "LIVORNO PIEMONTE (soppresso)" },
    { "code": "E627", "province": "MI", "name": "LIVRAGA (soppresso)" },
    { "code": "E627", "province": "LO", "name": "LIVRAGA" },
    { "code": "E628", "province": "TN", "name": "LIZZANA (soppresso)" },
    { "code": "E629", "province": "LE", "name": "LIZZANELLO" },
    { "code": "E630", "province": "LE", "name": "LIZZANO (soppresso)" },
    { "code": "E630", "province": "TA", "name": "LIZZANO" },
    { "code": "A771", "province": "BO", "name": "LIZZANO IN BELVEDERE" },
    { "code": "E631", "province": "BG", "name": "LIZZOLA (soppresso)" },
    { "code": "E632", "province": "GE", "name": "LOANO (soppresso)" },
    { "code": "E632", "province": "SV", "name": "LOANO" },
    { "code": "E633", "province": "AL", "name": "LOAZZOLO (soppresso)" },
    { "code": "E633", "province": "AT", "name": "LOAZZOLO" },
    { "code": "E634", "province": "ME", "name": "LOCADI (soppresso)" },
    { "code": "E635", "province": "TO", "name": "LOCANA" },
    { "code": "E635", "province": "AO", "name": "LOCANA (soppresso)" },
    { "code": "E636", "province": "NO", "name": "LOCARNO (soppresso)" },
    { "code": "E636", "province": "VC", "name": "LOCARNO (soppresso)" },
    { "code": "E637", "province": "BG", "name": "LOCATE BERGAMASCO (soppresso)" },
    { "code": "E639", "province": "MI", "name": "LOCATE DI TRIULZI" },
    { "code": "E638", "province": "CO", "name": "LOCATE VARESINO" },
    { "code": "E640", "province": "BG", "name": "LOCATELLO" },
    { "code": "E641", "province": "GO", "name": "LOCAVIZZA DI AIDUSSINA (soppresso)" },
    { "code": "E641", "province": "UD", "name": "LOCAVIZZA DI AIDUSSINA (soppresso)" },
    { "code": "E642", "province": "GO", "name": "LOCAVIZZA DI CANALE (soppresso)" },
    { "code": "E642", "province": "UD", "name": "LOCAVIZZA DI CANALE (soppresso)" },
    { "code": "E643", "province": "TN", "name": "LOCCA (soppresso)" },
    { "code": "E644", "province": "CA", "name": "LOCERI (soppresso)" },
    { "code": "E644", "province": "NU", "name": "LOCERI" },
    { "code": "E644", "province": "OG", "name": "LOCERI (soppresso)" },
    { "code": "E645", "province": "BA", "name": "LOCOROTONDO" },
    { "code": "D976", "province": "RC", "name": "LOCRI" },
    { "code": "E646", "province": "SS", "name": "LOCULI (soppresso)" },
    { "code": "E646", "province": "NU", "name": "LOCULI" },
    { "code": "E647", "province": "SS", "name": "LODE' (soppresso)" },
    { "code": "E647", "province": "NU", "name": "LODE'" },
    { "code": "E648", "province": "MI", "name": "LODI (soppresso)" },
    { "code": "E648", "province": "LO", "name": "LODI" },
    { "code": "E651", "province": "MI", "name": "LODI VECCHIO (soppresso)" },
    { "code": "E651", "province": "LO", "name": "LODI VECCHIO" },
    { "code": "E649", "province": "SS", "name": "LODINE (soppresso)" },
    { "code": "E649", "province": "NU", "name": "LODINE" },
    { "code": "E652", "province": "BS", "name": "LODRINO" },
    { "code": "E653", "province": "TN", "name": "LODRONE (soppresso)" },
    { "code": "B164", "province": "GO", "name": "LOGA DI PLEZZO (soppresso)" },
    { "code": "B164", "province": "UD", "name": "LOGA DI PLEZZO (soppresso)" },
    { "code": "E654", "province": "BS", "name": "LOGRATO" },
    { "code": "E655", "province": "BO", "name": "LOIANO" },
    { "code": "M275", "province": "SS", "name": "LOIRI PORTO SAN PAOLO" },
    { "code": "M275", "province": "OT", "name": "LOIRI PORTO SAN PAOLO (soppresso)" },
    { "code": "E656", "province": "CO", "name": "LOMAGNA (soppresso)" },
    { "code": "E656", "province": "LC", "name": "LOMAGNA" },
    { "code": "E657", "province": "CO", "name": "LOMANIGA (soppresso)" },
    { "code": "E658", "province": "TN", "name": "LOMASO (soppresso)" },
    { "code": "E659", "province": "CO", "name": "LOMAZZO" },
    { "code": "E660", "province": "TO", "name": "LOMBARDORE" },
    { "code": "E661", "province": "TO", "name": "LOMBRIASCO" },
    { "code": "E662", "province": "PV", "name": "LOMELLO" },
    { "code": "A918", "province": "CO", "name": "LOMNAGO (soppresso)" },
    { "code": "A918", "province": "VA", "name": "LOMNAGO (soppresso)" },
    { "code": "E663", "province": "TN", "name": "LON (soppresso)" },
    { "code": "E664", "province": "TN", "name": "LONA-LASES" },
    { "code": "E665", "province": "CO", "name": "LONATE CEPPINO (soppresso)" },
    { "code": "E665", "province": "VA", "name": "LONATE CEPPINO" },
    { "code": "E666", "province": "MI", "name": "LONATE POZZOLO (soppresso)" },
    { "code": "E666", "province": "VA", "name": "LONATE POZZOLO" },
    { "code": "E667", "province": "BS", "name": "LONATO (soppresso)" },
    { "code": "M312", "province": "BS", "name": "LONATO DEL GARDA" },
    { "code": "E668", "province": "FI", "name": "LONDA" },
    { "code": "E669", "province": "CB", "name": "LONGANO (soppresso)" },
    { "code": "E669", "province": "IS", "name": "LONGANO" },
    { "code": "E671", "province": "VI", "name": "LONGARE" },
    { "code": "E672", "province": "BL", "name": "LONGARONE (soppresso)" },
    { "code": "M342", "province": "BL", "name": "LONGARONE" },
    { "code": "E673", "province": "BS", "name": "LONGHENA" },
    { "code": "E674", "province": "ME", "name": "LONGI" },
    { "code": "E675", "province": "FO", "name": "LONGIANO (soppresso)" },
    { "code": "E675", "province": "FC", "name": "LONGIANO" },
    { "code": "E676", "province": "TN", "name": "LONGIARU' (soppresso)" },
    { "code": "E676", "province": "BZ", "name": "LONGIARU' (soppresso)" },
    { "code": "E677", "province": "CS", "name": "LONGOBARDI" },
    { "code": "E678", "province": "CS", "name": "LONGOBUCCO" },
    { "code": "E679", "province": "CO", "name": "LONGONE AL SEGRINO" },
    { "code": "E681", "province": "PG", "name": "LONGONE SABINO (soppresso)" },
    { "code": "E681", "province": "RM", "name": "LONGONE SABINO (soppresso)" },
    { "code": "E681", "province": "RI", "name": "LONGONE SABINO" },
    { "code": "E682", "province": "VI", "name": "LONIGO" },
    { "code": "E683", "province": "TO", "name": "LORANZE'" },
    { "code": "E683", "province": "AO", "name": "LORANZE' (soppresso)" },
    { "code": "E684", "province": "PD", "name": "LOREGGIA" },
    { "code": "E685", "province": "NO", "name": "LOREGLIA (soppresso)" },
    { "code": "E685", "province": "VB", "name": "LOREGLIA" },
    { "code": "E686", "province": "BG", "name": "LORENTINO (soppresso)" },
    { "code": "E687", "province": "BL", "name": "LORENZAGO (soppresso)" },
    { "code": "E687", "province": "BL", "name": "LORENZAGO DI CADORE" },
    { "code": "E688", "province": "PI", "name": "LORENZANA (soppresso)" },
    { "code": "E689", "province": "RO", "name": "LOREO" },
    { "code": "E690", "province": "AN", "name": "LORETO" },
    { "code": "E691", "province": "TE", "name": "LORETO APRUTINO (soppresso)" },
    { "code": "E691", "province": "PE", "name": "LORETO APRUTINO" },
    { "code": "E692", "province": "TV", "name": "LORIA" },
    { "code": "E693", "province": "AR", "name": "LORO CIUFFENNA" },
    { "code": "E694", "province": "MC", "name": "LORO PICENO" },
    { "code": "E695", "province": "GE", "name": "LORSICA" },
    { "code": "E696", "province": "GO", "name": "LOSE (soppresso)" },
    { "code": "E696", "province": "UD", "name": "LOSE (soppresso)" },
    { "code": "E697", "province": "BA", "name": "LOSETO (soppresso)" },
    { "code": "E698", "province": "BS", "name": "LOSINE" },
    { "code": "E699", "province": "CN", "name": "LOTTULO (soppresso)" },
    { "code": "E700", "province": "CA", "name": "LOTZORAI (soppresso)" },
    { "code": "E700", "province": "NU", "name": "LOTZORAI" },
    { "code": "E700", "province": "OG", "name": "LOTZORAI (soppresso)" },
    { "code": "E701", "province": "BS", "name": "LOVENO GRUMELLO (soppresso)" },
    { "code": "E702", "province": "CO", "name": "LOVENO SOPRA MENAGGIO (soppresso)" },
    { "code": "E703", "province": "TN", "name": "LOVER (soppresso)" },
    { "code": "E704", "province": "BG", "name": "LOVERE" },
    { "code": "E705", "province": "SO", "name": "LOVERO" },
    { "code": "E706", "province": "BS", "name": "LOZIO" },
    { "code": "E707", "province": "CO", "name": "LOZZA (soppresso)" },
    { "code": "E707", "province": "VA", "name": "LOZZA" },
    { "code": "E710", "province": "CO", "name": "LOZZO (soppresso)" },
    { "code": "E710", "province": "VA", "name": "LOZZO (soppresso)" },
    { "code": "E709", "province": "PD", "name": "LOZZO ATESTINO" },
    { "code": "E708", "province": "BL", "name": "LOZZO CADORE (soppresso)" },
    { "code": "E708", "province": "BL", "name": "LOZZO DI CADORE" },
    { "code": "E711", "province": "NO", "name": "LOZZOLO (soppresso)" },
    { "code": "E711", "province": "VC", "name": "LOZZOLO" },
    { "code": "E712", "province": "AL", "name": "LU (soppresso)" },
    { "code": "M420", "province": "AL", "name": "LU E CUCCARO MONFERRATO" },
    { "code": "E713", "province": "RM", "name": "LUBRIANO (soppresso)" },
    { "code": "E713", "province": "VT", "name": "LUBRIANO" },
    { "code": "E715", "province": "LU", "name": "LUCCA" },
    { "code": "E714", "province": "AG", "name": "LUCCA SICULA" },
    { "code": "E716", "province": "FG", "name": "LUCERA" },
    { "code": "E717", "province": "MI", "name": "LUCERNATE (soppresso)" },
    { "code": "E718", "province": "AR", "name": "LUCIGNANO" },
    { "code": "E719", "province": "IM", "name": "LUCINASCO" },
    { "code": "E720", "province": "GO", "name": "LUCINICO (soppresso)" },
    { "code": "E720", "province": "UD", "name": "LUCINICO (soppresso)" },
    { "code": "E721", "province": "CO", "name": "LUCINO (soppresso)" },
    { "code": "E722", "province": "CB", "name": "LUCITO" },
    { "code": "E723", "province": "AQ", "name": "LUCO DEI MARSI" },
    { "code": "E724", "province": "AQ", "name": "LUCOLI" },
    { "code": "E725", "province": "BS", "name": "LUDRIANO (soppresso)" },
    { "code": "E726", "province": "PC", "name": "LUGAGNANO VAL D'ARDA" },
    { "code": "E727", "province": "TO", "name": "LUGNACCO (soppresso)" },
    { "code": "E727", "province": "AO", "name": "LUGNACCO (soppresso)" },
    { "code": "E728", "province": "AQ", "name": "LUGNANO DI VILLA TROIANA (soppresso)" },
    { "code": "E728", "province": "RI", "name": "LUGNANO DI VILLA TROIANA (soppresso)" },
    { "code": "E729", "province": "PG", "name": "LUGNANO IN TEVERINA (soppresso)" },
    { "code": "E729", "province": "TR", "name": "LUGNANO IN TEVERINA" },
    { "code": "E730", "province": "RA", "name": "LUGO" },
    { "code": "E731", "province": "VI", "name": "LUGO DI VICENZA" },
    { "code": "E732", "province": "GO", "name": "LUICO (soppresso)" },
    { "code": "E732", "province": "UD", "name": "LUICO (soppresso)" },
    { "code": "E734", "province": "CO", "name": "LUINO (soppresso)" },
    { "code": "E734", "province": "VA", "name": "LUINO" },
    { "code": "E735", "province": "CO", "name": "LUISAGO" },
    { "code": "E736", "province": "SS", "name": "LULA (soppresso)" },
    { "code": "E736", "province": "NU", "name": "LULA" },
    { "code": "E737", "province": "GE", "name": "LUMARZO" },
    { "code": "E738", "province": "BS", "name": "LUMEZZANE" },
    { "code": "E739", "province": "BS", "name": "LUMEZZANE PIEVE (soppresso)" },
    { "code": "E740", "province": "BS", "name": "LUMEZZANE SAN SEBASTIANO (soppresso)" },
    { "code": "E741", "province": "BS", "name": "LUMEZZANE SANT'APOLLONIO (soppresso)" },
    { "code": "E742", "province": "CA", "name": "LUNAMATRONA (soppresso)" },
    { "code": "E742", "province": "VS", "name": "LUNAMATRONA (soppresso)" },
    { "code": "E742", "province": "SU", "name": "LUNAMATRONA" },
    { "code": "E743", "province": "PS", "name": "LUNANO (soppresso)" },
    { "code": "E743", "province": "PU", "name": "LUNANO" },
    { "code": "E744", "province": "TN", "name": "LUNDO (soppresso)" },
    { "code": "B387", "province": "PV", "name": "LUNGAVILLA" },
    { "code": "E745", "province": "CS", "name": "LUNGRO" },
    { "code": "G143", "province": "SP", "name": "LUNI" },
    { "code": "E746", "province": "AV", "name": "LUOGOSANO" },
    { "code": "E747", "province": "SS", "name": "LUOGOSANTO" },
    { "code": "E747", "province": "OT", "name": "LUOGOSANTO (soppresso)" },
    { "code": "E748", "province": "CB", "name": "LUPARA" },
    { "code": "E749", "province": "CO", "name": "LURAGO D'ERBA" },
    { "code": "E750", "province": "CO", "name": "LURAGO MARINONE" },
    { "code": "E751", "province": "BG", "name": "LURANO" },
    { "code": "E752", "province": "SS", "name": "LURAS" },
    { "code": "E752", "province": "OT", "name": "LURAS (soppresso)" },
    { "code": "E753", "province": "CO", "name": "LURATE ABBATE (soppresso)" },
    { "code": "E753", "province": "CO", "name": "LURATE CACCIVIO" },
    { "code": "E754", "province": "CE", "name": "LUSCIANO" },
    { "code": "E755", "province": "CE", "name": "LUSCIANO E DUCENTA (soppresso)" },
    { "code": "E755", "province": "NA", "name": "LUSCIANO E DUCENTA (soppresso)" },
    { "code": "E757", "province": "TN", "name": "LUSERNA" },
    { "code": "E758", "province": "TO", "name": "LUSERNA SAN GIOVANNI" },
    { "code": "E759", "province": "TO", "name": "LUSERNETTA" },
    { "code": "E760", "province": "UD", "name": "LUSEVERA" },
    { "code": "E761", "province": "RO", "name": "LUSIA" },
    { "code": "E762", "province": "VI", "name": "LUSIANA (soppresso)" },
    { "code": "M427", "province": "VI", "name": "LUSIANA CONCO" },
    { "code": "E763", "province": "TO", "name": "LUSIGLIE'" },
    { "code": "E763", "province": "AO", "name": "LUSIGLIE' (soppresso)" },
    { "code": "E764", "province": "TN", "name": "LUSON (soppresso)" },
    { "code": "E764", "province": "BZ", "name": "LUSON" },
    { "code": "E765", "province": "PL", "name": "LUSSINGRANDE (soppresso)" },
    { "code": "E766", "province": "PL", "name": "LUSSINPICCOLO (soppresso)" },
    { "code": "E767", "province": "SA", "name": "LUSTRA" },
    { "code": "E768", "province": "TN", "name": "LUTAGO (soppresso)" },
    { "code": "E768", "province": "BZ", "name": "LUTAGO (soppresso)" },
    { "code": "E769", "province": "CO", "name": "LUVINATE (soppresso)" },
    { "code": "E769", "province": "VA", "name": "LUVINATE" },
    { "code": "E770", "province": "BG", "name": "LUZZANA" },
    { "code": "E772", "province": "RE", "name": "LUZZARA" },
    { "code": "E773", "province": "CS", "name": "LUZZI" },
    { "code": "E774", "province": "NO", "name": "LUZZOGNO (soppresso)" },
    { "code": "E775", "province": "VA", "name": "MACCAGNO (soppresso)" },
    { "code": "M339", "province": "VA", "name": "MACCAGNO CON PINO E VEDDASCA" },
    { "code": "E776", "province": "CO", "name": "MACCAGNO INFERIORE (soppresso)" },
    { "code": "E776", "province": "VA", "name": "MACCAGNO INFERIORE (soppresso)" },
    { "code": "E775", "province": "CO", "name": "MACCAGNO SUPERIORE (soppresso)" },
    { "code": "E775", "province": "VA", "name": "MACCAGNO SUPERIORE (soppresso)" },
    { "code": "E777", "province": "MI", "name": "MACCASTORNA (soppresso)" },
    { "code": "E777", "province": "LO", "name": "MACCASTORNA" },
    { "code": "E778", "province": "CB", "name": "MACCHIA D'ISERNIA (soppresso)" },
    { "code": "E778", "province": "IS", "name": "MACCHIA D'ISERNIA" },
    { "code": "E780", "province": "CB", "name": "MACCHIA VALFORTORE" },
    { "code": "E779", "province": "CB", "name": "MACCHIAGODENA (soppresso)" },
    { "code": "E779", "province": "IS", "name": "MACCHIAGODENA" },
    { "code": "E781", "province": "CO", "name": "MACCIO (soppresso)" },
    { "code": "E782", "province": "TO", "name": "MACELLO" },
    { "code": "E783", "province": "MC", "name": "MACERATA" },
    { "code": "E784", "province": "CE", "name": "MACERATA CAMPANIA" },
    { "code": "E784", "province": "NA", "name": "MACERATA CAMPANIA (soppresso)" },
    { "code": "E784", "province": "CE", "name": "MACERATA DI MARCIANISE (soppresso)" },
    { "code": "E785", "province": "PS", "name": "MACERATA FELTRIA (soppresso)" },
    { "code": "E785", "province": "PU", "name": "MACERATA FELTRIA" },
    { "code": "E786", "province": "MI", "name": "MACHERIO (soppresso)" },
    { "code": "E786", "province": "MB", "name": "MACHERIO" },
    { "code": "E787", "province": "BS", "name": "MACLODIO" },
    { "code": "E788", "province": "CA", "name": "MACOMER (soppresso)" },
    { "code": "E788", "province": "NU", "name": "MACOMER" },
    { "code": "E789", "province": "CN", "name": "MACRA" },
    { "code": "E790", "province": "NO", "name": "MACUGNAGA (soppresso)" },
    { "code": "E790", "province": "VB", "name": "MACUGNAGA" },
    { "code": "E791", "province": "CE", "name": "MADDALONI" },
    { "code": "E791", "province": "NA", "name": "MADDALONI (soppresso)" },
    { "code": "E792", "province": "BS", "name": "MADERNO (soppresso)" },
    { "code": "E342", "province": "SO", "name": "MADESIMO" },
    { "code": "E793", "province": "CR", "name": "MADIGNANO" },
    { "code": "E794", "province": "BG", "name": "MADONE" },
    { "code": "E795", "province": "NO", "name": "MADONNA DEL SASSO (soppresso)" },
    { "code": "E795", "province": "VB", "name": "MADONNA DEL SASSO" },
    { "code": "E796", "province": "TN", "name": "MADRANO (soppresso)" },
    { "code": "E797", "province": "TN", "name": "MADRUZZO (soppresso)" },
    { "code": "M357", "province": "TN", "name": "MADRUZZO" },
    { "code": "E798", "province": "RM", "name": "MAENZA (soppresso)" },
    { "code": "E798", "province": "LT", "name": "MAENZA" },
    { "code": "E799", "province": "CB", "name": "MAFALDA" },
    { "code": "E800", "province": "TN", "name": "MAGASA (soppresso)" },
    { "code": "E800", "province": "BS", "name": "MAGASA" },
    { "code": "E801", "province": "MI", "name": "MAGENTA" },
    { "code": "E802", "province": "CO", "name": "MAGGIANICO (soppresso)" },
    { "code": "E803", "province": "NO", "name": "MAGGIORA" },
    { "code": "E804", "province": "PV", "name": "MAGHERNO" },
    { "code": "E805", "province": "PG", "name": "MAGIONE" },
    { "code": "E806", "province": "CZ", "name": "MAGISANO" },
    { "code": "E809", "province": "CN", "name": "MAGLIANO ALFIERI" },
    { "code": "E808", "province": "CN", "name": "MAGLIANO ALPI" },
    { "code": "E809", "province": "CN", "name": "MAGLIANO D'ALBA (soppresso)" },
    { "code": "E811", "province": "AQ", "name": "MAGLIANO DE' MARSI" },
    { "code": "E807", "province": "AP", "name": "MAGLIANO DI TENNA (soppresso)" },
    { "code": "E807", "province": "FM", "name": "MAGLIANO DI TENNA" },
    { "code": "E810", "province": "GR", "name": "MAGLIANO IN TOSCANA" },
    { "code": "E813", "province": "RM", "name": "MAGLIANO ROMANO" },
    { "code": "E812", "province": "PG", "name": "MAGLIANO SABINA (soppresso)" },
    { "code": "E812", "province": "RM", "name": "MAGLIANO SABINA (soppresso)" },
    { "code": "E812", "province": "RI", "name": "MAGLIANO SABINA" },
    { "code": "E814", "province": "SA", "name": "MAGLIANO VETERE" },
    { "code": "E815", "province": "LE", "name": "MAGLIE" },
    { "code": "E816", "province": "GE", "name": "MAGLIOLO (soppresso)" },
    { "code": "E816", "province": "SV", "name": "MAGLIOLO" },
    { "code": "E817", "province": "TO", "name": "MAGLIONE" },
    { "code": "E817", "province": "AO", "name": "MAGLIONE (soppresso)" },
    { "code": "E818", "province": "MN", "name": "MAGNACAVALLO" },
    { "code": "E819", "province": "MI", "name": "MAGNAGO" },
    { "code": "E821", "province": "NO", "name": "MAGNANO (soppresso)" },
    { "code": "E821", "province": "VC", "name": "MAGNANO (soppresso)" },
    { "code": "E821", "province": "BI", "name": "MAGNANO" },
    { "code": "E820", "province": "UD", "name": "MAGNANO IN RIVIERA" },
    { "code": "E823", "province": "BS", "name": "MAGNO SOPRA INZINO (soppresso)" },
    { "code": "E824", "province": "NO", "name": "MAGOGNINO (soppresso)" },
    { "code": "E825", "province": "CA", "name": "MAGOMADAS (soppresso)" },
    { "code": "E825", "province": "NU", "name": "MAGOMADAS (soppresso)" },
    { "code": "E825", "province": "OR", "name": "MAGOMADAS" },
    { "code": "E826", "province": "TN", "name": "MAGRAS (soppresso)" },
    { "code": "E828", "province": "VI", "name": "MAGRE' (soppresso)" },
    { "code": "E827", "province": "TN", "name": "MAGRE' (soppresso)" },
    { "code": "E827", "province": "BZ", "name": "MAGRE' (soppresso)" },
    { "code": "E829", "province": "TN", "name": "MAGRE' ALL'ADIGE (soppresso)" },
    { "code": "E829", "province": "BZ", "name": "MAGRE' ALL'ADIGE (soppresso)" },
    { "code": "E829", "province": "BZ", "name": "MAGRE' SULLA STRADA DEL VINO" },
    { "code": "E828", "province": "VI", "name": "MAGRE' VICENTINO (soppresso)" },
    { "code": "E830", "province": "CO", "name": "MAGREGLIO" },
    { "code": "E831", "province": "TN", "name": "MAIA ALTA (soppresso)" },
    { "code": "E832", "province": "TN", "name": "MAIA BASSA (soppresso)" },
    { "code": "E834", "province": "CZ", "name": "MAIDA" },
    { "code": "E835", "province": "CS", "name": "MAIERA'" },
    { "code": "E836", "province": "CZ", "name": "MAIERATO (soppresso)" },
    { "code": "E836", "province": "VV", "name": "MAIERATO" },
    { "code": "E837", "province": "AN", "name": "MAIOLATI (soppresso)" },
    { "code": "E837", "province": "AN", "name": "MAIOLATI SPONTINI" },
    { "code": "E838", "province": "PS", "name": "MAIOLO (soppresso)" },
    { "code": "E838", "province": "PU", "name": "MAIOLO (soppresso)" },
    { "code": "E838", "province": "RN", "name": "MAIOLO" },
    { "code": "E839", "province": "SA", "name": "MAIORI" },
    { "code": "E840", "province": "MI", "name": "MAIRAGO (soppresso)" },
    { "code": "E840", "province": "LO", "name": "MAIRAGO" },
    { "code": "E841", "province": "BS", "name": "MAIRANO" },
    { "code": "E842", "province": "GE", "name": "MAISSANA (soppresso)" },
    { "code": "E842", "province": "SP", "name": "MAISSANA" },
    { "code": "E833", "province": "UD", "name": "MAJANO" },
    { "code": "E843", "province": "CR", "name": "MALAGNINO" },
    { "code": "E844", "province": "BO", "name": "MALALBERGO" },
    { "code": "E846", "province": "UD", "name": "MALBORGHETTO (soppresso)" },
    { "code": "E847", "province": "UD", "name": "MALBORGHETTO VALBRUNA" },
    { "code": "E848", "province": "VR", "name": "MALCESINE" },
    { "code": "E849", "province": "TS", "name": "MALCHINA (soppresso)" },
    { "code": "E850", "province": "TN", "name": "MALE'" },
    { "code": "E851", "province": "BS", "name": "MALEGNO" },
    { "code": "E852", "province": "MI", "name": "MALEO (soppresso)" },
    { "code": "E852", "province": "LO", "name": "MALEO" },
    { "code": "E853", "province": "NO", "name": "MALESCO (soppresso)" },
    { "code": "E853", "province": "VB", "name": "MALESCO" },
    { "code": "E854", "province": "CT", "name": "MALETTO" },
    { "code": "E855", "province": "ME", "name": "MALFA" },
    { "code": "E856", "province": "CO", "name": "MALGESSO (soppresso)" },
    { "code": "E856", "province": "VA", "name": "MALGESSO" },
    { "code": "E857", "province": "TN", "name": "MALGOLO (soppresso)" },
    { "code": "E858", "province": "CO", "name": "MALGRATE (soppresso)" },
    { "code": "E858", "province": "LC", "name": "MALGRATE" },
    { "code": "E859", "province": "CS", "name": "MALITO" },
    { "code": "E860", "province": "GE", "name": "MALLARE (soppresso)" },
    { "code": "E860", "province": "SV", "name": "MALLARE" },
    { "code": "E861", "province": "TN", "name": "MALLAS (soppresso)" },
    { "code": "E861", "province": "BZ", "name": "MALLAS (soppresso)" },
    { "code": "E861", "province": "TN", "name": "MALLES (soppresso)" },
    { "code": "E862", "province": "BZ", "name": "MALLES VENOSTA" },
    { "code": "E863", "province": "CO", "name": "MALNATE (soppresso)" },
    { "code": "E863", "province": "VA", "name": "MALNATE" },
    { "code": "E864", "province": "VI", "name": "MALO" },
    { "code": "E865", "province": "BS", "name": "MALONNO" },
    { "code": "E866", "province": "TN", "name": "MALOSCO" },
    { "code": "E867", "province": "CN", "name": "MALPOTREMO (soppresso)" },
    { "code": "E868", "province": "AP", "name": "MALTIGNANO" },
    { "code": "E869", "province": "ME", "name": "MALVAGNA" },
    { "code": "E870", "province": "AL", "name": "MALVICINO" },
    { "code": "E871", "province": "AL", "name": "MALVINO (soppresso)" },
    { "code": "E872", "province": "CS", "name": "MALVITO" },
    { "code": "E873", "province": "RC", "name": "MAMMOLA" },
    { "code": "E874", "province": "SS", "name": "MAMOIADA (soppresso)" },
    { "code": "E874", "province": "NU", "name": "MAMOIADA" },
    { "code": "E849", "province": "TS", "name": "MANCHINIE (soppresso)" },
    { "code": "E875", "province": "GR", "name": "MANCIANO" },
    { "code": "E876", "province": "ME", "name": "MANDANICI" },
    { "code": "E877", "province": "CA", "name": "MANDAS (soppresso)" },
    { "code": "E877", "province": "SU", "name": "MANDAS" },
    { "code": "E878", "province": "CS", "name": "MANDATORICCIO" },
    { "code": "B632", "province": "RM", "name": "MANDELA" },
    { "code": "E879", "province": "CO", "name": "MANDELLO DEL LARIO (soppresso)" },
    { "code": "E879", "province": "LC", "name": "MANDELLO DEL LARIO" },
    { "code": "E880", "province": "NO", "name": "MANDELLO VITTA" },
    { "code": "E882", "province": "LE", "name": "MANDURIA (soppresso)" },
    { "code": "E882", "province": "TA", "name": "MANDURIA" },
    { "code": "E883", "province": "BS", "name": "MANERBA (soppresso)" },
    { "code": "E883", "province": "BS", "name": "MANERBA DEL GARDA" },
    { "code": "E884", "province": "BS", "name": "MANERBIO" },
    { "code": "E885", "province": "FG", "name": "MANFREDONIA" },
    { "code": "E887", "province": "CN", "name": "MANGO" },
    { "code": "E888", "province": "CS", "name": "MANGONE" },
    { "code": "M283", "province": "CT", "name": "MANIACE" },
    { "code": "E889", "province": "UD", "name": "MANIAGO (soppresso)" },
    { "code": "E889", "province": "PN", "name": "MANIAGO" },
    { "code": "E890", "province": "TO", "name": "MANIGLIA (soppresso)" },
    { "code": "E891", "province": "AV", "name": "MANOCALZATI" },
    { "code": "E892", "province": "CH", "name": "MANOPPELLO (soppresso)" },
    { "code": "E892", "province": "PE", "name": "MANOPPELLO" },
    { "code": "E893", "province": "TV", "name": "MANSUE'" },
    { "code": "E894", "province": "CN", "name": "MANTA" },
    { "code": "E895", "province": "TN", "name": "MANTANA (soppresso)" },
    { "code": "E895", "province": "BZ", "name": "MANTANA (soppresso)" },
    { "code": "E896", "province": "SO", "name": "MANTELLO" },
    { "code": "E897", "province": "MN", "name": "MANTOVA" },
    { "code": "E899", "province": "UD", "name": "MANZANO" },
    { "code": "E898", "province": "TN", "name": "MANZANO (soppresso)" },
    { "code": "E900", "province": "RM", "name": "MANZIANA" },
    { "code": "E901", "province": "BG", "name": "MAPELLO" },
    { "code": "M316", "province": "TO", "name": "MAPPANO" },
    { "code": "E902", "province": "SS", "name": "MARA" },
    { "code": "E903", "province": "CA", "name": "MARACALAGONIS" },
    { "code": "E904", "province": "MO", "name": "MARANELLO" },
    { "code": "E909", "province": "TN", "name": "MARANO (soppresso)" },
    { "code": "E906", "province": "NA", "name": "MARANO DI NAPOLI" },
    { "code": "E911", "province": "VR", "name": "MARANO DI VALPOLICELLA" },
    { "code": "E908", "province": "RM", "name": "MARANO EQUO" },
    { "code": "E910", "province": "UD", "name": "MARANO LAGUNARE" },
    { "code": "E914", "province": "CS", "name": "MARANO MARCHESATO" },
    { "code": "E915", "province": "CS", "name": "MARANO PRINCIPATO" },
    { "code": "E905", "province": "MO", "name": "MARANO SUL PANARO" },
    { "code": "E907", "province": "NO", "name": "MARANO TICINO" },
    { "code": "E912", "province": "VI", "name": "MARANO VICENTINO" },
    { "code": "E913", "province": "CE", "name": "MARANOLA (soppresso)" },
    { "code": "E913", "province": "RM", "name": "MARANOLA (soppresso)" },
    { "code": "E916", "province": "TN", "name": "MARANZA (soppresso)" },
    { "code": "E916", "province": "BZ", "name": "MARANZA (soppresso)" },
    { "code": "E916", "province": "TN", "name": "MARANZA IN PUSTERIA (soppresso)" },
    { "code": "E917", "province": "AL", "name": "MARANZANA (soppresso)" },
    { "code": "E917", "province": "AT", "name": "MARANZANA" },
    { "code": "E919", "province": "PZ", "name": "MARATEA" },
    { "code": "E921", "province": "MI", "name": "MARCALLO CON CASONE" },
    { "code": "E922", "province": "MN", "name": "MARCARIA" },
    { "code": "E923", "province": "CZ", "name": "MARCEDUSA" },
    { "code": "E924", "province": "RM", "name": "MARCELLINA" },
    { "code": "E925", "province": "CZ", "name": "MARCELLINARA" },
    { "code": "E926", "province": "VR", "name": "MARCELLISE (soppresso)" },
    { "code": "E927", "province": "PG", "name": "MARCETELLI (soppresso)" },
    { "code": "E927", "province": "RM", "name": "MARCETELLI (soppresso)" },
    { "code": "E927", "province": "RI", "name": "MARCETELLI" },
    { "code": "E928", "province": "BS", "name": "MARCHENO" },
    { "code": "E929", "province": "CO", "name": "MARCHIROLO (soppresso)" },
    { "code": "E929", "province": "VA", "name": "MARCHIROLO" },
    { "code": "E930", "province": "LI", "name": "MARCIANA" },
    { "code": "E931", "province": "LI", "name": "MARCIANA MARINA" },
    { "code": "E932", "province": "CE", "name": "MARCIANISE" },
    { "code": "E932", "province": "NA", "name": "MARCIANISE (soppresso)" },
    { "code": "E933", "province": "AR", "name": "MARCIANO DELLA CHIANA" },
    { "code": "E934", "province": "PV", "name": "MARCIGNAGO" },
    { "code": "E935", "province": "TN", "name": "MARCO (soppresso)" },
    { "code": "E936", "province": "VE", "name": "MARCON" },
    { "code": "E937", "province": "TO", "name": "MARCORENGO (soppresso)" },
    { "code": "E938", "province": "TN", "name": "MAREBBE (soppresso)" },
    { "code": "E938", "province": "BZ", "name": "MAREBBE" },
    { "code": "E939", "province": "CN", "name": "MARENE" },
    { "code": "E940", "province": "TV", "name": "MARENO DI PIAVE" },
    { "code": "E941", "province": "TO", "name": "MARENTINO" },
    { "code": "E942", "province": "PL", "name": "MARESEGO (soppresso)" },
    { "code": "E943", "province": "TN", "name": "MARETA (soppresso)" },
    { "code": "E943", "province": "BZ", "name": "MARETA (soppresso)" },
    { "code": "E944", "province": "AL", "name": "MARETTO (soppresso)" },
    { "code": "E944", "province": "AT", "name": "MARETTO" },
    { "code": "E945", "province": "CN", "name": "MARGARITA" },
    { "code": "E946", "province": "FG", "name": "MARGHERITA DI SAVOIA (soppresso)" },
    { "code": "E946", "province": "BT", "name": "MARGHERITA DI SAVOIA" },
    { "code": "E947", "province": "CO", "name": "MARGNO (soppresso)" },
    { "code": "E947", "province": "LC", "name": "MARGNO" },
    { "code": "E948", "province": "TN", "name": "MARGONE (soppresso)" },
    { "code": "E949", "province": "MN", "name": "MARIANA (soppresso)" },
    { "code": "E949", "province": "MN", "name": "MARIANA MANTOVANA" },
    { "code": "E952", "province": "GO", "name": "MARIANO (soppresso)" },
    { "code": "E952", "province": "UD", "name": "MARIANO (soppresso)" },
    { "code": "E950", "province": "BG", "name": "MARIANO AL BREMBO (soppresso)" },
    { "code": "E951", "province": "CO", "name": "MARIANO COMENSE" },
    { "code": "E952", "province": "UD", "name": "MARIANO DEL FRIULI (soppresso)" },
    { "code": "E952", "province": "GO", "name": "MARIANO DEL FRIULI" },
    { "code": "E953", "province": "CL", "name": "MARIANOPOLI" },
    { "code": "E954", "province": "CE", "name": "MARIGLIANELLA (soppresso)" },
    { "code": "E954", "province": "NA", "name": "MARIGLIANELLA" },
    { "code": "E955", "province": "CE", "name": "MARIGLIANO (soppresso)" },
    { "code": "E955", "province": "NA", "name": "MARIGLIANO" },
    { "code": "E956", "province": "RC", "name": "MARINA DI GIOIOSA IONICA" },
    { "code": "E957", "province": "PA", "name": "MARINEO" },
    { "code": "E958", "province": "RM", "name": "MARINO" },
    { "code": "E959", "province": "TN", "name": "MARLENGO (soppresso)" },
    { "code": "E959", "province": "BZ", "name": "MARLENGO" },
    { "code": "E960", "province": "FI", "name": "MARLIANA (soppresso)" },
    { "code": "E960", "province": "PT", "name": "MARLIANA" },
    { "code": "E961", "province": "BS", "name": "MARMENTINO" },
    { "code": "E962", "province": "MN", "name": "MARMIROLO" },
    { "code": "E963", "province": "CN", "name": "MARMORA" },
    { "code": "E964", "province": "AL", "name": "MARMORITO (soppresso)" },
    { "code": "E965", "province": "MI", "name": "MARNATE (soppresso)" },
    { "code": "E965", "province": "VA", "name": "MARNATE" },
    { "code": "D588", "province": "BG", "name": "MARNE (soppresso)" },
    { "code": "E966", "province": "IM", "name": "MARO CASTELLO (soppresso)" },
    { "code": "E967", "province": "BS", "name": "MARONE" },
    { "code": "E968", "province": "RC", "name": "MAROPATI" },
    { "code": "E970", "province": "VI", "name": "MAROSTICA" },
    { "code": "E971", "province": "FI", "name": "MARRADI" },
    { "code": "E972", "province": "CA", "name": "MARRUBIU (soppresso)" },
    { "code": "E972", "province": "OR", "name": "MARRUBIU" },
    { "code": "E973", "province": "CN", "name": "MARSAGLIA" },
    { "code": "E974", "province": "TP", "name": "MARSALA" },
    { "code": "E975", "province": "PG", "name": "MARSCIANO" },
    { "code": "E976", "province": "PZ", "name": "MARSICO NUOVO" },
    { "code": "E977", "province": "PZ", "name": "MARSICOVETERE" },
    { "code": "E978", "province": "RM", "name": "MARTA (soppresso)" },
    { "code": "E978", "province": "VT", "name": "MARTA" },
    { "code": "E979", "province": "LE", "name": "MARTANO" },
    { "code": "E980", "province": "VE", "name": "MARTELLAGO" },
    { "code": "E981", "province": "TN", "name": "MARTELLO (soppresso)" },
    { "code": "E981", "province": "BZ", "name": "MARTELLO" },
    { "code": "E982", "province": "UD", "name": "MARTIGNACCO" },
    { "code": "E983", "province": "CR", "name": "MARTIGNANA DI PO" },
    { "code": "E984", "province": "LE", "name": "MARTIGNANO" },
    { "code": "E986", "province": "LE", "name": "MARTINA FRANCA (soppresso)" },
    { "code": "E986", "province": "TA", "name": "MARTINA FRANCA" },
    { "code": "E985", "province": "GE", "name": "MARTINA OLBA (soppresso)" },
    { "code": "E985", "province": "SV", "name": "MARTINA OLBA (soppresso)" },
    { "code": "E987", "province": "BG", "name": "MARTINENGO" },
    { "code": "E988", "province": "CN", "name": "MARTINIANA PO" },
    { "code": "E989", "province": "TE", "name": "MARTINSICURO" },
    { "code": "E991", "province": "CZ", "name": "MARTIRANO (soppresso)" },
    { "code": "E990", "province": "CZ", "name": "MARTIRANO" },
    { "code": "E991", "province": "CZ", "name": "MARTIRANO LOMBARDO" },
    { "code": "E992", "province": "SS", "name": "MARTIS" },
    { "code": "E993", "province": "RC", "name": "MARTONE" },
    { "code": "E994", "province": "MI", "name": "MARUDO (soppresso)" },
    { "code": "E994", "province": "LO", "name": "MARUDO" },
    { "code": "E995", "province": "LE", "name": "MARUGGIO (soppresso)" },
    { "code": "E995", "province": "TA", "name": "MARUGGIO" },
    { "code": "B689", "province": "BO", "name": "MARZABOTTO" },
    { "code": "E999", "province": "PV", "name": "MARZANO" },
    { "code": "E998", "province": "CE", "name": "MARZANO APPIO" },
    { "code": "E998", "province": "NA", "name": "MARZANO APPIO (soppresso)" },
    { "code": "E997", "province": "AV", "name": "MARZANO DI NOLA" },
    { "code": "F001", "province": "CS", "name": "MARZI" },
    { "code": "F002", "province": "CO", "name": "MARZIO (soppresso)" },
    { "code": "F002", "province": "VA", "name": "MARZIO" },
    { "code": "M270", "province": "CA", "name": "MASAINAS (soppresso)" },
    { "code": "M270", "province": "CI", "name": "MASAINAS (soppresso)" },
    { "code": "M270", "province": "SU", "name": "MASAINAS" },
    { "code": "F003", "province": "MI", "name": "MASATE" },
    { "code": "F004", "province": "CT", "name": "MASCALI" },
    { "code": "F005", "province": "CT", "name": "MASCALUCIA" },
    { "code": "F006", "province": "PZ", "name": "MASCHITO" },
    { "code": "F008", "province": "MI", "name": "MASCIAGO MILANESE (soppresso)" },
    { "code": "F007", "province": "CO", "name": "MASCIAGO PRIMO (soppresso)" },
    { "code": "F007", "province": "VA", "name": "MASCIAGO PRIMO" },
    { "code": "F009", "province": "TV", "name": "MASER" },
    { "code": "F010", "province": "NO", "name": "MASERA (soppresso)" },
    { "code": "F010", "province": "VB", "name": "MASERA" },
    { "code": "F011", "province": "PD", "name": "MASERA' DI PADOVA" },
    { "code": "F012", "province": "TV", "name": "MASERADA (soppresso)" },
    { "code": "F012", "province": "TV", "name": "MASERADA SUL PIAVE" },
    { "code": "F013", "province": "PD", "name": "MASI" },
    { "code": "F014", "province": "TN", "name": "MASI DI VIGO (soppresso)" },
    { "code": "F016", "province": "FE", "name": "MASI TORELLO" },
    { "code": "B733", "province": "TO", "name": "MASINO (soppresso)" },
    { "code": "B733", "province": "AO", "name": "MASINO (soppresso)" },
    { "code": "F015", "province": "AL", "name": "MASIO" },
    { "code": "F017", "province": "CO", "name": "MASLIANICO" },
    { "code": "F018", "province": "CO", "name": "MASNAGO (soppresso)" },
    { "code": "F018", "province": "VA", "name": "MASNAGO (soppresso)" },
    { "code": "F019", "province": "VI", "name": "MASON VICENTINO (soppresso)" },
    { "code": "F020", "province": "GE", "name": "MASONE" },
    { "code": "F023", "province": "MS", "name": "MASSA" },
    { "code": "F022", "province": "AQ", "name": "MASSA D'ALBE" },
    { "code": "M289", "province": "NA", "name": "MASSA DI SOMMA" },
    { "code": "F025", "province": "LU", "name": "MASSA E COZZILE (soppresso)" },
    { "code": "F025", "province": "PT", "name": "MASSA E COZZILE" },
    { "code": "F021", "province": "AP", "name": "MASSA FERMANA (soppresso)" },
    { "code": "F021", "province": "FM", "name": "MASSA FERMANA" },
    { "code": "F026", "province": "FE", "name": "MASSA FISCAGLIA (soppresso)" },
    { "code": "F029", "province": "RA", "name": "MASSA LOMBARDA" },
    { "code": "F030", "province": "NA", "name": "MASSA LUBRENSE" },
    { "code": "F032", "province": "GR", "name": "MASSA MARITTIMA" },
    { "code": "F024", "province": "PG", "name": "MASSA MARTANA" },
    { "code": "F036", "province": "RO", "name": "MASSA SUPERIORE (soppresso)" },
    { "code": "F027", "province": "LE", "name": "MASSAFRA (soppresso)" },
    { "code": "F027", "province": "TA", "name": "MASSAFRA" },
    { "code": "F028", "province": "MI", "name": "MASSALENGO (soppresso)" },
    { "code": "F028", "province": "LO", "name": "MASSALENGO" },
    { "code": "F031", "province": "CA", "name": "MASSAMA (soppresso)" },
    { "code": "F033", "province": "PD", "name": "MASSANZAGO" },
    { "code": "F035", "province": "LU", "name": "MASSAROSA" },
    { "code": "F037", "province": "NO", "name": "MASSAZZA (soppresso)" },
    { "code": "F037", "province": "VC", "name": "MASSAZZA (soppresso)" },
    { "code": "F037", "province": "BI", "name": "MASSAZZA" },
    { "code": "F039", "province": "SI", "name": "MASSE DI SAN MARTINO (soppresso)" },
    { "code": "F040", "province": "SI", "name": "MASSE DI SIENA (soppresso)" },
    { "code": "F041", "province": "TO", "name": "MASSELLO" },
    { "code": "F042", "province": "NO", "name": "MASSERANO (soppresso)" },
    { "code": "F042", "province": "VC", "name": "MASSERANO (soppresso)" },
    { "code": "F042", "province": "BI", "name": "MASSERANO" },
    { "code": "F044", "province": "AP", "name": "MASSIGNANO" },
    { "code": "F045", "province": "TN", "name": "MASSIMENO" },
    { "code": "F046", "province": "GE", "name": "MASSIMINO (soppresso)" },
    { "code": "F046", "province": "SV", "name": "MASSIMINO" },
    { "code": "F047", "province": "NO", "name": "MASSINO (soppresso)" },
    { "code": "F047", "province": "NO", "name": "MASSINO VISCONTI" },
    { "code": "F048", "province": "NO", "name": "MASSIOLA (soppresso)" },
    { "code": "F048", "province": "VB", "name": "MASSIOLA" },
    { "code": "F049", "province": "TN", "name": "MASTELLINA (soppresso)" },
    { "code": "F050", "province": "CA", "name": "MASULLAS (soppresso)" },
    { "code": "F050", "province": "OR", "name": "MASULLAS" },
    { "code": "F051", "province": "MC", "name": "MATELICA" },
    { "code": "F052", "province": "PZ", "name": "MATERA (soppresso)" },
    { "code": "F052", "province": "MT", "name": "MATERA" },
    { "code": "F053", "province": "TO", "name": "MATHI" },
    { "code": "F053", "province": "TO", "name": "MATI (soppresso)" },
    { "code": "F054", "province": "LE", "name": "MATINO" },
    { "code": "F055", "province": "CB", "name": "MATRICE" },
    { "code": "F056", "province": "TN", "name": "MATTARELLO (soppresso)" },
    { "code": "F057", "province": "FU", "name": "MATTERIA (soppresso)" },
    { "code": "F057", "province": "PL", "name": "MATTERIA (soppresso)" },
    { "code": "F058", "province": "TO", "name": "MATTIE" },
    { "code": "F059", "province": "FG", "name": "MATTINATA" },
    { "code": "F060", "province": "FU", "name": "MATTUGLIE (soppresso)" },
    { "code": "F060", "province": "PL", "name": "MATTUGLIE (soppresso)" },
    { "code": "F061", "province": "TP", "name": "MAZARA DEL VALLO" },
    { "code": "F062", "province": "TN", "name": "MAZIA (soppresso)" },
    { "code": "F062", "province": "BZ", "name": "MAZIA (soppresso)" },
    { "code": "F063", "province": "BS", "name": "MAZZANO" },
    { "code": "F064", "province": "RM", "name": "MAZZANO ROMANO" },
    { "code": "F065", "province": "CL", "name": "MAZZARINO" },
    { "code": "F066", "province": "ME", "name": "MAZZARRA' SANT'ANDREA" },
    { "code": "M271", "province": "CT", "name": "MAZZARRONE" },
    { "code": "F067", "province": "TO", "name": "MAZZE'" },
    { "code": "F067", "province": "AO", "name": "MAZZE' (soppresso)" },
    { "code": "F068", "province": "TN", "name": "MAZZIN" },
    { "code": "F070", "province": "SO", "name": "MAZZO DI VALTELLINA" },
    { "code": "F069", "province": "MI", "name": "MAZZO MILANESE (soppresso)" },
    { "code": "F071", "province": "BG", "name": "MAZZOLENI E FALGHERA (soppresso)" },
    { "code": "F072", "province": "BS", "name": "MAZZUNNO (soppresso)" },
    { "code": "F074", "province": "TO", "name": "MEANA DI SUSA" },
    { "code": "F073", "province": "CA", "name": "MEANA SARDO (soppresso)" },
    { "code": "F073", "province": "NU", "name": "MEANA SARDO" },
    { "code": "F075", "province": "TO", "name": "MEANO (soppresso)" },
    { "code": "F076", "province": "TN", "name": "MEANO (soppresso)" },
    { "code": "F077", "province": "TN", "name": "MECHEL (soppresso)" },
    { "code": "F078", "province": "MI", "name": "MEDA (soppresso)" },
    { "code": "F078", "province": "MB", "name": "MEDA" },
    { "code": "F079", "province": "GO", "name": "MEDANA (soppresso)" },
    { "code": "F079", "province": "UD", "name": "MEDANA (soppresso)" },
    { "code": "F080", "province": "PV", "name": "MEDE" },
    { "code": "F081", "province": "GO", "name": "MEDEA" },
    { "code": "F081", "province": "UD", "name": "MEDEA (soppresso)" },
    { "code": "F082", "province": "PR", "name": "MEDESANO" },
    { "code": "F083", "province": "BO", "name": "MEDICINA" },
    { "code": "F084", "province": "MI", "name": "MEDIGLIA" },
    { "code": "F085", "province": "BG", "name": "MEDOLAGO" },
    { "code": "F086", "province": "MN", "name": "MEDOLE" },
    { "code": "F087", "province": "MO", "name": "MEDOLLA" },
    { "code": "F088", "province": "TV", "name": "MEDUNA DI LIVENZA" },
    { "code": "F089", "province": "UD", "name": "MEDUNO (soppresso)" },
    { "code": "F089", "province": "PN", "name": "MEDUNO" },
    { "code": "F091", "province": "PD", "name": "MEGLIADINO SAN FIDENZIO (soppresso)" },
    { "code": "F092", "province": "PD", "name": "MEGLIADINO SAN VITALE" },
    { "code": "F093", "province": "NO", "name": "MEINA" },
    { "code": "F094", "province": "BL", "name": "MEL (soppresso)" },
    { "code": "F095", "province": "RO", "name": "MELARA" },
    { "code": "F096", "province": "AL", "name": "MELAZZO" },
    { "code": "F097", "province": "FO", "name": "MELDOLA (soppresso)" },
    { "code": "F097", "province": "FC", "name": "MELDOLA" },
    { "code": "F098", "province": "GE", "name": "MELE" },
    { "code": "F100", "province": "MI", "name": "MELEGNANO" },
    { "code": "F101", "province": "LE", "name": "MELENDUGNO" },
    { "code": "F102", "province": "MI", "name": "MELETI (soppresso)" },
    { "code": "F102", "province": "LO", "name": "MELETI" },
    { "code": "F103", "province": "TO", "name": "MELEZET (soppresso)" },
    { "code": "F104", "province": "PZ", "name": "MELFI" },
    { "code": "F105", "province": "RC", "name": "MELICUCCA'" },
    { "code": "F106", "province": "RC", "name": "MELICUCCO" },
    { "code": "F107", "province": "SR", "name": "MELILLI" },
    { "code": "F108", "province": "CZ", "name": "MELISSA (soppresso)" },
    { "code": "F108", "province": "KR", "name": "MELISSA" },
    { "code": "F109", "province": "LE", "name": "MELISSANO" },
    { "code": "F111", "province": "NA", "name": "MELITO DI NAPOLI" },
    { "code": "F112", "province": "RC", "name": "MELITO DI PORTO SALVO" },
    { "code": "F110", "province": "AV", "name": "MELITO IRPINO" },
    { "code": "F110", "province": "AV", "name": "MELITO VALLE BONITO (soppresso)" },
    { "code": "F113", "province": "BN", "name": "MELIZZANO" },
    { "code": "F114", "province": "CN", "name": "MELLE" },
    { "code": "F115", "province": "SO", "name": "MELLO" },
    { "code": "F116", "province": "TV", "name": "MELMA (soppresso)" },
    { "code": "F117", "province": "LE", "name": "MELPIGNANO" },
    { "code": "F118", "province": "TN", "name": "MELTINA (soppresso)" },
    { "code": "F118", "province": "BZ", "name": "MELTINA" },
    { "code": "F119", "province": "MI", "name": "MELZO" },
    { "code": "F120", "province": "CO", "name": "MENAGGIO" },
    { "code": "F121", "province": "SO", "name": "MENAROLA (soppresso)" },
    { "code": "F122", "province": "PV", "name": "MENCONICO" },
    { "code": "F123", "province": "IM", "name": "MENDATICA" },
    { "code": "F124", "province": "IM", "name": "MENDATICA MONTEGROSSO (soppresso)" },
    { "code": "F125", "province": "CS", "name": "MENDICINO" },
    { "code": "F126", "province": "AG", "name": "MENFI" },
    { "code": "F127", "province": "RM", "name": "MENTANA" },
    { "code": "F128", "province": "TO", "name": "MENTOULLES (soppresso)" },
    { "code": "F130", "province": "VE", "name": "MEOLO" },
    { "code": "F131", "province": "AL", "name": "MERANA" },
    { "code": "F132", "province": "TN", "name": "MERANO (soppresso)" },
    { "code": "F132", "province": "BZ", "name": "MERANO" },
    { "code": "F133", "province": "CO", "name": "MERATE (soppresso)" },
    { "code": "F133", "province": "LC", "name": "MERATE" },
    { "code": "F134", "province": "CO", "name": "MERCALLO (soppresso)" },
    { "code": "F134", "province": "VA", "name": "MERCALLO" },
    { "code": "F135", "province": "PS", "name": "MERCATELLO (soppresso)" },
    { "code": "F135", "province": "PS", "name": "MERCATELLO SUL METAURO (soppresso)" },
    { "code": "F135", "province": "PU", "name": "MERCATELLO SUL METAURO" },
    { "code": "F136", "province": "PS", "name": "MERCATINO CONCA (soppresso)" },
    { "code": "F136", "province": "PU", "name": "MERCATINO CONCA" },
    { "code": "F137", "province": "PS", "name": "MERCATINO MARECCHIA (soppresso)" },
    { "code": "F138", "province": "SA", "name": "MERCATO SAN SEVERINO" },
    { "code": "F139", "province": "FO", "name": "MERCATO SARACENO (soppresso)" },
    { "code": "F139", "province": "FC", "name": "MERCATO SARACENO" },
    { "code": "F140", "province": "TO", "name": "MERCENASCO" },
    { "code": "F140", "province": "AO", "name": "MERCENASCO (soppresso)" },
    { "code": "F141", "province": "AV", "name": "MERCOGLIANO" },
    { "code": "F143", "province": "NO", "name": "MERCURAGO (soppresso)" },
    { "code": "F144", "province": "UD", "name": "MERETO DI TOMBA" },
    { "code": "F144", "province": "UD", "name": "MERETTO DI TOMBA (soppresso)" },
    { "code": "F145", "province": "AN", "name": "MERGO" },
    { "code": "F146", "province": "NO", "name": "MERGOZZO (soppresso)" },
    { "code": "F146", "province": "VB", "name": "MERGOZZO" },
    { "code": "F147", "province": "ME", "name": "MERI'" },
    { "code": "F148", "province": "PD", "name": "MERLARA" },
    { "code": "F149", "province": "MI", "name": "MERLINO (soppresso)" },
    { "code": "F149", "province": "LO", "name": "MERLINO" },
    { "code": "F150", "province": "GO", "name": "MERNA (soppresso)" },
    { "code": "F150", "province": "UD", "name": "MERNA (soppresso)" },
    { "code": "F151", "province": "CO", "name": "MERONE" },
    { "code": "F152", "province": "LE", "name": "MESAGNE (soppresso)" },
    { "code": "F152", "province": "BR", "name": "MESAGNE" },
    { "code": "F153", "province": "SO", "name": "MESE" },
    { "code": "F154", "province": "CO", "name": "MESENZANA (soppresso)" },
    { "code": "F154", "province": "VA", "name": "MESENZANA" },
    { "code": "F155", "province": "MI", "name": "MESERO" },
    { "code": "F156", "province": "FE", "name": "MESOLA" },
    { "code": "F157", "province": "CZ", "name": "MESORACA (soppresso)" },
    { "code": "F157", "province": "KR", "name": "MESORACA" },
    { "code": "F158", "province": "ME", "name": "MESSINA" },
    { "code": "F159", "province": "VE", "name": "MESTRE (soppresso)" },
    { "code": "F160", "province": "TN", "name": "MESTRIAGO (soppresso)" },
    { "code": "F161", "province": "PD", "name": "MESTRINO" },
    { "code": "F162", "province": "NA", "name": "META" },
    { "code": "A987", "province": "PR", "name": "METTI E POZZOLO (soppresso)" },
    { "code": "F164", "province": "TO", "name": "MEUGLIANO (soppresso)" },
    { "code": "F164", "province": "AO", "name": "MEUGLIANO (soppresso)" },
    { "code": "F165", "province": "MI", "name": "MEZZAGO (soppresso)" },
    { "code": "F165", "province": "MB", "name": "MEZZAGO" },
    { "code": "F168", "province": "TN", "name": "MEZZANA" },
    { "code": "F170", "province": "PV", "name": "MEZZANA BIGLI" },
    { "code": "F167", "province": "NO", "name": "MEZZANA MORTIGLIENGO (soppresso)" },
    { "code": "F167", "province": "VC", "name": "MEZZANA MORTIGLIENGO (soppresso)" },
    { "code": "F167", "province": "BI", "name": "MEZZANA MORTIGLIENGO" },
    { "code": "F171", "province": "PV", "name": "MEZZANA RABATTONE" },
    { "code": "F169", "province": "MI", "name": "MEZZANA SUPERIORE (soppresso)" },
    { "code": "F169", "province": "VA", "name": "MEZZANA SUPERIORE (soppresso)" },
    { "code": "F172", "province": "VR", "name": "MEZZANE DI SOTTO" },
    { "code": "F173", "province": "GE", "name": "MEZZANEGO" },
    { "code": "F174", "province": "PR", "name": "MEZZANI (soppresso)" },
    { "code": "F175", "province": "PV", "name": "MEZZANINO" },
    { "code": "F176", "province": "TN", "name": "MEZZANO" },
    { "code": "F177", "province": "TN", "name": "MEZZANO IMER (soppresso)" },
    { "code": "D731", "province": "TN", "name": "MEZZASELVA (soppresso)" },
    { "code": "D731", "province": "BZ", "name": "MEZZASELVA (soppresso)" },
    { "code": "D731", "province": "TN", "name": "MEZZASELVA ALL'ISARCO (soppresso)" },
    { "code": "E601", "province": "MI", "name": "MEZZATE (soppresso)" },
    { "code": "F181", "province": "CO", "name": "MEZZEGRA (soppresso)" },
    { "code": "F182", "province": "TO", "name": "MEZZENILE" },
    { "code": "F183", "province": "TN", "name": "MEZZOCORONA" },
    { "code": "F184", "province": "PA", "name": "MEZZOJUSO" },
    { "code": "F185", "province": "TN", "name": "MEZZOLAGO (soppresso)" },
    { "code": "F186", "province": "BG", "name": "MEZZOLDO" },
    { "code": "F187", "province": "TN", "name": "MEZZOLOMBARDO" },
    { "code": "F188", "province": "NO", "name": "MEZZOMERICO" },
    { "code": "F189", "province": "NO", "name": "MIAGLIANO (soppresso)" },
    { "code": "F189", "province": "VC", "name": "MIAGLIANO (soppresso)" },
    { "code": "F189", "province": "BI", "name": "MIAGLIANO" },
    { "code": "F190", "province": "TV", "name": "MIANE" },
    { "code": "F191", "province": "NO", "name": "MIASINO" },
    { "code": "F192", "province": "NO", "name": "MIAZZINA (soppresso)" },
    { "code": "F192", "province": "VB", "name": "MIAZZINA" },
    { "code": "F193", "province": "AQ", "name": "MICIGLIANO (soppresso)" },
    { "code": "F193", "province": "RI", "name": "MICIGLIANO" },
    { "code": "F194", "province": "LE", "name": "MIGGIANO" },
    { "code": "F195", "province": "NO", "name": "MIGIANDONE (soppresso)" },
    { "code": "F196", "province": "CH", "name": "MIGLIANICO" },
    { "code": "F198", "province": "FE", "name": "MIGLIARINO (soppresso)" },
    { "code": "F199", "province": "FE", "name": "MIGLIARO (soppresso)" },
    { "code": "F200", "province": "CZ", "name": "MIGLIERINA" },
    { "code": "F201", "province": "PZ", "name": "MIGLIONICO (soppresso)" },
    { "code": "F201", "province": "MT", "name": "MIGLIONICO" },
    { "code": "F202", "province": "GE", "name": "MIGNANEGO" },
    { "code": "F203", "province": "CE", "name": "MIGNANO (soppresso)" },
    { "code": "F203", "province": "NA", "name": "MIGNANO (soppresso)" },
    { "code": "F203", "province": "CE", "name": "MIGNANO MONTE LUNGO" },
    { "code": "F204", "province": "MI", "name": "MIGNETTE (soppresso)" },
    { "code": "F205", "province": "MI", "name": "MILANO" },
    { "code": "F206", "province": "ME", "name": "MILAZZO" },
    { "code": "E618", "province": "CL", "name": "MILENA" },
    { "code": "F207", "province": "CZ", "name": "MILETO (soppresso)" },
    { "code": "F207", "province": "VV", "name": "MILETO" },
    { "code": "F208", "province": "CA", "name": "MILIS (soppresso)" },
    { "code": "F208", "province": "OR", "name": "MILIS" },
    { "code": "F209", "province": "CT", "name": "MILITELLO IN VAL DI CATANIA" },
    { "code": "F210", "province": "ME", "name": "MILITELLO ROSMARINO" },
    { "code": "F211", "province": "TN", "name": "MILLAN-SARNES (soppresso)" },
    { "code": "F211", "province": "BZ", "name": "MILLAN-SARNES (soppresso)" },
    { "code": "F212", "province": "TO", "name": "MILLAURES (soppresso)" },
    { "code": "F213", "province": "GE", "name": "MILLESIMO (soppresso)" },
    { "code": "F213", "province": "SV", "name": "MILLESIMO" },
    { "code": "F214", "province": "CT", "name": "MILO" },
    { "code": "E618", "province": "CL", "name": "MILOCCA (soppresso)" },
    { "code": "F215", "province": "BS", "name": "MILZANELLO (soppresso)" },
    { "code": "F216", "province": "BS", "name": "MILZANO" },
    { "code": "F217", "province": "CT", "name": "MINEO" },
    { "code": "F218", "province": "VR", "name": "MINERBE" },
    { "code": "F219", "province": "BO", "name": "MINERBIO" },
    { "code": "F221", "province": "LE", "name": "MINERVINO DI LECCE" },
    { "code": "F220", "province": "BA", "name": "MINERVINO MURGE (soppresso)" },
    { "code": "F220", "province": "BT", "name": "MINERVINO MURGE" },
    { "code": "F222", "province": "CO", "name": "MINOPRIO (soppresso)" },
    { "code": "F223", "province": "SA", "name": "MINORI" },
    { "code": "F224", "province": "CE", "name": "MINTURNO (soppresso)" },
    { "code": "F224", "province": "RM", "name": "MINTURNO (soppresso)" },
    { "code": "F224", "province": "LT", "name": "MINTURNO" },
    { "code": "F225", "province": "MS", "name": "MINUCCIANO (soppresso)" },
    { "code": "F225", "province": "LU", "name": "MINUCCIANO" },
    { "code": "F226", "province": "GE", "name": "MIOGLIA (soppresso)" },
    { "code": "F226", "province": "SV", "name": "MIOGLIA" },
    { "code": "F227", "province": "TN", "name": "MIOLA (soppresso)" },
    { "code": "F229", "province": "VE", "name": "MIRA" },
    { "code": "F230", "province": "AV", "name": "MIRABELLA ECLANO" },
    { "code": "F231", "province": "CT", "name": "MIRABELLA IMBACCARI" },
    { "code": "F235", "province": "FE", "name": "MIRABELLO (soppresso)" },
    { "code": "D581", "province": "CO", "name": "MIRABELLO COMASCO (soppresso)" },
    { "code": "F237", "province": "PV", "name": "MIRABELLO ED UNITI DI PAVIA (soppresso)" },
    { "code": "F232", "province": "AL", "name": "MIRABELLO MONFERRATO" },
    { "code": "F233", "province": "CB", "name": "MIRABELLO SANNITICO" },
    { "code": "F238", "province": "PV", "name": "MIRADOLO (soppresso)" },
    { "code": "F238", "province": "PV", "name": "MIRADOLO TERME" },
    { "code": "F239", "province": "CB", "name": "MIRANDA (soppresso)" },
    { "code": "F239", "province": "IS", "name": "MIRANDA" },
    { "code": "F240", "province": "MO", "name": "MIRANDOLA" },
    { "code": "F241", "province": "VE", "name": "MIRANO" },
    { "code": "F242", "province": "ME", "name": "MIRTO" },
    { "code": "F244", "province": "FO", "name": "MISANO ADRIATICO (soppresso)" },
    { "code": "F244", "province": "RN", "name": "MISANO ADRIATICO" },
    { "code": "F243", "province": "BG", "name": "MISANO DI GERA D'ADDA" },
    { "code": "F244", "province": "FO", "name": "MISANO IN VILLA VITTORIA (soppresso)" },
    { "code": "F246", "province": "PA", "name": "MISILMERI" },
    { "code": "F247", "province": "MI", "name": "MISINTO (soppresso)" },
    { "code": "F247", "province": "MB", "name": "MISINTO" },
    { "code": "F248", "province": "CO", "name": "MISSAGLIA (soppresso)" },
    { "code": "F248", "province": "LC", "name": "MISSAGLIA" },
    { "code": "F249", "province": "PZ", "name": "MISSANELLO" },
    { "code": "F250", "province": "CT", "name": "MISTERBIANCO" },
    { "code": "F251", "province": "ME", "name": "MISTRETTA" },
    { "code": "F252", "province": "VR", "name": "MIZZOLE (soppresso)" },
    { "code": "F253", "province": "IM", "name": "MOANO (soppresso)" },
    { "code": "F254", "province": "AL", "name": "MOASCA (soppresso)" },
    { "code": "F254", "province": "AT", "name": "MOASCA" },
    { "code": "F255", "province": "TO", "name": "MOCCHIE (soppresso)" },
    { "code": "F256", "province": "GE", "name": "MOCONESI" },
    { "code": "F257", "province": "MO", "name": "MODENA" },
    { "code": "F258", "province": "SR", "name": "MODICA (soppresso)" },
    { "code": "F258", "province": "RG", "name": "MODICA" },
    { "code": "F259", "province": "FI", "name": "MODIGLIANA (soppresso)" },
    { "code": "F259", "province": "FO", "name": "MODIGLIANA (soppresso)" },
    { "code": "F259", "province": "FC", "name": "MODIGLIANA" },
    { "code": "F261", "province": "CA", "name": "MODOLO (soppresso)" },
    { "code": "F261", "province": "NU", "name": "MODOLO (soppresso)" },
    { "code": "F261", "province": "OR", "name": "MODOLO" },
    { "code": "F262", "province": "BA", "name": "MODUGNO" },
    { "code": "F263", "province": "TN", "name": "MOENA" },
    { "code": "F264", "province": "TN", "name": "MOERNA (soppresso)" },
    { "code": "F265", "province": "CO", "name": "MOGGIO (soppresso)" },
    { "code": "F265", "province": "LC", "name": "MOGGIO" },
    { "code": "F266", "province": "UD", "name": "MOGGIO UDINESE" },
    { "code": "F267", "province": "MN", "name": "MOGLIA" },
    { "code": "F268", "province": "MC", "name": "MOGLIANO" },
    { "code": "F269", "province": "TV", "name": "MOGLIANO VENETO" },
    { "code": "F270", "province": "CA", "name": "MOGORELLA (soppresso)" },
    { "code": "F270", "province": "OR", "name": "MOGORELLA" },
    { "code": "F271", "province": "CA", "name": "MOGORELLA RUINAS (soppresso)" },
    { "code": "F272", "province": "CA", "name": "MOGORO (soppresso)" },
    { "code": "F272", "province": "OR", "name": "MOGORO" },
    { "code": "F273", "province": "CO", "name": "MOIANA (soppresso)" },
    { "code": "F274", "province": "BN", "name": "MOIANO" },
    { "code": "F275", "province": "UD", "name": "MOIMACCO" },
    { "code": "F277", "province": "ME", "name": "MOIO ALCANTARA" },
    { "code": "F276", "province": "BG", "name": "MOIO DE' CALVI" },
    { "code": "F278", "province": "SA", "name": "MOIO DELLA CIVITELLA" },
    { "code": "F279", "province": "CN", "name": "MOIOLA" },
    { "code": "F280", "province": "BA", "name": "MOLA DI BARI" },
    { "code": "F281", "province": "AL", "name": "MOLARE" },
    { "code": "F282", "province": "GE", "name": "MOLASSANA (soppresso)" },
    { "code": "F283", "province": "MS", "name": "MOLAZZANA (soppresso)" },
    { "code": "F283", "province": "LU", "name": "MOLAZZANA" },
    { "code": "F284", "province": "BA", "name": "MOLFETTA" },
    { "code": "F285", "province": "CO", "name": "MOLINA (soppresso)" },
    { "code": "M255", "province": "AQ", "name": "MOLINA ATERNO" },
    { "code": "F286", "province": "TN", "name": "MOLINA DI LEDRO (soppresso)" },
    { "code": "F287", "province": "BN", "name": "MOLINARA" },
    { "code": "F288", "province": "BO", "name": "MOLINELLA" },
    { "code": "F289", "province": "BG", "name": "MOLINI DI COLOGNOLA (soppresso)" },
    { "code": "F290", "province": "IM", "name": "MOLINI DI TRIORA" },
    { "code": "F291", "province": "TN", "name": "MOLINI DI TURES (soppresso)" },
    { "code": "F291", "province": "BZ", "name": "MOLINI DI TURES (soppresso)" },
    { "code": "F292", "province": "AL", "name": "MOLINO ALZANO (soppresso)" },
    { "code": "F293", "province": "AL", "name": "MOLINO DEI TORTI" },
    { "code": "F294", "province": "CB", "name": "MOLISE" },
    { "code": "F295", "province": "PZ", "name": "MOLITERNO" },
    { "code": "F296", "province": "TN", "name": "MOLLARO (soppresso)" },
    { "code": "F297", "province": "NO", "name": "MOLLIA (soppresso)" },
    { "code": "F297", "province": "VC", "name": "MOLLIA" },
    { "code": "F298", "province": "TO", "name": "MOLLIERES (soppresso)" },
    { "code": "F300", "province": "AL", "name": "MOLO DI BORBERA (soppresso)" },
    { "code": "F301", "province": "RC", "name": "MOLOCHIO" },
    { "code": "B947", "province": "BG", "name": "MOLOGNO (soppresso)" },
    { "code": "F303", "province": "IM", "name": "MOLTEDO SUPERIORE (soppresso)" },
    { "code": "F304", "province": "CO", "name": "MOLTENO (soppresso)" },
    { "code": "F304", "province": "LC", "name": "MOLTENO" },
    { "code": "F305", "province": "CO", "name": "MOLTRASIO" },
    { "code": "F306", "province": "VI", "name": "MOLVENA (soppresso)" },
    { "code": "F307", "province": "TN", "name": "MOLVENO" },
    { "code": "F308", "province": "AL", "name": "MOMBALDONE (soppresso)" },
    { "code": "F308", "province": "AT", "name": "MOMBALDONE" },
    { "code": "F309", "province": "CN", "name": "MOMBARCARO" },
    { "code": "F310", "province": "PS", "name": "MOMBAROCCIO (soppresso)" },
    { "code": "F310", "province": "PU", "name": "MOMBAROCCIO" },
    { "code": "F311", "province": "AL", "name": "MOMBARUZZO (soppresso)" },
    { "code": "F311", "province": "AT", "name": "MOMBARUZZO" },
    { "code": "F312", "province": "CN", "name": "MOMBASIGLIO" },
    { "code": "F315", "province": "TO", "name": "MOMBELLO DI TORINO" },
    { "code": "F314", "province": "CO", "name": "MOMBELLO LAGO MAGGIORE (soppresso)" },
    { "code": "F314", "province": "VA", "name": "MOMBELLO LAGO MAGGIORE (soppresso)" },
    { "code": "F313", "province": "AL", "name": "MOMBELLO MONFERRATO" },
    { "code": "F316", "province": "AL", "name": "MOMBERCELLI (soppresso)" },
    { "code": "F316", "province": "AT", "name": "MOMBERCELLI" },
    { "code": "F317", "province": "NO", "name": "MOMO" },
    { "code": "F318", "province": "TO", "name": "MOMPANTERO" },
    { "code": "F319", "province": "PG", "name": "MOMPEO (soppresso)" },
    { "code": "F319", "province": "RM", "name": "MOMPEO (soppresso)" },
    { "code": "F319", "province": "RI", "name": "MOMPEO" },
    { "code": "F320", "province": "AL", "name": "MOMPERONE" },
    { "code": "F322", "province": "CB", "name": "MONACILIONI" },
    { "code": "F323", "province": "AL", "name": "MONALE (soppresso)" },
    { "code": "F323", "province": "AT", "name": "MONALE" },
    { "code": "F324", "province": "RC", "name": "MONASTERACE" },
    { "code": "F325", "province": "AL", "name": "MONASTERO BORMIDA (soppresso)" },
    { "code": "F325", "province": "AT", "name": "MONASTERO BORMIDA" },
    { "code": "F327", "province": "TO", "name": "MONASTERO DI LANZO" },
    { "code": "F326", "province": "CN", "name": "MONASTERO DI VASCO" },
    { "code": "F329", "province": "CN", "name": "MONASTEROLO CASOTTO" },
    { "code": "F329", "province": "CN", "name": "MONASTEROLO CASSOTO (soppresso)" },
    { "code": "F328", "province": "BG", "name": "MONASTEROLO DEL CASTELLO" },
    { "code": "F330", "province": "CN", "name": "MONASTEROLO DI SAVIGLIANO" },
    { "code": "F331", "province": "TO", "name": "MONASTEROLO TORINESE (soppresso)" },
    { "code": "F332", "province": "TV", "name": "MONASTIER DI TREVISO" },
    { "code": "F333", "province": "CA", "name": "MONASTIR (soppresso)" },
    { "code": "F333", "province": "SU", "name": "MONASTIR" },
    { "code": "F334", "province": "CO", "name": "MONATE (soppresso)" },
    { "code": "F334", "province": "VA", "name": "MONATE (soppresso)" },
    { "code": "F335", "province": "TO", "name": "MONCALIERI" },
    { "code": "F336", "province": "AL", "name": "MONCALVO (soppresso)" },
    { "code": "F336", "province": "AT", "name": "MONCALVO" },
    { "code": "D553", "province": "TO", "name": "MONCENISIO" },
    { "code": "F337", "province": "AL", "name": "MONCESTINO" },
    { "code": "F338", "province": "CN", "name": "MONCHIERO" },
    { "code": "F339", "province": "CN", "name": "MONCHIERO NOVELLO (soppresso)" },
    { "code": "F340", "province": "PR", "name": "MONCHIO (soppresso)" },
    { "code": "F340", "province": "PR", "name": "MONCHIO DELLE CORTI" },
    { "code": "F341", "province": "TN", "name": "MONCLASSICO (soppresso)" },
    { "code": "F342", "province": "NO", "name": "MONCRIVELLO (soppresso)" },
    { "code": "F342", "province": "VC", "name": "MONCRIVELLO" },
    { "code": "F343", "province": "AL", "name": "MONCUCCO TORINESE (soppresso)" },
    { "code": "F343", "province": "AT", "name": "MONCUCCO TORINESE" },
    { "code": "F346", "province": "FO", "name": "MONDAINO (soppresso)" },
    { "code": "F346", "province": "RN", "name": "MONDAINO" },
    { "code": "F347", "province": "PS", "name": "MONDAVIO (soppresso)" },
    { "code": "F347", "province": "PU", "name": "MONDAVIO" },
    { "code": "F348", "province": "PS", "name": "MONDOLFO (soppresso)" },
    { "code": "F348", "province": "PU", "name": "MONDOLFO" },
    { "code": "F349", "province": "CO", "name": "MONDONICO (soppresso)" },
    { "code": "F350", "province": "AL", "name": "MONDONIO (soppresso)" },
    { "code": "F351", "province": "CN", "name": "MONDOVI'" },
    { "code": "F352", "province": "CE", "name": "MONDRAGONE" },
    { "code": "F352", "province": "NA", "name": "MONDRAGONE (soppresso)" },
    { "code": "F353", "province": "TO", "name": "MONDRONE (soppresso)" },
    { "code": "F354", "province": "GE", "name": "MONEGLIA" },
    { "code": "F355", "province": "CN", "name": "MONESIGLIO" },
    { "code": "F356", "province": "GO", "name": "MONFALCONE" },
    { "code": "F356", "province": "TS", "name": "MONFALCONE (soppresso)" },
    { "code": "F357", "province": "MO", "name": "MONFESTINO IN SERRAMAZZONI (soppresso)" },
    { "code": "F358", "province": "CN", "name": "MONFORTE D'ALBA" },
    { "code": "F359", "province": "ME", "name": "MONFORTE SAN GIORGIO" },
    { "code": "F360", "province": "TV", "name": "MONFUMO" },
    { "code": "F361", "province": "AL", "name": "MONGARDINO (soppresso)" },
    { "code": "F361", "province": "AT", "name": "MONGARDINO" },
    { "code": "F362", "province": "TN", "name": "MONGHEZZO DI FUORI (soppresso)" },
    { "code": "F362", "province": "BZ", "name": "MONGHEZZO DI FUORI (soppresso)" },
    { "code": "F362", "province": "TN", "name": "MONGHEZZO ESTERNO (soppresso)" },
    { "code": "F363", "province": "BO", "name": "MONGHIDORO" },
    { "code": "F364", "province": "CZ", "name": "MONGIANA (soppresso)" },
    { "code": "F364", "province": "VV", "name": "MONGIANA" },
    { "code": "F365", "province": "AL", "name": "MONGIARDINO LIGURE" },
    { "code": "F367", "province": "AO", "name": "MONGIOVE (soppresso)" },
    { "code": "F368", "province": "ME", "name": "MONGIUFFI MELIA" },
    { "code": "F369", "province": "NO", "name": "MONGRANDO (soppresso)" },
    { "code": "F369", "province": "VC", "name": "MONGRANDO (soppresso)" },
    { "code": "F369", "province": "BI", "name": "MONGRANDO" },
    { "code": "F370", "province": "CS", "name": "MONGRASSANO" },
    { "code": "F371", "province": "TN", "name": "MONGUELFO (soppresso)" },
    { "code": "F371", "province": "BZ", "name": "MONGUELFO (soppresso)" },
    { "code": "F371", "province": "BZ", "name": "MONGUELFO-TESIDO" },
    { "code": "F372", "province": "CO", "name": "MONGUZZO" },
    { "code": "F373", "province": "BS", "name": "MONIGA (soppresso)" },
    { "code": "F373", "province": "BS", "name": "MONIGA DEL GARDA" },
    { "code": "F374", "province": "AL", "name": "MONLEALE" },
    { "code": "F375", "province": "BS", "name": "MONNO" },
    { "code": "F376", "province": "BA", "name": "MONOPOLI" },
    { "code": "F377", "province": "PA", "name": "MONREALE" },
    { "code": "F378", "province": "TS", "name": "MONRUPINO" },
    { "code": "F379", "province": "AP", "name": "MONSAMPIETRO MORICO (soppresso)" },
    { "code": "F379", "province": "FM", "name": "MONSAMPIETRO MORICO" },
    { "code": "F380", "province": "AP", "name": "MONSAMPOLO DEL TRONTO" },
    { "code": "F381", "province": "AN", "name": "MONSANO" },
    { "code": "F382", "province": "PD", "name": "MONSELICE" },
    { "code": "F383", "province": "CA", "name": "MONSERRATO" },
    { "code": "F384", "province": "LU", "name": "MONSUMMANO (soppresso)" },
    { "code": "F384", "province": "PT", "name": "MONSUMMANO (soppresso)" },
    { "code": "F384", "province": "PT", "name": "MONSUMMANO TERME" },
    { "code": "F385", "province": "CN", "name": "MONTA'" },
    { "code": "F386", "province": "AL", "name": "MONTABONE (soppresso)" },
    { "code": "F386", "province": "AT", "name": "MONTABONE" },
    { "code": "F387", "province": "AL", "name": "MONTACUTO" },
    { "code": "F390", "province": "AL", "name": "MONTAFIA (soppresso)" },
    { "code": "F390", "province": "AT", "name": "MONTAFIA" },
    { "code": "F391", "province": "CB", "name": "MONTAGANO" },
    { "code": "F393", "province": "SO", "name": "MONTAGNA (soppresso)" },
    { "code": "F392", "province": "TN", "name": "MONTAGNA (soppresso)" },
    { "code": "F392", "province": "BZ", "name": "MONTAGNA" },
    { "code": "F393", "province": "SO", "name": "MONTAGNA IN VALTELLINA" },
    { "code": "F394", "province": "PD", "name": "MONTAGNANA" },
    { "code": "F395", "province": "ME", "name": "MONTAGNAREALE" },
    { "code": "F396", "province": "TN", "name": "MONTAGNE (soppresso)" },
    { "code": "F397", "province": "AV", "name": "MONTAGUTO" },
    { "code": "F398", "province": "FI", "name": "MONTAIONE" },
    { "code": "F400", "province": "ME", "name": "MONTALBANO DI ELICONA (soppresso)" },
    { "code": "F400", "province": "ME", "name": "MONTALBANO ELICONA" },
    { "code": "F399", "province": "PZ", "name": "MONTALBANO JONICO (soppresso)" },
    { "code": "F399", "province": "MT", "name": "MONTALBANO JONICO" },
    { "code": "F402", "province": "SI", "name": "MONTALCINO (soppresso)" },
    { "code": "M378", "province": "SI", "name": "MONTALCINO" },
    { "code": "F403", "province": "AL", "name": "MONTALDEO" },
    { "code": "F404", "province": "AL", "name": "MONTALDO BORMIDA" },
    { "code": "F405", "province": "CN", "name": "MONTALDO DI MONDOVI'" },
    { "code": "F408", "province": "CN", "name": "MONTALDO ROERO" },
    { "code": "F409", "province": "AL", "name": "MONTALDO SCARAMPI (soppresso)" },
    { "code": "F409", "province": "AT", "name": "MONTALDO SCARAMPI" },
    { "code": "F407", "province": "TO", "name": "MONTALDO TORINESE" },
    { "code": "F410", "province": "FI", "name": "MONTALE (soppresso)" },
    { "code": "F410", "province": "PT", "name": "MONTALE" },
    { "code": "E895", "province": "TN", "name": "MONTALE IN PUSTERIA (soppresso)" },
    { "code": "F411", "province": "TO", "name": "MONTALENGHE" },
    { "code": "F411", "province": "AO", "name": "MONTALENGHE (soppresso)" },
    { "code": "F412", "province": "AL", "name": "MONTALERO (soppresso)" },
    { "code": "F414", "province": "AG", "name": "MONTALLEGRO" },
    { "code": "M387", "province": "IM", "name": "MONTALTO CARPASIO" },
    { "code": "F415", "province": "AP", "name": "MONTALTO DELLE MARCHE" },
    { "code": "F419", "province": "RM", "name": "MONTALTO DI CASTRO (soppresso)" },
    { "code": "F419", "province": "VT", "name": "MONTALTO DI CASTRO" },
    { "code": "F420", "province": "TO", "name": "MONTALTO DORA" },
    { "code": "F420", "province": "AO", "name": "MONTALTO DORA (soppresso)" },
    { "code": "F406", "province": "IM", "name": "MONTALTO LIGURE (soppresso)" },
    { "code": "F417", "province": "PV", "name": "MONTALTO PAVESE" },
    { "code": "F416", "province": "CS", "name": "MONTALTO UFFUGO" },
    { "code": "F422", "province": "TO", "name": "MONTANARO" },
    { "code": "F423", "province": "MI", "name": "MONTANASO LOMBARDO (soppresso)" },
    { "code": "F423", "province": "LO", "name": "MONTANASO LOMBARDO" },
    { "code": "F424", "province": "CN", "name": "MONTANERA" },
    { "code": "F426", "province": "SA", "name": "MONTANO ANTILIA" },
    { "code": "F425", "province": "CO", "name": "MONTANO COMASCO (soppresso)" },
    { "code": "F427", "province": "CO", "name": "MONTANO LUCINO" },
    { "code": "F428", "province": "AP", "name": "MONTAPPONE (soppresso)" },
    { "code": "F428", "province": "FM", "name": "MONTAPPONE" },
    { "code": "F429", "province": "CB", "name": "MONTAQUILA (soppresso)" },
    { "code": "F429", "province": "IS", "name": "MONTAQUILA" },
    { "code": "F430", "province": "PG", "name": "MONTASOLA (soppresso)" },
    { "code": "F430", "province": "RM", "name": "MONTASOLA (soppresso)" },
    { "code": "F430", "province": "RI", "name": "MONTASOLA" },
    { "code": "F431", "province": "TN", "name": "MONTASSILO (soppresso)" },
    { "code": "F431", "province": "TN", "name": "MONTASSILONE (soppresso)" },
    { "code": "F431", "province": "BZ", "name": "MONTASSILONE (soppresso)" },
    { "code": "F432", "province": "CZ", "name": "MONTAURO" },
    { "code": "F433", "province": "CH", "name": "MONTAZZOLI" },
    { "code": "F436", "province": "TN", "name": "MONTE A MEZZODI' (soppresso)" },
    { "code": "F438", "province": "TN", "name": "MONTE A TRAMONTANA (soppresso)" },
    { "code": "F400", "province": "ME", "name": "MONTE ALBANO (soppresso)" },
    { "code": "F437", "province": "GR", "name": "MONTE ARGENTARIO" },
    { "code": "F456", "province": "PG", "name": "MONTE CASTELLO DI VIBIO" },
    { "code": "F460", "province": "MC", "name": "MONTE CAVALLO" },
    { "code": "F467", "province": "PS", "name": "MONTE CERIGNONE (soppresso)" },
    { "code": "F467", "province": "PU", "name": "MONTE CERIGNONE" },
    { "code": "ND", "province": "PL", "name": "MONTE CHILOVI (soppresso)" },
    { "code": "ND", "province": "FU", "name": "MONTE CHILOVI (soppresso)" },
    { "code": "F476", "province": "FO", "name": "MONTE COLOMBO (soppresso)" },
    { "code": "F476", "province": "RN", "name": "MONTE COLOMBO (soppresso)" },
    { "code": "F477", "province": "RM", "name": "MONTE COMPATRI" },
    { "code": "F434", "province": "CR", "name": "MONTE CREMASCO" },
    { "code": "F485", "province": "PL", "name": "MONTE DI CAPODISTRIA (soppresso)" },
    { "code": "F486", "province": "VI", "name": "MONTE DI MALO" },
    { "code": "F436", "province": "TN", "name": "MONTE DI MEZZODI' (soppresso)" },
    { "code": "F436", "province": "BZ", "name": "MONTE DI MEZZODI' (soppresso)" },
    { "code": "F488", "province": "NA", "name": "MONTE DI PROCIDA" },
    { "code": "F438", "province": "TN", "name": "MONTE DI TRAMONTANA (soppresso)" },
    { "code": "F438", "province": "BZ", "name": "MONTE DI TRAMONTANA (soppresso)" },
    { "code": "F517", "province": "AP", "name": "MONTE GIBERTO (soppresso)" },
    { "code": "F517", "province": "FM", "name": "MONTE GIBERTO" },
    { "code": "F524", "province": "PS", "name": "MONTE GRIMANO (soppresso)" },
    { "code": "F524", "province": "PU", "name": "MONTE GRIMANO (soppresso)" },
    { "code": "F524", "province": "PU", "name": "MONTE GRIMANO TERME" },
    { "code": "F532", "province": "BS", "name": "MONTE ISOLA" },
    { "code": "F561", "province": "BG", "name": "MONTE MARENZO (soppresso)" },
    { "code": "F561", "province": "LC", "name": "MONTE MARENZO" },
    { "code": "F584", "province": "NO", "name": "MONTE OSSOLANO (soppresso)" },
    { "code": "F589", "province": "PS", "name": "MONTE PORZIO (soppresso)" },
    { "code": "F589", "province": "PU", "name": "MONTE PORZIO" },
    { "code": "F590", "province": "RM", "name": "MONTE PORZIO CATONE" },
    { "code": "F599", "province": "AP", "name": "MONTE RINALDO (soppresso)" },
    { "code": "F599", "province": "FM", "name": "MONTE RINALDO" },
    { "code": "F600", "province": "AN", "name": "MONTE ROBERTO" },
    { "code": "F603", "province": "RM", "name": "MONTE ROMANO (soppresso)" },
    { "code": "F603", "province": "VT", "name": "MONTE ROMANO" },
    { "code": "F616", "province": "CE", "name": "MONTE SAN BIAGIO (soppresso)" },
    { "code": "F616", "province": "RM", "name": "MONTE SAN BIAGIO (soppresso)" },
    { "code": "F616", "province": "LT", "name": "MONTE SAN BIAGIO" },
    { "code": "F617", "province": "TN", "name": "MONTE SAN CANDIDO (soppresso)" },
    { "code": "F617", "province": "BZ", "name": "MONTE SAN CANDIDO (soppresso)" },
    { "code": "F618", "province": "SA", "name": "MONTE SAN GIACOMO" },
    { "code": "F620", "province": "RM", "name": "MONTE SAN GIOVANNI CAMPANO (soppresso)" },
    { "code": "F620", "province": "FR", "name": "MONTE SAN GIOVANNI CAMPANO" },
    { "code": "F619", "province": "PG", "name": "MONTE SAN GIOVANNI IN SABINA (soppresso)" },
    { "code": "F619", "province": "RM", "name": "MONTE SAN GIOVANNI IN SABINA (soppresso)" },
    { "code": "F619", "province": "RI", "name": "MONTE SAN GIOVANNI IN SABINA" },
    { "code": "D423", "province": "TP", "name": "MONTE SAN GIULIANO (soppresso)" },
    { "code": "F621", "province": "MC", "name": "MONTE SAN GIUSTO" },
    { "code": "F622", "province": "MC", "name": "MONTE SAN MARTINO" },
    { "code": "F626", "province": "AP", "name": "MONTE SAN PIETRANGELI (soppresso)" },
    { "code": "F626", "province": "FM", "name": "MONTE SAN PIETRANGELI" },
    { "code": "F627", "province": "BO", "name": "MONTE SAN PIETRO" },
    { "code": "F628", "province": "AR", "name": "MONTE SAN SAVINO" },
    { "code": "F634", "province": "AN", "name": "MONTE SAN VITO" },
    { "code": "F635", "province": "UD", "name": "MONTE SAN VITO (soppresso)" },
    { "code": "F635", "province": "GO", "name": "MONTE SAN VITO (soppresso)" },
    { "code": "F629", "province": "AR", "name": "MONTE SANTA MARIA TIBERINA (soppresso)" },
    { "code": "F629", "province": "PG", "name": "MONTE SANTA MARIA TIBERINA" },
    { "code": "F631", "province": "FG", "name": "MONTE SANT'ANGELO" },
    { "code": "F652", "province": "UD", "name": "MONTE URABICE (soppresso)" },
    { "code": "F652", "province": "GO", "name": "MONTE URABICE (soppresso)" },
    { "code": "F653", "province": "AP", "name": "MONTE URANO (soppresso)" },
    { "code": "F653", "province": "FM", "name": "MONTE URANO" },
    { "code": "F664", "province": "AP", "name": "MONTE VIDON COMBATTE (soppresso)" },
    { "code": "F664", "province": "FM", "name": "MONTE VIDON COMBATTE" },
    { "code": "F665", "province": "AP", "name": "MONTE VIDON CORRADO (soppresso)" },
    { "code": "F665", "province": "FM", "name": "MONTE VIDON CORRADO" },
    { "code": "F440", "province": "PV", "name": "MONTEBELLO (soppresso)" },
    { "code": "F440", "province": "PV", "name": "MONTEBELLO DELLA BATTAGLIA" },
    { "code": "F441", "province": "TE", "name": "MONTEBELLO DI BERTONA (soppresso)" },
    { "code": "F441", "province": "PE", "name": "MONTEBELLO DI BERTONA" },
    { "code": "D746", "province": "RC", "name": "MONTEBELLO JONICO" },
    { "code": "B268", "province": "CH", "name": "MONTEBELLO SUL SANGRO" },
    { "code": "F442", "province": "VI", "name": "MONTEBELLO VICENTINO" },
    { "code": "F443", "province": "TV", "name": "MONTEBELLUNA" },
    { "code": "F445", "province": "GE", "name": "MONTEBRUNO" },
    { "code": "F446", "province": "PG", "name": "MONTEBUONO (soppresso)" },
    { "code": "F446", "province": "RM", "name": "MONTEBUONO (soppresso)" },
    { "code": "F446", "province": "RI", "name": "MONTEBUONO" },
    { "code": "F450", "province": "PS", "name": "MONTECALVO IN FOGLIA (soppresso)" },
    { "code": "F450", "province": "PU", "name": "MONTECALVO IN FOGLIA" },
    { "code": "F448", "province": "AV", "name": "MONTECALVO IRPINO" },
    { "code": "F449", "province": "PV", "name": "MONTECALVO VERSIGGIA" },
    { "code": "F452", "province": "LU", "name": "MONTECARLO" },
    { "code": "F453", "province": "AN", "name": "MONTECAROTTO" },
    { "code": "F454", "province": "MC", "name": "MONTECASSIANO" },
    { "code": "F455", "province": "AL", "name": "MONTECASTELLO" },
    { "code": "F457", "province": "PG", "name": "MONTECASTRILLI (soppresso)" },
    { "code": "F457", "province": "TR", "name": "MONTECASTRILLI" },
    { "code": "F459", "province": "LU", "name": "MONTECATINI DI VAL DI NIEVOLE (soppresso)" },
    { "code": "F459", "province": "PT", "name": "MONTECATINI DI VAL DI NIEVOLE (soppresso)" },
    { "code": "F458", "province": "PI", "name": "MONTECATINI VAL DI CECINA" },
    { "code": "A561", "province": "PT", "name": "MONTECATINI-TERME" },
    { "code": "F461", "province": "VR", "name": "MONTECCHIA DI CROSARA" },
    { "code": "F462", "province": "TR", "name": "MONTECCHIO" },
    { "code": "F463", "province": "RE", "name": "MONTECCHIO EMILIA" },
    { "code": "F464", "province": "VI", "name": "MONTECCHIO MAGGIORE" },
    { "code": "F465", "province": "VI", "name": "MONTECCHIO PRECALCINO" },
    { "code": "F466", "province": "RM", "name": "MONTECELIO (soppresso)" },
    { "code": "F470", "province": "TN", "name": "MONTECHIARO (soppresso)" },
    { "code": "F470", "province": "BZ", "name": "MONTECHIARO (soppresso)" },
    { "code": "F469", "province": "AL", "name": "MONTECHIARO D'ACQUI" },
    { "code": "F468", "province": "AL", "name": "MONTECHIARO D'ASTI (soppresso)" },
    { "code": "F468", "province": "AT", "name": "MONTECHIARO D'ASTI" },
    { "code": "F472", "province": "AL", "name": "MONTECHIARO DENICE (soppresso)" },
    { "code": "F473", "province": "PR", "name": "MONTECHIARUGOLO" },
    { "code": "F474", "province": "PS", "name": "MONTECICCARDO (soppresso)" },
    { "code": "F474", "province": "PU", "name": "MONTECICCARDO" },
    { "code": "F475", "province": "CB", "name": "MONTECILFONE" },
    { "code": "F478", "province": "PS", "name": "MONTECOPIOLO (soppresso)" },
    { "code": "F478", "province": "PU", "name": "MONTECOPIOLO" },
    { "code": "F479", "province": "SA", "name": "MONTECORICE" },
    { "code": "F480", "province": "SA", "name": "MONTECORVINO PUGLIANO" },
    { "code": "F481", "province": "SA", "name": "MONTECORVINO ROVELLA" },
    { "code": "F482", "province": "MC", "name": "MONTECOSARO" },
    { "code": "F483", "province": "NO", "name": "MONTECRESTESE (soppresso)" },
    { "code": "F483", "province": "VB", "name": "MONTECRESTESE" },
    { "code": "F484", "province": "MO", "name": "MONTECRETO" },
    { "code": "F487", "province": "AP", "name": "MONTEDINOVE" },
    { "code": "F489", "province": "CL", "name": "MONTEDORO" },
    { "code": "F491", "province": "AV", "name": "MONTEFALCIONE" },
    { "code": "F492", "province": "PG", "name": "MONTEFALCO" },
    { "code": "F493", "province": "AP", "name": "MONTEFALCONE APPENNINO (soppresso)" },
    { "code": "F493", "province": "FM", "name": "MONTEFALCONE APPENNINO" },
    { "code": "F494", "province": "BN", "name": "MONTEFALCONE DI VAL FORTORE" },
    { "code": "F495", "province": "CB", "name": "MONTEFALCONE NEL SANNIO" },
    { "code": "F496", "province": "MC", "name": "MONTEFANO" },
    { "code": "F497", "province": "PS", "name": "MONTEFELCINO (soppresso)" },
    { "code": "F497", "province": "PU", "name": "MONTEFELCINO" },
    { "code": "F498", "province": "CH", "name": "MONTEFERRANTE" },
    { "code": "F499", "province": "RM", "name": "MONTEFIASCONE (soppresso)" },
    { "code": "F499", "province": "VT", "name": "MONTEFIASCONE" },
    { "code": "F500", "province": "TE", "name": "MONTEFINO" },
    { "code": "F502", "province": "FO", "name": "MONTEFIORE CONCA (soppresso)" },
    { "code": "F502", "province": "RN", "name": "MONTEFIORE CONCA" },
    { "code": "F501", "province": "AP", "name": "MONTEFIORE DELL'ASO" },
    { "code": "F503", "province": "MO", "name": "MONTEFIORINO" },
    { "code": "F502", "province": "FO", "name": "MONTEFIORITO (soppresso)" },
    { "code": "F504", "province": "RM", "name": "MONTEFLAVIO" },
    { "code": "F505", "province": "TN", "name": "MONTEFONTANA (soppresso)" },
    { "code": "F505", "province": "BZ", "name": "MONTEFONTANA (soppresso)" },
    { "code": "F507", "province": "SA", "name": "MONTEFORTE CILENTO" },
    { "code": "F508", "province": "VR", "name": "MONTEFORTE D'ALPONE" },
    { "code": "F506", "province": "AV", "name": "MONTEFORTE IRPINO" },
    { "code": "F509", "province": "AP", "name": "MONTEFORTINO (soppresso)" },
    { "code": "F509", "province": "FM", "name": "MONTEFORTINO" },
    { "code": "F510", "province": "PG", "name": "MONTEFRANCO (soppresso)" },
    { "code": "F510", "province": "TR", "name": "MONTEFRANCO" },
    { "code": "F511", "province": "AV", "name": "MONTEFREDANE" },
    { "code": "ND", "province": "FU", "name": "MONTEFREDDO (soppresso)" },
    { "code": "ND", "province": "PL", "name": "MONTEFREDDO (soppresso)" },
    { "code": "F512", "province": "AV", "name": "MONTEFUSCO" },
    { "code": "F513", "province": "PG", "name": "MONTEGABBIONE (soppresso)" },
    { "code": "F513", "province": "TR", "name": "MONTEGABBIONE" },
    { "code": "F514", "province": "VI", "name": "MONTEGALDA" },
    { "code": "F515", "province": "VI", "name": "MONTEGALDELLA" },
    { "code": "F516", "province": "AP", "name": "MONTEGALLO" },
    { "code": "F518", "province": "AL", "name": "MONTEGIOCO" },
    { "code": "F519", "province": "CS", "name": "MONTEGIORDANO" },
    { "code": "F520", "province": "AP", "name": "MONTEGIORGIO (soppresso)" },
    { "code": "F520", "province": "FM", "name": "MONTEGIORGIO" },
    { "code": "F522", "province": "AP", "name": "MONTEGRANARO (soppresso)" },
    { "code": "F522", "province": "FM", "name": "MONTEGRANARO" },
    { "code": "F302", "province": "IM", "name": "MONTEGRAZIE (soppresso)" },
    { "code": "F523", "province": "FO", "name": "MONTEGRIDOLFO (soppresso)" },
    { "code": "F523", "province": "RN", "name": "MONTEGRIDOLFO" },
    { "code": "F525", "province": "CO", "name": "MONTEGRINO (soppresso)" },
    { "code": "F525", "province": "VA", "name": "MONTEGRINO (soppresso)" },
    { "code": "F526", "province": "VA", "name": "MONTEGRINO VALTRAVAGLIA" },
    { "code": "F527", "province": "AL", "name": "MONTEGROSSO D'ASTI (soppresso)" },
    { "code": "F527", "province": "AT", "name": "MONTEGROSSO D'ASTI" },
    { "code": "F528", "province": "IM", "name": "MONTEGROSSO PIAN LATTE" },
    { "code": "F529", "province": "PD", "name": "MONTEGROTTO TERME" },
    { "code": "F531", "province": "LE", "name": "MONTEIASI (soppresso)" },
    { "code": "F531", "province": "TA", "name": "MONTEIASI" },
    { "code": "F533", "province": "PS", "name": "MONTELABBATE (soppresso)" },
    { "code": "F533", "province": "PU", "name": "MONTELABBATE" },
    { "code": "F534", "province": "RM", "name": "MONTELANICO" },
    { "code": "F535", "province": "CH", "name": "MONTELAPIANO" },
    { "code": "F537", "province": "CZ", "name": "MONTELEONE DI CALABRIA (soppresso)" },
    { "code": "F536", "province": "AP", "name": "MONTELEONE DI FERMO (soppresso)" },
    { "code": "F536", "province": "FM", "name": "MONTELEONE DI FERMO" },
    { "code": "F538", "province": "AV", "name": "MONTELEONE DI PUGLIA (soppresso)" },
    { "code": "F538", "province": "FG", "name": "MONTELEONE DI PUGLIA" },
    { "code": "F540", "province": "PG", "name": "MONTELEONE DI SPOLETO" },
    { "code": "F543", "province": "PG", "name": "MONTELEONE D'ORVIETO (soppresso)" },
    { "code": "F543", "province": "TR", "name": "MONTELEONE D'ORVIETO" },
    { "code": "F542", "province": "SS", "name": "MONTELEONE ROCCA DORIA" },
    { "code": "F541", "province": "PG", "name": "MONTELEONE SABINO (soppresso)" },
    { "code": "F541", "province": "RM", "name": "MONTELEONE SABINO (soppresso)" },
    { "code": "F541", "province": "RI", "name": "MONTELEONE SABINO" },
    { "code": "F544", "province": "PA", "name": "MONTELEPRE" },
    { "code": "F545", "province": "RM", "name": "MONTELIBRETTI" },
    { "code": "F546", "province": "AV", "name": "MONTELLA" },
    { "code": "F547", "province": "BG", "name": "MONTELLO" },
    { "code": "F548", "province": "CB", "name": "MONTELONGO" },
    { "code": "F549", "province": "AP", "name": "MONTELPARO (soppresso)" },
    { "code": "F549", "province": "FM", "name": "MONTELPARO" },
    { "code": "F550", "province": "CN", "name": "MONTELUPO ALBESE" },
    { "code": "F551", "province": "FI", "name": "MONTELUPO FIORENTINO" },
    { "code": "F552", "province": "MC", "name": "MONTELUPONE" },
    { "code": "F555", "province": "PS", "name": "MONTEMAGGIORE AL METAURO (soppresso)" },
    { "code": "F555", "province": "PU", "name": "MONTEMAGGIORE AL METAURO (soppresso)" },
    { "code": "F553", "province": "PA", "name": "MONTEMAGGIORE BELSITO" },
    { "code": "F556", "province": "AL", "name": "MONTEMAGNO (soppresso)" },
    { "code": "F556", "province": "AT", "name": "MONTEMAGNO" },
    { "code": "F558", "province": "CN", "name": "MONTEMALE DI CUNEO" },
    { "code": "F559", "province": "AV", "name": "MONTEMARANO" },
    { "code": "F560", "province": "AN", "name": "MONTEMARCIANO" },
    { "code": "F562", "province": "AL", "name": "MONTEMARZINO" },
    { "code": "F563", "province": "LE", "name": "MONTEMESOLA (soppresso)" },
    { "code": "F563", "province": "TA", "name": "MONTEMESOLA" },
    { "code": "F564", "province": "CO", "name": "MONTEMEZZO" },
    { "code": "F565", "province": "AR", "name": "MONTEMIGNAIO" },
    { "code": "F566", "province": "AV", "name": "MONTEMILETTO" },
    { "code": "F568", "province": "PZ", "name": "MONTEMILONE" },
    { "code": "F569", "province": "CB", "name": "MONTEMITRO" },
    { "code": "F570", "province": "AP", "name": "MONTEMONACO" },
    { "code": "F572", "province": "FI", "name": "MONTEMURLO (soppresso)" },
    { "code": "F572", "province": "PO", "name": "MONTEMURLO" },
    { "code": "F573", "province": "PZ", "name": "MONTEMURRO" },
    { "code": "F574", "province": "UD", "name": "MONTENARS" },
    { "code": "F576", "province": "CB", "name": "MONTENERO DI BISACCIA" },
    { "code": "F577", "province": "GO", "name": "MONTENERO D'IDRIA (soppresso)" },
    { "code": "F577", "province": "UD", "name": "MONTENERO D'IDRIA (soppresso)" },
    { "code": "F579", "province": "PG", "name": "MONTENERO SABINO (soppresso)" },
    { "code": "F579", "province": "RM", "name": "MONTENERO SABINO (soppresso)" },
    { "code": "F579", "province": "RI", "name": "MONTENERO SABINO" },
    { "code": "F580", "province": "CB", "name": "MONTENERO VAL COCCHIARA (soppresso)" },
    { "code": "F580", "province": "IS", "name": "MONTENERO VAL COCCHIARA" },
    { "code": "F578", "province": "CH", "name": "MONTENERODOMO" },
    { "code": "F582", "province": "CH", "name": "MONTEODORISIO" },
    { "code": "F585", "province": "TE", "name": "MONTEPAGANO (soppresso)" },
    { "code": "F586", "province": "CZ", "name": "MONTEPAONE" },
    { "code": "F587", "province": "LE", "name": "MONTEPARANO (soppresso)" },
    { "code": "F587", "province": "TA", "name": "MONTEPARANO" },
    { "code": "F588", "province": "TN", "name": "MONTEPONENTE (soppresso)" },
    { "code": "F588", "province": "BZ", "name": "MONTEPONENTE (soppresso)" },
    { "code": "F591", "province": "AP", "name": "MONTEPRANDONE" },
    { "code": "F592", "province": "SI", "name": "MONTEPULCIANO" },
    { "code": "F593", "province": "AN", "name": "MONTERADO (soppresso)" },
    { "code": "F594", "province": "AR", "name": "MONTERCHI" },
    { "code": "F594", "province": "PG", "name": "MONTERCHI (soppresso)" },
    { "code": "F595", "province": "AQ", "name": "MONTEREALE" },
    { "code": "F596", "province": "UD", "name": "MONTEREALE CELLINA (soppresso)" },
    { "code": "F596", "province": "UD", "name": "MONTEREALE VALCELLINA (soppresso)" },
    { "code": "F596", "province": "PN", "name": "MONTEREALE VALCELLINA" },
    { "code": "F597", "province": "BO", "name": "MONTERENZIO" },
    { "code": "F598", "province": "SI", "name": "MONTERIGGIONI" },
    { "code": "F601", "province": "CB", "name": "MONTERODUNI (soppresso)" },
    { "code": "F601", "province": "IS", "name": "MONTERODUNI" },
    { "code": "F605", "province": "SI", "name": "MONTERONI D'ARBIA" },
    { "code": "F604", "province": "LE", "name": "MONTERONI DI LECCE" },
    { "code": "F606", "province": "RM", "name": "MONTEROSI (soppresso)" },
    { "code": "F606", "province": "VT", "name": "MONTEROSI" },
    { "code": "F609", "province": "GE", "name": "MONTEROSSO AL MARE (soppresso)" },
    { "code": "F609", "province": "SP", "name": "MONTEROSSO AL MARE" },
    { "code": "F610", "province": "SR", "name": "MONTEROSSO ALMO (soppresso)" },
    { "code": "F610", "province": "RG", "name": "MONTEROSSO ALMO" },
    { "code": "F607", "province": "CZ", "name": "MONTEROSSO CALABRO (soppresso)" },
    { "code": "F607", "province": "VV", "name": "MONTEROSSO CALABRO" },
    { "code": "F608", "province": "CN", "name": "MONTEROSSO GRANA" },
    { "code": "F611", "province": "RM", "name": "MONTEROTONDO" },
    { "code": "F612", "province": "GR", "name": "MONTEROTONDO MARITTIMO" },
    { "code": "F614", "province": "AP", "name": "MONTERUBBIANO (soppresso)" },
    { "code": "F614", "province": "FM", "name": "MONTERUBBIANO" },
    { "code": "F615", "province": "TN", "name": "MONTES (soppresso)" },
    { "code": "F623", "province": "LE", "name": "MONTESANO SALENTINO" },
    { "code": "F625", "province": "SA", "name": "MONTESANO SULLA MARCELLANA" },
    { "code": "F633", "province": "PG", "name": "MONTESANTO (soppresso)" },
    { "code": "F633", "province": "PG", "name": "MONTESANTO VIEZI (soppresso)" },
    { "code": "F633", "province": "PG", "name": "MONTESANTO VIGI (soppresso)" },
    { "code": "F636", "province": "BN", "name": "MONTESARCHIO" },
    { "code": "F637", "province": "PZ", "name": "MONTESCAGLIOSO (soppresso)" },
    { "code": "F637", "province": "MT", "name": "MONTESCAGLIOSO" },
    { "code": "F638", "province": "PV", "name": "MONTESCANO" },
    { "code": "F639", "province": "NO", "name": "MONTESCHENO (soppresso)" },
    { "code": "F639", "province": "VB", "name": "MONTESCHENO" },
    { "code": "F640", "province": "PI", "name": "MONTESCUDAIO" },
    { "code": "F641", "province": "FO", "name": "MONTESCUDO (soppresso)" },
    { "code": "F641", "province": "RN", "name": "MONTESCUDO (soppresso)" },
    { "code": "M368", "province": "RN", "name": "MONTESCUDO-MONTE COLOMBO" },
    { "code": "F642", "province": "MO", "name": "MONTESE" },
    { "code": "F644", "province": "PV", "name": "MONTESEGALE" },
    { "code": "F645", "province": "AN", "name": "MONTESICURO (soppresso)" },
    { "code": "F646", "province": "TE", "name": "MONTESILVANO (soppresso)" },
    { "code": "F646", "province": "PE", "name": "MONTESILVANO" },
    { "code": "F647", "province": "TE", "name": "MONTESILVANO MARINA (soppresso)" },
    { "code": "F647", "province": "PE", "name": "MONTESILVANO MARINA (soppresso)" },
    { "code": "F648", "province": "FI", "name": "MONTESPERTOLI" },
    { "code": "F649", "province": "UD", "name": "MONTESPINO (soppresso)" },
    { "code": "F649", "province": "GO", "name": "MONTESPINO (soppresso)" },
    { "code": "F650", "province": "TO", "name": "MONTESTRUTTO (soppresso)" },
    { "code": "F650", "province": "AO", "name": "MONTESTRUTTO (soppresso)" },
    { "code": "F651", "province": "TO", "name": "MONTEU DA PO" },
    { "code": "F654", "province": "CN", "name": "MONTEU ROERO" },
    { "code": "F655", "province": "AG", "name": "MONTEVAGO" },
    { "code": "F656", "province": "AR", "name": "MONTEVARCHI" },
    { "code": "F657", "province": "CO", "name": "MONTEVECCHIA (soppresso)" },
    { "code": "F657", "province": "LC", "name": "MONTEVECCHIA" },
    { "code": "F659", "province": "BO", "name": "MONTEVEGLIO (soppresso)" },
    { "code": "F660", "province": "AV", "name": "MONTEVERDE" },
    { "code": "F661", "province": "PI", "name": "MONTEVERDI (soppresso)" },
    { "code": "F661", "province": "PI", "name": "MONTEVERDI MARITTIMO" },
    { "code": "F662", "province": "VI", "name": "MONTEVIALE" },
    { "code": "F663", "province": "CO", "name": "MONTEVIASCO (soppresso)" },
    { "code": "F663", "province": "VA", "name": "MONTEVIASCO (soppresso)" },
    { "code": "F666", "province": "CN", "name": "MONTEZEMOLO" },
    { "code": "F667", "province": "SS", "name": "MONTI" },
    { "code": "F667", "province": "OT", "name": "MONTI (soppresso)" },
    { "code": "F668", "province": "FO", "name": "MONTIANO (soppresso)" },
    { "code": "F668", "province": "FC", "name": "MONTIANO" },
    { "code": "F672", "province": "BS", "name": "MONTICELLI BRUSATI" },
    { "code": "F547", "province": "BG", "name": "MONTICELLI DI BORGOGNA (soppresso)" },
    { "code": "F671", "province": "PC", "name": "MONTICELLI D'ONGINA" },
    { "code": "F670", "province": "PV", "name": "MONTICELLI PAVESE" },
    { "code": "F674", "province": "CO", "name": "MONTICELLO BRIANZA (soppresso)" },
    { "code": "F674", "province": "LC", "name": "MONTICELLO BRIANZA" },
    { "code": "F675", "province": "VI", "name": "MONTICELLO CONTE OTTO" },
    { "code": "F669", "province": "CN", "name": "MONTICELLO D'ALBA" },
    { "code": "F471", "province": "BS", "name": "MONTICHIARI" },
    { "code": "F676", "province": "SI", "name": "MONTICIANO" },
    { "code": "F677", "province": "GR", "name": "MONTIERI" },
    { "code": "F678", "province": "AL", "name": "MONTIGLIO (soppresso)" },
    { "code": "F678", "province": "AT", "name": "MONTIGLIO (soppresso)" },
    { "code": "M302", "province": "AT", "name": "MONTIGLIO MONFERRATO" },
    { "code": "F679", "province": "MS", "name": "MONTIGNOSO" },
    { "code": "F680", "province": "BS", "name": "MONTIRONE" },
    { "code": "F367", "province": "TO", "name": "MONTJOVET (soppresso)" },
    { "code": "F367", "province": "AO", "name": "MONTJOVET" },
    { "code": "F681", "province": "CR", "name": "MONTODINE" },
    { "code": "F682", "province": "GE", "name": "MONTOGGIO" },
    { "code": "F683", "province": "PL", "name": "MONTONA (soppresso)" },
    { "code": "F685", "province": "PG", "name": "MONTONE" },
    { "code": "F687", "province": "PG", "name": "MONTOPOLI DI SABINA (soppresso)" },
    { "code": "F687", "province": "RM", "name": "MONTOPOLI DI SABINA (soppresso)" },
    { "code": "F687", "province": "RI", "name": "MONTOPOLI DI SABINA" },
    { "code": "F686", "province": "FI", "name": "MONTOPOLI IN VAL D'ARNO (soppresso)" },
    { "code": "F686", "province": "PI", "name": "MONTOPOLI IN VAL D'ARNO" },
    { "code": "F688", "province": "CO", "name": "MONTORFANO" },
    { "code": "F690", "province": "TE", "name": "MONTORIO AL VOMANO" },
    { "code": "F689", "province": "CB", "name": "MONTORIO NEI FRENTANI" },
    { "code": "F692", "province": "RM", "name": "MONTORIO ROMANO" },
    { "code": "F691", "province": "VR", "name": "MONTORIO VERONESE (soppresso)" },
    { "code": "M330", "province": "AV", "name": "MONTORO" },
    { "code": "F693", "province": "AV", "name": "MONTORO INFERIORE (soppresso)" },
    { "code": "F694", "province": "AV", "name": "MONTORO SUPERIORE (soppresso)" },
    { "code": "F696", "province": "VI", "name": "MONTORSO VICENTINO" },
    { "code": "F697", "province": "AP", "name": "MONTOTTONE (soppresso)" },
    { "code": "F697", "province": "FM", "name": "MONTOTTONE" },
    { "code": "F698", "province": "CA", "name": "MONTRESTA (soppresso)" },
    { "code": "F698", "province": "NU", "name": "MONTRESTA (soppresso)" },
    { "code": "F698", "province": "OR", "name": "MONTRESTA" },
    { "code": "F699", "province": "NO", "name": "MONTRIGIASCO (soppresso)" },
    { "code": "F700", "province": "BA", "name": "MONTRONE (soppresso)" },
    { "code": "F701", "province": "PV", "name": "MONTU' BECCARIA" },
    { "code": "F702", "province": "PV", "name": "MONTU' BERCHIELLI (soppresso)" },
    { "code": "F703", "province": "CO", "name": "MONVALLE (soppresso)" },
    { "code": "F703", "province": "VA", "name": "MONVALLE" },
    { "code": "F704", "province": "MI", "name": "MONZA (soppresso)" },
    { "code": "F704", "province": "MB", "name": "MONZA" },
    { "code": "F705", "province": "MN", "name": "MONZAMBANO" },
    { "code": "F706", "province": "BO", "name": "MONZUNO" },
    { "code": "F708", "province": "CS", "name": "MORANO CALABRO" },
    { "code": "F707", "province": "AL", "name": "MORANO SUL PO" },
    { "code": "F709", "province": "AL", "name": "MORANSENGO (soppresso)" },
    { "code": "F709", "province": "AT", "name": "MORANSENGO" },
    { "code": "F710", "province": "GO", "name": "MORARO" },
    { "code": "F710", "province": "UD", "name": "MORARO (soppresso)" },
    { "code": "F711", "province": "CO", "name": "MORAZZONE (soppresso)" },
    { "code": "F711", "province": "VA", "name": "MORAZZONE" },
    { "code": "F712", "province": "SO", "name": "MORBEGNO" },
    { "code": "F713", "province": "AL", "name": "MORBELLO" },
    { "code": "F714", "province": "NO", "name": "MORCA (soppresso)" },
    { "code": "F714", "province": "VC", "name": "MORCA (soppresso)" },
    { "code": "F716", "province": "LE", "name": "MORCIANO DI LEUCA" },
    { "code": "F715", "province": "FO", "name": "MORCIANO DI ROMAGNA (soppresso)" },
    { "code": "F715", "province": "RN", "name": "MORCIANO DI ROMAGNA" },
    { "code": "F717", "province": "BN", "name": "MORCONE" },
    { "code": "F718", "province": "BO", "name": "MORDANO" },
    { "code": "F719", "province": "AP", "name": "MOREGNANO (soppresso)" },
    { "code": "F720", "province": "BG", "name": "MORENGO" },
    { "code": "F721", "province": "SS", "name": "MORES" },
    { "code": "F722", "province": "AP", "name": "MORESCO (soppresso)" },
    { "code": "F722", "province": "FM", "name": "MORESCO" },
    { "code": "F723", "province": "CN", "name": "MORETTA" },
    { "code": "F724", "province": "PC", "name": "MORFASSO" },
    { "code": "F725", "province": "TV", "name": "MORGANO" },
    { "code": "F726", "province": "TO", "name": "MORGEX (soppresso)" },
    { "code": "F726", "province": "AO", "name": "MORGEX" },
    { "code": "F727", "province": "CA", "name": "MORGONGIORI (soppresso)" },
    { "code": "F727", "province": "OR", "name": "MORGONGIORI" },
    { "code": "F728", "province": "TN", "name": "MORI" },
    { "code": "F729", "province": "TV", "name": "MORIAGO (soppresso)" },
    { "code": "F729", "province": "TV", "name": "MORIAGO DELLA BATTAGLIA" },
    { "code": "F730", "province": "RM", "name": "MORICONE" },
    { "code": "F731", "province": "SA", "name": "MORIGERATI" },
    { "code": "D033", "province": "MI", "name": "MORIMONDO" },
    { "code": "F732", "province": "AQ", "name": "MORINO" },
    { "code": "F733", "province": "TO", "name": "MORIONDO TORINESE" },
    { "code": "F734", "province": "RM", "name": "MORLUPO" },
    { "code": "F735", "province": "CS", "name": "MORMANNO" },
    { "code": "F736", "province": "MI", "name": "MORNAGO (soppresso)" },
    { "code": "F736", "province": "VA", "name": "MORNAGO" },
    { "code": "F737", "province": "AL", "name": "MORNESE" },
    { "code": "F738", "province": "BG", "name": "MORNICO AL SERIO" },
    { "code": "F739", "province": "PV", "name": "MORNICO LOSANA" },
    { "code": "F740", "province": "RM", "name": "MOROLO (soppresso)" },
    { "code": "F740", "province": "FR", "name": "MOROLO" },
    { "code": "F741", "province": "NO", "name": "MORONDO (soppresso)" },
    { "code": "F741", "province": "VC", "name": "MORONDO (soppresso)" },
    { "code": "F742", "province": "CO", "name": "MOROSOLO (soppresso)" },
    { "code": "F742", "province": "VA", "name": "MOROSOLO (soppresso)" },
    { "code": "F743", "province": "CN", "name": "MOROZZO" },
    { "code": "F744", "province": "AV", "name": "MORRA DE SANCTIS" },
    { "code": "F744", "province": "AV", "name": "MORRA IRPINO (soppresso)" },
    { "code": "F745", "province": "AN", "name": "MORRO D'ALBA" },
    { "code": "F747", "province": "TE", "name": "MORRO D'ORO" },
    { "code": "F746", "province": "PG", "name": "MORRO REATINO (soppresso)" },
    { "code": "F746", "province": "RM", "name": "MORRO REATINO (soppresso)" },
    { "code": "F746", "province": "RI", "name": "MORRO REATINO" },
    { "code": "F748", "province": "CB", "name": "MORRONE DEL SANNIO" },
    { "code": "F749", "province": "MC", "name": "MORROVALLE" },
    { "code": "F750", "province": "UD", "name": "MORSANO AL TAGLIAMENTO (soppresso)" },
    { "code": "F750", "province": "PN", "name": "MORSANO AL TAGLIAMENTO" },
    { "code": "F751", "province": "AL", "name": "MORSASCO" },
    { "code": "F753", "province": "FO", "name": "MORTANO (soppresso)" },
    { "code": "F754", "province": "PV", "name": "MORTARA" },
    { "code": "F755", "province": "TN", "name": "MORTASO (soppresso)" },
    { "code": "F756", "province": "UD", "name": "MORTEGLIANO" },
    { "code": "F757", "province": "TN", "name": "MORTER (soppresso)" },
    { "code": "F757", "province": "BZ", "name": "MORTER (soppresso)" },
    { "code": "F758", "province": "CO", "name": "MORTERONE (soppresso)" },
    { "code": "F758", "province": "LC", "name": "MORTERONE" },
    { "code": "F759", "province": "PC", "name": "MORTIZZA (soppresso)" },
    { "code": "F760", "province": "UD", "name": "MORUZZO" },
    { "code": "F761", "province": "CR", "name": "MOSCAZZANO" },
    { "code": "F762", "province": "AV", "name": "MOSCHIANO" },
    { "code": "F763", "province": "PL", "name": "MOSCHIENA (soppresso)" },
    { "code": "F763", "province": "FU", "name": "MOSCHIENA (soppresso)" },
    { "code": "F763", "province": "FU", "name": "MOSCHIENIZZE (soppresso)" },
    { "code": "F763", "province": "PL", "name": "MOSCHIENIZZE (soppresso)" },
    { "code": "F764", "province": "TE", "name": "MOSCIANO SANT'ANGELO" },
    { "code": "F765", "province": "TE", "name": "MOSCUFO (soppresso)" },
    { "code": "F765", "province": "PE", "name": "MOSCUFO" },
    { "code": "F766", "province": "TN", "name": "MOSO (soppresso)" },
    { "code": "F766", "province": "BZ", "name": "MOSO (soppresso)" },
    { "code": "F766", "province": "BZ", "name": "MOSO IN PASSIRIA" },
    { "code": "F767", "province": "GO", "name": "MOSSA" },
    { "code": "F767", "province": "UD", "name": "MOSSA (soppresso)" },
    { "code": "F768", "province": "VI", "name": "MOSSANO (soppresso)" },
    { "code": "M304", "province": "BI", "name": "MOSSO (soppresso)" },
    { "code": "F769", "province": "NO", "name": "MOSSO SANTA MARIA (soppresso)" },
    { "code": "F769", "province": "VC", "name": "MOSSO SANTA MARIA (soppresso)" },
    { "code": "F769", "province": "BI", "name": "MOSSO SANTA MARIA (soppresso)" },
    { "code": "F771", "province": "CR", "name": "MOTTA BALUFFI" },
    { "code": "F772", "province": "ME", "name": "MOTTA CAMASTRA" },
    { "code": "F773", "province": "ME", "name": "MOTTA D'AFFERMO" },
    { "code": "F774", "province": "NO", "name": "MOTTA DE' CONTI (soppresso)" },
    { "code": "F774", "province": "VC", "name": "MOTTA DE' CONTI" },
    { "code": "F770", "province": "TV", "name": "MOTTA DI LIVENZA" },
    { "code": "F777", "province": "FG", "name": "MOTTA MONTECORVINO" },
    { "code": "F779", "province": "RC", "name": "MOTTA SAN GIOVANNI" },
    { "code": "F780", "province": "CZ", "name": "MOTTA SANTA LUCIA" },
    { "code": "F781", "province": "CT", "name": "MOTTA SANT'ANASTASIA" },
    { "code": "F783", "province": "MI", "name": "MOTTA VISCONTI" },
    { "code": "F775", "province": "CS", "name": "MOTTAFOLLONE" },
    { "code": "F776", "province": "NO", "name": "MOTTALCIATA (soppresso)" },
    { "code": "F776", "province": "VC", "name": "MOTTALCIATA (soppresso)" },
    { "code": "F776", "province": "BI", "name": "MOTTALCIATA" },
    { "code": "B012", "province": "MN", "name": "MOTTEGGIANA" },
    { "code": "F784", "province": "LE", "name": "MOTTOLA (soppresso)" },
    { "code": "F784", "province": "TA", "name": "MOTTOLA" },
    { "code": "F785", "province": "CH", "name": "MOZZAGROGNA" },
    { "code": "F786", "province": "BG", "name": "MOZZANICA" },
    { "code": "F788", "province": "CO", "name": "MOZZATE" },
    { "code": "F789", "province": "VR", "name": "MOZZECANE" },
    { "code": "F790", "province": "NO", "name": "MOZZIO (soppresso)" },
    { "code": "F791", "province": "BG", "name": "MOZZO" },
    { "code": "F792", "province": "BS", "name": "MU (soppresso)" },
    { "code": "F793", "province": "MC", "name": "MUCCIA" },
    { "code": "F794", "province": "CO", "name": "MUCENO (soppresso)" },
    { "code": "F794", "province": "VA", "name": "MUCENO (soppresso)" },
    { "code": "F795", "province": "TS", "name": "MUGGIA" },
    { "code": "F797", "province": "MI", "name": "MUGGIO' (soppresso)" },
    { "code": "F797", "province": "MB", "name": "MUGGIO'" },
    { "code": "F798", "province": "AV", "name": "MUGNANO DEL CARDINALE" },
    { "code": "F799", "province": "NA", "name": "MUGNANO DI NAPOLI" },
    { "code": "F801", "province": "MI", "name": "MULAZZANO (soppresso)" },
    { "code": "F801", "province": "LO", "name": "MULAZZANO" },
    { "code": "F802", "province": "MS", "name": "MULAZZO" },
    { "code": "F803", "province": "TN", "name": "MULES (soppresso)" },
    { "code": "F803", "province": "BZ", "name": "MULES (soppresso)" },
    { "code": "F806", "province": "BS", "name": "MURA" },
    { "code": "F807", "province": "VE", "name": "MURANO (soppresso)" },
    { "code": "F808", "province": "CA", "name": "MURAVERA (soppresso)" },
    { "code": "F808", "province": "SU", "name": "MURAVERA" },
    { "code": "F809", "province": "CN", "name": "MURAZZANO" },
    { "code": "F811", "province": "CN", "name": "MURELLO" },
    { "code": "F812", "province": "TO", "name": "MURIAGLIO (soppresso)" },
    { "code": "F812", "province": "AO", "name": "MURIAGLIO (soppresso)" },
    { "code": "F813", "province": "GE", "name": "MURIALDO (soppresso)" },
    { "code": "F813", "province": "SV", "name": "MURIALDO" },
    { "code": "F814", "province": "AL", "name": "MURISENGO" },
    { "code": "F815", "province": "SI", "name": "MURLO" },
    { "code": "F816", "province": "LE", "name": "MURO LECCESE" },
    { "code": "F817", "province": "PZ", "name": "MURO LUCANO" },
    { "code": "F818", "province": "SS", "name": "MUROS" },
    { "code": "F819", "province": "CO", "name": "MUSADINO (soppresso)" },
    { "code": "F819", "province": "VA", "name": "MUSADINO (soppresso)" },
    { "code": "F821", "province": "UD", "name": "MUSCOLI STRASSOLDO (soppresso)" },
    { "code": "F820", "province": "BS", "name": "MUSCOLINE" },
    { "code": "F822", "province": "CA", "name": "MUSEI (soppresso)" },
    { "code": "F822", "province": "CI", "name": "MUSEI (soppresso)" },
    { "code": "F822", "province": "SU", "name": "MUSEI" },
    { "code": "F823", "province": "CH", "name": "MUSELLARO (soppresso)" },
    { "code": "F823", "province": "PE", "name": "MUSELLARO (soppresso)" },
    { "code": "F825", "province": "CO", "name": "MUSIGNANO (soppresso)" },
    { "code": "F825", "province": "VA", "name": "MUSIGNANO (soppresso)" },
    { "code": "F826", "province": "VE", "name": "MUSILE (soppresso)" },
    { "code": "F826", "province": "VE", "name": "MUSILE DI PIAVE" },
    { "code": "F827", "province": "MI", "name": "MUSOCCO (soppresso)" },
    { "code": "F828", "province": "CO", "name": "MUSSO" },
    { "code": "F829", "province": "VI", "name": "MUSSOLENTE" },
    { "code": "A357", "province": "CA", "name": "MUSSOLINIA DI SARDEGNA (soppresso)" },
    { "code": "F830", "province": "CL", "name": "MUSSOMELI" },
    { "code": "F831", "province": "TE", "name": "MUTIGNANO (soppresso)" },
    { "code": "F832", "province": "UD", "name": "MUZZANA DEL TURGNANO" },
    { "code": "F833", "province": "NO", "name": "MUZZANO (soppresso)" },
    { "code": "F833", "province": "VC", "name": "MUZZANO (soppresso)" },
    { "code": "F833", "province": "BI", "name": "MUZZANO" },
    { "code": "A500", "province": "TS", "name": "NABRESINA (soppresso)" },
    { "code": "F834", "province": "TS", "name": "NACLA SAN MAURIZIO (soppresso)" },
    { "code": "F835", "province": "TN", "name": "NAGO-TORBOLE" },
    { "code": "F836", "province": "TN", "name": "NALLES (soppresso)" },
    { "code": "F836", "province": "BZ", "name": "NALLES" },
    { "code": "F837", "province": "TN", "name": "NANNO (soppresso)" },
    { "code": "F838", "province": "VI", "name": "NANTO" },
    { "code": "F839", "province": "NA", "name": "NAPOLI" },
    { "code": "F840", "province": "CA", "name": "NARBOLIA (soppresso)" },
    { "code": "F840", "province": "OR", "name": "NARBOLIA" },
    { "code": "F841", "province": "CA", "name": "NARCAO (soppresso)" },
    { "code": "F841", "province": "CI", "name": "NARCAO (soppresso)" },
    { "code": "F841", "province": "SU", "name": "NARCAO" },
    { "code": "F842", "province": "LE", "name": "NARDO'" },
    { "code": "F843", "province": "CZ", "name": "NARDODIPACE (soppresso)" },
    { "code": "F843", "province": "VV", "name": "NARDODIPACE" },
    { "code": "F844", "province": "PG", "name": "NARNI (soppresso)" },
    { "code": "F844", "province": "TR", "name": "NARNI" },
    { "code": "F845", "province": "AG", "name": "NARO" },
    { "code": "F846", "province": "CN", "name": "NARZOLE" },
    { "code": "F847", "province": "GE", "name": "NASINO (soppresso)" },
    { "code": "F847", "province": "SV", "name": "NASINO" },
    { "code": "F848", "province": "ME", "name": "NASO" },
    { "code": "F849", "province": "TN", "name": "NATURNO (soppresso)" },
    { "code": "F849", "province": "BZ", "name": "NATURNO" },
    { "code": "F850", "province": "CO", "name": "NAVA (soppresso)" },
    { "code": "F851", "province": "BS", "name": "NAVE" },
    { "code": "F853", "province": "TN", "name": "NAVE SAN ROCCO (soppresso)" },
    { "code": "F852", "province": "AQ", "name": "NAVELLI" },
    { "code": "F854", "province": "BS", "name": "NAVONO (soppresso)" },
    { "code": "F855", "province": "TN", "name": "NAZ (soppresso)" },
    { "code": "F855", "province": "BZ", "name": "NAZ (soppresso)" },
    { "code": "F856", "province": "BZ", "name": "NAZ-SCIAVES" },
    { "code": "F857", "province": "RM", "name": "NAZZANO" },
    { "code": "F858", "province": "GE", "name": "NE" },
    { "code": "F859", "province": "NO", "name": "NEBBIUNO" },
    { "code": "F860", "province": "VR", "name": "NEGARINE (soppresso)" },
    { "code": "F861", "province": "VR", "name": "NEGRAR (soppresso)" },
    { "code": "F861", "province": "VR", "name": "NEGRAR DI VALPOLICELLA" },
    { "code": "F862", "province": "GE", "name": "NEIRONE" },
    { "code": "F863", "province": "CN", "name": "NEIVE" },
    { "code": "F864", "province": "BG", "name": "NEMBRO" },
    { "code": "F865", "province": "RM", "name": "NEMI" },
    { "code": "F866", "province": "PZ", "name": "NEMOLI" },
    { "code": "F867", "province": "CA", "name": "NEONELI (soppresso)" },
    { "code": "F867", "province": "OR", "name": "NEONELI" },
    { "code": "F868", "province": "RM", "name": "NEPI (soppresso)" },
    { "code": "F868", "province": "VT", "name": "NEPI" },
    { "code": "F869", "province": "PL", "name": "NERESINE (soppresso)" },
    { "code": "F870", "province": "TE", "name": "NERETO" },
    { "code": "F871", "province": "RM", "name": "NEROLA" },
    { "code": "F872", "province": "TV", "name": "NERVESA (soppresso)" },
    { "code": "F872", "province": "TV", "name": "NERVESA DELLA BATTAGLIA" },
    { "code": "F873", "province": "GE", "name": "NERVI (soppresso)" },
    { "code": "F874", "province": "MI", "name": "NERVIANO" },
    { "code": "F875", "province": "BG", "name": "NESE (soppresso)" },
    { "code": "F876", "province": "PG", "name": "NESPOLO (soppresso)" },
    { "code": "F876", "province": "RM", "name": "NESPOLO (soppresso)" },
    { "code": "F876", "province": "RI", "name": "NESPOLO" },
    { "code": "F877", "province": "CO", "name": "NESSO" },
    { "code": "F878", "province": "NO", "name": "NETRO (soppresso)" },
    { "code": "F878", "province": "VC", "name": "NETRO (soppresso)" },
    { "code": "F878", "province": "BI", "name": "NETRO" },
    { "code": "F879", "province": "RM", "name": "NETTUNIA (soppresso)" },
    { "code": "F880", "province": "RM", "name": "NETTUNO" },
    { "code": "F881", "province": "LE", "name": "NEVIANO" },
    { "code": "F882", "province": "PR", "name": "NEVIANO DEGLI ARDUINI" },
    { "code": "F883", "province": "CN", "name": "NEVIGLIE" },
    { "code": "F884", "province": "BS", "name": "NIARDO" },
    { "code": "F885", "province": "PC", "name": "NIBBIANO (soppresso)" },
    { "code": "F886", "province": "NO", "name": "NIBBIOLA" },
    { "code": "F887", "province": "CO", "name": "NIBIONNO (soppresso)" },
    { "code": "F887", "province": "LC", "name": "NIBIONNO" },
    { "code": "F888", "province": "CZ", "name": "NICASTRO (soppresso)" },
    { "code": "F889", "province": "TO", "name": "NICHELINO" },
    { "code": "F890", "province": "CT", "name": "NICOLOSI" },
    { "code": "F891", "province": "PV", "name": "NICORVO" },
    { "code": "F892", "province": "CT", "name": "NICOSIA (soppresso)" },
    { "code": "F892", "province": "EN", "name": "NICOSIA" },
    { "code": "F893", "province": "CZ", "name": "NICOTERA (soppresso)" },
    { "code": "F893", "province": "VV", "name": "NICOTERA" },
    { "code": "F894", "province": "CN", "name": "NIELLA BELBO" },
    { "code": "F895", "province": "CN", "name": "NIELLA TANARO" },
    { "code": "F896", "province": "BS", "name": "NIGOLINE (soppresso)" },
    { "code": "F897", "province": "MI", "name": "NIGUARDA (soppresso)" },
    { "code": "F898", "province": "UD", "name": "NIMIS" },
    { "code": "F899", "province": "CL", "name": "NISCEMI" },
    { "code": "F900", "province": "CT", "name": "NISSORIA (soppresso)" },
    { "code": "F900", "province": "EN", "name": "NISSORIA" },
    { "code": "F901", "province": "ME", "name": "NIZZA DI SICILIA" },
    { "code": "F902", "province": "AL", "name": "NIZZA MONFERRATO (soppresso)" },
    { "code": "F902", "province": "AT", "name": "NIZZA MONFERRATO" },
    { "code": "F904", "province": "VE", "name": "NOALE" },
    { "code": "F905", "province": "TN", "name": "NOARNA (soppresso)" },
    { "code": "F906", "province": "TO", "name": "NOASCA" },
    { "code": "F906", "province": "AO", "name": "NOASCA (soppresso)" },
    { "code": "F907", "province": "CS", "name": "NOCARA" },
    { "code": "F908", "province": "TE", "name": "NOCCIANO (soppresso)" },
    { "code": "F908", "province": "PE", "name": "NOCCIANO" },
    { "code": "F909", "province": "NO", "name": "NOCCO (soppresso)" },
    { "code": "F912", "province": "SA", "name": "NOCERA INFERIORE" },
    { "code": "F913", "province": "SA", "name": "NOCERA SUPERIORE" },
    { "code": "F910", "province": "CZ", "name": "NOCERA TERINESE" },
    { "code": "F911", "province": "PG", "name": "NOCERA UMBRA" },
    { "code": "F914", "province": "PR", "name": "NOCETO" },
    { "code": "F915", "province": "BA", "name": "NOCI" },
    { "code": "F855", "province": "TN", "name": "NOCI (soppresso)" },
    { "code": "F916", "province": "LE", "name": "NOCIGLIA" },
    { "code": "F917", "province": "PZ", "name": "NOEPOLI" },
    { "code": "F918", "province": "VR", "name": "NOGARA" },
    { "code": "F919", "province": "TN", "name": "NOGARE' (soppresso)" },
    { "code": "F920", "province": "TN", "name": "NOGAREDO" },
    { "code": "F921", "province": "VR", "name": "NOGAROLE ROCCA" },
    { "code": "F922", "province": "VI", "name": "NOGAROLE VICENTINO" },
    { "code": "F923", "province": "BA", "name": "NOICATTARO" },
    { "code": "F924", "province": "CE", "name": "NOLA (soppresso)" },
    { "code": "F924", "province": "NA", "name": "NOLA" },
    { "code": "F925", "province": "TO", "name": "NOLE" },
    { "code": "F926", "province": "GE", "name": "NOLI (soppresso)" },
    { "code": "F926", "province": "SV", "name": "NOLI" },
    { "code": "F927", "province": "TO", "name": "NOMAGLIO" },
    { "code": "F927", "province": "AO", "name": "NOMAGLIO (soppresso)" },
    { "code": "F928", "province": "TN", "name": "NOMESINO (soppresso)" },
    { "code": "F929", "province": "TN", "name": "NOMI" },
    { "code": "F930", "province": "MO", "name": "NONANTOLA" },
    { "code": "F931", "province": "TO", "name": "NONE" },
    { "code": "F932", "province": "NO", "name": "NONIO (soppresso)" },
    { "code": "F932", "province": "VB", "name": "NONIO" },
    { "code": "F933", "province": "CA", "name": "NORAGUGUME (soppresso)" },
    { "code": "F933", "province": "NU", "name": "NORAGUGUME" },
    { "code": "F934", "province": "CA", "name": "NORBELLO (soppresso)" },
    { "code": "F934", "province": "OR", "name": "NORBELLO" },
    { "code": "F935", "province": "PG", "name": "NORCIA" },
    { "code": "F936", "province": "TN", "name": "NORIGLIO (soppresso)" },
    { "code": "F937", "province": "RM", "name": "NORMA (soppresso)" },
    { "code": "F937", "province": "LT", "name": "NORMA" },
    { "code": "F939", "province": "MI", "name": "NOSATE" },
    { "code": "F941", "province": "BG", "name": "NOSSA (soppresso)" },
    { "code": "F942", "province": "TE", "name": "NOTARESCO" },
    { "code": "F943", "province": "SR", "name": "NOTO" },
    { "code": "F944", "province": "MI", "name": "NOVA (soppresso)" },
    { "code": "F949", "province": "TN", "name": "NOVA LEVANTE (soppresso)" },
    { "code": "F949", "province": "BZ", "name": "NOVA LEVANTE" },
    { "code": "F944", "province": "MI", "name": "NOVA MILANESE (soppresso)" },
    { "code": "F944", "province": "MB", "name": "NOVA MILANESE" },
    { "code": "F950", "province": "TN", "name": "NOVA PONENTE (soppresso)" },
    { "code": "F950", "province": "BZ", "name": "NOVA PONENTE" },
    { "code": "A942", "province": "PZ", "name": "NOVA SIRI (soppresso)" },
    { "code": "A942", "province": "MT", "name": "NOVA SIRI" },
    { "code": "F945", "province": "TN", "name": "NOVACELLA (soppresso)" },
    { "code": "F945", "province": "BZ", "name": "NOVACELLA (soppresso)" },
    { "code": "F137", "province": "PS", "name": "NOVAFELTRIA (soppresso)" },
    { "code": "F137", "province": "PU", "name": "NOVAFELTRIA (soppresso)" },
    { "code": "F137", "province": "RN", "name": "NOVAFELTRIA" },
    { "code": "F946", "province": "VI", "name": "NOVALE (soppresso)" },
    { "code": "F947", "province": "TN", "name": "NOVALEDO" },
    { "code": "F948", "province": "TO", "name": "NOVALESA" },
    { "code": "F952", "province": "NO", "name": "NOVARA" },
    { "code": "F951", "province": "ME", "name": "NOVARA DI SICILIA" },
    { "code": "F953", "province": "TO", "name": "NOVAREGLIA (soppresso)" },
    { "code": "F953", "province": "AO", "name": "NOVAREGLIA (soppresso)" },
    { "code": "F954", "province": "CO", "name": "NOVATE BRIANZA (soppresso)" },
    { "code": "F956", "province": "SO", "name": "NOVATE MEZZOLA" },
    { "code": "F955", "province": "MI", "name": "NOVATE MILANESE" },
    { "code": "F957", "province": "VI", "name": "NOVE" },
    { "code": "F958", "province": "CO", "name": "NOVEDRATE" },
    { "code": "F960", "province": "RE", "name": "NOVELLARA" },
    { "code": "F961", "province": "CN", "name": "NOVELLO" },
    { "code": "F339", "province": "CN", "name": "NOVELLO MONCHIERO (soppresso)" },
    { "code": "F963", "province": "VE", "name": "NOVENTA DI PIAVE" },
    { "code": "F962", "province": "PD", "name": "NOVENTA PADOVANA" },
    { "code": "F964", "province": "VI", "name": "NOVENTA VICENTINA" },
    { "code": "F966", "province": "MO", "name": "NOVI DI MODENA" },
    { "code": "F965", "province": "AL", "name": "NOVI LIGURE" },
    { "code": "F967", "province": "SA", "name": "NOVI VELIA" },
    { "code": "F968", "province": "MI", "name": "NOVIGLIO" },
    { "code": "F969", "province": "PS", "name": "NOVILLARA (soppresso)" },
    { "code": "F970", "province": "LE", "name": "NOVOLI" },
    { "code": "F971", "province": "BS", "name": "NOZZA (soppresso)" },
    { "code": "F972", "province": "CN", "name": "NUCETTO" },
    { "code": "F973", "province": "SS", "name": "NUCHIS (soppresso)" },
    { "code": "F975", "province": "SS", "name": "NUGHEDU DI SAN NICOLO' (soppresso)" },
    { "code": "F975", "province": "SS", "name": "NUGHEDU SAN NICOLO'" },
    { "code": "F974", "province": "CA", "name": "NUGHEDU SANTA VITTORIA (soppresso)" },
    { "code": "F974", "province": "OR", "name": "NUGHEDU SANTA VITTORIA" },
    { "code": "F976", "province": "SS", "name": "NULE" },
    { "code": "F977", "province": "SS", "name": "NULVI" },
    { "code": "F978", "province": "AN", "name": "NUMANA" },
    { "code": "F979", "province": "SS", "name": "NUORO (soppresso)" },
    { "code": "F979", "province": "NU", "name": "NUORO" },
    { "code": "F980", "province": "CA", "name": "NURACHI (soppresso)" },
    { "code": "F980", "province": "OR", "name": "NURACHI" },
    { "code": "F981", "province": "CA", "name": "NURAGUS (soppresso)" },
    { "code": "F981", "province": "NU", "name": "NURAGUS (soppresso)" },
    { "code": "F981", "province": "SU", "name": "NURAGUS" },
    { "code": "F982", "province": "CA", "name": "NURALLAO (soppresso)" },
    { "code": "F982", "province": "NU", "name": "NURALLAO (soppresso)" },
    { "code": "F982", "province": "SU", "name": "NURALLAO" },
    { "code": "F983", "province": "CA", "name": "NURAMINIS (soppresso)" },
    { "code": "F983", "province": "SU", "name": "NURAMINIS" },
    { "code": "F984", "province": "CA", "name": "NURAXINIEDDU (soppresso)" },
    { "code": "F985", "province": "CA", "name": "NURECI (soppresso)" },
    { "code": "F985", "province": "OR", "name": "NURECI" },
    { "code": "F986", "province": "CA", "name": "NURRI (soppresso)" },
    { "code": "F986", "province": "NU", "name": "NURRI (soppresso)" },
    { "code": "F986", "province": "SU", "name": "NURRI" },
    { "code": "F987", "province": "TO", "name": "NUS (soppresso)" },
    { "code": "F987", "province": "AO", "name": "NUS" },
    { "code": "F988", "province": "AV", "name": "NUSCO" },
    { "code": "F989", "province": "BS", "name": "NUVOLENTO" },
    { "code": "F990", "province": "BS", "name": "NUVOLERA" },
    { "code": "F991", "province": "CA", "name": "NUXIS (soppresso)" },
    { "code": "F991", "province": "CI", "name": "NUXIS (soppresso)" },
    { "code": "F991", "province": "SU", "name": "NUXIS" },
    { "code": "F992", "province": "NO", "name": "OCCHIEPPO INFERIORE (soppresso)" },
    { "code": "F992", "province": "VC", "name": "OCCHIEPPO INFERIORE (soppresso)" },
    { "code": "F992", "province": "BI", "name": "OCCHIEPPO INFERIORE" },
    { "code": "F993", "province": "NO", "name": "OCCHIEPPO SUPERIORE (soppresso)" },
    { "code": "F993", "province": "VC", "name": "OCCHIEPPO SUPERIORE (soppresso)" },
    { "code": "F993", "province": "BI", "name": "OCCHIEPPO SUPERIORE" },
    { "code": "F994", "province": "RO", "name": "OCCHIOBELLO" },
    { "code": "F995", "province": "AL", "name": "OCCIMIANO" },
    { "code": "ND", "province": "VG", "name": "OCCISLA-CLANZO (soppresso)" },
    { "code": "ND", "province": "PL", "name": "OCCISLA-CLANZO (soppresso)" },
    { "code": "F996", "province": "AQ", "name": "OCRE" },
    { "code": "F997", "province": "AL", "name": "ODALENGO GRANDE" },
    { "code": "F998", "province": "AL", "name": "ODALENGO PICCOLO" },
    { "code": "F999", "province": "TV", "name": "ODERZO" },
    { "code": "G001", "province": "BS", "name": "ODOLO" },
    { "code": "G002", "province": "AQ", "name": "OFENA" },
    { "code": "G003", "province": "AN", "name": "OFFAGNA" },
    { "code": "G004", "province": "CR", "name": "OFFANENGO" },
    { "code": "G005", "province": "AP", "name": "OFFIDA" },
    { "code": "G006", "province": "BS", "name": "OFFLAGA" },
    { "code": "G007", "province": "NO", "name": "OGGEBBIO (soppresso)" },
    { "code": "G007", "province": "VB", "name": "OGGEBBIO" },
    { "code": "G008", "province": "MI", "name": "OGGIONA CON SANTO STEFANO (soppresso)" },
    { "code": "G008", "province": "VA", "name": "OGGIONA CON SANTO STEFANO" },
    { "code": "G009", "province": "CO", "name": "OGGIONO (soppresso)" },
    { "code": "G009", "province": "LC", "name": "OGGIONO" },
    { "code": "G010", "province": "TO", "name": "OGLIANICO" },
    { "code": "G011", "province": "SA", "name": "OGLIASTRO CILENTO" },
    { "code": "G012", "province": "AO", "name": "OIASSE (soppresso)" },
    { "code": "G014", "province": "GE", "name": "OLBA (soppresso)" },
    { "code": "G014", "province": "SV", "name": "OLBA (soppresso)" },
    { "code": "G015", "province": "SS", "name": "OLBIA" },
    { "code": "G015", "province": "OT", "name": "OLBIA (soppresso)" },
    { "code": "G016", "province": "NO", "name": "OLCENENGO (soppresso)" },
    { "code": "G016", "province": "VC", "name": "OLCENENGO" },
    { "code": "G017", "province": "CO", "name": "OLCIO (soppresso)" },
    { "code": "G018", "province": "NO", "name": "OLDENICO (soppresso)" },
    { "code": "G018", "province": "VC", "name": "OLDENICO" },
    { "code": "G019", "province": "NO", "name": "OLEGGIO" },
    { "code": "G020", "province": "NO", "name": "OLEGGIO CASTELLO" },
    { "code": "G021", "province": "PV", "name": "OLEVANO DI LOMELLINA" },
    { "code": "G022", "province": "RM", "name": "OLEVANO ROMANO" },
    { "code": "G023", "province": "SA", "name": "OLEVANO SUL TUSCIANO" },
    { "code": "G024", "province": "NO", "name": "OLGIA (soppresso)" },
    { "code": "G027", "province": "CO", "name": "OLGIATE CALCO (soppresso)" },
    { "code": "G025", "province": "CO", "name": "OLGIATE COMASCO" },
    { "code": "G026", "province": "CO", "name": "OLGIATE MOLGORA (soppresso)" },
    { "code": "G026", "province": "LC", "name": "OLGIATE MOLGORA" },
    { "code": "G028", "province": "MI", "name": "OLGIATE OLONA (soppresso)" },
    { "code": "G028", "province": "VA", "name": "OLGIATE OLONA" },
    { "code": "G029", "province": "CO", "name": "OLGINASIO (soppresso)" },
    { "code": "G029", "province": "VA", "name": "OLGINASIO (soppresso)" },
    { "code": "G030", "province": "CO", "name": "OLGINATE (soppresso)" },
    { "code": "G030", "province": "LC", "name": "OLGINATE" },
    { "code": "G031", "province": "SS", "name": "OLIENA (soppresso)" },
    { "code": "G031", "province": "NU", "name": "OLIENA" },
    { "code": "G032", "province": "PV", "name": "OLIVA GESSI" },
    { "code": "G034", "province": "CZ", "name": "OLIVADI" },
    { "code": "G035", "province": "IM", "name": "OLIVASTRI (soppresso)" },
    { "code": "G036", "province": "ME", "name": "OLIVERI" },
    { "code": "G039", "province": "SA", "name": "OLIVETO CITRA" },
    { "code": "G040", "province": "CO", "name": "OLIVETO LARIO (soppresso)" },
    { "code": "G040", "province": "LC", "name": "OLIVETO LARIO" },
    { "code": "G037", "province": "PZ", "name": "OLIVETO LUCANO (soppresso)" },
    { "code": "G037", "province": "MT", "name": "OLIVETO LUCANO" },
    { "code": "G041", "province": "IM", "name": "OLIVETTA SAN MICHELE" },
    { "code": "G042", "province": "AL", "name": "OLIVOLA" },
    { "code": "A126", "province": "CA", "name": "OLLASTA (soppresso)" },
    { "code": "G043", "province": "OR", "name": "OLLASTRA" },
    { "code": "G043", "province": "CA", "name": "OLLASTRA SIMAXIS (soppresso)" },
    { "code": "G043", "province": "OR", "name": "OLLASTRA SIMAXIS (soppresso)" },
    { "code": "A126", "province": "CA", "name": "OLLASTRA USELLUS (soppresso)" },
    { "code": "G044", "province": "SS", "name": "OLLOLAI (soppresso)" },
    { "code": "G044", "province": "NU", "name": "OLLOLAI" },
    { "code": "G045", "province": "TO", "name": "OLLOMONT (soppresso)" },
    { "code": "G045", "province": "AO", "name": "OLLOMONT" },
    { "code": "G045", "province": "AO", "name": "OLLOMONTE (soppresso)" },
    { "code": "G046", "province": "SS", "name": "OLMEDO" },
    { "code": "G047", "province": "CR", "name": "OLMENETA" },
    { "code": "G049", "province": "BG", "name": "OLMO AL BREMBO" },
    { "code": "G048", "province": "AL", "name": "OLMO GENTILE (soppresso)" },
    { "code": "G048", "province": "AT", "name": "OLMO GENTILE" },
    { "code": "G050", "province": "BG", "name": "OLTRE IL COLLE" },
    { "code": "G051", "province": "BG", "name": "OLTREPOVO (soppresso)" },
    { "code": "G052", "province": "TN", "name": "OLTRESARCA (soppresso)" },
    { "code": "G053", "province": "GO", "name": "OLTRESONZIA (soppresso)" },
    { "code": "G053", "province": "UD", "name": "OLTRESONZIA (soppresso)" },
    { "code": "G054", "province": "BG", "name": "OLTRESSENDA ALTA" },
    { "code": "G055", "province": "BG", "name": "OLTRESSENDA BASSA (soppresso)" },
    { "code": "G057", "province": "CO", "name": "OLTRONA AL LAGO (soppresso)" },
    { "code": "G057", "province": "VA", "name": "OLTRONA AL LAGO (soppresso)" },
    { "code": "G056", "province": "CO", "name": "OLTRONA DI SAN MAMETTE" },
    { "code": "G058", "province": "SS", "name": "OLZAI (soppresso)" },
    { "code": "G058", "province": "NU", "name": "OLZAI" },
    { "code": "G060", "province": "CR", "name": "OMBRIANO (soppresso)" },
    { "code": "G061", "province": "BS", "name": "OME" },
    { "code": "G062", "province": "NO", "name": "OMEGNA (soppresso)" },
    { "code": "G062", "province": "VB", "name": "OMEGNA" },
    { "code": "G063", "province": "SA", "name": "OMIGNANO" },
    { "code": "G064", "province": "SS", "name": "ONANI' (soppresso)" },
    { "code": "G064", "province": "NU", "name": "ONANI'" },
    { "code": "G065", "province": "RM", "name": "ONANO (soppresso)" },
    { "code": "G065", "province": "VT", "name": "ONANO" },
    { "code": "G066", "province": "CN", "name": "ONCINO" },
    { "code": "G067", "province": "IM", "name": "ONEGLIA (soppresso)" },
    { "code": "G068", "province": "BG", "name": "ONETA" },
    { "code": "G069", "province": "TN", "name": "ONIES (soppresso)" },
    { "code": "G069", "province": "BZ", "name": "ONIES (soppresso)" },
    { "code": "G070", "province": "SS", "name": "ONIFAI (soppresso)" },
    { "code": "G070", "province": "NU", "name": "ONIFAI" },
    { "code": "G071", "province": "SS", "name": "ONIFERI (soppresso)" },
    { "code": "G071", "province": "NU", "name": "ONIFERI" },
    { "code": "G072", "province": "CO", "name": "ONNO (soppresso)" },
    { "code": "G073", "province": "BS", "name": "ONO DEGNO (soppresso)" },
    { "code": "G074", "province": "BS", "name": "ONO SAN PIETRO" },
    { "code": "G075", "province": "BG", "name": "ONORE" },
    { "code": "G076", "province": "GE", "name": "ONZO (soppresso)" },
    { "code": "G076", "province": "SV", "name": "ONZO" },
    { "code": "G077", "province": "GO", "name": "OPACCHIASELLA (soppresso)" },
    { "code": "G077", "province": "UD", "name": "OPACCHIASELLA (soppresso)" },
    { "code": "G078", "province": "MI", "name": "OPERA" },
    { "code": "G079", "province": "AQ", "name": "OPI" },
    { "code": "G080", "province": "VR", "name": "OPPEANO" },
    { "code": "G081", "province": "PZ", "name": "OPPIDO LUCANO" },
    { "code": "G082", "province": "RC", "name": "OPPIDO MAMERTINA" },
    { "code": "G083", "province": "TN", "name": "ORA (soppresso)" },
    { "code": "G083", "province": "BZ", "name": "ORA" },
    { "code": "G084", "province": "SS", "name": "ORANI (soppresso)" },
    { "code": "G084", "province": "NU", "name": "ORANI" },
    { "code": "G085", "province": "NO", "name": "ORASSO (soppresso)" },
    { "code": "G086", "province": "CB", "name": "ORATINO" },
    { "code": "G087", "province": "TO", "name": "ORBASSANO" },
    { "code": "G088", "province": "GR", "name": "ORBETELLO" },
    { "code": "G089", "province": "PS", "name": "ORCIANO DI PESARO (soppresso)" },
    { "code": "G089", "province": "PU", "name": "ORCIANO DI PESARO (soppresso)" },
    { "code": "G090", "province": "PI", "name": "ORCIANO PISANO" },
    { "code": "D522", "province": "GE", "name": "ORCO FEGLINO (soppresso)" },
    { "code": "D522", "province": "SV", "name": "ORCO FEGLINO" },
    { "code": "M266", "province": "FG", "name": "ORDONA" },
    { "code": "G092", "province": "MI", "name": "ORENO (soppresso)" },
    { "code": "G093", "province": "GE", "name": "ORERO" },
    { "code": "G094", "province": "BG", "name": "OREZZO (soppresso)" },
    { "code": "G095", "province": "VI", "name": "ORGIANO" },
    { "code": "G097", "province": "SS", "name": "ORGOSOLO (soppresso)" },
    { "code": "G097", "province": "NU", "name": "ORGOSOLO" },
    { "code": "G098", "province": "LE", "name": "ORIA (soppresso)" },
    { "code": "G098", "province": "BR", "name": "ORIA" },
    { "code": "G099", "province": "BS", "name": "ORIANO (soppresso)" },
    { "code": "G100", "province": "CO", "name": "ORIANO DI BRIANZA (soppresso)" },
    { "code": "G102", "province": "AQ", "name": "ORICOLA" },
    { "code": "G103", "province": "MI", "name": "ORIGGIO (soppresso)" },
    { "code": "G103", "province": "VA", "name": "ORIGGIO" },
    { "code": "G105", "province": "CO", "name": "ORINO (soppresso)" },
    { "code": "G105", "province": "VA", "name": "ORINO" },
    { "code": "G106", "province": "VA", "name": "ORINO-AZZIO (soppresso)" },
    { "code": "G108", "province": "BG", "name": "ORIO AL SERIO" },
    { "code": "G109", "province": "TO", "name": "ORIO CANAVESE" },
    { "code": "G109", "province": "AO", "name": "ORIO CANAVESE (soppresso)" },
    { "code": "G107", "province": "MI", "name": "ORIO LITTA (soppresso)" },
    { "code": "G107", "province": "LO", "name": "ORIO LITTA" },
    { "code": "G110", "province": "CS", "name": "ORIOLO" },
    { "code": "G111", "province": "RM", "name": "ORIOLO ROMANO (soppresso)" },
    { "code": "G111", "province": "VT", "name": "ORIOLO ROMANO" },
    { "code": "G112", "province": "TN", "name": "ORIS (soppresso)" },
    { "code": "G112", "province": "BZ", "name": "ORIS (soppresso)" },
    { "code": "G113", "province": "CA", "name": "ORISTANO (soppresso)" },
    { "code": "G113", "province": "OR", "name": "ORISTANO" },
    { "code": "G114", "province": "CN", "name": "ORMEA" },
    { "code": "G115", "province": "TV", "name": "ORMELLE" },
    { "code": "G116", "province": "MI", "name": "ORNAGO (soppresso)" },
    { "code": "G116", "province": "MB", "name": "ORNAGO" },
    { "code": "G117", "province": "NO", "name": "ORNAVASSO (soppresso)" },
    { "code": "G117", "province": "VB", "name": "ORNAVASSO" },
    { "code": "G118", "province": "BG", "name": "ORNICA" },
    { "code": "G119", "province": "SS", "name": "OROSEI (soppresso)" },
    { "code": "G119", "province": "NU", "name": "OROSEI" },
    { "code": "G120", "province": "SS", "name": "OROTELLI (soppresso)" },
    { "code": "G120", "province": "NU", "name": "OROTELLI" },
    { "code": "G121", "province": "SA", "name": "ORRIA" },
    { "code": "G122", "province": "CA", "name": "ORROLI (soppresso)" },
    { "code": "G122", "province": "NU", "name": "ORROLI (soppresso)" },
    { "code": "G122", "province": "SU", "name": "ORROLI" },
    { "code": "G123", "province": "TV", "name": "ORSAGO" },
    { "code": "G124", "province": "AL", "name": "ORSARA BORMIDA" },
    { "code": "G125", "province": "AV", "name": "ORSARA DI PUGLIA (soppresso)" },
    { "code": "G125", "province": "FG", "name": "ORSARA DI PUGLIA" },
    { "code": "G126", "province": "CO", "name": "ORSENIGO" },
    { "code": "G127", "province": "PL", "name": "ORSERA (soppresso)" },
    { "code": "G128", "province": "CH", "name": "ORSOGNA" },
    { "code": "G129", "province": "CS", "name": "ORSOMARSO" },
    { "code": "G130", "province": "CE", "name": "ORTA DI ATELLA" },
    { "code": "G130", "province": "NA", "name": "ORTA DI ATELLA (soppresso)" },
    { "code": "G131", "province": "FG", "name": "ORTA NOVA" },
    { "code": "G132", "province": "NO", "name": "ORTA NOVARESE (soppresso)" },
    { "code": "G134", "province": "NO", "name": "ORTA SAN GIULIO" },
    { "code": "G133", "province": "CA", "name": "ORTACESUS (soppresso)" },
    { "code": "G133", "province": "SU", "name": "ORTACESUS" },
    { "code": "G135", "province": "RM", "name": "ORTE (soppresso)" },
    { "code": "G135", "province": "VT", "name": "ORTE" },
    { "code": "G136", "province": "LE", "name": "ORTELLE" },
    { "code": "G137", "province": "AP", "name": "ORTEZZANO (soppresso)" },
    { "code": "G137", "province": "FM", "name": "ORTEZZANO" },
    { "code": "G138", "province": "RC", "name": "ORTI (soppresso)" },
    { "code": "G139", "province": "AR", "name": "ORTIGNANO RAGGIOLO" },
    { "code": "G140", "province": "TN", "name": "ORTISEI (soppresso)" },
    { "code": "G140", "province": "BZ", "name": "ORTISEI" },
    { "code": "F479", "province": "SA", "name": "ORTODONICO (soppresso)" },
    { "code": "G141", "province": "CH", "name": "ORTONA" },
    { "code": "G142", "province": "AQ", "name": "ORTONA DEI MARSI" },
    { "code": "G143", "province": "GE", "name": "ORTONOVO (soppresso)" },
    { "code": "G143", "province": "SP", "name": "ORTONOVO (soppresso)" },
    { "code": "G144", "province": "GE", "name": "ORTOVERO (soppresso)" },
    { "code": "G144", "province": "SV", "name": "ORTOVERO" },
    { "code": "G145", "province": "AQ", "name": "ORTUCCHIO" },
    { "code": "G146", "province": "CA", "name": "ORTUERI (soppresso)" },
    { "code": "G146", "province": "NU", "name": "ORTUERI" },
    { "code": "G147", "province": "SS", "name": "ORUNE (soppresso)" },
    { "code": "G147", "province": "NU", "name": "ORUNE" },
    { "code": "G148", "province": "PG", "name": "ORVIETO (soppresso)" },
    { "code": "G148", "province": "TR", "name": "ORVIETO" },
    { "code": "B595", "province": "PG", "name": "ORVINIO (soppresso)" },
    { "code": "B595", "province": "RM", "name": "ORVINIO (soppresso)" },
    { "code": "B595", "province": "RI", "name": "ORVINIO" },
    { "code": "G149", "province": "BS", "name": "ORZINUOVI" },
    { "code": "G150", "province": "BS", "name": "ORZIVECCHI" },
    { "code": "G151", "province": "TO", "name": "OSASCO" },
    { "code": "G152", "province": "TO", "name": "OSASIO" },
    { "code": "G153", "province": "SS", "name": "OSCHIRI" },
    { "code": "G153", "province": "OT", "name": "OSCHIRI (soppresso)" },
    { "code": "G154", "province": "SS", "name": "OSIDDA (soppresso)" },
    { "code": "G154", "province": "NU", "name": "OSIDDA" },
    { "code": "G155", "province": "GE", "name": "OSIGLIA (soppresso)" },
    { "code": "G155", "province": "SV", "name": "OSIGLIA" },
    { "code": "G156", "province": "SS", "name": "OSILO" },
    { "code": "G157", "province": "AN", "name": "OSIMO" },
    { "code": "G158", "province": "CA", "name": "OSINI (soppresso)" },
    { "code": "G158", "province": "NU", "name": "OSINI" },
    { "code": "G158", "province": "OG", "name": "OSINI (soppresso)" },
    { "code": "G159", "province": "BG", "name": "OSIO SOPRA" },
    { "code": "G160", "province": "BG", "name": "OSIO SOTTO" },
    { "code": "E529", "province": "VA", "name": "OSMATE (soppresso)" },
    { "code": "E529", "province": "CO", "name": "OSMATE LENTATE (soppresso)" },
    { "code": "E529", "province": "VA", "name": "OSMATE LENTATE (soppresso)" },
    { "code": "G161", "province": "CO", "name": "OSNAGO (soppresso)" },
    { "code": "G161", "province": "LC", "name": "OSNAGO" },
    { "code": "G163", "province": "UD", "name": "OSOPPO" },
    { "code": "G164", "province": "IM", "name": "OSPEDALETTI" },
    { "code": "G168", "province": "TN", "name": "OSPEDALETTO" },
    { "code": "G165", "province": "AV", "name": "OSPEDALETTO D'ALPINOLO" },
    { "code": "G167", "province": "PD", "name": "OSPEDALETTO EUGANEO" },
    { "code": "G166", "province": "MI", "name": "OSPEDALETTO LODIGIANO (soppresso)" },
    { "code": "G166", "province": "LO", "name": "OSPEDALETTO LODIGIANO" },
    { "code": "G169", "province": "BL", "name": "OSPITALE (soppresso)" },
    { "code": "G169", "province": "BL", "name": "OSPITALE DI CADORE" },
    { "code": "G170", "province": "BS", "name": "OSPITALETTO" },
    { "code": "G171", "province": "MI", "name": "OSSAGO LODIGIANO (soppresso)" },
    { "code": "G171", "province": "LO", "name": "OSSAGO LODIGIANO" },
    { "code": "G173", "province": "TN", "name": "OSSANA" },
    { "code": "G174", "province": "BG", "name": "OSSANESGA (soppresso)" },
    { "code": "G175", "province": "UD", "name": "OSSECCA VITTUGLIE (soppresso)" },
    { "code": "G175", "province": "GO", "name": "OSSECCA VITTUGLIE (soppresso)" },
    { "code": "G175", "province": "GO", "name": "OSSECH-VITTUGLIE (soppresso)" },
    { "code": "G175", "province": "UD", "name": "OSSECH-VITTUGLIE (soppresso)" },
    { "code": "G176", "province": "GO", "name": "OSSEGLIANO SAN MICHELE (soppresso)" },
    { "code": "G176", "province": "UD", "name": "OSSEGLIANO SAN MICHELE (soppresso)" },
    { "code": "G177", "province": "PL", "name": "OSSERO (soppresso)" },
    { "code": "G178", "province": "SS", "name": "OSSI" },
    { "code": "G179", "province": "BS", "name": "OSSIMO" },
    { "code": "G180", "province": "CR", "name": "OSSOLARO (soppresso)" },
    { "code": "G181", "province": "MI", "name": "OSSONA" },
    { "code": "G182", "province": "CO", "name": "OSSUCCIO (soppresso)" },
    { "code": "G183", "province": "CN", "name": "OSTANA" },
    { "code": "G184", "province": "FE", "name": "OSTELLATO" },
    { "code": "G185", "province": "CR", "name": "OSTIANO" },
    { "code": "G186", "province": "MN", "name": "OSTIGLIA" },
    { "code": "F401", "province": "AN", "name": "OSTRA" },
    { "code": "F581", "province": "AN", "name": "OSTRA VETERE" },
    { "code": "G187", "province": "LE", "name": "OSTUNI (soppresso)" },
    { "code": "G187", "province": "BR", "name": "OSTUNI" },
    { "code": "G188", "province": "LE", "name": "OTRANTO" },
    { "code": "G189", "province": "PG", "name": "OTRICOLI (soppresso)" },
    { "code": "G189", "province": "TR", "name": "OTRICOLI" },
    { "code": "G190", "province": "NA", "name": "OTTAIANO (soppresso)" },
    { "code": "G191", "province": "SS", "name": "OTTANA (soppresso)" },
    { "code": "G191", "province": "NU", "name": "OTTANA" },
    { "code": "G192", "province": "SA", "name": "OTTATI" },
    { "code": "G190", "province": "NA", "name": "OTTAVIANO" },
    { "code": "G193", "province": "AL", "name": "OTTIGLIO" },
    { "code": "G194", "province": "PV", "name": "OTTOBIANO" },
    { "code": "G195", "province": "PV", "name": "OTTONE (soppresso)" },
    { "code": "G195", "province": "PC", "name": "OTTONE" },
    { "code": "G196", "province": "TO", "name": "OULX" },
    { "code": "G197", "province": "AL", "name": "OVADA" },
    { "code": "G198", "province": "UD", "name": "OVARO" },
    { "code": "G199", "province": "AL", "name": "OVIGLIO" },
    { "code": "G200", "province": "AQ", "name": "OVINDOLI" },
    { "code": "G201", "province": "SS", "name": "OVODDA (soppresso)" },
    { "code": "G201", "province": "NU", "name": "OVODDA" },
    { "code": "G012", "province": "TO", "name": "OYACE (soppresso)" },
    { "code": "G012", "province": "AO", "name": "OYACE" },
    { "code": "G202", "province": "TO", "name": "OZEGNA" },
    { "code": "G202", "province": "AO", "name": "OZEGNA (soppresso)" },
    { "code": "G203", "province": "SS", "name": "OZIERI" },
    { "code": "G205", "province": "BO", "name": "OZZANO DELL'EMILIA" },
    { "code": "G204", "province": "AL", "name": "OZZANO MONFERRATO" },
    { "code": "G206", "province": "MI", "name": "OZZERO" },
    { "code": "G207", "province": "CA", "name": "PABILLONIS (soppresso)" },
    { "code": "G207", "province": "VS", "name": "PABILLONIS (soppresso)" },
    { "code": "G207", "province": "SU", "name": "PABILLONIS" },
    { "code": "G209", "province": "ME", "name": "PACE DEL MELA" },
    { "code": "G208", "province": "TP", "name": "PACECO" },
    { "code": "G210", "province": "AQ", "name": "PACENTRO" },
    { "code": "G211", "province": "SR", "name": "PACHINO" },
    { "code": "G212", "province": "PG", "name": "PACIANO" },
    { "code": "G213", "province": "BS", "name": "PADENGHE (soppresso)" },
    { "code": "G213", "province": "BS", "name": "PADENGHE SUL GARDA" },
    { "code": "G214", "province": "TN", "name": "PADERGNONE (soppresso)" },
    { "code": "G215", "province": "AL", "name": "PADERNA" },
    { "code": "G216", "province": "BS", "name": "PADERNELLO (soppresso)" },
    { "code": "G219", "province": "CR", "name": "PADERNO CREMONESE (soppresso)" },
    { "code": "G218", "province": "CO", "name": "PADERNO D'ADDA (soppresso)" },
    { "code": "G218", "province": "LC", "name": "PADERNO D'ADDA" },
    { "code": "G221", "province": "TV", "name": "PADERNO D'ASOLO (soppresso)" },
    { "code": "G221", "province": "TV", "name": "PADERNO DEL GRAPPA (soppresso)" },
    { "code": "G220", "province": "MI", "name": "PADERNO DUGNANO" },
    { "code": "G217", "province": "BS", "name": "PADERNO FRANCIACORTA" },
    { "code": "G222", "province": "CR", "name": "PADERNO OSSOLARO (soppresso)" },
    { "code": "G222", "province": "CR", "name": "PADERNO PONCHIELLI" },
    { "code": "G223", "province": "CO", "name": "PADERNO ROBBIATE (soppresso)" },
    { "code": "G224", "province": "PD", "name": "PADOVA" },
    { "code": "G225", "province": "SS", "name": "PADRIA" },
    { "code": "M301", "province": "SS", "name": "PADRU" },
    { "code": "M301", "province": "OT", "name": "PADRU (soppresso)" },
    { "code": "G226", "province": "SA", "name": "PADULA" },
    { "code": "G227", "province": "BN", "name": "PADULI" },
    { "code": "G228", "province": "CN", "name": "PAESANA" },
    { "code": "G229", "province": "TV", "name": "PAESE" },
    { "code": "G230", "province": "SA", "name": "PAGANI" },
    { "code": "G231", "province": "AQ", "name": "PAGANICA (soppresso)" },
    { "code": "C782", "province": "GR", "name": "PAGANICO (soppresso)" },
    { "code": "G232", "province": "PG", "name": "PAGANICO SABINO (soppresso)" },
    { "code": "G232", "province": "RM", "name": "PAGANICO SABINO (soppresso)" },
    { "code": "G232", "province": "RI", "name": "PAGANICO SABINO" },
    { "code": "G233", "province": "BG", "name": "PAGAZZANO" },
    { "code": "G234", "province": "ME", "name": "PAGLIARA" },
    { "code": "G236", "province": "CN", "name": "PAGLIERES (soppresso)" },
    { "code": "G237", "province": "CH", "name": "PAGLIETA" },
    { "code": "G238", "province": "UD", "name": "PAGNACCO" },
    { "code": "G240", "province": "CN", "name": "PAGNO" },
    { "code": "G241", "province": "CO", "name": "PAGNONA (soppresso)" },
    { "code": "G241", "province": "LC", "name": "PAGNONA" },
    { "code": "G242", "province": "AV", "name": "PAGO DEL VALLO DI LAURO" },
    { "code": "G243", "province": "BN", "name": "PAGO VEIANO" },
    { "code": "G246", "province": "BS", "name": "PAISCO (soppresso)" },
    { "code": "G247", "province": "BS", "name": "PAISCO LOVENO" },
    { "code": "G248", "province": "BS", "name": "PAITONE" },
    { "code": "G249", "province": "BG", "name": "PALADINA" },
    { "code": "G250", "province": "MO", "name": "PALAGANO" },
    { "code": "G251", "province": "LE", "name": "PALAGIANELLO (soppresso)" },
    { "code": "G251", "province": "TA", "name": "PALAGIANELLO" },
    { "code": "G252", "province": "LE", "name": "PALAGIANO (soppresso)" },
    { "code": "G252", "province": "TA", "name": "PALAGIANO" },
    { "code": "G253", "province": "CT", "name": "PALAGONIA" },
    { "code": "G254", "province": "PI", "name": "PALAIA" },
    { "code": "G255", "province": "PR", "name": "PALANZANO" },
    { "code": "G256", "province": "CO", "name": "PALANZO (soppresso)" },
    { "code": "G257", "province": "CB", "name": "PALATA" },
    { "code": "G258", "province": "SS", "name": "PALAU" },
    { "code": "G258", "province": "OT", "name": "PALAU (soppresso)" },
    { "code": "G259", "province": "BG", "name": "PALAZZAGO" },
    { "code": "G263", "province": "PA", "name": "PALAZZO ADRIANO" },
    { "code": "G262", "province": "TO", "name": "PALAZZO CANAVESE" },
    { "code": "G262", "province": "AO", "name": "PALAZZO CANAVESE (soppresso)" },
    { "code": "G260", "province": "CR", "name": "PALAZZO PIGNANO" },
    { "code": "G269", "province": "AO", "name": "PALAZZO PIVERONE (soppresso)" },
    { "code": "G269", "province": "TO", "name": "PALAZZO PIVERONE (soppresso)" },
    { "code": "G261", "province": "PZ", "name": "PALAZZO SAN GERVASIO" },
    { "code": "G261", "province": "MT", "name": "PALAZZO SAN GERVASIO (soppresso)" },
    { "code": "G267", "province": "SR", "name": "PALAZZOLO ACREIDE" },
    { "code": "G268", "province": "UD", "name": "PALAZZOLO DELLO STELLA" },
    { "code": "G264", "province": "BS", "name": "PALAZZOLO SULL'OGLIO" },
    { "code": "G266", "province": "NO", "name": "PALAZZOLO VERCELLESE (soppresso)" },
    { "code": "G266", "province": "VC", "name": "PALAZZOLO VERCELLESE" },
    { "code": "G270", "province": "FI", "name": "PALAZZUOLO DI ROMAGNA (soppresso)" },
    { "code": "G270", "province": "FI", "name": "PALAZZUOLO SUL SENIO" },
    { "code": "G271", "province": "CH", "name": "PALENA" },
    { "code": "G272", "province": "CZ", "name": "PALERMITI" },
    { "code": "G273", "province": "PA", "name": "PALERMO" },
    { "code": "G274", "province": "RM", "name": "PALESTRINA" },
    { "code": "G275", "province": "PV", "name": "PALESTRO" },
    { "code": "G276", "province": "RM", "name": "PALIANO (soppresso)" },
    { "code": "G276", "province": "FR", "name": "PALIANO" },
    { "code": "G277", "province": "RC", "name": "PALIZZI" },
    { "code": "G278", "province": "CZ", "name": "PALLAGORIO (soppresso)" },
    { "code": "G278", "province": "KR", "name": "PALLAGORIO" },
    { "code": "G279", "province": "NO", "name": "PALLANZA (soppresso)" },
    { "code": "G280", "province": "NO", "name": "PALLANZENO (soppresso)" },
    { "code": "G280", "province": "VB", "name": "PALLANZENO" },
    { "code": "G281", "province": "GE", "name": "PALLARE (soppresso)" },
    { "code": "G281", "province": "SV", "name": "PALLARE" },
    { "code": "G283", "province": "CE", "name": "PALMA CAMPANIA (soppresso)" },
    { "code": "G283", "province": "NA", "name": "PALMA CAMPANIA" },
    { "code": "G282", "province": "AG", "name": "PALMA DI MONTECHIARO" },
    { "code": "G284", "province": "UD", "name": "PALMANOVA" },
    { "code": "G285", "province": "LE", "name": "PALMARIGGI" },
    { "code": "G286", "province": "CA", "name": "PALMAS ARBOREA (soppresso)" },
    { "code": "G286", "province": "OR", "name": "PALMAS ARBOREA" },
    { "code": "G287", "province": "CA", "name": "PALMAS SUERGIU (soppresso)" },
    { "code": "G288", "province": "RC", "name": "PALMI" },
    { "code": "G289", "province": "AP", "name": "PALMIANO" },
    { "code": "G081", "province": "PZ", "name": "PALMIRA (soppresso)" },
    { "code": "G290", "province": "CH", "name": "PALMOLI" },
    { "code": "G291", "province": "BA", "name": "PALO DEL COLLE" },
    { "code": "G293", "province": "RM", "name": "PALOMBARA SABINA" },
    { "code": "G294", "province": "CH", "name": "PALOMBARO" },
    { "code": "G292", "province": "SA", "name": "PALOMONTE" },
    { "code": "G295", "province": "BG", "name": "PALOSCO" },
    { "code": "G297", "province": "VR", "name": "PALU'" },
    { "code": "G296", "province": "TN", "name": "PALU' (soppresso)" },
    { "code": "G296", "province": "TN", "name": "PALU' DEL FERSINA" },
    { "code": "G298", "province": "CS", "name": "PALUDI" },
    { "code": "G299", "province": "TN", "name": "PALUS (soppresso)" },
    { "code": "G300", "province": "UD", "name": "PALUZZA" },
    { "code": "G301", "province": "CR", "name": "PALVARETO (soppresso)" },
    { "code": "G302", "province": "CN", "name": "PAMPARATO" },
    { "code": "G303", "province": "TO", "name": "PANCALIERI" },
    { "code": "G304", "province": "PV", "name": "PANCARANA" },
    { "code": "G305", "province": "TN", "name": "PANCHIA'" },
    { "code": "G306", "province": "CR", "name": "PANDINO" },
    { "code": "G307", "province": "CS", "name": "PANETTIERI" },
    { "code": "G308", "province": "PG", "name": "PANICALE" },
    { "code": "G310", "province": "GO", "name": "PANIQUA (soppresso)" },
    { "code": "G310", "province": "UD", "name": "PANIQUA (soppresso)" },
    { "code": "G311", "province": "BN", "name": "PANNARANO" },
    { "code": "G312", "province": "FG", "name": "PANNI" },
    { "code": "G313", "province": "TN", "name": "PANNONE (soppresso)" },
    { "code": "G314", "province": "IM", "name": "PANTASINA (soppresso)" },
    { "code": "G315", "province": "TP", "name": "PANTELLERIA" },
    { "code": "G316", "province": "MI", "name": "PANTIGLIATE" },
    { "code": "G317", "province": "CS", "name": "PAOLA" },
    { "code": "G318", "province": "BN", "name": "PAOLISI" },
    { "code": "G319", "province": "TP", "name": "PAPARELLA SAN MARCO (soppresso)" },
    { "code": "G320", "province": "CS", "name": "PAPASIDERO" },
    { "code": "G322", "province": "PG", "name": "PAPIGNO (soppresso)" },
    { "code": "G322", "province": "TR", "name": "PAPIGNO (soppresso)" },
    { "code": "G323", "province": "RO", "name": "PAPOZZE" },
    { "code": "G324", "province": "MI", "name": "PARABIAGO" },
    { "code": "G325", "province": "LE", "name": "PARABITA" },
    { "code": "G327", "province": "BS", "name": "PARATICO" },
    { "code": "G328", "province": "TN", "name": "PARCINES (soppresso)" },
    { "code": "G328", "province": "BZ", "name": "PARCINES" },
    { "code": "A239", "province": "PA", "name": "PARCO (soppresso)" },
    { "code": "G329", "province": "CO", "name": "PARE' (soppresso)" },
    { "code": "G330", "province": "TO", "name": "PARELLA" },
    { "code": "G330", "province": "AO", "name": "PARELLA (soppresso)" },
    { "code": "G331", "province": "CS", "name": "PARENTI" },
    { "code": "G332", "province": "PL", "name": "PARENZO (soppresso)" },
    { "code": "G333", "province": "CE", "name": "PARETE" },
    { "code": "G333", "province": "NA", "name": "PARETE (soppresso)" },
    { "code": "G334", "province": "AL", "name": "PARETO" },
    { "code": "G335", "province": "CZ", "name": "PARGHELIA (soppresso)" },
    { "code": "G335", "province": "VV", "name": "PARGHELIA" },
    { "code": "C782", "province": "GR", "name": "PARI (soppresso)" },
    { "code": "G336", "province": "CO", "name": "PARLASCO (soppresso)" },
    { "code": "G336", "province": "LC", "name": "PARLASCO" },
    { "code": "G337", "province": "PR", "name": "PARMA" },
    { "code": "G338", "province": "AL", "name": "PARODI LIGURE" },
    { "code": "G339", "province": "CN", "name": "PAROLDO" },
    { "code": "G340", "province": "AV", "name": "PAROLISE" },
    { "code": "G342", "province": "PV", "name": "PARONA" },
    { "code": "G341", "province": "VR", "name": "PARONA ALL'ADIGE (soppresso)" },
    { "code": "G341", "province": "VR", "name": "PARONA DI VALPOLICELLA (soppresso)" },
    { "code": "G343", "province": "NO", "name": "PARONE (soppresso)" },
    { "code": "G343", "province": "VC", "name": "PARONE (soppresso)" },
    { "code": "G344", "province": "PG", "name": "PARRANO (soppresso)" },
    { "code": "G344", "province": "TR", "name": "PARRANO" },
    { "code": "G345", "province": "CO", "name": "PARRAVICINO (soppresso)" },
    { "code": "G346", "province": "BG", "name": "PARRE" },
    { "code": "G347", "province": "TP", "name": "PARTANNA" },
    { "code": "G348", "province": "PA", "name": "PARTINICO" },
    { "code": "G349", "province": "NO", "name": "PARUZZARO" },
    { "code": "G350", "province": "BG", "name": "PARZANICA" },
    { "code": "G352", "province": "UD", "name": "PASIAN DI PRATO" },
    { "code": "A700", "province": "UD", "name": "PASIAN SCHIAVONESCO (soppresso)" },
    { "code": "G353", "province": "UD", "name": "PASIANO DI PORDENONE (soppresso)" },
    { "code": "G353", "province": "PN", "name": "PASIANO DI PORDENONE" },
    { "code": "G354", "province": "BS", "name": "PASPARDO" },
    { "code": "G357", "province": "AL", "name": "PASSERANO (soppresso)" },
    { "code": "G358", "province": "AL", "name": "PASSERANO MARMORITO (soppresso)" },
    { "code": "G358", "province": "AT", "name": "PASSERANO MARMORITO" },
    { "code": "G359", "province": "PG", "name": "PASSIGNANO (soppresso)" },
    { "code": "G359", "province": "PG", "name": "PASSIGNANO SUL TRASIMENO" },
    { "code": "G361", "province": "BS", "name": "PASSIRANO" },
    { "code": "G362", "province": "CE", "name": "PASTENA (soppresso)" },
    { "code": "G362", "province": "FR", "name": "PASTENA" },
    { "code": "G364", "province": "CE", "name": "PASTORANO" },
    { "code": "G364", "province": "NA", "name": "PASTORANO (soppresso)" },
    { "code": "G365", "province": "VR", "name": "PASTRENGO" },
    { "code": "G367", "province": "AL", "name": "PASTURANA" },
    { "code": "G368", "province": "CO", "name": "PASTURO (soppresso)" },
    { "code": "G368", "province": "LC", "name": "PASTURO" },
    { "code": "M269", "province": "PZ", "name": "PATERNO" },
    { "code": "G371", "province": "CT", "name": "PATERNO'" },
    { "code": "G372", "province": "CS", "name": "PATERNO CALABRO" },
    { "code": "G369", "province": "AN", "name": "PATERNO D'ANCONA (soppresso)" },
    { "code": "G370", "province": "AV", "name": "PATERNOPOLI" },
    { "code": "G373", "province": "TN", "name": "PATONE (soppresso)" },
    { "code": "G374", "province": "RM", "name": "PATRICA (soppresso)" },
    { "code": "G374", "province": "FR", "name": "PATRICA" },
    { "code": "G375", "province": "AP", "name": "PATRIGNONE (soppresso)" },
    { "code": "G376", "province": "SS", "name": "PATTADA" },
    { "code": "G377", "province": "ME", "name": "PATTI" },
    { "code": "G378", "province": "LE", "name": "PATU'" },
    { "code": "G379", "province": "CA", "name": "PAU (soppresso)" },
    { "code": "G379", "province": "OR", "name": "PAU" },
    { "code": "F485", "province": "PL", "name": "PAUGNANO (soppresso)" },
    { "code": "G381", "province": "UD", "name": "PAULARO" },
    { "code": "G382", "province": "CA", "name": "PAULI ARBAREI (soppresso)" },
    { "code": "G382", "province": "VS", "name": "PAULI ARBAREI (soppresso)" },
    { "code": "G382", "province": "SU", "name": "PAULI ARBAREI" },
    { "code": "F383", "province": "CA", "name": "PAULI MONSERRATO (soppresso)" },
    { "code": "F383", "province": "CA", "name": "PAULI PIRRI (soppresso)" },
    { "code": "G384", "province": "CA", "name": "PAULILATINO (soppresso)" },
    { "code": "G384", "province": "OR", "name": "PAULILATINO" },
    { "code": "G385", "province": "MI", "name": "PAULLO" },
    { "code": "G386", "province": "BN", "name": "PAUPISI" },
    { "code": "D042", "province": "MC", "name": "PAUSULA (soppresso)" },
    { "code": "G387", "province": "TO", "name": "PAVAROLO" },
    { "code": "G388", "province": "PV", "name": "PAVIA" },
    { "code": "G389", "province": "UD", "name": "PAVIA DI UDINE" },
    { "code": "G392", "province": "TO", "name": "PAVONE CANAVESE" },
    { "code": "G392", "province": "AO", "name": "PAVONE CANAVESE (soppresso)" },
    { "code": "G390", "province": "AL", "name": "PAVONE D'ALESSANDRIA (soppresso)" },
    { "code": "G391", "province": "BS", "name": "PAVONE DEL MELLA" },
    { "code": "G393", "province": "MO", "name": "PAVULLO NEL FRIGNANO" },
    { "code": "G394", "province": "RC", "name": "PAZZANO" },
    { "code": "G395", "province": "PI", "name": "PECCIOLI" },
    { "code": "G396", "province": "TO", "name": "PECCO (soppresso)" },
    { "code": "G396", "province": "AO", "name": "PECCO (soppresso)" },
    { "code": "G397", "province": "AL", "name": "PECETTO (soppresso)" },
    { "code": "G397", "province": "AL", "name": "PECETTO DI VALENZA" },
    { "code": "G398", "province": "TO", "name": "PECETTO TORINESE" },
    { "code": "G399", "province": "PC", "name": "PECORARA (soppresso)" },
    { "code": "G400", "province": "CS", "name": "PEDACE (soppresso)" },
    { "code": "G401", "province": "AO", "name": "PEDANEA (soppresso)" },
    { "code": "G401", "province": "TO", "name": "PEDANEA (soppresso)" },
    { "code": "G402", "province": "CT", "name": "PEDARA" },
    { "code": "G403", "province": "AP", "name": "PEDASO (soppresso)" },
    { "code": "G403", "province": "FM", "name": "PEDASO" },
    { "code": "G404", "province": "BL", "name": "PEDAVENA" },
    { "code": "G406", "province": "TN", "name": "PEDEMONTE (soppresso)" },
    { "code": "G406", "province": "VI", "name": "PEDEMONTE" },
    { "code": "G407", "province": "BS", "name": "PEDERGNAGA (soppresso)" },
    { "code": "G407", "province": "BS", "name": "PEDERGNAGA ORIANO (soppresso)" },
    { "code": "G408", "province": "TV", "name": "PEDEROBBA" },
    { "code": "G409", "province": "TN", "name": "PEDERZANO (soppresso)" },
    { "code": "G410", "province": "SO", "name": "PEDESINA" },
    { "code": "G411", "province": "CS", "name": "PEDIVIGLIANO" },
    { "code": "G412", "province": "BG", "name": "PEDRENGO" },
    { "code": "G414", "province": "GE", "name": "PEGLI (soppresso)" },
    { "code": "G415", "province": "CO", "name": "PEGLIO" },
    { "code": "G416", "province": "PS", "name": "PEGLIO (soppresso)" },
    { "code": "G416", "province": "PU", "name": "PEGLIO" },
    { "code": "G417", "province": "MN", "name": "PEGOGNAGA" },
    { "code": "G418", "province": "BG", "name": "PEIA" },
    { "code": "G419", "province": "TN", "name": "PEIO" },
    { "code": "G420", "province": "FI", "name": "PELAGO" },
    { "code": "G421", "province": "NO", "name": "PELLA" },
    { "code": "G422", "province": "RC", "name": "PELLARO (soppresso)" },
    { "code": "G424", "province": "PR", "name": "PELLEGRINO PARMENSE" },
    { "code": "G425", "province": "VE", "name": "PELLESTRINA (soppresso)" },
    { "code": "G426", "province": "SA", "name": "PELLEZZANO" },
    { "code": "G427", "province": "CO", "name": "PELLIO INTELVI (soppresso)" },
    { "code": "G428", "province": "TN", "name": "PELLIZZANO" },
    { "code": "G429", "province": "TN", "name": "PELUGO" },
    { "code": "G430", "province": "AL", "name": "PENANGO (soppresso)" },
    { "code": "G430", "province": "AT", "name": "PENANGO" },
    { "code": "G431", "province": "SO", "name": "PENDOLASCO (soppresso)" },
    { "code": "G432", "province": "PG", "name": "PENNA IN TEVERINA (soppresso)" },
    { "code": "G432", "province": "TR", "name": "PENNA IN TEVERINA" },
    { "code": "G436", "province": "MC", "name": "PENNA SAN GIOVANNI" },
    { "code": "G437", "province": "TE", "name": "PENNA SANT'ANDREA" },
    { "code": "G433", "province": "PS", "name": "PENNABILLI (soppresso)" },
    { "code": "G433", "province": "PU", "name": "PENNABILLI (soppresso)" },
    { "code": "G433", "province": "RN", "name": "PENNABILLI" },
    { "code": "G434", "province": "CH", "name": "PENNADOMO" },
    { "code": "G435", "province": "CH", "name": "PENNAPIEDIMONTE" },
    { "code": "G438", "province": "TE", "name": "PENNE (soppresso)" },
    { "code": "G438", "province": "PE", "name": "PENNE" },
    { "code": "C999", "province": "AQ", "name": "PENTIMA (soppresso)" },
    { "code": "G439", "province": "CZ", "name": "PENTONE" },
    { "code": "G440", "province": "CO", "name": "PENZANO (soppresso)" },
    { "code": "G441", "province": "CH", "name": "PERANO" },
    { "code": "G442", "province": "BL", "name": "PERAROLO (soppresso)" },
    { "code": "G442", "province": "BL", "name": "PERAROLO DI CADORE" },
    { "code": "G443", "province": "TN", "name": "PERCA (soppresso)" },
    { "code": "G443", "province": "BZ", "name": "PERCA" },
    { "code": "G444", "province": "RM", "name": "PERCILE" },
    { "code": "G445", "province": "CA", "name": "PERDASDEFOGU (soppresso)" },
    { "code": "G445", "province": "NU", "name": "PERDASDEFOGU" },
    { "code": "G445", "province": "OG", "name": "PERDASDEFOGU (soppresso)" },
    { "code": "G446", "province": "CA", "name": "PERDAXIUS (soppresso)" },
    { "code": "G446", "province": "CI", "name": "PERDAXIUS (soppresso)" },
    { "code": "G446", "province": "SU", "name": "PERDAXIUS" },
    { "code": "G447", "province": "SA", "name": "PERDIFUMO" },
    { "code": "G448", "province": "CO", "name": "PEREGO (soppresso)" },
    { "code": "G448", "province": "LC", "name": "PEREGO (soppresso)" },
    { "code": "G449", "province": "AQ", "name": "PERETO" },
    { "code": "G450", "province": "SS", "name": "PERFUGAS" },
    { "code": "G443", "province": "TN", "name": "PERGA (soppresso)" },
    { "code": "G451", "province": "AR", "name": "PERGINE (soppresso)" },
    { "code": "G452", "province": "TN", "name": "PERGINE (soppresso)" },
    { "code": "G451", "province": "AR", "name": "PERGINE VALDARNO (soppresso)" },
    { "code": "G452", "province": "TN", "name": "PERGINE VALSUGANA" },
    { "code": "G453", "province": "PS", "name": "PERGOLA (soppresso)" },
    { "code": "G453", "province": "PU", "name": "PERGOLA" },
    { "code": "G454", "province": "IM", "name": "PERINALDO" },
    { "code": "G455", "province": "SA", "name": "PERITO" },
    { "code": "G456", "province": "CO", "name": "PERLEDO (soppresso)" },
    { "code": "G456", "province": "LC", "name": "PERLEDO" },
    { "code": "G457", "province": "CN", "name": "PERLETTO" },
    { "code": "G458", "province": "CN", "name": "PERLO" },
    { "code": "G459", "province": "TO", "name": "PERLOZ (soppresso)" },
    { "code": "G459", "province": "AO", "name": "PERLOZ" },
    { "code": "G460", "province": "CN", "name": "PERNO (soppresso)" },
    { "code": "G461", "province": "PD", "name": "PERNUMIA" },
    { "code": "C013", "province": "MI", "name": "PERO" },
    { "code": "G463", "province": "TO", "name": "PEROSA ARGENTINA" },
    { "code": "G462", "province": "TO", "name": "PEROSA CANAVESE" },
    { "code": "G462", "province": "AO", "name": "PEROSA CANAVESE (soppresso)" },
    { "code": "G464", "province": "TN", "name": "PERRA (soppresso)" },
    { "code": "G465", "province": "TO", "name": "PERRERO" },
    { "code": "G467", "province": "BO", "name": "PERSICETO (soppresso)" },
    { "code": "G468", "province": "CR", "name": "PERSICO (soppresso)" },
    { "code": "G469", "province": "CR", "name": "PERSICO DOSIMO" },
    { "code": "G470", "province": "TN", "name": "PERSONE (soppresso)" },
    { "code": "G471", "province": "NO", "name": "PERTENGO (soppresso)" },
    { "code": "G471", "province": "VC", "name": "PERTENGO" },
    { "code": "G472", "province": "UD", "name": "PERTEOLE (soppresso)" },
    { "code": "G474", "province": "BS", "name": "PERTICA ALTA" },
    { "code": "G475", "province": "BS", "name": "PERTICA BASSA" },
    { "code": "G476", "province": "SA", "name": "PERTOSA" },
    { "code": "G477", "province": "TO", "name": "PERTUSIO" },
    { "code": "G477", "province": "AO", "name": "PERTUSIO (soppresso)" },
    { "code": "G478", "province": "PG", "name": "PERUGIA" },
    { "code": "H054", "province": "GO", "name": "PERVACINA (soppresso)" },
    { "code": "H054", "province": "UD", "name": "PERVACINA (soppresso)" },
    { "code": "G479", "province": "PS", "name": "PESARO (soppresso)" },
    { "code": "G479", "province": "PU", "name": "PESARO" },
    { "code": "G480", "province": "LU", "name": "PESCAGLIA" },
    { "code": "G481", "province": "VR", "name": "PESCANTINA" },
    { "code": "G482", "province": "CH", "name": "PESCARA (soppresso)" },
    { "code": "G482", "province": "PE", "name": "PESCARA" },
    { "code": "G483", "province": "CR", "name": "PESCAROLO ED UNITI" },
    { "code": "G484", "province": "AQ", "name": "PESCASSEROLI" },
    { "code": "G485", "province": "CO", "name": "PESCATE (soppresso)" },
    { "code": "G485", "province": "LC", "name": "PESCATE" },
    { "code": "G486", "province": "CB", "name": "PESCHE (soppresso)" },
    { "code": "G486", "province": "IS", "name": "PESCHE" },
    { "code": "G487", "province": "FG", "name": "PESCHICI" },
    { "code": "G488", "province": "MI", "name": "PESCHIERA BORROMEO" },
    { "code": "G489", "province": "VR", "name": "PESCHIERA DEL GARDA" },
    { "code": "G490", "province": "BS", "name": "PESCHIERA MARAGLIO (soppresso)" },
    { "code": "G489", "province": "VR", "name": "PESCHIERA SUL LAGO DI GARDA (soppresso)" },
    { "code": "G491", "province": "LU", "name": "PESCIA (soppresso)" },
    { "code": "G491", "province": "PT", "name": "PESCIA" },
    { "code": "G492", "province": "AQ", "name": "PESCINA" },
    { "code": "G494", "province": "BN", "name": "PESCO SANNITA" },
    { "code": "G493", "province": "AQ", "name": "PESCOCOSTANZO" },
    { "code": "G494", "province": "BN", "name": "PESCOLAMAZZA (soppresso)" },
    { "code": "G495", "province": "CB", "name": "PESCOLANCIANO (soppresso)" },
    { "code": "G495", "province": "IS", "name": "PESCOLANCIANO" },
    { "code": "G496", "province": "PZ", "name": "PESCOPAGANO" },
    { "code": "G497", "province": "CB", "name": "PESCOPENNATARO (soppresso)" },
    { "code": "G497", "province": "IS", "name": "PESCOPENNATARO" },
    { "code": "G498", "province": "AQ", "name": "PESCOROCCHIANO (soppresso)" },
    { "code": "G498", "province": "RI", "name": "PESCOROCCHIANO" },
    { "code": "G499", "province": "TE", "name": "PESCOSANSONESCO (soppresso)" },
    { "code": "G499", "province": "PE", "name": "PESCOSANSONESCO" },
    { "code": "G500", "province": "CE", "name": "PESCOSOLIDO (soppresso)" },
    { "code": "G500", "province": "FR", "name": "PESCOSOLIDO" },
    { "code": "G502", "province": "MI", "name": "PESSANO CON BORNAGO" },
    { "code": "G504", "province": "CR", "name": "PESSINA CREMONESE" },
    { "code": "G503", "province": "CO", "name": "PESSINA VALSASSINA (soppresso)" },
    { "code": "G505", "province": "TO", "name": "PESSINETTO" },
    { "code": "G506", "province": "CB", "name": "PETACCIATO" },
    { "code": "G507", "province": "PG", "name": "PETESCIA (soppresso)" },
    { "code": "G507", "province": "RM", "name": "PETESCIA (soppresso)" },
    { "code": "G507", "province": "RI", "name": "PETESCIA (soppresso)" },
    { "code": "G508", "province": "CZ", "name": "PETILIA POLICASTRO (soppresso)" },
    { "code": "G508", "province": "KR", "name": "PETILIA POLICASTRO" },
    { "code": "G509", "province": "SA", "name": "PETINA" },
    { "code": "G510", "province": "PA", "name": "PETRALIA SOPRANA" },
    { "code": "G511", "province": "PA", "name": "PETRALIA SOTTANA" },
    { "code": "G513", "province": "AQ", "name": "PETRELLA SALTO (soppresso)" },
    { "code": "G513", "province": "RI", "name": "PETRELLA SALTO" },
    { "code": "G512", "province": "CB", "name": "PETRELLA TIFERNINA" },
    { "code": "G514", "province": "PS", "name": "PETRIANO (soppresso)" },
    { "code": "G514", "province": "PU", "name": "PETRIANO" },
    { "code": "G515", "province": "MC", "name": "PETRIOLO" },
    { "code": "G516", "province": "AP", "name": "PETRITOLI (soppresso)" },
    { "code": "G516", "province": "FM", "name": "PETRITOLI" },
    { "code": "G517", "province": "CZ", "name": "PETRIZZI" },
    { "code": "G518", "province": "CZ", "name": "PETRONA'" },
    { "code": "M281", "province": "TP", "name": "PETROSINO" },
    { "code": "G519", "province": "AV", "name": "PETRURO (soppresso)" },
    { "code": "G519", "province": "AV", "name": "PETRURO IRPINO" },
    { "code": "G520", "province": "NO", "name": "PETTENASCO" },
    { "code": "G521", "province": "NO", "name": "PETTINENGO (soppresso)" },
    { "code": "G521", "province": "VC", "name": "PETTINENGO (soppresso)" },
    { "code": "G521", "province": "BI", "name": "PETTINENGO" },
    { "code": "G522", "province": "ME", "name": "PETTINEO" },
    { "code": "G523", "province": "CB", "name": "PETTORANELLO DEL MOLISE (soppresso)" },
    { "code": "G523", "province": "IS", "name": "PETTORANELLO DEL MOLISE" },
    { "code": "G523", "province": "CB", "name": "PETTORANELLO DI MOLISE (soppresso)" },
    { "code": "G524", "province": "AQ", "name": "PETTORANO SUL GIZIO" },
    { "code": "G525", "province": "RO", "name": "PETTORAZZA GRIMANI" },
    { "code": "G526", "province": "CN", "name": "PEVERAGNO" },
    { "code": "G528", "province": "NO", "name": "PEZZANA (soppresso)" },
    { "code": "G528", "province": "VC", "name": "PEZZANA" },
    { "code": "G529", "province": "BS", "name": "PEZZAZE" },
    { "code": "G532", "province": "CN", "name": "PEZZOLO VALLE UZZONE" },
    { "code": "G533", "province": "BS", "name": "PEZZORO (soppresso)" },
    { "code": "G535", "province": "PC", "name": "PIACENZA" },
    { "code": "G534", "province": "PD", "name": "PIACENZA D'ADIGE" },
    { "code": "G536", "province": "CR", "name": "PIADENA (soppresso)" },
    { "code": "M418", "province": "CR", "name": "PIADENA DRIZZONA" },
    { "code": "G537", "province": "PS", "name": "PIAGGE (soppresso)" },
    { "code": "G537", "province": "PU", "name": "PIAGGE (soppresso)" },
    { "code": "G538", "province": "SA", "name": "PIAGGINE" },
    { "code": "G539", "province": "SA", "name": "PIAGGINE SOPRANE (soppresso)" },
    { "code": "G546", "province": "BS", "name": "PIAN CAMUNO" },
    { "code": "G550", "province": "BS", "name": "PIAN D'ARTOGNE (soppresso)" },
    { "code": "G566", "province": "BO", "name": "PIAN DEL VOGLIO (soppresso)" },
    { "code": "G552", "province": "AR", "name": "PIAN DI SCO (soppresso)" },
    { "code": "G562", "province": "BG", "name": "PIAN GAIANO (soppresso)" },
    { "code": "G542", "province": "GE", "name": "PIANA CRIXIA (soppresso)" },
    { "code": "G542", "province": "SV", "name": "PIANA CRIXIA" },
    { "code": "G543", "province": "PA", "name": "PIANA DEGLI ALBANESI" },
    { "code": "G543", "province": "PA", "name": "PIANA DEI GRECI (soppresso)" },
    { "code": "G541", "province": "CE", "name": "PIANA DI CAIAZZO (soppresso)" },
    { "code": "G541", "province": "BN", "name": "PIANA DI CAIAZZO (soppresso)" },
    { "code": "G541", "province": "CE", "name": "PIANA DI MONTE VERNA" },
    { "code": "G544", "province": "IM", "name": "PIANAVIA (soppresso)" },
    { "code": "G545", "province": "AO", "name": "PIANBOSETO (soppresso)" },
    { "code": "G547", "province": "SI", "name": "PIANCASTAGNAIO" },
    { "code": "G548", "province": "NO", "name": "PIANCERI (soppresso)" },
    { "code": "G548", "province": "VC", "name": "PIANCERI (soppresso)" },
    { "code": "G549", "province": "BS", "name": "PIANCOGNO" },
    { "code": "F136", "province": "PS", "name": "PIANDICASTELLO (soppresso)" },
    { "code": "G551", "province": "PS", "name": "PIANDIMELETO (soppresso)" },
    { "code": "G551", "province": "PU", "name": "PIANDIMELETO" },
    { "code": "G553", "province": "CS", "name": "PIANE CRATI" },
    { "code": "G554", "province": "NO", "name": "PIANE DI SERRAVALLE SESIA (soppresso)" },
    { "code": "G554", "province": "NO", "name": "PIANE SESIA (soppresso)" },
    { "code": "G554", "province": "VC", "name": "PIANE SESIA (soppresso)" },
    { "code": "G555", "province": "TE", "name": "PIANELLA (soppresso)" },
    { "code": "G555", "province": "PE", "name": "PIANELLA" },
    { "code": "G556", "province": "CO", "name": "PIANELLO DEL LARIO" },
    { "code": "G557", "province": "PC", "name": "PIANELLO VAL TIDONE" },
    { "code": "G558", "province": "CR", "name": "PIANENGO" },
    { "code": "G559", "province": "TO", "name": "PIANEZZA" },
    { "code": "G560", "province": "VI", "name": "PIANEZZE" },
    { "code": "G561", "province": "CN", "name": "PIANFEI" },
    { "code": "G563", "province": "IM", "name": "PIANI (soppresso)" },
    { "code": "G564", "province": "BG", "name": "PIANICO" },
    { "code": "G565", "province": "VE", "name": "PIANIGA" },
    { "code": "G569", "province": "TN", "name": "PIANO (soppresso)" },
    { "code": "G568", "province": "NA", "name": "PIANO DI SORRENTO" },
    { "code": "F766", "province": "TN", "name": "PIANO IN PASSERIA (soppresso)" },
    { "code": "G567", "province": "CO", "name": "PIANO PORLEZZA (soppresso)" },
    { "code": "D546", "province": "CZ", "name": "PIANOPOLI" },
    { "code": "G570", "province": "BO", "name": "PIANORO" },
    { "code": "G571", "province": "RM", "name": "PIANSANO (soppresso)" },
    { "code": "G571", "province": "VT", "name": "PIANSANO" },
    { "code": "G572", "province": "SO", "name": "PIANTEDO" },
    { "code": "G573", "province": "NA", "name": "PIANURA (soppresso)" },
    { "code": "G574", "province": "BG", "name": "PIARIO" },
    { "code": "G575", "province": "CN", "name": "PIASCO" },
    { "code": "G576", "province": "SO", "name": "PIATEDA" },
    { "code": "G577", "province": "NO", "name": "PIATTO (soppresso)" },
    { "code": "G577", "province": "VC", "name": "PIATTO (soppresso)" },
    { "code": "G577", "province": "BI", "name": "PIATTO" },
    { "code": "G578", "province": "TV", "name": "PIAVON (soppresso)" },
    { "code": "G582", "province": "MS", "name": "PIAZZA AL SERCHIO (soppresso)" },
    { "code": "G582", "province": "LU", "name": "PIAZZA AL SERCHIO" },
    { "code": "G580", "province": "CL", "name": "PIAZZA ARMERINA (soppresso)" },
    { "code": "G580", "province": "EN", "name": "PIAZZA ARMERINA" },
    { "code": "G579", "province": "BG", "name": "PIAZZA BREMBANA" },
    { "code": "G581", "province": "CO", "name": "PIAZZA SANTO STEFANO (soppresso)" },
    { "code": "G583", "province": "BG", "name": "PIAZZATORRE" },
    { "code": "G584", "province": "TO", "name": "PIAZZO (soppresso)" },
    { "code": "G585", "province": "BG", "name": "PIAZZO ALTO (soppresso)" },
    { "code": "G586", "province": "BG", "name": "PIAZZO BASSO (soppresso)" },
    { "code": "G587", "province": "PD", "name": "PIAZZOLA SUL BRENTA" },
    { "code": "G588", "province": "BG", "name": "PIAZZOLO" },
    { "code": "G589", "province": "TE", "name": "PICCIANO (soppresso)" },
    { "code": "G589", "province": "PE", "name": "PICCIANO" },
    { "code": "G590", "province": "PZ", "name": "PICERNO" },
    { "code": "G591", "province": "CE", "name": "PICINISCO (soppresso)" },
    { "code": "G591", "province": "FR", "name": "PICINISCO" },
    { "code": "G592", "province": "CE", "name": "PICO (soppresso)" },
    { "code": "G592", "province": "FR", "name": "PICO" },
    { "code": "G593", "province": "AL", "name": "PIEA (soppresso)" },
    { "code": "G593", "province": "AT", "name": "PIEA" },
    { "code": "G594", "province": "NO", "name": "PIEDICAVALLO (soppresso)" },
    { "code": "G594", "province": "VC", "name": "PIEDICAVALLO (soppresso)" },
    { "code": "G594", "province": "BI", "name": "PIEDICAVALLO" },
    { "code": "G595", "province": "PG", "name": "PIEDILUCO (soppresso)" },
    { "code": "G595", "province": "TR", "name": "PIEDILUCO (soppresso)" },
    { "code": "G596", "province": "CE", "name": "PIEDIMONTE D'ALIFE (soppresso)" },
    { "code": "G596", "province": "BN", "name": "PIEDIMONTE D'ALIFE (soppresso)" },
    { "code": "G599", "province": "UD", "name": "PIEDIMONTE DEL CALVARIO (soppresso)" },
    { "code": "G599", "province": "GO", "name": "PIEDIMONTE DEL CALVARIO (soppresso)" },
    { "code": "G597", "province": "CT", "name": "PIEDIMONTE ETNEO" },
    { "code": "G596", "province": "CE", "name": "PIEDIMONTE MATESE" },
    { "code": "G598", "province": "CE", "name": "PIEDIMONTE SAN GERMANO (soppresso)" },
    { "code": "G598", "province": "FR", "name": "PIEDIMONTE SAN GERMANO" },
    { "code": "G600", "province": "NO", "name": "PIEDIMULERA (soppresso)" },
    { "code": "G600", "province": "VB", "name": "PIEDIMULERA" },
    { "code": "G601", "province": "PG", "name": "PIEGARO" },
    { "code": "G602", "province": "SI", "name": "PIENZA" },
    { "code": "G603", "province": "CR", "name": "PIERANICA" },
    { "code": "G612", "province": "PV", "name": "PIETRA DE' GIORGI" },
    { "code": "G617", "province": "PV", "name": "PIETRA GAVINA (soppresso)" },
    { "code": "G605", "province": "GE", "name": "PIETRA LIGURE (soppresso)" },
    { "code": "G605", "province": "SV", "name": "PIETRA LIGURE" },
    { "code": "G619", "province": "AL", "name": "PIETRA MARAZZI" },
    { "code": "G606", "province": "CB", "name": "PIETRABBONDANTE (soppresso)" },
    { "code": "G606", "province": "IS", "name": "PIETRABBONDANTE" },
    { "code": "G607", "province": "IM", "name": "PIETRABRUNA" },
    { "code": "G608", "province": "TE", "name": "PIETRACAMELA" },
    { "code": "G609", "province": "CB", "name": "PIETRACATELLA" },
    { "code": "G610", "province": "CB", "name": "PIETRACUPA" },
    { "code": "G611", "province": "AV", "name": "PIETRADEFUSI" },
    { "code": "G613", "province": "CH", "name": "PIETRAFERRAZZANA" },
    { "code": "G615", "province": "CS", "name": "PIETRAFITTA" },
    { "code": "G616", "province": "PZ", "name": "PIETRAGALLA" },
    { "code": "G618", "province": "PG", "name": "PIETRALUNGA" },
    { "code": "G620", "province": "CE", "name": "PIETRAMELARA" },
    { "code": "G620", "province": "NA", "name": "PIETRAMELARA (soppresso)" },
    { "code": "G604", "province": "FG", "name": "PIETRAMONTECORVINO" },
    { "code": "G621", "province": "TE", "name": "PIETRANICO (soppresso)" },
    { "code": "G621", "province": "PE", "name": "PIETRANICO" },
    { "code": "G622", "province": "CS", "name": "PIETRAPAOLA" },
    { "code": "G623", "province": "PZ", "name": "PIETRAPERTOSA" },
    { "code": "G624", "province": "CL", "name": "PIETRAPERZIA (soppresso)" },
    { "code": "G624", "province": "EN", "name": "PIETRAPERZIA" },
    { "code": "G625", "province": "CN", "name": "PIETRAPORZIO" },
    { "code": "G626", "province": "BN", "name": "PIETRAROJA" },
    { "code": "G627", "province": "PS", "name": "PIETRARUBBIA (soppresso)" },
    { "code": "G627", "province": "PU", "name": "PIETRARUBBIA" },
    { "code": "G628", "province": "LU", "name": "PIETRASANTA" },
    { "code": "G629", "province": "AV", "name": "PIETRASTORNINA" },
    { "code": "G630", "province": "CE", "name": "PIETRAVAIRANO" },
    { "code": "G630", "province": "NA", "name": "PIETRAVAIRANO (soppresso)" },
    { "code": "G631", "province": "BN", "name": "PIETRELCINA" },
    { "code": "G636", "province": "LU", "name": "PIEVE A NIEVOLE (soppresso)" },
    { "code": "G636", "province": "PT", "name": "PIEVE A NIEVOLE" },
    { "code": "G635", "province": "PV", "name": "PIEVE ALBIGNOLA" },
    { "code": "G638", "province": "BL", "name": "PIEVE D'ALPAGO (soppresso)" },
    { "code": "G639", "province": "PV", "name": "PIEVE DEL CAIRO" },
    { "code": "M422", "province": "TV", "name": "PIEVE DEL GRAPPA" },
    { "code": "G640", "province": "CR", "name": "PIEVE DELMONA (soppresso)" },
    { "code": "G641", "province": "TN", "name": "PIEVE DI BONO (soppresso)" },
    { "code": "M365", "province": "TN", "name": "PIEVE DI BONO-PREZZO" },
    { "code": "G642", "province": "BL", "name": "PIEVE DI CADORE" },
    { "code": "G643", "province": "FE", "name": "PIEVE DI CENTO (soppresso)" },
    { "code": "G643", "province": "BO", "name": "PIEVE DI CENTO" },
    { "code": "G633", "province": "MN", "name": "PIEVE DI CORIANO (soppresso)" },
    { "code": "G644", "province": "TN", "name": "PIEVE DI LEDRO (soppresso)" },
    { "code": "G645", "province": "TV", "name": "PIEVE DI SOLIGO" },
    { "code": "G646", "province": "GE", "name": "PIEVE DI SORI (soppresso)" },
    { "code": "G632", "province": "IM", "name": "PIEVE DI TECO" },
    { "code": "G647", "province": "CR", "name": "PIEVE D'OLMI" },
    { "code": "G634", "province": "MI", "name": "PIEVE EMANUELE" },
    { "code": "G096", "province": "MI", "name": "PIEVE FISSIRAGA (soppresso)" },
    { "code": "G096", "province": "LO", "name": "PIEVE FISSIRAGA" },
    { "code": "G648", "province": "MS", "name": "PIEVE FOSCIANA (soppresso)" },
    { "code": "G648", "province": "LU", "name": "PIEVE FOSCIANA" },
    { "code": "G646", "province": "GE", "name": "PIEVE LIGURE" },
    { "code": "G650", "province": "PV", "name": "PIEVE PORTO MORONE" },
    { "code": "G651", "province": "CR", "name": "PIEVE SAN GIACOMO" },
    { "code": "G653", "province": "AR", "name": "PIEVE SANTO STEFANO" },
    { "code": "G656", "province": "TN", "name": "PIEVE TESINO" },
    { "code": "G657", "province": "MC", "name": "PIEVE TORINA" },
    { "code": "G658", "province": "NO", "name": "PIEVE VERGONTE (soppresso)" },
    { "code": "G658", "province": "VB", "name": "PIEVE VERGONTE" },
    { "code": "G637", "province": "MC", "name": "PIEVEBOVIGLIANA (soppresso)" },
    { "code": "G649", "province": "MO", "name": "PIEVEPELAGO" },
    { "code": "G659", "province": "RM", "name": "PIGLIO (soppresso)" },
    { "code": "G659", "province": "FR", "name": "PIGLIO" },
    { "code": "G660", "province": "IM", "name": "PIGNA" },
    { "code": "G662", "province": "CE", "name": "PIGNATARO INTERAMNA (soppresso)" },
    { "code": "G662", "province": "FR", "name": "PIGNATARO INTERAMNA" },
    { "code": "G661", "province": "CE", "name": "PIGNATARO MAGGIORE" },
    { "code": "G661", "province": "NA", "name": "PIGNATARO MAGGIORE (soppresso)" },
    { "code": "G663", "province": "PZ", "name": "PIGNOLA" },
    { "code": "G663", "province": "PZ", "name": "PIGNOLA DI BASILICATA (soppresso)" },
    { "code": "G664", "province": "GE", "name": "PIGNONE (soppresso)" },
    { "code": "G664", "province": "SP", "name": "PIGNONE" },
    { "code": "G665", "province": "CO", "name": "PIGRA" },
    { "code": "G666", "province": "NO", "name": "PILA (soppresso)" },
    { "code": "G666", "province": "VC", "name": "PILA" },
    { "code": "G667", "province": "TN", "name": "PILCANTE (soppresso)" },
    { "code": "G668", "province": "BS", "name": "PILZONE (soppresso)" },
    { "code": "G669", "province": "CA", "name": "PIMENTEL (soppresso)" },
    { "code": "G669", "province": "SU", "name": "PIMENTEL" },
    { "code": "G670", "province": "NA", "name": "PIMONTE" },
    { "code": "G671", "province": "PV", "name": "PINAROLO PO" },
    { "code": "G672", "province": "TO", "name": "PINASCA" },
    { "code": "G673", "province": "RO", "name": "PINCARA" },
    { "code": "G674", "province": "TO", "name": "PINEROLO" },
    { "code": "F831", "province": "TE", "name": "PINETO" },
    { "code": "G675", "province": "PL", "name": "PINGUENTE (soppresso)" },
    { "code": "G676", "province": "AL", "name": "PINO D'ASTI (soppresso)" },
    { "code": "G676", "province": "AT", "name": "PINO D'ASTI" },
    { "code": "G677", "province": "CO", "name": "PINO SULLA SPONDA DEL LAGO MAGGIORE (soppresso)" },
    { "code": "G677", "province": "VA", "name": "PINO SULLA SPONDA DEL LAGO MAGGIORE (soppresso)" },
    { "code": "G678", "province": "TO", "name": "PINO TORINESE" },
    { "code": "G680", "province": "UD", "name": "PINZANO AL TAGLIAMENTO (soppresso)" },
    { "code": "G680", "province": "PN", "name": "PINZANO AL TAGLIAMENTO" },
    { "code": "G681", "province": "TN", "name": "PINZOLO" },
    { "code": "G682", "province": "PS", "name": "PIOBBICO (soppresso)" },
    { "code": "G682", "province": "PU", "name": "PIOBBICO" },
    { "code": "G683", "province": "CN", "name": "PIOBESI D'ALBA" },
    { "code": "G684", "province": "TO", "name": "PIOBESI TORINESE" },
    { "code": "G685", "province": "NO", "name": "PIODE (soppresso)" },
    { "code": "G685", "province": "VC", "name": "PIODE" },
    { "code": "G686", "province": "MI", "name": "PIOLTELLO" },
    { "code": "G687", "province": "PI", "name": "PIOMBINO (soppresso)" },
    { "code": "G687", "province": "LI", "name": "PIOMBINO" },
    { "code": "G688", "province": "PD", "name": "PIOMBINO DESE" },
    { "code": "G689", "province": "PR", "name": "PIONE (soppresso)" },
    { "code": "G690", "province": "MC", "name": "PIORACO" },
    { "code": "G691", "province": "TO", "name": "PIOSSASCO" },
    { "code": "G692", "province": "AL", "name": "PIOVA' (soppresso)" },
    { "code": "G692", "province": "AT", "name": "PIOVA' (soppresso)" },
    { "code": "G692", "province": "AT", "name": "PIOVA' MASSAIA" },
    { "code": "G693", "province": "PD", "name": "PIOVE DI SACCO" },
    { "code": "G694", "province": "VI", "name": "PIOVENE (soppresso)" },
    { "code": "G694", "province": "VI", "name": "PIOVENE ROCCHETTE" },
    { "code": "G695", "province": "AL", "name": "PIOVERA (soppresso)" },
    { "code": "G696", "province": "PC", "name": "PIOZZANO" },
    { "code": "G697", "province": "CN", "name": "PIOZZO" },
    { "code": "G698", "province": "RM", "name": "PIPERNO (soppresso)" },
    { "code": "G699", "province": "ME", "name": "PIRAINO" },
    { "code": "G700", "province": "PL", "name": "PIRANO (soppresso)" },
    { "code": "G701", "province": "CA", "name": "PIRRI (soppresso)" },
    { "code": "G702", "province": "PI", "name": "PISA" },
    { "code": "G703", "province": "NO", "name": "PISANO" },
    { "code": "G705", "province": "TO", "name": "PISCINA" },
    { "code": "M291", "province": "CA", "name": "PISCINAS (soppresso)" },
    { "code": "M291", "province": "CI", "name": "PISCINAS (soppresso)" },
    { "code": "M291", "province": "SU", "name": "PISCINAS" },
    { "code": "G706", "province": "NA", "name": "PISCINOLA (soppresso)" },
    { "code": "G707", "province": "SA", "name": "PISCIOTTA" },
    { "code": "G708", "province": "CZ", "name": "PISCOPIO (soppresso)" },
    { "code": "G709", "province": "PL", "name": "PISINO (soppresso)" },
    { "code": "G710", "province": "BS", "name": "PISOGNE" },
    { "code": "G704", "province": "RM", "name": "PISONIANO" },
    { "code": "G711", "province": "PV", "name": "PISSARELLO (soppresso)" },
    { "code": "G712", "province": "PZ", "name": "PISTICCI (soppresso)" },
    { "code": "G712", "province": "MT", "name": "PISTICCI" },
    { "code": "G713", "province": "FI", "name": "PISTOIA (soppresso)" },
    { "code": "G713", "province": "PT", "name": "PISTOIA" },
    { "code": "G714", "province": "NO", "name": "PISTOLESA (soppresso)" },
    { "code": "G714", "province": "VC", "name": "PISTOLESA (soppresso)" },
    { "code": "G714", "province": "BI", "name": "PISTOLESA (soppresso)" },
    { "code": "G715", "province": "FI", "name": "PITEGLIO (soppresso)" },
    { "code": "G715", "province": "PT", "name": "PITEGLIO (soppresso)" },
    { "code": "G716", "province": "GR", "name": "PITIGLIANO" },
    { "code": "G717", "province": "MN", "name": "PIUBEGA" },
    { "code": "G718", "province": "SO", "name": "PIURO" },
    { "code": "G719", "province": "TO", "name": "PIVERONE" },
    { "code": "G719", "province": "AO", "name": "PIVERONE (soppresso)" },
    { "code": "G720", "province": "PV", "name": "PIZZALE" },
    { "code": "G721", "province": "CR", "name": "PIZZIGHETTONE" },
    { "code": "G722", "province": "CZ", "name": "PIZZO (soppresso)" },
    { "code": "G722", "province": "VV", "name": "PIZZO" },
    { "code": "G723", "province": "PV", "name": "PIZZOCORNO (soppresso)" },
    { "code": "G724", "province": "CH", "name": "PIZZOFERRATO" },
    { "code": "G726", "province": "AQ", "name": "PIZZOLI" },
    { "code": "G727", "province": "CB", "name": "PIZZONE (soppresso)" },
    { "code": "G727", "province": "IS", "name": "PIZZONE" },
    { "code": "G728", "province": "CZ", "name": "PIZZONI (soppresso)" },
    { "code": "G728", "province": "VV", "name": "PIZZONI" },
    { "code": "G729", "province": "RC", "name": "PLACANICA" },
    { "code": "G730", "province": "TN", "name": "PLAGNOLO (soppresso)" },
    { "code": "G731", "province": "GO", "name": "PLANINA (soppresso)" },
    { "code": "G731", "province": "UD", "name": "PLANINA (soppresso)" },
    { "code": "G730", "province": "TN", "name": "PLANOL (soppresso)" },
    { "code": "G730", "province": "BZ", "name": "PLANOL (soppresso)" },
    { "code": "G732", "province": "TN", "name": "PLATA (soppresso)" },
    { "code": "G732", "province": "BZ", "name": "PLATA (soppresso)" },
    { "code": "G733", "province": "CS", "name": "PLATACI" },
    { "code": "G734", "province": "CZ", "name": "PLATANIA" },
    { "code": "G732", "province": "TN", "name": "PLATEA (soppresso)" },
    { "code": "G735", "province": "RC", "name": "PLATI'" },
    { "code": "G736", "province": "UD", "name": "PLATISCHIS (soppresso)" },
    { "code": "G299", "province": "TN", "name": "PLAUS (soppresso)" },
    { "code": "G299", "province": "BZ", "name": "PLAUS" },
    { "code": "G737", "province": "CO", "name": "PLESIO" },
    { "code": "G738", "province": "GO", "name": "PLEZZO (soppresso)" },
    { "code": "G738", "province": "UD", "name": "PLEZZO (soppresso)" },
    { "code": "G739", "province": "GO", "name": "PLISCOVIZZA DELLA MADONNA (soppresso)" },
    { "code": "G739", "province": "UD", "name": "PLISCOVIZZA DELLA MADONNA (soppresso)" },
    { "code": "G740", "province": "SS", "name": "PLOAGHE" },
    { "code": "G741", "province": "GE", "name": "PLODIO (soppresso)" },
    { "code": "G741", "province": "SV", "name": "PLODIO" },
    { "code": "G742", "province": "CN", "name": "POCAPAGLIA" },
    { "code": "G743", "province": "UD", "name": "POCENIA" },
    { "code": "G744", "province": "UD", "name": "POCRAI DEL PIRO (soppresso)" },
    { "code": "G744", "province": "GO", "name": "POCRAI DEL PIRO (soppresso)" },
    { "code": "G745", "province": "RC", "name": "PODARGONI (soppresso)" },
    { "code": "G746", "province": "MS", "name": "PODENZANA" },
    { "code": "G747", "province": "PC", "name": "PODENZANO" },
    { "code": "G599", "province": "GO", "name": "PODGORA (soppresso)" },
    { "code": "G599", "province": "UD", "name": "PODGORA (soppresso)" },
    { "code": "G744", "province": "GO", "name": "PODICRAI (soppresso)" },
    { "code": "G744", "province": "UD", "name": "PODICRAI (soppresso)" },
    { "code": "G748", "province": "GO", "name": "PODRAGA (soppresso)" },
    { "code": "G748", "province": "UD", "name": "PODRAGA (soppresso)" },
    { "code": "G749", "province": "RM", "name": "POFI (soppresso)" },
    { "code": "G749", "province": "FR", "name": "POFI" },
    { "code": "G750", "province": "IM", "name": "POGGI (soppresso)" },
    { "code": "G751", "province": "LE", "name": "POGGIARDO" },
    { "code": "G752", "province": "SI", "name": "POGGIBONSI" },
    { "code": "G754", "province": "FI", "name": "POGGIO A CAIANO (soppresso)" },
    { "code": "G754", "province": "PO", "name": "POGGIO A CAIANO" },
    { "code": "G755", "province": "FO", "name": "POGGIO BERNI (soppresso)" },
    { "code": "G755", "province": "RN", "name": "POGGIO BERNI (soppresso)" },
    { "code": "G756", "province": "PG", "name": "POGGIO BUSTONE (soppresso)" },
    { "code": "G756", "province": "RM", "name": "POGGIO BUSTONE (soppresso)" },
    { "code": "G756", "province": "RI", "name": "POGGIO BUSTONE" },
    { "code": "G757", "province": "PG", "name": "POGGIO CATINO (soppresso)" },
    { "code": "G757", "province": "RM", "name": "POGGIO CATINO (soppresso)" },
    { "code": "G757", "province": "RI", "name": "POGGIO CATINO" },
    { "code": "G759", "province": "PG", "name": "POGGIO FIDONI (soppresso)" },
    { "code": "G759", "province": "RM", "name": "POGGIO FIDONI (soppresso)" },
    { "code": "G759", "province": "RI", "name": "POGGIO FIDONI (soppresso)" },
    { "code": "G761", "province": "FG", "name": "POGGIO IMPERIALE" },
    { "code": "G763", "province": "PG", "name": "POGGIO MIRTETO (soppresso)" },
    { "code": "G763", "province": "RM", "name": "POGGIO MIRTETO (soppresso)" },
    { "code": "G763", "province": "RI", "name": "POGGIO MIRTETO" },
    { "code": "G764", "province": "PG", "name": "POGGIO MOIANO (soppresso)" },
    { "code": "G764", "province": "RM", "name": "POGGIO MOIANO (soppresso)" },
    { "code": "G764", "province": "RI", "name": "POGGIO MOIANO" },
    { "code": "G765", "province": "PG", "name": "POGGIO NATIVO (soppresso)" },
    { "code": "G765", "province": "RM", "name": "POGGIO NATIVO (soppresso)" },
    { "code": "G765", "province": "RI", "name": "POGGIO NATIVO" },
    { "code": "G766", "province": "AQ", "name": "POGGIO PICENZE" },
    { "code": "G768", "province": "FE", "name": "POGGIO RENATICO" },
    { "code": "G753", "province": "MN", "name": "POGGIO RUSCO" },
    { "code": "G770", "province": "PG", "name": "POGGIO SAN LORENZO (soppresso)" },
    { "code": "G770", "province": "RM", "name": "POGGIO SAN LORENZO (soppresso)" },
    { "code": "G770", "province": "RI", "name": "POGGIO SAN LORENZO" },
    { "code": "G771", "province": "AN", "name": "POGGIO SAN MARCELLO" },
    { "code": "D566", "province": "MC", "name": "POGGIO SAN VICINO" },
    { "code": "B317", "province": "CB", "name": "POGGIO SANNITA (soppresso)" },
    { "code": "B317", "province": "IS", "name": "POGGIO SANNITA" },
    { "code": "M324", "province": "RN", "name": "POGGIO TORRIANA" },
    { "code": "G758", "province": "PG", "name": "POGGIODOMO" },
    { "code": "G760", "province": "CH", "name": "POGGIOFIORITO" },
    { "code": "G762", "province": "NA", "name": "POGGIOMARINO" },
    { "code": "G767", "province": "TP", "name": "POGGIOREALE" },
    { "code": "G769", "province": "BA", "name": "POGGIORSINI" },
    { "code": "G431", "province": "SO", "name": "POGGIRIDENTI" },
    { "code": "G772", "province": "MI", "name": "POGLIANO (soppresso)" },
    { "code": "G772", "province": "MI", "name": "POGLIANO MILANESE" },
    { "code": "G773", "province": "CO", "name": "POGNANA (soppresso)" },
    { "code": "G773", "province": "CO", "name": "POGNANA LARIO" },
    { "code": "G774", "province": "BG", "name": "POGNANO" },
    { "code": "G775", "province": "NO", "name": "POGNO" },
    { "code": "G777", "province": "TO", "name": "POIRINO" },
    { "code": "G776", "province": "VI", "name": "POJANA MAGGIORE" },
    { "code": "G778", "province": "PL", "name": "POLA (soppresso)" },
    { "code": "G779", "province": "BS", "name": "POLAVENO" },
    { "code": "G780", "province": "UD", "name": "POLCENIGO (soppresso)" },
    { "code": "G780", "province": "PN", "name": "POLCENIGO" },
    { "code": "G781", "province": "CR", "name": "POLENGO (soppresso)" },
    { "code": "G782", "province": "RO", "name": "POLESELLA" },
    { "code": "G783", "province": "PR", "name": "POLESINE PARMENSE (soppresso)" },
    { "code": "M367", "province": "PR", "name": "POLESINE ZIBELLO" },
    { "code": "G784", "province": "RM", "name": "POLI" },
    { "code": "G785", "province": "CZ", "name": "POLIA (soppresso)" },
    { "code": "G785", "province": "VV", "name": "POLIA" },
    { "code": "B657", "province": "SA", "name": "POLICASTRO DEL GOLFO (soppresso)" },
    { "code": "G786", "province": "MT", "name": "POLICORO" },
    { "code": "G787", "province": "BA", "name": "POLIGNANO A MARE" },
    { "code": "G789", "province": "MO", "name": "POLINAGO" },
    { "code": "G790", "province": "PG", "name": "POLINO (soppresso)" },
    { "code": "G790", "province": "TR", "name": "POLINO" },
    { "code": "G791", "province": "RC", "name": "POLISTENA" },
    { "code": "G792", "province": "PA", "name": "POLIZZI GENEROSA" },
    { "code": "G793", "province": "SA", "name": "POLLA" },
    { "code": "G794", "province": "TO", "name": "POLLEIN (soppresso)" },
    { "code": "G794", "province": "AO", "name": "POLLEIN" },
    { "code": "G795", "province": "NA", "name": "POLLENA TROCCHIA" },
    { "code": "F567", "province": "MC", "name": "POLLENZA" },
    { "code": "G796", "province": "SA", "name": "POLLICA" },
    { "code": "G797", "province": "PA", "name": "POLLINA" },
    { "code": "G798", "province": "NO", "name": "POLLONE (soppresso)" },
    { "code": "G798", "province": "VC", "name": "POLLONE (soppresso)" },
    { "code": "G798", "province": "BI", "name": "POLLONE" },
    { "code": "G799", "province": "CH", "name": "POLLUTRI" },
    { "code": "G800", "province": "CN", "name": "POLONGHERA" },
    { "code": "G801", "province": "BS", "name": "POLPENAZZE (soppresso)" },
    { "code": "G801", "province": "BS", "name": "POLPENAZZE DEL GARDA" },
    { "code": "G802", "province": "PD", "name": "POLVERARA" },
    { "code": "G803", "province": "AN", "name": "POLVERIGI" },
    { "code": "G804", "province": "PI", "name": "POMARANCE" },
    { "code": "G805", "province": "TO", "name": "POMARETTO" },
    { "code": "G806", "province": "PZ", "name": "POMARICO (soppresso)" },
    { "code": "G806", "province": "MT", "name": "POMARICO" },
    { "code": "G807", "province": "AL", "name": "POMARO MONFERRATO" },
    { "code": "G808", "province": "TN", "name": "POMAROLO" },
    { "code": "G809", "province": "NO", "name": "POMBIA" },
    { "code": "G810", "province": "PV", "name": "POMETO (soppresso)" },
    { "code": "G811", "province": "RM", "name": "POMEZIA" },
    { "code": "G812", "province": "NA", "name": "POMIGLIANO D'ARCO" },
    { "code": "G813", "province": "NA", "name": "POMPEI" },
    { "code": "G814", "province": "IM", "name": "POMPEIANA" },
    { "code": "G815", "province": "BS", "name": "POMPIANO" },
    { "code": "G816", "province": "MN", "name": "POMPONESCO" },
    { "code": "G817", "province": "CA", "name": "POMPU (soppresso)" },
    { "code": "G817", "province": "OR", "name": "POMPU" },
    { "code": "G818", "province": "BS", "name": "PONCARALE" },
    { "code": "G819", "province": "BS", "name": "PONCARALE FLERO (soppresso)" },
    { "code": "G820", "province": "NO", "name": "PONDERANO (soppresso)" },
    { "code": "G820", "province": "VC", "name": "PONDERANO (soppresso)" },
    { "code": "G820", "province": "BI", "name": "PONDERANO" },
    { "code": "G821", "province": "CO", "name": "PONNA" },
    { "code": "G822", "province": "PI", "name": "PONSACCO" },
    { "code": "G823", "province": "PD", "name": "PONSO" },
    { "code": "G545", "province": "TO", "name": "PONT BOZET (soppresso)" },
    { "code": "G545", "province": "AO", "name": "PONT BOZET (soppresso)" },
    { "code": "G854", "province": "TO", "name": "PONT SAINT MARTIN (soppresso)" },
    { "code": "G854", "province": "AO", "name": "PONT SAINT MARTIN (soppresso)" },
    { "code": "G824", "province": "BS", "name": "PONTAGNA (soppresso)" },
    { "code": "G825", "province": "FI", "name": "PONTASSIEVE" },
    { "code": "G545", "province": "AO", "name": "PONTBOSET" },
    { "code": "G826", "province": "TO", "name": "PONT-CANAVESE" },
    { "code": "G826", "province": "AO", "name": "PONT-CANAVESE (soppresso)" },
    { "code": "G827", "province": "BN", "name": "PONTE" },
    { "code": "G830", "province": "TN", "name": "PONTE ALL'ISARCO (soppresso)" },
    { "code": "G830", "province": "BZ", "name": "PONTE ALL'ISARCO (soppresso)" },
    { "code": "G833", "province": "LU", "name": "PONTE BUGGIANESE (soppresso)" },
    { "code": "G833", "province": "PT", "name": "PONTE BUGGIANESE" },
    { "code": "G842", "province": "PC", "name": "PONTE DELL'OLIO" },
    { "code": "G844", "province": "BS", "name": "PONTE DI LEGNO" },
    { "code": "G845", "province": "BG", "name": "PONTE DI NOSSA (soppresso)" },
    { "code": "G846", "province": "TV", "name": "PONTE DI PIAVE" },
    { "code": "G830", "province": "BZ", "name": "PONTE GARDENA" },
    { "code": "G829", "province": "SO", "name": "PONTE IN VALTELLINA" },
    { "code": "G828", "province": "CO", "name": "PONTE LAMBRO (soppresso)" },
    { "code": "G847", "province": "CO", "name": "PONTE LAMBRO" },
    { "code": "B662", "province": "BL", "name": "PONTE NELLE ALPI" },
    { "code": "G851", "province": "PV", "name": "PONTE NIZZA" },
    { "code": "F941", "province": "BG", "name": "PONTE NOSSA" },
    { "code": "G854", "province": "AO", "name": "PONTE SAN MARTINO (soppresso)" },
    { "code": "G855", "province": "PD", "name": "PONTE SAN NICOLO'" },
    { "code": "G856", "province": "BG", "name": "PONTE SAN PIETRO" },
    { "code": "G831", "province": "UD", "name": "PONTEBBA" },
    { "code": "G832", "province": "UD", "name": "PONTEBBA NOVA (soppresso)" },
    { "code": "G834", "province": "SA", "name": "PONTECAGNANO FAIANO" },
    { "code": "G836", "province": "RO", "name": "PONTECCHIO (soppresso)" },
    { "code": "G836", "province": "RO", "name": "PONTECCHIO POLESINE" },
    { "code": "G837", "province": "CN", "name": "PONTECHIANALE" },
    { "code": "G838", "province": "CE", "name": "PONTECORVO (soppresso)" },
    { "code": "G838", "province": "FR", "name": "PONTECORVO" },
    { "code": "G839", "province": "AL", "name": "PONTECURONE" },
    { "code": "G840", "province": "IM", "name": "PONTEDASSIO" },
    { "code": "G841", "province": "GE", "name": "PONTEDECIMO (soppresso)" },
    { "code": "G843", "province": "PI", "name": "PONTEDERA" },
    { "code": "G832", "province": "UD", "name": "PONTEFELLA (soppresso)" },
    { "code": "G848", "province": "BN", "name": "PONTELANDOLFO" },
    { "code": "G849", "province": "CE", "name": "PONTELATONE" },
    { "code": "G849", "province": "NA", "name": "PONTELATONE (soppresso)" },
    { "code": "G847", "province": "CO", "name": "PONTELEZZA (soppresso)" },
    { "code": "G850", "province": "PD", "name": "PONTELONGO" },
    { "code": "G852", "province": "PC", "name": "PONTENURE" },
    { "code": "G853", "province": "BG", "name": "PONTERANICA" },
    { "code": "G858", "province": "AL", "name": "PONTESTURA" },
    { "code": "G859", "province": "BS", "name": "PONTEVICO" },
    { "code": "G860", "province": "TO", "name": "PONTEY (soppresso)" },
    { "code": "G860", "province": "AO", "name": "PONTEY" },
    { "code": "G861", "province": "AL", "name": "PONTI" },
    { "code": "G862", "province": "MN", "name": "PONTI SUL MINCIO" },
    { "code": "G863", "province": "NA", "name": "PONTICELLI (soppresso)" },
    { "code": "G864", "province": "BG", "name": "PONTIDA" },
    { "code": "G865", "province": "LT", "name": "PONTINIA" },
    { "code": "G866", "province": "GE", "name": "PONTINVREA (soppresso)" },
    { "code": "G866", "province": "SV", "name": "PONTINVREA" },
    { "code": "G867", "province": "BG", "name": "PONTIROLO NUOVO" },
    { "code": "G869", "province": "BS", "name": "PONTOGLIO" },
    { "code": "G870", "province": "MS", "name": "PONTREMOLI" },
    { "code": "G854", "province": "AO", "name": "PONT-SAINT-MARTIN" },
    { "code": "G871", "province": "CE", "name": "PONZA (soppresso)" },
    { "code": "G871", "province": "NA", "name": "PONZA (soppresso)" },
    { "code": "G871", "province": "LT", "name": "PONZA" },
    { "code": "G873", "province": "AP", "name": "PONZANO DI FERMO (soppresso)" },
    { "code": "G873", "province": "FM", "name": "PONZANO DI FERMO" },
    { "code": "G872", "province": "AL", "name": "PONZANO MONFERRATO" },
    { "code": "G874", "province": "RM", "name": "PONZANO ROMANO" },
    { "code": "G875", "province": "TV", "name": "PONZANO VENETO" },
    { "code": "G876", "province": "CO", "name": "PONZATE (soppresso)" },
    { "code": "G877", "province": "AL", "name": "PONZONE" },
    { "code": "G878", "province": "AQ", "name": "POPOLI (soppresso)" },
    { "code": "G878", "province": "PE", "name": "POPOLI" },
    { "code": "G879", "province": "AR", "name": "POPPI" },
    { "code": "G880", "province": "TN", "name": "POR (soppresso)" },
    { "code": "G881", "province": "PG", "name": "PORANO (soppresso)" },
    { "code": "G881", "province": "TR", "name": "PORANO" },
    { "code": "G882", "province": "LU", "name": "PORCARI" },
    { "code": "G886", "province": "UD", "name": "PORCIA (soppresso)" },
    { "code": "G886", "province": "PN", "name": "PORCIA" },
    { "code": "G888", "province": "UD", "name": "PORDENONE (soppresso)" },
    { "code": "G888", "province": "PN", "name": "PORDENONE" },
    { "code": "G889", "province": "CO", "name": "PORLEZZA" },
    { "code": "G890", "province": "IM", "name": "PORNASSIO" },
    { "code": "G891", "province": "UD", "name": "PORPETTO" },
    { "code": "A558", "province": "BO", "name": "PORRETTA TERME (soppresso)" },
    { "code": "E470", "province": "AO", "name": "PORTA LITTORIA (soppresso)" },
    { "code": "G894", "province": "AL", "name": "PORTACOMARO (soppresso)" },
    { "code": "G894", "province": "AT", "name": "PORTACOMARO" },
    { "code": "G895", "province": "PV", "name": "PORTALBERA" },
    { "code": "G900", "province": "TO", "name": "PORTE" },
    { "code": "M358", "province": "TN", "name": "PORTE DI RENDENA" },
    { "code": "G901", "province": "BS", "name": "PORTESE (soppresso)" },
    { "code": "G902", "province": "NA", "name": "PORTICI" },
    { "code": "G903", "province": "CE", "name": "PORTICO DI CASERTA" },
    { "code": "G903", "province": "NA", "name": "PORTICO DI CASERTA (soppresso)" },
    { "code": "G904", "province": "FI", "name": "PORTICO E SAN BENEDETTO (soppresso)" },
    { "code": "G904", "province": "FO", "name": "PORTICO E SAN BENEDETTO (soppresso)" },
    { "code": "G904", "province": "FC", "name": "PORTICO E SAN BENEDETTO" },
    { "code": "G905", "province": "RC", "name": "PORTIGLIOLA" },
    { "code": "G908", "province": "MI", "name": "PORTO (soppresso)" },
    { "code": "E680", "province": "LI", "name": "PORTO AZZURRO" },
    { "code": "G906", "province": "CO", "name": "PORTO CERESIO (soppresso)" },
    { "code": "G906", "province": "VA", "name": "PORTO CERESIO" },
    { "code": "M263", "province": "LE", "name": "PORTO CESAREO" },
    { "code": "G911", "province": "MC", "name": "PORTO CIVITANOVA (soppresso)" },
    { "code": "G908", "province": "MI", "name": "PORTO D'ADDA (soppresso)" },
    { "code": "F299", "province": "AG", "name": "PORTO EMPEDOCLE" },
    { "code": "E680", "province": "LI", "name": "PORTO LONGONE (soppresso)" },
    { "code": "G917", "province": "MN", "name": "PORTO MANTOVANO" },
    { "code": "G918", "province": "IM", "name": "PORTO MAURIZIO (soppresso)" },
    { "code": "G919", "province": "MC", "name": "PORTO RECANATI" },
    { "code": "G920", "province": "AP", "name": "PORTO SAN GIORGIO (soppresso)" },
    { "code": "G920", "province": "FM", "name": "PORTO SAN GIORGIO" },
    { "code": "G921", "province": "AP", "name": "PORTO SANT'ELPIDIO (soppresso)" },
    { "code": "G921", "province": "FM", "name": "PORTO SANT'ELPIDIO" },
    { "code": "G923", "province": "RO", "name": "PORTO TOLLE" },
    { "code": "G924", "province": "SS", "name": "PORTO TORRES" },
    { "code": "G907", "province": "CO", "name": "PORTO VALTRAVAGLIA (soppresso)" },
    { "code": "G907", "province": "VA", "name": "PORTO VALTRAVAGLIA" },
    { "code": "G926", "province": "RO", "name": "PORTO VIRO" },
    { "code": "G909", "province": "TV", "name": "PORTOBUFFOLE'" },
    { "code": "G910", "province": "CB", "name": "PORTOCANNONE" },
    { "code": "G912", "province": "LI", "name": "PORTOFERRAIO" },
    { "code": "G913", "province": "GE", "name": "PORTOFINO" },
    { "code": "G914", "province": "VE", "name": "PORTOGRUARO" },
    { "code": "G915", "province": "PL", "name": "PORTOLE (soppresso)" },
    { "code": "G916", "province": "FE", "name": "PORTOMAGGIORE" },
    { "code": "M257", "province": "SR", "name": "PORTOPALO DI CAPO PASSERO" },
    { "code": "G922", "province": "CA", "name": "PORTOSCUSO (soppresso)" },
    { "code": "G922", "province": "CI", "name": "PORTOSCUSO (soppresso)" },
    { "code": "G922", "province": "SU", "name": "PORTOSCUSO" },
    { "code": "G925", "province": "GE", "name": "PORTOVENERE (soppresso)" },
    { "code": "G925", "province": "SP", "name": "PORTOVENERE" },
    { "code": "G927", "province": "NO", "name": "PORTULA (soppresso)" },
    { "code": "G927", "province": "VC", "name": "PORTULA (soppresso)" },
    { "code": "G927", "province": "BI", "name": "PORTULA" },
    { "code": "G928", "province": "BS", "name": "PORZANO (soppresso)" },
    { "code": "G929", "province": "SS", "name": "POSADA (soppresso)" },
    { "code": "G929", "province": "NU", "name": "POSADA" },
    { "code": "G930", "province": "BG", "name": "POSCANTE (soppresso)" },
    { "code": "G931", "province": "VI", "name": "POSINA" },
    { "code": "G932", "province": "SA", "name": "POSITANO" },
    { "code": "G933", "province": "TV", "name": "POSSAGNO" },
    { "code": "G934", "province": "AQ", "name": "POSTA (soppresso)" },
    { "code": "G934", "province": "RI", "name": "POSTA" },
    { "code": "G935", "province": "FR", "name": "POSTA FIBRENO" },
    { "code": "G936", "province": "TN", "name": "POSTAL (soppresso)" },
    { "code": "G936", "province": "BZ", "name": "POSTAL" },
    { "code": "G937", "province": "SO", "name": "POSTALESIO" },
    { "code": "G939", "province": "SA", "name": "POSTIGLIONE" },
    { "code": "G940", "province": "NO", "name": "POSTUA (soppresso)" },
    { "code": "G940", "province": "VC", "name": "POSTUA" },
    { "code": "G941", "province": "TS", "name": "POSTUMIA (soppresso)" },
    { "code": "G941", "province": "TS", "name": "POSTUMIA GROTTE (soppresso)" },
    { "code": "G942", "province": "PZ", "name": "POTENZA" },
    { "code": "F632", "province": "MC", "name": "POTENZA PICENA" },
    { "code": "G943", "province": "VI", "name": "POVE (soppresso)" },
    { "code": "G943", "province": "VI", "name": "POVE DEL GRAPPA" },
    { "code": "G944", "province": "TV", "name": "POVEGLIANO" },
    { "code": "G945", "province": "VR", "name": "POVEGLIANO VERONESE" },
    { "code": "G946", "province": "TS", "name": "POVERIO (soppresso)" },
    { "code": "G947", "province": "RE", "name": "POVIGLIO" },
    { "code": "G946", "province": "TS", "name": "POVIR (soppresso)" },
    { "code": "G948", "province": "TN", "name": "POVO (soppresso)" },
    { "code": "G949", "province": "UD", "name": "POVOLETTO" },
    { "code": "G950", "province": "TN", "name": "POZZA (soppresso)" },
    { "code": "G950", "province": "TN", "name": "POZZA DI FASSA (soppresso)" },
    { "code": "G951", "province": "RI", "name": "POZZAGLIA SABINA" },
    { "code": "G951", "province": "PG", "name": "POZZAGLIA SABINO (soppresso)" },
    { "code": "G951", "province": "RM", "name": "POZZAGLIA SABINO (soppresso)" },
    { "code": "G951", "province": "RI", "name": "POZZAGLIA SABINO (soppresso)" },
    { "code": "B914", "province": "CR", "name": "POZZAGLIO ED UNITI" },
    { "code": "G953", "province": "SR", "name": "POZZALLO (soppresso)" },
    { "code": "G953", "province": "RG", "name": "POZZALLO" },
    { "code": "G954", "province": "CB", "name": "POZZILLI (soppresso)" },
    { "code": "G954", "province": "IS", "name": "POZZILLI" },
    { "code": "G956", "province": "PS", "name": "POZZO ALTO (soppresso)" },
    { "code": "G955", "province": "MI", "name": "POZZO D'ADDA" },
    { "code": "G960", "province": "AL", "name": "POZZOL GROPPO" },
    { "code": "G959", "province": "BS", "name": "POZZOLENGO" },
    { "code": "G957", "province": "VI", "name": "POZZOLEONE" },
    { "code": "G961", "province": "AL", "name": "POZZOLO FORMIGARO" },
    { "code": "G962", "province": "SS", "name": "POZZOMAGGIORE" },
    { "code": "G963", "province": "PD", "name": "POZZONOVO" },
    { "code": "G964", "province": "NA", "name": "POZZUOLI" },
    { "code": "G966", "province": "UD", "name": "POZZUOLO DEL FRIULI" },
    { "code": "G965", "province": "MI", "name": "POZZUOLO MARTESANA" },
    { "code": "G967", "province": "GE", "name": "PRA (soppresso)" },
    { "code": "G968", "province": "BG", "name": "PRADALUNGA" },
    { "code": "G969", "province": "UD", "name": "PRADAMANO" },
    { "code": "G970", "province": "CN", "name": "PRADLEVE (soppresso)" },
    { "code": "G970", "province": "CN", "name": "PRADLEVES" },
    { "code": "G972", "province": "BO", "name": "PRADURO E SASSO (soppresso)" },
    { "code": "G973", "province": "TO", "name": "PRAGELATO" },
    { "code": "G975", "province": "CS", "name": "PRAIA A MARE" },
    { "code": "G976", "province": "SA", "name": "PRAIANO" },
    { "code": "G977", "province": "BS", "name": "PRALBOINO" },
    { "code": "G978", "province": "TO", "name": "PRALI" },
    { "code": "G979", "province": "TO", "name": "PRALORMO" },
    { "code": "G980", "province": "NO", "name": "PRALUNGO (soppresso)" },
    { "code": "G980", "province": "VC", "name": "PRALUNGO (soppresso)" },
    { "code": "G980", "province": "BI", "name": "PRALUNGO" },
    { "code": "G978", "province": "TO", "name": "PRALY (soppresso)" },
    { "code": "G981", "province": "VE", "name": "PRAMAGGIORE" },
    { "code": "G982", "province": "TO", "name": "PRAMOLLO" },
    { "code": "G983", "province": "BS", "name": "PRANDAGLIO (soppresso)" },
    { "code": "G984", "province": "TN", "name": "PRANZO (soppresso)" },
    { "code": "G985", "province": "NO", "name": "PRAROLO (soppresso)" },
    { "code": "G985", "province": "VC", "name": "PRAROLO" },
    { "code": "G986", "province": "TO", "name": "PRAROSTINO" },
    { "code": "G987", "province": "AL", "name": "PRASCO" },
    { "code": "G988", "province": "TO", "name": "PRASCORSANO" },
    { "code": "G988", "province": "AO", "name": "PRASCORSANO (soppresso)" },
    { "code": "G989", "province": "TN", "name": "PRASO (soppresso)" },
    { "code": "G993", "province": "SO", "name": "PRATA CAMPORTACCIO" },
    { "code": "G992", "province": "AQ", "name": "PRATA D'ANSIDONIA" },
    { "code": "G994", "province": "UD", "name": "PRATA DI PORDENONE (soppresso)" },
    { "code": "G994", "province": "PN", "name": "PRATA DI PORDENONE" },
    { "code": "G990", "province": "AV", "name": "PRATA DI PRINCIPATO ULTRA" },
    { "code": "G991", "province": "CE", "name": "PRATA SANNITA" },
    { "code": "G991", "province": "CB", "name": "PRATA SANNITA (soppresso)" },
    { "code": "G995", "province": "CE", "name": "PRATELLA" },
    { "code": "G995", "province": "CB", "name": "PRATELLA (soppresso)" },
    { "code": "G996", "province": "TN", "name": "PRATI (soppresso)" },
    { "code": "G996", "province": "BZ", "name": "PRATI (soppresso)" },
    { "code": "G997", "province": "TO", "name": "PRATIGLIONE" },
    { "code": "G997", "province": "AO", "name": "PRATIGLIONE (soppresso)" },
    { "code": "G999", "province": "FI", "name": "PRATO (soppresso)" },
    { "code": "G999", "province": "PO", "name": "PRATO" },
    { "code": "H003", "province": "TN", "name": "PRATO ALLA DRAVA (soppresso)" },
    { "code": "H003", "province": "BZ", "name": "PRATO ALLA DRAVA (soppresso)" },
    { "code": "H004", "province": "BZ", "name": "PRATO ALLO STELVIO" },
    { "code": "H002", "province": "UD", "name": "PRATO CARNICO" },
    { "code": "ND", "province": "TN", "name": "PRATO DI VENOSTA (soppresso)" },
    { "code": "ND", "province": "BZ", "name": "PRATO DI VENOSTA (soppresso)" },
    { "code": "G999", "province": "FI", "name": "PRATO IN TOSCANA (soppresso)" },
    { "code": "H001", "province": "NO", "name": "PRATO SESIA" },
    { "code": "H004", "province": "BZ", "name": "PRATO VENOSTA (soppresso)" },
    { "code": "H007", "province": "AQ", "name": "PRATOLA PELIGNA" },
    { "code": "H006", "province": "AV", "name": "PRATOLA SERRA" },
    { "code": "H008", "province": "AR", "name": "PRATOVECCHIO (soppresso)" },
    { "code": "H009", "province": "AR", "name": "PRATOVECCHIO STIA (soppresso)" },
    { "code": "M329", "province": "AR", "name": "PRATOVECCHIO STIA" },
    { "code": "H010", "province": "UD", "name": "PRAVISDOMINI (soppresso)" },
    { "code": "H010", "province": "PN", "name": "PRAVISDOMINI" },
    { "code": "G974", "province": "NO", "name": "PRAY (soppresso)" },
    { "code": "G974", "province": "VC", "name": "PRAY (soppresso)" },
    { "code": "G974", "province": "BI", "name": "PRAY" },
    { "code": "H011", "province": "CN", "name": "PRAZZO" },
    { "code": "H012", "province": "TN", "name": "PRE' (soppresso)" },
    { "code": "H042", "province": "TO", "name": "PRE' SAINT DIDIER (soppresso)" },
    { "code": "H042", "province": "AO", "name": "PRE' SAINT DIDIER (soppresso)" },
    { "code": "H013", "province": "RC", "name": "PRECACORE (soppresso)" },
    { "code": "H014", "province": "UD", "name": "PRECENICCO" },
    { "code": "H015", "province": "PG", "name": "PRECI" },
    { "code": "H016", "province": "MI", "name": "PRECOTTO (soppresso)" },
    { "code": "M344", "province": "TN", "name": "PREDAIA" },
    { "code": "H017", "province": "FO", "name": "PREDAPPIO (soppresso)" },
    { "code": "H017", "province": "FC", "name": "PREDAPPIO" },
    { "code": "H017", "province": "FO", "name": "PREDAPPIO NUOVA (soppresso)" },
    { "code": "H018", "province": "TN", "name": "PREDAZZO" },
    { "code": "H019", "province": "TN", "name": "PREDOI (soppresso)" },
    { "code": "H019", "province": "BZ", "name": "PREDOI" },
    { "code": "H020", "province": "BG", "name": "PREDORE" },
    { "code": "H021", "province": "AL", "name": "PREDOSA" },
    { "code": "H022", "province": "TV", "name": "PREGANZIOL" },
    { "code": "H023", "province": "TN", "name": "PREGASINA (soppresso)" },
    { "code": "H024", "province": "TN", "name": "PREGHENA (soppresso)" },
    { "code": "H025", "province": "NO", "name": "PREGLIA (soppresso)" },
    { "code": "H026", "province": "MI", "name": "PREGNANA (soppresso)" },
    { "code": "H026", "province": "MI", "name": "PREGNANA MILANESE" },
    { "code": "B117", "province": "PV", "name": "PREGOLA (soppresso)" },
    { "code": "H027", "province": "IM", "name": "PRELA'" },
    { "code": "H028", "province": "CO", "name": "PREMANA (soppresso)" },
    { "code": "H028", "province": "LC", "name": "PREMANA" },
    { "code": "H029", "province": "UD", "name": "PREMARIACCO" },
    { "code": "H030", "province": "NO", "name": "PREMENO (soppresso)" },
    { "code": "H030", "province": "VB", "name": "PREMENO" },
    { "code": "H033", "province": "NO", "name": "PREMIA (soppresso)" },
    { "code": "H033", "province": "VB", "name": "PREMIA" },
    { "code": "H034", "province": "FI", "name": "PREMILCUORE (soppresso)" },
    { "code": "H034", "province": "FO", "name": "PREMILCUORE (soppresso)" },
    { "code": "H034", "province": "FC", "name": "PREMILCUORE" },
    { "code": "H035", "province": "TN", "name": "PREMIONE (soppresso)" },
    { "code": "H036", "province": "BG", "name": "PREMOLO" },
    { "code": "H037", "province": "NO", "name": "PREMOSELLO (soppresso)" },
    { "code": "H037", "province": "NO", "name": "PREMOSELLO-CHIOVENDA (soppresso)" },
    { "code": "H037", "province": "VB", "name": "PREMOSELLO-CHIOVENDA" },
    { "code": "H038", "province": "UD", "name": "PREONE" },
    { "code": "H039", "province": "TN", "name": "PREORE (soppresso)" },
    { "code": "H040", "province": "UD", "name": "PREPOTTO" },
    { "code": "H042", "province": "AO", "name": "PRE'-SAINT-DIDIER" },
    { "code": "H043", "province": "BS", "name": "PRESEGLIE" },
    { "code": "H044", "province": "BS", "name": "PRESEGNO (soppresso)" },
    { "code": "H045", "province": "CE", "name": "PRESENZANO" },
    { "code": "H045", "province": "NA", "name": "PRESENZANO (soppresso)" },
    { "code": "H046", "province": "BG", "name": "PRESEZZO" },
    { "code": "H047", "province": "LE", "name": "PRESICCE (soppresso)" },
    { "code": "M428", "province": "LE", "name": "PRESICCE-ACQUARICA" },
    { "code": "H048", "province": "VR", "name": "PRESSANA" },
    { "code": "H049", "province": "TN", "name": "PRESSON (soppresso)" },
    { "code": "H050", "province": "BS", "name": "PRESTINE (soppresso)" },
    { "code": "H052", "province": "CH", "name": "PRETORO" },
    { "code": "H053", "province": "AQ", "name": "PRETURO (soppresso)" },
    { "code": "H054", "province": "UD", "name": "PREVACINA (soppresso)" },
    { "code": "H054", "province": "GO", "name": "PREVACINA (soppresso)" },
    { "code": "H055", "province": "BS", "name": "PREVALLE" },
    { "code": "H056", "province": "AQ", "name": "PREZZA" },
    { "code": "H057", "province": "TN", "name": "PREZZO (soppresso)" },
    { "code": "H058", "province": "TO", "name": "PRIACCO (soppresso)" },
    { "code": "H058", "province": "AO", "name": "PRIACCO (soppresso)" },
    { "code": "H059", "province": "CN", "name": "PRIERO" },
    { "code": "H060", "province": "CN", "name": "PRIERO MONTEZEMOLO (soppresso)" },
    { "code": "H062", "province": "SA", "name": "PRIGNANO CILENTO" },
    { "code": "H061", "province": "MO", "name": "PRIGNANO SULLA SECCHIA" },
    { "code": "H063", "province": "CO", "name": "PRIMALUNA (soppresso)" },
    { "code": "H063", "province": "LC", "name": "PRIMALUNA" },
    { "code": "H064", "province": "FU", "name": "PRIMANO (soppresso)" },
    { "code": "H064", "province": "PL", "name": "PRIMANO (soppresso)" },
    { "code": "H065", "province": "AL", "name": "PRIMEGLIO SCHIERANO (soppresso)" },
    { "code": "H066", "province": "TN", "name": "PRIMIERO (soppresso)" },
    { "code": "M359", "province": "TN", "name": "PRIMIERO SAN MARTINO DI CASTROZZA" },
    { "code": "H067", "province": "TN", "name": "PRIO' (soppresso)" },
    { "code": "H068", "province": "CN", "name": "PRIOCCA" },
    { "code": "H069", "province": "CN", "name": "PRIOLA" },
    { "code": "M279", "province": "SR", "name": "PRIOLO GARGALLO" },
    { "code": "G698", "province": "RM", "name": "PRIVERNO (soppresso)" },
    { "code": "G698", "province": "LT", "name": "PRIVERNO" },
    { "code": "H070", "province": "PA", "name": "PRIZZI" },
    { "code": "H071", "province": "RM", "name": "PROCENO (soppresso)" },
    { "code": "H071", "province": "VT", "name": "PROCENO" },
    { "code": "H072", "province": "NA", "name": "PROCIDA" },
    { "code": "H073", "province": "GE", "name": "PROPATA" },
    { "code": "H074", "province": "CO", "name": "PROSERPIO" },
    { "code": "H076", "province": "RM", "name": "PROSSEDI (soppresso)" },
    { "code": "H076", "province": "LT", "name": "PROSSEDI" },
    { "code": "H077", "province": "BS", "name": "PROVAGLIO (soppresso)" },
    { "code": "H078", "province": "BS", "name": "PROVAGLIO D'ISEO" },
    { "code": "H079", "province": "BS", "name": "PROVAGLIO SOPRA (soppresso)" },
    { "code": "H080", "province": "BS", "name": "PROVAGLIO SOTTO (soppresso)" },
    { "code": "H077", "province": "BS", "name": "PROVAGLIO VAL SABBIA" },
    { "code": "H081", "province": "TN", "name": "PROVES (soppresso)" },
    { "code": "H081", "province": "BZ", "name": "PROVES" },
    { "code": "H082", "province": "BS", "name": "PROVEZZE (soppresso)" },
    { "code": "H083", "province": "CB", "name": "PROVVIDENTI" },
    { "code": "H084", "province": "VR", "name": "PRUN (soppresso)" },
    { "code": "H085", "province": "CN", "name": "PRUNETTO" },
    { "code": "H086", "province": "BS", "name": "PUEGNAGO (soppresso)" },
    { "code": "H086", "province": "BS", "name": "PUEGNAGO SUL GARDA" },
    { "code": "H087", "province": "BN", "name": "PUGLIANELLO" },
    { "code": "H088", "province": "CA", "name": "PULA" },
    { "code": "H089", "province": "UD", "name": "PULFERO" },
    { "code": "H090", "province": "LE", "name": "PULSANO (soppresso)" },
    { "code": "H090", "province": "TA", "name": "PULSANO" },
    { "code": "H091", "province": "BG", "name": "PUMENENGO" },
    { "code": "H092", "province": "BL", "name": "PUOS D'ALPAGO (soppresso)" },
    { "code": "H093", "province": "CO", "name": "PURIA (soppresso)" },
    { "code": "H094", "province": "CO", "name": "PUSIANO" },
    { "code": "H095", "province": "SS", "name": "PUTIFIGARI" },
    { "code": "H096", "province": "BA", "name": "PUTIGNANO" },
    { "code": "H097", "province": "AV", "name": "QUADRELLE" },
    { "code": "H098", "province": "CH", "name": "QUADRI" },
    { "code": "H099", "province": "AV", "name": "QUAGLIETTA (soppresso)" },
    { "code": "H100", "province": "TO", "name": "QUAGLIUZZO" },
    { "code": "H100", "province": "AO", "name": "QUAGLIUZZO (soppresso)" },
    { "code": "H101", "province": "NA", "name": "QUALIANO" },
    { "code": "H102", "province": "AL", "name": "QUARANTI (soppresso)" },
    { "code": "H102", "province": "AT", "name": "QUARANTI" },
    { "code": "D213", "province": "TN", "name": "QUARAZZE (soppresso)" },
    { "code": "H103", "province": "NO", "name": "QUAREGNA (soppresso)" },
    { "code": "H103", "province": "VC", "name": "QUAREGNA (soppresso)" },
    { "code": "H103", "province": "BI", "name": "QUAREGNA (soppresso)" },
    { "code": "M414", "province": "BI", "name": "QUAREGNA CERRETO" },
    { "code": "H104", "province": "AL", "name": "QUARGNENTO" },
    { "code": "H105", "province": "NO", "name": "QUARNA (soppresso)" },
    { "code": "H106", "province": "NO", "name": "QUARNA SOPRA (soppresso)" },
    { "code": "H106", "province": "VB", "name": "QUARNA SOPRA" },
    { "code": "H107", "province": "NO", "name": "QUARNA SOTTO (soppresso)" },
    { "code": "H107", "province": "VB", "name": "QUARNA SOTTO" },
    { "code": "H108", "province": "NO", "name": "QUARONA (soppresso)" },
    { "code": "H108", "province": "VC", "name": "QUARONA" },
    { "code": "H109", "province": "PT", "name": "QUARRATA" },
    { "code": "H110", "province": "TO", "name": "QUART (soppresso)" },
    { "code": "H110", "province": "AO", "name": "QUART" },
    { "code": "H111", "province": "AL", "name": "QUARTI (soppresso)" },
    { "code": "H112", "province": "MI", "name": "QUARTIANO (soppresso)" },
    { "code": "H114", "province": "NA", "name": "QUARTO" },
    { "code": "H115", "province": "GE", "name": "QUARTO AL MARE (soppresso)" },
    { "code": "H117", "province": "VE", "name": "QUARTO D'ALTINO" },
    { "code": "H115", "province": "GE", "name": "QUARTO DEI MILLE (soppresso)" },
    { "code": "H110", "province": "AO", "name": "QUARTO PRAETORIA (soppresso)" },
    { "code": "H118", "province": "CA", "name": "QUARTU SANT'ELENA" },
    { "code": "H119", "province": "CA", "name": "QUARTUCCIU" },
    { "code": "H120", "province": "TO", "name": "QUASSOLO" },
    { "code": "H120", "province": "AO", "name": "QUASSOLO (soppresso)" },
    { "code": "H121", "province": "AL", "name": "QUATTORDIO" },
    { "code": "H122", "province": "RE", "name": "QUATTRO CASTELLA" },
    { "code": "H124", "province": "BL", "name": "QUERO (soppresso)" },
    { "code": "M332", "province": "BL", "name": "QUERO VAS" },
    { "code": "H125", "province": "TN", "name": "QUETTA (soppresso)" },
    { "code": "H126", "province": "GE", "name": "QUILIANO (soppresso)" },
    { "code": "H126", "province": "SV", "name": "QUILIANO" },
    { "code": "H127", "province": "TO", "name": "QUINCINETTO" },
    { "code": "H127", "province": "AO", "name": "QUINCINETTO (soppresso)" },
    { "code": "H128", "province": "AV", "name": "QUINDICI" },
    { "code": "H129", "province": "MN", "name": "QUINGENTOLE" },
    { "code": "H130", "province": "CR", "name": "QUINTANO" },
    { "code": "H135", "province": "GE", "name": "QUINTO AL MARE (soppresso)" },
    { "code": "H131", "province": "TV", "name": "QUINTO DI TREVISO" },
    { "code": "H133", "province": "VR", "name": "QUINTO DI VALPANTENA (soppresso)" },
    { "code": "H132", "province": "NO", "name": "QUINTO VERCELLESE (soppresso)" },
    { "code": "H132", "province": "VC", "name": "QUINTO VERCELLESE" },
    { "code": "H134", "province": "VI", "name": "QUINTO VICENTINO" },
    { "code": "H139", "province": "BS", "name": "QUINZANELLO (soppresso)" },
    { "code": "H140", "province": "BS", "name": "QUINZANO D'OGLIO" },
    { "code": "H142", "province": "VR", "name": "QUINZANO VERONESE (soppresso)" },
    { "code": "H143", "province": "MN", "name": "QUISTELLO" },
    { "code": "H145", "province": "NO", "name": "QUITTENGO (soppresso)" },
    { "code": "H145", "province": "VC", "name": "QUITTENGO (soppresso)" },
    { "code": "H145", "province": "BI", "name": "QUITTENGO (soppresso)" },
    { "code": "H146", "province": "TN", "name": "RABBI" },
    { "code": "H147", "province": "LE", "name": "RACALE" },
    { "code": "H148", "province": "AG", "name": "RACALMUTO" },
    { "code": "H149", "province": "UD", "name": "RACCOLANA (soppresso)" },
    { "code": "H150", "province": "CN", "name": "RACCONIGI" },
    { "code": "H151", "province": "ME", "name": "RACCUJA" },
    { "code": "H152", "province": "TN", "name": "RACIGNES (soppresso)" },
    { "code": "H152", "province": "TN", "name": "RACINES (soppresso)" },
    { "code": "H152", "province": "BZ", "name": "RACINES" },
    { "code": "H153", "province": "SI", "name": "RADDA (soppresso)" },
    { "code": "H153", "province": "SI", "name": "RADDA IN CHIANTI" },
    { "code": "H154", "province": "CT", "name": "RADDUSA" },
    { "code": "H155", "province": "RC", "name": "RADICENA (soppresso)" },
    { "code": "H156", "province": "SI", "name": "RADICOFANI" },
    { "code": "H157", "province": "SI", "name": "RADICONDOLI" },
    { "code": "H158", "province": "BS", "name": "RAFFA (soppresso)" },
    { "code": "H159", "province": "AG", "name": "RAFFADALI" },
    { "code": "M287", "province": "CT", "name": "RAGALNA" },
    { "code": "H161", "province": "UD", "name": "RAGOGNA" },
    { "code": "H162", "province": "TN", "name": "RAGOLI (soppresso)" },
    { "code": "H163", "province": "SR", "name": "RAGUSA (soppresso)" },
    { "code": "H163", "province": "RG", "name": "RAGUSA" },
    { "code": "H164", "province": "SR", "name": "RAGUSA IBLA (soppresso)" },
    { "code": "H164", "province": "RG", "name": "RAGUSA IBLA (soppresso)" },
    { "code": "H164", "province": "SR", "name": "RAGUSA INFERIORE (soppresso)" },
    { "code": "H166", "province": "AQ", "name": "RAIANO" },
    { "code": "H167", "province": "TN", "name": "RAISSA (soppresso)" },
    { "code": "H168", "province": "CT", "name": "RAMACCA" },
    { "code": "G654", "province": "RE", "name": "RAMISETO (soppresso)" },
    { "code": "H169", "province": "RO", "name": "RAMO DI PALO (soppresso)" },
    { "code": "H170", "province": "CO", "name": "RAMPONIO (soppresso)" },
    { "code": "H171", "province": "CO", "name": "RAMPONIO VERNA (soppresso)" },
    { "code": "H172", "province": "CO", "name": "RANCIO DI LECCO (soppresso)" },
    { "code": "H173", "province": "CO", "name": "RANCIO VALCUVIA (soppresso)" },
    { "code": "H173", "province": "VA", "name": "RANCIO VALCUVIA" },
    { "code": "H174", "province": "CO", "name": "RANCO (soppresso)" },
    { "code": "H174", "province": "VA", "name": "RANCO" },
    { "code": "H175", "province": "CT", "name": "RANDAZZO" },
    { "code": "H176", "province": "BG", "name": "RANICA" },
    { "code": "H177", "province": "BG", "name": "RANZANICO" },
    { "code": "H179", "province": "GE", "name": "RANZI PIETRA (soppresso)" },
    { "code": "H179", "province": "SV", "name": "RANZI PIETRA (soppresso)" },
    { "code": "H178", "province": "GO", "name": "RANZIANO (soppresso)" },
    { "code": "H178", "province": "UD", "name": "RANZIANO (soppresso)" },
    { "code": "H180", "province": "IM", "name": "RANZO" },
    { "code": "H181", "province": "TN", "name": "RANZO (soppresso)" },
    { "code": "H182", "province": "AP", "name": "RAPAGNANO (soppresso)" },
    { "code": "H182", "province": "FM", "name": "RAPAGNANO" },
    { "code": "H183", "province": "GE", "name": "RAPALLO" },
    { "code": "H184", "province": "CH", "name": "RAPINO" },
    { "code": "H185", "province": "SI", "name": "RAPOLANO (soppresso)" },
    { "code": "H185", "province": "SI", "name": "RAPOLANO TERME" },
    { "code": "H186", "province": "PZ", "name": "RAPOLLA" },
    { "code": "H187", "province": "PZ", "name": "RAPONE" },
    { "code": "H188", "province": "NO", "name": "RASSA (soppresso)" },
    { "code": "H188", "province": "VC", "name": "RASSA" },
    { "code": "H190", "province": "TN", "name": "RASUN DI SOPRA (soppresso)" },
    { "code": "H190", "province": "BZ", "name": "RASUN DI SOPRA (soppresso)" },
    { "code": "H191", "province": "TN", "name": "RASUN DI SOTTO (soppresso)" },
    { "code": "H191", "province": "BZ", "name": "RASUN DI SOTTO (soppresso)" },
    { "code": "M307", "province": "BZ", "name": "RASUN VALDAORA (soppresso)" },
    { "code": "H189", "province": "BZ", "name": "RASUN-ANTERSELVA" },
    { "code": "H192", "province": "SO", "name": "RASURA" },
    { "code": "H194", "province": "AG", "name": "RAVANUSA" },
    { "code": "H195", "province": "MO", "name": "RAVARINO" },
    { "code": "H196", "province": "UD", "name": "RAVASCLETTO" },
    { "code": "H197", "province": "CO", "name": "RAVELLINO (soppresso)" },
    { "code": "H198", "province": "SA", "name": "RAVELLO" },
    { "code": "H199", "province": "RA", "name": "RAVENNA" },
    { "code": "H200", "province": "UD", "name": "RAVEO" },
    { "code": "H201", "province": "TN", "name": "RAVINA (soppresso)" },
    { "code": "H202", "province": "CE", "name": "RAVISCANINA" },
    { "code": "H202", "province": "BN", "name": "RAVISCANINA (soppresso)" },
    { "code": "H203", "province": "NO", "name": "RE (soppresso)" },
    { "code": "H203", "province": "VB", "name": "RE" },
    { "code": "H204", "province": "PV", "name": "REA" },
    { "code": "H205", "province": "AG", "name": "REALMONTE" },
    { "code": "H206", "province": "UD", "name": "REANA DEL ROJALE" },
    { "code": "H207", "province": "TO", "name": "REANO" },
    { "code": "H208", "province": "CO", "name": "REBBIO (soppresso)" },
    { "code": "H210", "province": "CE", "name": "RECALE" },
    { "code": "H210", "province": "NA", "name": "RECALE (soppresso)" },
    { "code": "H211", "province": "MC", "name": "RECANATI" },
    { "code": "H212", "province": "GE", "name": "RECCO" },
    { "code": "H213", "province": "NO", "name": "RECETTO" },
    { "code": "H214", "province": "VI", "name": "RECOARO (soppresso)" },
    { "code": "H214", "province": "VI", "name": "RECOARO TERME" },
    { "code": "H216", "province": "PV", "name": "REDAVALLE" },
    { "code": "H217", "province": "BG", "name": "REDONA (soppresso)" },
    { "code": "H218", "province": "MN", "name": "REDONDESCO" },
    { "code": "H219", "province": "AL", "name": "REFRANCORE (soppresso)" },
    { "code": "H219", "province": "AT", "name": "REFRANCORE" },
    { "code": "H220", "province": "TV", "name": "REFRONTOLO" },
    { "code": "H221", "province": "CT", "name": "REGALBUTO (soppresso)" },
    { "code": "H221", "province": "EN", "name": "REGALBUTO" },
    { "code": "H222", "province": "FI", "name": "REGGELLO" },
    { "code": "H224", "province": "RC", "name": "REGGIO DI CALABRIA" },
    { "code": "H223", "province": "RE", "name": "REGGIO NELL'EMILIA" },
    { "code": "H225", "province": "RE", "name": "REGGIOLO" },
    { "code": "H283", "province": "GO", "name": "REIFEMBERG (soppresso)" },
    { "code": "H283", "province": "UD", "name": "REIFEMBERG (soppresso)" },
    { "code": "H227", "province": "BN", "name": "REINO" },
    { "code": "H228", "province": "ME", "name": "REITANO" },
    { "code": "H229", "province": "UD", "name": "REMANZACCO" },
    { "code": "H230", "province": "BS", "name": "REMEDELLO" },
    { "code": "H231", "province": "BS", "name": "REMEDELLO SOPRA (soppresso)" },
    { "code": "H232", "province": "BS", "name": "REMEDELLO SOTTO (soppresso)" },
    { "code": "H233", "province": "MI", "name": "RENATE (soppresso)" },
    { "code": "H233", "province": "MB", "name": "RENATE" },
    { "code": "H234", "province": "MI", "name": "RENATE VEDUGGIO (soppresso)" },
    { "code": "H235", "province": "CS", "name": "RENDE" },
    { "code": "H236", "province": "TN", "name": "RENON (soppresso)" },
    { "code": "H236", "province": "BZ", "name": "RENON" },
    { "code": "F378", "province": "TS", "name": "REPNO (soppresso)" },
    { "code": "H238", "province": "TV", "name": "RESANA" },
    { "code": "H239", "province": "MI", "name": "RESCALDA (soppresso)" },
    { "code": "H240", "province": "MI", "name": "RESCALDINA" },
    { "code": "H242", "province": "UD", "name": "RESIA" },
    { "code": "H241", "province": "TN", "name": "RESIA (soppresso)" },
    { "code": "H241", "province": "BZ", "name": "RESIA (soppresso)" },
    { "code": "H241", "province": "TN", "name": "RESIA ALL'ADIGE (soppresso)" },
    { "code": "H243", "province": "NA", "name": "RESINA (soppresso)" },
    { "code": "H244", "province": "UD", "name": "RESIUTTA" },
    { "code": "H245", "province": "CL", "name": "RESUTTANO" },
    { "code": "H193", "province": "FU", "name": "RETACEVO IN MONTE (soppresso)" },
    { "code": "H193", "province": "PL", "name": "RETACEVO IN MONTE (soppresso)" },
    { "code": "H246", "province": "PV", "name": "RETORBIDO" },
    { "code": "H247", "province": "CN", "name": "REVELLO" },
    { "code": "H248", "province": "MN", "name": "REVERE (soppresso)" },
    { "code": "H249", "province": "TN", "name": "REVIANO FOLAS (soppresso)" },
    { "code": "H250", "province": "AL", "name": "REVIGLIASCO D'ASTI (soppresso)" },
    { "code": "H250", "province": "AT", "name": "REVIGLIASCO D'ASTI" },
    { "code": "H251", "province": "TO", "name": "REVIGLIASCO TORINESE (soppresso)" },
    { "code": "H253", "province": "TV", "name": "REVINE LAGO" },
    { "code": "H254", "province": "TN", "name": "REVO'" },
    { "code": "H255", "province": "CO", "name": "REZZAGO" },
    { "code": "H256", "province": "BS", "name": "REZZATO" },
    { "code": "H257", "province": "IM", "name": "REZZO" },
    { "code": "H259", "province": "CO", "name": "REZZO CAVARGNA (soppresso)" },
    { "code": "H258", "province": "GE", "name": "REZZOAGLIO" },
    { "code": "H260", "province": "CO", "name": "REZZONICO (soppresso)" },
    { "code": "H261", "province": "AO", "name": "RHEMES (soppresso)" },
    { "code": "H262", "province": "TO", "name": "RHEMES NOTRE DAME (soppresso)" },
    { "code": "H262", "province": "AO", "name": "RHEMES NOTRE DAME (soppresso)" },
    { "code": "H263", "province": "TO", "name": "RHEMES SAINT GEORGES (soppresso)" },
    { "code": "H263", "province": "AO", "name": "RHEMES SAINT GEORGES (soppresso)" },
    { "code": "H262", "province": "AO", "name": "RHEMES-NOTRE-DAME" },
    { "code": "H263", "province": "AO", "name": "RHEMES-SAINT-GEORGES" },
    { "code": "H264", "province": "MI", "name": "RHO" },
    { "code": "H265", "province": "RC", "name": "RIACE" },
    { "code": "H266", "province": "GE", "name": "RIALTO (soppresso)" },
    { "code": "H266", "province": "SV", "name": "RIALTO" },
    { "code": "H267", "province": "RM", "name": "RIANO" },
    { "code": "H268", "province": "CE", "name": "RIARDO" },
    { "code": "H268", "province": "NA", "name": "RIARDO (soppresso)" },
    { "code": "H269", "province": "AG", "name": "RIBERA" },
    { "code": "H270", "province": "TO", "name": "RIBORDONE" },
    { "code": "H270", "province": "AO", "name": "RIBORDONE (soppresso)" },
    { "code": "H271", "province": "CZ", "name": "RICADI (soppresso)" },
    { "code": "H271", "province": "VV", "name": "RICADI" },
    { "code": "H272", "province": "AL", "name": "RICALDONE" },
    { "code": "H273", "province": "CB", "name": "RICCIA" },
    { "code": "H274", "province": "FO", "name": "RICCIONE (soppresso)" },
    { "code": "H274", "province": "RN", "name": "RICCIONE" },
    { "code": "H275", "province": "GE", "name": "RICCO' DEL GOLFO DI SPEZIA (soppresso)" },
    { "code": "H275", "province": "SP", "name": "RICCO' DEL GOLFO DI SPEZIA" },
    { "code": "H276", "province": "CR", "name": "RICENGO" },
    { "code": "H277", "province": "SA", "name": "RICIGLIANO" },
    { "code": "H278", "province": "TO", "name": "RICLARETTO (soppresso)" },
    { "code": "H279", "province": "TN", "name": "RIDANNA (soppresso)" },
    { "code": "H279", "province": "BZ", "name": "RIDANNA (soppresso)" },
    { "code": "H280", "province": "TV", "name": "RIESE (soppresso)" },
    { "code": "H280", "province": "TV", "name": "RIESE PIO X" },
    { "code": "H281", "province": "CL", "name": "RIESI" },
    { "code": "H282", "province": "PG", "name": "RIETI (soppresso)" },
    { "code": "H282", "province": "RM", "name": "RIETI (soppresso)" },
    { "code": "H282", "province": "RI", "name": "RIETI" },
    { "code": "H283", "province": "UD", "name": "RIFEMBERGO (soppresso)" },
    { "code": "H283", "province": "GO", "name": "RIFEMBERGO (soppresso)" },
    { "code": "H284", "province": "TN", "name": "RIFIANO (soppresso)" },
    { "code": "H284", "province": "BZ", "name": "RIFIANO" },
    { "code": "H285", "province": "CN", "name": "RIFREDDO" },
    { "code": "H288", "province": "RM", "name": "RIGNANO FLAMINIO" },
    { "code": "H287", "province": "FG", "name": "RIGNANO GARGANICO" },
    { "code": "H286", "province": "FI", "name": "RIGNANO SULL'ARNO" },
    { "code": "H289", "province": "UD", "name": "RIGOLATO" },
    { "code": "H290", "province": "BG", "name": "RIGOSA (soppresso)" },
    { "code": "H291", "province": "NO", "name": "RIMA SAN GIUSEPPE (soppresso)" },
    { "code": "H291", "province": "VC", "name": "RIMA SAN GIUSEPPE (soppresso)" },
    { "code": "H292", "province": "NO", "name": "RIMASCO (soppresso)" },
    { "code": "H292", "province": "VC", "name": "RIMASCO (soppresso)" },
    { "code": "H293", "province": "NO", "name": "RIMELLA (soppresso)" },
    { "code": "H293", "province": "VC", "name": "RIMELLA" },
    { "code": "H294", "province": "FO", "name": "RIMINI (soppresso)" },
    { "code": "H294", "province": "RN", "name": "RIMINI" },
    { "code": "H295", "province": "TN", "name": "RINA (soppresso)" },
    { "code": "H295", "province": "BZ", "name": "RINA (soppresso)" },
    { "code": "H296", "province": "AL", "name": "RINCO (soppresso)" },
    { "code": "H295", "province": "TN", "name": "RINNA (soppresso)" },
    { "code": "M391", "province": "LI", "name": "RIO" },
    { "code": "H299", "province": "TN", "name": "RIO DI PUSTERIA (soppresso)" },
    { "code": "H299", "province": "BZ", "name": "RIO DI PUSTERIA" },
    { "code": "H305", "province": "LI", "name": "RIO MARINA (soppresso)" },
    { "code": "H297", "province": "LI", "name": "RIO NELL'ELBA (soppresso)" },
    { "code": "H298", "province": "RE", "name": "RIO SALICETO" },
    { "code": "H300", "province": "RM", "name": "RIOFREDDO" },
    { "code": "H301", "province": "CA", "name": "RIOLA (soppresso)" },
    { "code": "H301", "province": "CA", "name": "RIOLA SARDO (soppresso)" },
    { "code": "H301", "province": "OR", "name": "RIOLA SARDO" },
    { "code": "H302", "province": "RA", "name": "RIOLO (soppresso)" },
    { "code": "H302", "province": "RA", "name": "RIOLO DEI BAGNI (soppresso)" },
    { "code": "H302", "province": "RA", "name": "RIOLO TERME" },
    { "code": "H303", "province": "MO", "name": "RIOLUNATO" },
    { "code": "H304", "province": "GE", "name": "RIOMAGGIORE (soppresso)" },
    { "code": "H304", "province": "SP", "name": "RIOMAGGIORE" },
    { "code": "H306", "province": "TN", "name": "RIOMOLINO (soppresso)" },
    { "code": "H306", "province": "BZ", "name": "RIOMOLINO (soppresso)" },
    { "code": "H307", "province": "PZ", "name": "RIONERO IN VULTURE" },
    { "code": "H308", "province": "CB", "name": "RIONERO SANNITICO (soppresso)" },
    { "code": "H308", "province": "IS", "name": "RIONERO SANNITICO" },
    { "code": "H320", "province": "CH", "name": "RIPA TEATINA" },
    { "code": "H311", "province": "CB", "name": "RIPABOTTONI" },
    { "code": "H312", "province": "PZ", "name": "RIPACANDIDA" },
    { "code": "H313", "province": "CB", "name": "RIPALIMOSANI" },
    { "code": "H313", "province": "CB", "name": "RIPALIMOSANO (soppresso)" },
    { "code": "H314", "province": "CR", "name": "RIPALTA ARPINA" },
    { "code": "H315", "province": "CR", "name": "RIPALTA CREMASCA" },
    { "code": "H316", "province": "CR", "name": "RIPALTA GUERINA" },
    { "code": "H317", "province": "CR", "name": "RIPALTA NUOVA (soppresso)" },
    { "code": "E799", "province": "CB", "name": "RIPALTA SUL TRIGNO (soppresso)" },
    { "code": "H319", "province": "PI", "name": "RIPARBELLA" },
    { "code": "H321", "province": "AP", "name": "RIPATRANSONE" },
    { "code": "H322", "province": "AN", "name": "RIPE (soppresso)" },
    { "code": "H323", "province": "MC", "name": "RIPE SAN GINESIO" },
    { "code": "H324", "province": "RM", "name": "RIPI (soppresso)" },
    { "code": "H324", "province": "FR", "name": "RIPI" },
    { "code": "H325", "province": "CT", "name": "RIPOSTO" },
    { "code": "H167", "province": "TN", "name": "RISCONE (soppresso)" },
    { "code": "H167", "province": "BZ", "name": "RISCONE (soppresso)" },
    { "code": "H326", "province": "CN", "name": "RITTANA" },
    { "code": "H330", "province": "TN", "name": "RIVA (soppresso)" },
    { "code": "H330", "province": "TN", "name": "RIVA DEL GARDA" },
    { "code": "M410", "province": "FE", "name": "RIVA DEL PO" },
    { "code": "H331", "province": "BG", "name": "RIVA DI SOLTO" },
    { "code": "H332", "province": "TN", "name": "RIVA DI TURES (soppresso)" },
    { "code": "H332", "province": "BZ", "name": "RIVA DI TURES (soppresso)" },
    { "code": "H332", "province": "TN", "name": "RIVA IN VALLE (soppresso)" },
    { "code": "H328", "province": "IM", "name": "RIVA LIGURE" },
    { "code": "H337", "province": "TO", "name": "RIVA PRESSO CHIERI" },
    { "code": "H345", "province": "IM", "name": "RIVA SANTO STEFANO (soppresso)" },
    { "code": "H329", "province": "NO", "name": "RIVA VALDOBBIA (soppresso)" },
    { "code": "H329", "province": "VC", "name": "RIVA VALDOBBIA (soppresso)" },
    { "code": "H333", "province": "TO", "name": "RIVALBA" },
    { "code": "H334", "province": "AL", "name": "RIVALTA BORMIDA" },
    { "code": "H335", "province": "TO", "name": "RIVALTA DI TORINO" },
    { "code": "H327", "province": "BL", "name": "RIVAMONTE (soppresso)" },
    { "code": "H327", "province": "BL", "name": "RIVAMONTE AGORDINO" },
    { "code": "H336", "province": "PV", "name": "RIVANAZZANO (soppresso)" },
    { "code": "H336", "province": "PV", "name": "RIVANAZZANO TERME" },
    { "code": "H338", "province": "TO", "name": "RIVARA" },
    { "code": "H340", "province": "TO", "name": "RIVAROLO CANAVESE" },
    { "code": "H341", "province": "CR", "name": "RIVAROLO DEL RE ED UNITI" },
    { "code": "H342", "province": "MN", "name": "RIVAROLO FUORI (soppresso)" },
    { "code": "H339", "province": "GE", "name": "RIVAROLO LIGURE (soppresso)" },
    { "code": "H342", "province": "MN", "name": "RIVAROLO MANTOVANO" },
    { "code": "H343", "province": "AL", "name": "RIVARONE" },
    { "code": "H344", "province": "TO", "name": "RIVAROSSA" },
    { "code": "H346", "province": "NO", "name": "RIVE (soppresso)" },
    { "code": "H346", "province": "VC", "name": "RIVE" },
    { "code": "H347", "province": "UD", "name": "RIVE D'ARCANO" },
    { "code": "H348", "province": "PZ", "name": "RIVELLO" },
    { "code": "H349", "province": "TO", "name": "RIVERA (soppresso)" },
    { "code": "H350", "province": "PC", "name": "RIVERGARO" },
    { "code": "H351", "province": "BG", "name": "RIVIERA D'ADDA (soppresso)" },
    { "code": "H352", "province": "UD", "name": "RIVIGNANO (soppresso)" },
    { "code": "M317", "province": "UD", "name": "RIVIGNANO TEOR" },
    { "code": "H353", "province": "AQ", "name": "RIVISONDOLI" },
    { "code": "H354", "province": "PG", "name": "RIVODUTRI (soppresso)" },
    { "code": "H354", "province": "RM", "name": "RIVODUTRI (soppresso)" },
    { "code": "H354", "province": "RI", "name": "RIVODUTRI" },
    { "code": "H355", "province": "TO", "name": "RIVOLI" },
    { "code": "H356", "province": "VR", "name": "RIVOLI VERONESE" },
    { "code": "H357", "province": "CR", "name": "RIVOLTA D'ADDA" },
    { "code": "H358", "province": "BS", "name": "RIVOLTELLA (soppresso)" },
    { "code": "G356", "province": "UD", "name": "RIVOLTO (soppresso)" },
    { "code": "H359", "province": "RC", "name": "RIZZICONI" },
    { "code": "H360", "province": "FE", "name": "RO (soppresso)" },
    { "code": "H361", "province": "VI", "name": "ROANA" },
    { "code": "H362", "province": "CN", "name": "ROASCHIA" },
    { "code": "H363", "province": "CN", "name": "ROASCIO" },
    { "code": "H364", "province": "NO", "name": "ROASENDA (soppresso)" },
    { "code": "H364", "province": "VC", "name": "ROASENDA (soppresso)" },
    { "code": "H365", "province": "NO", "name": "ROASIO (soppresso)" },
    { "code": "H365", "province": "VC", "name": "ROASIO" },
    { "code": "H366", "province": "AL", "name": "ROATTO (soppresso)" },
    { "code": "H366", "province": "AT", "name": "ROATTO" },
    { "code": "H367", "province": "TO", "name": "ROBASSOMERO" },
    { "code": "G223", "province": "CO", "name": "ROBBIATE (soppresso)" },
    { "code": "G223", "province": "LC", "name": "ROBBIATE" },
    { "code": "G223", "province": "CO", "name": "ROBBIATE PADERNO (soppresso)" },
    { "code": "H369", "province": "PV", "name": "ROBBIO" },
    { "code": "H371", "province": "MI", "name": "ROBECCHETTO CON INDUNO" },
    { "code": "H372", "province": "CR", "name": "ROBECCO D'OGLIO" },
    { "code": "H375", "province": "PV", "name": "ROBECCO PAVESE" },
    { "code": "H373", "province": "MI", "name": "ROBECCO SUL NAVIGLIO" },
    { "code": "H376", "province": "AL", "name": "ROBELLA (soppresso)" },
    { "code": "H376", "province": "AT", "name": "ROBELLA" },
    { "code": "H377", "province": "CN", "name": "ROBILANTE" },
    { "code": "H378", "province": "CN", "name": "ROBURENT" },
    { "code": "H378", "province": "CN", "name": "ROBURENTO (soppresso)" },
    { "code": "H386", "province": "TO", "name": "ROCCA CANAVESE" },
    { "code": "H387", "province": "RM", "name": "ROCCA CANTERANO" },
    { "code": "H391", "province": "CN", "name": "ROCCA CIGLIE'" },
    { "code": "H392", "province": "AL", "name": "ROCCA D'ARAZZO (soppresso)" },
    { "code": "H392", "province": "AT", "name": "ROCCA D'ARAZZO" },
    { "code": "H393", "province": "CE", "name": "ROCCA D'ARCE (soppresso)" },
    { "code": "H393", "province": "FR", "name": "ROCCA D'ARCE" },
    { "code": "H395", "province": "CN", "name": "ROCCA DE' BALDI" },
    { "code": "H396", "province": "PV", "name": "ROCCA DE' GIORGI" },
    { "code": "H397", "province": "BG", "name": "ROCCA DEL COLLE (soppresso)" },
    { "code": "H398", "province": "CE", "name": "ROCCA D'EVANDRO" },
    { "code": "H398", "province": "NA", "name": "ROCCA D'EVANDRO (soppresso)" },
    { "code": "H399", "province": "AQ", "name": "ROCCA DI BOTTE" },
    { "code": "H400", "province": "AQ", "name": "ROCCA DI CAMBIO" },
    { "code": "H401", "province": "RM", "name": "ROCCA DI CAVE" },
    { "code": "H402", "province": "AQ", "name": "ROCCA DI MEZZO" },
    { "code": "H403", "province": "CZ", "name": "ROCCA DI NETO (soppresso)" },
    { "code": "H403", "province": "KR", "name": "ROCCA DI NETO" },
    { "code": "H404", "province": "RM", "name": "ROCCA DI PAPA" },
    { "code": "H414", "province": "AL", "name": "ROCCA GRIMALDA" },
    { "code": "H416", "province": "CS", "name": "ROCCA IMPERIALE" },
    { "code": "H421", "province": "RM", "name": "ROCCA MASSIMA (soppresso)" },
    { "code": "H421", "province": "LT", "name": "ROCCA MASSIMA" },
    { "code": "H429", "province": "AQ", "name": "ROCCA PIA" },
    { "code": "H379", "province": "BL", "name": "ROCCA PIETORE" },
    { "code": "H381", "province": "NO", "name": "ROCCA PIETRA (soppresso)" },
    { "code": "H381", "province": "VC", "name": "ROCCA PIETRA (soppresso)" },
    { "code": "H432", "province": "RM", "name": "ROCCA PRIORA" },
    { "code": "H437", "province": "FI", "name": "ROCCA SAN CASCIANO (soppresso)" },
    { "code": "H437", "province": "FO", "name": "ROCCA SAN CASCIANO (soppresso)" },
    { "code": "H437", "province": "FC", "name": "ROCCA SAN CASCIANO" },
    { "code": "H438", "province": "AV", "name": "ROCCA SAN FELICE" },
    { "code": "H439", "province": "CH", "name": "ROCCA SAN GIOVANNI" },
    { "code": "H440", "province": "TE", "name": "ROCCA SANTA MARIA" },
    { "code": "H441", "province": "RM", "name": "ROCCA SANTO STEFANO" },
    { "code": "H446", "province": "PG", "name": "ROCCA SINIBALDA (soppresso)" },
    { "code": "H446", "province": "RM", "name": "ROCCA SINIBALDA (soppresso)" },
    { "code": "H446", "province": "RI", "name": "ROCCA SINIBALDA" },
    { "code": "H450", "province": "PV", "name": "ROCCA SUSELLA" },
    { "code": "H382", "province": "AV", "name": "ROCCABASCERANA" },
    { "code": "H383", "province": "CZ", "name": "ROCCABERNARDA (soppresso)" },
    { "code": "H383", "province": "KR", "name": "ROCCABERNARDA" },
    { "code": "H384", "province": "PR", "name": "ROCCABIANCA" },
    { "code": "H385", "province": "CN", "name": "ROCCABRUNA" },
    { "code": "H388", "province": "CH", "name": "ROCCACARAMANICO (soppresso)" },
    { "code": "H388", "province": "PE", "name": "ROCCACARAMANICO (soppresso)" },
    { "code": "H389", "province": "AQ", "name": "ROCCACASALE" },
    { "code": "H394", "province": "SA", "name": "ROCCADASPIDE" },
    { "code": "H405", "province": "ME", "name": "ROCCAFIORITA" },
    { "code": "H390", "province": "AP", "name": "ROCCAFLUVIONE" },
    { "code": "H408", "province": "RC", "name": "ROCCAFORTE DEL GRECO" },
    { "code": "H406", "province": "AL", "name": "ROCCAFORTE LIGURE" },
    { "code": "H407", "province": "CN", "name": "ROCCAFORTE MONDOVI'" },
    { "code": "H409", "province": "LE", "name": "ROCCAFORZATA (soppresso)" },
    { "code": "H409", "province": "TA", "name": "ROCCAFORZATA" },
    { "code": "H410", "province": "BS", "name": "ROCCAFRANCA" },
    { "code": "H411", "province": "RM", "name": "ROCCAGIOVINE" },
    { "code": "H412", "province": "SA", "name": "ROCCAGLORIOSA" },
    { "code": "H413", "province": "RM", "name": "ROCCAGORGA (soppresso)" },
    { "code": "H413", "province": "LT", "name": "ROCCAGORGA" },
    { "code": "H415", "province": "CE", "name": "ROCCAGUGLIELMA (soppresso)" },
    { "code": "D831", "province": "UD", "name": "ROCCALBA (soppresso)" },
    { "code": "H417", "province": "GR", "name": "ROCCALBEGNA" },
    { "code": "H418", "province": "ME", "name": "ROCCALUMERA" },
    { "code": "H419", "province": "RM", "name": "ROCCALVECCE (soppresso)" },
    { "code": "H419", "province": "VT", "name": "ROCCALVECCE (soppresso)" },
    { "code": "H420", "province": "CB", "name": "ROCCAMANDOLFI (soppresso)" },
    { "code": "H420", "province": "IS", "name": "ROCCAMANDOLFI" },
    { "code": "H422", "province": "PA", "name": "ROCCAMENA" },
    { "code": "H423", "province": "CE", "name": "ROCCAMONFINA" },
    { "code": "H423", "province": "NA", "name": "ROCCAMONFINA (soppresso)" },
    { "code": "H424", "province": "CH", "name": "ROCCAMONTEPIANO" },
    { "code": "H425", "province": "CH", "name": "ROCCAMORICE (soppresso)" },
    { "code": "H425", "province": "PE", "name": "ROCCAMORICE" },
    { "code": "H426", "province": "PZ", "name": "ROCCANOVA" },
    { "code": "H427", "province": "PG", "name": "ROCCANTICA (soppresso)" },
    { "code": "H427", "province": "RM", "name": "ROCCANTICA (soppresso)" },
    { "code": "H427", "province": "RI", "name": "ROCCANTICA" },
    { "code": "H428", "province": "PA", "name": "ROCCAPALUMBA" },
    { "code": "H430", "province": "TO", "name": "ROCCAPIATTA (soppresso)" },
    { "code": "H431", "province": "SA", "name": "ROCCAPIEMONTE" },
    { "code": "H433", "province": "CE", "name": "ROCCARAINOLA (soppresso)" },
    { "code": "H433", "province": "NA", "name": "ROCCARAINOLA" },
    { "code": "H434", "province": "AQ", "name": "ROCCARASO" },
    { "code": "H436", "province": "CE", "name": "ROCCAROMANA" },
    { "code": "H436", "province": "NA", "name": "ROCCAROMANA (soppresso)" },
    { "code": "H442", "province": "CH", "name": "ROCCASCALEGNA" },
    { "code": "H443", "province": "CE", "name": "ROCCASECCA (soppresso)" },
    { "code": "H443", "province": "FR", "name": "ROCCASECCA" },
    { "code": "H444", "province": "RM", "name": "ROCCASECCA DEI VOLSCI (soppresso)" },
    { "code": "H444", "province": "LT", "name": "ROCCASECCA DEI VOLSCI" },
    { "code": "H445", "province": "CB", "name": "ROCCASICURA (soppresso)" },
    { "code": "H445", "province": "IS", "name": "ROCCASICURA" },
    { "code": "H447", "province": "CN", "name": "ROCCASPARVERA" },
    { "code": "H448", "province": "CH", "name": "ROCCASPINALVETI" },
    { "code": "H449", "province": "GR", "name": "ROCCASTRADA" },
    { "code": "H380", "province": "ME", "name": "ROCCAVALDINA" },
    { "code": "H451", "province": "AL", "name": "ROCCAVERANO (soppresso)" },
    { "code": "H451", "province": "AT", "name": "ROCCAVERANO" },
    { "code": "H452", "province": "GE", "name": "ROCCAVIGNALE (soppresso)" },
    { "code": "H452", "province": "SV", "name": "ROCCAVIGNALE" },
    { "code": "H453", "province": "CN", "name": "ROCCAVIONE" },
    { "code": "H454", "province": "CB", "name": "ROCCAVIVARA" },
    { "code": "H456", "province": "RC", "name": "ROCCELLA IONICA" },
    { "code": "H455", "province": "ME", "name": "ROCCELLA VALDEMONE" },
    { "code": "H458", "province": "CB", "name": "ROCCHETTA A VOLTURNO (soppresso)" },
    { "code": "H458", "province": "IS", "name": "ROCCHETTA A VOLTURNO" },
    { "code": "H462", "province": "CN", "name": "ROCCHETTA BELBO" },
    { "code": "H464", "province": "GE", "name": "ROCCHETTA CENGIO (soppresso)" },
    { "code": "H464", "province": "SV", "name": "ROCCHETTA CENGIO (soppresso)" },
    { "code": "H461", "province": "MS", "name": "ROCCHETTA DI VARA (soppresso)" },
    { "code": "H461", "province": "SP", "name": "ROCCHETTA DI VARA" },
    { "code": "H459", "province": "CE", "name": "ROCCHETTA E CROCE" },
    { "code": "H459", "province": "NA", "name": "ROCCHETTA E CROCE (soppresso)" },
    { "code": "H465", "province": "AL", "name": "ROCCHETTA LIGURE" },
    { "code": "H460", "province": "IM", "name": "ROCCHETTA NERVINA" },
    { "code": "H466", "province": "AL", "name": "ROCCHETTA PALAFEA (soppresso)" },
    { "code": "H466", "province": "AT", "name": "ROCCHETTA PALAFEA" },
    { "code": "H467", "province": "AV", "name": "ROCCHETTA SANT'ANTONIO (soppresso)" },
    { "code": "H467", "province": "FG", "name": "ROCCHETTA SANT'ANTONIO" },
    { "code": "H468", "province": "AL", "name": "ROCCHETTA TANARO (soppresso)" },
    { "code": "H468", "province": "AT", "name": "ROCCHETTA TANARO" },
    { "code": "H457", "province": "TO", "name": "ROCHEMOLLES (soppresso)" },
    { "code": "H470", "province": "MI", "name": "RODANO" },
    { "code": "H471", "province": "UD", "name": "RODDA (soppresso)" },
    { "code": "H472", "province": "CN", "name": "RODDI" },
    { "code": "H473", "province": "CN", "name": "RODDINO" },
    { "code": "H474", "province": "CN", "name": "RODELLO" },
    { "code": "H476", "province": "BS", "name": "RODENGO (soppresso)" },
    { "code": "H475", "province": "TN", "name": "RODENGO (soppresso)" },
    { "code": "H475", "province": "BZ", "name": "RODENGO" },
    { "code": "H477", "province": "BS", "name": "RODENGO SAIANO" },
    { "code": "H478", "province": "CO", "name": "RODERO" },
    { "code": "H479", "province": "ME", "name": "RODI (soppresso)" },
    { "code": "H480", "province": "FG", "name": "RODI GARGANICO" },
    { "code": "H479", "province": "ME", "name": "RODI' MILICI" },
    { "code": "H482", "province": "TS", "name": "RODIC (soppresso)" },
    { "code": "H481", "province": "MN", "name": "RODIGO" },
    { "code": "H482", "province": "TS", "name": "RODITTI (soppresso)" },
    { "code": "H484", "province": "BS", "name": "ROE' VOLCIANO" },
    { "code": "H485", "province": "SA", "name": "ROFRANO" },
    { "code": "H486", "province": "CO", "name": "ROGENO (soppresso)" },
    { "code": "H486", "province": "LC", "name": "ROGENO" },
    { "code": "H488", "province": "CS", "name": "ROGGIANO GRAVINA" },
    { "code": "H487", "province": "CO", "name": "ROGGIANO VALTRAVAGLIA (soppresso)" },
    { "code": "H487", "province": "VA", "name": "ROGGIANO VALTRAVAGLIA (soppresso)" },
    { "code": "H489", "province": "RC", "name": "ROGHUDI" },
    { "code": "H490", "province": "CS", "name": "ROGLIANO" },
    { "code": "H491", "province": "PV", "name": "ROGNANO" },
    { "code": "H492", "province": "BG", "name": "ROGNO" },
    { "code": "H493", "province": "SO", "name": "ROGOLO" },
    { "code": "H494", "province": "RM", "name": "ROIATE" },
    { "code": "H495", "province": "CH", "name": "ROIO DEL SANGRO" },
    { "code": "H496", "province": "AQ", "name": "ROIO PIANO (soppresso)" },
    { "code": "H497", "province": "TO", "name": "ROISAN (soppresso)" },
    { "code": "H497", "province": "AO", "name": "ROISAN" },
    { "code": "H498", "province": "TO", "name": "ROLETTO" },
    { "code": "H500", "province": "RE", "name": "ROLO" },
    { "code": "H501", "province": "RM", "name": "ROMA" },
    { "code": "H504", "province": "TN", "name": "ROMAGNANO (soppresso)" },
    { "code": "H503", "province": "SA", "name": "ROMAGNANO AL MONTE" },
    { "code": "H502", "province": "NO", "name": "ROMAGNANO SESIA" },
    { "code": "H505", "province": "PV", "name": "ROMAGNESE" },
    { "code": "H505", "province": "PC", "name": "ROMAGNESE (soppresso)" },
    { "code": "H506", "province": "TN", "name": "ROMALLO" },
    { "code": "H507", "province": "SS", "name": "ROMANA" },
    { "code": "H508", "province": "CR", "name": "ROMANENGO" },
    { "code": "H510", "province": "CO", "name": "ROMANO' BRIANZA (soppresso)" },
    { "code": "H511", "province": "TO", "name": "ROMANO CANAVESE" },
    { "code": "H511", "province": "AO", "name": "ROMANO CANAVESE (soppresso)" },
    { "code": "H512", "province": "VI", "name": "ROMANO D'EZZELINO" },
    { "code": "H509", "province": "BG", "name": "ROMANO DI LOMBARDIA" },
    { "code": "H513", "province": "GO", "name": "ROMANS (soppresso)" },
    { "code": "H513", "province": "UD", "name": "ROMANS (soppresso)" },
    { "code": "H514", "province": "GO", "name": "ROMANS D'ISONZO" },
    { "code": "H515", "province": "TN", "name": "ROMARZOLO (soppresso)" },
    { "code": "H516", "province": "CZ", "name": "ROMBIOLO (soppresso)" },
    { "code": "H516", "province": "VV", "name": "ROMBIOLO" },
    { "code": "H517", "province": "TN", "name": "ROMENO" },
    { "code": "H518", "province": "NO", "name": "ROMENTINO" },
    { "code": "H519", "province": "ME", "name": "ROMETTA" },
    { "code": "H521", "province": "CO", "name": "RONAGO" },
    { "code": "H522", "province": "VR", "name": "RONCA'" },
    { "code": "H523", "province": "TV", "name": "RONCADE" },
    { "code": "H525", "province": "BS", "name": "RONCADELLE" },
    { "code": "H527", "province": "PV", "name": "RONCARO" },
    { "code": "H528", "province": "TN", "name": "RONCEGNO (soppresso)" },
    { "code": "H528", "province": "TN", "name": "RONCEGNO TERME" },
    { "code": "H529", "province": "MI", "name": "RONCELLO (soppresso)" },
    { "code": "H529", "province": "MB", "name": "RONCELLO" },
    { "code": "H532", "province": "TN", "name": "RONCHI (soppresso)" },
    { "code": "H531", "province": "GO", "name": "RONCHI (soppresso)" },
    { "code": "H531", "province": "TS", "name": "RONCHI (soppresso)" },
    { "code": "H531", "province": "TS", "name": "RONCHI DEI LEGIONARI (soppresso)" },
    { "code": "H531", "province": "GO", "name": "RONCHI DEI LEGIONARI" },
    { "code": "H531", "province": "TS", "name": "RONCHI DI MONFALCONE (soppresso)" },
    { "code": "H532", "province": "TN", "name": "RONCHI VALSUGANA" },
    { "code": "H533", "province": "UD", "name": "RONCHIS" },
    { "code": "H534", "province": "RM", "name": "RONCIGLIONE (soppresso)" },
    { "code": "H534", "province": "VT", "name": "RONCIGLIONE" },
    { "code": "H540", "province": "VR", "name": "RONCO ALL'ADIGE" },
    { "code": "H538", "province": "NO", "name": "RONCO BIELLESE (soppresso)" },
    { "code": "H538", "province": "VC", "name": "RONCO BIELLESE (soppresso)" },
    { "code": "H538", "province": "BI", "name": "RONCO BIELLESE" },
    { "code": "H537", "province": "MI", "name": "RONCO BRIANTINO (soppresso)" },
    { "code": "H537", "province": "MB", "name": "RONCO BRIANTINO" },
    { "code": "H539", "province": "TO", "name": "RONCO CANAVESE" },
    { "code": "H539", "province": "AO", "name": "RONCO CANAVESE (soppresso)" },
    { "code": "H536", "province": "GE", "name": "RONCO SCRIVIA" },
    { "code": "H535", "province": "BG", "name": "RONCOBELLO" },
    { "code": "H541", "province": "MN", "name": "RONCOFERRARO" },
    { "code": "H542", "province": "FO", "name": "RONCOFREDDO (soppresso)" },
    { "code": "H542", "province": "FC", "name": "RONCOFREDDO" },
    { "code": "H543", "province": "TN", "name": "RONCOGNO (soppresso)" },
    { "code": "H544", "province": "BG", "name": "RONCOLA" },
    { "code": "H545", "province": "TN", "name": "RONCONE (soppresso)" },
    { "code": "H546", "province": "PV", "name": "RONDANINA (soppresso)" },
    { "code": "H546", "province": "GE", "name": "RONDANINA" },
    { "code": "H547", "province": "TO", "name": "RONDISSONE" },
    { "code": "H548", "province": "CO", "name": "RONGIO (soppresso)" },
    { "code": "H549", "province": "NO", "name": "RONSECCO (soppresso)" },
    { "code": "H549", "province": "VC", "name": "RONSECCO" },
    { "code": "H550", "province": "GO", "name": "RONZINA (soppresso)" },
    { "code": "H550", "province": "UD", "name": "RONZINA (soppresso)" },
    { "code": "H551", "province": "TN", "name": "RONZO (soppresso)" },
    { "code": "M303", "province": "TN", "name": "RONZO-CHIENIS" },
    { "code": "H552", "province": "TN", "name": "RONZONE" },
    { "code": "H553", "province": "NO", "name": "ROPPOLO (soppresso)" },
    { "code": "H553", "province": "VC", "name": "ROPPOLO (soppresso)" },
    { "code": "H553", "province": "BI", "name": "ROPPOLO" },
    { "code": "H554", "province": "TO", "name": "RORA'" },
    { "code": "H555", "province": "TO", "name": "RORETO (soppresso)" },
    { "code": "H555", "province": "TO", "name": "RORETO CHISONE (soppresso)" },
    { "code": "H556", "province": "VI", "name": "ROSA'" },
    { "code": "H557", "province": "RC", "name": "ROSALI' (soppresso)" },
    { "code": "H558", "province": "RC", "name": "ROSARNO" },
    { "code": "H559", "province": "PV", "name": "ROSASCO" },
    { "code": "H560", "province": "MI", "name": "ROSATE" },
    { "code": "H561", "province": "NO", "name": "ROSAZZA (soppresso)" },
    { "code": "H561", "province": "VC", "name": "ROSAZZA (soppresso)" },
    { "code": "H561", "province": "BI", "name": "ROSAZZA" },
    { "code": "H562", "province": "TE", "name": "ROSCIANO (soppresso)" },
    { "code": "H562", "province": "PE", "name": "ROSCIANO" },
    { "code": "H563", "province": "BG", "name": "ROSCIATE (soppresso)" },
    { "code": "H564", "province": "SA", "name": "ROSCIGNO" },
    { "code": "H565", "province": "CS", "name": "ROSE" },
    { "code": "H566", "province": "CH", "name": "ROSELLO" },
    { "code": "H572", "province": "CS", "name": "ROSETO CAPO SPULICO" },
    { "code": "F585", "province": "TE", "name": "ROSETO DEGLI ABRUZZI" },
    { "code": "H568", "province": "FG", "name": "ROSETO VALFORTORE" },
    { "code": "H570", "province": "PI", "name": "ROSIGNANO MARITTIMO (soppresso)" },
    { "code": "H570", "province": "LI", "name": "ROSIGNANO MARITTIMO" },
    { "code": "H569", "province": "AL", "name": "ROSIGNANO MONFERRATO" },
    { "code": "H571", "province": "AL", "name": "ROSINGO (soppresso)" },
    { "code": "H572", "province": "CS", "name": "ROSITO CAPO SPULICO (soppresso)" },
    { "code": "H573", "province": "RO", "name": "ROSOLINA" },
    { "code": "H574", "province": "SR", "name": "ROSOLINI" },
    { "code": "H575", "province": "AN", "name": "ROSORA" },
    { "code": "H576", "province": "AN", "name": "ROSORA MERGO (soppresso)" },
    { "code": "H577", "province": "NO", "name": "ROSSA (soppresso)" },
    { "code": "H577", "province": "VC", "name": "ROSSA" },
    { "code": "H578", "province": "CN", "name": "ROSSANA" },
    { "code": "H579", "province": "CS", "name": "ROSSANO (soppresso)" },
    { "code": "H580", "province": "VI", "name": "ROSSANO VENETO" },
    { "code": "H581", "province": "GE", "name": "ROSSIGLIONE" },
    { "code": "H582", "province": "BG", "name": "ROSSINO (soppresso)" },
    { "code": "H583", "province": "TO", "name": "ROSTA" },
    { "code": "H584", "province": "BG", "name": "ROTA (soppresso)" },
    { "code": "H586", "province": "BG", "name": "ROTA DENTRO (soppresso)" },
    { "code": "H584", "province": "BG", "name": "ROTA D'IMAGNA" },
    { "code": "H587", "province": "BG", "name": "ROTA FUORI (soppresso)" },
    { "code": "H585", "province": "CS", "name": "ROTA GRECA" },
    { "code": "H588", "province": "AP", "name": "ROTELLA" },
    { "code": "H589", "province": "CB", "name": "ROTELLO" },
    { "code": "H590", "province": "PZ", "name": "ROTONDA" },
    { "code": "H591", "province": "PZ", "name": "ROTONDELLA (soppresso)" },
    { "code": "H591", "province": "MT", "name": "ROTONDELLA" },
    { "code": "H592", "province": "AV", "name": "ROTONDI" },
    { "code": "H593", "province": "PC", "name": "ROTTOFRENO" },
    { "code": "H594", "province": "VI", "name": "ROTZO" },
    { "code": "H555", "province": "TO", "name": "ROURE" },
    { "code": "H596", "province": "CO", "name": "ROVAGNATE (soppresso)" },
    { "code": "H596", "province": "LC", "name": "ROVAGNATE (soppresso)" },
    { "code": "H364", "province": "VC", "name": "ROVASENDA" },
    { "code": "H597", "province": "CO", "name": "ROVATE (soppresso)" },
    { "code": "H597", "province": "VA", "name": "ROVATE (soppresso)" },
    { "code": "H598", "province": "BS", "name": "ROVATO" },
    { "code": "H599", "province": "PV", "name": "ROVEGNO (soppresso)" },
    { "code": "H599", "province": "GE", "name": "ROVEGNO" },
    { "code": "H600", "province": "NO", "name": "ROVEGRO (soppresso)" },
    { "code": "H601", "province": "CO", "name": "ROVELLASCA" },
    { "code": "H602", "province": "CO", "name": "ROVELLO (soppresso)" },
    { "code": "H602", "province": "CO", "name": "ROVELLO PORRO" },
    { "code": "H603", "province": "CO", "name": "ROVENNA (soppresso)" },
    { "code": "H605", "province": "TN", "name": "ROVER CARBONARE (soppresso)" },
    { "code": "H604", "province": "MN", "name": "ROVERBELLA" },
    { "code": "H606", "province": "VR", "name": "ROVERCHIARA" },
    { "code": "H607", "province": "TN", "name": "ROVERE' DELLA LUNA" },
    { "code": "H608", "province": "VR", "name": "ROVERE' DI VELO (soppresso)" },
    { "code": "H608", "province": "VR", "name": "ROVERE' VERONESE" },
    { "code": "H610", "province": "VR", "name": "ROVEREDO DI GUA'" },
    { "code": "H609", "province": "UD", "name": "ROVEREDO IN PIANO (soppresso)" },
    { "code": "H609", "province": "PN", "name": "ROVEREDO IN PIANO" },
    { "code": "H612", "province": "TN", "name": "ROVERETO" },
    { "code": "H613", "province": "FO", "name": "ROVERSANO (soppresso)" },
    { "code": "H614", "province": "PV", "name": "ROVESCALA" },
    { "code": "H615", "province": "BG", "name": "ROVETTA" },
    { "code": "H616", "province": "BG", "name": "ROVETTA CON FINO (soppresso)" },
    { "code": "H601", "province": "CO", "name": "ROVI PORRO (soppresso)" },
    { "code": "H618", "province": "RM", "name": "ROVIANO" },
    { "code": "H619", "province": "PL", "name": "ROVIGNO (soppresso)" },
    { "code": "H619", "province": "PL", "name": "ROVIGNO D'ISTRIA (soppresso)" },
    { "code": "H620", "province": "RO", "name": "ROVIGO" },
    { "code": "H621", "province": "CS", "name": "ROVITO" },
    { "code": "H622", "province": "PD", "name": "ROVOLON" },
    { "code": "H623", "province": "MI", "name": "ROZZANO" },
    { "code": "H624", "province": "PL", "name": "ROZZO (soppresso)" },
    { "code": "H625", "province": "PD", "name": "RUBANO" },
    { "code": "H626", "province": "CR", "name": "RUBBIANO (soppresso)" },
    { "code": "H627", "province": "TO", "name": "RUBIANA" },
    { "code": "H628", "province": "RE", "name": "RUBIERA" },
    { "code": "H629", "province": "UD", "name": "RUDA" },
    { "code": "H630", "province": "BS", "name": "RUDIANO" },
    { "code": "H631", "province": "TO", "name": "RUEGLIO" },
    { "code": "H631", "province": "AO", "name": "RUEGLIO (soppresso)" },
    { "code": "H632", "province": "LE", "name": "RUFFANO" },
    { "code": "H633", "province": "CN", "name": "RUFFIA" },
    { "code": "H634", "province": "TN", "name": "RUFFRE' (soppresso)" },
    { "code": "H634", "province": "TN", "name": "RUFFRE'-MENDOLA" },
    { "code": "H635", "province": "FI", "name": "RUFINA" },
    { "code": "H636", "province": "MI", "name": "RUGINELLO (soppresso)" },
    { "code": "ND", "province": "CA", "name": "RUINAS (soppresso)" },
    { "code": "F271", "province": "CA", "name": "RUINAS (soppresso)" },
    { "code": "F271", "province": "OR", "name": "RUINAS" },
    { "code": "H637", "province": "PV", "name": "RUINO (soppresso)" },
    { "code": "H637", "province": "PC", "name": "RUINO (soppresso)" },
    { "code": "H638", "province": "NO", "name": "RUMIANCA (soppresso)" },
    { "code": "H639", "province": "TN", "name": "RUMO" },
    { "code": "H640", "province": "CO", "name": "RUNO (soppresso)" },
    { "code": "H640", "province": "VA", "name": "RUNO (soppresso)" },
    { "code": "H641", "province": "PZ", "name": "RUOTI" },
    { "code": "F378", "province": "TS", "name": "RUPIN GRANDE (soppresso)" },
    { "code": "H642", "province": "RA", "name": "RUSSI" },
    { "code": "H643", "province": "BA", "name": "RUTIGLIANO" },
    { "code": "H644", "province": "SA", "name": "RUTINO" },
    { "code": "H165", "province": "CE", "name": "RUVIANO" },
    { "code": "H165", "province": "BN", "name": "RUVIANO (soppresso)" },
    { "code": "H646", "province": "PZ", "name": "RUVO DEL MONTE" },
    { "code": "H645", "province": "BA", "name": "RUVO DI PUGLIA" },
    { "code": "H647", "province": "RM", "name": "SABAUDIA (soppresso)" },
    { "code": "H647", "province": "LT", "name": "SABAUDIA" },
    { "code": "H648", "province": "NO", "name": "SABBIA (soppresso)" },
    { "code": "H648", "province": "VC", "name": "SABBIA (soppresso)" },
    { "code": "H649", "province": "BG", "name": "SABBIO BERGAMASCO (soppresso)" },
    { "code": "H650", "province": "BS", "name": "SABBIO CHIESE" },
    { "code": "H651", "province": "CO", "name": "SABBIONCELLO (soppresso)" },
    { "code": "H652", "province": "MN", "name": "SABBIONETA" },
    { "code": "H653", "province": "UD", "name": "SABLE GRANDE (soppresso)" },
    { "code": "H653", "province": "GO", "name": "SABLE GRANDE (soppresso)" },
    { "code": "H654", "province": "SA", "name": "SACCO" },
    { "code": "H655", "province": "PD", "name": "SACCOLONGO" },
    { "code": "H656", "province": "MI", "name": "SACCONAGO (soppresso)" },
    { "code": "H656", "province": "VA", "name": "SACCONAGO (soppresso)" },
    { "code": "H657", "province": "UD", "name": "SACILE (soppresso)" },
    { "code": "H657", "province": "PN", "name": "SACILE" },
    { "code": "H658", "province": "RM", "name": "SACROFANO" },
    { "code": "H659", "province": "CA", "name": "SADALI (soppresso)" },
    { "code": "H659", "province": "NU", "name": "SADALI (soppresso)" },
    { "code": "H659", "province": "SU", "name": "SADALI" },
    { "code": "H660", "province": "GO", "name": "SAGA (soppresso)" },
    { "code": "H660", "province": "UD", "name": "SAGA (soppresso)" },
    { "code": "H661", "province": "CA", "name": "SAGAMA (soppresso)" },
    { "code": "H661", "province": "NU", "name": "SAGAMA (soppresso)" },
    { "code": "H661", "province": "OR", "name": "SAGAMA" },
    { "code": "H663", "province": "PV", "name": "SAGLIANO DI CRENNA (soppresso)" },
    { "code": "H662", "province": "NO", "name": "SAGLIANO MICCA (soppresso)" },
    { "code": "H662", "province": "VC", "name": "SAGLIANO MICCA (soppresso)" },
    { "code": "H662", "province": "BI", "name": "SAGLIANO MICCA" },
    { "code": "H664", "province": "FU", "name": "SAGORIA SAN MARTINO (soppresso)" },
    { "code": "H664", "province": "PL", "name": "SAGORIA SAN MARTINO (soppresso)" },
    { "code": "H665", "province": "GO", "name": "SAGRADO" },
    { "code": "H665", "province": "UD", "name": "SAGRADO (soppresso)" },
    { "code": "H666", "province": "TN", "name": "SAGRON MIS" },
    { "code": "H668", "province": "BS", "name": "SAIANO (soppresso)" },
    { "code": "H669", "province": "TO", "name": "SAINT CHRISTOPHE (soppresso)" },
    { "code": "H669", "province": "AO", "name": "SAINT CHRISTOPHE (soppresso)" },
    { "code": "H670", "province": "TO", "name": "SAINT DENIS (soppresso)" },
    { "code": "H670", "province": "AO", "name": "SAINT DENIS (soppresso)" },
    { "code": "H671", "province": "TO", "name": "SAINT MARCEL (soppresso)" },
    { "code": "H671", "province": "AO", "name": "SAINT MARCEL (soppresso)" },
    { "code": "H672", "province": "TO", "name": "SAINT NICOLAS (soppresso)" },
    { "code": "H672", "province": "AO", "name": "SAINT NICOLAS (soppresso)" },
    { "code": "H673", "province": "TO", "name": "SAINT OYEN (soppresso)" },
    { "code": "H673", "province": "AO", "name": "SAINT OYEN (soppresso)" },
    { "code": "H674", "province": "TO", "name": "SAINT PIERRE (soppresso)" },
    { "code": "H674", "province": "AO", "name": "SAINT PIERRE (soppresso)" },
    { "code": "H675", "province": "TO", "name": "SAINT RHEMY (soppresso)" },
    { "code": "H675", "province": "AO", "name": "SAINT RHEMY (soppresso)" },
    { "code": "H676", "province": "TO", "name": "SAINT VINCENT (soppresso)" },
    { "code": "H676", "province": "AO", "name": "SAINT VINCENT (soppresso)" },
    { "code": "H669", "province": "AO", "name": "SAINT-CHRISTOPHE" },
    { "code": "H670", "province": "AO", "name": "SAINT-DENIS" },
    { "code": "H671", "province": "AO", "name": "SAINT-MARCEL" },
    { "code": "H672", "province": "AO", "name": "SAINT-NICOLAS" },
    { "code": "H673", "province": "AO", "name": "SAINT-OYEN" },
    { "code": "H674", "province": "AO", "name": "SAINT-PIERRE" },
    { "code": "H675", "province": "AO", "name": "SAINT-RHEMY (soppresso)" },
    { "code": "H675", "province": "AO", "name": "SAINT-RHEMY-EN-BOSSES" },
    { "code": "H676", "province": "AO", "name": "SAINT-VINCENT" },
    { "code": "H680", "province": "CO", "name": "SALA AL BARRO (soppresso)" },
    { "code": "H682", "province": "PR", "name": "SALA BAGANZA" },
    { "code": "H681", "province": "NO", "name": "SALA BIELLESE (soppresso)" },
    { "code": "H681", "province": "VC", "name": "SALA BIELLESE (soppresso)" },
    { "code": "H681", "province": "BI", "name": "SALA BIELLESE" },
    { "code": "H678", "province": "BO", "name": "SALA BOLOGNESE" },
    { "code": "H679", "province": "CO", "name": "SALA COMACINA" },
    { "code": "H683", "province": "SA", "name": "SALA CONSILINA" },
    { "code": "E458", "province": "AO", "name": "SALA DORA (soppresso)" },
    { "code": "H677", "province": "AL", "name": "SALA MONFERRATO" },
    { "code": "H684", "province": "TO", "name": "SALABERTANO (soppresso)" },
    { "code": "H685", "province": "AL", "name": "SALABUE (soppresso)" },
    { "code": "H687", "province": "PZ", "name": "SALANDRA (soppresso)" },
    { "code": "H687", "province": "MT", "name": "SALANDRA" },
    { "code": "H688", "province": "TP", "name": "SALAPARUTA" },
    { "code": "H689", "province": "RO", "name": "SALARA" },
    { "code": "H690", "province": "NO", "name": "SALASCO (soppresso)" },
    { "code": "H690", "province": "VC", "name": "SALASCO" },
    { "code": "H691", "province": "TO", "name": "SALASSA" },
    { "code": "H691", "province": "AO", "name": "SALASSA (soppresso)" },
    { "code": "H684", "province": "TO", "name": "SALBERTRAND" },
    { "code": "H692", "province": "GO", "name": "SALCANO (soppresso)" },
    { "code": "H692", "province": "UD", "name": "SALCANO (soppresso)" },
    { "code": "F810", "province": "VI", "name": "SALCEDO" },
    { "code": "H693", "province": "CB", "name": "SALCITO" },
    { "code": "H694", "province": "AL", "name": "SALE" },
    { "code": "H697", "province": "TO", "name": "SALE CASTELNUOVO (soppresso)" },
    { "code": "H697", "province": "AO", "name": "SALE CASTELNUOVO (soppresso)" },
    { "code": "H695", "province": "CN", "name": "SALE DELLE LANGHE" },
    { "code": "H699", "province": "BS", "name": "SALE MARASINO" },
    { "code": "H704", "province": "CN", "name": "SALE SAN GIOVANNI" },
    { "code": "H698", "province": "NO", "name": "SALECCHIO (soppresso)" },
    { "code": "H700", "province": "TP", "name": "SALEMI" },
    { "code": "H686", "province": "SA", "name": "SALENTO" },
    { "code": "H702", "province": "TO", "name": "SALERANO CANAVESE" },
    { "code": "H702", "province": "AO", "name": "SALERANO CANAVESE (soppresso)" },
    { "code": "H701", "province": "MI", "name": "SALERANO SUL LAMBRO (soppresso)" },
    { "code": "H701", "province": "LO", "name": "SALERANO SUL LAMBRO" },
    { "code": "H703", "province": "SA", "name": "SALERNO" },
    { "code": "H705", "province": "PD", "name": "SALETTO (soppresso)" },
    { "code": "H706", "province": "TV", "name": "SALGAREDA" },
    { "code": "H707", "province": "NO", "name": "SALI VERCELLESE (soppresso)" },
    { "code": "H707", "province": "VC", "name": "SALI VERCELLESE" },
    { "code": "H709", "province": "RC", "name": "SALICE CALABRO (soppresso)" },
    { "code": "H708", "province": "LE", "name": "SALICE SALENTINO" },
    { "code": "H708", "province": "BR", "name": "SALICE SALENTINO (soppresso)" },
    { "code": "H710", "province": "CN", "name": "SALICETO" },
    { "code": "H711", "province": "ME", "name": "SALINA (soppresso)" },
    { "code": "H713", "province": "PG", "name": "SALISANO (soppresso)" },
    { "code": "H713", "province": "RM", "name": "SALISANO (soppresso)" },
    { "code": "H713", "province": "RI", "name": "SALISANO" },
    { "code": "H714", "province": "VR", "name": "SALIZZOLE" },
    { "code": "H715", "province": "CH", "name": "SALLE (soppresso)" },
    { "code": "H715", "province": "PE", "name": "SALLE" },
    { "code": "H716", "province": "CN", "name": "SALMORE (soppresso)" },
    { "code": "H716", "province": "CN", "name": "SALMOUR" },
    { "code": "H717", "province": "BS", "name": "SALO'" },
    { "code": "H718", "province": "GO", "name": "SALONA D'ISONZO (soppresso)" },
    { "code": "H719", "province": "TN", "name": "SALORNO (soppresso)" },
    { "code": "H719", "province": "BZ", "name": "SALORNO" },
    { "code": "H720", "province": "PR", "name": "SALSOMAGGIORE (soppresso)" },
    { "code": "H720", "province": "PR", "name": "SALSOMAGGIORE TERME" },
    { "code": "H721", "province": "PS", "name": "SALTARA (soppresso)" },
    { "code": "H721", "province": "PU", "name": "SALTARA (soppresso)" },
    { "code": "E857", "province": "TN", "name": "SALTER-MALGOLO (soppresso)" },
    { "code": "H722", "province": "TO", "name": "SALTO (soppresso)" },
    { "code": "H722", "province": "AO", "name": "SALTO (soppresso)" },
    { "code": "I768", "province": "GO", "name": "SALTO DI VIPACCO (soppresso)" },
    { "code": "I768", "province": "UD", "name": "SALTO DI VIPACCO (soppresso)" },
    { "code": "H723", "province": "CO", "name": "SALTRIO (soppresso)" },
    { "code": "H723", "province": "VA", "name": "SALTRIO" },
    { "code": "H724", "province": "FO", "name": "SALUDECIO (soppresso)" },
    { "code": "H724", "province": "RN", "name": "SALUDECIO" },
    { "code": "H725", "province": "NO", "name": "SALUGGIA (soppresso)" },
    { "code": "H725", "province": "VC", "name": "SALUGGIA" },
    { "code": "H726", "province": "NO", "name": "SALUSSOLA (soppresso)" },
    { "code": "H726", "province": "VC", "name": "SALUSSOLA (soppresso)" },
    { "code": "H726", "province": "BI", "name": "SALUSSOLA" },
    { "code": "H727", "province": "CN", "name": "SALUZZO" },
    { "code": "B653", "province": "CO", "name": "SALVADERA (soppresso)" },
    { "code": "H728", "province": "RO", "name": "SALVATERRA (soppresso)" },
    { "code": "H729", "province": "LE", "name": "SALVE" },
    { "code": "H731", "province": "CR", "name": "SALVIROLA" },
    { "code": "H731", "province": "CR", "name": "SALVIROLA CREMASCA (soppresso)" },
    { "code": "H732", "province": "SA", "name": "SALVITELLE" },
    { "code": "H734", "province": "TO", "name": "SALZA DI PINEROLO" },
    { "code": "H733", "province": "AV", "name": "SALZA IRPINA" },
    { "code": "H735", "province": "VE", "name": "SALZANO" },
    { "code": "H736", "province": "MI", "name": "SAMARATE (soppresso)" },
    { "code": "H736", "province": "VA", "name": "SAMARATE" },
    { "code": "H737", "province": "GO", "name": "SAMARIA (soppresso)" },
    { "code": "H737", "province": "UD", "name": "SAMARIA (soppresso)" },
    { "code": "H738", "province": "CA", "name": "SAMASSI (soppresso)" },
    { "code": "H738", "province": "VS", "name": "SAMASSI (soppresso)" },
    { "code": "H738", "province": "SU", "name": "SAMASSI" },
    { "code": "H739", "province": "CA", "name": "SAMATZAI (soppresso)" },
    { "code": "H739", "province": "SU", "name": "SAMATZAI" },
    { "code": "H740", "province": "UD", "name": "SAMBASSO (soppresso)" },
    { "code": "H740", "province": "GO", "name": "SAMBASSO (soppresso)" },
    { "code": "H741", "province": "RC", "name": "SAMBATELLO (soppresso)" },
    { "code": "H742", "province": "CZ", "name": "SAMBIASE (soppresso)" },
    { "code": "H743", "province": "AG", "name": "SAMBUCA DI SICILIA" },
    { "code": "H744", "province": "FI", "name": "SAMBUCA PISTOIESE (soppresso)" },
    { "code": "H744", "province": "PT", "name": "SAMBUCA PISTOIESE" },
    { "code": "H743", "province": "AG", "name": "SAMBUCA ZABUT (soppresso)" },
    { "code": "H745", "province": "RM", "name": "SAMBUCI" },
    { "code": "H746", "province": "CN", "name": "SAMBUCO" },
    { "code": "H747", "province": "CN", "name": "SAMBUCO PIETRAPORZIO (soppresso)" },
    { "code": "H748", "province": "NO", "name": "SAMBUGHETTO (soppresso)" },
    { "code": "H749", "province": "BA", "name": "SAMMICHELE DI BARI" },
    { "code": "H013", "province": "RC", "name": "SAMO" },
    { "code": "H751", "province": "RC", "name": "SAMO DI CALABRIA (soppresso)" },
    { "code": "H750", "province": "TN", "name": "SAMOCLEVO (soppresso)" },
    { "code": "H752", "province": "SO", "name": "SAMOLACO" },
    { "code": "H753", "province": "TO", "name": "SAMONE" },
    { "code": "H754", "province": "TN", "name": "SAMONE" },
    { "code": "H753", "province": "AO", "name": "SAMONE (soppresso)" },
    { "code": "H755", "province": "CN", "name": "SAMPEIRE (soppresso)" },
    { "code": "H755", "province": "CN", "name": "SAMPEYRE (soppresso)" },
    { "code": "H756", "province": "CA", "name": "SAMUGHEO (soppresso)" },
    { "code": "H756", "province": "OR", "name": "SAMUGHEO" },
    { "code": "H763", "province": "IM", "name": "SAN BARTOLOMEO AL MARE" },
    { "code": "H763", "province": "IM", "name": "SAN BARTOLOMEO DEL CERVO (soppresso)" },
    { "code": "H764", "province": "BN", "name": "SAN BARTOLOMEO IN GALDO" },
    { "code": "H760", "province": "CO", "name": "SAN BARTOLOMEO VAL CAVARGNA" },
    { "code": "H762", "province": "NO", "name": "SAN BARTOLOMEO VALMARA (soppresso)" },
    { "code": "H765", "province": "CS", "name": "SAN BASILE" },
    { "code": "H766", "province": "CA", "name": "SAN BASILIO (soppresso)" },
    { "code": "H766", "province": "SU", "name": "SAN BASILIO" },
    { "code": "H767", "province": "CR", "name": "SAN BASSANO" },
    { "code": "H768", "province": "RO", "name": "SAN BELLINO" },
    { "code": "H770", "province": "CN", "name": "SAN BENEDETTO BELBO" },
    { "code": "H772", "province": "AQ", "name": "SAN BENEDETTO DEI MARSI" },
    { "code": "H769", "province": "AP", "name": "SAN BENEDETTO DEL TRONTO" },
    { "code": "H773", "province": "AQ", "name": "SAN BENEDETTO IN PERILLIS" },
    { "code": "H771", "province": "MN", "name": "SAN BENEDETTO PO" },
    { "code": "H774", "province": "CS", "name": "SAN BENEDETTO ULLANO" },
    { "code": "G566", "province": "BO", "name": "SAN BENEDETTO VAL DI SAMBRO" },
    { "code": "H775", "province": "TO", "name": "SAN BENIGNO CANAVESE" },
    { "code": "H776", "province": "CR", "name": "SAN BERNARDINO (soppresso)" },
    { "code": "H777", "province": "NO", "name": "SAN BERNARDINO VERBANO (soppresso)" },
    { "code": "H777", "province": "VB", "name": "SAN BERNARDINO VERBANO" },
    { "code": "H780", "province": "IM", "name": "SAN BIAGIO DELLA CIMA" },
    { "code": "H781", "province": "TV", "name": "SAN BIAGIO DI CALLALTA" },
    { "code": "H778", "province": "AG", "name": "SAN BIAGIO PLATANI" },
    { "code": "H779", "province": "CE", "name": "SAN BIAGIO SARACINISCO (soppresso)" },
    { "code": "H779", "province": "FR", "name": "SAN BIAGIO SARACINISCO" },
    { "code": "H782", "province": "CB", "name": "SAN BIASE" },
    { "code": "H783", "province": "VR", "name": "SAN BONIFACIO" },
    { "code": "H784", "province": "CH", "name": "SAN BUONO" },
    { "code": "H785", "province": "CZ", "name": "SAN CALOGERO (soppresso)" },
    { "code": "H785", "province": "VV", "name": "SAN CALOGERO" },
    { "code": "H786", "province": "TN", "name": "SAN CANDIDO (soppresso)" },
    { "code": "H786", "province": "BZ", "name": "SAN CANDIDO" },
    { "code": "H787", "province": "TS", "name": "SAN CANZIAN D'ISONZO (soppresso)" },
    { "code": "H787", "province": "GO", "name": "SAN CANZIAN D'ISONZO" },
    { "code": "H787", "province": "GO", "name": "SAN CANZIANO (soppresso)" },
    { "code": "H787", "province": "TS", "name": "SAN CANZIANO (soppresso)" },
    { "code": "H789", "province": "TO", "name": "SAN CARLO CANAVESE" },
    { "code": "H789", "province": "TO", "name": "SAN CARLO DI CIRIE' (soppresso)" },
    { "code": "H790", "province": "SI", "name": "SAN CASCIANO DEI BAGNI" },
    { "code": "H791", "province": "FI", "name": "SAN CASCIANO IN VAL DI PESA" },
    { "code": "M264", "province": "LE", "name": "SAN CASSIANO" },
    { "code": "H792", "province": "CL", "name": "SAN CATALDO" },
    { "code": "M295", "province": "RM", "name": "SAN CESAREO" },
    { "code": "H793", "province": "LE", "name": "SAN CESARIO DI LECCE" },
    { "code": "H794", "province": "MO", "name": "SAN CESARIO SUL PANARO" },
    { "code": "H795", "province": "PZ", "name": "SAN CHIRICO NUOVO" },
    { "code": "H796", "province": "PZ", "name": "SAN CHIRICO RAPARO" },
    { "code": "H797", "province": "PA", "name": "SAN CIPIRELLO" },
    { "code": "H798", "province": "CE", "name": "SAN CIPRIANO D'AVERSA" },
    { "code": "H798", "province": "NA", "name": "SAN CIPRIANO D'AVERSA (soppresso)" },
    { "code": "H800", "province": "SA", "name": "SAN CIPRIANO PICENTINO" },
    { "code": "H799", "province": "PV", "name": "SAN CIPRIANO PO" },
    { "code": "H801", "province": "FO", "name": "SAN CLEMENTE (soppresso)" },
    { "code": "H801", "province": "RN", "name": "SAN CLEMENTE" },
    { "code": "H803", "province": "MI", "name": "SAN COLOMBANO AL LAMBRO" },
    { "code": "H804", "province": "TO", "name": "SAN COLOMBANO BELMONTE" },
    { "code": "H804", "province": "AO", "name": "SAN COLOMBANO BELMONTE (soppresso)" },
    { "code": "H802", "province": "GE", "name": "SAN COLOMBANO CERTENOLI" },
    { "code": "H805", "province": "CT", "name": "SAN CONO" },
    { "code": "H806", "province": "CS", "name": "SAN COSMO ALBANESE" },
    { "code": "H808", "province": "PZ", "name": "SAN COSTANTINO ALBANESE" },
    { "code": "H807", "province": "CZ", "name": "SAN COSTANTINO CALABRO (soppresso)" },
    { "code": "H807", "province": "VV", "name": "SAN COSTANTINO CALABRO" },
    { "code": "H809", "province": "PS", "name": "SAN COSTANZO (soppresso)" },
    { "code": "H809", "province": "PU", "name": "SAN COSTANZO" },
    { "code": "H810", "province": "AL", "name": "SAN CRISTOFORO" },
    { "code": "H814", "province": "PV", "name": "SAN DAMIANO AL COLLE" },
    { "code": "H811", "province": "AL", "name": "SAN DAMIANO D'ASTI (soppresso)" },
    { "code": "H811", "province": "AT", "name": "SAN DAMIANO D'ASTI" },
    { "code": "H812", "province": "CN", "name": "SAN DAMIANO MACRA" },
    { "code": "H817", "province": "GO", "name": "SAN DANIELE DEL CARSO (soppresso)" },
    { "code": "H817", "province": "UD", "name": "SAN DANIELE DEL CARSO (soppresso)" },
    { "code": "H816", "province": "UD", "name": "SAN DANIELE DEL FRIULI" },
    { "code": "H815", "province": "CR", "name": "SAN DANIELE PO" },
    { "code": "H815", "province": "CR", "name": "SAN DANIELE RIPA PO (soppresso)" },
    { "code": "H818", "province": "CS", "name": "SAN DEMETRIO CORONE" },
    { "code": "H819", "province": "AQ", "name": "SAN DEMETRIO NE' VESTINI" },
    { "code": "H042", "province": "AO", "name": "SAN DESIDERIO TERME (soppresso)" },
    { "code": "H820", "province": "TO", "name": "SAN DIDERO" },
    { "code": "H823", "province": "VE", "name": "SAN DONA' DI PIAVE" },
    { "code": "H822", "province": "LE", "name": "SAN DONACI (soppresso)" },
    { "code": "H822", "province": "BR", "name": "SAN DONACI" },
    { "code": "H826", "province": "LE", "name": "SAN DONATO DI LECCE" },
    { "code": "H825", "province": "CS", "name": "SAN DONATO DI NINEA" },
    { "code": "H827", "province": "MI", "name": "SAN DONATO MILANESE" },
    { "code": "H824", "province": "CE", "name": "SAN DONATO VAL DI COMINO (soppresso)" },
    { "code": "H824", "province": "FR", "name": "SAN DONATO VAL DI COMINO" },
    { "code": "D324", "province": "TS", "name": "SAN DORLIGO DELLA VALLE-DOLINA" },
    { "code": "H830", "province": "CO", "name": "SAN FEDELE (soppresso)" },
    { "code": "H830", "province": "CO", "name": "SAN FEDELE INTELVI (soppresso)" },
    { "code": "H831", "province": "PZ", "name": "SAN FELE" },
    { "code": "H837", "province": "TN", "name": "SAN FELICE (soppresso)" },
    { "code": "H837", "province": "BZ", "name": "SAN FELICE (soppresso)" },
    { "code": "H834", "province": "CE", "name": "SAN FELICE A CANCELLO" },
    { "code": "H834", "province": "NA", "name": "SAN FELICE A CANCELLO (soppresso)" },
    { "code": "H836", "province": "RM", "name": "SAN FELICE CIRCEO (soppresso)" },
    { "code": "H836", "province": "LT", "name": "SAN FELICE CIRCEO" },
    { "code": "H838", "province": "BS", "name": "SAN FELICE DEL BENACO" },
    { "code": "H833", "province": "CB", "name": "SAN FELICE DEL LITTORIO (soppresso)" },
    { "code": "H833", "province": "CB", "name": "SAN FELICE DEL MOLISE" },
    { "code": "H832", "province": "BS", "name": "SAN FELICE DI SCOVOLO (soppresso)" },
    { "code": "H833", "province": "CB", "name": "SAN FELICE SLAVO (soppresso)" },
    { "code": "H835", "province": "MO", "name": "SAN FELICE SUL PANARO" },
    { "code": "M277", "province": "RC", "name": "SAN FERDINANDO" },
    { "code": "H839", "province": "FG", "name": "SAN FERDINANDO DI PUGLIA (soppresso)" },
    { "code": "H839", "province": "BT", "name": "SAN FERDINANDO DI PUGLIA" },
    { "code": "H840", "province": "CO", "name": "SAN FERMO DELLA BATTAGLIA" },
    { "code": "H841", "province": "CS", "name": "SAN FILI" },
    { "code": "H842", "province": "ME", "name": "SAN FILIPPO DEL MELA" },
    { "code": "H843", "province": "TV", "name": "SAN FIOR" },
    { "code": "H844", "province": "MI", "name": "SAN FIORANO (soppresso)" },
    { "code": "H844", "province": "LO", "name": "SAN FIORANO" },
    { "code": "H845", "province": "GO", "name": "SAN FLORIANO (soppresso)" },
    { "code": "H845", "province": "UD", "name": "SAN FLORIANO (soppresso)" },
    { "code": "H845", "province": "UD", "name": "SAN FLORIANO DEL COLLIO (soppresso)" },
    { "code": "H845", "province": "GO", "name": "SAN FLORIANO DEL COLLIO" },
    { "code": "H846", "province": "CZ", "name": "SAN FLORO" },
    { "code": "H847", "province": "TO", "name": "SAN FRANCESCO AL CAMPO" },
    { "code": "H848", "province": "SS", "name": "SAN FRANCESCO D'AGLIENTU (soppresso)" },
    { "code": "H849", "province": "GE", "name": "SAN FRANCESCO D'ALBARO (soppresso)" },
    { "code": "H850", "province": "ME", "name": "SAN FRATELLO" },
    { "code": "H854", "province": "BG", "name": "SAN GALLO (soppresso)" },
    { "code": "H856", "province": "CA", "name": "SAN GAVINO MONREALE (soppresso)" },
    { "code": "H856", "province": "VS", "name": "SAN GAVINO MONREALE (soppresso)" },
    { "code": "H856", "province": "SU", "name": "SAN GAVINO MONREALE" },
    { "code": "H857", "province": "PG", "name": "SAN GEMINI (soppresso)" },
    { "code": "H857", "province": "TR", "name": "SAN GEMINI" },
    { "code": "H859", "province": "PV", "name": "SAN GENESIO (soppresso)" },
    { "code": "H858", "province": "TN", "name": "SAN GENESIO (soppresso)" },
    { "code": "H858", "province": "BZ", "name": "SAN GENESIO (soppresso)" },
    { "code": "H858", "province": "BZ", "name": "SAN GENESIO ATESINO" },
    { "code": "H859", "province": "PV", "name": "SAN GENESIO ED UNITI" },
    { "code": "H860", "province": "CE", "name": "SAN GENNARO (soppresso)" },
    { "code": "H860", "province": "NA", "name": "SAN GENNARO (soppresso)" },
    { "code": "H860", "province": "NA", "name": "SAN GENNARO VESUVIANO" },
    { "code": "H862", "province": "TO", "name": "SAN GERMANO CHISONE" },
    { "code": "H863", "province": "VI", "name": "SAN GERMANO DEI BERICI (soppresso)" },
    { "code": "H861", "province": "NO", "name": "SAN GERMANO VERCELLESE (soppresso)" },
    { "code": "H861", "province": "VC", "name": "SAN GERMANO VERCELLESE" },
    { "code": "H865", "province": "BS", "name": "SAN GERVASIO BRESCIANO" },
    { "code": "H864", "province": "BG", "name": "SAN GERVASIO D'ADDA (soppresso)" },
    { "code": "H869", "province": "TN", "name": "SAN GIACOMO (soppresso)" },
    { "code": "H866", "province": "TN", "name": "SAN GIACOMO (soppresso)" },
    { "code": "H866", "province": "BZ", "name": "SAN GIACOMO (soppresso)" },
    { "code": "H867", "province": "CB", "name": "SAN GIACOMO DEGLI SCHIAVONI" },
    { "code": "H870", "province": "MN", "name": "SAN GIACOMO DELLE SEGNATE" },
    { "code": "H868", "province": "SO", "name": "SAN GIACOMO FILIPPO" },
    { "code": "H871", "province": "TS", "name": "SAN GIACOMO IN COLLE (soppresso)" },
    { "code": "H866", "province": "TN", "name": "SAN GIACOMO IN VALLE AURINA (soppresso)" },
    { "code": "B952", "province": "VC", "name": "SAN GIACOMO VERCELLESE" },
    { "code": "H873", "province": "TO", "name": "SAN GILLIO" },
    { "code": "H874", "province": "TO", "name": "SAN GILLIO TORINESE (soppresso)" },
    { "code": "H875", "province": "SI", "name": "SAN GIMIGNANO" },
    { "code": "H876", "province": "MC", "name": "SAN GINESIO" },
    { "code": "H879", "province": "TN", "name": "SAN GIORGIO (soppresso)" },
    { "code": "H879", "province": "BZ", "name": "SAN GIORGIO (soppresso)" },
    { "code": "H892", "province": "NA", "name": "SAN GIORGIO A CREMANO" },
    { "code": "H880", "province": "CE", "name": "SAN GIORGIO A LIRI (soppresso)" },
    { "code": "H880", "province": "FR", "name": "SAN GIORGIO A LIRI" },
    { "code": "H881", "province": "CS", "name": "SAN GIORGIO ALBANESE" },
    { "code": "H883", "province": "MN", "name": "SAN GIORGIO BIGARELLO" },
    { "code": "H890", "province": "TO", "name": "SAN GIORGIO CANAVESE" },
    { "code": "H890", "province": "AO", "name": "SAN GIORGIO CANAVESE (soppresso)" },
    { "code": "H894", "province": "BN", "name": "SAN GIORGIO DEL SANNIO" },
    { "code": "H891", "province": "UD", "name": "SAN GIORGIO DELLA RICHINVELDA (soppresso)" },
    { "code": "H891", "province": "PN", "name": "SAN GIORGIO DELLA RICHINVELDA" },
    { "code": "H893", "province": "PD", "name": "SAN GIORGIO DELLE PERTICHE" },
    { "code": "E408", "province": "TV", "name": "SAN GIORGIO DI LAGO (soppresso)" },
    { "code": "H885", "province": "PV", "name": "SAN GIORGIO DI LOMELLINA" },
    { "code": "H883", "province": "MN", "name": "SAN GIORGIO DI MANTOVA (soppresso)" },
    { "code": "H895", "province": "UD", "name": "SAN GIORGIO DI NOGARO" },
    { "code": "H886", "province": "PS", "name": "SAN GIORGIO DI PESARO (soppresso)" },
    { "code": "H886", "province": "PU", "name": "SAN GIORGIO DI PESARO (soppresso)" },
    { "code": "H896", "province": "BO", "name": "SAN GIORGIO DI PIANO" },
    { "code": "H897", "province": "PD", "name": "SAN GIORGIO IN BOSCO" },
    { "code": "H879", "province": "TN", "name": "SAN GIORGIO IN VAL TURES (soppresso)" },
    { "code": "H882", "province": "TA", "name": "SAN GIORGIO IONICO" },
    { "code": "H898", "province": "BN", "name": "SAN GIORGIO LA MOLARA" },
    { "code": "H894", "province": "BN", "name": "SAN GIORGIO LA MONTAGNA (soppresso)" },
    { "code": "H888", "province": "PZ", "name": "SAN GIORGIO LUCANO (soppresso)" },
    { "code": "H888", "province": "MT", "name": "SAN GIORGIO LUCANO" },
    { "code": "H878", "province": "AL", "name": "SAN GIORGIO MONFERRATO" },
    { "code": "H889", "province": "RC", "name": "SAN GIORGIO MORGETO" },
    { "code": "H887", "province": "PC", "name": "SAN GIORGIO PIACENTINO" },
    { "code": "H899", "province": "AL", "name": "SAN GIORGIO SCARAMPI (soppresso)" },
    { "code": "H899", "province": "AT", "name": "SAN GIORGIO SCARAMPI" },
    { "code": "H882", "province": "LE", "name": "SAN GIORGIO SOTTO TARANTO (soppresso)" },
    { "code": "H882", "province": "TA", "name": "SAN GIORGIO SOTTO TARANTO (soppresso)" },
    { "code": "H884", "province": "MI", "name": "SAN GIORGIO SU LEGNANO" },
    { "code": "H900", "province": "TO", "name": "SAN GIORIO DI SUSA" },
    { "code": "H902", "province": "TN", "name": "SAN GIOVANNI (soppresso)" },
    { "code": "H902", "province": "BZ", "name": "SAN GIOVANNI (soppresso)" },
    { "code": "H907", "province": "SA", "name": "SAN GIOVANNI A PIRO" },
    { "code": "H908", "province": "NA", "name": "SAN GIOVANNI A TEDUCCIO (soppresso)" },
    { "code": "H906", "province": "UD", "name": "SAN GIOVANNI AL NATISONE" },
    { "code": "H905", "province": "CO", "name": "SAN GIOVANNI ALLA CASTAGNA (soppresso)" },
    { "code": "H909", "province": "GE", "name": "SAN GIOVANNI BATTISTA (soppresso)" },
    { "code": "H910", "province": "BG", "name": "SAN GIOVANNI BIANCO" },
    { "code": "H911", "province": "SI", "name": "SAN GIOVANNI D'ASSO (soppresso)" },
    { "code": "H912", "province": "MN", "name": "SAN GIOVANNI DEL DOSSO" },
    { "code": "H913", "province": "RM", "name": "SAN GIOVANNI DI BIEDA (soppresso)" },
    { "code": "H913", "province": "VT", "name": "SAN GIOVANNI DI BIEDA (soppresso)" },
    { "code": "M390", "province": "TN", "name": "SAN GIOVANNI DI FASSA-SEN JAN" },
    { "code": "H915", "province": "CT", "name": "SAN GIOVANNI DI GALERMO (soppresso)" },
    { "code": "H903", "province": "RC", "name": "SAN GIOVANNI DI GERACE" },
    { "code": "H906", "province": "UD", "name": "SAN GIOVANNI DI MANZANO (soppresso)" },
    { "code": "H914", "province": "AG", "name": "SAN GIOVANNI GEMINI" },
    { "code": "H916", "province": "VI", "name": "SAN GIOVANNI ILARIONE (soppresso)" },
    { "code": "H916", "province": "VR", "name": "SAN GIOVANNI ILARIONE" },
    { "code": "H918", "province": "CR", "name": "SAN GIOVANNI IN CROCE" },
    { "code": "H919", "province": "CS", "name": "SAN GIOVANNI IN FIORE" },
    { "code": "H920", "province": "CB", "name": "SAN GIOVANNI IN GALDO" },
    { "code": "H921", "province": "FO", "name": "SAN GIOVANNI IN MARIGNANO (soppresso)" },
    { "code": "H921", "province": "RN", "name": "SAN GIOVANNI IN MARIGNANO" },
    { "code": "G467", "province": "BO", "name": "SAN GIOVANNI IN PERSICETO" },
    { "code": "H902", "province": "TN", "name": "SAN GIOVANNI IN VALLE AURINA (soppresso)" },
    { "code": "H917", "province": "CE", "name": "SAN GIOVANNI INCARICO (soppresso)" },
    { "code": "H917", "province": "FR", "name": "SAN GIOVANNI INCARICO" },
    { "code": "H922", "province": "CT", "name": "SAN GIOVANNI LA PUNTA" },
    { "code": "H923", "province": "CH", "name": "SAN GIOVANNI LIPIONI" },
    { "code": "H924", "province": "VR", "name": "SAN GIOVANNI LUPATOTO" },
    { "code": "H925", "province": "PG", "name": "SAN GIOVANNI REATINO (soppresso)" },
    { "code": "H926", "province": "FG", "name": "SAN GIOVANNI ROTONDO" },
    { "code": "G287", "province": "CA", "name": "SAN GIOVANNI SUERGIU (soppresso)" },
    { "code": "G287", "province": "CI", "name": "SAN GIOVANNI SUERGIU (soppresso)" },
    { "code": "G287", "province": "SU", "name": "SAN GIOVANNI SUERGIU" },
    { "code": "D690", "province": "CH", "name": "SAN GIOVANNI TEATINO" },
    { "code": "H901", "province": "AR", "name": "SAN GIOVANNI VALDARNO" },
    { "code": "H928", "province": "CB", "name": "SAN GIULIANO DEL SANNIO" },
    { "code": "H929", "province": "CB", "name": "SAN GIULIANO DI PUGLIA" },
    { "code": "H930", "province": "MI", "name": "SAN GIULIANO MILANESE" },
    { "code": "A562", "province": "PI", "name": "SAN GIULIANO TERME" },
    { "code": "H932", "province": "NO", "name": "SAN GIUSEPPE DI CASTO (soppresso)" },
    { "code": "H932", "province": "VC", "name": "SAN GIUSEPPE DI CASTO (soppresso)" },
    { "code": "H933", "province": "PA", "name": "SAN GIUSEPPE JATO" },
    { "code": "H931", "province": "NA", "name": "SAN GIUSEPPE VESUVIANO" },
    { "code": "H935", "province": "PG", "name": "SAN GIUSTINO" },
    { "code": "H936", "province": "TO", "name": "SAN GIUSTO CANAVESE" },
    { "code": "H936", "province": "AO", "name": "SAN GIUSTO CANAVESE (soppresso)" },
    { "code": "H937", "province": "FI", "name": "SAN GODENZO" },
    { "code": "H939", "province": "CE", "name": "SAN GREGORIO (soppresso)" },
    { "code": "H939", "province": "BN", "name": "SAN GREGORIO (soppresso)" },
    { "code": "H942", "province": "RM", "name": "SAN GREGORIO DA SASSOLA" },
    { "code": "H940", "province": "CT", "name": "SAN GREGORIO DI CATANIA" },
    { "code": "H941", "province": "CZ", "name": "SAN GREGORIO D'IPPONA (soppresso)" },
    { "code": "H941", "province": "VV", "name": "SAN GREGORIO D'IPPONA" },
    { "code": "H943", "province": "SA", "name": "SAN GREGORIO MAGNO" },
    { "code": "H939", "province": "CE", "name": "SAN GREGORIO MATESE" },
    { "code": "H938", "province": "BL", "name": "SAN GREGORIO NELLE ALPI" },
    { "code": "H947", "province": "PC", "name": "SAN LAZZARO ALBERONI (soppresso)" },
    { "code": "H945", "province": "BO", "name": "SAN LAZZARO DI SAVENA" },
    { "code": "H948", "province": "PR", "name": "SAN LAZZARO PARMENSE (soppresso)" },
    { "code": "H946", "province": "IM", "name": "SAN LAZZARO REALE (soppresso)" },
    { "code": "H949", "province": "PS", "name": "SAN LEO (soppresso)" },
    { "code": "H949", "province": "PU", "name": "SAN LEO (soppresso)" },
    { "code": "H949", "province": "RN", "name": "SAN LEO" },
    { "code": "H951", "province": "UD", "name": "SAN LEONARDO" },
    { "code": "H950", "province": "TN", "name": "SAN LEONARDO (soppresso)" },
    { "code": "H950", "province": "BZ", "name": "SAN LEONARDO (soppresso)" },
    { "code": "H950", "province": "TN", "name": "SAN LEONARDO IN PASSIRIA (soppresso)" },
    { "code": "H952", "province": "BZ", "name": "SAN LEONARDO IN PASSIRIA" },
    { "code": "E404", "province": "UD", "name": "SAN LEOPOLDO ALAGLESIE (soppresso)" },
    { "code": "H953", "province": "BN", "name": "SAN LEUCIO (soppresso)" },
    { "code": "H954", "province": "CE", "name": "SAN LEUCIO (soppresso)" },
    { "code": "H954", "province": "NA", "name": "SAN LEUCIO (soppresso)" },
    { "code": "H953", "province": "BN", "name": "SAN LEUCIO DEL SANNIO" },
    { "code": "H955", "province": "BN", "name": "SAN LORENZELLO" },
    { "code": "H959", "province": "RC", "name": "SAN LORENZO" },
    { "code": "H956", "province": "TN", "name": "SAN LORENZO (soppresso)" },
    { "code": "H956", "province": "BZ", "name": "SAN LORENZO (soppresso)" },
    { "code": "H957", "province": "IM", "name": "SAN LORENZO AL MARE" },
    { "code": "H961", "province": "CS", "name": "SAN LORENZO BELLIZZI" },
    { "code": "H962", "province": "CS", "name": "SAN LORENZO DEL VALLO" },
    { "code": "H964", "province": "GO", "name": "SAN LORENZO DI MOSSA (soppresso)" },
    { "code": "H964", "province": "UD", "name": "SAN LORENZO DI MOSSA (soppresso)" },
    { "code": "H956", "province": "BZ", "name": "SAN LORENZO DI SEBATO" },
    { "code": "M345", "province": "TN", "name": "SAN LORENZO DORSINO" },
    { "code": "H966", "province": "TN", "name": "SAN LORENZO IN BANALE (soppresso)" },
    { "code": "H958", "province": "PS", "name": "SAN LORENZO IN CAMPO (soppresso)" },
    { "code": "H958", "province": "PU", "name": "SAN LORENZO IN CAMPO" },
    { "code": "H956", "province": "TN", "name": "SAN LORENZO IN PUSTERIA (soppresso)" },
    { "code": "H956", "province": "BZ", "name": "SAN LORENZO IN PUSTERIA (soppresso)" },
    { "code": "H964", "province": "GO", "name": "SAN LORENZO ISONTINO" },
    { "code": "H967", "province": "BN", "name": "SAN LORENZO MAGGIORE" },
    { "code": "H968", "province": "CR", "name": "SAN LORENZO MONDINARI (soppresso)" },
    { "code": "H969", "province": "RM", "name": "SAN LORENZO NUOVO (soppresso)" },
    { "code": "H969", "province": "VT", "name": "SAN LORENZO NUOVO" },
    { "code": "H970", "province": "RC", "name": "SAN LUCA" },
    { "code": "H971", "province": "CS", "name": "SAN LUCIDO" },
    { "code": "H972", "province": "TN", "name": "SAN LUGANO (soppresso)" },
    { "code": "H973", "province": "BN", "name": "SAN LUPO" },
    { "code": "H976", "province": "CZ", "name": "SAN MANGO D'AQUINO" },
    { "code": "H977", "province": "SA", "name": "SAN MANGO PIEMONTE" },
    { "code": "H975", "province": "AV", "name": "SAN MANGO SUL CALORE" },
    { "code": "H978", "province": "CE", "name": "SAN MARCELLINO" },
    { "code": "H978", "province": "NA", "name": "SAN MARCELLINO (soppresso)" },
    { "code": "H979", "province": "AN", "name": "SAN MARCELLO" },
    { "code": "H980", "province": "FI", "name": "SAN MARCELLO PISTOIESE (soppresso)" },
    { "code": "H980", "province": "PT", "name": "SAN MARCELLO PISTOIESE (soppresso)" },
    { "code": "M377", "province": "PT", "name": "SAN MARCELLO PITEGLIO" },
    { "code": "H981", "province": "CS", "name": "SAN MARCO ARGENTANO" },
    { "code": "H982", "province": "ME", "name": "SAN MARCO D'ALUNZIO" },
    { "code": "H984", "province": "BN", "name": "SAN MARCO DEI CAVOTI" },
    { "code": "F043", "province": "CE", "name": "SAN MARCO EVANGELISTA" },
    { "code": "F043", "province": "NA", "name": "SAN MARCO EVANGELISTA (soppresso)" },
    { "code": "H985", "province": "FG", "name": "SAN MARCO IN LAMIS" },
    { "code": "H986", "province": "FG", "name": "SAN MARCO LA CATOLA" },
    { "code": "H988", "province": "TN", "name": "SAN MARTINO (soppresso)" },
    { "code": "H989", "province": "TN", "name": "SAN MARTINO (soppresso)" },
    { "code": "H989", "province": "BZ", "name": "SAN MARTINO (soppresso)" },
    { "code": "H988", "province": "BZ", "name": "SAN MARTINO (soppresso)" },
    { "code": "H995", "province": "RM", "name": "SAN MARTINO AL CIMINO (soppresso)" },
    { "code": "H995", "province": "VT", "name": "SAN MARTINO AL CIMINO (soppresso)" },
    { "code": "I001", "province": "TN", "name": "SAN MARTINO AL MONTE (soppresso)" },
    { "code": "I001", "province": "BZ", "name": "SAN MARTINO AL MONTE (soppresso)" },
    { "code": "H999", "province": "UD", "name": "SAN MARTINO AL TAGLIAMENTO (soppresso)" },
    { "code": "H999", "province": "PN", "name": "SAN MARTINO AL TAGLIAMENTO" },
    { "code": "H987", "province": "AL", "name": "SAN MARTINO ALFIERI (soppresso)" },
    { "code": "H987", "province": "AT", "name": "SAN MARTINO ALFIERI" },
    { "code": "I003", "province": "VR", "name": "SAN MARTINO BUON ALBERGO" },
    { "code": "H997", "province": "TO", "name": "SAN MARTINO CANAVESE" },
    { "code": "H997", "province": "AO", "name": "SAN MARTINO CANAVESE (soppresso)" },
    { "code": "H994", "province": "PZ", "name": "SAN MARTINO D'AGRI" },
    { "code": "I005", "province": "MN", "name": "SAN MARTINO DALL'ARGINE" },
    { "code": "I006", "province": "BG", "name": "SAN MARTINO DE' CALVI (soppresso)" },
    { "code": "I007", "province": "CR", "name": "SAN MARTINO DEL LAGO" },
    { "code": "H992", "province": "CS", "name": "SAN MARTINO DI FINITA" },
    { "code": "I008", "province": "PD", "name": "SAN MARTINO DI LUPARI" },
    { "code": "H998", "province": "TO", "name": "SAN MARTINO DI PERRERO (soppresso)" },
    { "code": "H996", "province": "RO", "name": "SAN MARTINO DI VENEZZE" },
    { "code": "H988", "province": "TN", "name": "SAN MARTINO IN BADIA (soppresso)" },
    { "code": "H988", "province": "BZ", "name": "SAN MARTINO IN BADIA" },
    { "code": "I009", "province": "CR", "name": "SAN MARTINO IN BELISETO (soppresso)" },
    { "code": "I010", "province": "TN", "name": "SAN MARTINO IN CASIES (soppresso)" },
    { "code": "I010", "province": "BZ", "name": "SAN MARTINO IN CASIES (soppresso)" },
    { "code": "H989", "province": "TN", "name": "SAN MARTINO IN PASSIRIA (soppresso)" },
    { "code": "H989", "province": "BZ", "name": "SAN MARTINO IN PASSIRIA" },
    { "code": "H990", "province": "CB", "name": "SAN MARTINO IN PENSILIS" },
    { "code": "I011", "province": "RE", "name": "SAN MARTINO IN RIO" },
    { "code": "I012", "province": "MI", "name": "SAN MARTINO IN STRADA (soppresso)" },
    { "code": "I012", "province": "LO", "name": "SAN MARTINO IN STRADA" },
    { "code": "I013", "province": "GO", "name": "SAN MARTINO QUISCA (soppresso)" },
    { "code": "I013", "province": "UD", "name": "SAN MARTINO QUISCA (soppresso)" },
    { "code": "I002", "province": "BN", "name": "SAN MARTINO SANNITA" },
    { "code": "I014", "province": "PV", "name": "SAN MARTINO SICCOMARIO" },
    { "code": "H991", "province": "CH", "name": "SAN MARTINO SULLA MARRUCINA" },
    { "code": "I016", "province": "AV", "name": "SAN MARTINO VALLE CAUDINA" },
    { "code": "I018", "province": "LE", "name": "SAN MARZANO DI SAN GIUSEPPE (soppresso)" },
    { "code": "I018", "province": "TA", "name": "SAN MARZANO DI SAN GIUSEPPE" },
    { "code": "I020", "province": "AL", "name": "SAN MARZANO MOASCA (soppresso)" },
    { "code": "I020", "province": "AT", "name": "SAN MARZANO MOASCA (soppresso)" },
    { "code": "I017", "province": "AL", "name": "SAN MARZANO OLIVETO (soppresso)" },
    { "code": "I017", "province": "AT", "name": "SAN MARZANO OLIVETO" },
    { "code": "I019", "province": "SA", "name": "SAN MARZANO SUL SARNO" },
    { "code": "I021", "province": "AL", "name": "SAN MARZANOTTO (soppresso)" },
    { "code": "I023", "province": "CB", "name": "SAN MASSIMO" },
    { "code": "I022", "province": "VR", "name": "SAN MASSIMO ALL'ADIGE (soppresso)" },
    { "code": "I024", "province": "TO", "name": "SAN MAURIZIO CANAVESE" },
    { "code": "I025", "province": "NO", "name": "SAN MAURIZIO D'OPAGLIO" },
    { "code": "I028", "province": "PA", "name": "SAN MAURO CASTELVERDE" },
    { "code": "I031", "province": "SA", "name": "SAN MAURO CILENTO" },
    { "code": "I027", "province": "FO", "name": "SAN MAURO DI ROMAGNA (soppresso)" },
    { "code": "H712", "province": "VR", "name": "SAN MAURO DI SALINE" },
    { "code": "I029", "province": "PZ", "name": "SAN MAURO FORTE (soppresso)" },
    { "code": "I029", "province": "MT", "name": "SAN MAURO FORTE" },
    { "code": "I032", "province": "SA", "name": "SAN MAURO LA BRUCA" },
    { "code": "I026", "province": "CZ", "name": "SAN MAURO MARCHESATO (soppresso)" },
    { "code": "I026", "province": "KR", "name": "SAN MAURO MARCHESATO" },
    { "code": "I027", "province": "FO", "name": "SAN MAURO PASCOLI (soppresso)" },
    { "code": "I027", "province": "FC", "name": "SAN MAURO PASCOLI" },
    { "code": "I030", "province": "TO", "name": "SAN MAURO TORINESE" },
    { "code": "I040", "province": "VE", "name": "SAN MICHELE AL TAGLIAMENTO" },
    { "code": "I042", "province": "TN", "name": "SAN MICHELE ALL'ADIGE" },
    { "code": "I033", "province": "AL", "name": "SAN MICHELE D'ASTI (soppresso)" },
    { "code": "H117", "province": "VE", "name": "SAN MICHELE DEL QUARTO (soppresso)" },
    { "code": "I035", "province": "CT", "name": "SAN MICHELE DI GANZARIA" },
    { "code": "I044", "province": "TS", "name": "SAN MICHELE DI POSTUMIA (soppresso)" },
    { "code": "I034", "province": "AV", "name": "SAN MICHELE DI SERINO" },
    { "code": "I041", "province": "VR", "name": "SAN MICHELE EXTRA (soppresso)" },
    { "code": "I039", "province": "RM", "name": "SAN MICHELE IN TEVERINA (soppresso)" },
    { "code": "I039", "province": "VT", "name": "SAN MICHELE IN TEVERINA (soppresso)" },
    { "code": "I037", "province": "CN", "name": "SAN MICHELE MONDOVI'" },
    { "code": "I038", "province": "CN", "name": "SAN MICHELE PRAZZO (soppresso)" },
    { "code": "I045", "province": "BR", "name": "SAN MICHELE SALENTINO" },
    { "code": "I046", "province": "FI", "name": "SAN MINIATO (soppresso)" },
    { "code": "I046", "province": "PI", "name": "SAN MINIATO" },
    { "code": "I024", "province": "TO", "name": "SAN MORIZIO CANAVESE (soppresso)" },
    { "code": "I047", "province": "VI", "name": "SAN NAZARIO (soppresso)" },
    { "code": "I049", "province": "BN", "name": "SAN NAZZARO" },
    { "code": "B449", "province": "BN", "name": "SAN NAZZARO CALVI (soppresso)" },
    { "code": "I052", "province": "NO", "name": "SAN NAZZARO SESIA" },
    { "code": "I051", "province": "CO", "name": "SAN NAZZARO VAL CAVARGNA" },
    { "code": "I054", "province": "FG", "name": "SAN NICANDRO GARGANICO" },
    { "code": "I060", "province": "CS", "name": "SAN NICOLA ARCELLA" },
    { "code": "I061", "province": "AV", "name": "SAN NICOLA BARONIA" },
    { "code": "I058", "province": "CZ", "name": "SAN NICOLA DA CRISSA (soppresso)" },
    { "code": "I058", "province": "VV", "name": "SAN NICOLA DA CRISSA" },
    { "code": "I057", "province": "CZ", "name": "SAN NICOLA DELL'ALTO (soppresso)" },
    { "code": "I057", "province": "KR", "name": "SAN NICOLA DELL'ALTO" },
    { "code": "I056", "province": "CE", "name": "SAN NICOLA LA STRADA" },
    { "code": "I056", "province": "NA", "name": "SAN NICOLA LA STRADA (soppresso)" },
    { "code": "I062", "province": "BN", "name": "SAN NICOLA MANFREDI" },
    { "code": "A368", "province": "CA", "name": "SAN NICOLO' D'ARCIDANO (soppresso)" },
    { "code": "A368", "province": "OR", "name": "SAN NICOLO' D'ARCIDANO" },
    { "code": "I063", "province": "BL", "name": "SAN NICOLO' DI COMELICO" },
    { "code": "G383", "province": "CA", "name": "SAN NICOLO' GERREI (soppresso)" },
    { "code": "G383", "province": "SU", "name": "SAN NICOLO' GERREI" },
    { "code": "I064", "province": "MI", "name": "SAN NOVO (soppresso)" },
    { "code": "I065", "province": "BZ", "name": "SAN PANCRAZIO" },
    { "code": "I068", "province": "PR", "name": "SAN PANCRAZIO PARMENSE (soppresso)" },
    { "code": "I066", "province": "LE", "name": "SAN PANCRAZIO SALENTINO (soppresso)" },
    { "code": "I066", "province": "BR", "name": "SAN PANCRAZIO SALENTINO" },
    { "code": "I069", "province": "CA", "name": "SAN PANTALEO (soppresso)" },
    { "code": "G407", "province": "BS", "name": "SAN PAOLO" },
    { "code": "B906", "province": "PZ", "name": "SAN PAOLO ALBANESE" },
    { "code": "I073", "province": "CE", "name": "SAN PAOLO BEL SITO (soppresso)" },
    { "code": "I073", "province": "NA", "name": "SAN PAOLO BEL SITO" },
    { "code": "I074", "province": "NO", "name": "SAN PAOLO CERVO (soppresso)" },
    { "code": "I074", "province": "VC", "name": "SAN PAOLO CERVO (soppresso)" },
    { "code": "I074", "province": "BI", "name": "SAN PAOLO CERVO (soppresso)" },
    { "code": "B310", "province": "BG", "name": "SAN PAOLO D'ARGON" },
    { "code": "I070", "province": "AL", "name": "SAN PAOLO DELLA VALLE (soppresso)" },
    { "code": "I072", "province": "FG", "name": "SAN PAOLO DI CIVITATE" },
    { "code": "I071", "province": "AN", "name": "SAN PAOLO DI JESI" },
    { "code": "I076", "province": "AL", "name": "SAN PAOLO SOLBRITO (soppresso)" },
    { "code": "I076", "province": "AT", "name": "SAN PAOLO SOLBRITO" },
    { "code": "I078", "province": "TS", "name": "SAN PELAGIO (soppresso)" },
    { "code": "I079", "province": "BG", "name": "SAN PELLEGRINO (soppresso)" },
    { "code": "I079", "province": "BG", "name": "SAN PELLEGRINO TERME" },
    { "code": "I081", "province": "GE", "name": "SAN PIER D'ARENA (soppresso)" },
    { "code": "I082", "province": "TS", "name": "SAN PIER D'ISONZO (soppresso)" },
    { "code": "I082", "province": "GO", "name": "SAN PIER D'ISONZO" },
    { "code": "I083", "province": "RC", "name": "SAN PIER FEDELE (soppresso)" },
    { "code": "I084", "province": "ME", "name": "SAN PIER NICETO" },
    { "code": "I085", "province": "FI", "name": "SAN PIERO A SIEVE (soppresso)" },
    { "code": "I086", "province": "ME", "name": "SAN PIERO PATTI" },
    { "code": "I091", "province": "GO", "name": "SAN PIETRO (soppresso)" },
    { "code": "I091", "province": "UD", "name": "SAN PIETRO (soppresso)" },
    { "code": "I087", "province": "TN", "name": "SAN PIETRO (soppresso)" },
    { "code": "I087", "province": "BZ", "name": "SAN PIETRO (soppresso)" },
    { "code": "I093", "province": "CZ", "name": "SAN PIETRO A MAIDA" },
    { "code": "I094", "province": "NA", "name": "SAN PIETRO A PATIERNO (soppresso)" },
    { "code": "I092", "province": "UD", "name": "SAN PIETRO AL NATISONE" },
    { "code": "I089", "province": "SA", "name": "SAN PIETRO AL TANAGRO" },
    { "code": "I095", "province": "CZ", "name": "SAN PIETRO APOSTOLO" },
    { "code": "I096", "province": "CB", "name": "SAN PIETRO AVELLANA (soppresso)" },
    { "code": "I096", "province": "IS", "name": "SAN PIETRO AVELLANA" },
    { "code": "I088", "province": "BL", "name": "SAN PIETRO CADORE (soppresso)" },
    { "code": "I098", "province": "CT", "name": "SAN PIETRO CLARENZA" },
    { "code": "I100", "province": "TS", "name": "SAN PIETRO DEL CARSO (soppresso)" },
    { "code": "I082", "province": "GO", "name": "SAN PIETRO DELL'ISONZO (soppresso)" },
    { "code": "I082", "province": "TS", "name": "SAN PIETRO DELL'ISONZO (soppresso)" },
    { "code": "I101", "province": "TV", "name": "SAN PIETRO DI BARBOZZA (soppresso)" },
    { "code": "I088", "province": "BL", "name": "SAN PIETRO DI CADORE" },
    { "code": "I102", "province": "RC", "name": "SAN PIETRO DI CARIDA'" },
    { "code": "I103", "province": "TV", "name": "SAN PIETRO DI FELETTO" },
    { "code": "I091", "province": "UD", "name": "SAN PIETRO DI GORIZIA (soppresso)" },
    { "code": "I091", "province": "GO", "name": "SAN PIETRO DI GORIZIA (soppresso)" },
    { "code": "I104", "province": "CN", "name": "SAN PIETRO DI MONTEROSSO (soppresso)" },
    { "code": "I105", "province": "VR", "name": "SAN PIETRO DI MORUBIO" },
    { "code": "I106", "province": "BG", "name": "SAN PIETRO D'ORZIO (soppresso)" },
    { "code": "I108", "province": "CS", "name": "SAN PIETRO IN AMANTEA" },
    { "code": "I109", "province": "VR", "name": "SAN PIETRO IN CARIANO" },
    { "code": "I110", "province": "BO", "name": "SAN PIETRO IN CASALE" },
    { "code": "G788", "province": "PC", "name": "SAN PIETRO IN CERRO" },
    { "code": "I107", "province": "PD", "name": "SAN PIETRO IN GU" },
    { "code": "I114", "province": "CS", "name": "SAN PIETRO IN GUARANO" },
    { "code": "I115", "province": "LE", "name": "SAN PIETRO IN LAMA" },
    { "code": "I087", "province": "TN", "name": "SAN PIETRO IN VALLE AURINA (soppresso)" },
    { "code": "I112", "province": "AV", "name": "SAN PIETRO INDELICATO (soppresso)" },
    { "code": "I113", "province": "CE", "name": "SAN PIETRO INFINE" },
    { "code": "I113", "province": "NA", "name": "SAN PIETRO INFINE (soppresso)" },
    { "code": "I112", "province": "AV", "name": "SAN PIETRO IRPINO (soppresso)" },
    { "code": "F529", "province": "PD", "name": "SAN PIETRO MONTAGNON (soppresso)" },
    { "code": "I116", "province": "NO", "name": "SAN PIETRO MOSEZZO" },
    { "code": "I117", "province": "VI", "name": "SAN PIETRO MUSSOLINO" },
    { "code": "I118", "province": "CA", "name": "SAN PIETRO PULA (soppresso)" },
    { "code": "I086", "province": "ME", "name": "SAN PIETRO SOPRA PATTI (soppresso)" },
    { "code": "I090", "province": "TO", "name": "SAN PIETRO VAL LEMINA" },
    { "code": "I119", "province": "LE", "name": "SAN PIETRO VERNOTICO (soppresso)" },
    { "code": "I119", "province": "BR", "name": "SAN PIETRO VERNOTICO" },
    { "code": "I120", "province": "PD", "name": "SAN PIETRO VIMINARIO" },
    { "code": "I121", "province": "AQ", "name": "SAN PIO DELLE CAMERE" },
    { "code": "I125", "province": "RM", "name": "SAN POLO DEI CAVALIERI" },
    { "code": "I123", "province": "RE", "name": "SAN POLO D'ENZA" },
    { "code": "I123", "province": "RE", "name": "SAN POLO D'ENZA IN CAVIANO (soppresso)" },
    { "code": "I124", "province": "TV", "name": "SAN POLO DI PIAVE" },
    { "code": "I122", "province": "CB", "name": "SAN POLO MATESE" },
    { "code": "I122", "province": "CB", "name": "SAN POLOMATESE (soppresso)" },
    { "code": "I126", "province": "TO", "name": "SAN PONSO" },
    { "code": "I126", "province": "TO", "name": "SAN PONSO CANAVESE (soppresso)" },
    { "code": "I126", "province": "AO", "name": "SAN PONSO CANAVESE (soppresso)" },
    { "code": "I127", "province": "PV", "name": "SAN PONZO SEMOLA (soppresso)" },
    { "code": "I128", "province": "MO", "name": "SAN POSSIDONIO" },
    { "code": "I130", "province": "CE", "name": "SAN POTITO SANNITICO" },
    { "code": "I130", "province": "BN", "name": "SAN POTITO SANNITICO (soppresso)" },
    { "code": "I129", "province": "AV", "name": "SAN POTITO ULTRA" },
    { "code": "I131", "province": "CE", "name": "SAN PRISCO" },
    { "code": "I131", "province": "NA", "name": "SAN PRISCO (soppresso)" },
    { "code": "I132", "province": "RC", "name": "SAN PROCOPIO" },
    { "code": "I133", "province": "MO", "name": "SAN PROSPERO" },
    { "code": "I135", "province": "SI", "name": "SAN QUIRICO D'ORCIA" },
    { "code": "I134", "province": "GE", "name": "SAN QUIRICO IN VAL POLCEVERA (soppresso)" },
    { "code": "I136", "province": "UD", "name": "SAN QUIRINO (soppresso)" },
    { "code": "I136", "province": "PN", "name": "SAN QUIRINO" },
    { "code": "I137", "province": "TO", "name": "SAN RAFFAELE CIMENA" },
    { "code": "H675", "province": "AO", "name": "SAN REMIGIO (soppresso)" },
    { "code": "I139", "province": "RC", "name": "SAN ROBERTO" },
    { "code": "I140", "province": "MI", "name": "SAN ROCCO AL PORTO (soppresso)" },
    { "code": "I140", "province": "LO", "name": "SAN ROCCO AL PORTO" },
    { "code": "I142", "province": "MS", "name": "SAN ROMANO IN GARFAGNANA (soppresso)" },
    { "code": "I142", "province": "LU", "name": "SAN ROMANO IN GARFAGNANA" },
    { "code": "E519", "province": "GE", "name": "SAN RUFINO (soppresso)" },
    { "code": "I143", "province": "SA", "name": "SAN RUFO" },
    { "code": "I147", "province": "ME", "name": "SAN SALVATORE DI FITALIA" },
    { "code": "I144", "province": "AL", "name": "SAN SALVATORE MONFERRATO" },
    { "code": "I145", "province": "BN", "name": "SAN SALVATORE TELESINO" },
    { "code": "I148", "province": "CH", "name": "SAN SALVO" },
    { "code": "I151", "province": "NA", "name": "SAN SEBASTIANO AL VESUVIO" },
    { "code": "I150", "province": "AL", "name": "SAN SEBASTIANO CURONE" },
    { "code": "I152", "province": "TO", "name": "SAN SEBASTIANO DA PO" },
    { "code": "I154", "province": "TO", "name": "SAN SECONDO DI PINEROLO" },
    { "code": "I153", "province": "PR", "name": "SAN SECONDO PARMENSE" },
    { "code": "I157", "province": "PZ", "name": "SAN SEVERINO LUCANO" },
    { "code": "I156", "province": "MC", "name": "SAN SEVERINO MARCHE" },
    { "code": "F138", "province": "SA", "name": "SAN SEVERINO ROTA (soppresso)" },
    { "code": "I158", "province": "FG", "name": "SAN SEVERO" },
    { "code": "I159", "province": "TN", "name": "SAN SIGISMONDO (soppresso)" },
    { "code": "I159", "province": "BZ", "name": "SAN SIGISMONDO (soppresso)" },
    { "code": "I161", "province": "CH", "name": "SAN SILVESTRO (soppresso)" },
    { "code": "ND", "province": "CO", "name": "SAN SIRO (soppresso)" },
    { "code": "I162", "province": "CO", "name": "SAN SIRO" },
    { "code": "I163", "province": "AV", "name": "SAN SOSSIO (soppresso)" },
    { "code": "I163", "province": "AV", "name": "SAN SOSSIO BARONIA" },
    { "code": "I164", "province": "CZ", "name": "SAN SOSTENE" },
    { "code": "I165", "province": "CS", "name": "SAN SOSTI" },
    { "code": "I166", "province": "CA", "name": "SAN SPERATE (soppresso)" },
    { "code": "I166", "province": "SU", "name": "SAN SPERATE" },
    { "code": "I373", "province": "VE", "name": "SAN STINO DI LIVENZA" },
    { "code": "I261", "province": "CE", "name": "SAN TAMMARO" },
    { "code": "I261", "province": "NA", "name": "SAN TAMMARO (soppresso)" },
    { "code": "I328", "province": "ME", "name": "SAN TEODORO" },
    { "code": "I329", "province": "NU", "name": "SAN TEODORO (soppresso)" },
    { "code": "I329", "province": "OT", "name": "SAN TEODORO (soppresso)" },
    { "code": "I329", "province": "SS", "name": "SAN TEODORO" },
    { "code": "I347", "province": "BL", "name": "SAN TOMASO (soppresso)" },
    { "code": "I347", "province": "BL", "name": "SAN TOMASO AGORDINO" },
    { "code": "I378", "province": "TN", "name": "SAN VALENTINO AL BRENNERO (soppresso)" },
    { "code": "I378", "province": "BZ", "name": "SAN VALENTINO AL BRENNERO (soppresso)" },
    { "code": "I379", "province": "TN", "name": "SAN VALENTINO ALLA MUTA (soppresso)" },
    { "code": "I379", "province": "TN", "name": "SAN VALENTINO ALLA MUTTA (soppresso)" },
    { "code": "I379", "province": "BZ", "name": "SAN VALENTINO ALLA MUTTA (soppresso)" },
    { "code": "I376", "province": "CH", "name": "SAN VALENTINO IN ABRUZZO CITERIORE (soppresso)" },
    { "code": "I376", "province": "PE", "name": "SAN VALENTINO IN ABRUZZO CITERIORE" },
    { "code": "H019", "province": "TN", "name": "SAN VALENTINO IN PREDOI (soppresso)" },
    { "code": "I377", "province": "SA", "name": "SAN VALENTINO TORIO" },
    { "code": "I381", "province": "PG", "name": "SAN VENANZO (soppresso)" },
    { "code": "I381", "province": "TR", "name": "SAN VENANZO" },
    { "code": "I382", "province": "TV", "name": "SAN VENDEMIANO" },
    { "code": "I383", "province": "CA", "name": "SAN VERO CONGIUS (soppresso)" },
    { "code": "I384", "province": "CA", "name": "SAN VERO MILIS (soppresso)" },
    { "code": "I384", "province": "OR", "name": "SAN VERO MILIS" },
    { "code": "I385", "province": "BS", "name": "SAN VIGILIO (soppresso)" },
    { "code": "I390", "province": "LI", "name": "SAN VINCENZO" },
    { "code": "I387", "province": "CB", "name": "SAN VINCENZO AL VOLTURNO (soppresso)" },
    { "code": "H676", "province": "AO", "name": "SAN VINCENZO DELLA FONTE (soppresso)" },
    { "code": "I388", "province": "CS", "name": "SAN VINCENZO LA COSTA" },
    { "code": "I389", "province": "AQ", "name": "SAN VINCENZO VALLE ROVETO" },
    { "code": "I391", "province": "CE", "name": "SAN VITALIANO (soppresso)" },
    { "code": "I391", "province": "NA", "name": "SAN VITALIANO" },
    { "code": "I402", "province": "CA", "name": "SAN VITO (soppresso)" },
    { "code": "I395", "province": "CR", "name": "SAN VITO (soppresso)" },
    { "code": "I402", "province": "SU", "name": "SAN VITO" },
    { "code": "F635", "province": "GO", "name": "SAN VITO AL MONTE (soppresso)" },
    { "code": "F635", "province": "UD", "name": "SAN VITO AL MONTE (soppresso)" },
    { "code": "I403", "province": "UD", "name": "SAN VITO AL TAGLIAMENTO (soppresso)" },
    { "code": "I403", "province": "PN", "name": "SAN VITO AL TAGLIAMENTO" },
    { "code": "I404", "province": "UD", "name": "SAN VITO AL TORRE" },
    { "code": "I394", "province": "CH", "name": "SAN VITO CHIETINO" },
    { "code": "I396", "province": "LE", "name": "SAN VITO DEI NORMANNI (soppresso)" },
    { "code": "I396", "province": "BR", "name": "SAN VITO DEI NORMANNI" },
    { "code": "I392", "province": "BL", "name": "SAN VITO DI CADORE" },
    { "code": "I405", "province": "UD", "name": "SAN VITO DI FAGAGNA" },
    { "code": "I401", "province": "VI", "name": "SAN VITO DI LEGUZZANO" },
    { "code": "I406", "province": "GO", "name": "SAN VITO DI VIPACCO (soppresso)" },
    { "code": "I406", "province": "UD", "name": "SAN VITO DI VIPACCO (soppresso)" },
    { "code": "I395", "province": "CR", "name": "SAN VITO E MODESTO (soppresso)" },
    { "code": "I398", "province": "PG", "name": "SAN VITO IN MONTE (soppresso)" },
    { "code": "I398", "province": "TR", "name": "SAN VITO IN MONTE (soppresso)" },
    { "code": "I407", "province": "TP", "name": "SAN VITO LO CAPO" },
    { "code": "I400", "province": "RM", "name": "SAN VITO ROMANO" },
    { "code": "I393", "province": "CZ", "name": "SAN VITO SULLO IONIO" },
    { "code": "I408", "province": "CE", "name": "SAN VITTORE DEL LAZIO (soppresso)" },
    { "code": "I408", "province": "FR", "name": "SAN VITTORE DEL LAZIO" },
    { "code": "I409", "province": "MI", "name": "SAN VITTORE OLONA" },
    { "code": "I414", "province": "VR", "name": "SAN ZENO DI MONTAGNA" },
    { "code": "I412", "province": "BS", "name": "SAN ZENO NAVIGLIO" },
    { "code": "I415", "province": "MI", "name": "SAN ZENONE AL LAMBRO" },
    { "code": "I416", "province": "PV", "name": "SAN ZENONE AL PO" },
    { "code": "I417", "province": "TV", "name": "SAN ZENONE DEGLI EZZELINI" },
    { "code": "H757", "province": "LE", "name": "SANARICA" },
    { "code": "H821", "province": "NO", "name": "SANDIGLIANO (soppresso)" },
    { "code": "H821", "province": "VC", "name": "SANDIGLIANO (soppresso)" },
    { "code": "H821", "province": "BI", "name": "SANDIGLIANO" },
    { "code": "H829", "province": "VI", "name": "SANDRIGO" },
    { "code": "H851", "province": "CN", "name": "SANFRE'" },
    { "code": "H852", "province": "CN", "name": "SANFRONT" },
    { "code": "H852", "province": "CN", "name": "SANFRONTE (soppresso)" },
    { "code": "H855", "province": "TO", "name": "SANGANO" },
    { "code": "H872", "province": "CO", "name": "SANGIANO (soppresso)" },
    { "code": "H872", "province": "VA", "name": "SANGIANO" },
    { "code": "H877", "province": "CS", "name": "SANGINETO" },
    { "code": "H944", "province": "VR", "name": "SANGUINETTO" },
    { "code": "H974", "province": "CA", "name": "SANLURI (soppresso)" },
    { "code": "H974", "province": "VS", "name": "SANLURI (soppresso)" },
    { "code": "H974", "province": "SU", "name": "SANLURI" },
    { "code": "I048", "province": "PV", "name": "SANNAZZARO DE' BURGONDI" },
    { "code": "I053", "province": "BA", "name": "SANNICANDRO DI BARI" },
    { "code": "I054", "province": "FG", "name": "SANNICANDRO GARGANICO (soppresso)" },
    { "code": "I059", "province": "LE", "name": "SANNICOLA" },
    { "code": "I138", "province": "IM", "name": "SANREMO" },
    { "code": "I155", "province": "AR", "name": "SANSEPOLCRO" },
    { "code": "F138", "province": "SA", "name": "SANSEVERINO ROTA (soppresso)" },
    { "code": "D630", "province": "UD", "name": "SANT' ODORICO (soppresso)" },
    { "code": "I168", "province": "BG", "name": "SANTA BRIGIDA" },
    { "code": "I171", "province": "CS", "name": "SANTA CATERINA ALBANESE" },
    { "code": "I170", "province": "CZ", "name": "SANTA CATERINA DELLO IONIO" },
    { "code": "I169", "province": "CL", "name": "SANTA CATERINA VILLARMOSA" },
    { "code": "I172", "province": "LE", "name": "SANTA CESAREA (soppresso)" },
    { "code": "I172", "province": "LE", "name": "SANTA CESAREA TERME" },
    { "code": "I173", "province": "TN", "name": "SANTA CRISTINA (soppresso)" },
    { "code": "I173", "province": "BZ", "name": "SANTA CRISTINA (soppresso)" },
    { "code": "I176", "province": "RC", "name": "SANTA CRISTINA D'ASPROMONTE" },
    { "code": "I175", "province": "PV", "name": "SANTA CRISTINA E BISSONE" },
    { "code": "I174", "province": "PA", "name": "SANTA CRISTINA GELA" },
    { "code": "I173", "province": "TN", "name": "SANTA CRISTINA IN GARDENA (soppresso)" },
    { "code": "I173", "province": "BZ", "name": "SANTA CRISTINA VALGARDENA" },
    { "code": "I178", "province": "SR", "name": "SANTA CROCE CAMERINA (soppresso)" },
    { "code": "I178", "province": "RG", "name": "SANTA CROCE CAMERINA" },
    { "code": "I179", "province": "BN", "name": "SANTA CROCE DEL SANNIO" },
    { "code": "I180", "province": "GO", "name": "SANTA CROCE DI AIDUSSINA (soppresso)" },
    { "code": "I180", "province": "UD", "name": "SANTA CROCE DI AIDUSSINA (soppresso)" },
    { "code": "I181", "province": "CB", "name": "SANTA CROCE DI MAGLIANO" },
    { "code": "I177", "province": "FI", "name": "SANTA CROCE SULL'ARNO (soppresso)" },
    { "code": "I177", "province": "PI", "name": "SANTA CROCE SULL'ARNO" },
    { "code": "I183", "province": "CS", "name": "SANTA DOMENICA TALAO" },
    { "code": "I184", "province": "ME", "name": "SANTA DOMENICA VITTORIA" },
    { "code": "I185", "province": "AG", "name": "SANTA ELISABETTA" },
    { "code": "I187", "province": "GR", "name": "SANTA FIORA" },
    { "code": "I188", "province": "PA", "name": "SANTA FLAVIA" },
    { "code": "I203", "province": "PV", "name": "SANTA GIULETTA" },
    { "code": "I204", "province": "GE", "name": "SANTA GIULIA (soppresso)" },
    { "code": "I204", "province": "SV", "name": "SANTA GIULIA (soppresso)" },
    { "code": "I205", "province": "CA", "name": "SANTA GIUSTA (soppresso)" },
    { "code": "I205", "province": "OR", "name": "SANTA GIUSTA" },
    { "code": "I206", "province": "BL", "name": "SANTA GIUSTINA" },
    { "code": "I207", "province": "PD", "name": "SANTA GIUSTINA IN COLLE" },
    { "code": "I217", "province": "PI", "name": "SANTA LUCE" },
    { "code": "I218", "province": "PI", "name": "SANTA LUCE ORCIANO (soppresso)" },
    { "code": "I220", "province": "ME", "name": "SANTA LUCIA DEL MELA" },
    { "code": "I221", "province": "TV", "name": "SANTA LUCIA DI PIAVE" },
    { "code": "I219", "province": "AV", "name": "SANTA LUCIA DI SERINO" },
    { "code": "I222", "province": "GO", "name": "SANTA LUCIA DI TOLMINO (soppresso)" },
    { "code": "I222", "province": "UD", "name": "SANTA LUCIA DI TOLMINO (soppresso)" },
    { "code": "I222", "province": "GO", "name": "SANTA LUCIA D'ISONZO (soppresso)" },
    { "code": "I223", "province": "TN", "name": "SANTA MADDALENA IN CASIES (soppresso)" },
    { "code": "I223", "province": "BZ", "name": "SANTA MADDALENA IN CASIES (soppresso)" },
    { "code": "I229", "province": "TN", "name": "SANTA MARGHERITA (soppresso)" },
    { "code": "I226", "province": "PD", "name": "SANTA MARGHERITA D'ADIGE (soppresso)" },
    { "code": "I224", "province": "AG", "name": "SANTA MARGHERITA DI BELICE" },
    { "code": "I227", "province": "PV", "name": "SANTA MARGHERITA DI BOBBIO (soppresso)" },
    { "code": "I230", "province": "PV", "name": "SANTA MARGHERITA DI STAFFORA" },
    { "code": "I225", "province": "GE", "name": "SANTA MARGHERITA LIGURE" },
    { "code": "C717", "province": "CS", "name": "SANTA MARIA (soppresso)" },
    { "code": "I232", "province": "FI", "name": "SANTA MARIA A MONTE (soppresso)" },
    { "code": "I232", "province": "PI", "name": "SANTA MARIA A MONTE" },
    { "code": "I233", "province": "CE", "name": "SANTA MARIA A VICO" },
    { "code": "I233", "province": "NA", "name": "SANTA MARIA A VICO (soppresso)" },
    { "code": "I234", "province": "CE", "name": "SANTA MARIA CAPUA VETERE" },
    { "code": "I234", "province": "NA", "name": "SANTA MARIA CAPUA VETERE (soppresso)" },
    { "code": "M284", "province": "SS", "name": "SANTA MARIA COGHINAS" },
    { "code": "C717", "province": "CS", "name": "SANTA MARIA DEL CEDRO" },
    { "code": "I238", "province": "CB", "name": "SANTA MARIA DEL MOLISE (soppresso)" },
    { "code": "I238", "province": "IS", "name": "SANTA MARIA DEL MOLISE" },
    { "code": "I239", "province": "CO", "name": "SANTA MARIA DEL MONTE (soppresso)" },
    { "code": "I239", "province": "VA", "name": "SANTA MARIA DEL MONTE (soppresso)" },
    { "code": "I235", "province": "CR", "name": "SANTA MARIA DELLA CROCE (soppresso)" },
    { "code": "I237", "province": "PV", "name": "SANTA MARIA DELLA VERSA" },
    { "code": "I240", "province": "CT", "name": "SANTA MARIA DI LICODIA" },
    { "code": "I241", "province": "CO", "name": "SANTA MARIA DI ROVAGNATE (soppresso)" },
    { "code": "I242", "province": "VE", "name": "SANTA MARIA DI SALA" },
    { "code": "I243", "province": "CO", "name": "SANTA MARIA HOE' (soppresso)" },
    { "code": "I243", "province": "LC", "name": "SANTA MARIA HOE'" },
    { "code": "I244", "province": "CH", "name": "SANTA MARIA IMBARO" },
    { "code": "I245", "province": "MI", "name": "SANTA MARIA IN PRATO (soppresso)" },
    { "code": "I246", "province": "VR", "name": "SANTA MARIA IN STELLE (soppresso)" },
    { "code": "M273", "province": "NA", "name": "SANTA MARIA LA CARITA'" },
    { "code": "I247", "province": "CE", "name": "SANTA MARIA LA FOSSA" },
    { "code": "I247", "province": "NA", "name": "SANTA MARIA LA FOSSA (soppresso)" },
    { "code": "I248", "province": "UD", "name": "SANTA MARIA LA LONGA" },
    { "code": "I249", "province": "NO", "name": "SANTA MARIA MAGGIORE (soppresso)" },
    { "code": "I249", "province": "VB", "name": "SANTA MARIA MAGGIORE" },
    { "code": "I250", "province": "NO", "name": "SANTA MARIA MAGGIORE E CRANA (soppresso)" },
    { "code": "I251", "province": "AN", "name": "SANTA MARIA NUOVA" },
    { "code": "I252", "province": "CO", "name": "SANTA MARIA REZZONICO (soppresso)" },
    { "code": "I253", "province": "SA", "name": "SANTA MARINA" },
    { "code": "I254", "province": "ME", "name": "SANTA MARINA SALINA" },
    { "code": "I255", "province": "RM", "name": "SANTA MARINELLA" },
    { "code": "I291", "province": "TP", "name": "SANTA NINFA" },
    { "code": "I301", "province": "AV", "name": "SANTA PAOLINA" },
    { "code": "I308", "province": "CZ", "name": "SANTA SEVERINA (soppresso)" },
    { "code": "I308", "province": "KR", "name": "SANTA SEVERINA" },
    { "code": "I310", "province": "FI", "name": "SANTA SOFIA (soppresso)" },
    { "code": "I310", "province": "FO", "name": "SANTA SOFIA (soppresso)" },
    { "code": "I310", "province": "FC", "name": "SANTA SOFIA" },
    { "code": "I309", "province": "CS", "name": "SANTA SOFIA D'EPIRO" },
    { "code": "I311", "province": "ME", "name": "SANTA TERESA DI RIVA" },
    { "code": "I312", "province": "SS", "name": "SANTA TERESA GALLURA" },
    { "code": "I312", "province": "OT", "name": "SANTA TERESA GALLURA (soppresso)" },
    { "code": "I313", "province": "CO", "name": "SANTA VALERIA (soppresso)" },
    { "code": "I314", "province": "CT", "name": "SANTA VENERINA" },
    { "code": "I316", "province": "CN", "name": "SANTA VITTORIA D'ALBA" },
    { "code": "I315", "province": "AP", "name": "SANTA VITTORIA IN MATENANO (soppresso)" },
    { "code": "I315", "province": "FM", "name": "SANTA VITTORIA IN MATENANO" },
    { "code": "I167", "province": "CO", "name": "SANT'ABBONDIO (soppresso)" },
    { "code": "I182", "province": "CA", "name": "SANTADI (soppresso)" },
    { "code": "I182", "province": "CI", "name": "SANTADI (soppresso)" },
    { "code": "I182", "province": "SU", "name": "SANTADI" },
    { "code": "I189", "province": "CB", "name": "SANT'AGAPITO (soppresso)" },
    { "code": "I189", "province": "IS", "name": "SANT'AGAPITO" },
    { "code": "I191", "province": "BO", "name": "SANT'AGATA BOLOGNESE" },
    { "code": "I197", "province": "BN", "name": "SANT'AGATA DE' GOTI" },
    { "code": "I198", "province": "RC", "name": "SANT'AGATA DEL BIANCO" },
    { "code": "I192", "province": "CS", "name": "SANT'AGATA DI ESARO" },
    { "code": "I199", "province": "ME", "name": "SANT'AGATA DI MILITELLO" },
    { "code": "I193", "province": "FG", "name": "SANT'AGATA DI PUGLIA" },
    { "code": "I200", "province": "AV", "name": "SANT'AGATA DI SOTTO (soppresso)" },
    { "code": "I201", "province": "PS", "name": "SANT'AGATA FELTRIA (soppresso)" },
    { "code": "I201", "province": "PU", "name": "SANT'AGATA FELTRIA (soppresso)" },
    { "code": "I201", "province": "RN", "name": "SANT'AGATA FELTRIA" },
    { "code": "I190", "province": "AL", "name": "SANT'AGATA FOSSILI" },
    { "code": "I200", "province": "AV", "name": "SANT'AGATA IRPINA (soppresso)" },
    { "code": "I202", "province": "CT", "name": "SANT'AGATA LI BATTIATI" },
    { "code": "I195", "province": "NO", "name": "SANT'AGATA SOPRA CANNOBIO (soppresso)" },
    { "code": "I196", "province": "RA", "name": "SANT'AGATA SUL SANTERNO" },
    { "code": "I208", "province": "NA", "name": "SANT'AGNELLO" },
    { "code": "I209", "province": "FE", "name": "SANT'AGOSTINO (soppresso)" },
    { "code": "I211", "province": "PV", "name": "SANT'ALBANO DI BOBBIO (soppresso)" },
    { "code": "I210", "province": "CN", "name": "SANT'ALBANO STURA" },
    { "code": "I213", "province": "PV", "name": "SANT'ALESSIO CON VIALONE" },
    { "code": "I214", "province": "RC", "name": "SANT'ALESSIO IN ASPROMONTE" },
    { "code": "I215", "province": "ME", "name": "SANT'ALESSIO SICULO" },
    { "code": "I216", "province": "CT", "name": "SANT'ALFIO" },
    { "code": "I258", "province": "TO", "name": "SANT'AMBROGIO DI TORINO" },
    { "code": "I259", "province": "VR", "name": "SANT'AMBROGIO DI VALPOLICELLA" },
    { "code": "I257", "province": "CO", "name": "SANT'AMBROGIO OLONA (soppresso)" },
    { "code": "I257", "province": "VA", "name": "SANT'AMBROGIO OLONA (soppresso)" },
    { "code": "I256", "province": "CE", "name": "SANT'AMBROGIO SUL GARIGLIANO (soppresso)" },
    { "code": "I256", "province": "FR", "name": "SANT'AMBROGIO SUL GARIGLIANO" },
    { "code": "I262", "province": "NA", "name": "SANT'ANASTASIA" },
    { "code": "I263", "province": "PG", "name": "SANT'ANATOLIA DI NARCO" },
    { "code": "I265", "province": "CE", "name": "SANT'ANDREA (soppresso)" },
    { "code": "I269", "province": "GO", "name": "SANT'ANDREA (soppresso)" },
    { "code": "I269", "province": "UD", "name": "SANT'ANDREA (soppresso)" },
    { "code": "I265", "province": "FR", "name": "SANT'ANDREA (soppresso)" },
    { "code": "I266", "province": "CZ", "name": "SANT'ANDREA APOSTOLO DELLO IONIO" },
    { "code": "I265", "province": "FR", "name": "SANT'ANDREA DEL GARIGLIANO" },
    { "code": "I264", "province": "AV", "name": "SANT'ANDREA DI CONZA" },
    { "code": "I269", "province": "UD", "name": "SANT'ANDREA DI GORIZIA (soppresso)" },
    { "code": "I269", "province": "GO", "name": "SANT'ANDREA DI GORIZIA (soppresso)" },
    { "code": "I270", "province": "CE", "name": "SANT'ANDREA DI VALLEFREDDA (soppresso)" },
    { "code": "I271", "province": "CA", "name": "SANT'ANDREA FRIUS (soppresso)" },
    { "code": "I271", "province": "SU", "name": "SANT'ANDREA FRIUS" },
    { "code": "I272", "province": "TN", "name": "SANT'ANDREA IN MONTE (soppresso)" },
    { "code": "I272", "province": "BZ", "name": "SANT'ANDREA IN MONTE (soppresso)" },
    { "code": "I277", "province": "BN", "name": "SANT'ANGELO A CUPOLO" },
    { "code": "I278", "province": "SA", "name": "SANT'ANGELO A FASANELLA" },
    { "code": "I280", "province": "AV", "name": "SANT'ANGELO A SCALA" },
    { "code": "I279", "province": "AV", "name": "SANT'ANGELO ALL'ESCA" },
    { "code": "I273", "province": "CE", "name": "SANT'ANGELO D'ALIFE" },
    { "code": "I273", "province": "BN", "name": "SANT'ANGELO D'ALIFE (soppresso)" },
    { "code": "I281", "province": "AV", "name": "SANT'ANGELO DEI LOMBARDI" },
    { "code": "I282", "province": "CB", "name": "SANT'ANGELO DEL PESCO (soppresso)" },
    { "code": "I282", "province": "IS", "name": "SANT'ANGELO DEL PESCO" },
    { "code": "I283", "province": "ME", "name": "SANT'ANGELO DI BROLO" },
    { "code": "I275", "province": "PD", "name": "SANT'ANGELO DI PIOVE DI SACCO" },
    { "code": "I238", "province": "CB", "name": "SANT'ANGELO IN GROTTE (soppresso)" },
    { "code": "I285", "province": "PS", "name": "SANT'ANGELO IN LIZZOLA (soppresso)" },
    { "code": "I285", "province": "PU", "name": "SANT'ANGELO IN LIZZOLA (soppresso)" },
    { "code": "I286", "province": "MC", "name": "SANT'ANGELO IN PONTANO" },
    { "code": "I287", "province": "PS", "name": "SANT'ANGELO IN VADO (soppresso)" },
    { "code": "I287", "province": "PU", "name": "SANT'ANGELO IN VADO" },
    { "code": "I288", "province": "PZ", "name": "SANT'ANGELO LE FRATTE" },
    { "code": "I289", "province": "CB", "name": "SANT'ANGELO LIMOSANO" },
    { "code": "I274", "province": "MI", "name": "SANT'ANGELO LODIGIANO (soppresso)" },
    { "code": "I274", "province": "LO", "name": "SANT'ANGELO LODIGIANO" },
    { "code": "I276", "province": "PV", "name": "SANT'ANGELO LOMELLINA" },
    { "code": "I290", "province": "AG", "name": "SANT'ANGELO MUXARO" },
    { "code": "I284", "province": "RM", "name": "SANT'ANGELO ROMANO" },
    { "code": "M209", "province": "CA", "name": "SANT'ANNA ARRESI (soppresso)" },
    { "code": "M209", "province": "CI", "name": "SANT'ANNA ARRESI (soppresso)" },
    { "code": "M209", "province": "SU", "name": "SANT'ANNA ARRESI" },
    { "code": "I292", "province": "VR", "name": "SANT'ANNA D'ALFAEDO" },
    { "code": "I293", "province": "NA", "name": "SANT'ANTIMO" },
    { "code": "I294", "province": "CA", "name": "SANT'ANTIOCO (soppresso)" },
    { "code": "I294", "province": "CI", "name": "SANT'ANTIOCO (soppresso)" },
    { "code": "I294", "province": "SU", "name": "SANT'ANTIOCO" },
    { "code": "I296", "province": "TO", "name": "SANT'ANTONINO DI SUSA" },
    { "code": "I299", "province": "PC", "name": "SANT'ANTONIO A TREBBIA (soppresso)" },
    { "code": "I300", "province": "NA", "name": "SANT'ANTONIO ABATE" },
    { "code": "I297", "province": "BG", "name": "SANT'ANTONIO D'ADDA (soppresso)" },
    { "code": "M276", "province": "SS", "name": "SANT'ANTONIO DI GALLURA" },
    { "code": "M276", "province": "OT", "name": "SANT'ANTONIO DI GALLURA (soppresso)" },
    { "code": "I298", "province": "CA", "name": "SANT'ANTONIO RUINAS (soppresso)" },
    { "code": "I298", "province": "OR", "name": "SANT'ANTONIO RUINAS (soppresso)" },
    { "code": "I302", "province": "CE", "name": "SANT'APOLLINARE (soppresso)" },
    { "code": "I302", "province": "FR", "name": "SANT'APOLLINARE" },
    { "code": "I303", "province": "RO", "name": "SANT'APOLLINARE CON SELVA (soppresso)" },
    { "code": "I305", "province": "PZ", "name": "SANT'ARCANGELO" },
    { "code": "I304", "province": "FO", "name": "SANT'ARCANGELO DI ROMAGNA (soppresso)" },
    { "code": "I304", "province": "FO", "name": "SANTARCANGELO DI ROMAGNA (soppresso)" },
    { "code": "I304", "province": "RN", "name": "SANTARCANGELO DI ROMAGNA" },
    { "code": "F557", "province": "AV", "name": "SANT'ARCANGELO TRIMONTE (soppresso)" },
    { "code": "F557", "province": "BN", "name": "SANT'ARCANGELO TRIMONTE" },
    { "code": "I306", "province": "NA", "name": "SANT'ARPINO (soppresso)" },
    { "code": "I306", "province": "CE", "name": "SANT'ARPINO" },
    { "code": "I307", "province": "SA", "name": "SANT'ARSENIO" },
    { "code": "I326", "province": "AQ", "name": "SANTE MARIE" },
    { "code": "I318", "province": "TE", "name": "SANT'EGIDIO ALLA VIBRATA" },
    { "code": "I317", "province": "SA", "name": "SANT'EGIDIO DEL MONTE ALBINO" },
    { "code": "I319", "province": "PD", "name": "SANT'ELENA" },
    { "code": "B466", "province": "CB", "name": "SANT'ELENA SANNITA (soppresso)" },
    { "code": "B466", "province": "IS", "name": "SANT'ELENA SANNITA" },
    { "code": "I320", "province": "CB", "name": "SANT'ELIA A PIANISI" },
    { "code": "I321", "province": "CE", "name": "SANT'ELIA FIUMERAPIDO (soppresso)" },
    { "code": "I321", "province": "FR", "name": "SANT'ELIA FIUMERAPIDO" },
    { "code": "I324", "province": "AP", "name": "SANT'ELPIDIO A MARE (soppresso)" },
    { "code": "I324", "province": "FM", "name": "SANT'ELPIDIO A MARE" },
    { "code": "I327", "province": "TO", "name": "SANTENA" },
    { "code": "I330", "province": "BA", "name": "SANTERAMO IN COLLE" },
    { "code": "I332", "province": "CH", "name": "SANT'EUFEMIA A MAIELLA (soppresso)" },
    { "code": "I332", "province": "PE", "name": "SANT'EUFEMIA A MAIELLA" },
    { "code": "I333", "province": "RC", "name": "SANT'EUFEMIA D'ASPROMONTE" },
    { "code": "I186", "province": "BS", "name": "SANT'EUFEMIA DELLA FONTE (soppresso)" },
    { "code": "I334", "province": "CZ", "name": "SANT'EUFEMIA LAMEZIA (soppresso)" },
    { "code": "H673", "province": "AO", "name": "SANT'EUGENDO (soppresso)" },
    { "code": "I335", "province": "CH", "name": "SANT'EUSANIO DEL SANGRO" },
    { "code": "I336", "province": "AQ", "name": "SANT'EUSANIO FORCONESE" },
    { "code": "I337", "province": "NO", "name": "SANTHIA' (soppresso)" },
    { "code": "I337", "province": "VC", "name": "SANTHIA'" },
    { "code": "I339", "province": "CE", "name": "SANTI COSMA E DAMIANO (soppresso)" },
    { "code": "I339", "province": "RM", "name": "SANTI COSMA E DAMIANO (soppresso)" },
    { "code": "I339", "province": "LT", "name": "SANTI COSMA E DAMIANO" },
    { "code": "I338", "province": "BS", "name": "SANTICOLO (soppresso)" },
    { "code": "I341", "province": "RC", "name": "SANT'ILARIO DELLO IONIO" },
    { "code": "I342", "province": "RE", "name": "SANT'ILARIO D'ENZA" },
    { "code": "I340", "province": "GE", "name": "SANT'ILARIO LIGURE (soppresso)" },
    { "code": "I343", "province": "NO", "name": "SANTINO (soppresso)" },
    { "code": "I344", "province": "PS", "name": "SANT'IPPOLITO (soppresso)" },
    { "code": "I344", "province": "PU", "name": "SANT'IPPOLITO" },
    { "code": "I355", "province": "UD", "name": "SANTO SPIRITO DELLA BAINSIZZA (soppresso)" },
    { "code": "I355", "province": "GO", "name": "SANTO SPIRITO DELLA BAINSIZZA (soppresso)" },
    { "code": "I362", "province": "MI", "name": "SANTO STEFANO AL CORNO (soppresso)" },
    { "code": "I365", "province": "IM", "name": "SANTO STEFANO AL MARE" },
    { "code": "I367", "province": "CN", "name": "SANTO STEFANO BELBO" },
    { "code": "I368", "province": "GE", "name": "SANTO STEFANO D'AVETO" },
    { "code": "I358", "province": "BG", "name": "SANTO STEFANO DEL MONTE DEGLI ANGELI (soppresso)" },
    { "code": "I357", "province": "AV", "name": "SANTO STEFANO DEL SOLE" },
    { "code": "I369", "province": "ME", "name": "SANTO STEFANO DI BRIGA (soppresso)" },
    { "code": "C919", "province": "BL", "name": "SANTO STEFANO DI CADORE" },
    { "code": "I370", "province": "ME", "name": "SANTO STEFANO DI CAMASTRA" },
    { "code": "I363", "province": "GE", "name": "SANTO STEFANO DI MAGRA (soppresso)" },
    { "code": "I363", "province": "SP", "name": "SANTO STEFANO DI MAGRA" },
    { "code": "I359", "province": "CS", "name": "SANTO STEFANO DI ROGLIANO" },
    { "code": "I360", "province": "AQ", "name": "SANTO STEFANO DI SESSANIO" },
    { "code": "I371", "province": "RC", "name": "SANTO STEFANO IN ASPROMONTE" },
    { "code": "I362", "province": "MI", "name": "SANTO STEFANO LODIGIANO (soppresso)" },
    { "code": "I362", "province": "LO", "name": "SANTO STEFANO LODIGIANO" },
    { "code": "I356", "province": "AG", "name": "SANTO STEFANO QUISQUINA" },
    { "code": "I372", "province": "CN", "name": "SANTO STEFANO ROERO" },
    { "code": "I361", "province": "MI", "name": "SANTO STEFANO TICINO" },
    { "code": "I346", "province": "GE", "name": "SANT'OLCESE" },
    { "code": "I260", "province": "SA", "name": "SANTOMENNA" },
    { "code": "I348", "province": "TE", "name": "SANT'OMERO" },
    { "code": "I349", "province": "BG", "name": "SANT'OMOBONO IMAGNA (soppresso)" },
    { "code": "I349", "province": "BG", "name": "SANT'OMOBONO TERME (soppresso)" },
    { "code": "M333", "province": "BG", "name": "SANT'OMOBONO TERME" },
    { "code": "I350", "province": "CZ", "name": "SANT'ONOFRIO (soppresso)" },
    { "code": "I350", "province": "VV", "name": "SANT'ONOFRIO" },
    { "code": "I351", "province": "CE", "name": "SANTOPADRE (soppresso)" },
    { "code": "I351", "province": "FR", "name": "SANTOPADRE" },
    { "code": "I352", "province": "RM", "name": "SANT'ORESTE" },
    { "code": "I352", "province": "VT", "name": "SANT'ORESTE (soppresso)" },
    { "code": "I353", "province": "VI", "name": "SANTORSO" },
    { "code": "I354", "province": "TN", "name": "SANT'ORSOLA (soppresso)" },
    { "code": "I354", "province": "TN", "name": "SANT'ORSOLA TERME" },
    { "code": "I374", "province": "CA", "name": "SANTU LUSSURGIU (soppresso)" },
    { "code": "I374", "province": "OR", "name": "SANTU LUSSURGIU" },
    { "code": "I375", "province": "PD", "name": "SANT'URBANO" },
    { "code": "I386", "province": "PL", "name": "SANVINCENTI (soppresso)" },
    { "code": "I410", "province": "SA", "name": "SANZA" },
    { "code": "I411", "province": "TN", "name": "SANZENO" },
    { "code": "I418", "province": "PD", "name": "SAONARA" },
    { "code": "I419", "province": "TN", "name": "SAONE (soppresso)" },
    { "code": "I420", "province": "ME", "name": "SAPONARA" },
    { "code": "E221", "province": "PZ", "name": "SAPONARA DI GRUMENTO (soppresso)" },
    { "code": "I420", "province": "ME", "name": "SAPONARA VILLAFRANCA (soppresso)" },
    { "code": "I421", "province": "BL", "name": "SAPPADA (soppresso)" },
    { "code": "I421", "province": "UD", "name": "SAPPADA" },
    { "code": "I422", "province": "SA", "name": "SAPRI" },
    { "code": "I423", "province": "CS", "name": "SARACENA" },
    { "code": "I424", "province": "RM", "name": "SARACINESCO" },
    { "code": "I425", "province": "VI", "name": "SARCEDO" },
    { "code": "I426", "province": "PZ", "name": "SARCONI" },
    { "code": "I427", "province": "TN", "name": "SARDAGNA (soppresso)" },
    { "code": "I428", "province": "CA", "name": "SARDARA (soppresso)" },
    { "code": "I428", "province": "VS", "name": "SARDARA (soppresso)" },
    { "code": "I428", "province": "SU", "name": "SARDARA" },
    { "code": "I429", "province": "AL", "name": "SARDIGLIANO" },
    { "code": "I430", "province": "VI", "name": "SAREGO" },
    { "code": "I431", "province": "TN", "name": "SARENTINO (soppresso)" },
    { "code": "I431", "province": "BZ", "name": "SARENTINO" },
    { "code": "I432", "province": "AL", "name": "SAREZZANO" },
    { "code": "I433", "province": "BS", "name": "SAREZZO" },
    { "code": "I434", "province": "PC", "name": "SARMATO" },
    { "code": "I435", "province": "TV", "name": "SARMEDE" },
    { "code": "I436", "province": "MC", "name": "SARNANO" },
    { "code": "I437", "province": "BG", "name": "SARNICO" },
    { "code": "I438", "province": "SA", "name": "SARNO" },
    { "code": "I439", "province": "TN", "name": "SARNONICO" },
    { "code": "I440", "province": "IM", "name": "SAROLA (soppresso)" },
    { "code": "I441", "province": "MI", "name": "SARONNO (soppresso)" },
    { "code": "I441", "province": "VA", "name": "SARONNO" },
    { "code": "I442", "province": "TO", "name": "SARRE (soppresso)" },
    { "code": "I442", "province": "AO", "name": "SARRE" },
    { "code": "I443", "province": "CA", "name": "SARROCH" },
    { "code": "I444", "province": "FO", "name": "SARSINA (soppresso)" },
    { "code": "I444", "province": "FC", "name": "SARSINA" },
    { "code": "I445", "province": "SI", "name": "SARTEANO" },
    { "code": "I446", "province": "CO", "name": "SARTIRANA BRIANTEA (soppresso)" },
    { "code": "I447", "province": "PV", "name": "SARTIRANA LOMELLINA" },
    { "code": "I448", "province": "SS", "name": "SARULE (soppresso)" },
    { "code": "I448", "province": "NU", "name": "SARULE" },
    { "code": "I449", "province": "GE", "name": "SARZANA (soppresso)" },
    { "code": "I449", "province": "SP", "name": "SARZANA" },
    { "code": "I450", "province": "AQ", "name": "SASSA (soppresso)" },
    { "code": "I451", "province": "SA", "name": "SASSANO" },
    { "code": "I452", "province": "SS", "name": "SASSARI" },
    { "code": "I453", "province": "GE", "name": "SASSELLO (soppresso)" },
    { "code": "I453", "province": "SV", "name": "SASSELLO" },
    { "code": "I454", "province": "PI", "name": "SASSETTA (soppresso)" },
    { "code": "I454", "province": "LI", "name": "SASSETTA" },
    { "code": "I455", "province": "BN", "name": "SASSINORO" },
    { "code": "I458", "province": "TN", "name": "SASSO (soppresso)" },
    { "code": "G972", "province": "BO", "name": "SASSO BOLOGNESE (soppresso)" },
    { "code": "I456", "province": "IM", "name": "SASSO DI BORDIGHERA (soppresso)" },
    { "code": "I457", "province": "PZ", "name": "SASSO DI CASTALDA" },
    { "code": "G972", "province": "BO", "name": "SASSO MARCONI" },
    { "code": "I459", "province": "PS", "name": "SASSOCORVARO (soppresso)" },
    { "code": "I459", "province": "PU", "name": "SASSOCORVARO (soppresso)" },
    { "code": "M413", "province": "PU", "name": "SASSOCORVARO AUDITORE" },
    { "code": "I460", "province": "PS", "name": "SASSOFELTRIO (soppresso)" },
    { "code": "I460", "province": "PU", "name": "SASSOFELTRIO" },
    { "code": "I461", "province": "AN", "name": "SASSOFERRATO" },
    { "code": "I462", "province": "MO", "name": "SASSUOLO" },
    { "code": "I463", "province": "CZ", "name": "SATRIANO" },
    { "code": "G614", "province": "PZ", "name": "SATRIANO DI LUCANIA" },
    { "code": "I464", "province": "UD", "name": "SAURIS" },
    { "code": "I465", "province": "TO", "name": "SAUZE DI CESANA" },
    { "code": "I466", "province": "TO", "name": "SAUZE D'OULX" },
    { "code": "I467", "province": "LE", "name": "SAVA (soppresso)" },
    { "code": "I467", "province": "TA", "name": "SAVA" },
    { "code": "I468", "province": "CZ", "name": "SAVELLI (soppresso)" },
    { "code": "I468", "province": "KR", "name": "SAVELLI" },
    { "code": "I469", "province": "CE", "name": "SAVIANO (soppresso)" },
    { "code": "I469", "province": "NA", "name": "SAVIANO" },
    { "code": "I470", "province": "CN", "name": "SAVIGLIANO" },
    { "code": "I471", "province": "AV", "name": "SAVIGNANO DI PUGLIA (soppresso)" },
    { "code": "I472", "province": "FO", "name": "SAVIGNANO DI ROMAGNA (soppresso)" },
    { "code": "I471", "province": "AV", "name": "SAVIGNANO IRPINO" },
    { "code": "I473", "province": "MO", "name": "SAVIGNANO SUL PANARO" },
    { "code": "I472", "province": "FO", "name": "SAVIGNANO SUL RUBICONE (soppresso)" },
    { "code": "I472", "province": "FC", "name": "SAVIGNANO SUL RUBICONE" },
    { "code": "I474", "province": "BO", "name": "SAVIGNO (soppresso)" },
    { "code": "I475", "province": "GE", "name": "SAVIGNONE" },
    { "code": "I476", "province": "BS", "name": "SAVIORE (soppresso)" },
    { "code": "I476", "province": "BS", "name": "SAVIORE DELL'ADAMELLO" },
    { "code": "I477", "province": "ME", "name": "SAVOCA" },
    { "code": "I478", "province": "UD", "name": "SAVOGNA" },
    { "code": "I479", "province": "GO", "name": "SAVOGNA (soppresso)" },
    { "code": "I479", "province": "UD", "name": "SAVOGNA (soppresso)" },
    { "code": "I479", "province": "UD", "name": "SAVOGNA D'ISONZO (soppresso)" },
    { "code": "I479", "province": "GO", "name": "SAVOGNA D'ISONZO" },
    { "code": "H730", "province": "PZ", "name": "SAVOIA DI LUCANIA" },
    { "code": "I480", "province": "GE", "name": "SAVONA (soppresso)" },
    { "code": "I480", "province": "SV", "name": "SAVONA" },
    { "code": "I481", "province": "TO", "name": "SAVOULX (soppresso)" },
    { "code": "I482", "province": "PE", "name": "SCAFA" },
    { "code": "I483", "province": "SA", "name": "SCAFATI" },
    { "code": "I484", "province": "CN", "name": "SCAGNELLO" },
    { "code": "I486", "province": "SA", "name": "SCALA" },
    { "code": "I485", "province": "CS", "name": "SCALA COELI" },
    { "code": "I487", "province": "PV", "name": "SCALDASOLE" },
    { "code": "I488", "province": "TN", "name": "SCALE (soppresso)" },
    { "code": "I489", "province": "CS", "name": "SCALEA" },
    { "code": "I490", "province": "TO", "name": "SCALENGHE" },
    { "code": "I488", "province": "TN", "name": "SCALERES (soppresso)" },
    { "code": "I488", "province": "BZ", "name": "SCALERES (soppresso)" },
    { "code": "I491", "province": "CN", "name": "SCALETTA UZZONE (soppresso)" },
    { "code": "I492", "province": "ME", "name": "SCALETTA ZANCLEA" },
    { "code": "I492", "province": "ME", "name": "SCALETTA ZANGLEA (soppresso)" },
    { "code": "I493", "province": "AV", "name": "SCAMPITELLA" },
    { "code": "I494", "province": "CZ", "name": "SCANDALE (soppresso)" },
    { "code": "I494", "province": "KR", "name": "SCANDALE" },
    { "code": "I495", "province": "AL", "name": "SCANDELUZZA (soppresso)" },
    { "code": "I495", "province": "AT", "name": "SCANDELUZZA (soppresso)" },
    { "code": "I496", "province": "RE", "name": "SCANDIANO" },
    { "code": "B962", "province": "FI", "name": "SCANDICCI" },
    { "code": "I497", "province": "CR", "name": "SCANDOLARA RAVARA" },
    { "code": "I498", "province": "CR", "name": "SCANDOLARA RIPA D'OGLIO" },
    { "code": "I499", "province": "PG", "name": "SCANDRIGLIA (soppresso)" },
    { "code": "I499", "province": "RM", "name": "SCANDRIGLIA (soppresso)" },
    { "code": "I499", "province": "RI", "name": "SCANDRIGLIA" },
    { "code": "I500", "province": "CR", "name": "SCANNABUE (soppresso)" },
    { "code": "I501", "province": "AQ", "name": "SCANNO" },
    { "code": "I502", "province": "BG", "name": "SCANO AL BREMBO (soppresso)" },
    { "code": "I503", "province": "CA", "name": "SCANO DI MONTIFERRO (soppresso)" },
    { "code": "I503", "province": "NU", "name": "SCANO DI MONTIFERRO (soppresso)" },
    { "code": "I503", "province": "OR", "name": "SCANO DI MONTIFERRO" },
    { "code": "I504", "province": "GR", "name": "SCANSANO" },
    { "code": "M256", "province": "MT", "name": "SCANZANO JONICO" },
    { "code": "I505", "province": "BG", "name": "SCANZO (soppresso)" },
    { "code": "I506", "province": "BG", "name": "SCANZOROSCIATE" },
    { "code": "I507", "province": "CB", "name": "SCAPOLI (soppresso)" },
    { "code": "I507", "province": "IS", "name": "SCAPOLI" },
    { "code": "I509", "province": "CO", "name": "SCARIA (soppresso)" },
    { "code": "I510", "province": "GR", "name": "SCARLINO" },
    { "code": "I511", "province": "TO", "name": "SCARMAGNO" },
    { "code": "I511", "province": "AO", "name": "SCARMAGNO (soppresso)" },
    { "code": "I512", "province": "CN", "name": "SCARNAFIGI" },
    { "code": "I513", "province": "CN", "name": "SCARNAFIGI-RUFFIA (soppresso)" },
    { "code": "I514", "province": "FI", "name": "SCARPERIA (soppresso)" },
    { "code": "M326", "province": "FI", "name": "SCARPERIA E SAN PIERO" },
    { "code": "I515", "province": "BS", "name": "SCARPIZZOLO (soppresso)" },
    { "code": "I516", "province": "TN", "name": "SCAVES (soppresso)" },
    { "code": "I517", "province": "PS", "name": "SCAVOLINO (soppresso)" },
    { "code": "I518", "province": "TN", "name": "SCELMO (soppresso)" },
    { "code": "I519", "province": "TN", "name": "SCENA (soppresso)" },
    { "code": "I519", "province": "BZ", "name": "SCENA" },
    { "code": "I520", "province": "CH", "name": "SCERNI" },
    { "code": "I522", "province": "PG", "name": "SCHEGGIA E PASCELUPO" },
    { "code": "I523", "province": "PG", "name": "SCHEGGINO" },
    { "code": "I524", "province": "GO", "name": "SCHERBINA (soppresso)" },
    { "code": "I524", "province": "UD", "name": "SCHERBINA (soppresso)" },
    { "code": "I525", "province": "CO", "name": "SCHIANNO (soppresso)" },
    { "code": "I525", "province": "VA", "name": "SCHIANNO (soppresso)" },
    { "code": "I526", "province": "CH", "name": "SCHIAVI DI ABRUZZO" },
    { "code": "I527", "province": "VI", "name": "SCHIAVON" },
    { "code": "I528", "province": "NO", "name": "SCHIERANCO (soppresso)" },
    { "code": "I529", "province": "CO", "name": "SCHIGNANO" },
    { "code": "I530", "province": "BG", "name": "SCHILPARIO" },
    { "code": "I531", "province": "VI", "name": "SCHIO" },
    { "code": "I532", "province": "MN", "name": "SCHIVENOGLIA" },
    { "code": "I533", "province": "AG", "name": "SCIACCA" },
    { "code": "I534", "province": "PA", "name": "SCIARA" },
    { "code": "I516", "province": "TN", "name": "SCIAVES (soppresso)" },
    { "code": "I516", "province": "BZ", "name": "SCIAVES (soppresso)" },
    { "code": "I535", "province": "SR", "name": "SCICLI (soppresso)" },
    { "code": "I535", "province": "RG", "name": "SCICLI" },
    { "code": "I536", "province": "RC", "name": "SCIDO" },
    { "code": "D290", "province": "CS", "name": "SCIGLIANO" },
    { "code": "I537", "province": "RC", "name": "SCILLA" },
    { "code": "I538", "province": "PA", "name": "SCILLATO" },
    { "code": "I539", "province": "TO", "name": "SCIOLZE" },
    { "code": "I540", "province": "CE", "name": "SCISCIANO (soppresso)" },
    { "code": "I540", "province": "NA", "name": "SCISCIANO" },
    { "code": "I541", "province": "PA", "name": "SCLAFANI (soppresso)" },
    { "code": "I541", "province": "PA", "name": "SCLAFANI BAGNI" },
    { "code": "I542", "province": "UD", "name": "SCODOVACCA (soppresso)" },
    { "code": "I543", "province": "AQ", "name": "SCONTRONE" },
    { "code": "I544", "province": "NO", "name": "SCOPA (soppresso)" },
    { "code": "I544", "province": "VC", "name": "SCOPA" },
    { "code": "I545", "province": "NO", "name": "SCOPELLO (soppresso)" },
    { "code": "I545", "province": "VC", "name": "SCOPELLO" },
    { "code": "I546", "province": "AQ", "name": "SCOPPITO" },
    { "code": "I547", "province": "TS", "name": "SCOPPO (soppresso)" },
    { "code": "I548", "province": "CT", "name": "SCORDIA" },
    { "code": "I549", "province": "LE", "name": "SCORRANO" },
    { "code": "I550", "province": "FO", "name": "SCORTICATA (soppresso)" },
    { "code": "I551", "province": "VE", "name": "SCORZE'" },
    { "code": "I552", "province": "GO", "name": "SCRILIE (soppresso)" },
    { "code": "I552", "province": "UD", "name": "SCRILIE (soppresso)" },
    { "code": "I552", "province": "UD", "name": "SCRILLA (soppresso)" },
    { "code": "I552", "province": "GO", "name": "SCRILLA (soppresso)" },
    { "code": "H658", "province": "RM", "name": "SCROFANO (soppresso)" },
    { "code": "I553", "province": "AQ", "name": "SCURCOLA (soppresso)" },
    { "code": "I553", "province": "AQ", "name": "SCURCOLA MARSICANA" },
    { "code": "I554", "province": "TN", "name": "SCURELLE" },
    { "code": "I555", "province": "AL", "name": "SCURZOLENGO (soppresso)" },
    { "code": "I555", "province": "AT", "name": "SCURZOLENGO" },
    { "code": "I556", "province": "IM", "name": "SEBORGA" },
    { "code": "I557", "province": "GO", "name": "SEBREGHE (soppresso)" },
    { "code": "I557", "province": "UD", "name": "SEBREGHE (soppresso)" },
    { "code": "I558", "province": "AQ", "name": "SECINARO" },
    { "code": "I559", "province": "LE", "name": "SECLI'" },
    { "code": "I560", "province": "NA", "name": "SECONDIGLIANO (soppresso)" },
    { "code": "I561", "province": "MI", "name": "SECUGNAGO (soppresso)" },
    { "code": "I561", "province": "LO", "name": "SECUGNAGO" },
    { "code": "I562", "province": "UD", "name": "SEDEGLIANO" },
    { "code": "I563", "province": "BL", "name": "SEDICO" },
    { "code": "I564", "province": "CA", "name": "SEDILO (soppresso)" },
    { "code": "I564", "province": "OR", "name": "SEDILO" },
    { "code": "I565", "province": "SS", "name": "SEDINI" },
    { "code": "I566", "province": "MI", "name": "SEDRIANO" },
    { "code": "I567", "province": "BG", "name": "SEDRINA" },
    { "code": "I568", "province": "GO", "name": "SEDULA (soppresso)" },
    { "code": "I568", "province": "UD", "name": "SEDULA (soppresso)" },
    { "code": "I569", "province": "MC", "name": "SEFRO" },
    { "code": "I570", "province": "CA", "name": "SEGARIU (soppresso)" },
    { "code": "I570", "province": "VS", "name": "SEGARIU (soppresso)" },
    { "code": "I570", "province": "SU", "name": "SEGARIU" },
    { "code": "I571", "province": "GR", "name": "SEGGIANO" },
    { "code": "I572", "province": "CO", "name": "SEGHEBBIA (soppresso)" },
    { "code": "C842", "province": "UD", "name": "SEGNACCO (soppresso)" },
    { "code": "I573", "province": "RM", "name": "SEGNI" },
    { "code": "I574", "province": "GE", "name": "SEGNO (soppresso)" },
    { "code": "I575", "province": "TN", "name": "SEGNO (soppresso)" },
    { "code": "I574", "province": "SV", "name": "SEGNO (soppresso)" },
    { "code": "I576", "province": "TN", "name": "SEGONZANO" },
    { "code": "I577", "province": "MI", "name": "SEGRATE" },
    { "code": "I578", "province": "TV", "name": "SEGUSINO" },
    { "code": "I579", "province": "TN", "name": "SEIO (soppresso)" },
    { "code": "I580", "province": "CA", "name": "SELARGIUS" },
    { "code": "I581", "province": "PG", "name": "SELCI (soppresso)" },
    { "code": "I581", "province": "RM", "name": "SELCI (soppresso)" },
    { "code": "I581", "province": "RI", "name": "SELCI" },
    { "code": "I582", "province": "CA", "name": "SELEGAS (soppresso)" },
    { "code": "I582", "province": "SU", "name": "SELEGAS" },
    { "code": "I583", "province": "BG", "name": "SELINO (soppresso)" },
    { "code": "I584", "province": "UD", "name": "SELLA DELLE TRINCEE (soppresso)" },
    { "code": "I584", "province": "GO", "name": "SELLA DELLE TRINCEE (soppresso)" },
    { "code": "M360", "province": "TN", "name": "SELLA GIUDICARIE" },
    { "code": "I585", "province": "PG", "name": "SELLANO" },
    { "code": "I587", "province": "BG", "name": "SELLERE (soppresso)" },
    { "code": "I588", "province": "BS", "name": "SELLERO" },
    { "code": "I589", "province": "CZ", "name": "SELLIA" },
    { "code": "I590", "province": "CZ", "name": "SELLIA MARINA" },
    { "code": "I584", "province": "GO", "name": "SELLO (soppresso)" },
    { "code": "I584", "province": "UD", "name": "SELLO (soppresso)" },
    { "code": "I591", "province": "TN", "name": "SELVA (soppresso)" },
    { "code": "I591", "province": "BZ", "name": "SELVA (soppresso)" },
    { "code": "I592", "province": "BL", "name": "SELVA BELLUNESE (soppresso)" },
    { "code": "I593", "province": "TN", "name": "SELVA DEI MOLINI (soppresso)" },
    { "code": "I593", "province": "BZ", "name": "SELVA DEI MOLINI" },
    { "code": "I592", "province": "BL", "name": "SELVA DI CADORE" },
    { "code": "I594", "province": "VR", "name": "SELVA DI PROGNO" },
    { "code": "I591", "province": "BZ", "name": "SELVA DI VAL GARDENA" },
    { "code": "I591", "province": "TN", "name": "SELVA IN GARDENA (soppresso)" },
    { "code": "I595", "province": "PD", "name": "SELVAZZANO DENTRO" },
    { "code": "I596", "province": "NO", "name": "SELVE MARCONE (soppresso)" },
    { "code": "I596", "province": "VC", "name": "SELVE MARCONE (soppresso)" },
    { "code": "I596", "province": "BI", "name": "SELVE MARCONE (soppresso)" },
    { "code": "I597", "province": "BG", "name": "SELVINO" },
    { "code": "I598", "province": "SS", "name": "SEMESTENE" },
    { "code": "I599", "province": "PV", "name": "SEMIANA" },
    { "code": "I600", "province": "RC", "name": "SEMINARA" },
    { "code": "H740", "province": "GO", "name": "SEMPAS (soppresso)" },
    { "code": "H740", "province": "UD", "name": "SEMPAS (soppresso)" },
    { "code": "I601", "province": "GR", "name": "SEMPRONIANO" },
    { "code": "M390", "province": "TN", "name": "SEN JAN DI FASSA (soppresso)" },
    { "code": "I746", "province": "TS", "name": "SENADOLE (soppresso)" },
    { "code": "I602", "province": "MI", "name": "SENAGO" },
    { "code": "ND", "province": "TN", "name": "SENALE (soppresso)" },
    { "code": "ND", "province": "BZ", "name": "SENALE (soppresso)" },
    { "code": "I604", "province": "TN", "name": "SENALES (soppresso)" },
    { "code": "I604", "province": "BZ", "name": "SENALES" },
    { "code": "I604", "province": "TN", "name": "SENALES IN VENOSTA (soppresso)" },
    { "code": "I603", "province": "BZ", "name": "SENALE-SAN FELICE" },
    { "code": "I605", "province": "CA", "name": "SENEGHE (soppresso)" },
    { "code": "I605", "province": "OR", "name": "SENEGHE" },
    { "code": "I606", "province": "AV", "name": "SENERCHIA" },
    { "code": "I607", "province": "BS", "name": "SENIGA" },
    { "code": "I608", "province": "AN", "name": "SENIGALLIA" },
    { "code": "I609", "province": "CA", "name": "SENIS (soppresso)" },
    { "code": "I609", "province": "OR", "name": "SENIS" },
    { "code": "I610", "province": "PZ", "name": "SENISE" },
    { "code": "I611", "province": "CO", "name": "SENNA COMASCO" },
    { "code": "I612", "province": "MI", "name": "SENNA LODIGIANA (soppresso)" },
    { "code": "I612", "province": "LO", "name": "SENNA LODIGIANA" },
    { "code": "I613", "province": "CA", "name": "SENNARIOLO (soppresso)" },
    { "code": "I613", "province": "NU", "name": "SENNARIOLO (soppresso)" },
    { "code": "I613", "province": "OR", "name": "SENNARIOLO" },
    { "code": "I614", "province": "SS", "name": "SENNORI" },
    { "code": "I615", "province": "CA", "name": "SENORBI' (soppresso)" },
    { "code": "I615", "province": "SU", "name": "SENORBI'" },
    { "code": "I616", "province": "TS", "name": "SENOSECCHIA (soppresso)" },
    { "code": "I617", "province": "TN", "name": "SEO (soppresso)" },
    { "code": "I618", "province": "CB", "name": "SEPINO" },
    { "code": "I619", "province": "NO", "name": "SEPPIANA (soppresso)" },
    { "code": "I619", "province": "VB", "name": "SEPPIANA (soppresso)" },
    { "code": "I620", "province": "CO", "name": "SEPRIO (soppresso)" },
    { "code": "I621", "province": "UD", "name": "SEQUALS (soppresso)" },
    { "code": "I621", "province": "PN", "name": "SEQUALS" },
    { "code": "I622", "province": "LU", "name": "SERAVEZZA" },
    { "code": "I623", "province": "CA", "name": "SERBARIU (soppresso)" },
    { "code": "I624", "province": "CA", "name": "SERDIANA (soppresso)" },
    { "code": "I624", "province": "SU", "name": "SERDIANA" },
    { "code": "I625", "province": "MI", "name": "SEREGNO (soppresso)" },
    { "code": "I625", "province": "MB", "name": "SEREGNO" },
    { "code": "I626", "province": "BL", "name": "SEREN (soppresso)" },
    { "code": "I626", "province": "BL", "name": "SEREN DEL GRAPPA" },
    { "code": "I627", "province": "CR", "name": "SERGNANO" },
    { "code": "I628", "province": "BG", "name": "SERIATE" },
    { "code": "I629", "province": "BG", "name": "SERINA" },
    { "code": "I630", "province": "AV", "name": "SERINO" },
    { "code": "I631", "province": "BS", "name": "SERLE" },
    { "code": "I632", "province": "MN", "name": "SERMIDE (soppresso)" },
    { "code": "I632", "province": "MN", "name": "SERMIDE E FELONICA" },
    { "code": "I633", "province": "BS", "name": "SERMIONE (soppresso)" },
    { "code": "I634", "province": "RM", "name": "SERMONETA (soppresso)" },
    { "code": "I634", "province": "LT", "name": "SERMONETA" },
    { "code": "I635", "province": "TV", "name": "SERNAGLIA (soppresso)" },
    { "code": "I635", "province": "TV", "name": "SERNAGLIA DELLA BATTAGLIA" },
    { "code": "I636", "province": "SO", "name": "SERNIO" },
    { "code": "I637", "province": "AL", "name": "SEROLE (soppresso)" },
    { "code": "I637", "province": "AT", "name": "SEROLE" },
    { "code": "I638", "province": "GO", "name": "SERPENIZZA (soppresso)" },
    { "code": "I638", "province": "UD", "name": "SERPENIZZA (soppresso)" },
    { "code": "I642", "province": "CS", "name": "SERRA D'AIELLO" },
    { "code": "I643", "province": "AN", "name": "SERRA DE' CONTI" },
    { "code": "I650", "province": "CS", "name": "SERRA PEDACE (soppresso)" },
    { "code": "I640", "province": "GE", "name": "SERRA RICCO'" },
    { "code": "I639", "province": "CZ", "name": "SERRA SAN BRUNO (soppresso)" },
    { "code": "I639", "province": "VV", "name": "SERRA SAN BRUNO" },
    { "code": "I653", "province": "AN", "name": "SERRA SAN QUIRICO" },
    { "code": "I654", "province": "PS", "name": "SERRA SANT'ABBONDIO (soppresso)" },
    { "code": "I654", "province": "PU", "name": "SERRA SANT'ABBONDIO" },
    { "code": "I641", "province": "FG", "name": "SERRACAPRIOLA" },
    { "code": "I644", "province": "CL", "name": "SERRADIFALCO" },
    { "code": "I646", "province": "CN", "name": "SERRALUNGA D'ALBA" },
    { "code": "I645", "province": "AL", "name": "SERRALUNGA DI CREA" },
    { "code": "I647", "province": "CA", "name": "SERRAMANNA (soppresso)" },
    { "code": "I647", "province": "VS", "name": "SERRAMANNA (soppresso)" },
    { "code": "I647", "province": "SU", "name": "SERRAMANNA" },
    { "code": "F357", "province": "MO", "name": "SERRAMAZZONI" },
    { "code": "I648", "province": "SA", "name": "SERRAMEZZANA" },
    { "code": "I649", "province": "CH", "name": "SERRAMONACESCA (soppresso)" },
    { "code": "I649", "province": "PE", "name": "SERRAMONACESCA" },
    { "code": "I651", "province": "MC", "name": "SERRAPETRONA" },
    { "code": "I652", "province": "NA", "name": "SERRARA FONTANA" },
    { "code": "I655", "province": "CZ", "name": "SERRASTRETTA" },
    { "code": "I656", "province": "RC", "name": "SERRATA" },
    { "code": "I662", "province": "MN", "name": "SERRAVALLE A PO" },
    { "code": "I665", "province": "TN", "name": "SERRAVALLE ALL'ADIGE (soppresso)" },
    { "code": "I658", "province": "AL", "name": "SERRAVALLE D'ASTI (soppresso)" },
    { "code": "I659", "province": "CN", "name": "SERRAVALLE DELLE LANGHE (soppresso)" },
    { "code": "I661", "province": "MC", "name": "SERRAVALLE DI CHIENTI" },
    { "code": "I659", "province": "CN", "name": "SERRAVALLE LANGHE" },
    { "code": "I657", "province": "AL", "name": "SERRAVALLE LIBARNA (soppresso)" },
    { "code": "I660", "province": "FI", "name": "SERRAVALLE PISTOIESE (soppresso)" },
    { "code": "I660", "province": "PT", "name": "SERRAVALLE PISTOIESE" },
    { "code": "I657", "province": "AL", "name": "SERRAVALLE SCRIVIA" },
    { "code": "I663", "province": "NO", "name": "SERRAVALLE SESIA (soppresso)" },
    { "code": "I663", "province": "VC", "name": "SERRAVALLE SESIA" },
    { "code": "I666", "province": "SA", "name": "SERRE" },
    { "code": "I667", "province": "CA", "name": "SERRENTI (soppresso)" },
    { "code": "I667", "province": "VS", "name": "SERRENTI (soppresso)" },
    { "code": "I667", "province": "SU", "name": "SERRENTI" },
    { "code": "I668", "province": "CA", "name": "SERRI (soppresso)" },
    { "code": "I668", "province": "NU", "name": "SERRI (soppresso)" },
    { "code": "I668", "province": "SU", "name": "SERRI" },
    { "code": "I669", "province": "RM", "name": "SERRONE (soppresso)" },
    { "code": "I669", "province": "FR", "name": "SERRONE" },
    { "code": "I670", "province": "PS", "name": "SERRUNGARINA (soppresso)" },
    { "code": "I670", "province": "PU", "name": "SERRUNGARINA (soppresso)" },
    { "code": "I671", "province": "CZ", "name": "SERSALE" },
    { "code": "I672", "province": "TN", "name": "SERSO (soppresso)" },
    { "code": "C070", "province": "AP", "name": "SERVIGLIANO (soppresso)" },
    { "code": "C070", "province": "FM", "name": "SERVIGLIANO" },
    { "code": "I674", "province": "TS", "name": "SESANA (soppresso)" },
    { "code": "I676", "province": "CE", "name": "SESSA AURUNCA" },
    { "code": "I676", "province": "NA", "name": "SESSA AURUNCA (soppresso)" },
    { "code": "I677", "province": "SA", "name": "SESSA CILENTO" },
    { "code": "I678", "province": "AL", "name": "SESSAME (soppresso)" },
    { "code": "I678", "province": "AT", "name": "SESSAME" },
    { "code": "I679", "province": "CB", "name": "SESSANO (soppresso)" },
    { "code": "I679", "province": "CB", "name": "SESSANO DEL MOLISE (soppresso)" },
    { "code": "I679", "province": "IS", "name": "SESSANO DEL MOLISE" },
    { "code": "I680", "province": "AL", "name": "SESSANT (soppresso)" },
    { "code": "E070", "province": "GE", "name": "SESTA GODANO (soppresso)" },
    { "code": "E070", "province": "SP", "name": "SESTA GODANO" },
    { "code": "I681", "province": "AR", "name": "SESTINO" },
    { "code": "I687", "province": "TN", "name": "SESTO (soppresso)" },
    { "code": "I687", "province": "BZ", "name": "SESTO" },
    { "code": "I686", "province": "UD", "name": "SESTO AL REGHENA (soppresso)" },
    { "code": "I686", "province": "PN", "name": "SESTO AL REGHENA" },
    { "code": "I688", "province": "MI", "name": "SESTO CALENDE (soppresso)" },
    { "code": "I688", "province": "VA", "name": "SESTO CALENDE" },
    { "code": "I682", "province": "CB", "name": "SESTO CAMPANO (soppresso)" },
    { "code": "I682", "province": "IS", "name": "SESTO CAMPANO" },
    { "code": "I683", "province": "CR", "name": "SESTO ED UNITI" },
    { "code": "I684", "province": "FI", "name": "SESTO FIORENTINO" },
    { "code": "I690", "province": "MI", "name": "SESTO SAN GIOVANNI" },
    { "code": "I689", "province": "MO", "name": "SESTOLA" },
    { "code": "I693", "province": "GE", "name": "SESTRI LEVANTE" },
    { "code": "I694", "province": "GE", "name": "SESTRI PONENTE (soppresso)" },
    { "code": "I692", "province": "TO", "name": "SESTRIERE" },
    { "code": "I692", "province": "TO", "name": "SESTRIERES (soppresso)" },
    { "code": "I695", "province": "CA", "name": "SESTU" },
    { "code": "I696", "province": "MI", "name": "SETTALA" },
    { "code": "I697", "province": "CE", "name": "SETTEFRATI (soppresso)" },
    { "code": "I697", "province": "FR", "name": "SETTEFRATI" },
    { "code": "I698", "province": "AL", "name": "SETTIME (soppresso)" },
    { "code": "I698", "province": "AT", "name": "SETTIME" },
    { "code": "I700", "province": "MI", "name": "SETTIMO MILANESE" },
    { "code": "I701", "province": "TO", "name": "SETTIMO ROTTARO" },
    { "code": "I701", "province": "AO", "name": "SETTIMO ROTTARO (soppresso)" },
    { "code": "I699", "province": "CA", "name": "SETTIMO SAN PIETRO" },
    { "code": "I702", "province": "AO", "name": "SETTIMO TAVAGNASCO (soppresso)" },
    { "code": "I702", "province": "TO", "name": "SETTIMO TAVAGNASCO (soppresso)" },
    { "code": "I703", "province": "TO", "name": "SETTIMO TORINESE" },
    { "code": "I702", "province": "TO", "name": "SETTIMO VITTONE" },
    { "code": "I702", "province": "AO", "name": "SETTIMO VITTONE (soppresso)" },
    { "code": "I704", "province": "CZ", "name": "SETTINGIANO" },
    { "code": "I705", "province": "CA", "name": "SETZU (soppresso)" },
    { "code": "I705", "province": "VS", "name": "SETZU (soppresso)" },
    { "code": "I705", "province": "SU", "name": "SETZU" },
    { "code": "I706", "province": "CA", "name": "SEUI (soppresso)" },
    { "code": "I706", "province": "NU", "name": "SEUI (soppresso)" },
    { "code": "I706", "province": "OG", "name": "SEUI (soppresso)" },
    { "code": "I706", "province": "SU", "name": "SEUI" },
    { "code": "I707", "province": "CA", "name": "SEULO (soppresso)" },
    { "code": "I707", "province": "NU", "name": "SEULO (soppresso)" },
    { "code": "I707", "province": "SU", "name": "SEULO" },
    { "code": "I709", "province": "MI", "name": "SEVESO (soppresso)" },
    { "code": "I709", "province": "MB", "name": "SEVESO" },
    { "code": "I710", "province": "TN", "name": "SEVIGNANO (soppresso)" },
    { "code": "I711", "province": "AL", "name": "SEZZADIO" },
    { "code": "I712", "province": "RM", "name": "SEZZE (soppresso)" },
    { "code": "I712", "province": "LT", "name": "SEZZE" },
    { "code": "I711", "province": "AL", "name": "SEZZE' (soppresso)" },
    { "code": "I713", "province": "BG", "name": "SFORZATICA (soppresso)" },
    { "code": "I714", "province": "TN", "name": "SFRUZ" },
    { "code": "I715", "province": "TS", "name": "SGONICO (soppresso)" },
    { "code": "I715", "province": "TS", "name": "SGONICO-ZGONIK" },
    { "code": "I716", "province": "RM", "name": "SGURGOLA (soppresso)" },
    { "code": "I716", "province": "FR", "name": "SGURGOLA" },
    { "code": "I717", "province": "CA", "name": "SIAMAGGIORE (soppresso)" },
    { "code": "I717", "province": "OR", "name": "SIAMAGGIORE" },
    { "code": "ND", "province": "CA", "name": "SIAMANNA (soppresso)" },
    { "code": "I718", "province": "OR", "name": "SIAMANNA" },
    { "code": "I719", "province": "CA", "name": "SIAMANNA-SIAPICCIA (soppresso)" },
    { "code": "I719", "province": "OR", "name": "SIAMANNA-SIAPICCIA (soppresso)" },
    { "code": "I720", "province": "SA", "name": "SIANO" },
    { "code": "I721", "province": "CA", "name": "SIAPICCIA (soppresso)" },
    { "code": "I721", "province": "OR", "name": "SIAPICCIA" },
    { "code": "I722", "province": "CA", "name": "SICCI SAN BIAGIO (soppresso)" },
    { "code": "M253", "province": "SA", "name": "SICIGNANO (soppresso)" },
    { "code": "M253", "province": "SA", "name": "SICIGNANO DEGLI ALBURNI" },
    { "code": "I723", "province": "AG", "name": "SICULIANA" },
    { "code": "I724", "province": "CA", "name": "SIDDI (soppresso)" },
    { "code": "I724", "province": "VS", "name": "SIDDI (soppresso)" },
    { "code": "I724", "province": "SU", "name": "SIDDI" },
    { "code": "I725", "province": "RC", "name": "SIDERNO" },
    { "code": "I726", "province": "SI", "name": "SIENA" },
    { "code": "I727", "province": "PG", "name": "SIGILLO" },
    { "code": "I728", "province": "FI", "name": "SIGNA" },
    { "code": "I729", "province": "TN", "name": "SILANDRO (soppresso)" },
    { "code": "I729", "province": "BZ", "name": "SILANDRO" },
    { "code": "I730", "province": "SS", "name": "SILANUS (soppresso)" },
    { "code": "I730", "province": "NU", "name": "SILANUS" },
    { "code": "F116", "province": "TV", "name": "SILEA" },
    { "code": "I731", "province": "CA", "name": "SILI' (soppresso)" },
    { "code": "I732", "province": "SS", "name": "SILIGO" },
    { "code": "I734", "province": "CA", "name": "SILIQUA (soppresso)" },
    { "code": "I734", "province": "SU", "name": "SILIQUA" },
    { "code": "I735", "province": "CA", "name": "SILIUS (soppresso)" },
    { "code": "I735", "province": "SU", "name": "SILIUS" },
    { "code": "I737", "province": "MS", "name": "SILLANO (soppresso)" },
    { "code": "I737", "province": "LU", "name": "SILLANO (soppresso)" },
    { "code": "M347", "province": "LU", "name": "SILLANO GIUNCUGNANO" },
    { "code": "I736", "province": "NO", "name": "SILLAVENGO" },
    { "code": "I733", "province": "PL", "name": "SILUN MONT'AQUILA (soppresso)" },
    { "code": "I738", "province": "AL", "name": "SILVANO D'ORBA" },
    { "code": "I739", "province": "PV", "name": "SILVANO PIETRA" },
    { "code": "I740", "province": "CR", "name": "SILVELLA (soppresso)" },
    { "code": "I741", "province": "TE", "name": "SILVI" },
    { "code": "I742", "province": "CA", "name": "SIMALA (soppresso)" },
    { "code": "I742", "province": "OR", "name": "SIMALA" },
    { "code": "I743", "province": "CA", "name": "SIMAXIS (soppresso)" },
    { "code": "I743", "province": "OR", "name": "SIMAXIS" },
    { "code": "I744", "province": "CZ", "name": "SIMBARIO (soppresso)" },
    { "code": "I744", "province": "VV", "name": "SIMBARIO" },
    { "code": "I745", "province": "CZ", "name": "SIMERI CRICHI" },
    { "code": "I747", "province": "ME", "name": "SINAGRA" },
    { "code": "A468", "province": "SI", "name": "SINALUNGA" },
    { "code": "I748", "province": "CA", "name": "SINDIA (soppresso)" },
    { "code": "I748", "province": "NU", "name": "SINDIA" },
    { "code": "I749", "province": "CA", "name": "SINI (soppresso)" },
    { "code": "I749", "province": "OR", "name": "SINI" },
    { "code": "I750", "province": "CN", "name": "SINIO" },
    { "code": "I751", "province": "SS", "name": "SINISCOLA (soppresso)" },
    { "code": "I751", "province": "NU", "name": "SINISCOLA" },
    { "code": "I752", "province": "CA", "name": "SINNAI" },
    { "code": "I753", "province": "RC", "name": "SINOPOLI" },
    { "code": "I754", "province": "SR", "name": "SIRACUSA" },
    { "code": "I756", "province": "AV", "name": "SIRIGNANO" },
    { "code": "I757", "province": "CA", "name": "SIRIS (soppresso)" },
    { "code": "I757", "province": "OR", "name": "SIRIS" },
    { "code": "I633", "province": "BS", "name": "SIRMIONE" },
    { "code": "I758", "province": "AN", "name": "SIROLO" },
    { "code": "I759", "province": "CO", "name": "SIRONE (soppresso)" },
    { "code": "I759", "province": "LC", "name": "SIRONE" },
    { "code": "I760", "province": "TN", "name": "SIROR (soppresso)" },
    { "code": "I761", "province": "CO", "name": "SIRTORI (soppresso)" },
    { "code": "I761", "province": "LC", "name": "SIRTORI" },
    { "code": "I762", "province": "CA", "name": "SISINI (soppresso)" },
    { "code": "I763", "province": "PR", "name": "SISSA (soppresso)" },
    { "code": "M325", "province": "PR", "name": "SISSA TRECASALI" },
    { "code": "I764", "province": "CA", "name": "SIURGUS (soppresso)" },
    { "code": "I765", "province": "CA", "name": "SIURGUS DONIGALA (soppresso)" },
    { "code": "I765", "province": "SU", "name": "SIURGUS DONIGALA" },
    { "code": "I766", "province": "BS", "name": "SIVIANO (soppresso)" },
    { "code": "E265", "province": "PV", "name": "SIZIANO" },
    { "code": "I767", "province": "NO", "name": "SIZZANO" },
    { "code": "I768", "province": "UD", "name": "SLAPPE ZORZI (soppresso)" },
    { "code": "I768", "province": "GO", "name": "SLAPPE ZORZI (soppresso)" },
    { "code": "M024", "province": "TS", "name": "SLAVINA (soppresso)" },
    { "code": "I769", "province": "TN", "name": "SLINGIA (soppresso)" },
    { "code": "I769", "province": "BZ", "name": "SLINGIA (soppresso)" },
    { "code": "I769", "province": "TN", "name": "SLINIGA (soppresso)" },
    { "code": "I770", "province": "TS", "name": "SLIVIA (soppresso)" },
    { "code": "I770", "province": "TS", "name": "SLIVNO (soppresso)" },
    { "code": "I771", "province": "TN", "name": "SLUDERNO (soppresso)" },
    { "code": "I771", "province": "BZ", "name": "SLUDERNO" },
    { "code": "I733", "province": "PL", "name": "SLUM (soppresso)" },
    { "code": "I772", "province": "TN", "name": "SMARANO (soppresso)" },
    { "code": "I773", "province": "FU", "name": "SMERIA (soppresso)" },
    { "code": "I773", "province": "PL", "name": "SMERIA (soppresso)" },
    { "code": "I774", "province": "AP", "name": "SMERILLO (soppresso)" },
    { "code": "I774", "province": "FM", "name": "SMERILLO" },
    { "code": "I775", "province": "VR", "name": "SOAVE" },
    { "code": "I776", "province": "NA", "name": "SOCCAVO (soppresso)" },
    { "code": "I777", "province": "UD", "name": "SOCCHIEVE" },
    { "code": "I778", "province": "CA", "name": "SODDI' (soppresso)" },
    { "code": "I778", "province": "OR", "name": "SODDI'" },
    { "code": "I779", "province": "FO", "name": "SOGLIANO AL RUBICONE (soppresso)" },
    { "code": "I779", "province": "FC", "name": "SOGLIANO AL RUBICONE" },
    { "code": "I780", "province": "LE", "name": "SOGLIANO CAVOUR" },
    { "code": "I781", "province": "AL", "name": "SOGLIO (soppresso)" },
    { "code": "I781", "province": "AT", "name": "SOGLIO" },
    { "code": "I782", "province": "BS", "name": "SOIANO DEL LAGO" },
    { "code": "I783", "province": "VI", "name": "SOLAGNA" },
    { "code": "I784", "province": "CA", "name": "SOLANAS (soppresso)" },
    { "code": "I785", "province": "SR", "name": "SOLARINO" },
    { "code": "I786", "province": "MI", "name": "SOLARO" },
    { "code": "I787", "province": "RA", "name": "SOLAROLO" },
    { "code": "I790", "province": "CR", "name": "SOLAROLO RAINERIO" },
    { "code": "I791", "province": "CA", "name": "SOLARUSSA (soppresso)" },
    { "code": "I791", "province": "OR", "name": "SOLARUSSA" },
    { "code": "I792", "province": "CO", "name": "SOLBIATE (soppresso)" },
    { "code": "I793", "province": "VA", "name": "SOLBIATE ARNO" },
    { "code": "I793", "province": "MI", "name": "SOLBIATE ARNO E MONTE (soppresso)" },
    { "code": "I793", "province": "VA", "name": "SOLBIATE ARNO E MONTE (soppresso)" },
    { "code": "M412", "province": "CO", "name": "SOLBIATE CON CAGNO" },
    { "code": "I794", "province": "MI", "name": "SOLBIATE OLONA (soppresso)" },
    { "code": "I794", "province": "VA", "name": "SOLBIATE OLONA" },
    { "code": "I795", "province": "AL", "name": "SOLBRITO (soppresso)" },
    { "code": "I796", "province": "IM", "name": "SOLDANO" },
    { "code": "I797", "province": "CA", "name": "SOLEMINIS (soppresso)" },
    { "code": "I797", "province": "SU", "name": "SOLEMINIS" },
    { "code": "I798", "province": "AL", "name": "SOLERO" },
    { "code": "I799", "province": "PD", "name": "SOLESINO" },
    { "code": "I800", "province": "LE", "name": "SOLETO" },
    { "code": "I801", "province": "MN", "name": "SOLFERINO" },
    { "code": "I802", "province": "MO", "name": "SOLIERA" },
    { "code": "I803", "province": "PR", "name": "SOLIGNANO" },
    { "code": "I804", "province": "AQ", "name": "SOLMONA (soppresso)" },
    { "code": "I805", "province": "AV", "name": "SOLOFRA" },
    { "code": "I807", "province": "TO", "name": "SOLOMIAC (soppresso)" },
    { "code": "I808", "province": "AL", "name": "SOLONGHELLO" },
    { "code": "I809", "province": "BN", "name": "SOLOPACA" },
    { "code": "I811", "province": "BG", "name": "SOLTO (soppresso)" },
    { "code": "I812", "province": "BG", "name": "SOLTO COLLINA" },
    { "code": "I813", "province": "BG", "name": "SOLZA" },
    { "code": "I814", "province": "CO", "name": "SOLZAGO (soppresso)" },
    { "code": "I815", "province": "MI", "name": "SOMAGLIA (soppresso)" },
    { "code": "I815", "province": "LO", "name": "SOMAGLIA" },
    { "code": "I816", "province": "CO", "name": "SOMANA (soppresso)" },
    { "code": "I817", "province": "CN", "name": "SOMANO" },
    { "code": "B148", "province": "BG", "name": "SOMBRENO (soppresso)" },
    { "code": "I818", "province": "BG", "name": "SOMENDENNA (soppresso)" },
    { "code": "I819", "province": "MI", "name": "SOMMA LOMBARDO (soppresso)" },
    { "code": "I819", "province": "VA", "name": "SOMMA LOMBARDO" },
    { "code": "I820", "province": "NA", "name": "SOMMA VESUVIANA" },
    { "code": "I821", "province": "VR", "name": "SOMMACAMPAGNA" },
    { "code": "I822", "province": "CN", "name": "SOMMARIVA DEL BOSCO" },
    { "code": "I823", "province": "CN", "name": "SOMMARIVA PERNO" },
    { "code": "I824", "province": "CL", "name": "SOMMATINO" },
    { "code": "I825", "province": "PV", "name": "SOMMO" },
    { "code": "I826", "province": "VR", "name": "SONA" },
    { "code": "I827", "province": "CR", "name": "SONCINO" },
    { "code": "I828", "province": "SO", "name": "SONDALO" },
    { "code": "I829", "province": "SO", "name": "SONDRIO" },
    { "code": "I830", "province": "BG", "name": "SONGAVAZZO" },
    { "code": "I831", "province": "BS", "name": "SONICO" },
    { "code": "I832", "province": "RM", "name": "SONNINO (soppresso)" },
    { "code": "I832", "province": "LT", "name": "SONNINO" },
    { "code": "I833", "province": "GO", "name": "SONZIA (soppresso)" },
    { "code": "I833", "province": "UD", "name": "SONZIA (soppresso)" },
    { "code": "I834", "province": "TN", "name": "SOPRAMONTE (soppresso)" },
    { "code": "I835", "province": "NO", "name": "SOPRANA (soppresso)" },
    { "code": "I835", "province": "VC", "name": "SOPRANA (soppresso)" },
    { "code": "I835", "province": "BI", "name": "SOPRANA (soppresso)" },
    { "code": "I836", "province": "BS", "name": "SOPRAPONTE (soppresso)" },
    { "code": "I837", "province": "BS", "name": "SOPRAZOCCO (soppresso)" },
    { "code": "I838", "province": "CE", "name": "SORA (soppresso)" },
    { "code": "I838", "province": "FR", "name": "SORA" },
    { "code": "I839", "province": "TN", "name": "SORAGA (soppresso)" },
    { "code": "I839", "province": "TN", "name": "SORAGA DI FASSA" },
    { "code": "I840", "province": "PR", "name": "SORAGNA" },
    { "code": "I841", "province": "GR", "name": "SORANO" },
    { "code": "I842", "province": "FI", "name": "SORBANO (soppresso)" },
    { "code": "I842", "province": "FO", "name": "SORBANO (soppresso)" },
    { "code": "I844", "province": "CZ", "name": "SORBO SAN BASILE" },
    { "code": "I843", "province": "AV", "name": "SORBO SERPICO" },
    { "code": "I845", "province": "PR", "name": "SORBOLO (soppresso)" },
    { "code": "M411", "province": "PR", "name": "SORBOLO MEZZANI" },
    { "code": "I846", "province": "PS", "name": "SORBOLONGO (soppresso)" },
    { "code": "I847", "province": "NO", "name": "SORDEVOLO (soppresso)" },
    { "code": "I847", "province": "VC", "name": "SORDEVOLO (soppresso)" },
    { "code": "I847", "province": "BI", "name": "SORDEVOLO" },
    { "code": "I848", "province": "MI", "name": "SORDIO (soppresso)" },
    { "code": "I848", "province": "LO", "name": "SORDIO" },
    { "code": "I849", "province": "CR", "name": "SORESINA" },
    { "code": "I850", "province": "VR", "name": "SORGA'" },
    { "code": "I851", "province": "CA", "name": "SORGONO (soppresso)" },
    { "code": "I851", "province": "NU", "name": "SORGONO" },
    { "code": "I852", "province": "GE", "name": "SORI" },
    { "code": "I853", "province": "CZ", "name": "SORIANELLO (soppresso)" },
    { "code": "I853", "province": "VV", "name": "SORIANELLO" },
    { "code": "I854", "province": "CZ", "name": "SORIANO CALABRO (soppresso)" },
    { "code": "I854", "province": "VV", "name": "SORIANO CALABRO" },
    { "code": "I855", "province": "RM", "name": "SORIANO NEL CIMINO (soppresso)" },
    { "code": "I855", "province": "VT", "name": "SORIANO NEL CIMINO" },
    { "code": "I856", "province": "CO", "name": "SORICO" },
    { "code": "I857", "province": "NO", "name": "SORISO" },
    { "code": "I858", "province": "BG", "name": "SORISOLE" },
    { "code": "I859", "province": "AL", "name": "SORLI (soppresso)" },
    { "code": "I860", "province": "CO", "name": "SORMANO" },
    { "code": "I861", "province": "CA", "name": "SORRADILE (soppresso)" },
    { "code": "I861", "province": "OR", "name": "SORRADILE" },
    { "code": "I862", "province": "NA", "name": "SORRENTO" },
    { "code": "I863", "province": "SS", "name": "SORSO" },
    { "code": "I864", "province": "SR", "name": "SORTINO" },
    { "code": "I865", "province": "CR", "name": "SOSPIRO" },
    { "code": "I866", "province": "BL", "name": "SOSPIROLO" },
    { "code": "I867", "province": "VI", "name": "SOSSANO" },
    { "code": "I868", "province": "NO", "name": "SOSTEGNO (soppresso)" },
    { "code": "I868", "province": "VC", "name": "SOSTEGNO (soppresso)" },
    { "code": "I868", "province": "BI", "name": "SOSTEGNO" },
    { "code": "I869", "province": "BG", "name": "SOTTO IL MONTE (soppresso)" },
    { "code": "I869", "province": "BG", "name": "SOTTO IL MONTE GIOVANNI XXIII" },
    { "code": "I870", "province": "NO", "name": "SOVAZZA (soppresso)" },
    { "code": "I871", "province": "TN", "name": "SOVER" },
    { "code": "I872", "province": "CZ", "name": "SOVERATO" },
    { "code": "I873", "province": "BG", "name": "SOVERE" },
    { "code": "I874", "province": "CZ", "name": "SOVERIA MANNELLI" },
    { "code": "I875", "province": "CZ", "name": "SOVERIA SIMERI" },
    { "code": "I876", "province": "BL", "name": "SOVERZENE" },
    { "code": "I877", "province": "SI", "name": "SOVICILLE" },
    { "code": "I878", "province": "MI", "name": "SOVICO (soppresso)" },
    { "code": "I878", "province": "MB", "name": "SOVICO" },
    { "code": "I879", "province": "VI", "name": "SOVIZZO" },
    { "code": "I673", "province": "BL", "name": "SOVRAMONTE" },
    { "code": "I880", "province": "NO", "name": "SOZZAGO" },
    { "code": "E366", "province": "SR", "name": "SPACCAFORNO (soppresso)" },
    { "code": "E366", "province": "RG", "name": "SPACCAFORNO (soppresso)" },
    { "code": "I881", "province": "ME", "name": "SPADAFORA" },
    { "code": "I882", "province": "ME", "name": "SPADAFORA SAN MARTINO (soppresso)" },
    { "code": "I883", "province": "ME", "name": "SPADAFORA SAN PIETRO (soppresso)" },
    { "code": "I884", "province": "CZ", "name": "SPADOLA (soppresso)" },
    { "code": "I884", "province": "VV", "name": "SPADOLA" },
    { "code": "I885", "province": "CE", "name": "SPARANISE" },
    { "code": "I885", "province": "NA", "name": "SPARANISE (soppresso)" },
    { "code": "I886", "province": "TO", "name": "SPARONE" },
    { "code": "I886", "province": "AO", "name": "SPARONE (soppresso)" },
    { "code": "I887", "province": "LE", "name": "SPECCHIA" },
    { "code": "I888", "province": "PG", "name": "SPELLO" },
    { "code": "I889", "province": "TN", "name": "SPERA (soppresso)" },
    { "code": "I891", "province": "CT", "name": "SPERLINGA (soppresso)" },
    { "code": "I891", "province": "EN", "name": "SPERLINGA" },
    { "code": "I892", "province": "CE", "name": "SPERLONGA (soppresso)" },
    { "code": "I892", "province": "RM", "name": "SPERLONGA (soppresso)" },
    { "code": "I892", "province": "LT", "name": "SPERLONGA" },
    { "code": "I893", "province": "AV", "name": "SPERONE" },
    { "code": "I894", "province": "PV", "name": "SPESSA" },
    { "code": "E463", "province": "GE", "name": "SPEZIA (soppresso)" },
    { "code": "E463", "province": "SP", "name": "SPEZIA (soppresso)" },
    { "code": "I895", "province": "CS", "name": "SPEZZANO ALBANESE" },
    { "code": "I896", "province": "CS", "name": "SPEZZANO DELLA SILA" },
    { "code": "I897", "province": "CS", "name": "SPEZZANO GRANDE (soppresso)" },
    { "code": "I898", "province": "CS", "name": "SPEZZANO PICCOLO (soppresso)" },
    { "code": "I899", "province": "TN", "name": "SPIAZZO" },
    { "code": "I900", "province": "TN", "name": "SPIGNES (soppresso)" },
    { "code": "I901", "province": "AL", "name": "SPIGNO MONFERRATO" },
    { "code": "I902", "province": "CE", "name": "SPIGNO SATURNIA (soppresso)" },
    { "code": "I902", "province": "RM", "name": "SPIGNO SATURNIA (soppresso)" },
    { "code": "I902", "province": "LT", "name": "SPIGNO SATURNIA" },
    { "code": "I903", "province": "MO", "name": "SPILAMBERTO" },
    { "code": "I904", "province": "UD", "name": "SPILIMBERGO (soppresso)" },
    { "code": "I904", "province": "PN", "name": "SPILIMBERGO" },
    { "code": "I905", "province": "CZ", "name": "SPILINGA (soppresso)" },
    { "code": "I905", "province": "VV", "name": "SPILINGA" },
    { "code": "I906", "province": "CR", "name": "SPINADESCO" },
    { "code": "I907", "province": "BA", "name": "SPINAZZOLA (soppresso)" },
    { "code": "I907", "province": "BT", "name": "SPINAZZOLA" },
    { "code": "I908", "province": "VE", "name": "SPINEA" },
    { "code": "I909", "province": "CR", "name": "SPINEDA" },
    { "code": "I910", "province": "CB", "name": "SPINETE" },
    { "code": "I911", "province": "AL", "name": "SPINETO (soppresso)" },
    { "code": "I911", "province": "AL", "name": "SPINETO SCRIVIA" },
    { "code": "I912", "province": "AP", "name": "SPINETOLI" },
    { "code": "I900", "province": "TN", "name": "SPINGA (soppresso)" },
    { "code": "I900", "province": "BZ", "name": "SPINGA (soppresso)" },
    { "code": "I913", "province": "BG", "name": "SPINO AL BREMBO (soppresso)" },
    { "code": "I914", "province": "CR", "name": "SPINO D'ADDA" },
    { "code": "I915", "province": "BG", "name": "SPINONE (soppresso)" },
    { "code": "I916", "province": "BG", "name": "SPINONE AL LAGO" },
    { "code": "I916", "province": "BG", "name": "SPINONE DEI CASTELLI (soppresso)" },
    { "code": "I917", "province": "PZ", "name": "SPINOSO" },
    { "code": "I919", "province": "BG", "name": "SPIRANO" },
    { "code": "I920", "province": "NO", "name": "SPOCCIA (soppresso)" },
    { "code": "I921", "province": "PG", "name": "SPOLETO" },
    { "code": "I922", "province": "TE", "name": "SPOLTORE (soppresso)" },
    { "code": "I922", "province": "PE", "name": "SPOLTORE" },
    { "code": "I923", "province": "LE", "name": "SPONGANO" },
    { "code": "I924", "province": "TN", "name": "SPOR (soppresso)" },
    { "code": "I924", "province": "TN", "name": "SPORMAGGIORE" },
    { "code": "I925", "province": "TN", "name": "SPORMINORE" },
    { "code": "I926", "province": "GE", "name": "SPOTORNO (soppresso)" },
    { "code": "I926", "province": "SV", "name": "SPOTORNO" },
    { "code": "I927", "province": "TV", "name": "SPRESIANO" },
    { "code": "I928", "province": "SO", "name": "SPRIANA" },
    { "code": "I929", "province": "CZ", "name": "SQUILLACE" },
    { "code": "I930", "province": "LE", "name": "SQUINZANO" },
    { "code": "I931", "province": "BG", "name": "STABELLO (soppresso)" },
    { "code": "I932", "province": "AN", "name": "STAFFOLO" },
    { "code": "I933", "province": "PV", "name": "STAGHIGLIONE (soppresso)" },
    { "code": "I935", "province": "CR", "name": "STAGNO LOMBARDO" },
    { "code": "I936", "province": "RC", "name": "STAITI" },
    { "code": "I937", "province": "CZ", "name": "STALETTI'" },
    { "code": "I938", "province": "PD", "name": "STANGHELLA" },
    { "code": "I939", "province": "GO", "name": "STARANZANO" },
    { "code": "I939", "province": "TS", "name": "STARANZANO (soppresso)" },
    { "code": "M298", "province": "TA", "name": "STATTE" },
    { "code": "I940", "province": "TN", "name": "STAVA (soppresso)" },
    { "code": "I940", "province": "BZ", "name": "STAVA (soppresso)" },
    { "code": "I940", "province": "TN", "name": "STAVE (soppresso)" },
    { "code": "I941", "province": "AL", "name": "STAZZANO" },
    { "code": "I942", "province": "LU", "name": "STAZZEMA" },
    { "code": "I943", "province": "CO", "name": "STAZZONA" },
    { "code": "I944", "province": "CO", "name": "STAZZONA GERMASINO (soppresso)" },
    { "code": "I945", "province": "CZ", "name": "STEFANACONI (soppresso)" },
    { "code": "I945", "province": "VV", "name": "STEFANACONI" },
    { "code": "I946", "province": "GE", "name": "STELLA (soppresso)" },
    { "code": "I946", "province": "SV", "name": "STELLA" },
    { "code": "G887", "province": "SA", "name": "STELLA CILENTO" },
    { "code": "I947", "province": "GE", "name": "STELLANELLO (soppresso)" },
    { "code": "I947", "province": "SV", "name": "STELLANELLO" },
    { "code": "I948", "province": "TN", "name": "STELVIO (soppresso)" },
    { "code": "I948", "province": "BZ", "name": "STELVIO" },
    { "code": "I949", "province": "TN", "name": "STENICO" },
    { "code": "I950", "province": "LE", "name": "STERNATIA" },
    { "code": "I951", "province": "BG", "name": "STEZZANO" },
    { "code": "I952", "province": "AR", "name": "STIA (soppresso)" },
    { "code": "I953", "province": "RO", "name": "STIENTA" },
    { "code": "I954", "province": "PZ", "name": "STIGLIANO (soppresso)" },
    { "code": "I954", "province": "MT", "name": "STIGLIANO" },
    { "code": "I955", "province": "RC", "name": "STIGNANO" },
    { "code": "I956", "province": "RC", "name": "STILO" },
    { "code": "I958", "province": "TN", "name": "STILVES (soppresso)" },
    { "code": "I958", "province": "BZ", "name": "STILVES (soppresso)" },
    { "code": "I959", "province": "PG", "name": "STIMIGLIANO (soppresso)" },
    { "code": "I959", "province": "RM", "name": "STIMIGLIANO (soppresso)" },
    { "code": "I959", "province": "RI", "name": "STIMIGLIANO" },
    { "code": "M290", "province": "SS", "name": "STINTINO" },
    { "code": "I960", "province": "SA", "name": "STIO" },
    { "code": "I961", "province": "TS", "name": "STORIE (soppresso)" },
    { "code": "I962", "province": "FG", "name": "STORNARA" },
    { "code": "I963", "province": "FG", "name": "STORNARELLA" },
    { "code": "I964", "province": "TN", "name": "STORO" },
    { "code": "I965", "province": "VE", "name": "STRA" },
    { "code": "I967", "province": "TN", "name": "STRADA (soppresso)" },
    { "code": "I968", "province": "PV", "name": "STRADELLA" },
    { "code": "I969", "province": "TO", "name": "STRAMBINELLO" },
    { "code": "I969", "province": "AO", "name": "STRAMBINELLO (soppresso)" },
    { "code": "I970", "province": "TO", "name": "STRAMBINO" },
    { "code": "I970", "province": "AO", "name": "STRAMBINO (soppresso)" },
    { "code": "I971", "province": "AO", "name": "STRAMBINO ROMANO (soppresso)" },
    { "code": "I971", "province": "TO", "name": "STRAMBINO ROMANO (soppresso)" },
    { "code": "I972", "province": "TN", "name": "STRAMENTIZZO (soppresso)" },
    { "code": "I973", "province": "RM", "name": "STRANGOLAGALLI (soppresso)" },
    { "code": "I973", "province": "FR", "name": "STRANGOLAGALLI" },
    { "code": "I974", "province": "UD", "name": "STREGNA" },
    { "code": "I975", "province": "TN", "name": "STREMBO" },
    { "code": "I976", "province": "NO", "name": "STRESA (soppresso)" },
    { "code": "I976", "province": "VB", "name": "STRESA" },
    { "code": "I976", "province": "NO", "name": "STRESA BORROMEO (soppresso)" },
    { "code": "I977", "province": "AL", "name": "STREVI" },
    { "code": "I978", "province": "CE", "name": "STRIANO (soppresso)" },
    { "code": "I978", "province": "NA", "name": "STRIANO" },
    { "code": "I979", "province": "TN", "name": "STRIGNO (soppresso)" },
    { "code": "I980", "province": "NO", "name": "STRONA (soppresso)" },
    { "code": "I980", "province": "VC", "name": "STRONA (soppresso)" },
    { "code": "I980", "province": "BI", "name": "STRONA" },
    { "code": "I981", "province": "PG", "name": "STRONCONE (soppresso)" },
    { "code": "I981", "province": "TR", "name": "STRONCONE" },
    { "code": "I982", "province": "CZ", "name": "STRONGOLI (soppresso)" },
    { "code": "I982", "province": "KR", "name": "STRONGOLI" },
    { "code": "I983", "province": "NO", "name": "STROPINO (soppresso)" },
    { "code": "I984", "province": "NO", "name": "STROPPIANA (soppresso)" },
    { "code": "I984", "province": "VC", "name": "STROPPIANA" },
    { "code": "I985", "province": "CN", "name": "STROPPO" },
    { "code": "I986", "province": "BG", "name": "STROZZA" },
    { "code": "I987", "province": "GE", "name": "STRUPPA (soppresso)" },
    { "code": "I988", "province": "TN", "name": "STUMIAGA (soppresso)" },
    { "code": "I989", "province": "GO", "name": "STURIA (soppresso)" },
    { "code": "I989", "province": "UD", "name": "STURIA (soppresso)" },
    { "code": "I989", "province": "UD", "name": "STURIA DELLE FUSINE (soppresso)" },
    { "code": "I989", "province": "GO", "name": "STURIA DELLE FUSINE (soppresso)" },
    { "code": "I990", "province": "AV", "name": "STURNO" },
    { "code": "B014", "province": "PV", "name": "SUARDI" },
    { "code": "I991", "province": "AR", "name": "SUBBIANO" },
    { "code": "I992", "province": "RM", "name": "SUBIACO" },
    { "code": "I993", "province": "CE", "name": "SUCCIVO" },
    { "code": "I993", "province": "NA", "name": "SUCCIVO (soppresso)" },
    { "code": "I994", "province": "CO", "name": "SUEGLIO (soppresso)" },
    { "code": "I994", "province": "LC", "name": "SUEGLIO" },
    { "code": "I995", "province": "CA", "name": "SUELLI (soppresso)" },
    { "code": "I995", "province": "SU", "name": "SUELLI" },
    { "code": "I996", "province": "CO", "name": "SUELLO (soppresso)" },
    { "code": "I996", "province": "LC", "name": "SUELLO" },
    { "code": "I997", "province": "BG", "name": "SUISIO" },
    { "code": "I998", "province": "MI", "name": "SULBIATE (soppresso)" },
    { "code": "I998", "province": "MB", "name": "SULBIATE" },
    { "code": "I804", "province": "AQ", "name": "SULMONA" },
    { "code": "L002", "province": "BS", "name": "SULZANO" },
    { "code": "L003", "province": "MI", "name": "SUMIRAGO (soppresso)" },
    { "code": "L003", "province": "VA", "name": "SUMIRAGO" },
    { "code": "L004", "province": "AV", "name": "SUMMONTE" },
    { "code": "L005", "province": "NO", "name": "SUNA (soppresso)" },
    { "code": "L006", "province": "CA", "name": "SUNI (soppresso)" },
    { "code": "L006", "province": "NU", "name": "SUNI (soppresso)" },
    { "code": "L006", "province": "OR", "name": "SUNI" },
    { "code": "L007", "province": "NO", "name": "SUNO" },
    { "code": "L008", "province": "LE", "name": "SUPERSANO" },
    { "code": "L009", "province": "RM", "name": "SUPINO (soppresso)" },
    { "code": "L009", "province": "FR", "name": "SUPINO" },
    { "code": "L010", "province": "LE", "name": "SURANO" },
    { "code": "L011", "province": "LE", "name": "SURBO" },
    { "code": "L013", "province": "TO", "name": "SUSA" },
    { "code": "L012", "province": "TN", "name": "SUSA' (soppresso)" },
    { "code": "L014", "province": "TV", "name": "SUSEGANA" },
    { "code": "L553", "province": "PL", "name": "SUSGNEVIZZA (soppresso)" },
    { "code": "L015", "province": "MN", "name": "SUSTINENTE" },
    { "code": "L016", "province": "CL", "name": "SUTERA" },
    { "code": "L017", "province": "RM", "name": "SUTRI (soppresso)" },
    { "code": "L017", "province": "VT", "name": "SUTRI" },
    { "code": "L018", "province": "UD", "name": "SUTRIO" },
    { "code": "L019", "province": "PI", "name": "SUVERETO (soppresso)" },
    { "code": "L019", "province": "LI", "name": "SUVERETO" },
    { "code": "L020", "province": "MN", "name": "SUZZARA" },
    { "code": "L021", "province": "TN", "name": "TABLA' (soppresso)" },
    { "code": "L021", "province": "BZ", "name": "TABLA' (soppresso)" },
    { "code": "L022", "province": "CO", "name": "TACENO (soppresso)" },
    { "code": "L022", "province": "LC", "name": "TACENO" },
    { "code": "L023", "province": "CA", "name": "TADASUNI (soppresso)" },
    { "code": "L023", "province": "OR", "name": "TADASUNI" },
    { "code": "L024", "province": "IM", "name": "TAGGIA" },
    { "code": "L025", "province": "AQ", "name": "TAGLIACOZZO" },
    { "code": "L026", "province": "RO", "name": "TAGLIO DI PO" },
    { "code": "G926", "province": "RO", "name": "TAGLIO DI PORTO VIRO (soppresso)" },
    { "code": "L027", "province": "AL", "name": "TAGLIOLO (soppresso)" },
    { "code": "L028", "province": "AL", "name": "TAGLIOLO BELFORTE (soppresso)" },
    { "code": "L027", "province": "AL", "name": "TAGLIOLO MONFERRATO" },
    { "code": "L029", "province": "BG", "name": "TAGLIUNO (soppresso)" },
    { "code": "L030", "province": "BL", "name": "TAIBON (soppresso)" },
    { "code": "L030", "province": "BL", "name": "TAIBON AGORDINO" },
    { "code": "L032", "province": "CO", "name": "TAINO (soppresso)" },
    { "code": "L032", "province": "VA", "name": "TAINO" },
    { "code": "L033", "province": "TN", "name": "TAIO (soppresso)" },
    { "code": "G736", "province": "UD", "name": "TAIPANA" },
    { "code": "L034", "province": "PS", "name": "TALAMELLO (soppresso)" },
    { "code": "L034", "province": "PU", "name": "TALAMELLO (soppresso)" },
    { "code": "L034", "province": "RN", "name": "TALAMELLO" },
    { "code": "L035", "province": "SO", "name": "TALAMONA" },
    { "code": "L036", "province": "CA", "name": "TALANA (soppresso)" },
    { "code": "L036", "province": "NU", "name": "TALANA" },
    { "code": "L036", "province": "OG", "name": "TALANA (soppresso)" },
    { "code": "L037", "province": "BG", "name": "TALEGGIO" },
    { "code": "L038", "province": "AR", "name": "TALLA" },
    { "code": "L039", "province": "UD", "name": "TALMASSONS" },
    { "code": "L040", "province": "BL", "name": "TAMBRE" },
    { "code": "L041", "province": "TN", "name": "TANAS (soppresso)" },
    { "code": "L041", "province": "BZ", "name": "TANAS (soppresso)" },
    { "code": "L042", "province": "ME", "name": "TAORMINA" },
    { "code": "L043", "province": "NO", "name": "TAPIGLIANO (soppresso)" },
    { "code": "L044", "province": "UD", "name": "TAPOGLIANO (soppresso)" },
    { "code": "L045", "province": "NO", "name": "TAPPIA (soppresso)" },
    { "code": "L046", "province": "PG", "name": "TARANO (soppresso)" },
    { "code": "L046", "province": "RM", "name": "TARANO (soppresso)" },
    { "code": "L046", "province": "RI", "name": "TARANO" },
    { "code": "L047", "province": "CH", "name": "TARANTA PELIGNA" },
    { "code": "L048", "province": "CN", "name": "TARANTASCA" },
    { "code": "L049", "province": "LE", "name": "TARANTO (soppresso)" },
    { "code": "L049", "province": "TA", "name": "TARANTO" },
    { "code": "L050", "province": "UD", "name": "TARCENTO" },
    { "code": "L051", "province": "TN", "name": "TARCES (soppresso)" },
    { "code": "L051", "province": "BZ", "name": "TARCES (soppresso)" },
    { "code": "L052", "province": "UD", "name": "TARCETTA (soppresso)" },
    { "code": "L053", "province": "UD", "name": "TARNOVA DELLA SELVA (soppresso)" },
    { "code": "L053", "province": "GO", "name": "TARNOVA DELLA SELVA (soppresso)" },
    { "code": "D024", "province": "RM", "name": "TARQUINIA (soppresso)" },
    { "code": "D024", "province": "VT", "name": "TARQUINIA" },
    { "code": "L054", "province": "TN", "name": "TARRES (soppresso)" },
    { "code": "L054", "province": "BZ", "name": "TARRES (soppresso)" },
    { "code": "L051", "province": "TN", "name": "TARRES DI SOPRA (soppresso)" },
    { "code": "L054", "province": "TN", "name": "TARRES DI SOTTO (soppresso)" },
    { "code": "L055", "province": "CS", "name": "TARSIA" },
    { "code": "L056", "province": "SO", "name": "TARTANO" },
    { "code": "L057", "province": "UD", "name": "TARVISIO" },
    { "code": "L058", "province": "TV", "name": "TARZO" },
    { "code": "L059", "province": "AL", "name": "TASSAROLO" },
    { "code": "L060", "province": "TN", "name": "TASSULLO (soppresso)" },
    { "code": "L061", "province": "AV", "name": "TAURANO" },
    { "code": "L062", "province": "AV", "name": "TAURASI" },
    { "code": "L063", "province": "RC", "name": "TAURIANOVA" },
    { "code": "L064", "province": "LE", "name": "TAURISANO" },
    { "code": "L065", "province": "UD", "name": "TAVAGNACCO" },
    { "code": "L066", "province": "TO", "name": "TAVAGNASCO" },
    { "code": "L066", "province": "AO", "name": "TAVAGNASCO (soppresso)" },
    { "code": "L067", "province": "FI", "name": "TAVARNELLE (soppresso)" },
    { "code": "L067", "province": "FI", "name": "TAVARNELLE VAL DI PESA (soppresso)" },
    { "code": "F260", "province": "MI", "name": "TAVAZZANO CON VILLAVESCO (soppresso)" },
    { "code": "F260", "province": "LO", "name": "TAVAZZANO CON VILLAVESCO" },
    { "code": "L069", "province": "CB", "name": "TAVENNA" },
    { "code": "L070", "province": "CZ", "name": "TAVERNA" },
    { "code": "L071", "province": "CO", "name": "TAVERNERIO" },
    { "code": "G033", "province": "TO", "name": "TAVERNETTE (soppresso)" },
    { "code": "L073", "province": "BG", "name": "TAVERNOLA BERGAMASCA" },
    { "code": "L072", "province": "AV", "name": "TAVERNOLA SAN FELICE (soppresso)" },
    { "code": "C698", "province": "BS", "name": "TAVERNOLE CIMMO (soppresso)" },
    { "code": "C698", "province": "BS", "name": "TAVERNOLE SUL MELLA" },
    { "code": "L074", "province": "LE", "name": "TAVIANO" },
    { "code": "L075", "province": "NO", "name": "TAVIGLIANO (soppresso)" },
    { "code": "L075", "province": "VC", "name": "TAVIGLIANO (soppresso)" },
    { "code": "L075", "province": "BI", "name": "TAVIGLIANO" },
    { "code": "L076", "province": "TN", "name": "TAVODO (soppresso)" },
    { "code": "L077", "province": "IM", "name": "TAVOLE (soppresso)" },
    { "code": "L078", "province": "PS", "name": "TAVOLETO (soppresso)" },
    { "code": "L078", "province": "PU", "name": "TAVOLETO" },
    { "code": "L079", "province": "TN", "name": "TAVON (soppresso)" },
    { "code": "L080", "province": "CO", "name": "TAVORDO (soppresso)" },
    { "code": "L081", "province": "PS", "name": "TAVULLIA (soppresso)" },
    { "code": "L081", "province": "PU", "name": "TAVULLIA" },
    { "code": "L082", "province": "PZ", "name": "TEANA" },
    { "code": "L083", "province": "CE", "name": "TEANO" },
    { "code": "L083", "province": "NA", "name": "TEANO (soppresso)" },
    { "code": "D292", "province": "SA", "name": "TEGGIANO" },
    { "code": "L084", "province": "SO", "name": "TEGLIO" },
    { "code": "L085", "province": "VE", "name": "TEGLIO VENETO" },
    { "code": "L086", "province": "BN", "name": "TELESE (soppresso)" },
    { "code": "L086", "province": "BN", "name": "TELESE TERME" },
    { "code": "L087", "province": "BG", "name": "TELGATE" },
    { "code": "L088", "province": "SS", "name": "TELTI" },
    { "code": "L088", "province": "OT", "name": "TELTI (soppresso)" },
    { "code": "L089", "province": "TN", "name": "TELVE" },
    { "code": "L090", "province": "TN", "name": "TELVE DI SOPRA" },
    { "code": "L091", "province": "TN", "name": "TELVES (soppresso)" },
    { "code": "L091", "province": "BZ", "name": "TELVES (soppresso)" },
    { "code": "L092", "province": "UD", "name": "TEMENIZZA (soppresso)" },
    { "code": "L092", "province": "GO", "name": "TEMENIZZA (soppresso)" },
    { "code": "L092", "province": "GO", "name": "TEMNIZZA (soppresso)" },
    { "code": "L092", "province": "UD", "name": "TEMNIZZA (soppresso)" },
    { "code": "L093", "province": "SS", "name": "TEMPIO PAUSANIA" },
    { "code": "L093", "province": "OT", "name": "TEMPIO PAUSANIA (soppresso)" },
    { "code": "L094", "province": "BS", "name": "TEMU'" },
    { "code": "L095", "province": "CN", "name": "TENDA (soppresso)" },
    { "code": "L096", "province": "TN", "name": "TENNA" },
    { "code": "L097", "province": "TN", "name": "TENNO" },
    { "code": "L098", "province": "TN", "name": "TEODONA (soppresso)" },
    { "code": "L098", "province": "TN", "name": "TEODONE (soppresso)" },
    { "code": "L098", "province": "BZ", "name": "TEODONE (soppresso)" },
    { "code": "L099", "province": "FO", "name": "TEODORANO (soppresso)" },
    { "code": "L100", "province": "PD", "name": "TEOLO" },
    { "code": "L101", "province": "UD", "name": "TEOR (soppresso)" },
    { "code": "L102", "province": "AV", "name": "TEORA" },
    { "code": "L103", "province": "TE", "name": "TERAMO" },
    { "code": "L104", "province": "NO", "name": "TERDOBBIATE" },
    { "code": "L105", "province": "CE", "name": "TERELLE (soppresso)" },
    { "code": "L105", "province": "FR", "name": "TERELLE" },
    { "code": "L106", "province": "TN", "name": "TERENTO (soppresso)" },
    { "code": "L106", "province": "BZ", "name": "TERENTO" },
    { "code": "E548", "province": "PR", "name": "TERENZO" },
    { "code": "M282", "province": "SS", "name": "TERGU" },
    { "code": "L107", "province": "TN", "name": "TERLAGO (soppresso)" },
    { "code": "L108", "province": "TN", "name": "TERLANO (soppresso)" },
    { "code": "L108", "province": "BZ", "name": "TERLANO" },
    { "code": "L109", "province": "BA", "name": "TERLIZZI" },
    { "code": "M210", "province": "ME", "name": "TERME VIGLIATORE" },
    { "code": "L110", "province": "TN", "name": "TERMENAGO (soppresso)" },
    { "code": "L111", "province": "TN", "name": "TERMENO (soppresso)" },
    { "code": "L111", "province": "BZ", "name": "TERMENO (soppresso)" },
    { "code": "L111", "province": "BZ", "name": "TERMENO SULLA STRADA DEL VINO" },
    { "code": "L112", "province": "PA", "name": "TERMINI IMERESE" },
    { "code": "L113", "province": "CB", "name": "TERMOLI" },
    { "code": "L114", "province": "TN", "name": "TERMON (soppresso)" },
    { "code": "L115", "province": "CO", "name": "TERNATE (soppresso)" },
    { "code": "L115", "province": "VA", "name": "TERNATE" },
    { "code": "L116", "province": "NO", "name": "TERNENGO (soppresso)" },
    { "code": "L116", "province": "VC", "name": "TERNENGO (soppresso)" },
    { "code": "L116", "province": "BI", "name": "TERNENGO" },
    { "code": "L117", "province": "PG", "name": "TERNI (soppresso)" },
    { "code": "L117", "province": "TR", "name": "TERNI" },
    { "code": "L118", "province": "BG", "name": "TERNO D'ISOLA" },
    { "code": "L053", "province": "GO", "name": "TERNOVA (soppresso)" },
    { "code": "L053", "province": "UD", "name": "TERNOVA (soppresso)" },
    { "code": "L119", "province": "GO", "name": "TERNOVA D'ISONZO (soppresso)" },
    { "code": "L119", "province": "UD", "name": "TERNOVA D'ISONZO (soppresso)" },
    { "code": "L128", "province": "FU", "name": "TERNOVO (soppresso)" },
    { "code": "L128", "province": "PL", "name": "TERNOVO (soppresso)" },
    { "code": "C339", "province": "FI", "name": "TERRA DEL SOLE E CASTROCARO (soppresso)" },
    { "code": "C339", "province": "FO", "name": "TERRA DEL SOLE E CASTROCARO (soppresso)" },
    { "code": "L120", "province": "RM", "name": "TERRACINA (soppresso)" },
    { "code": "L120", "province": "LT", "name": "TERRACINA" },
    { "code": "L121", "province": "TN", "name": "TERRAGNOLO" },
    { "code": "L122", "province": "CA", "name": "TERRALBA (soppresso)" },
    { "code": "L122", "province": "OR", "name": "TERRALBA" },
    { "code": "L124", "province": "CS", "name": "TERRANOVA DA SIBARI" },
    { "code": "L125", "province": "MI", "name": "TERRANOVA DEI PASSERINI (soppresso)" },
    { "code": "L125", "province": "LO", "name": "TERRANOVA DEI PASSERINI" },
    { "code": "L126", "province": "PZ", "name": "TERRANOVA DI POLLINO" },
    { "code": "D960", "province": "CL", "name": "TERRANOVA DI SICILIA (soppresso)" },
    { "code": "G015", "province": "SS", "name": "TERRANOVA PAUSANIA (soppresso)" },
    { "code": "L127", "province": "RC", "name": "TERRANOVA SAPPO MINULIO" },
    { "code": "L123", "province": "AR", "name": "TERRANUOVA BRACCIOLINI" },
    { "code": "L130", "province": "PV", "name": "TERRASA (soppresso)" },
    { "code": "L131", "province": "PA", "name": "TERRASINI" },
    { "code": "L132", "province": "PD", "name": "TERRASSA PADOVANA" },
    { "code": "L133", "province": "CS", "name": "TERRATI (soppresso)" },
    { "code": "L134", "province": "CS", "name": "TERRAVECCHIA" },
    { "code": "L135", "province": "MI", "name": "TERRAZZANO (soppresso)" },
    { "code": "L136", "province": "VR", "name": "TERRAZZO" },
    { "code": "M407", "province": "TN", "name": "TERRE D'ADIGE" },
    { "code": "M381", "province": "FE", "name": "TERRE DEL RENO" },
    { "code": "M379", "province": "PU", "name": "TERRE ROVERESCHE" },
    { "code": "L137", "province": "TN", "name": "TERRES (soppresso)" },
    { "code": "L138", "province": "PI", "name": "TERRICCIOLA" },
    { "code": "L139", "province": "AL", "name": "TERRUGGIA" },
    { "code": "L140", "province": "CA", "name": "TERTENIA (soppresso)" },
    { "code": "L140", "province": "NU", "name": "TERTENIA" },
    { "code": "L140", "province": "OG", "name": "TERTENIA (soppresso)" },
    { "code": "L141", "province": "BS", "name": "TERZANO (soppresso)" },
    { "code": "L142", "province": "NA", "name": "TERZIGNO" },
    { "code": "L143", "province": "AL", "name": "TERZO" },
    { "code": "L144", "province": "UD", "name": "TERZO D'AQUILEIA" },
    { "code": "L145", "province": "TN", "name": "TERZOLAS" },
    { "code": "L146", "province": "IM", "name": "TERZORIO" },
    { "code": "L147", "province": "TN", "name": "TESERO" },
    { "code": "L148", "province": "TN", "name": "TESIDO (soppresso)" },
    { "code": "L148", "province": "BZ", "name": "TESIDO (soppresso)" },
    { "code": "L149", "province": "TN", "name": "TESIMO (soppresso)" },
    { "code": "L149", "province": "BZ", "name": "TESIMO" },
    { "code": "L150", "province": "RM", "name": "TESSENNANO (soppresso)" },
    { "code": "L150", "province": "VT", "name": "TESSENNANO" },
    { "code": "L152", "province": "GE", "name": "TESTICO (soppresso)" },
    { "code": "L152", "province": "SV", "name": "TESTICO" },
    { "code": "L153", "province": "CA", "name": "TETI (soppresso)" },
    { "code": "L153", "province": "NU", "name": "TETI" },
    { "code": "L154", "province": "CA", "name": "TEULADA (soppresso)" },
    { "code": "L154", "province": "SU", "name": "TEULADA" },
    { "code": "L155", "province": "CE", "name": "TEVEROLA" },
    { "code": "L155", "province": "NA", "name": "TEVEROLA (soppresso)" },
    { "code": "L156", "province": "VI", "name": "TEZZE (soppresso)" },
    { "code": "L156", "province": "VI", "name": "TEZZE SUL BRENTA" },
    { "code": "L157", "province": "VI", "name": "THIENE" },
    { "code": "L158", "province": "SS", "name": "THIESI" },
    { "code": "L159", "province": "TO", "name": "THURES (soppresso)" },
    { "code": "L160", "province": "CA", "name": "TIANA (soppresso)" },
    { "code": "L160", "province": "NU", "name": "TIANA" },
    { "code": "L161", "province": "TN", "name": "TIARNO (soppresso)" },
    { "code": "L162", "province": "TN", "name": "TIARNO DI SOPRA (soppresso)" },
    { "code": "L163", "province": "TN", "name": "TIARNO DI SOTTO (soppresso)" },
    { "code": "L164", "province": "CR", "name": "TICENGO" },
    { "code": "L165", "province": "AL", "name": "TICINETO" },
    { "code": "L166", "province": "LE", "name": "TIGGIANO" },
    { "code": "L167", "province": "GE", "name": "TIGLIETO" },
    { "code": "L167", "province": "SV", "name": "TIGLIETO (soppresso)" },
    { "code": "L168", "province": "AL", "name": "TIGLIOLE (soppresso)" },
    { "code": "L168", "province": "AT", "name": "TIGLIOLE" },
    { "code": "L169", "province": "BS", "name": "TIGNALE" },
    { "code": "L170", "province": "BS", "name": "TIMOLINE (soppresso)" },
    { "code": "L171", "province": "TO", "name": "TINA (soppresso)" },
    { "code": "L171", "province": "AO", "name": "TINA (soppresso)" },
    { "code": "L172", "province": "CA", "name": "TINNURA (soppresso)" },
    { "code": "L172", "province": "NU", "name": "TINNURA (soppresso)" },
    { "code": "L172", "province": "OR", "name": "TINNURA" },
    { "code": "L173", "province": "AQ", "name": "TIONE (soppresso)" },
    { "code": "L174", "province": "TN", "name": "TIONE (soppresso)" },
    { "code": "L173", "province": "AQ", "name": "TIONE DEGLI ABRUZZI" },
    { "code": "L174", "province": "TN", "name": "TIONE DI TRENTO" },
    { "code": "L175", "province": "SO", "name": "TIRANO" },
    { "code": "L176", "province": "TN", "name": "TIRES (soppresso)" },
    { "code": "L176", "province": "BZ", "name": "TIRES" },
    { "code": "L177", "province": "CZ", "name": "TIRIOLO" },
    { "code": "L178", "province": "TN", "name": "TIROLO (soppresso)" },
    { "code": "L178", "province": "BZ", "name": "TIROLO" },
    { "code": "L179", "province": "TN", "name": "TISA (soppresso)" },
    { "code": "L179", "province": "TN", "name": "TISO (soppresso)" },
    { "code": "L179", "province": "BZ", "name": "TISO (soppresso)" },
    { "code": "L180", "province": "SS", "name": "TISSI" },
    { "code": "L181", "province": "PZ", "name": "TITO" },
    { "code": "L182", "province": "RM", "name": "TIVOLI" },
    { "code": "H109", "province": "FI", "name": "TIZZANA (soppresso)" },
    { "code": "H109", "province": "PT", "name": "TIZZANA (soppresso)" },
    { "code": "L183", "province": "PR", "name": "TIZZANO VAL PARMA" },
    { "code": "L184", "province": "RE", "name": "TOANO" },
    { "code": "L185", "province": "BN", "name": "TOCCO CAUDIO" },
    { "code": "L186", "province": "CH", "name": "TOCCO DA CASAURIA (soppresso)" },
    { "code": "L186", "province": "PE", "name": "TOCCO DA CASAURIA" },
    { "code": "L187", "province": "NO", "name": "TOCENO (soppresso)" },
    { "code": "L187", "province": "VB", "name": "TOCENO" },
    { "code": "L188", "province": "PG", "name": "TODI" },
    { "code": "L189", "province": "PG", "name": "TOFFIA (soppresso)" },
    { "code": "L189", "province": "RM", "name": "TOFFIA (soppresso)" },
    { "code": "L189", "province": "RI", "name": "TOFFIA" },
    { "code": "L190", "province": "GE", "name": "TOIRANO (soppresso)" },
    { "code": "L190", "province": "SV", "name": "TOIRANO" },
    { "code": "L191", "province": "MC", "name": "TOLENTINO" },
    { "code": "L192", "province": "RM", "name": "TOLFA" },
    { "code": "L193", "province": "NO", "name": "TOLLEGNO (soppresso)" },
    { "code": "L193", "province": "VC", "name": "TOLLEGNO (soppresso)" },
    { "code": "L193", "province": "BI", "name": "TOLLEGNO" },
    { "code": "L194", "province": "CH", "name": "TOLLO" },
    { "code": "L195", "province": "UD", "name": "TOLMEZZO" },
    { "code": "L196", "province": "GO", "name": "TOLMINO (soppresso)" },
    { "code": "L196", "province": "UD", "name": "TOLMINO (soppresso)" },
    { "code": "L197", "province": "PZ", "name": "TOLVE" },
    { "code": "L198", "province": "TS", "name": "TOMADIO (soppresso)" },
    { "code": "L198", "province": "TS", "name": "TOMAI (soppresso)" },
    { "code": "L081", "province": "PS", "name": "TOMBA DI PESARO (soppresso)" },
    { "code": "C071", "province": "AN", "name": "TOMBA DI SENIGALLIA (soppresso)" },
    { "code": "L199", "province": "PD", "name": "TOMBOLO" },
    { "code": "L200", "province": "TN", "name": "TON" },
    { "code": "L201", "province": "TN", "name": "TONADICO (soppresso)" },
    { "code": "L202", "province": "CA", "name": "TONARA (soppresso)" },
    { "code": "L202", "province": "NU", "name": "TONARA" },
    { "code": "L203", "province": "AL", "name": "TONCO (soppresso)" },
    { "code": "L203", "province": "AT", "name": "TONCO" },
    { "code": "L204", "province": "AL", "name": "TONENGO (soppresso)" },
    { "code": "L204", "province": "AT", "name": "TONENGO" },
    { "code": "D717", "province": "VI", "name": "TONEZZA (soppresso)" },
    { "code": "D717", "province": "VI", "name": "TONEZZA DEL CIMONE" },
    { "code": "L205", "province": "CE", "name": "TORA E PICCILLI" },
    { "code": "L205", "province": "NA", "name": "TORA E PICCILLI (soppresso)" },
    { "code": "L206", "province": "CS", "name": "TORANO CASTELLO" },
    { "code": "L207", "province": "TE", "name": "TORANO NUOVO" },
    { "code": "L208", "province": "CO", "name": "TORBA (soppresso)" },
    { "code": "L208", "province": "VA", "name": "TORBA (soppresso)" },
    { "code": "L209", "province": "BS", "name": "TORBIATO (soppresso)" },
    { "code": "L210", "province": "BS", "name": "TORBOLE CASAGLIA" },
    { "code": "L211", "province": "TN", "name": "TORCEGNO" },
    { "code": "L212", "province": "SA", "name": "TORCHIARA" },
    { "code": "L213", "province": "LE", "name": "TORCHIAROLO (soppresso)" },
    { "code": "L213", "province": "BR", "name": "TORCHIAROLO" },
    { "code": "L214", "province": "AV", "name": "TORELLA DEI LOMBARDI" },
    { "code": "L215", "province": "CB", "name": "TORELLA DEL SANNIO" },
    { "code": "L216", "province": "PG", "name": "TORGIANO" },
    { "code": "L217", "province": "TO", "name": "TORGNON (soppresso)" },
    { "code": "L217", "province": "AO", "name": "TORGNON" },
    { "code": "L217", "province": "AO", "name": "TORGNONE (soppresso)" },
    { "code": "L219", "province": "TO", "name": "TORINO" },
    { "code": "L218", "province": "CH", "name": "TORINO DI SANGRO" },
    { "code": "L220", "province": "BA", "name": "TORITTO" },
    { "code": "L221", "province": "CR", "name": "TORLINO (soppresso)" },
    { "code": "L221", "province": "CR", "name": "TORLINO VIMERCATI" },
    { "code": "L223", "province": "NO", "name": "TORNACO" },
    { "code": "L224", "province": "CH", "name": "TORNARECCIO" },
    { "code": "L225", "province": "CR", "name": "TORNATA" },
    { "code": "L227", "province": "AQ", "name": "TORNIMPARTE" },
    { "code": "L228", "province": "CO", "name": "TORNO" },
    { "code": "L229", "province": "PR", "name": "TORNOLO" },
    { "code": "L230", "province": "CB", "name": "TORO" },
    { "code": "L231", "province": "SS", "name": "TORPE' (soppresso)" },
    { "code": "L231", "province": "NU", "name": "TORPE'" },
    { "code": "L232", "province": "TN", "name": "TORRA (soppresso)" },
    { "code": "L233", "province": "SA", "name": "TORRACA" },
    { "code": "L234", "province": "PV", "name": "TORRADELLO (soppresso)" },
    { "code": "L235", "province": "SS", "name": "TORRALBA" },
    { "code": "L236", "province": "IM", "name": "TORRAZZA (soppresso)" },
    { "code": "L237", "province": "PV", "name": "TORRAZZA COSTE" },
    { "code": "L238", "province": "TO", "name": "TORRAZZA PIEMONTE" },
    { "code": "L239", "province": "NO", "name": "TORRAZZO (soppresso)" },
    { "code": "L239", "province": "VC", "name": "TORRAZZO (soppresso)" },
    { "code": "L239", "province": "BI", "name": "TORRAZZO" },
    { "code": "L245", "province": "NA", "name": "TORRE ANNUNZIATA" },
    { "code": "L247", "province": "TO", "name": "TORRE BAIRO (soppresso)" },
    { "code": "L247", "province": "AO", "name": "TORRE BAIRO (soppresso)" },
    { "code": "L249", "province": "PV", "name": "TORRE BERETTI (soppresso)" },
    { "code": "L250", "province": "PV", "name": "TORRE BERETTI E CASTELLARO" },
    { "code": "L251", "province": "BG", "name": "TORRE BOLDONE" },
    { "code": "L252", "province": "CN", "name": "TORRE BORMIDA" },
    { "code": "L243", "province": "RM", "name": "TORRE CAJETANI (soppresso)" },
    { "code": "L243", "province": "FR", "name": "TORRE CAJETANI" },
    { "code": "L247", "province": "TO", "name": "TORRE CANAVESE" },
    { "code": "L256", "province": "PV", "name": "TORRE D'ARESE" },
    { "code": "L257", "province": "BG", "name": "TORRE DE' BUSI" },
    { "code": "L257", "province": "LC", "name": "TORRE DE' BUSI (soppresso)" },
    { "code": "L262", "province": "PV", "name": "TORRE DE' NEGRI" },
    { "code": "L263", "province": "TE", "name": "TORRE DE' PASSERI (soppresso)" },
    { "code": "L263", "province": "PE", "name": "TORRE DE' PASSERI" },
    { "code": "L258", "province": "CR", "name": "TORRE DE' PICENARDI" },
    { "code": "L264", "province": "AL", "name": "TORRE DE' RATTI (soppresso)" },
    { "code": "L265", "province": "BG", "name": "TORRE DE' ROVERI" },
    { "code": "L259", "province": "NA", "name": "TORRE DEL GRECO" },
    { "code": "L260", "province": "PV", "name": "TORRE DEL MANGANO (soppresso)" },
    { "code": "L261", "province": "PV", "name": "TORRE DEL MONTE (soppresso)" },
    { "code": "L267", "province": "VE", "name": "TORRE DI MOSTO" },
    { "code": "L240", "province": "CZ", "name": "TORRE DI RUGGIERO" },
    { "code": "L244", "province": "SO", "name": "TORRE DI SANTA MARIA" },
    { "code": "L269", "province": "PV", "name": "TORRE D'ISOLA" },
    { "code": "L272", "province": "AV", "name": "TORRE LE NOCELLE" },
    { "code": "L241", "province": "CN", "name": "TORRE MONDOVI'" },
    { "code": "L274", "province": "SA", "name": "TORRE ORSAIA" },
    { "code": "L275", "province": "PG", "name": "TORRE ORSINA (soppresso)" },
    { "code": "L275", "province": "TR", "name": "TORRE ORSINA (soppresso)" },
    { "code": "L276", "province": "BG", "name": "TORRE PALLAVICINA" },
    { "code": "L277", "province": "TO", "name": "TORRE PELLICE" },
    { "code": "L278", "province": "CN", "name": "TORRE SAN GIORGIO" },
    { "code": "L279", "province": "AP", "name": "TORRE SAN PATRIZIO (soppresso)" },
    { "code": "L279", "province": "FM", "name": "TORRE SAN PATRIZIO" },
    { "code": "L280", "province": "LE", "name": "TORRE SANTA SUSANNA (soppresso)" },
    { "code": "L280", "province": "BR", "name": "TORRE SANTA SUSANNA" },
    { "code": "L283", "province": "CN", "name": "TORRE UZZONE (soppresso)" },
    { "code": "L246", "province": "UD", "name": "TORREANO" },
    { "code": "L248", "province": "VI", "name": "TORREBELVICINO" },
    { "code": "L253", "province": "CH", "name": "TORREBRUNA" },
    { "code": "L254", "province": "BN", "name": "TORRECUSO" },
    { "code": "L270", "province": "PD", "name": "TORREGLIA" },
    { "code": "L271", "province": "ME", "name": "TORREGROTTA" },
    { "code": "L273", "province": "FG", "name": "TORREMAGGIORE" },
    { "code": "M286", "province": "ME", "name": "TORRENOVA" },
    { "code": "L128", "province": "PL", "name": "TORRENOVA DI BISTERZA (soppresso)" },
    { "code": "L128", "province": "FU", "name": "TORRENOVA DI BISTERZA (soppresso)" },
    { "code": "L281", "province": "CN", "name": "TORRESINA" },
    { "code": "L282", "province": "PA", "name": "TORRETTA" },
    { "code": "L285", "province": "PV", "name": "TORREVECCHIA PIA" },
    { "code": "L284", "province": "CH", "name": "TORREVECCHIA TEATINA" },
    { "code": "L287", "province": "VR", "name": "TORRI DEL BENACO" },
    { "code": "L297", "province": "VI", "name": "TORRI DI QUARTESOLO" },
    { "code": "L286", "province": "PG", "name": "TORRI IN SABINA (soppresso)" },
    { "code": "L286", "province": "RM", "name": "TORRI IN SABINA (soppresso)" },
    { "code": "L286", "province": "RI", "name": "TORRI IN SABINA" },
    { "code": "L288", "province": "IM", "name": "TORRIA (soppresso)" },
    { "code": "I550", "province": "FO", "name": "TORRIANA (soppresso)" },
    { "code": "I550", "province": "RN", "name": "TORRIANA (soppresso)" },
    { "code": "L289", "province": "PV", "name": "TORRIANO (soppresso)" },
    { "code": "L290", "province": "RM", "name": "TORRICE (soppresso)" },
    { "code": "L290", "province": "FR", "name": "TORRICE" },
    { "code": "L294", "province": "TA", "name": "TORRICELLA" },
    { "code": "L296", "province": "CR", "name": "TORRICELLA DEL PIZZO" },
    { "code": "L293", "province": "PG", "name": "TORRICELLA IN SABINA (soppresso)" },
    { "code": "L293", "province": "RM", "name": "TORRICELLA IN SABINA (soppresso)" },
    { "code": "L293", "province": "RI", "name": "TORRICELLA IN SABINA" },
    { "code": "L291", "province": "CH", "name": "TORRICELLA PELIGNA" },
    { "code": "L295", "province": "TE", "name": "TORRICELLA SICURA" },
    { "code": "L292", "province": "PV", "name": "TORRICELLA VERZATE" },
    { "code": "L298", "province": "GE", "name": "TORRIGLIA" },
    { "code": "L299", "province": "PR", "name": "TORRILE" },
    { "code": "L301", "province": "AV", "name": "TORRIONI" },
    { "code": "L303", "province": "SI", "name": "TORRITA (soppresso)" },
    { "code": "L303", "province": "SI", "name": "TORRITA DI SIENA" },
    { "code": "L302", "province": "RM", "name": "TORRITA TIBERINA" },
    { "code": "ND", "province": "CA", "name": "TORTOLI' (soppresso)" },
    { "code": "ND", "province": "NU", "name": "TORTOLI' (soppresso)" },
    { "code": "A355", "province": "NU", "name": "TORTOLI'" },
    { "code": "A355", "province": "OG", "name": "TORTOLI' (soppresso)" },
    { "code": "L304", "province": "AL", "name": "TORTONA" },
    { "code": "L305", "province": "CS", "name": "TORTORA" },
    { "code": "L306", "province": "SA", "name": "TORTORELLA" },
    { "code": "L307", "province": "TE", "name": "TORTORETO" },
    { "code": "L308", "province": "ME", "name": "TORTORICI" },
    { "code": "L309", "province": "UD", "name": "TORVISCOSA" },
    { "code": "L310", "province": "RM", "name": "TOSCANELLA (soppresso)" },
    { "code": "L311", "province": "BS", "name": "TOSCOLANO (soppresso)" },
    { "code": "L312", "province": "BS", "name": "TOSCOLANO-MADERNO" },
    { "code": "L313", "province": "TN", "name": "TOSS (soppresso)" },
    { "code": "L314", "province": "TE", "name": "TOSSICIA" },
    { "code": "B044", "province": "BO", "name": "TOSSIGNANO (soppresso)" },
    { "code": "L316", "province": "SO", "name": "TOVO DI SANT'AGATA" },
    { "code": "L315", "province": "GE", "name": "TOVO SAN GIACOMO (soppresso)" },
    { "code": "L315", "province": "SV", "name": "TOVO SAN GIACOMO" },
    { "code": "L317", "province": "PA", "name": "TRABIA" },
    { "code": "L318", "province": "BG", "name": "TRABUCHELLO (soppresso)" },
    { "code": "L319", "province": "CO", "name": "TRADATE (soppresso)" },
    { "code": "L319", "province": "VA", "name": "TRADATE" },
    { "code": "L320", "province": "NO", "name": "TRAFFIUME (soppresso)" },
    { "code": "L321", "province": "CA", "name": "TRAMATZA (soppresso)" },
    { "code": "L321", "province": "OR", "name": "TRAMATZA" },
    { "code": "L322", "province": "TN", "name": "TRAMBILENO" },
    { "code": "L323", "province": "SA", "name": "TRAMONTI" },
    { "code": "L324", "province": "UD", "name": "TRAMONTI DI SOPRA (soppresso)" },
    { "code": "L324", "province": "PN", "name": "TRAMONTI DI SOPRA" },
    { "code": "L325", "province": "UD", "name": "TRAMONTI DI SOTTO (soppresso)" },
    { "code": "L325", "province": "PN", "name": "TRAMONTI DI SOTTO" },
    { "code": "L326", "province": "PZ", "name": "TRAMUTOLA" },
    { "code": "L327", "province": "TO", "name": "TRANA" },
    { "code": "L328", "province": "BA", "name": "TRANI (soppresso)" },
    { "code": "L328", "province": "BT", "name": "TRANI" },
    { "code": "L329", "province": "TN", "name": "TRANSACQUA (soppresso)" },
    { "code": "L330", "province": "SO", "name": "TRAONA" },
    { "code": "L331", "province": "TP", "name": "TRAPANI" },
    { "code": "L332", "province": "PA", "name": "TRAPPETO" },
    { "code": "L333", "province": "NO", "name": "TRAREGO (soppresso)" },
    { "code": "L333", "province": "NO", "name": "TRAREGO VIGGIONA (soppresso)" },
    { "code": "L333", "province": "VB", "name": "TRAREGO VIGGIONA" },
    { "code": "L334", "province": "AQ", "name": "TRASACCO" },
    { "code": "L335", "province": "UD", "name": "TRASAGHIS" },
    { "code": "L336", "province": "NO", "name": "TRASQUERA (soppresso)" },
    { "code": "L336", "province": "VB", "name": "TRASQUERA" },
    { "code": "D449", "province": "MS", "name": "TRASSILICO (soppresso)" },
    { "code": "D449", "province": "LU", "name": "TRASSILICO (soppresso)" },
    { "code": "L337", "province": "CA", "name": "TRATALIAS (soppresso)" },
    { "code": "L337", "province": "CI", "name": "TRATALIAS (soppresso)" },
    { "code": "L337", "province": "SU", "name": "TRATALIAS" },
    { "code": "L338", "province": "TO", "name": "TRAUSELLA (soppresso)" },
    { "code": "L338", "province": "AO", "name": "TRAUSELLA (soppresso)" },
    { "code": "I236", "province": "PV", "name": "TRAVACO' SICCOMARIO" },
    { "code": "L339", "province": "BS", "name": "TRAVAGLIATO" },
    { "code": "L340", "province": "TO", "name": "TRAVE (soppresso)" },
    { "code": "L341", "province": "CO", "name": "TRAVEDONA (soppresso)" },
    { "code": "L341", "province": "VA", "name": "TRAVEDONA (soppresso)" },
    { "code": "L342", "province": "VA", "name": "TRAVEDONA-MONATE" },
    { "code": "L343", "province": "CO", "name": "TRAVERSA (soppresso)" },
    { "code": "L344", "province": "TO", "name": "TRAVERSE (soppresso)" },
    { "code": "L345", "province": "TO", "name": "TRAVERSELLA" },
    { "code": "L345", "province": "AO", "name": "TRAVERSELLA (soppresso)" },
    { "code": "L346", "province": "PR", "name": "TRAVERSETOLO" },
    { "code": "L340", "province": "TO", "name": "TRAVES" },
    { "code": "L347", "province": "UD", "name": "TRAVESIO (soppresso)" },
    { "code": "L347", "province": "PN", "name": "TRAVESIO" },
    { "code": "L348", "province": "PC", "name": "TRAVO" },
    { "code": "M361", "province": "TN", "name": "TRE VILLE" },
    { "code": "L349", "province": "PD", "name": "TREBASELEGHE" },
    { "code": "L350", "province": "PV", "name": "TREBBIANO NIZZA (soppresso)" },
    { "code": "L351", "province": "PV", "name": "TREBECCO (soppresso)" },
    { "code": "L351", "province": "PC", "name": "TREBECCO (soppresso)" },
    { "code": "L353", "province": "CS", "name": "TREBISACCE" },
    { "code": "L354", "province": "PR", "name": "TRECASALI (soppresso)" },
    { "code": "M280", "province": "NA", "name": "TRECASE" },
    { "code": "L355", "province": "CT", "name": "TRECASTAGNI" },
    { "code": "M318", "province": "AN", "name": "TRECASTELLI" },
    { "code": "L356", "province": "NO", "name": "TRECATE" },
    { "code": "L357", "province": "PZ", "name": "TRECCHINA" },
    { "code": "L359", "province": "RO", "name": "TRECENTA" },
    { "code": "L360", "province": "CR", "name": "TREDOSSI (soppresso)" },
    { "code": "L361", "province": "FI", "name": "TREDOZIO (soppresso)" },
    { "code": "L361", "province": "FO", "name": "TREDOZIO (soppresso)" },
    { "code": "L361", "province": "FC", "name": "TREDOZIO" },
    { "code": "L363", "province": "CH", "name": "TREGLIO" },
    { "code": "L364", "province": "VR", "name": "TREGNAGO" },
    { "code": "L366", "province": "MC", "name": "TREIA" },
    { "code": "L367", "province": "CN", "name": "TREISO" },
    { "code": "L368", "province": "CO", "name": "TREMENICO (soppresso)" },
    { "code": "L368", "province": "LC", "name": "TREMENICO (soppresso)" },
    { "code": "L369", "province": "CT", "name": "TREMESTIERI ETNEO" },
    { "code": "L370", "province": "CO", "name": "TREMEZZINA (soppresso)" },
    { "code": "M341", "province": "CO", "name": "TREMEZZINA" },
    { "code": "L371", "province": "CO", "name": "TREMEZZO (soppresso)" },
    { "code": "L372", "province": "BS", "name": "TREMOSINE (soppresso)" },
    { "code": "L372", "province": "BS", "name": "TREMOSINE SUL GARDA" },
    { "code": "L373", "province": "MI", "name": "TRENNO (soppresso)" },
    { "code": "L374", "province": "TN", "name": "TRENS (soppresso)" },
    { "code": "L374", "province": "BZ", "name": "TRENS (soppresso)" },
    { "code": "L375", "province": "CS", "name": "TRENTA (soppresso)" },
    { "code": "L376", "province": "GO", "name": "TRENTA D'ISONZO (soppresso)" },
    { "code": "L376", "province": "UD", "name": "TRENTA D'ISONZO (soppresso)" },
    { "code": "L377", "province": "SA", "name": "TRENTINARA" },
    { "code": "L378", "province": "TN", "name": "TRENTO" },
    { "code": "L379", "province": "CE", "name": "TRENTOLA (soppresso)" },
    { "code": "L379", "province": "NA", "name": "TRENTOLA (soppresso)" },
    { "code": "L379", "province": "CE", "name": "TRENTOLA DUCENTA" },
    { "code": "L380", "province": "BS", "name": "TRENZANO" },
    { "code": "L381", "province": "UD", "name": "TREPPO CARNICO (soppresso)" },
    { "code": "L382", "province": "UD", "name": "TREPPO GRANDE" },
    { "code": "M399", "province": "UD", "name": "TREPPO LIGOSULLO" },
    { "code": "L383", "province": "LE", "name": "TREPUZZI" },
    { "code": "L384", "province": "SI", "name": "TREQUANDA" },
    { "code": "L385", "province": "TN", "name": "TRES (soppresso)" },
    { "code": "L386", "province": "MS", "name": "TRESANA" },
    { "code": "L387", "province": "VI", "name": "TRESCHE' CONCA (soppresso)" },
    { "code": "L389", "province": "CR", "name": "TRESCORE (soppresso)" },
    { "code": "L388", "province": "BG", "name": "TRESCORE BALNEARIO" },
    { "code": "L389", "province": "CR", "name": "TRESCORE CREMASCO" },
    { "code": "L390", "province": "FE", "name": "TRESIGALLO (soppresso)" },
    { "code": "M409", "province": "FE", "name": "TRESIGNANA" },
    { "code": "L391", "province": "RC", "name": "TRESILICO (soppresso)" },
    { "code": "L392", "province": "SO", "name": "TRESIVIO" },
    { "code": "L393", "province": "CA", "name": "TRESNURAGHES (soppresso)" },
    { "code": "L393", "province": "NU", "name": "TRESNURAGHES (soppresso)" },
    { "code": "L393", "province": "OR", "name": "TRESNURAGHES" },
    { "code": "L394", "province": "VI", "name": "TRETTO (soppresso)" },
    { "code": "L395", "province": "CO", "name": "TREVANO (soppresso)" },
    { "code": "L396", "province": "VR", "name": "TREVENZUOLO" },
    { "code": "L397", "province": "PG", "name": "TREVI" },
    { "code": "L398", "province": "RM", "name": "TREVI NEL LAZIO (soppresso)" },
    { "code": "L398", "province": "FR", "name": "TREVI NEL LAZIO" },
    { "code": "L399", "province": "AV", "name": "TREVICO" },
    { "code": "L400", "province": "BG", "name": "TREVIGLIO" },
    { "code": "L402", "province": "TV", "name": "TREVIGNANO" },
    { "code": "L401", "province": "RM", "name": "TREVIGNANO ROMANO" },
    { "code": "L403", "province": "AL", "name": "TREVILLE" },
    { "code": "L404", "province": "BG", "name": "TREVIOLO" },
    { "code": "L405", "province": "CO", "name": "TREVISAGO (soppresso)" },
    { "code": "L405", "province": "VA", "name": "TREVISAGO (soppresso)" },
    { "code": "L407", "province": "TV", "name": "TREVISO" },
    { "code": "L406", "province": "BS", "name": "TREVISO BRESCIANO" },
    { "code": "L408", "province": "MI", "name": "TREZZANO ROSA" },
    { "code": "L409", "province": "MI", "name": "TREZZANO SUL NAVIGLIO" },
    { "code": "L411", "province": "MI", "name": "TREZZO SULL'ADDA" },
    { "code": "L410", "province": "CN", "name": "TREZZO TINELLA" },
    { "code": "L413", "province": "CO", "name": "TREZZONE" },
    { "code": "L414", "province": "PD", "name": "TRIBANO" },
    { "code": "L415", "province": "MI", "name": "TRIBIANO" },
    { "code": "L416", "province": "GE", "name": "TRIBOGNA" },
    { "code": "L417", "province": "GO", "name": "TRIBUSSA (soppresso)" },
    { "code": "L417", "province": "UD", "name": "TRIBUSSA (soppresso)" },
    { "code": "L418", "province": "PZ", "name": "TRICARICO (soppresso)" },
    { "code": "L418", "province": "MT", "name": "TRICARICO" },
    { "code": "L419", "province": "LE", "name": "TRICASE" },
    { "code": "L420", "province": "NO", "name": "TRICERRO (soppresso)" },
    { "code": "L420", "province": "VC", "name": "TRICERRO" },
    { "code": "L421", "province": "UD", "name": "TRICESIMO" },
    { "code": "L422", "province": "BL", "name": "TRICHIANA (soppresso)" },
    { "code": "L423", "province": "CA", "name": "TRIEI (soppresso)" },
    { "code": "L423", "province": "NU", "name": "TRIEI" },
    { "code": "L423", "province": "OG", "name": "TRIEI (soppresso)" },
    { "code": "L424", "province": "TS", "name": "TRIESTE" },
    { "code": "L425", "province": "BA", "name": "TRIGGIANO" },
    { "code": "L426", "province": "CR", "name": "TRIGOLO" },
    { "code": "L427", "province": "CN", "name": "TRINITA'" },
    { "code": "L428", "province": "SS", "name": "TRINITA' D'AGULTU E VIGNOLA" },
    { "code": "L428", "province": "OT", "name": "TRINITA' D'AGULTU E VIGNOLA (soppresso)" },
    { "code": "B915", "province": "FG", "name": "TRINITAPOLI (soppresso)" },
    { "code": "B915", "province": "BT", "name": "TRINITAPOLI" },
    { "code": "L429", "province": "NO", "name": "TRINO (soppresso)" },
    { "code": "L429", "province": "VC", "name": "TRINO" },
    { "code": "L430", "province": "IM", "name": "TRIORA" },
    { "code": "L431", "province": "ME", "name": "TRIPI" },
    { "code": "L432", "province": "AL", "name": "TRISOBBIO" },
    { "code": "L433", "province": "VI", "name": "TRISSINO" },
    { "code": "L434", "province": "MI", "name": "TRIUGGIO (soppresso)" },
    { "code": "L434", "province": "MB", "name": "TRIUGGIO" },
    { "code": "L435", "province": "CB", "name": "TRIVENTO" },
    { "code": "L436", "province": "NO", "name": "TRIVERO (soppresso)" },
    { "code": "L436", "province": "VC", "name": "TRIVERO (soppresso)" },
    { "code": "L436", "province": "BI", "name": "TRIVERO (soppresso)" },
    { "code": "L437", "province": "RM", "name": "TRIVIGLIANO (soppresso)" },
    { "code": "L437", "province": "FR", "name": "TRIVIGLIANO" },
    { "code": "L438", "province": "UD", "name": "TRIVIGNANO UDINESE" },
    { "code": "L439", "province": "PZ", "name": "TRIVIGNO" },
    { "code": "L440", "province": "PV", "name": "TRIVOLZIO" },
    { "code": "L443", "province": "NO", "name": "TROBASO (soppresso)" },
    { "code": "L444", "province": "TN", "name": "TRODENA (soppresso)" },
    { "code": "L444", "province": "BZ", "name": "TRODENA (soppresso)" },
    { "code": "L444", "province": "BZ", "name": "TRODENA NEL PARCO NATURALE" },
    { "code": "L445", "province": "TO", "name": "TROFARELLO" },
    { "code": "L447", "province": "FG", "name": "TROIA" },
    { "code": "L448", "province": "CT", "name": "TROINA (soppresso)" },
    { "code": "L448", "province": "EN", "name": "TROINA" },
    { "code": "L449", "province": "PV", "name": "TROMELLO" },
    { "code": "L450", "province": "NO", "name": "TRONTANO (soppresso)" },
    { "code": "L450", "province": "VB", "name": "TRONTANO" },
    { "code": "A705", "province": "CO", "name": "TRONZANO LAGO MAGGIORE (soppresso)" },
    { "code": "A705", "province": "VA", "name": "TRONZANO LAGO MAGGIORE" },
    { "code": "L451", "province": "NO", "name": "TRONZANO VERCELLESE (soppresso)" },
    { "code": "L451", "province": "VC", "name": "TRONZANO VERCELLESE" },
    { "code": "L452", "province": "CZ", "name": "TROPEA (soppresso)" },
    { "code": "L452", "province": "VV", "name": "TROPEA" },
    { "code": "L453", "province": "PV", "name": "TROVO" },
    { "code": "L454", "province": "MI", "name": "TRUCCAZZANO" },
    { "code": "L455", "province": "TN", "name": "TUBRE (soppresso)" },
    { "code": "L455", "province": "BZ", "name": "TUBRE" },
    { "code": "L456", "province": "TN", "name": "TUENETTO (soppresso)" },
    { "code": "L457", "province": "TN", "name": "TUENNO (soppresso)" },
    { "code": "L458", "province": "CB", "name": "TUFARA" },
    { "code": "L459", "province": "CH", "name": "TUFILLO" },
    { "code": "L460", "province": "CE", "name": "TUFINO (soppresso)" },
    { "code": "L460", "province": "NA", "name": "TUFINO" },
    { "code": "L461", "province": "AV", "name": "TUFO" },
    { "code": "L462", "province": "LE", "name": "TUGLIE" },
    { "code": "L463", "province": "CA", "name": "TUILI (soppresso)" },
    { "code": "L463", "province": "VS", "name": "TUILI (soppresso)" },
    { "code": "L463", "province": "SU", "name": "TUILI" },
    { "code": "L464", "province": "SS", "name": "TULA" },
    { "code": "L465", "province": "TN", "name": "TUNES (soppresso)" },
    { "code": "L465", "province": "BZ", "name": "TUNES (soppresso)" },
    { "code": "L466", "province": "PG", "name": "TUORO (soppresso)" },
    { "code": "L466", "province": "PG", "name": "TUORO SUL TRASIMENO" },
    { "code": "L467", "province": "PV", "name": "TURAGO BORDONE (soppresso)" },
    { "code": "G507", "province": "RI", "name": "TURANIA" },
    { "code": "L469", "province": "MI", "name": "TURANO (soppresso)" },
    { "code": "L468", "province": "TN", "name": "TURANO (soppresso)" },
    { "code": "L469", "province": "MI", "name": "TURANO LODIGIANO (soppresso)" },
    { "code": "L469", "province": "LO", "name": "TURANO LODIGIANO" },
    { "code": "L470", "province": "CO", "name": "TURATE" },
    { "code": "L471", "province": "MI", "name": "TURBIGO" },
    { "code": "L472", "province": "BA", "name": "TURI" },
    { "code": "L473", "province": "CA", "name": "TURRI (soppresso)" },
    { "code": "L473", "province": "VS", "name": "TURRI (soppresso)" },
    { "code": "L473", "province": "SU", "name": "TURRI" },
    { "code": "L474", "province": "GO", "name": "TURRIACO" },
    { "code": "L474", "province": "TS", "name": "TURRIACO (soppresso)" },
    { "code": "L475", "province": "CH", "name": "TURRIVALIGNANI (soppresso)" },
    { "code": "L475", "province": "PE", "name": "TURRIVALIGNANI" },
    { "code": "L476", "province": "MI", "name": "TURRO MILANESE (soppresso)" },
    { "code": "L477", "province": "PZ", "name": "TURSI (soppresso)" },
    { "code": "L477", "province": "MT", "name": "TURSI" },
    { "code": "L478", "province": "ME", "name": "TUSA" },
    { "code": "L310", "province": "RM", "name": "TUSCANIA (soppresso)" },
    { "code": "L310", "province": "VT", "name": "TUSCANIA" },
    { "code": "C789", "province": "BG", "name": "UBIALE CLANEZZO" },
    { "code": "L480", "province": "MI", "name": "UBOLDO (soppresso)" },
    { "code": "L480", "province": "VA", "name": "UBOLDO" },
    { "code": "L481", "province": "UD", "name": "UCOVIZZA (soppresso)" },
    { "code": "L482", "province": "ME", "name": "UCRIA" },
    { "code": "L483", "province": "UD", "name": "UDINE" },
    { "code": "L484", "province": "LE", "name": "UGENTO" },
    { "code": "L485", "province": "LE", "name": "UGGIANO LA CHIESA" },
    { "code": "L486", "province": "CO", "name": "UGGIATE (soppresso)" },
    { "code": "L487", "province": "CO", "name": "UGGIATE-TREVANO" },
    { "code": "L481", "province": "UD", "name": "UGOVIZZA VALBRUNA (soppresso)" },
    { "code": "L488", "province": "CA", "name": "ULA' TIRSO (soppresso)" },
    { "code": "L488", "province": "OR", "name": "ULA' TIRSO" },
    { "code": "L489", "province": "CA", "name": "ULASSAI (soppresso)" },
    { "code": "L489", "province": "NU", "name": "ULASSAI" },
    { "code": "L489", "province": "OG", "name": "ULASSAI (soppresso)" },
    { "code": "L490", "province": "TN", "name": "ULTIMO (soppresso)" },
    { "code": "L490", "province": "BZ", "name": "ULTIMO" },
    { "code": "G196", "province": "TO", "name": "ULZIO (soppresso)" },
    { "code": "L491", "province": "PL", "name": "UMAGO (soppresso)" },
    { "code": "D786", "province": "PG", "name": "UMBERTIDE" },
    { "code": "L492", "province": "CZ", "name": "UMBRIATICO (soppresso)" },
    { "code": "L492", "province": "KR", "name": "UMBRIATICO" },
    { "code": "L493", "province": "NO", "name": "UNCHIO (soppresso)" },
    { "code": "L494", "province": "BS", "name": "URAGO D'OGLIO" },
    { "code": "L496", "province": "CA", "name": "URAS (soppresso)" },
    { "code": "L496", "province": "OR", "name": "URAS" },
    { "code": "L497", "province": "PD", "name": "URBANA" },
    { "code": "L498", "province": "PS", "name": "URBANIA (soppresso)" },
    { "code": "L498", "province": "PU", "name": "URBANIA" },
    { "code": "L499", "province": "SV", "name": "URBE" },
    { "code": "L500", "province": "PS", "name": "URBINO (soppresso)" },
    { "code": "L500", "province": "PU", "name": "URBINO" },
    { "code": "L501", "province": "MC", "name": "URBISAGLIA" },
    { "code": "L501", "province": "MC", "name": "URBISAGLIA BONSERVIZI (soppresso)" },
    { "code": "L502", "province": "BG", "name": "URGNANO" },
    { "code": "L503", "province": "SS", "name": "URI" },
    { "code": "L504", "province": "CO", "name": "URIO (soppresso)" },
    { "code": "L505", "province": "CB", "name": "URURI" },
    { "code": "L506", "province": "CA", "name": "URZULEI (soppresso)" },
    { "code": "L506", "province": "NU", "name": "URZULEI" },
    { "code": "L506", "province": "OG", "name": "URZULEI (soppresso)" },
    { "code": "L507", "province": "GE", "name": "USCIO" },
    { "code": "L508", "province": "CA", "name": "USELLUS (soppresso)" },
    { "code": "L508", "province": "OR", "name": "USELLUS" },
    { "code": "L509", "province": "SS", "name": "USINI" },
    { "code": "L511", "province": "MI", "name": "USMATE VELATE (soppresso)" },
    { "code": "L511", "province": "MB", "name": "USMATE VELATE" },
    { "code": "L512", "province": "CA", "name": "USSANA (soppresso)" },
    { "code": "L512", "province": "SU", "name": "USSANA" },
    { "code": "L513", "province": "CA", "name": "USSARAMANNA (soppresso)" },
    { "code": "L513", "province": "VS", "name": "USSARAMANNA (soppresso)" },
    { "code": "L513", "province": "SU", "name": "USSARAMANNA" },
    { "code": "L514", "province": "CA", "name": "USSASSAI (soppresso)" },
    { "code": "L514", "province": "NU", "name": "USSASSAI" },
    { "code": "L514", "province": "OG", "name": "USSASSAI (soppresso)" },
    { "code": "L515", "province": "TO", "name": "USSEAUX" },
    { "code": "L516", "province": "TO", "name": "USSEGLIO" },
    { "code": "L517", "province": "MC", "name": "USSITA" },
    { "code": "L518", "province": "CN", "name": "USSOLO (soppresso)" },
    { "code": "L519", "province": "PA", "name": "USTICA" },
    { "code": "L520", "province": "GO", "name": "USTIE (soppresso)" },
    { "code": "L520", "province": "UD", "name": "USTIE (soppresso)" },
    { "code": "L521", "province": "CA", "name": "UTA" },
    { "code": "L522", "province": "LU", "name": "UZZANO (soppresso)" },
    { "code": "L522", "province": "PT", "name": "UZZANO" },
    { "code": "L524", "province": "CS", "name": "VACCARIZZO ALBANESE" },
    { "code": "L525", "province": "PG", "name": "VACONE (soppresso)" },
    { "code": "L525", "province": "RM", "name": "VACONE (soppresso)" },
    { "code": "L525", "province": "RI", "name": "VACONE" },
    { "code": "L526", "province": "CH", "name": "VACRI" },
    { "code": "L527", "province": "TN", "name": "VADENA (soppresso)" },
    { "code": "L527", "province": "BZ", "name": "VADENA" },
    { "code": "L528", "province": "GE", "name": "VADO (soppresso)" },
    { "code": "L528", "province": "GE", "name": "VADO LIGURE (soppresso)" },
    { "code": "L528", "province": "SV", "name": "VADO LIGURE" },
    { "code": "L533", "province": "MS", "name": "VAGLI SOTTO (soppresso)" },
    { "code": "L533", "province": "LU", "name": "VAGLI SOTTO" },
    { "code": "L529", "province": "FI", "name": "VAGLIA" },
    { "code": "L530", "province": "AL", "name": "VAGLIERANO (soppresso)" },
    { "code": "L532", "province": "PZ", "name": "VAGLIO BASILICATA" },
    { "code": "L532", "province": "PZ", "name": "VAGLIO DI BASILICATA (soppresso)" },
    { "code": "L532", "province": "PZ", "name": "VAGLIO LUCANO (soppresso)" },
    { "code": "L531", "province": "AL", "name": "VAGLIO SERRA (soppresso)" },
    { "code": "L531", "province": "AT", "name": "VAGLIO SERRA" },
    { "code": "L534", "province": "NO", "name": "VAGNA (soppresso)" },
    { "code": "L537", "province": "FI", "name": "VAIANO (soppresso)" },
    { "code": "L537", "province": "PO", "name": "VAIANO" },
    { "code": "L535", "province": "CR", "name": "VAIANO CREMASCO" },
    { "code": "L538", "province": "TO", "name": "VAIE" },
    { "code": "L539", "province": "CR", "name": "VAILATE" },
    { "code": "L540", "province": "CE", "name": "VAIRANO PATENORA" },
    { "code": "L540", "province": "NA", "name": "VAIRANO PATENORA (soppresso)" },
    { "code": "M265", "province": "PN", "name": "VAJONT" },
    { "code": "M334", "province": "BG", "name": "VAL BREMBILLA" },
    { "code": "L555", "province": "TO", "name": "VAL DELLA TORRE" },
    { "code": "M405", "province": "TO", "name": "VAL DI CHY" },
    { "code": "L562", "province": "PV", "name": "VAL DI NIZZA" },
    { "code": "H261", "province": "AO", "name": "VAL DI REMA (soppresso)" },
    { "code": "L564", "province": "BZ", "name": "VAL DI VIZZE" },
    { "code": "M374", "province": "BL", "name": "VAL DI ZOLDO" },
    { "code": "M384", "province": "VI", "name": "VAL LIONA" },
    { "code": "L637", "province": "VA", "name": "VAL MARCHIROLO (soppresso)" },
    { "code": "L638", "province": "SO", "name": "VAL MASINO" },
    { "code": "H259", "province": "CO", "name": "VAL REZZO" },
    { "code": "L543", "province": "TN", "name": "VALAS (soppresso)" },
    { "code": "L543", "province": "BZ", "name": "VALAS (soppresso)" },
    { "code": "L544", "province": "BG", "name": "VALBONDIONE" },
    { "code": "L545", "province": "BG", "name": "VALBREMBO" },
    { "code": "M423", "province": "VI", "name": "VALBRENTA" },
    { "code": "L546", "province": "GE", "name": "VALBREVENNA" },
    { "code": "L547", "province": "CO", "name": "VALBRONA" },
    { "code": "L548", "province": "AO", "name": "VALCHIUSA (soppresso)" },
    { "code": "M415", "province": "TO", "name": "VALCHIUSA" },
    { "code": "L549", "province": "TO", "name": "VALCHIUSELLA (soppresso)" },
    { "code": "L549", "province": "AO", "name": "VALCHIUSELLA (soppresso)" },
    { "code": "L550", "province": "TN", "name": "VALDA (soppresso)" },
    { "code": "L551", "province": "VI", "name": "VALDAGNO" },
    { "code": "A179", "province": "TN", "name": "VALDAGNO (soppresso)" },
    { "code": "A179", "province": "BZ", "name": "VALDAGNO (soppresso)" },
    { "code": "A179", "province": "TN", "name": "VALDAGNO DI TRENTO (soppresso)" },
    { "code": "M343", "province": "TN", "name": "VALDAONE" },
    { "code": "L552", "province": "TN", "name": "VALDAORA (soppresso)" },
    { "code": "L552", "province": "BZ", "name": "VALDAORA" },
    { "code": "L553", "province": "PL", "name": "VALDARSA (soppresso)" },
    { "code": "L554", "province": "VI", "name": "VALDASTICO" },
    { "code": "L556", "province": "NO", "name": "VALDENGO (soppresso)" },
    { "code": "L556", "province": "VC", "name": "VALDENGO (soppresso)" },
    { "code": "L556", "province": "BI", "name": "VALDENGO" },
    { "code": "G319", "province": "TP", "name": "VALDERICE" },
    { "code": "L557", "province": "SO", "name": "VALDIDENTRO" },
    { "code": "L558", "province": "CN", "name": "VALDIERI" },
    { "code": "L559", "province": "TN", "name": "VALDIGIOVO (soppresso)" },
    { "code": "L560", "province": "AO", "name": "VALDIGNA D'AOSTA (soppresso)" },
    { "code": "F726", "province": "AO", "name": "VALDIGNA D'AOSTA (soppresso)" },
    { "code": "M417", "province": "BI", "name": "VALDILANA" },
    { "code": "L561", "province": "ME", "name": "VALDINA" },
    { "code": "L563", "province": "SO", "name": "VALDISOTTO" },
    { "code": "L565", "province": "TV", "name": "VALDOBBIADENE" },
    { "code": "L566", "province": "NO", "name": "VALDUGGIA (soppresso)" },
    { "code": "L566", "province": "VC", "name": "VALDUGGIA" },
    { "code": "L568", "province": "PV", "name": "VALEGGIO" },
    { "code": "L567", "province": "VR", "name": "VALEGGIO SUL MINCIO" },
    { "code": "L569", "province": "RM", "name": "VALENTANO (soppresso)" },
    { "code": "L569", "province": "VT", "name": "VALENTANO" },
    { "code": "L570", "province": "AL", "name": "VALENZA" },
    { "code": "L571", "province": "BA", "name": "VALENZANO" },
    { "code": "L572", "province": "MI", "name": "VALERA FRATTA (soppresso)" },
    { "code": "L572", "province": "LO", "name": "VALERA FRATTA" },
    { "code": "L573", "province": "PG", "name": "VALFABBRICA" },
    { "code": "L574", "province": "AL", "name": "VALFENERA (soppresso)" },
    { "code": "L574", "province": "AT", "name": "VALFENERA" },
    { "code": "L575", "province": "TN", "name": "VALFLORIANA" },
    { "code": "M382", "province": "MC", "name": "VALFORNACE" },
    { "code": "L576", "province": "SO", "name": "VALFURVA" },
    { "code": "L577", "province": "CO", "name": "VALGANNA (soppresso)" },
    { "code": "L577", "province": "VA", "name": "VALGANNA" },
    { "code": "L578", "province": "TO", "name": "VALGIOIE" },
    { "code": "L559", "province": "TN", "name": "VALGIOVO (soppresso)" },
    { "code": "L559", "province": "BZ", "name": "VALGIOVO (soppresso)" },
    { "code": "L579", "province": "BG", "name": "VALGOGLIO" },
    { "code": "L580", "province": "CN", "name": "VALGRANA" },
    { "code": "D322", "province": "GO", "name": "VALGRANDE (soppresso)" },
    { "code": "D322", "province": "UD", "name": "VALGRANDE (soppresso)" },
    { "code": "L581", "province": "CO", "name": "VALGREGHENTINO (soppresso)" },
    { "code": "L581", "province": "LC", "name": "VALGREGHENTINO" },
    { "code": "L582", "province": "TO", "name": "VALGRISANCHE (soppresso)" },
    { "code": "L582", "province": "AO", "name": "VALGRISANCHE (soppresso)" },
    { "code": "L582", "province": "AO", "name": "VALGRISENCHE" },
    { "code": "L582", "province": "AO", "name": "VALGRISENZA (soppresso)" },
    { "code": "L583", "province": "CL", "name": "VALGUARNERA CAROPEPE (soppresso)" },
    { "code": "L583", "province": "EN", "name": "VALGUARNERA CAROPEPE" },
    { "code": "L584", "province": "BL", "name": "VALLADA (soppresso)" },
    { "code": "L584", "province": "BL", "name": "VALLADA AGORDINA" },
    { "code": "L585", "province": "BG", "name": "VALL'ALTA (soppresso)" },
    { "code": "L586", "province": "NO", "name": "VALLANZENGO (soppresso)" },
    { "code": "L586", "province": "VC", "name": "VALLANZENGO (soppresso)" },
    { "code": "L586", "province": "BI", "name": "VALLANZENGO" },
    { "code": "L587", "province": "TN", "name": "VALLARGA (soppresso)" },
    { "code": "L587", "province": "BZ", "name": "VALLARGA (soppresso)" },
    { "code": "L588", "province": "TN", "name": "VALLARSA" },
    { "code": "L589", "province": "AV", "name": "VALLATA" },
    { "code": "L594", "province": "CE", "name": "VALLE AGRICOLA" },
    { "code": "L594", "province": "BN", "name": "VALLE AGRICOLA (soppresso)" },
    { "code": "L595", "province": "BZ", "name": "VALLE AURINA" },
    { "code": "M404", "province": "VB", "name": "VALLE CANNOBINA" },
    { "code": "L597", "province": "TE", "name": "VALLE CASTELLANA" },
    { "code": "G540", "province": "SA", "name": "VALLE DELL'ANGELO" },
    { "code": "L590", "province": "BL", "name": "VALLE DI CADORE" },
    { "code": "L601", "province": "BZ", "name": "VALLE DI CASIES" },
    { "code": "L591", "province": "CE", "name": "VALLE DI MADDALONI" },
    { "code": "L591", "province": "NA", "name": "VALLE DI MADDALONI (soppresso)" },
    { "code": "L602", "province": "PL", "name": "VALLE D'ISTRIA (soppresso)" },
    { "code": "L606", "province": "NO", "name": "VALLE INFERIORE MOSSO (soppresso)" },
    { "code": "L593", "province": "PV", "name": "VALLE LOMELLINA" },
    { "code": "L606", "province": "NO", "name": "VALLE MOSSO (soppresso)" },
    { "code": "L606", "province": "VC", "name": "VALLE MOSSO (soppresso)" },
    { "code": "L606", "province": "BI", "name": "VALLE MOSSO (soppresso)" },
    { "code": "L617", "province": "PV", "name": "VALLE SALIMBENE" },
    { "code": "L618", "province": "TN", "name": "VALLE SAN FELICE (soppresso)" },
    { "code": "L620", "province": "NO", "name": "VALLE SAN NICOLAO (soppresso)" },
    { "code": "L620", "province": "VC", "name": "VALLE SAN NICOLAO (soppresso)" },
    { "code": "L620", "province": "BI", "name": "VALLE SAN NICOLAO" },
    { "code": "L621", "province": "TN", "name": "VALLE SAN SILVESTRO (soppresso)" },
    { "code": "L621", "province": "BZ", "name": "VALLE SAN SILVESTRO (soppresso)" },
    { "code": "L622", "province": "NO", "name": "VALLE SUPERIORE MOSSO (soppresso)" },
    { "code": "L622", "province": "VC", "name": "VALLE SUPERIORE MOSSO (soppresso)" },
    { "code": "L596", "province": "IM", "name": "VALLEBONA" },
    { "code": "L598", "province": "RM", "name": "VALLECORSA (soppresso)" },
    { "code": "L598", "province": "FR", "name": "VALLECORSA" },
    { "code": "L599", "province": "IM", "name": "VALLECROSIA" },
    { "code": "L603", "province": "PA", "name": "VALLEDOLMO" },
    { "code": "L604", "province": "SS", "name": "VALLEDORIA" },
    { "code": "I322", "province": "CZ", "name": "VALLEFIORITA" },
    { "code": "M331", "province": "PU", "name": "VALLEFOGLIA" },
    { "code": "L605", "province": "CE", "name": "VALLEFREDDA (soppresso)" },
    { "code": "L605", "province": "FR", "name": "VALLEFREDDA (soppresso)" },
    { "code": "M362", "province": "TN", "name": "VALLELAGHI" },
    { "code": "L607", "province": "CZ", "name": "VALLELONGA (soppresso)" },
    { "code": "L607", "province": "VV", "name": "VALLELONGA" },
    { "code": "L608", "province": "TN", "name": "VALLELUNGA (soppresso)" },
    { "code": "L608", "province": "BZ", "name": "VALLELUNGA (soppresso)" },
    { "code": "L608", "province": "TN", "name": "VALLELUNGA CARLINO (soppresso)" },
    { "code": "L609", "province": "CL", "name": "VALLELUNGA PRATAMENO" },
    { "code": "L605", "province": "FR", "name": "VALLEMAIO" },
    { "code": "L610", "province": "UD", "name": "VALLENONCELLO (soppresso)" },
    { "code": "L611", "province": "RM", "name": "VALLEPIETRA" },
    { "code": "L612", "province": "RM", "name": "VALLERANO (soppresso)" },
    { "code": "L612", "province": "VT", "name": "VALLERANO" },
    { "code": "L613", "province": "CA", "name": "VALLERMOSA (soppresso)" },
    { "code": "L613", "province": "SU", "name": "VALLERMOSA" },
    { "code": "L614", "province": "CE", "name": "VALLEROTONDA (soppresso)" },
    { "code": "L614", "province": "FR", "name": "VALLEROTONDA" },
    { "code": "L615", "province": "TN", "name": "VALLES (soppresso)" },
    { "code": "L615", "province": "BZ", "name": "VALLES (soppresso)" },
    { "code": "L616", "province": "AV", "name": "VALLESACCARDA" },
    { "code": "L623", "province": "BG", "name": "VALLEVE" },
    { "code": "L624", "province": "VI", "name": "VALLI DEI SIGNORI (soppresso)" },
    { "code": "L624", "province": "VI", "name": "VALLI DEL PASUBIO" },
    { "code": "L625", "province": "RM", "name": "VALLINFREDA" },
    { "code": "L626", "province": "BS", "name": "VALLIO (soppresso)" },
    { "code": "L626", "province": "BS", "name": "VALLIO TERME" },
    { "code": "L628", "province": "SA", "name": "VALLO DELLA LUCANIA" },
    { "code": "L627", "province": "PG", "name": "VALLO DI NERA" },
    { "code": "L629", "province": "TO", "name": "VALLO TORINESE" },
    { "code": "L630", "province": "VI", "name": "VALLONARA (soppresso)" },
    { "code": "L632", "province": "IM", "name": "VALLORIA MARITTIMA (soppresso)" },
    { "code": "L631", "province": "CN", "name": "VALLORIATE" },
    { "code": "L633", "province": "AL", "name": "VALMACCA" },
    { "code": "L634", "province": "CO", "name": "VALMADRERA (soppresso)" },
    { "code": "L634", "province": "LC", "name": "VALMADRERA" },
    { "code": "L635", "province": "NO", "name": "VALMAGGIA (soppresso)" },
    { "code": "L635", "province": "VC", "name": "VALMAGGIA (soppresso)" },
    { "code": "L636", "province": "CN", "name": "VALMALA (soppresso)" },
    { "code": "L639", "province": "RM", "name": "VALMONTONE" },
    { "code": "L640", "province": "CO", "name": "VALMOREA" },
    { "code": "L641", "province": "PR", "name": "VALMOZZOLA" },
    { "code": "L642", "province": "BG", "name": "VALNEGRA" },
    { "code": "L643", "province": "AO", "name": "VALPELLINA (soppresso)" },
    { "code": "L643", "province": "TO", "name": "VALPELLINE (soppresso)" },
    { "code": "L643", "province": "AO", "name": "VALPELLINE" },
    { "code": "L644", "province": "TO", "name": "VALPERGA" },
    { "code": "L644", "province": "AO", "name": "VALPERGA (soppresso)" },
    { "code": "L645", "province": "TO", "name": "VALPRATO (soppresso)" },
    { "code": "L645", "province": "AO", "name": "VALPRATO (soppresso)" },
    { "code": "B510", "province": "AO", "name": "VALPRATO SOANA (soppresso)" },
    { "code": "B510", "province": "TO", "name": "VALPRATO SOANA" },
    { "code": "L646", "province": "VI", "name": "VALROVINA (soppresso)" },
    { "code": "M320", "province": "BO", "name": "VALSAMOGGIA" },
    { "code": "M254", "province": "FU", "name": "VALSANTAMARINA (soppresso)" },
    { "code": "L647", "province": "AO", "name": "VALSAVARA (soppresso)" },
    { "code": "L647", "province": "TO", "name": "VALSAVARANCHE (soppresso)" },
    { "code": "L647", "province": "AO", "name": "VALSAVARANCHE (soppresso)" },
    { "code": "L647", "province": "AO", "name": "VALSAVARENCHE" },
    { "code": "L648", "province": "BS", "name": "VALSAVIORE (soppresso)" },
    { "code": "L649", "province": "BG", "name": "VALSECCA (soppresso)" },
    { "code": "D513", "province": "PZ", "name": "VALSINNI (soppresso)" },
    { "code": "D513", "province": "MT", "name": "VALSINNI" },
    { "code": "C936", "province": "CO", "name": "VALSOLDA" },
    { "code": "L650", "province": "VI", "name": "VALSTAGNA (soppresso)" },
    { "code": "L651", "province": "NO", "name": "VALSTRONA (soppresso)" },
    { "code": "L651", "province": "VB", "name": "VALSTRONA" },
    { "code": "L652", "province": "BG", "name": "VALTESSE (soppresso)" },
    { "code": "L653", "province": "PG", "name": "VALTOPINA" },
    { "code": "L654", "province": "AO", "name": "VALTORNENZA (soppresso)" },
    { "code": "L655", "province": "BG", "name": "VALTORTA" },
    { "code": "L654", "province": "TO", "name": "VALTOURNANCHE (soppresso)" },
    { "code": "L654", "province": "AO", "name": "VALTOURNANCHE (soppresso)" },
    { "code": "L654", "province": "AO", "name": "VALTOURNENCHE" },
    { "code": "L656", "province": "SA", "name": "VALVA" },
    { "code": "M395", "province": "LC", "name": "VALVARRONE" },
    { "code": "L657", "province": "UD", "name": "VALVASONE (soppresso)" },
    { "code": "L657", "province": "PN", "name": "VALVASONE (soppresso)" },
    { "code": "M346", "province": "PN", "name": "VALVASONE ARZENE" },
    { "code": "L659", "province": "PV", "name": "VALVERDE (soppresso)" },
    { "code": "L658", "province": "CT", "name": "VALVERDE" },
    { "code": "L468", "province": "TN", "name": "VALVESTINO (soppresso)" },
    { "code": "L468", "province": "BS", "name": "VALVESTINO" },
    { "code": "L660", "province": "BZ", "name": "VANDOIES" },
    { "code": "L661", "province": "TN", "name": "VANDOIES DI SOPRA (soppresso)" },
    { "code": "L661", "province": "BZ", "name": "VANDOIES DI SOPRA (soppresso)" },
    { "code": "L662", "province": "TN", "name": "VANDOIES DI SOTTO (soppresso)" },
    { "code": "L662", "province": "BZ", "name": "VANDOIES DI SOTTO (soppresso)" },
    { "code": "L663", "province": "TN", "name": "VANGA (soppresso)" },
    { "code": "L663", "province": "BZ", "name": "VANGA (soppresso)" },
    { "code": "L664", "province": "MI", "name": "VANZAGHELLO" },
    { "code": "L665", "province": "MI", "name": "VANZAGO" },
    { "code": "L666", "province": "NO", "name": "VANZONE CON SAN CARLO (soppresso)" },
    { "code": "L666", "province": "VB", "name": "VANZONE CON SAN CARLO" },
    { "code": "L667", "province": "MI", "name": "VAPRIO D'ADDA" },
    { "code": "L668", "province": "NO", "name": "VAPRIO D'AGOGNA" },
    { "code": "L669", "province": "NO", "name": "VARALLO (soppresso)" },
    { "code": "L669", "province": "VC", "name": "VARALLO" },
    { "code": "L670", "province": "NO", "name": "VARALLO POMBIA" },
    { "code": "L671", "province": "CO", "name": "VARANO (soppresso)" },
    { "code": "L671", "province": "CO", "name": "VARANO BORGHI (soppresso)" },
    { "code": "L671", "province": "VA", "name": "VARANO BORGHI" },
    { "code": "L672", "province": "PR", "name": "VARANO DE' MELEGARI" },
    { "code": "L673", "province": "RC", "name": "VARAPODIO" },
    { "code": "L674", "province": "CO", "name": "VARARO (soppresso)" },
    { "code": "L674", "province": "VA", "name": "VARARO (soppresso)" },
    { "code": "L675", "province": "GE", "name": "VARAZZE (soppresso)" },
    { "code": "L675", "province": "SV", "name": "VARAZZE" },
    { "code": "L676", "province": "PG", "name": "VARCO SABINO (soppresso)" },
    { "code": "L676", "province": "RM", "name": "VARCO SABINO (soppresso)" },
    { "code": "L676", "province": "RI", "name": "VARCO SABINO" },
    { "code": "L677", "province": "MI", "name": "VAREDO (soppresso)" },
    { "code": "L677", "province": "MB", "name": "VAREDO" },
    { "code": "L678", "province": "TN", "name": "VARENA" },
    { "code": "L679", "province": "AL", "name": "VARENGO (soppresso)" },
    { "code": "L680", "province": "CO", "name": "VARENNA (soppresso)" },
    { "code": "L680", "province": "LC", "name": "VARENNA" },
    { "code": "L682", "province": "CO", "name": "VARESE (soppresso)" },
    { "code": "L682", "province": "VA", "name": "VARESE" },
    { "code": "L681", "province": "GE", "name": "VARESE LIGURE (soppresso)" },
    { "code": "L681", "province": "SP", "name": "VARESE LIGURE" },
    { "code": "L683", "province": "AL", "name": "VARGO (soppresso)" },
    { "code": "L685", "province": "TO", "name": "VARISELLA" },
    { "code": "L686", "province": "UD", "name": "VARMO" },
    { "code": "L687", "province": "TN", "name": "VARNA (soppresso)" },
    { "code": "L687", "province": "BZ", "name": "VARNA" },
    { "code": "L688", "province": "BN", "name": "VARONI (soppresso)" },
    { "code": "L689", "province": "PR", "name": "VARSI" },
    { "code": "L690", "province": "PV", "name": "VARZI" },
    { "code": "L691", "province": "NO", "name": "VARZO (soppresso)" },
    { "code": "L691", "province": "VB", "name": "VARZO" },
    { "code": "L692", "province": "BL", "name": "VAS (soppresso)" },
    { "code": "A701", "province": "VT", "name": "VASANELLO" },
    { "code": "L693", "province": "IM", "name": "VASIA" },
    { "code": "L694", "province": "TN", "name": "VASIO (soppresso)" },
    { "code": "L695", "province": "CO", "name": "VASSENA (soppresso)" },
    { "code": "E372", "province": "CH", "name": "VASTO" },
    { "code": "L696", "province": "CB", "name": "VASTOGIRARDI (soppresso)" },
    { "code": "L696", "province": "IS", "name": "VASTOGIRARDI" },
    { "code": "L697", "province": "TN", "name": "VATTARO (soppresso)" },
    { "code": "L698", "province": "TO", "name": "VAUDA CANAVESE" },
    { "code": "L698", "province": "TO", "name": "VAUDA DI FRONT (soppresso)" },
    { "code": "L538", "province": "TO", "name": "VAYES (soppresso)" },
    { "code": "E728", "province": "RI", "name": "VAZIA (soppresso)" },
    { "code": "L699", "province": "CZ", "name": "VAZZANO (soppresso)" },
    { "code": "L699", "province": "VV", "name": "VAZZANO" },
    { "code": "L700", "province": "TV", "name": "VAZZOLA" },
    { "code": "L701", "province": "CO", "name": "VECCANA (soppresso)" },
    { "code": "L701", "province": "VA", "name": "VECCANA (soppresso)" },
    { "code": "L702", "province": "PI", "name": "VECCHIANO" },
    { "code": "L704", "province": "MI", "name": "VEDANO AL LAMBRO (soppresso)" },
    { "code": "L704", "province": "MB", "name": "VEDANO AL LAMBRO" },
    { "code": "L703", "province": "CO", "name": "VEDANO OLONA (soppresso)" },
    { "code": "L703", "province": "VA", "name": "VEDANO OLONA" },
    { "code": "L705", "province": "VA", "name": "VEDDASCA (soppresso)" },
    { "code": "L706", "province": "TV", "name": "VEDELAGO" },
    { "code": "L707", "province": "BG", "name": "VEDESETA" },
    { "code": "L709", "province": "MI", "name": "VEDUGGIO CON COLZANO (soppresso)" },
    { "code": "L709", "province": "MB", "name": "VEDUGGIO CON COLZANO" },
    { "code": "L710", "province": "PD", "name": "VEGGIANO" },
    { "code": "L711", "province": "LE", "name": "VEGLIE" },
    { "code": "L711", "province": "BR", "name": "VEGLIE (soppresso)" },
    { "code": "L712", "province": "NO", "name": "VEGLIO (soppresso)" },
    { "code": "L712", "province": "VC", "name": "VEGLIO (soppresso)" },
    { "code": "L712", "province": "BI", "name": "VEGLIO" },
    { "code": "L713", "province": "RM", "name": "VEJANO (soppresso)" },
    { "code": "L713", "province": "VT", "name": "VEJANO" },
    { "code": "L543", "province": "TN", "name": "VELASIO (soppresso)" },
    { "code": "L714", "province": "CO", "name": "VELATE (soppresso)" },
    { "code": "L714", "province": "VA", "name": "VELATE (soppresso)" },
    { "code": "L511", "province": "MI", "name": "VELATE MILANESE (soppresso)" },
    { "code": "L715", "province": "CO", "name": "VELESO" },
    { "code": "L716", "province": "PV", "name": "VELEZZO LOMELLINA" },
    { "code": "H653", "province": "GO", "name": "VELICHE-ZABLIE (soppresso)" },
    { "code": "H653", "province": "UD", "name": "VELICHE-ZABLIE (soppresso)" },
    { "code": "L717", "province": "LU", "name": "VELLANO (soppresso)" },
    { "code": "L717", "province": "PT", "name": "VELLANO (soppresso)" },
    { "code": "L718", "province": "GE", "name": "VELLEGO (soppresso)" },
    { "code": "L718", "province": "SV", "name": "VELLEGO (soppresso)" },
    { "code": "L719", "province": "RM", "name": "VELLETRI" },
    { "code": "L720", "province": "PV", "name": "VELLEZZO BELLINI" },
    { "code": "L721", "province": "BS", "name": "VELLO (soppresso)" },
    { "code": "L723", "province": "VI", "name": "VELO D'ASTICO" },
    { "code": "L722", "province": "VR", "name": "VELO VERONESE" },
    { "code": "L724", "province": "TN", "name": "VELTURNO (soppresso)" },
    { "code": "L724", "province": "BZ", "name": "VELTURNO" },
    { "code": "L725", "province": "CB", "name": "VENAFRO (soppresso)" },
    { "code": "L725", "province": "IS", "name": "VENAFRO" },
    { "code": "L726", "province": "TO", "name": "VENALZIO (soppresso)" },
    { "code": "L727", "province": "TO", "name": "VENARIA REALE" },
    { "code": "L728", "province": "AP", "name": "VENAROTTA" },
    { "code": "L729", "province": "CN", "name": "VENASCA" },
    { "code": "L726", "province": "TO", "name": "VENAUS" },
    { "code": "L730", "province": "GE", "name": "VENDONE (soppresso)" },
    { "code": "L730", "province": "SV", "name": "VENDONE" },
    { "code": "L731", "province": "CO", "name": "VENDROGNO (soppresso)" },
    { "code": "L731", "province": "LC", "name": "VENDROGNO" },
    { "code": "L732", "province": "VA", "name": "VENEGONO (soppresso)" },
    { "code": "L733", "province": "CO", "name": "VENEGONO INFERIORE (soppresso)" },
    { "code": "L733", "province": "VA", "name": "VENEGONO INFERIORE" },
    { "code": "L734", "province": "CO", "name": "VENEGONO SUPERIORE (soppresso)" },
    { "code": "L734", "province": "VA", "name": "VENEGONO SUPERIORE" },
    { "code": "L735", "province": "ME", "name": "VENETICO" },
    { "code": "L736", "province": "VE", "name": "VENEZIA" },
    { "code": "L737", "province": "CO", "name": "VENIANO" },
    { "code": "L738", "province": "PZ", "name": "VENOSA" },
    { "code": "M364", "province": "RE", "name": "VENTASSO" },
    { "code": "L739", "province": "AV", "name": "VENTICANO" },
    { "code": "L741", "province": "IM", "name": "VENTIMIGLIA" },
    { "code": "L740", "province": "PA", "name": "VENTIMIGLIA DI SICILIA" },
    { "code": "L742", "province": "NA", "name": "VENTOTENE (soppresso)" },
    { "code": "L742", "province": "LT", "name": "VENTOTENE" },
    { "code": "L743", "province": "UD", "name": "VENZONE" },
    { "code": "L744", "province": "MI", "name": "VERANO (soppresso)" },
    { "code": "L745", "province": "TN", "name": "VERANO (soppresso)" },
    { "code": "L745", "province": "BZ", "name": "VERANO" },
    { "code": "L744", "province": "MI", "name": "VERANO BRIANZA (soppresso)" },
    { "code": "L744", "province": "MB", "name": "VERANO BRIANZA" },
    { "code": "L746", "province": "NO", "name": "VERBANIA (soppresso)" },
    { "code": "L746", "province": "VB", "name": "VERBANIA" },
    { "code": "L747", "province": "CS", "name": "VERBICARO" },
    { "code": "L748", "province": "CO", "name": "VERCANA" },
    { "code": "L749", "province": "SO", "name": "VERCEIA" },
    { "code": "L750", "province": "NO", "name": "VERCELLI (soppresso)" },
    { "code": "L750", "province": "VC", "name": "VERCELLI" },
    { "code": "L751", "province": "BG", "name": "VERCURAGO (soppresso)" },
    { "code": "L751", "province": "LC", "name": "VERCURAGO" },
    { "code": "L752", "province": "BG", "name": "VERDELLINO" },
    { "code": "L753", "province": "BG", "name": "VERDELLO" },
    { "code": "L754", "province": "CO", "name": "VERDERIO (soppresso)" },
    { "code": "M337", "province": "LC", "name": "VERDERIO" },
    { "code": "L755", "province": "CO", "name": "VERDERIO INFERIORE (soppresso)" },
    { "code": "L755", "province": "LC", "name": "VERDERIO INFERIORE (soppresso)" },
    { "code": "L756", "province": "CO", "name": "VERDERIO SUPERIORE (soppresso)" },
    { "code": "L756", "province": "LC", "name": "VERDERIO SUPERIORE (soppresso)" },
    { "code": "L757", "province": "TN", "name": "VERDESINA (soppresso)" },
    { "code": "L758", "province": "CN", "name": "VERDUNO" },
    { "code": "L759", "province": "GE", "name": "VEREZZI (soppresso)" },
    { "code": "L759", "province": "SV", "name": "VEREZZI (soppresso)" },
    { "code": "L761", "province": "NO", "name": "VERGANO NOVARESE (soppresso)" },
    { "code": "L762", "province": "BO", "name": "VERGATO" },
    { "code": "L763", "province": "MS", "name": "VERGEMOLI (soppresso)" },
    { "code": "L763", "province": "LU", "name": "VERGEMOLI (soppresso)" },
    { "code": "L764", "province": "FI", "name": "VERGHERETO (soppresso)" },
    { "code": "L764", "province": "FO", "name": "VERGHERETO (soppresso)" },
    { "code": "L764", "province": "FC", "name": "VERGHERETO" },
    { "code": "L765", "province": "MI", "name": "VERGIATE (soppresso)" },
    { "code": "L765", "province": "VA", "name": "VERGIATE" },
    { "code": "L767", "province": "CO", "name": "VERGOBBIO (soppresso)" },
    { "code": "L767", "province": "VA", "name": "VERGOBBIO (soppresso)" },
    { "code": "H840", "province": "CO", "name": "VERGOSA (soppresso)" },
    { "code": "L768", "province": "MI", "name": "VERMEZZO (soppresso)" },
    { "code": "M424", "province": "MI", "name": "VERMEZZO CON ZELO" },
    { "code": "L769", "province": "TN", "name": "VERMIGLIO" },
    { "code": "L770", "province": "CO", "name": "VERNA (soppresso)" },
    { "code": "L771", "province": "CN", "name": "VERNANTE" },
    { "code": "L772", "province": "PC", "name": "VERNASCA" },
    { "code": "L773", "province": "MI", "name": "VERNATE" },
    { "code": "L774", "province": "GE", "name": "VERNAZZA (soppresso)" },
    { "code": "L774", "province": "SP", "name": "VERNAZZA" },
    { "code": "L775", "province": "FI", "name": "VERNIO (soppresso)" },
    { "code": "L775", "province": "PO", "name": "VERNIO" },
    { "code": "L776", "province": "LE", "name": "VERNOLE" },
    { "code": "L777", "province": "BS", "name": "VEROLANUOVA" },
    { "code": "L778", "province": "BS", "name": "VEROLAVECCHIA" },
    { "code": "L779", "province": "TO", "name": "VEROLENGO" },
    { "code": "L780", "province": "RM", "name": "VEROLI (soppresso)" },
    { "code": "L780", "province": "FR", "name": "VEROLI" },
    { "code": "L781", "province": "VR", "name": "VERONA" },
    { "code": "D193", "province": "VR", "name": "VERONELLA" },
    { "code": "L782", "province": "GO", "name": "VERPOGLIANO (soppresso)" },
    { "code": "L782", "province": "UD", "name": "VERPOGLIANO (soppresso)" },
    { "code": "L783", "province": "TO", "name": "VERRAYES (soppresso)" },
    { "code": "L783", "province": "AO", "name": "VERRAYES" },
    { "code": "C282", "province": "TO", "name": "VERRES (soppresso)" },
    { "code": "C282", "province": "AO", "name": "VERRES" },
    { "code": "L784", "province": "PV", "name": "VERRETTO" },
    { "code": "L785", "province": "NO", "name": "VERRONE (soppresso)" },
    { "code": "L785", "province": "VC", "name": "VERRONE (soppresso)" },
    { "code": "L785", "province": "BI", "name": "VERRONE" },
    { "code": "L788", "province": "PV", "name": "VERRUA PO" },
    { "code": "L787", "province": "TO", "name": "VERRUA SAVOIA" },
    { "code": "L786", "province": "PV", "name": "VERRUA SICCOMARIO (soppresso)" },
    { "code": "L789", "province": "GO", "name": "VERSA (soppresso)" },
    { "code": "L789", "province": "UD", "name": "VERSA (soppresso)" },
    { "code": "L790", "province": "TN", "name": "VERSCIACO (soppresso)" },
    { "code": "L790", "province": "BZ", "name": "VERSCIACO (soppresso)" },
    { "code": "L791", "province": "CO", "name": "VERTEMATE (soppresso)" },
    { "code": "L792", "province": "CO", "name": "VERTEMATE CON MINOPRIO" },
    { "code": "L793", "province": "PL", "name": "VERTENEGLIO (soppresso)" },
    { "code": "L794", "province": "GO", "name": "VERTOIBA (soppresso)" },
    { "code": "L794", "province": "UD", "name": "VERTOIBA (soppresso)" },
    { "code": "L794", "province": "UD", "name": "VERTOIBA IN CAMPI SANTI (soppresso)" },
    { "code": "L794", "province": "GO", "name": "VERTOIBA IN CAMPI SANTI (soppresso)" },
    { "code": "L795", "province": "BG", "name": "VERTOVA" },
    { "code": "L796", "province": "GO", "name": "VERTOVINO (soppresso)" },
    { "code": "L796", "province": "UD", "name": "VERTOVINO (soppresso)" },
    { "code": "L797", "province": "FO", "name": "VERUCCHIO (soppresso)" },
    { "code": "L797", "province": "RN", "name": "VERUCCHIO" },
    { "code": "L798", "province": "NO", "name": "VERUNO (soppresso)" },
    { "code": "L799", "province": "SO", "name": "VERVIO" },
    { "code": "L800", "province": "TN", "name": "VERVO' (soppresso)" },
    { "code": "L801", "province": "UD", "name": "VERZEGNIS" },
    { "code": "L802", "province": "CZ", "name": "VERZINO (soppresso)" },
    { "code": "L802", "province": "KR", "name": "VERZINO" },
    { "code": "L804", "province": "CN", "name": "VERZUOLO" },
    { "code": "L805", "province": "PD", "name": "VESCOVANA" },
    { "code": "L806", "province": "CR", "name": "VESCOVATO" },
    { "code": "L807", "province": "AL", "name": "VESIME (soppresso)" },
    { "code": "L807", "province": "AT", "name": "VESIME" },
    { "code": "L808", "province": "NO", "name": "VESPOLATE" },
    { "code": "L809", "province": "IM", "name": "VESSALICO" },
    { "code": "L810", "province": "VR", "name": "VESTENANOVA" },
    { "code": "L811", "province": "TO", "name": "VESTIGNE'" },
    { "code": "L811", "province": "AO", "name": "VESTIGNE' (soppresso)" },
    { "code": "L812", "province": "BS", "name": "VESTONE" },
    { "code": "L813", "province": "CO", "name": "VESTRENO (soppresso)" },
    { "code": "L813", "province": "LC", "name": "VESTRENO (soppresso)" },
    { "code": "L814", "province": "RM", "name": "VETRALLA (soppresso)" },
    { "code": "L814", "province": "VT", "name": "VETRALLA" },
    { "code": "L815", "province": "RE", "name": "VETTO" },
    { "code": "L817", "province": "CN", "name": "VEZZA D'ALBA" },
    { "code": "L816", "province": "BS", "name": "VEZZA D'OGLIO" },
    { "code": "L821", "province": "TN", "name": "VEZZANO (soppresso)" },
    { "code": "L818", "province": "TN", "name": "VEZZANO (soppresso)" },
    { "code": "L818", "province": "BZ", "name": "VEZZANO (soppresso)" },
    { "code": "L818", "province": "TN", "name": "VEZZANO IN VENOSTA (soppresso)" },
    { "code": "L819", "province": "GE", "name": "VEZZANO LIGURE (soppresso)" },
    { "code": "L819", "province": "SP", "name": "VEZZANO LIGURE" },
    { "code": "L820", "province": "RE", "name": "VEZZANO SUL CROSTOLO" },
    { "code": "L822", "province": "GE", "name": "VEZZI (soppresso)" },
    { "code": "L823", "province": "GE", "name": "VEZZI PORTIO (soppresso)" },
    { "code": "L823", "province": "SV", "name": "VEZZI PORTIO" },
    { "code": "L824", "province": "NO", "name": "VEZZO (soppresso)" },
    { "code": "L825", "province": "CR", "name": "VHO (soppresso)" },
    { "code": "L826", "province": "MN", "name": "VIADANA" },
    { "code": "L827", "province": "BG", "name": "VIADANICA" },
    { "code": "L828", "province": "CT", "name": "VIAGRANDE" },
    { "code": "L829", "province": "AL", "name": "VIALE (soppresso)" },
    { "code": "L829", "province": "AT", "name": "VIALE" },
    { "code": "L830", "province": "TO", "name": "VIALFRE'" },
    { "code": "L830", "province": "AO", "name": "VIALFRE' (soppresso)" },
    { "code": "L831", "province": "RE", "name": "VIANO" },
    { "code": "L832", "province": "TN", "name": "VIARAGO (soppresso)" },
    { "code": "L833", "province": "LU", "name": "VIAREGGIO" },
    { "code": "L834", "province": "AL", "name": "VIARIGI (soppresso)" },
    { "code": "L834", "province": "AT", "name": "VIARIGI" },
    { "code": "F537", "province": "CZ", "name": "VIBO VALENTIA (soppresso)" },
    { "code": "F537", "province": "VV", "name": "VIBO VALENTIA" },
    { "code": "L835", "province": "SA", "name": "VIBONATI" },
    { "code": "L836", "province": "CE", "name": "VICALVI (soppresso)" },
    { "code": "L836", "province": "FR", "name": "VICALVI" },
    { "code": "L837", "province": "PA", "name": "VICARI" },
    { "code": "L838", "province": "FI", "name": "VICCHIO" },
    { "code": "L839", "province": "NO", "name": "VICENO (soppresso)" },
    { "code": "L840", "province": "VI", "name": "VICENZA" },
    { "code": "L548", "province": "TO", "name": "VICO CANAVESE (soppresso)" },
    { "code": "L548", "province": "AO", "name": "VICO CANAVESE (soppresso)" },
    { "code": "L842", "province": "FG", "name": "VICO DEL GARGANO" },
    { "code": "L844", "province": "CE", "name": "VICO DI PANTANO (soppresso)" },
    { "code": "L844", "province": "NA", "name": "VICO DI PANTANO (soppresso)" },
    { "code": "L845", "province": "NA", "name": "VICO EQUENSE" },
    { "code": "L843", "province": "RM", "name": "VICO NEL LAZIO (soppresso)" },
    { "code": "L843", "province": "FR", "name": "VICO NEL LAZIO" },
    { "code": "L841", "province": "CN", "name": "VICOFORTE" },
    { "code": "L846", "province": "TE", "name": "VICOLI (soppresso)" },
    { "code": "L846", "province": "PE", "name": "VICOLI" },
    { "code": "L847", "province": "NO", "name": "VICOLUNGO" },
    { "code": "L849", "province": "CO", "name": "VICONAGO (soppresso)" },
    { "code": "L849", "province": "VA", "name": "VICONAGO (soppresso)" },
    { "code": "L850", "province": "PI", "name": "VICOPISANO" },
    { "code": "L851", "province": "RM", "name": "VICOVARO" },
    { "code": "M259", "province": "SS", "name": "VIDDALBA" },
    { "code": "L854", "province": "PV", "name": "VIDIGULFO" },
    { "code": "L855", "province": "CR", "name": "VIDOLASCO (soppresso)" },
    { "code": "L856", "province": "TV", "name": "VIDOR" },
    { "code": "L857", "province": "TO", "name": "VIDRACCO" },
    { "code": "L857", "province": "AO", "name": "VIDRACCO (soppresso)" },
    { "code": "L858", "province": "FG", "name": "VIESTE" },
    { "code": "L859", "province": "PZ", "name": "VIETRI DI POTENZA" },
    { "code": "L860", "province": "SA", "name": "VIETRI SUL MARE" },
    { "code": "L863", "province": "TN", "name": "VIGALZANO (soppresso)" },
    { "code": "L864", "province": "NO", "name": "VIGANELLA (soppresso)" },
    { "code": "L864", "province": "VB", "name": "VIGANELLA (soppresso)" },
    { "code": "L866", "province": "CO", "name": "VIGANO' (soppresso)" },
    { "code": "L866", "province": "LC", "name": "VIGANO'" },
    { "code": "L865", "province": "BG", "name": "VIGANO SAN MARTINO" },
    { "code": "L868", "province": "FE", "name": "VIGARANO MAINARDA" },
    { "code": "L869", "province": "VR", "name": "VIGASIO" },
    { "code": "L870", "province": "PR", "name": "VIGATTO (soppresso)" },
    { "code": "L871", "province": "MI", "name": "VIGENTINO (soppresso)" },
    { "code": "L872", "province": "PV", "name": "VIGEVANO" },
    { "code": "L873", "province": "PZ", "name": "VIGGIANELLO" },
    { "code": "L874", "province": "PZ", "name": "VIGGIANO" },
    { "code": "L875", "province": "NO", "name": "VIGGIONA (soppresso)" },
    { "code": "L876", "province": "CO", "name": "VIGGIU' (soppresso)" },
    { "code": "L876", "province": "VA", "name": "VIGGIU'" },
    { "code": "L876", "province": "VA", "name": "VIGGIU' ED UNITI (soppresso)" },
    { "code": "L878", "province": "PD", "name": "VIGHIZZOLO D'ESTE" },
    { "code": "L880", "province": "NO", "name": "VIGLIANO BIELLESE (soppresso)" },
    { "code": "L880", "province": "VC", "name": "VIGLIANO BIELLESE (soppresso)" },
    { "code": "L880", "province": "BI", "name": "VIGLIANO BIELLESE" },
    { "code": "L879", "province": "AL", "name": "VIGLIANO D'ASTI (soppresso)" },
    { "code": "L879", "province": "AT", "name": "VIGLIANO D'ASTI" },
    { "code": "L881", "province": "AL", "name": "VIGNALE MONFERRATO" },
    { "code": "L882", "province": "RM", "name": "VIGNANELLO (soppresso)" },
    { "code": "L882", "province": "VT", "name": "VIGNANELLO" },
    { "code": "L883", "province": "MI", "name": "VIGNATE" },
    { "code": "L885", "province": "MO", "name": "VIGNOLA" },
    { "code": "L884", "province": "TN", "name": "VIGNOLA (soppresso)" },
    { "code": "L886", "province": "TN", "name": "VIGNOLA-FALESINA" },
    { "code": "L887", "province": "AL", "name": "VIGNOLE BORBERA" },
    { "code": "L888", "province": "CN", "name": "VIGNOLO" },
    { "code": "L889", "province": "NO", "name": "VIGNONE (soppresso)" },
    { "code": "L889", "province": "VB", "name": "VIGNONE" },
    { "code": "L890", "province": "BL", "name": "VIGO (soppresso)" },
    { "code": "L891", "province": "TN", "name": "VIGO D'ANAUNIA (soppresso)" },
    { "code": "L890", "province": "BL", "name": "VIGO DI CADORE" },
    { "code": "L893", "province": "TN", "name": "VIGO DI FASSA (soppresso)" },
    { "code": "L903", "province": "TN", "name": "VIGO RENDENA (soppresso)" },
    { "code": "L892", "province": "PD", "name": "VIGODARZERE" },
    { "code": "L894", "province": "BG", "name": "VIGOLO" },
    { "code": "L895", "province": "TN", "name": "VIGOLO BASELGA (soppresso)" },
    { "code": "L896", "province": "TN", "name": "VIGOLO VATTARO (soppresso)" },
    { "code": "L897", "province": "PC", "name": "VIGOLZONE" },
    { "code": "L898", "province": "TO", "name": "VIGONE" },
    { "code": "L899", "province": "VE", "name": "VIGONOVO" },
    { "code": "L900", "province": "PD", "name": "VIGONZA" },
    { "code": "L904", "province": "AL", "name": "VIGUZZOLO" },
    { "code": "L910", "province": "TN", "name": "VILLA AGNEDO (soppresso)" },
    { "code": "L911", "province": "TN", "name": "VILLA BANALE (soppresso)" },
    { "code": "L912", "province": "VR", "name": "VILLA BARTOLOMEA" },
    { "code": "L913", "province": "LU", "name": "VILLA BASILICA" },
    { "code": "L917", "province": "PV", "name": "VILLA BISCOSSI" },
    { "code": "L919", "province": "BS", "name": "VILLA CARCINA" },
    { "code": "L920", "province": "LE", "name": "VILLA CASTELLI (soppresso)" },
    { "code": "L920", "province": "BR", "name": "VILLA CASTELLI" },
    { "code": "L921", "province": "TO", "name": "VILLA CASTELNUOVO (soppresso)" },
    { "code": "L921", "province": "AO", "name": "VILLA CASTELNUOVO (soppresso)" },
    { "code": "L922", "province": "TE", "name": "VILLA CELIERA (soppresso)" },
    { "code": "L922", "province": "PE", "name": "VILLA CELIERA" },
    { "code": "L925", "province": "BS", "name": "VILLA COGOZZO (soppresso)" },
    { "code": "L926", "province": "MS", "name": "VILLA COLLEMANDINA (soppresso)" },
    { "code": "L926", "province": "LU", "name": "VILLA COLLEMANDINA" },
    { "code": "L927", "province": "AL", "name": "VILLA CORSIONE (soppresso)" },
    { "code": "L927", "province": "AT", "name": "VILLA CORSIONE (soppresso)" },
    { "code": "L928", "province": "MI", "name": "VILLA CORTESE" },
    { "code": "L929", "province": "BG", "name": "VILLA D'ADDA" },
    { "code": "L918", "province": "RO", "name": "VILLA D'ADIGE (soppresso)" },
    { "code": "L930", "province": "BS", "name": "VILLA D'ALLEGNO (soppresso)" },
    { "code": "A215", "province": "BG", "name": "VILLA D'ALME'" },
    { "code": "L932", "province": "PL", "name": "VILLA DECANI (soppresso)" },
    { "code": "L933", "province": "NO", "name": "VILLA DEL BOSCO (soppresso)" },
    { "code": "L933", "province": "VC", "name": "VILLA DEL BOSCO (soppresso)" },
    { "code": "L933", "province": "BI", "name": "VILLA DEL BOSCO" },
    { "code": "L934", "province": "PD", "name": "VILLA DEL CONTE" },
    { "code": "L935", "province": "FU", "name": "VILLA DEL NEVOSO (soppresso)" },
    { "code": "D801", "province": "CE", "name": "VILLA DI BRIANO" },
    { "code": "L907", "province": "SO", "name": "VILLA DI CHIAVENNA" },
    { "code": "L936", "province": "BG", "name": "VILLA DI SERIO" },
    { "code": "L908", "province": "SO", "name": "VILLA DI TIRANO" },
    { "code": "L938", "province": "BG", "name": "VILLA D'OGNA" },
    { "code": "L941", "province": "TN", "name": "VILLA D'UTA (soppresso)" },
    { "code": "L937", "province": "PD", "name": "VILLA ESTENSE" },
    { "code": "L943", "province": "IM", "name": "VILLA FARALDI" },
    { "code": "L956", "province": "CO", "name": "VILLA GUARDIA" },
    { "code": "E181", "province": "TN", "name": "VILLA IN SELVA (soppresso)" },
    { "code": "L957", "province": "TN", "name": "VILLA LAGARINA" },
    { "code": "A081", "province": "CE", "name": "VILLA LATINA (soppresso)" },
    { "code": "A081", "province": "FR", "name": "VILLA LATINA" },
    { "code": "L844", "province": "NA", "name": "VILLA LITERNO (soppresso)" },
    { "code": "L844", "province": "CE", "name": "VILLA LITERNO" },
    { "code": "L969", "province": "RE", "name": "VILLA MINOZZO" },
    { "code": "L941", "province": "TN", "name": "VILLA OTTONE (soppresso)" },
    { "code": "L941", "province": "BZ", "name": "VILLA OTTONE (soppresso)" },
    { "code": "F804", "province": "MN", "name": "VILLA POMA (soppresso)" },
    { "code": "M006", "province": "TN", "name": "VILLA RENDENA (soppresso)" },
    { "code": "M010", "province": "CO", "name": "VILLA ROMANO' (soppresso)" },
    { "code": "C592", "province": "AO", "name": "VILLA SAN ANSELMO (soppresso)" },
    { "code": "M017", "province": "MI", "name": "VILLA SAN FIORANO (soppresso)" },
    { "code": "M018", "province": "RC", "name": "VILLA SAN GIOVANNI" },
    { "code": "H913", "province": "VT", "name": "VILLA SAN GIOVANNI IN TUSCIA" },
    { "code": "H934", "province": "RC", "name": "VILLA SAN GIUSEPPE (soppresso)" },
    { "code": "I118", "province": "CA", "name": "VILLA SAN PIETRO" },
    { "code": "M019", "province": "AL", "name": "VILLA SAN SECONDO (soppresso)" },
    { "code": "M019", "province": "AT", "name": "VILLA SAN SECONDO" },
    { "code": "M020", "province": "TN", "name": "VILLA SANTA CATERINA (soppresso)" },
    { "code": "M020", "province": "BZ", "name": "VILLA SANTA CATERINA (soppresso)" },
    { "code": "L905", "province": "CE", "name": "VILLA SANTA LUCIA (soppresso)" },
    { "code": "L905", "province": "FR", "name": "VILLA SANTA LUCIA" },
    { "code": "M021", "province": "AQ", "name": "VILLA SANTA LUCIA DEGLI ABRUZZI" },
    { "code": "M022", "province": "CH", "name": "VILLA SANTA MARIA" },
    { "code": "M023", "province": "AQ", "name": "VILLA SANT'ANGELO" },
    { "code": "I298", "province": "OR", "name": "VILLA SANT'ANTONIO" },
    { "code": "L909", "province": "UD", "name": "VILLA SANTINA" },
    { "code": "I364", "province": "RM", "name": "VILLA SANTO STEFANO (soppresso)" },
    { "code": "I364", "province": "FR", "name": "VILLA SANTO STEFANO" },
    { "code": "M024", "province": "TS", "name": "VILLA SLAVINA (soppresso)" },
    { "code": "A609", "province": "CA", "name": "VILLA VERDE (soppresso)" },
    { "code": "A609", "province": "OR", "name": "VILLA VERDE" },
    { "code": "L760", "province": "CO", "name": "VILLA VERGANO (soppresso)" },
    { "code": "M034", "province": "UD", "name": "VILLA VICENTINA (soppresso)" },
    { "code": "M035", "province": "NA", "name": "VILLA VOLTURNO (soppresso)" },
    { "code": "M035", "province": "CE", "name": "VILLA VOLTURNO (soppresso)" },
    { "code": "L915", "province": "TN", "name": "VILLABASSA (soppresso)" },
    { "code": "L915", "province": "BZ", "name": "VILLABASSA" },
    { "code": "L914", "province": "TS", "name": "VILLABASSA DI SENOSECCHIA (soppresso)" },
    { "code": "L916", "province": "PA", "name": "VILLABATE" },
    { "code": "E503", "province": "AL", "name": "VILLABELLA (soppresso)" },
    { "code": "L923", "province": "BS", "name": "VILLACHIARA" },
    { "code": "L924", "province": "CA", "name": "VILLACIDRO (soppresso)" },
    { "code": "L924", "province": "VS", "name": "VILLACIDRO (soppresso)" },
    { "code": "L924", "province": "SU", "name": "VILLACIDRO" },
    { "code": "L931", "province": "AL", "name": "VILLADEATI" },
    { "code": "L939", "province": "RO", "name": "VILLADOSE" },
    { "code": "L906", "province": "NO", "name": "VILLADOSSOLA (soppresso)" },
    { "code": "L906", "province": "VB", "name": "VILLADOSSOLA" },
    { "code": "L942", "province": "CN", "name": "VILLAFALLETTO" },
    { "code": "L945", "province": "AL", "name": "VILLAFRANCA D'ASTI (soppresso)" },
    { "code": "L945", "province": "AT", "name": "VILLAFRANCA D'ASTI" },
    { "code": "L949", "province": "VR", "name": "VILLAFRANCA DI VERONA" },
    { "code": "L946", "province": "MS", "name": "VILLAFRANCA IN LUNIGIANA" },
    { "code": "L947", "province": "PD", "name": "VILLAFRANCA PADOVANA" },
    { "code": "L948", "province": "TO", "name": "VILLAFRANCA PIEMONTE" },
    { "code": "L948", "province": "TO", "name": "VILLAFRANCA SABAUDA (soppresso)" },
    { "code": "L944", "province": "AG", "name": "VILLAFRANCA SICULA" },
    { "code": "L950", "province": "ME", "name": "VILLAFRANCA TIRRENA" },
    { "code": "L951", "province": "PA", "name": "VILLAFRATI" },
    { "code": "L952", "province": "VI", "name": "VILLAGA" },
    { "code": "L953", "province": "CA", "name": "VILLAGRANDE STRISAILI (soppresso)" },
    { "code": "L953", "province": "NU", "name": "VILLAGRANDE STRISAILI" },
    { "code": "L953", "province": "OG", "name": "VILLAGRANDE STRISAILI (soppresso)" },
    { "code": "L955", "province": "IM", "name": "VILLAGUARDIA (soppresso)" },
    { "code": "L958", "province": "AQ", "name": "VILLALAGO" },
    { "code": "L959", "province": "CL", "name": "VILLALBA" },
    { "code": "L960", "province": "CO", "name": "VILL'ALBESE (soppresso)" },
    { "code": "L961", "province": "CH", "name": "VILLALFONSINA" },
    { "code": "L963", "province": "AL", "name": "VILLALVERNIA" },
    { "code": "L964", "province": "CH", "name": "VILLAMAGNA" },
    { "code": "L965", "province": "AV", "name": "VILLAMAINA" },
    { "code": "L966", "province": "CA", "name": "VILLAMAR (soppresso)" },
    { "code": "L966", "province": "VS", "name": "VILLAMAR (soppresso)" },
    { "code": "L966", "province": "SU", "name": "VILLAMAR" },
    { "code": "L967", "province": "RO", "name": "VILLAMARZANA" },
    { "code": "L968", "province": "CA", "name": "VILLAMASSARGIA (soppresso)" },
    { "code": "L968", "province": "CI", "name": "VILLAMASSARGIA (soppresso)" },
    { "code": "L968", "province": "SU", "name": "VILLAMASSARGIA" },
    { "code": "L970", "province": "AL", "name": "VILLAMIROGLIO" },
    { "code": "L971", "province": "TN", "name": "VILLANDRO (soppresso)" },
    { "code": "L971", "province": "BZ", "name": "VILLANDRO" },
    { "code": "L981", "province": "TO", "name": "VILLANEUVE (soppresso)" },
    { "code": "L981", "province": "AO", "name": "VILLANEUVE (soppresso)" },
    { "code": "L981", "province": "AO", "name": "VILLANOVA BALTEA (soppresso)" },
    { "code": "L978", "province": "NO", "name": "VILLANOVA BIELLESE (soppresso)" },
    { "code": "L978", "province": "VC", "name": "VILLANOVA BIELLESE (soppresso)" },
    { "code": "L978", "province": "BI", "name": "VILLANOVA BIELLESE" },
    { "code": "L982", "province": "TO", "name": "VILLANOVA CANAVESE" },
    { "code": "L975", "province": "GE", "name": "VILLANOVA D'ALBENGA (soppresso)" },
    { "code": "L975", "province": "SV", "name": "VILLANOVA D'ALBENGA" },
    { "code": "L983", "province": "PV", "name": "VILLANOVA D'ARDENGHI" },
    { "code": "L984", "province": "AT", "name": "VILLANOVA D'ASTI" },
    { "code": "L973", "province": "AV", "name": "VILLANOVA DEL BATTISTA" },
    { "code": "L985", "province": "RO", "name": "VILLANOVA DEL GHEBBO" },
    { "code": "L977", "province": "MI", "name": "VILLANOVA DEL SILLARO (soppresso)" },
    { "code": "L977", "province": "LO", "name": "VILLANOVA DEL SILLARO" },
    { "code": "L979", "province": "PD", "name": "VILLANOVA DI CAMPOSAMPIERO" },
    { "code": "L988", "province": "RO", "name": "VILLANOVA MARCHESANA" },
    { "code": "L974", "province": "CN", "name": "VILLANOVA MONDOVI'" },
    { "code": "L972", "province": "AL", "name": "VILLANOVA MONFERRATO" },
    { "code": "L989", "province": "SS", "name": "VILLANOVA MONTELEONE" },
    { "code": "L990", "province": "CN", "name": "VILLANOVA SOLARO" },
    { "code": "L980", "province": "PC", "name": "VILLANOVA SULL'ARDA" },
    { "code": "L991", "province": "CA", "name": "VILLANOVA TRUSCHEDU (soppresso)" },
    { "code": "L991", "province": "OR", "name": "VILLANOVA TRUSCHEDU" },
    { "code": "L992", "province": "CA", "name": "VILLANOVA TULO (soppresso)" },
    { "code": "L992", "province": "NU", "name": "VILLANOVA TULO (soppresso)" },
    { "code": "L992", "province": "SU", "name": "VILLANOVA TULO" },
    { "code": "L986", "province": "CA", "name": "VILLANOVAFORRU (soppresso)" },
    { "code": "L986", "province": "VS", "name": "VILLANOVAFORRU (soppresso)" },
    { "code": "L986", "province": "SU", "name": "VILLANOVAFORRU" },
    { "code": "L987", "province": "CA", "name": "VILLANOVAFRANCA (soppresso)" },
    { "code": "L987", "province": "VS", "name": "VILLANOVAFRANCA (soppresso)" },
    { "code": "L987", "province": "SU", "name": "VILLANOVAFRANCA" },
    { "code": "L993", "province": "CN", "name": "VILLANOVETTA (soppresso)" },
    { "code": "L994", "province": "PV", "name": "VILLANTERIO" },
    { "code": "L984", "province": "AL", "name": "VILLANUOVA D'ASTI (soppresso)" },
    { "code": "L984", "province": "AT", "name": "VILLANUOVA D'ASTI (soppresso)" },
    { "code": "L995", "province": "BS", "name": "VILLANUOVA SUL CLISI" },
    { "code": "M278", "province": "CA", "name": "VILLAPERUCCIO (soppresso)" },
    { "code": "M278", "province": "CI", "name": "VILLAPERUCCIO (soppresso)" },
    { "code": "M278", "province": "SU", "name": "VILLAPERUCCIO" },
    { "code": "B903", "province": "CS", "name": "VILLAPIANA" },
    { "code": "L998", "province": "CA", "name": "VILLAPUTZU (soppresso)" },
    { "code": "L998", "province": "SU", "name": "VILLAPUTZU" },
    { "code": "L999", "province": "TO", "name": "VILLAR DORA" },
    { "code": "M007", "province": "TO", "name": "VILLAR FOCCHIARDO" },
    { "code": "M013", "province": "TO", "name": "VILLAR PELLICE" },
    { "code": "M014", "province": "TO", "name": "VILLAR PEROSA" },
    { "code": "M015", "province": "CN", "name": "VILLAR SAN COSTANZO" },
    { "code": "M002", "province": "TO", "name": "VILLARBASSE" },
    { "code": "M003", "province": "NO", "name": "VILLARBOIT (soppresso)" },
    { "code": "M003", "province": "VC", "name": "VILLARBOIT" },
    { "code": "M004", "province": "TO", "name": "VILLAREGGIA" },
    { "code": "M004", "province": "AO", "name": "VILLAREGGIA (soppresso)" },
    { "code": "G309", "province": "NA", "name": "VILLARICCA" },
    { "code": "G760", "province": "CH", "name": "VILLARIELLI (soppresso)" },
    { "code": "E022", "province": "CA", "name": "VILLARIOS MASAINAS (soppresso)" },
    { "code": "M009", "province": "AL", "name": "VILLAROMAGNANO" },
    { "code": "M011", "province": "CL", "name": "VILLAROSA (soppresso)" },
    { "code": "M011", "province": "EN", "name": "VILLAROSA" },
    { "code": "M016", "province": "CA", "name": "VILLASALTO (soppresso)" },
    { "code": "M016", "province": "SU", "name": "VILLASALTO" },
    { "code": "M017", "province": "MI", "name": "VILLASANTA (soppresso)" },
    { "code": "M017", "province": "MB", "name": "VILLASANTA" },
    { "code": "B738", "province": "CA", "name": "VILLASIMIUS (soppresso)" },
    { "code": "B738", "province": "SU", "name": "VILLASIMIUS" },
    { "code": "M025", "province": "CA", "name": "VILLASOR (soppresso)" },
    { "code": "M025", "province": "SU", "name": "VILLASOR" },
    { "code": "M026", "province": "CA", "name": "VILLASPECIOSA (soppresso)" },
    { "code": "M026", "province": "SU", "name": "VILLASPECIOSA" },
    { "code": "M027", "province": "TO", "name": "VILLASTELLONE" },
    { "code": "M028", "province": "NO", "name": "VILLATA (soppresso)" },
    { "code": "M028", "province": "VC", "name": "VILLATA" },
    { "code": "M029", "province": "IM", "name": "VILLATALLA (soppresso)" },
    { "code": "M030", "province": "CA", "name": "VILLAURBANA (soppresso)" },
    { "code": "M030", "province": "OR", "name": "VILLAURBANA" },
    { "code": "M031", "province": "AQ", "name": "VILLAVALLELONGA" },
    { "code": "M032", "province": "VI", "name": "VILLAVERLA" },
    { "code": "F260", "province": "MI", "name": "VILLAVESCO (soppresso)" },
    { "code": "M033", "province": "IM", "name": "VILLAVIANI (soppresso)" },
    { "code": "M036", "province": "TN", "name": "VILLAZZANO (soppresso)" },
    { "code": "M363", "province": "TN", "name": "VILLE D'ANAUNIA" },
    { "code": "M037", "province": "TN", "name": "VILLE DEL MONTE (soppresso)" },
    { "code": "M038", "province": "UD", "name": "VILLE MONTEVECCHIO (soppresso)" },
    { "code": "M038", "province": "GO", "name": "VILLE MONTEVECCHIO (soppresso)" },
    { "code": "M039", "province": "IM", "name": "VILLE SAN PIETRO (soppresso)" },
    { "code": "M040", "province": "IM", "name": "VILLE SAN SEBASTIANO (soppresso)" },
    { "code": "L981", "province": "AO", "name": "VILLENEUVE" },
    { "code": "M043", "province": "GO", "name": "VILLESSE" },
    { "code": "M043", "province": "UD", "name": "VILLESSE (soppresso)" },
    { "code": "M041", "province": "AQ", "name": "VILLETTA BARREA" },
    { "code": "M042", "province": "NO", "name": "VILLETTE (soppresso)" },
    { "code": "M042", "province": "VB", "name": "VILLETTE" },
    { "code": "M044", "province": "MN", "name": "VILLIMPENTA" },
    { "code": "M045", "province": "BG", "name": "VILLONGO" },
    { "code": "M046", "province": "BG", "name": "VILLONGO SAN FILASTRO (soppresso)" },
    { "code": "M047", "province": "BG", "name": "VILLONGO SANT'ALESSANDRO (soppresso)" },
    { "code": "M048", "province": "TV", "name": "VILLORBA" },
    { "code": "M049", "province": "BG", "name": "VILMINORE (soppresso)" },
    { "code": "M050", "province": "BG", "name": "VILMINORE DI SCALVE" },
    { "code": "M052", "province": "MI", "name": "VIMERCATE (soppresso)" },
    { "code": "M052", "province": "MB", "name": "VIMERCATE" },
    { "code": "M053", "province": "MI", "name": "VIMODRONE" },
    { "code": "M054", "province": "CO", "name": "VIMOGNO (soppresso)" },
    { "code": "M055", "province": "CN", "name": "VINADIO" },
    { "code": "M057", "province": "CB", "name": "VINCHIATURO" },
    { "code": "M058", "province": "AL", "name": "VINCHIO (soppresso)" },
    { "code": "M058", "province": "AT", "name": "VINCHIO" },
    { "code": "M059", "province": "FI", "name": "VINCI" },
    { "code": "M060", "province": "TO", "name": "VINOVO" },
    { "code": "M061", "province": "NO", "name": "VINTEBBIO (soppresso)" },
    { "code": "M061", "province": "VC", "name": "VINTEBBIO (soppresso)" },
    { "code": "M062", "province": "NO", "name": "VINZAGLIO" },
    { "code": "M063", "province": "CN", "name": "VIOLA" },
    { "code": "M064", "province": "TN", "name": "VION (soppresso)" },
    { "code": "M065", "province": "BS", "name": "VIONE" },
    { "code": "M066", "province": "GO", "name": "VIPACCO (soppresso)" },
    { "code": "M066", "province": "UD", "name": "VIPACCO (soppresso)" },
    { "code": "M067", "province": "TN", "name": "VIPITENO (soppresso)" },
    { "code": "M067", "province": "BZ", "name": "VIPITENO" },
    { "code": "H123", "province": "MN", "name": "VIRGILIO (soppresso)" },
    { "code": "M069", "province": "TO", "name": "VIRLE PIEMONTE" },
    { "code": "M068", "province": "BS", "name": "VIRLE TREPONTI (soppresso)" },
    { "code": "M070", "province": "BS", "name": "VISANO" },
    { "code": "M071", "province": "TO", "name": "VISCHE" },
    { "code": "M071", "province": "AO", "name": "VISCHE (soppresso)" },
    { "code": "M072", "province": "CE", "name": "VISCIANO (soppresso)" },
    { "code": "M072", "province": "NA", "name": "VISCIANO" },
    { "code": "M073", "province": "UD", "name": "VISCO" },
    { "code": "M074", "province": "PL", "name": "VISIGNANO (soppresso)" },
    { "code": "M074", "province": "PL", "name": "VISIGNANO D'ISTRIA (soppresso)" },
    { "code": "M075", "province": "PL", "name": "VISINADA (soppresso)" },
    { "code": "M076", "province": "CO", "name": "VISINO (soppresso)" },
    { "code": "M077", "province": "AL", "name": "VISONE" },
    { "code": "M078", "province": "MC", "name": "VISSO" },
    { "code": "M078", "province": "PG", "name": "VISSO (soppresso)" },
    { "code": "M079", "province": "PV", "name": "VISTARINO" },
    { "code": "M080", "province": "TO", "name": "VISTRORIO" },
    { "code": "M080", "province": "AO", "name": "VISTRORIO (soppresso)" },
    { "code": "M081", "province": "TP", "name": "VITA" },
    { "code": "M082", "province": "RM", "name": "VITERBO (soppresso)" },
    { "code": "M082", "province": "VT", "name": "VITERBO" },
    { "code": "M083", "province": "CE", "name": "VITICUSO (soppresso)" },
    { "code": "M083", "province": "FR", "name": "VITICUSO" },
    { "code": "M084", "province": "CE", "name": "VITICUSO ED ACQUAFONDATA (soppresso)" },
    { "code": "M085", "province": "UD", "name": "VITO D'ASIO (soppresso)" },
    { "code": "M085", "province": "PN", "name": "VITO D'ASIO" },
    { "code": "M086", "province": "RM", "name": "VITORCHIANO (soppresso)" },
    { "code": "M086", "province": "VT", "name": "VITORCHIANO" },
    { "code": "M087", "province": "MI", "name": "VITTADONE (soppresso)" },
    { "code": "M088", "province": "SR", "name": "VITTORIA (soppresso)" },
    { "code": "M088", "province": "RG", "name": "VITTORIA" },
    { "code": "M089", "province": "TV", "name": "VITTORIO (soppresso)" },
    { "code": "M089", "province": "TV", "name": "VITTORIO VENETO" },
    { "code": "M090", "province": "AQ", "name": "VITTORITO" },
    { "code": "M091", "province": "MI", "name": "VITTUONE" },
    { "code": "M093", "province": "BN", "name": "VITULANO" },
    { "code": "M092", "province": "CE", "name": "VITULAZIO" },
    { "code": "M092", "province": "NA", "name": "VITULAZIO (soppresso)" },
    { "code": "M094", "province": "TO", "name": "VIU'" },
    { "code": "M096", "province": "UD", "name": "VIVARO (soppresso)" },
    { "code": "M096", "province": "PN", "name": "VIVARO" },
    { "code": "M095", "province": "RM", "name": "VIVARO ROMANO" },
    { "code": "M098", "province": "NO", "name": "VIVERONE (soppresso)" },
    { "code": "M098", "province": "VC", "name": "VIVERONE (soppresso)" },
    { "code": "M098", "province": "BI", "name": "VIVERONE" },
    { "code": "M099", "province": "TN", "name": "VIZZE (soppresso)" },
    { "code": "M099", "province": "BZ", "name": "VIZZE (soppresso)" },
    { "code": "M100", "province": "CT", "name": "VIZZINI" },
    { "code": "M101", "province": "MI", "name": "VIZZOLA TICINO (soppresso)" },
    { "code": "M101", "province": "VA", "name": "VIZZOLA TICINO" },
    { "code": "M102", "province": "MI", "name": "VIZZOLO PREDABISSI" },
    { "code": "M103", "province": "PD", "name": "VO'" },
    { "code": "M104", "province": "BS", "name": "VOBARNO" },
    { "code": "M105", "province": "GE", "name": "VOBBIA" },
    { "code": "M106", "province": "NO", "name": "VOCCA (soppresso)" },
    { "code": "M106", "province": "VC", "name": "VOCCA" },
    { "code": "M107", "province": "NO", "name": "VOCOGNO E PRESTINONE (soppresso)" },
    { "code": "M108", "province": "BL", "name": "VODO CADORE" },
    { "code": "M109", "province": "PV", "name": "VOGHERA" },
    { "code": "M038", "province": "GO", "name": "VOGHERSCA (soppresso)" },
    { "code": "M038", "province": "UD", "name": "VOGHERSCA (soppresso)" },
    { "code": "M110", "province": "FE", "name": "VOGHIERA" },
    { "code": "M111", "province": "NO", "name": "VOGOGNA (soppresso)" },
    { "code": "M111", "province": "VB", "name": "VOGOGNA" },
    { "code": "M112", "province": "GO", "name": "VOISCHIZZA (soppresso)" },
    { "code": "M112", "province": "UD", "name": "VOISCHIZZA (soppresso)" },
    { "code": "M112", "province": "UD", "name": "VOISSIZZA DI COMENO (soppresso)" },
    { "code": "M112", "province": "GO", "name": "VOISSIZZA DI COMENO (soppresso)" },
    { "code": "M113", "province": "TN", "name": "VOLANO" },
    { "code": "H484", "province": "BS", "name": "VOLCIANO (soppresso)" },
    { "code": "M114", "province": "CO", "name": "VOLDOMINO (soppresso)" },
    { "code": "M114", "province": "VA", "name": "VOLDOMINO (soppresso)" },
    { "code": "M115", "province": "NA", "name": "VOLLA" },
    { "code": "M116", "province": "CR", "name": "VOLONGO" },
    { "code": "M117", "province": "FU", "name": "VOLOSCA-ABBAZIA (soppresso)" },
    { "code": "M117", "province": "PL", "name": "VOLOSCA-ABBAZIA (soppresso)" },
    { "code": "M118", "province": "TV", "name": "VOLPAGO (soppresso)" },
    { "code": "M118", "province": "TV", "name": "VOLPAGO DEL MONTELLO" },
    { "code": "M119", "province": "PV", "name": "VOLPARA" },
    { "code": "M120", "province": "AL", "name": "VOLPEDO" },
    { "code": "M121", "province": "AL", "name": "VOLPEGLINO" },
    { "code": "M122", "province": "TO", "name": "VOLPIANO" },
    { "code": "M125", "province": "MN", "name": "VOLTA MANTOVANA" },
    { "code": "M123", "province": "AL", "name": "VOLTAGGIO" },
    { "code": "M124", "province": "BL", "name": "VOLTAGO (soppresso)" },
    { "code": "M124", "province": "BL", "name": "VOLTAGO AGORDINO" },
    { "code": "M126", "province": "PI", "name": "VOLTERRA" },
    { "code": "M127", "province": "CR", "name": "VOLTIDO" },
    { "code": "M128", "province": "CO", "name": "VOLTORE (soppresso)" },
    { "code": "M128", "province": "VA", "name": "VOLTORE (soppresso)" },
    { "code": "M129", "province": "GE", "name": "VOLTRI (soppresso)" },
    { "code": "M131", "province": "FG", "name": "VOLTURARA APPULA" },
    { "code": "M130", "province": "AV", "name": "VOLTURARA IRPINA" },
    { "code": "M132", "province": "FG", "name": "VOLTURINO" },
    { "code": "M133", "province": "TO", "name": "VOLVERA" },
    { "code": "M134", "province": "GO", "name": "VOLZANA (soppresso)" },
    { "code": "M134", "province": "UD", "name": "VOLZANA (soppresso)" },
    { "code": "M135", "province": "GO", "name": "VOSCHIA (soppresso)" },
    { "code": "M135", "province": "UD", "name": "VOSCHIA (soppresso)" },
    { "code": "M136", "province": "CN", "name": "VOTTIGNASCO" },
    { "code": "F652", "province": "GO", "name": "VRABICE (soppresso)" },
    { "code": "F652", "province": "UD", "name": "VRABICE (soppresso)" },
    { "code": "M138", "province": "CZ", "name": "ZACCANOPOLI (soppresso)" },
    { "code": "M138", "province": "VV", "name": "ZACCANOPOLI" },
    { "code": "M139", "province": "CT", "name": "ZAFFERANA ETNEA" },
    { "code": "M140", "province": "CZ", "name": "ZAGARISE" },
    { "code": "M141", "province": "RM", "name": "ZAGAROLO" },
    { "code": "M142", "province": "TN", "name": "ZAMBANA (soppresso)" },
    { "code": "M143", "province": "CZ", "name": "ZAMBRONE (soppresso)" },
    { "code": "M143", "province": "VV", "name": "ZAMBRONE" },
    { "code": "M144", "province": "BG", "name": "ZANDOBBIO" },
    { "code": "M145", "province": "VI", "name": "ZANE'" },
    { "code": "M147", "province": "BG", "name": "ZANICA" },
    { "code": "M148", "province": "CR", "name": "ZAPPELLO (soppresso)" },
    { "code": "M267", "province": "FG", "name": "ZAPPONETA" },
    { "code": "M149", "province": "ZA", "name": "ZARA (soppresso)" },
    { "code": "M150", "province": "PV", "name": "ZAVATTARELLO" },
    { "code": "M150", "province": "PC", "name": "ZAVATTARELLO (soppresso)" },
    { "code": "M151", "province": "PV", "name": "ZAVATTARELLO VALVERDE (soppresso)" },
    { "code": "M152", "province": "PV", "name": "ZECCONE" },
    { "code": "M153", "province": "CA", "name": "ZEDDIANI (soppresso)" },
    { "code": "M153", "province": "OR", "name": "ZEDDIANI" },
    { "code": "C590", "province": "TN", "name": "ZEDES (soppresso)" },
    { "code": "M154", "province": "VE", "name": "ZELARINO (soppresso)" },
    { "code": "M156", "province": "CO", "name": "ZELBIO" },
    { "code": "M157", "province": "CO", "name": "ZELBIO-VELESO (soppresso)" },
    { "code": "M158", "province": "MI", "name": "ZELO BUON PERSICO (soppresso)" },
    { "code": "M158", "province": "LO", "name": "ZELO BUON PERSICO" },
    { "code": "M160", "province": "MI", "name": "ZELO SURRIGONE (soppresso)" },
    { "code": "M161", "province": "PV", "name": "ZEME" },
    { "code": "M162", "province": "PV", "name": "ZENEVREDO" },
    { "code": "M163", "province": "TV", "name": "ZENSON DI PIAVE" },
    { "code": "M164", "province": "CA", "name": "ZEPPARA (soppresso)" },
    { "code": "M165", "province": "PV", "name": "ZERBA (soppresso)" },
    { "code": "M165", "province": "PC", "name": "ZERBA" },
    { "code": "M166", "province": "PV", "name": "ZERBO" },
    { "code": "M167", "province": "PV", "name": "ZERBOLO'" },
    { "code": "M168", "province": "CA", "name": "ZERFALIU (soppresso)" },
    { "code": "M168", "province": "OR", "name": "ZERFALIU" },
    { "code": "M169", "province": "MS", "name": "ZERI" },
    { "code": "M170", "province": "VI", "name": "ZERMEGHEDO" },
    { "code": "M171", "province": "TV", "name": "ZERO BRANCO" },
    { "code": "M172", "province": "VR", "name": "ZEVIO" },
    { "code": "L848", "province": "PC", "name": "ZIANO (soppresso)" },
    { "code": "M173", "province": "TN", "name": "ZIANO (soppresso)" },
    { "code": "M173", "province": "TN", "name": "ZIANO DI FIEMME" },
    { "code": "L848", "province": "PC", "name": "ZIANO PIACENTINO" },
    { "code": "M174", "province": "PR", "name": "ZIBELLO (soppresso)" },
    { "code": "M176", "province": "MI", "name": "ZIBIDO SAN GIACOMO" },
    { "code": "M177", "province": "GE", "name": "ZIGNAGO (soppresso)" },
    { "code": "M177", "province": "SP", "name": "ZIGNAGO" },
    { "code": "M178", "province": "VR", "name": "ZIMELLA" },
    { "code": "M179", "province": "NO", "name": "ZIMONE (soppresso)" },
    { "code": "M179", "province": "VC", "name": "ZIMONE (soppresso)" },
    { "code": "M179", "province": "BI", "name": "ZIMONE" },
    { "code": "M180", "province": "PV", "name": "ZINASCO" },
    { "code": "M181", "province": "MI", "name": "ZIVIDO (soppresso)" },
    { "code": "M182", "province": "GE", "name": "ZOAGLI" },
    { "code": "M183", "province": "MO", "name": "ZOCCA" },
    { "code": "M184", "province": "BG", "name": "ZOGNO" },
    { "code": "M185", "province": "BO", "name": "ZOLA PREDOSA" },
    { "code": "I345", "province": "BL", "name": "ZOLDO ALTO (soppresso)" },
    { "code": "M186", "province": "GO", "name": "ZOLLA (soppresso)" },
    { "code": "M186", "province": "UD", "name": "ZOLLA (soppresso)" },
    { "code": "M187", "province": "LE", "name": "ZOLLINO" },
    { "code": "M188", "province": "BS", "name": "ZONE" },
    { "code": "M189", "province": "BL", "name": "ZOPPE' (soppresso)" },
    { "code": "M189", "province": "BL", "name": "ZOPPE' DI CADORE" },
    { "code": "M190", "province": "UD", "name": "ZOPPOLA (soppresso)" },
    { "code": "M190", "province": "PN", "name": "ZOPPOLA" },
    { "code": "M191", "province": "MI", "name": "ZORLESCO (soppresso)" },
    { "code": "M192", "province": "NO", "name": "ZORNASCO (soppresso)" },
    { "code": "M193", "province": "BG", "name": "ZORZINO (soppresso)" },
    { "code": "M194", "province": "VI", "name": "ZOVENCEDO" },
    { "code": "M195", "province": "NO", "name": "ZOVERALLO (soppresso)" },
    { "code": "M196", "province": "NO", "name": "ZUBIENA (soppresso)" },
    { "code": "M196", "province": "VC", "name": "ZUBIENA (soppresso)" },
    { "code": "M196", "province": "BI", "name": "ZUBIENA" },
    { "code": "M197", "province": "GE", "name": "ZUCCARELLO (soppresso)" },
    { "code": "M197", "province": "SV", "name": "ZUCCARELLO" },
    { "code": "M198", "province": "TN", "name": "ZUCLO (soppresso)" },
    { "code": "M199", "province": "VI", "name": "ZUGLIANO" },
    { "code": "M200", "province": "UD", "name": "ZUGLIO" },
    { "code": "M201", "province": "NO", "name": "ZUMAGLIA (soppresso)" },
    { "code": "M201", "province": "VC", "name": "ZUMAGLIA (soppresso)" },
    { "code": "M201", "province": "BI", "name": "ZUMAGLIA" },
    { "code": "M202", "province": "CS", "name": "ZUMPANO" },
    { "code": "M203", "province": "AV", "name": "ZUNGOLI" },
    { "code": "M204", "province": "CZ", "name": "ZUNGRI (soppresso)" },
    { "code": "M204", "province": "VV", "name": "ZUNGRI" },
    { "code": "M206", "province": "CA", "name": "ZURI (soppresso)" },
]

_COUNTRIES = [
    { "code":"Z100", "province":"EE", "name":"ALBANIA", },
    { "code":"Z101", "province":"EE", "name":"ANDORRA", },
    { "code":"Z102", "province":"EE", "name":"AUSTRIA", },
    { "code":"Z103", "province":"EE", "name":"BELGIO", },
    { "code":"Z104", "province":"EE", "name":"BULGARIA", },
    { "code":"Z105", "province":"EE", "name":"CECOSLOVACCHIA", },
    { "code":"Z106", "province":"EE", "name":"CITTA DEL VATICANO / VATICANO", },
    { "code":"Z107", "province":"EE", "name":"DANIMARCA", },
    { "code":"Z108", "province":"EE", "name":"FAER OER", },
    { "code":"Z109", "province":"EE", "name":"FINLANDIA", },
    { "code":"Z110", "province":"EE", "name":"FRANCIA", },
    { "code":"Z111", "province":"EE", "name":"GERMANIA REP. DEMOCRATICA", },
    { "code":"Z112", "province":"EE", "name":"GERMANIA REP. FEDERALE / GERMANIA", },
    { "code":"Z113", "province":"EE", "name":"GIBILTERRA", },
    { "code":"Z114", "province":"EE", "name":"GRAN BRETAGNA", },
    { "code":"Z115", "province":"EE", "name":"GRECIA", },
    { "code":"Z116", "province":"EE", "name":"IRLANDA", },
    { "code":"Z117", "province":"EE", "name":"ISLANDA", },
    { "code":"Z118", "province":"EE", "name":"IUGOSLAVIA", },
    { "code":"Z119", "province":"EE", "name":"LIECHTENSTEIN", },
    { "code":"Z120", "province":"EE", "name":"LUSSEMBURGO", },
    { "code":"Z121", "province":"EE", "name":"MALTA", },
    { "code":"Z122", "province":"EE", "name":"MAN", },
    { "code":"Z123", "province":"EE", "name":"MONACO", },
    { "code":"Z124", "province":"EE", "name":"NORMANNE", },
    { "code":"Z125", "province":"EE", "name":"NORVEGIA", },
    { "code":"Z126", "province":"EE", "name":"PAESI BASSI", },
    { "code":"Z127", "province":"EE", "name":"POLONIA", },
    { "code":"Z128", "province":"EE", "name":"PORTOGALLO", },
    { "code":"Z129", "province":"EE", "name":"ROMANIA", },
    { "code":"Z130", "province":"EE", "name":"SAN MARINO", },
    { "code":"Z131", "province":"EE", "name":"SPAGNA", },
    { "code":"Z132", "province":"EE", "name":"SVEZIA", },
    { "code":"Z133", "province":"EE", "name":"SVIZZERA", },
    { "code":"Z134", "province":"EE", "name":"UNGHERIA", },
    { "code":"Z135", "province":"EE", "name":"URSS", },
    { "code":"Z136", "province":"EE", "name":"GEORGIA", },
    { "code":"Z137", "province":"EE", "name":"ARMENIA", },
    { "code":"Z138", "province":"EE", "name":"UCRAINA", },
    { "code":"Z139", "province":"EE", "name":"BIELORUSSIA", },
    { "code":"Z140", "province":"EE", "name":"MOLDAVIA", },
    { "code":"Z141", "province":"EE", "name":"AZERBAIDJAN", },
    { "code":"Z142", "province":"EE", "name":"KIRGHIZISTAN", },
    { "code":"Z143", "province":"EE", "name":"UZBEKISTAN", },
    { "code":"Z144", "province":"EE", "name":"ESTONIA", },
    { "code":"Z145", "province":"EE", "name":"LETTONIA", },
    { "code":"Z146", "province":"EE", "name":"LITUANIA", },
    { "code":"Z147", "province":"EE", "name":"TAGIKISTAN", },
    { "code":"Z148", "province":"EE", "name":"MACEDONIA", },
    { "code":"Z149", "province":"EE", "name":"CROAZIA", },
    { "code":"Z150", "province":"EE", "name":"SLOVENIA", },
    { "code":"Z151", "province":"EE", "name":"TURKEMENISTAN", },
    { "code":"Z152", "province":"EE", "name":"KAZAKISTAN", },
    { "code":"Z153", "province":"EE", "name":"BOSNIA ED ERZEGOVINA / BOSNIA ERZEGOVINA", },
    { "code":"Z154", "province":"EE", "name":"RUSSIA / FEDERAZIONE RUSSA", },
    { "code":"Z155", "province":"EE", "name":"REPUBBLICA SLOVACCA", },
    { "code":"Z156", "province":"EE", "name":"REPUBBLICA CECA", },
    { "code":"Z200", "province":"EE", "name":"AFGHANISTAN", },
    { "code":"Z201", "province":"EE", "name":"ARABIA MERIDIONALE", },
    { "code":"Z202", "province":"EE", "name":"PROTETTORATO DELLA ARABIA MERIDIONALE", },
    { "code":"Z203", "province":"EE", "name":"ARABIA SAUDITA", },
    { "code":"Z204", "province":"EE", "name":"BAHREIN", },
    { "code":"Z205", "province":"EE", "name":"BHUTAN", },
    { "code":"Z206", "province":"EE", "name":"BIRMANIA", },
    { "code":"Z207", "province":"EE", "name":"BRUNEI", },
    { "code":"Z208", "province":"EE", "name":"CAMBOGIA", },
    { "code":"Z209", "province":"EE", "name":"SRI LANKA", },
    { "code":"Z210", "province":"EE", "name":"CINA REPUBBLICA POPOLARE / CINA / CHINA", },
    { "code":"Z211", "province":"EE", "name":"CIPRO", },
    { "code":"Z212", "province":"EE", "name":"COCOS", },
    { "code":"Z213", "province":"EE", "name":"REPUBBLICA DI COREA", },
    { "code":"Z214", "province":"EE", "name":"COREA REPUBBLICA POPOLARE", },
    { "code":"Z215", "province":"EE", "name":"EMIRATI ARABI UNITI", },
    { "code":"Z216", "province":"EE", "name":"FILIPPINE", },
    { "code":"Z217", "province":"EE", "name":"CINA REPUBBLICA NAZIONALE", },
    { "code":"Z218", "province":"EE", "name":"TERRITORIO DI GAZA", },
    { "code":"Z219", "province":"EE", "name":"GIAPPONE", },
    { "code":"Z220", "province":"EE", "name":"GIORDANIA", },
    { "code":"Z221", "province":"EE", "name":"HONG KONG", },
    { "code":"Z222", "province":"EE", "name":"INDIA", },
    { "code":"Z223", "province":"EE", "name":"INDONESIA", },
    { "code":"Z224", "province":"EE", "name":"IRAN", },
    { "code":"Z225", "province":"EE", "name":"IRAQ", },
    { "code":"Z226", "province":"EE", "name":"ISRAELE", },
    { "code":"Z227", "province":"EE", "name":"KUWAIT", },
    { "code":"Z228", "province":"EE", "name":"LAOS", },
    { "code":"Z229", "province":"EE", "name":"LIBANO", },
    { "code":"Z230", "province":"EE", "name":"MALESIA", },
    { "code":"Z231", "province":"EE", "name":"MACAO", },
    { "code":"Z232", "province":"EE", "name":"MALDIVE", },
    { "code":"Z233", "province":"EE", "name":"MONGOLIA REP. POPOLARE", },
    { "code":"Z234", "province":"EE", "name":"NEPAL", },
    { "code":"Z235", "province":"EE", "name":"OMAN", },
    { "code":"Z236", "province":"EE", "name":"PAKISTAN", },
    { "code":"Z237", "province":"EE", "name":"QATAR", },
    { "code":"Z238", "province":"EE", "name":"RYUKYU", },
    { "code":"Z239", "province":"EE", "name":"SIKKIM", },
    { "code":"Z240", "province":"EE", "name":"SIRIA", },
    { "code":"Z241", "province":"EE", "name":"THAILANDIA", },
    { "code":"Z242", "province":"EE", "name":"TIMOR", },
    { "code":"Z243", "province":"EE", "name":"TURCHIA", },
    { "code":"Z244", "province":"EE", "name":"VIETNAM DEL SUD", },
    { "code":"Z245", "province":"EE", "name":"VIETNAM DEL NORD", },
    { "code":"Z246", "province":"EE", "name":"YEMEN", },
    { "code":"Z247", "province":"EE", "name":"MALAYSIA", },
    { "code":"Z248", "province":"EE", "name":"SINGAPORE", },
    { "code":"Z249", "province":"EE", "name":"BANGLADESH", },
    { "code":"Z250", "province":"EE", "name":"YEMEN REP. DEM. POPOLARE", },
    { "code":"Z251", "province":"EE", "name":"VIETNAM", },
    { "code":"Z300", "province":"EE", "name":"NAMIBIA", },
    { "code":"Z301", "province":"EE", "name":"ALGERIA", },
    { "code":"Z302", "province":"EE", "name":"ANGOLA", },
    { "code":"Z303", "province":"EE", "name":"BASUTOLAND SUD AFRICA BRITANNICO", },
    { "code":"Z304", "province":"EE", "name":"BECIUANIA SUD AFRICA BRITANNICO", },
    { "code":"Z305", "province":"EE", "name":"BURUNDI", },
    { "code":"Z306", "province":"EE", "name":"CAMERUN", },
    { "code":"Z307", "province":"EE", "name":"CAPO VERDE", },
    { "code":"Z308", "province":"EE", "name":"IMPERO CENTROAFRICANO", },
    { "code":"Z309", "province":"EE", "name":"CIAD", },
    { "code":"Z310", "province":"EE", "name":"COMORE", },
    { "code":"Z311", "province":"EE", "name":"CONGO REPUBBLICA POPOLARE", },
    { "code":"Z312", "province":"EE", "name":"ZAIRE", },
    { "code":"Z313", "province":"EE", "name":"COSTA D'AVORIO", },
    { "code":"Z314", "province":"EE", "name":"BENIN", },
    { "code":"Z315", "province":"EE", "name":"ETIOPIA", },
    { "code":"Z316", "province":"EE", "name":"GABON", },
    { "code":"Z317", "province":"EE", "name":"GAMBIA", },
    { "code":"Z318", "province":"EE", "name":"GHANA", },
    { "code":"Z319", "province":"EE", "name":"GUINEA", },
    { "code":"Z320", "province":"EE", "name":"GUINEA BISSAU", },
    { "code":"Z321", "province":"EE", "name":"GUINEA EQUATORIALE", },
    { "code":"Z322", "province":"EE", "name":"KENYA", },
    { "code":"Z323", "province":"EE", "name":"IFNI", },
    { "code":"Z324", "province":"EE", "name":"LA REUNION", },
    { "code":"Z325", "province":"EE", "name":"LIBERIA", },
    { "code":"Z326", "province":"EE", "name":"LIBIA", },
    { "code":"Z327", "province":"EE", "name":"MADAGASCAR", },
    { "code":"Z328", "province":"EE", "name":"MALAWI", },
    { "code":"Z329", "province":"EE", "name":"MALI", },
    { "code":"Z330", "province":"EE", "name":"MAROCCO", },
    { "code":"Z331", "province":"EE", "name":"MAURITANIA", },
    { "code":"Z332", "province":"EE", "name":"MAURIZIO", },
    { "code":"Z333", "province":"EE", "name":"MOZAMBICO", },
    { "code":"Z334", "province":"EE", "name":"NIGER", },
    { "code":"Z335", "province":"EE", "name":"NIGERIA", },
    { "code":"Z336", "province":"EE", "name":"EGITTO", },
    { "code":"Z337", "province":"EE", "name":"ZIMBABWE", },
    { "code":"Z338", "province":"EE", "name":"RUANDA", },
    { "code":"Z339", "province":"EE", "name":"SAHARA SPAGNOLO", },
    { "code":"Z340", "province":"EE", "name":"SANT ELENA", },
    { "code":"Z341", "province":"EE", "name":"PRINCIPE", },
    { "code":"Z342", "province":"EE", "name":"SEICELLE", },
    { "code":"Z343", "province":"EE", "name":"SENEGAL", },
    { "code":"Z344", "province":"EE", "name":"SIERRA LEONE", },
    { "code":"Z345", "province":"EE", "name":"SOMALIA", },
    { "code":"Z346", "province":"EE", "name":"SOMALIA FRANCESE", },
    { "code":"Z347", "province":"EE", "name":"REPUBBLICA SUDAFRICANA", },
    { "code":"Z348", "province":"EE", "name":"SUDAN", },
    { "code":"Z349", "province":"EE", "name":"SWAZILAND", },
    { "code":"Z350", "province":"EE", "name":"TANGANICA", },
    { "code":"Z351", "province":"EE", "name":"TOGO", },
    { "code":"Z352", "province":"EE", "name":"TUNISIA", },
    { "code":"Z353", "province":"EE", "name":"UGANDA", },
    { "code":"Z354", "province":"EE", "name":"BURKINA FASO", },
    { "code":"Z355", "province":"EE", "name":"ZAMBIA", },
    { "code":"Z356", "province":"EE", "name":"ZANZIBAR", },
    { "code":"Z357", "province":"EE", "name":"TANZANIA", },
    { "code":"Z358", "province":"EE", "name":"BOTSWANA", },
    { "code":"Z359", "province":"EE", "name":"LESOTHO", },
    { "code":"Z360", "province":"EE", "name":"MAYOTTE", },
    { "code":"Z361", "province":"EE", "name":"GIBUTI", },
    { "code":"Z362", "province":"EE", "name":"SAHARA MERIDIONALE", },
    { "code":"Z363", "province":"EE", "name":"SAHARA SETTENTRIONALE", },
    { "code":"Z364", "province":"EE", "name":"BOPHUTHATSWANA", },
    { "code":"Z365", "province":"EE", "name":"TRANSKEI", },
    { "code":"Z366", "province":"EE", "name":"VENDA", },
    { "code":"Z367", "province":"EE", "name":"CISKEI", },
    { "code":"Z368", "province":"EE", "name":"ERITREA", },
    { "code":"Z400", "province":"EE", "name":"BERMUDE", },
    { "code":"Z401", "province":"EE", "name":"CANADA", },
    { "code":"Z402", "province":"EE", "name":"GROENLANDIA", },
    { "code":"Z403", "province":"EE", "name":"SAINT PIERRE ET MIQUELON", },
    { "code":"Z404", "province":"EE", "name":"STATI UNITI D'AMERICA", },
    { "code":"Z500", "province":"EE", "name":"ANTILLE BRITANNICHE", },
    { "code":"Z501", "province":"EE", "name":"ANTILLE OLANDESI", },
    { "code":"Z502", "province":"EE", "name":"BAHAMA", },
    { "code":"Z503", "province":"EE", "name":"COSTA RICA", },
    { "code":"Z504", "province":"EE", "name":"CUBA", },
    { "code":"Z505", "province":"EE", "name":"REPUBBLICA DOMINICANA", },
    { "code":"Z506", "province":"EE", "name":"EL SALVADOR", },
    { "code":"Z507", "province":"EE", "name":"GIAMAICA", },
    { "code":"Z508", "province":"EE", "name":"GUADALUPA", },
    { "code":"Z509", "province":"EE", "name":"GUATEMALA", },
    { "code":"Z510", "province":"EE", "name":"HAITI", },
    { "code":"Z511", "province":"EE", "name":"HONDURAS", },
    { "code":"Z512", "province":"EE", "name":"BELIZE", },
    { "code":"Z513", "province":"EE", "name":"MARTINICA", },
    { "code":"Z514", "province":"EE", "name":"MESSICO", },
    { "code":"Z515", "province":"EE", "name":"NICARAGUA", },
    { "code":"Z516", "province":"EE", "name":"PANAMA", },
    { "code":"Z517", "province":"EE", "name":"PANAMA ZONA DEL CANALE", },
    { "code":"Z518", "province":"EE", "name":"PUERTO RICO", },
    { "code":"Z519", "province":"EE", "name":"TURKS", },
    { "code":"Z520", "province":"EE", "name":"ISOLE VERGINI", },
    { "code":"Z522", "province":"EE", "name":"BARBADOS", },
    { "code":"Z523", "province":"EE", "name":"ANTILLE BRITANNICHE", },
    { "code":"Z524", "province":"EE", "name":"GRENADA", },
    { "code":"Z525", "province":"EE", "name":"ISOLE VERGINI BRITANNICHE ", },
    { "code":"Z526", "province":"EE", "name":"DOMINICA", },
    { "code":"Z527", "province":"EE", "name":"SAINT LUCIA", },
    { "code":"Z528", "province":"EE", "name":"SAINT VINCENT E GRENADINE", },
    { "code":"Z529", "province":"EE", "name":"ISOLA ANGUILLA", },
    { "code":"Z530", "province":"EE", "name":"ISOLE CAYMAN", },
    { "code":"Z531", "province":"EE", "name":"MONTSERRAT", },
    { "code":"Z532", "province":"EE", "name":"ANTIGUE E BARBUDA", },
    { "code":"Z533", "province":"EE", "name":"SAINT KITTS E NEVIS", },
    { "code":"Z600", "province":"EE", "name":"ARGENTINA", },
    { "code":"Z601", "province":"EE", "name":"BOLIVIA", },
    { "code":"Z602", "province":"EE", "name":"BRASILE", },
    { "code":"Z603", "province":"EE", "name":"CILE", },
    { "code":"Z604", "province":"EE", "name":"COLOMBIA", },
    { "code":"Z605", "province":"EE", "name":"ECUADOR", },
    { "code":"Z606", "province":"EE", "name":"REPUBBLICA DELLA GUAYANA", },
    { "code":"Z607", "province":"EE", "name":"GUAYANA FRANCESE", },
    { "code":"Z608", "province":"EE", "name":"SURINAME", },
    { "code":"Z609", "province":"EE", "name":"MALVINE", },
    { "code":"Z610", "province":"EE", "name":"PARAGUAY", },
    { "code":"Z611", "province":"EE", "name":"PERU", },
    { "code":"Z612", "province":"EE", "name":"TRINIDAD E TOBAGO", },
    { "code":"Z613", "province":"EE", "name":"URUGUAY", },
    { "code":"Z614", "province":"EE", "name":"VENEZUELA", },
    { "code":"Z700", "province":"EE", "name":"AUSTRALIA", },
    { "code":"Z701", "province":"EE", "name":"CAROLINE", },
    { "code":"Z702", "province":"EE", "name":"CHRISTMAS", },
    { "code":"Z703", "province":"EE", "name":"COOK", },
    { "code":"Z704", "province":"EE", "name":"FIGI O VITI", },
    { "code":"Z705", "province":"EE", "name":"ELLICE", },
    { "code":"Z706", "province":"EE", "name":"GUAM", },
    { "code":"Z707", "province":"EE", "name":"IRIAN OCCIDENTALE", },
    { "code":"Z708", "province":"EE", "name":"MACQUARIE", },
    { "code":"Z709", "province":"EE", "name":"MARCUS", },
    { "code":"Z710", "province":"EE", "name":"MARIANNE", },
    { "code":"Z711", "province":"EE", "name":"MARSHALL", },
    { "code":"Z712", "province":"EE", "name":"MIDWAY", },
    { "code":"Z713", "province":"EE", "name":"NAURU", },
    { "code":"Z714", "province":"EE", "name":"SAVAGE", },
    { "code":"Z715", "province":"EE", "name":"NORFOLK", },
    { "code":"Z716", "province":"EE", "name":"NUOVA CALEDONIA", },
    { "code":"Z717", "province":"EE", "name":"NUOVE EBRIDI", },
    { "code":"Z718", "province":"EE", "name":"NUOVA GUINEA", },
    { "code":"Z719", "province":"EE", "name":"NUOVA ZELANDA", },
    { "code":"Z720", "province":"EE", "name":"PAPUASIA", },
    { "code":"Z721", "province":"EE", "name":"PASQUA", },
    { "code":"Z722", "province":"EE", "name":"PITCAIRN", },
    { "code":"Z723", "province":"EE", "name":"POLINESIA", },
    { "code":"Z724", "province":"EE", "name":"SALOMONE", },
    { "code":"Z725", "province":"EE", "name":"SAMOA AMERICANE", },
    { "code":"Z726", "province":"EE", "name":"SAMOA OCCIDENTALI", },
    { "code":"Z727", "province":"EE", "name":"TOKELAU", },
    { "code":"Z728", "province":"EE", "name":"TONGA O DEGLI AMICI", },
    { "code":"Z729", "province":"EE", "name":"WALLIS", },
    { "code":"Z730", "province":"EE", "name":"PAPUA NUOVA GUINEA", },
    { "code":"Z731", "province":"EE", "name":"KIRIBATI", },
    { "code":"Z732", "province":"EE", "name":"TUVALU", },
    { "code":"Z733", "province":"EE", "name":"VANUATU", },
    { "code":"Z734", "province":"EE", "name":"PALAU REPUBBLICA", },
    { "code":"Z735", "province":"EE", "name":"MICRONESIA STATI FEDERALI / MICRONESIA", },
    { "code":"Z800", "province":"EE", "name":"DIPENDENZE CANADESI", },
    { "code":"Z801", "province":"EE", "name":"DIPENDENZE NORVEGESI", },
    { "code":"Z802", "province":"EE", "name":"DIPENDENZE SOVIETICHE", },
    { "code":"Z900", "province":"EE", "name":"DIPENDENZE AUSTRALIANE", },
    { "code":"Z901", "province":"EE", "name":"DIPENDENZE BRITANNICHE", },
    { "code":"Z902", "province":"EE", "name":"DIPENDENZE FRANCESI", },
    { "code":"Z903", "province":"EE", "name":"DIPENDENZE NEOZELANDESI", },
    { "code":"Z905", "province":"EE", "name":"DIPENDENZE NORVEGESI", },
    { "code":"Z906", "province":"EE", "name":"DIPENDENZE SUDAFRICANE", },
    # { "code":"Z999", "province":"EE", "name":"APOLIDE", },
]
