# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ GENERAL IMPORTS
# └─────────────────────────────────────────────────────────────────────────────────────

from __future__ import annotations

from typing import TYPE_CHECKING

# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ PROJECT IMPORTS
# └─────────────────────────────────────────────────────────────────────────────────────

if TYPE_CHECKING:
    from core.enums import HTTPMethod


# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ API REQUEST
# └─────────────────────────────────────────────────────────────────────────────────────


class APIRequest:
    """A utility class that represents API requests"""

    # ┌─────────────────────────────────────────────────────────────────────────────────
    # │ CLASS ATTRIBUTES
    # └─────────────────────────────────────────────────────────────────────────────────

    # Declare type of URL
    url: str

    # Declare type of method
    method: HTTPMethod

    # ┌─────────────────────────────────────────────────────────────────────────────────
    # │ __INIT__
    # └─────────────────────────────────────────────────────────────────────────────────

    def __init__(self, url: str, method: HTTPMethod) -> None:
        """Init Method"""

        # Set URL
        self.url = url

        # Set method
        self.method = method
