# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ GENERAL IMPORTS
# └─────────────────────────────────────────────────────────────────────────────────────

from __future__ import annotations

from typing import TYPE_CHECKING

# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ PROJECT IMPORTS
# └─────────────────────────────────────────────────────────────────────────────────────

if TYPE_CHECKING:
    from core.client.enums.http_method import HTTPMethod
    from core.client.types import HTTPMethodLiteral


# ┌─────────────────────────────────────────────────────────────────────────────────────
# │ INVALID HTTP METHOD ERROR
# └─────────────────────────────────────────────────────────────────────────────────────


class InvalidHTTPMethodError(Exception):
    """Raised when an invalid HTTP method is detected"""

    # ┌─────────────────────────────────────────────────────────────────────────────────
    # │ __INIT__
    # └─────────────────────────────────────────────────────────────────────────────────

    def __init__(self, method: HTTPMethod | HTTPMethodLiteral) -> None:
        """Init Method"""

        # Initialize the exception
        super().__init__(f"Invalid HTTP method: {method}")

        # Set the method
        self.method = method
