# Python Cowsay

A rewrite of cowsay in python. Allows for parsing of existing `.cow` files.

## Install

    pip install python-cowsay

## Usage

The classic cowsay can be generated by the `cowsay` or `cowthink` functions:

```python
from cowsay import cowsay

message = """
The most remarkable thing about my mother is that for thirty years she served
the family nothing but leftovers.  The original meal has never been found.
		-- Calvin Trillin
"""
print(cowsay(message))
```

Will yield:

```
 __________________________________________ 
/  The most remarkable thing about my      \
| mother is that for thirty years she      |
| served the family nothing but leftovers. |
| The original meal has never been found.  |
|                                          |
\ -- Calvin Trillin                        /
 ------------------------------------------ 
        \   ^__^
         \  (oo)\_______
            (__)\       )\/\
                ||----w |
                ||     ||
```

The arguments for these functions are:
- `message` – a string to wrap in the text bubble
- `cow='default'` – the name of the cow (valid names from `list_cows`)
- `preset=None` – the original cowsay presets: `-bggpstwy`
- `eyes=Option.eyes` – A custom eye string
- `tongue=Option.tongue` – A custom tongue string
- `width=40` – The width of the text bubble 
- `wrap_text=True` – Whether text should be wrapped in the bubble
- `cowfile=None` – A custom string representing a cow

### Other Functions

The available builtin cows can be found with `list_cows`. A cow can be chosen
randomly from this list with `get_random_cow`.

A custom `.cow` file can be parsed using the `read_dot_cow` function which takes
a `TextIO` stream.
