from enum import Enum
from typing import Any, Callable, Optional, Union


class Network(Enum): ...


class PacketType(Enum): ...


class InfoType(Enum): ...


class ReplyTag(Enum): ...


class AcarsMessage:
    def __init__(self, from_station: str, msg_type: PacketType, message: str): ...

    @property
    def hash(self) -> str: ...

    def __str__(self) -> str: ...

    def __repr__(self) -> str: ...


class CPDLCMessage(AcarsMessage):
    def __init__(self, from_station: str, msg_type: PacketType, message: str): ...

    @property
    def request_for_reply(self) -> bool: ...

    @property
    def no_reply(self) -> bool: ...

    def reply_message(self, status: bool) -> str: ...

    def __str__(self) -> str: ...


class CPDLC:
    def __init__(self, email: str,
                 login_code: str,
                 acars_url: str = "http://www.hoppie.nl/acars/system", *,
                 cpdlc_connect_callback: Optional[Callable[[], None]] = ...,
                 cpdlc_atc_info_update_callback: Optional[Callable[[], None]] = ...,
                 cpdlc_disconnect_callback: Optional[Callable[[], None]] = ...):
        ...

    def message_receiver_callback(self) -> Callable[[Any], None]: ...

    def add_message_receiver_callback(self, callback: Callable[[AcarsMessage], None]) -> None: ...

    def call_message_receiver_callback(self, message: AcarsMessage) -> None: ...

    def message_sender_callback(self) -> Callable[[Any], None]: ...

    def add_message_sender_callback(self, callback: Callable[[str, str], None]) -> None: ...

    def call_message_sender_callback(self, to: str, message: str) -> None: ...

    def start_poller(self): ...

    async def stop_poller(self): ...

    def _cpdlc_logout(self): ...

    def handle_message(self, message: Union[AcarsMessage]): ...

    def poll_message(self): ...

    def get_network(self) -> Network: ...

    def change_network(self, new_network: Network): ...

    def set_callsign(self, callsign: str): ...

    def ping_station(self, station_callsign: str = ...) -> bool:

    def query_info(self, info_type: InfoType, icao: str) -> AcarsMessage: ...

    def send_telex_message(self, target_station: str, message: str) -> bool: ...

    def departure_clearance_delivery(self, target_station: str, aircraft_type: str, dest_airport: str, dep_airport: str,
                                     stand: str, atis_letter: str) -> bool:
        ...

    def reply_cpdlc_message(self, message: CPDLCMessage, status: bool) -> bool: ...

    def cpdlc_login(self, target_station: str) -> bool: ...

    def cpdlc_logout(self) -> bool: ...
