# python-cq

[![CI](https://github.com/100nm/python-cq/actions/workflows/ci.yml/badge.svg)](https://github.com/100nm/python-cq)
[![PyPI - Version](https://img.shields.io/pypi/v/python-cq.svg?color=blue)](https://pypi.org/project/python-cq)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/python-cq.svg?color=blue)](https://pypistats.org/packages/python-cq)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)

Lightweight library for separating Python code according to **Command and Query Responsibility Segregation** principles.

Dependency injection is handled by [python-injection](https://github.com/100nm/python-injection).

Easy to use with [FastAPI](https://github.com/fastapi/fastapi).

## Installation

⚠️ _Requires Python 3.12 or higher_

```bash
pip install python-cq
```

## Resources

* [**Writing Application Layer**](https://github.com/100nm/python-cq/tree/prod/documentation/writing-application-layer.md)
* [**Pipeline**](https://github.com/100nm/python-cq/tree/prod/documentation/pipeline.md)
* [**FastAPI Example**](https://github.com/100nm/python-cq/tree/prod/documentation/fastapi-example.md)
