# coding: utf-8

"""
    Crunchbase Enterprise API

    Crunchbase Enterprise API, 2021-07-16  # noqa: E501

    OpenAPI spec version: 1.0.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class EntityApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def entities_acquisitions_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Acquisition's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_acquisitions_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: AcquisitionEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_acquisitions_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_acquisitions_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_acquisitions_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Acquisition's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_acquisitions_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: AcquisitionEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_acquisitions_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_acquisitions_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_acquisitions_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/acquisitions/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcquisitionEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_acquisitions_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Acquisition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_acquisitions_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Acquisition: [acquiree_organization, acquirer_organization, fields, press_references] 
        :return: AcquisitionEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_acquisitions_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_acquisitions_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_acquisitions_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Acquisition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_acquisitions_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Acquisition: [acquiree_organization, acquirer_organization, fields, press_references] 
        :return: AcquisitionEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_acquisitions_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_acquisitions_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/acquisitions/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcquisitionEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_addresses_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Address's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_addresses_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: AddressEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_addresses_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_addresses_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_addresses_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Address's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_addresses_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: AddressEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_addresses_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_addresses_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_addresses_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/addresses/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_addresses_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_addresses_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Address: [event, fields, organization] 
        :return: AddressEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_addresses_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_addresses_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_addresses_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_addresses_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Address: [event, fields, organization] 
        :return: AddressEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_addresses_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_addresses_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/addresses/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_categories_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Category's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_categories_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: CategoryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_categories_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_categories_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_categories_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Category's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_categories_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: CategoryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_categories_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_categories_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_categories_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/categories/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_categories_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_categories_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Category: [fields] 
        :return: CategoryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_categories_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_categories_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_categories_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_categories_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Category: [fields] 
        :return: CategoryEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_categories_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_categories_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/categories/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_category_groups_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Category Group's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_category_groups_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: CategoryGroupEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_category_groups_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_category_groups_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_category_groups_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Category Group's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_category_groups_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: CategoryGroupEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_category_groups_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_category_groups_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_category_groups_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/category_groups/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryGroupEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_category_groups_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Category Group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_category_groups_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Category Group: [fields] 
        :return: CategoryGroupEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_category_groups_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_category_groups_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_category_groups_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Category Group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_category_groups_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Category Group: [fields] 
        :return: CategoryGroupEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_category_groups_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_category_groups_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/category_groups/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryGroupEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_degrees_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Degree's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_degrees_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: DegreeEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_degrees_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_degrees_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_degrees_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Degree's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_degrees_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: DegreeEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_degrees_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_degrees_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_degrees_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/degrees/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DegreeEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_degrees_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Degree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_degrees_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Degree: [fields, organization, person] 
        :return: DegreeEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_degrees_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_degrees_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_degrees_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Degree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_degrees_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Degree: [fields, organization, person] 
        :return: DegreeEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_degrees_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_degrees_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/degrees/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DegreeEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_event_appearances_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Event Appearance's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_event_appearances_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: EventAppearanceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_event_appearances_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_event_appearances_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_event_appearances_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Event Appearance's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_event_appearances_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: EventAppearanceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_event_appearances_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_event_appearances_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_event_appearances_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/event_appearances/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventAppearanceEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_event_appearances_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Event Appearance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_event_appearances_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Event Appearance: [event, fields, participant] 
        :return: EventAppearanceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_event_appearances_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_event_appearances_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_event_appearances_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Event Appearance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_event_appearances_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Event Appearance: [event, fields, participant] 
        :return: EventAppearanceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_event_appearances_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_event_appearances_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/event_appearances/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventAppearanceEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_events_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Event's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_events_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: EventEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_events_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_events_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_events_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Event's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_events_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: EventEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_events_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_events_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_events_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/events/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_events_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Event  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_events_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Event: [address, appearances, contestants, exhibitors, fields, organizers, press_references, speakers, sponsors] 
        :return: EventEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_events_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_events_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_events_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Event  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_events_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Event: [address, appearances, contestants, exhibitors, fields, organizers, press_references, speakers, sponsors] 
        :return: EventEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_events_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_events_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/events/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_funding_rounds_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Funding Round's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funding_rounds_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: FundingRoundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_funding_rounds_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_funding_rounds_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_funding_rounds_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Funding Round's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funding_rounds_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: FundingRoundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_funding_rounds_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_funding_rounds_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_funding_rounds_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/funding_rounds/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundingRoundEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_funding_rounds_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Funding Round  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funding_rounds_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Funding Round: [fields, investments, investors, lead_investors, organization, partners, press_references] 
        :return: FundingRoundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_funding_rounds_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_funding_rounds_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_funding_rounds_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Funding Round  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funding_rounds_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Funding Round: [fields, investments, investors, lead_investors, organization, partners, press_references] 
        :return: FundingRoundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_funding_rounds_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_funding_rounds_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/funding_rounds/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundingRoundEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_funds_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Fund's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funds_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: FundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_funds_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_funds_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_funds_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Fund's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funds_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: FundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_funds_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_funds_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_funds_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/funds/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_funds_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Fund  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funds_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Fund: [fields, investors, owner, press_references] 
        :return: FundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_funds_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_funds_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_funds_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Fund  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_funds_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Fund: [fields, investors, owner, press_references] 
        :return: FundEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_funds_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_funds_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/funds/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_investments_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Investment's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_investments_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: InvestmentEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_investments_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_investments_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_investments_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Investment's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_investments_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: InvestmentEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_investments_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_investments_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_investments_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/investments/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestmentEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_investments_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Investment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_investments_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Investment: [fields, funding_round, investor, organization, partner] 
        :return: InvestmentEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_investments_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_investments_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_investments_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Investment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_investments_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Investment: [fields, funding_round, investor, organization, partner] 
        :return: InvestmentEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_investments_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_investments_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/investments/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestmentEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_ipos_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Ipo's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ipos_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: IpoEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_ipos_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_ipos_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_ipos_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Ipo's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ipos_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: IpoEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_ipos_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_ipos_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_ipos_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/ipos/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpoEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_ipos_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Ipo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ipos_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Ipo: [fields, organization, press_references] 
        :return: IpoEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_ipos_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_ipos_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_ipos_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Ipo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ipos_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Ipo: [fields, organization, press_references] 
        :return: IpoEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_ipos_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_ipos_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/ipos/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpoEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_jobs_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Job's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_jobs_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: JobEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_jobs_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_jobs_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_jobs_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Job's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_jobs_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: JobEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_jobs_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_jobs_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_jobs_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/jobs/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_jobs_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_jobs_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Job: [fields, organization, person] 
        :return: JobEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_jobs_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_jobs_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_jobs_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_jobs_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Job: [fields, organization, person] 
        :return: JobEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_jobs_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_jobs_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/jobs/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_locations_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Location's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_locations_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: LocationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_locations_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_locations_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_locations_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Location's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_locations_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: LocationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_locations_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_locations_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_locations_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/locations/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_locations_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Location  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_locations_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Location: [fields] 
        :return: LocationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_locations_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_locations_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_locations_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Location  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_locations_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Location: [fields] 
        :return: LocationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_locations_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_locations_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/locations/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_organizations_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Organization's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_organizations_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: OrganizationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_organizations_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_organizations_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_organizations_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Organization's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_organizations_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: OrganizationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_organizations_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_organizations_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_organizations_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/organizations/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_organizations_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_organizations_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Organization: [acquiree_acquisitions, acquirer_acquisitions, child_organizations, child_ownerships, event_appearances, fields, founders, headquarters_address, investors, ipos, jobs, key_employee_changes, layoffs, parent_organization, parent_ownership, participated_funding_rounds, participated_funds, participated_investments, press_references, raised_funding_rounds, raised_funds, raised_investments] 
        :return: OrganizationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_organizations_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_organizations_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_organizations_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_organizations_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Organization: [acquiree_acquisitions, acquirer_acquisitions, child_organizations, child_ownerships, event_appearances, fields, founders, headquarters_address, investors, ipos, jobs, key_employee_changes, layoffs, parent_organization, parent_ownership, participated_funding_rounds, participated_funds, participated_investments, press_references, raised_funding_rounds, raised_funds, raised_investments] 
        :return: OrganizationEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_organizations_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_organizations_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/organizations/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_ownerships_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Ownership's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ownerships_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: OwnershipEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_ownerships_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_ownerships_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_ownerships_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Ownership's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ownerships_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: OwnershipEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_ownerships_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_ownerships_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_ownerships_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/ownerships/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OwnershipEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_ownerships_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Ownership  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ownerships_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Ownership: [child_organization, fields, parent_organization, press_references] 
        :return: OwnershipEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_ownerships_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_ownerships_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_ownerships_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup an Ownership  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_ownerships_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Ownership: [child_organization, fields, parent_organization, press_references] 
        :return: OwnershipEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_ownerships_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_ownerships_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/ownerships/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OwnershipEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_people_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Person's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_people_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: PersonEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_people_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_people_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_people_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Person's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_people_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: PersonEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_people_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_people_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_people_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/people/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_people_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_people_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Person: [degrees, event_appearances, fields, founded_organizations, jobs, participated_funding_rounds, participated_funds, participated_investments, partner_funding_rounds, partner_investments, press_references, primary_job, primary_organization] 
        :return: PersonEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_people_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_people_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_people_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_people_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Person: [degrees, event_appearances, fields, founded_organizations, jobs, participated_funding_rounds, participated_funds, participated_investments, partner_funding_rounds, partner_investments, press_references, primary_job, primary_organization] 
        :return: PersonEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_people_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_people_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/people/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_press_references_entity_id_cards_card_id_get(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Press Reference's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_press_references_entity_id_cards_card_id_get(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: PressReferenceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_press_references_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_press_references_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, **kwargs)  # noqa: E501
            return data

    def entities_press_references_entity_id_cards_card_id_get_with_http_info(self, entity_id, card_id, **kwargs):  # noqa: E501
        """Lookup Press Reference's single card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_press_references_entity_id_cards_card_id_get_with_http_info(entity_id, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str card_id: A card to include on the resulting entity (required)
        :param str card_field_ids: Card fields to include on the specified card - array of field_id strings in JSON encoded as string
        :param str after_id: Lookup uuid of the last item in the previous page (not required for first page). Used to iterate a card's results starting at the beginning of the ordered set and moving forward. Suitable for implementing \"next page\" functionality. May not be provided simultaneously with before_id. 
        :param str before_id: Lookup uuid of the first item in the previous page (not required for first page). Used to iterate a card's results starting at the end of the ordered set and moving backward. Suitable for implementing \"previous page\" functionality. May not be provided simultaneously with after_id. 
        :param str order: Field name with order direction (asc/desc)
        :param int limit: Number of rows to return. Default is 100, min is 1, max is 100.
        :return: PressReferenceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'card_id', 'card_field_ids', 'after_id', 'before_id', 'order', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_press_references_entity_id_cards_card_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_press_references_entity_id_cards_card_id_get`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `entities_press_references_entity_id_cards_card_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'card_field_ids' in params:
            query_params.append(('card_field_ids', params['card_field_ids']))  # noqa: E501
        if 'after_id' in params:
            query_params.append(('after_id', params['after_id']))  # noqa: E501
        if 'before_id' in params:
            query_params.append(('before_id', params['before_id']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/press_references/{entity_id}/cards/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PressReferenceEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entities_press_references_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Press Reference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_press_references_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Press Reference: [fields] 
        :return: PressReferenceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entities_press_references_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.entities_press_references_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def entities_press_references_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Lookup a Press Reference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entities_press_references_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_id: UUID or permalink of desired entity (required)
        :param str field_ids: Fields to include on the resulting entity - either an array of field_id strings in JSON or a comma-separated list encoded as string
        :param str card_ids: Cards to include on the resulting entity - array of card_id strings in JSON encoded as string\\\\ Card Ids for Press Reference: [fields] 
        :return: PressReferenceEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'field_ids', 'card_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entities_press_references_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `entities_press_references_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entity_id'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'field_ids' in params:
            query_params.append(('field_ids', params['field_ids']))  # noqa: E501
        if 'card_ids' in params:
            query_params.append(('card_ids', params['card_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuthHeader']  # noqa: E501

        return self.api_client.call_api(
            '/entities/press_references/{entity_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PressReferenceEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
