from typing import TypeVar, Any, Protocol, runtime_checkable

DataT = TypeVar("DataT")
ReturnT = TypeVar("ReturnT")


class MutationCallbackProtocol(Protocol[ReturnT]):
    def __call__(self, name: str, data: ReturnT, context: dict[str, Any]) -> None: ...


@runtime_checkable
class MutationProtocol(Protocol[DataT, ReturnT]):
    name: str
    context: dict[str, Any]

    def mutate(self, **kwargs: Any) -> ReturnT: ...
    def subscribe(self, callback: MutationCallbackProtocol) -> None: ...
    def unsubscribe(self, callback: MutationCallbackProtocol) -> None: ...
    def dumps(self, formatter: 'MutationFormatterProtocol' = ...) -> Any: ...
    def loads(self, data: Any, formatter: 'MutationFormatterProtocol' = ...) -> Any: ...
    def __call__(self, **kwargs: Any) -> ReturnT: ...
    def __str__(self) -> str: ...
