"""This module contains a list of all available devices that can be used with playwright."""

PLAYWRIGHT_DEVICES = {
    "Blackberry PlayBook": {
        "user_agent": "Mozilla/5.0 (PlayBook; U; RIM Tablet OS 2.1.0; en-US) AppleWebKit/536.2+ (KHTML like Gecko) Version/18.0 Safari/536.2+",
        "viewport": {"width": 600, "height": 1024},
        "device_scale_factor": 1,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Blackberry PlayBook landscape": {
        "user_agent": "Mozilla/5.0 (PlayBook; U; RIM Tablet OS 2.1.0; en-US) AppleWebKit/536.2+ (KHTML like Gecko) Version/18.0 Safari/536.2+",
        "viewport": {"width": 1024, "height": 600},
        "device_scale_factor": 1,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "BlackBerry Z30": {
        "user_agent": "Mozilla/5.0 (BB10; Touch) AppleWebKit/537.10+ (KHTML, like Gecko) Version/18.0 Mobile Safari/537.10+",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "BlackBerry Z30 landscape": {
        "user_agent": "Mozilla/5.0 (BB10; Touch) AppleWebKit/537.10+ (KHTML, like Gecko) Version/18.0 Mobile Safari/537.10+",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy Note 3": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/18.0 Mobile Safari/534.30",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy Note 3 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/18.0 Mobile Safari/534.30",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy Note II": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/18.0 Mobile Safari/534.30",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy Note II landscape": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/18.0 Mobile Safari/534.30",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy S III": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.0; en-us; GT-I9300 Build/IMM76D) AppleWebKit/534.30 (KHTML, like Gecko) Version/18.0 Mobile Safari/534.30",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy S III landscape": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.0; en-us; GT-I9300 Build/IMM76D) AppleWebKit/534.30 (KHTML, like Gecko) Version/18.0 Mobile Safari/534.30",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Galaxy S5": {
        "user_agent": "Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy S5 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy S8": {
        "user_agent": "Mozilla/5.0 (Linux; Android 7.0; SM-G950U Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 360, "height": 740},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy S8 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 7.0; SM-G950U Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 740, "height": 360},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy S9+": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; SM-G965U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 320, "height": 658},
        "device_scale_factor": 4.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy S9+ landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; SM-G965U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 658, "height": 320},
        "device_scale_factor": 4.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy Tab S4": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.1.0; SM-T837A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 712, "height": 1138},
        "device_scale_factor": 2.25,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Galaxy Tab S4 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.1.0; SM-T837A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 1138, "height": 712},
        "device_scale_factor": 2.25,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "iPad (gen 5)": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 768, "height": 1024},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad (gen 5) landscape": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 1024, "height": 768},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad (gen 6)": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 768, "height": 1024},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad (gen 6) landscape": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 1024, "height": 768},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad (gen 7)": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 810, "height": 1080},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad (gen 7) landscape": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 1080, "height": 810},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad Mini": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 768, "height": 1024},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad Mini landscape": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 1024, "height": 768},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad Pro 11": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 834, "height": 1194},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPad Pro 11 landscape": {
        "user_agent": "Mozilla/5.0 (iPad; CPU OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 1194, "height": 834},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 6": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 375, "height": 667},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 6 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 667, "height": 375},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 6 Plus": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 414, "height": 736},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 6 Plus landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 736, "height": 414},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 7": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 375, "height": 667},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 7 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 667, "height": 375},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 7 Plus": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 414, "height": 736},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 7 Plus landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 736, "height": 414},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 8": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 375, "height": 667},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 8 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 667, "height": 375},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 8 Plus": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 414, "height": 736},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 8 Plus landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 736, "height": 414},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone SE": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/18.0 Mobile/14E304 Safari/602.1",
        "viewport": {"width": 320, "height": 568},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone SE landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/18.0 Mobile/14E304 Safari/602.1",
        "viewport": {"width": 568, "height": 320},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone X": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 375, "height": 812},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone X landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/18.0 Mobile/15A372 Safari/604.1",
        "viewport": {"width": 812, "height": 375},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone XR": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 414, "height": 896},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone XR landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 896, "height": 414},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 11": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 414, "height": 715},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 11 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 800, "height": 364},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 11 Pro": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 375, "height": 635},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 11 Pro landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 724, "height": 325},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 11 Pro Max": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 414, "height": 715},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 11 Pro Max landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 12_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 808, "height": 364},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 390, "height": 664},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 750, "height": 340},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 Pro": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 390, "height": 664},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 Pro landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 750, "height": 340},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 Pro Max": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 428, "height": 746},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 Pro Max landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 832, "height": 378},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 Mini": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 375, "height": 629},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 12 Mini landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 14_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 712, "height": 325},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 390, "height": 664},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 750, "height": 342},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 Pro": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 390, "height": 664},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 Pro landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 750, "height": 342},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 Pro Max": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 428, "height": 746},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 Pro Max landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 832, "height": 380},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 Mini": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 375, "height": 629},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 13 Mini landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 15_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 712, "height": 327},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 390, "height": 664},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 750, "height": 340},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 Plus": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 428, "height": 746},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 Plus landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 832, "height": 378},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 Pro": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 393, "height": 660},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 Pro landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 734, "height": 343},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 Pro Max": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 430, "height": 740},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 14 Pro Max landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 814, "height": 380},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 393, "height": 659},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 734, "height": 343},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 Plus": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 430, "height": 739},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 Plus landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 814, "height": 380},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 Pro": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 393, "height": 659},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 Pro landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 734, "height": 343},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 Pro Max": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 430, "height": 739},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "iPhone 15 Pro Max landscape": {
        "user_agent": "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Mobile/15E148 Safari/604.1",
        "viewport": {"width": 814, "height": 380},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Kindle Fire HDX": {
        "user_agent": "Mozilla/5.0 (Linux; U; en-us; KFAPWI Build/JDQ39) AppleWebKit/535.19 (KHTML, like Gecko) Silk/3.13 Safari/535.19 Silk-Accelerated=true",
        "viewport": {"width": 800, "height": 1280},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Kindle Fire HDX landscape": {
        "user_agent": "Mozilla/5.0 (Linux; U; en-us; KFAPWI Build/JDQ39) AppleWebKit/535.19 (KHTML, like Gecko) Silk/3.13 Safari/535.19 Silk-Accelerated=true",
        "viewport": {"width": 1280, "height": 800},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "LG Optimus L70": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.4.2; en-us; LGMS323 Build/KOT49I.MS32310c) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 384, "height": 640},
        "device_scale_factor": 1.25,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "LG Optimus L70 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; U; Android 4.4.2; en-us; LGMS323 Build/KOT49I.MS32310c) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 640, "height": 384},
        "device_scale_factor": 1.25,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Microsoft Lumia 550": {
        "user_agent": "Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 550) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36 Edge/14.14263",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Microsoft Lumia 550 landscape": {
        "user_agent": "Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 550) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36 Edge/14.14263",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Microsoft Lumia 950": {
        "user_agent": "Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 950) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36 Edge/14.14263",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 4,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Microsoft Lumia 950 landscape": {
        "user_agent": "Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 950) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36 Edge/14.14263",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 4,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 10": {
        "user_agent": "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 10 Build/MOB31T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 800, "height": 1280},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 10 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 10 Build/MOB31T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 1280, "height": 800},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 4": {
        "user_agent": "Mozilla/5.0 (Linux; Android 4.4.2; Nexus 4 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 384, "height": 640},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 4 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 4.4.2; Nexus 4 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 640, "height": 384},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 5": {
        "user_agent": "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 5 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 5X": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; Nexus 5X Build/OPR4.170623.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 412, "height": 732},
        "device_scale_factor": 2.625,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 5X landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; Nexus 5X Build/OPR4.170623.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 732, "height": 412},
        "device_scale_factor": 2.625,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 6": {
        "user_agent": "Mozilla/5.0 (Linux; Android 7.1.1; Nexus 6 Build/N6F26U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 412, "height": 732},
        "device_scale_factor": 3.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 6 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 7.1.1; Nexus 6 Build/N6F26U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 732, "height": 412},
        "device_scale_factor": 3.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 6P": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; Nexus 6P Build/OPP3.170518.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 412, "height": 732},
        "device_scale_factor": 3.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 6P landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; Nexus 6P Build/OPP3.170518.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 732, "height": 412},
        "device_scale_factor": 3.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 7": {
        "user_agent": "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 7 Build/MOB30X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 600, "height": 960},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nexus 7 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 7 Build/MOB30X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 960, "height": 600},
        "device_scale_factor": 2,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nokia Lumia 520": {
        "user_agent": "Mozilla/5.0 (compatible; MSIE 10.0; Windows Phone 8.0; Trident/6.0; IEMobile/10.0; ARM; Touch; NOKIA; Lumia 520)",
        "viewport": {"width": 320, "height": 533},
        "device_scale_factor": 1.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nokia Lumia 520 landscape": {
        "user_agent": "Mozilla/5.0 (compatible; MSIE 10.0; Windows Phone 8.0; Trident/6.0; IEMobile/10.0; ARM; Touch; NOKIA; Lumia 520)",
        "viewport": {"width": 533, "height": 320},
        "device_scale_factor": 1.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Nokia N9": {
        "user_agent": "Mozilla/5.0 (MeeGo; NokiaN9) AppleWebKit/534.13 (KHTML, like Gecko) NokiaBrowser/8.5.0 Mobile Safari/534.13",
        "viewport": {"width": 480, "height": 854},
        "device_scale_factor": 1,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Nokia N9 landscape": {
        "user_agent": "Mozilla/5.0 (MeeGo; NokiaN9) AppleWebKit/534.13 (KHTML, like Gecko) NokiaBrowser/8.5.0 Mobile Safari/534.13",
        "viewport": {"width": 854, "height": 480},
        "device_scale_factor": 1,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "webkit",
    },
    "Pixel 2": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0; Pixel 2 Build/OPD3.170816.012) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 411, "height": 731},
        "device_scale_factor": 2.625,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 2 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0; Pixel 2 Build/OPD3.170816.012) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 731, "height": 411},
        "device_scale_factor": 2.625,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 2 XL": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; Pixel 2 XL Build/OPD1.170816.004) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 411, "height": 823},
        "device_scale_factor": 3.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 2 XL landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 8.0.0; Pixel 2 XL Build/OPD1.170816.004) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 823, "height": 411},
        "device_scale_factor": 3.5,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 3": {
        "user_agent": "Mozilla/5.0 (Linux; Android 9; Pixel 3 Build/PQ1A.181105.017.A1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 393, "height": 786},
        "device_scale_factor": 2.75,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 3 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 9; Pixel 3 Build/PQ1A.181105.017.A1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 786, "height": 393},
        "device_scale_factor": 2.75,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 4": {
        "user_agent": "Mozilla/5.0 (Linux; Android 10; Pixel 4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 353, "height": 745},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 4 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 10; Pixel 4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 745, "height": 353},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 4a (5G)": {
        "user_agent": "Mozilla/5.0 (Linux; Android 11; Pixel 4a (5G)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 412, "height": 765},
        "device_scale_factor": 2.63,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 4a (5G) landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 11; Pixel 4a (5G)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 840, "height": 312},
        "device_scale_factor": 2.63,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 5": {
        "user_agent": "Mozilla/5.0 (Linux; Android 11; Pixel 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 393, "height": 727},
        "device_scale_factor": 2.75,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 5 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 11; Pixel 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 802, "height": 293},
        "device_scale_factor": 2.75,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 7": {
        "user_agent": "Mozilla/5.0 (Linux; Android 14; Pixel 7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 412, "height": 839},
        "device_scale_factor": 2.625,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Pixel 7 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 14; Pixel 7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 863, "height": 360},
        "device_scale_factor": 2.625,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Moto G4": {
        "user_agent": "Mozilla/5.0 (Linux; Android 7.0; Moto G (4)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 360, "height": 640},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Moto G4 landscape": {
        "user_agent": "Mozilla/5.0 (Linux; Android 7.0; Moto G (4)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Mobile Safari/537.36",
        "viewport": {"width": 640, "height": 360},
        "device_scale_factor": 3,
        "is_mobile": True,
        "has_touch": True,
        "default_browser_type": "chromium",
    },
    "Desktop Chrome HiDPI": {
        "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 2,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "chromium",
    },
    "Desktop Edge HiDPI": {
        "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36 Edg/130.0.6723.31",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 2,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "chromium",
    },
    "Desktop Firefox HiDPI": {
        "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 2,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "firefox",
    },
    "Desktop Safari": {
        "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.0 Safari/605.1.15",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 2,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "webkit",
    },
    "Desktop Chrome": {
        "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 1,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "chromium",
    },
    "Desktop Edge": {
        "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.6723.31 Safari/537.36 Edg/130.0.6723.31",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 1,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "chromium",
    },
    "Desktop Firefox": {
        "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0",
        "viewport": {"width": 1280, "height": 720},
        "device_scale_factor": 1,
        "is_mobile": False,
        "has_touch": False,
        "default_browser_type": "firefox",
    },
}
