# 文档目录

本目录包含项目的所有文档。

## 📚 文档列表

### 基础文档

| 文件 | 说明 |
|------|------|
| [01_README.md](01_README.md) | 📖 文档目录索引（本文件） |
| [01_release.md](01_release.md) | 🚀 发布指南 |
| [01_upload_instructions.md](01_upload_instructions.md) | 📤 上传说明 |
| [01_project_structure.md](01_project_structure.md) | 📂 项目结构说明 |
| [01_summary.md](01_summary.md) | 📝 项目总结 |

### 开发文档

| 文件 | 说明 |
|------|------|
| [02_local_development.md](02_local_development.md) | 💻 本地开发指南 |
| [02_naming_convention.md](02_naming_convention.md) | 📏 命名规范 |
| [02_print_dict_logging.md](02_print_dict_logging.md) | 📊 print_dict 日志功能 |
| [02_python_version_upgrade.md](02_python_version_upgrade.md) | 🐍 Python 版本要求 |
| [02_match_case_guide.md](02_match_case_guide.md) | 🔀 match-case 语法指南 |

### 技术文档

| 文件 | 说明 |
|------|------|
| [03_package_vs_module_name.md](03_package_vs_module_name.md) | 📦 包名与模块名详解 |
| [03_deploy_log_samples.md](03_deploy_log_samples.md) | 📋 部署日志示例 |

### 版本历史

| 文件 | 说明 |
|------|------|
| [04_rename_summary.md](04_rename_summary.md) | 🔄 v0.2.0 改名总结 (debug-tools) |
| [06_version_0.3.0.md](06_version_0.3.0.md) | 🆕 v0.3.0 版本说明 (debug-helpers) |
| [../CHANGELOG.md](../CHANGELOG.md) | 📅 版本更新日志（根目录） |

### 工具文档

| 文件 | 说明 |
|------|------|
| [07_makefile_guide.md](07_makefile_guide.md) | 🛠️ Makefile 使用指南 |

### GitHub Actions 文档

| 文件 | 说明 |
|------|------|
| [03_github_actions_explained.md](03_github_actions_explained.md) | 🤖 GitHub Actions 工作原理 |
| [04_pr_actions_timing.md](04_pr_actions_timing.md) | ⏱️ PR 触发机制详解 |
| [04_setup_pypi_tokens.md](04_setup_pypi_tokens.md) | 🔐 PyPI Token 配置指南 |

### Issue 记录

| 文件 | 说明 |
|------|------|
| [08_issue_name_conflict.md](08_issue_name_conflict.md) | ⚠️ PyPI 包名冲突 issue |
| [09_rename_to_debug_helpers.md](09_rename_to_debug_helpers.md) | 🔄 改名为 debug-helpers 指南 |
| [13_issue_github_actions_permissions.md](13_issue_github_actions_permissions.md) | 🔒 GitHub Actions 权限错误 |

---

## 🗂️ 文档分类

### 快速开始
1. **新用户**: 阅读根目录 [README.md](../README.md)
2. **安装使用**: [02_local_development.md](02_local_development.md)
3. **示例代码**: [../examples/readme.md](../examples/readme.md)

### 开发者
1. **发布流程**: [01_release.md](01_release.md)
2. **Makefile**: [07_makefile_guide.md](07_makefile_guide.md)
3. **包名说明**: [03_package_vs_module_name.md](03_package_vs_module_name.md)

### 维护者
1. **版本历史**: [../CHANGELOG.md](../CHANGELOG.md)
2. **Issue 记录**: [08_issue_name_conflict.md](08_issue_name_conflict.md)
3. **项目总结**: [01_summary.md](01_summary.md)

---

## 📖 文档编号规则

- `01_*` - 基础文档（README、发布、项目结构等）
- `02_*` - 开发文档（本地开发、命名规范、功能说明等）
- `03_*` - 技术文档（包名详解、部署日志等）
- `04_*` - 版本历史（改名总结等）
- `05_*` - （预留）
- `06_*` - 版本说明（新版本详细说明）
- `07_*` - 工具文档（Makefile、脚本等）
- `08_*` - Issue 记录（问题追踪）
- `09_*` - 改名指南（重命名相关）

---

## 🔍 快速查找

### 如何发布？
→ [01_release.md](01_release.md) 或 [07_makefile_guide.md](07_makefile_guide.md)

### 如何本地测试？
→ [02_local_development.md](02_local_development.md)

### 包名和模块名有什么区别？
→ [03_package_vs_module_name.md](03_package_vs_module_name.md)

### 为什么改名为 debug-helpers？
→ [08_issue_name_conflict.md](08_issue_name_conflict.md)

### Makefile 怎么用？
→ [07_makefile_guide.md](07_makefile_guide.md)

### 如何使用脚本发布？
→ [../scripts/README.md](../scripts/README.md)

---

## 📝 维护说明

### 添加新文档
1. 选择合适的编号前缀（01-09）
2. 使用小写字母和下划线命名
3. 在本 README 中添加索引

### 更新现有文档
1. 保持文件名不变
2. 更新修改日期
3. 如有重大变更，更新相关链接

### 更新 CHANGELOG.md
每次版本发布时：
1. 在文件顶部添加新版本
2. 使用清晰的分类（新增、改进、修复等）
3. 包含日期
4. 简洁描述每个变更

---

## 🌟 推荐阅读顺序

### 首次使用
1. [../README.md](../README.md) - 项目概述
2. [02_local_development.md](02_local_development.md) - 安装和测试
3. [../examples/readme.md](../examples/readme.md) - 运行示例

### 发布新版本
1. [01_release.md](01_release.md) - 发布流程
2. [07_makefile_guide.md](07_makefile_guide.md) - Makefile 命令
3. [01_upload_instructions.md](01_upload_instructions.md) - 上传说明
4. [../CHANGELOG.md](../CHANGELOG.md) - 更新版本日志

### 深入了解
1. [03_package_vs_module_name.md](03_package_vs_module_name.md) - 包名详解
2. [02_print_dict_logging.md](02_print_dict_logging.md) - 日志功能
3. [08_issue_name_conflict.md](08_issue_name_conflict.md) - 问题解决记录

---

## 🔗 相关资源

### 项目文档
- 主教程: [../../how_to_publish_to_pypi.md](../../how_to_publish_to_pypi.md)
- 项目 README: [../README.md](../README.md)
- Makefile 快速参考: [../MAKEFILE_README.md](../MAKEFILE_README.md)

### 外部资源
- TestPyPI: https://test.pypi.org/
- PyPI: https://pypi.org/
- 语义化版本规范: https://semver.org/lang/zh-CN/
- Python 打包指南: https://packaging.python.org/

---

## 🎯 文档使用指南

### 对于新手
1. 首先阅读项目根目录的 [README.md](../README.md)
2. 查看 [01_upload_instructions.md](01_upload_instructions.md) 了解上传流程
3. 参考主教程: [../../how_to_publish_to_pypi.md](../../how_to_publish_to_pypi.md)

### 对于维护者
1. 发布新版本前查看 [01_release.md](01_release.md)
2. 发布后更新 [../CHANGELOG.md](../CHANGELOG.md)
3. 使用 [../scripts/](../scripts/) 目录下的脚本或 Makefile 自动化发布

### 对于贡献者
1. 提交 PR 时在 [../CHANGELOG.md](../CHANGELOG.md) 中添加变更说明
2. 遵循版本号规范（语义化版本）
3. 确保所有测试通过
4. 遵循 [02_naming_convention.md](02_naming_convention.md) 的命名规范
